(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1200617,      22100]
NotebookOptionsPosition[   1194382,      21977]
NotebookOutlinePosition[   1195329,      22008]
CellTagsIndexPosition[   1195257,      22003]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Voigt & Pseudo-Voigt profiles", "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
   3.794473182921484*^9, 3.794473193906823*^9}, 3.797331640127709*^9, {
   3.797653041984359*^9, 3.797653047469375*^9}},
 CellTags->"Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.800596771824752*^9, 3.800597284202766*^9, 
  3.814004666591812*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"638de314-7056-49bd-af21-319f457c40a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"filePath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HomeDirectory", "[", "]"}], ",", "\"\<DeskTop\>\"", ",", 
       "\"\<Voigt_function.jpg\>\""}], "}"}], "]"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.794487949165287*^9, 3.7944879555406275`*^9}, {
  3.795686926938303*^9, 3.79568693015725*^9}, {3.7956871831566043`*^9, 
  3.795687184703747*^9}, {3.8134955442873125`*^9, 3.8134955519283504`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"7ee0b89d-b3e5-44a5-836e-8ce0856b95e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Get", "[", "\"\<Voigt_functions_general.m\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.817128916523795*^9, 3.817128924413577*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"c0c5201b-c383-4468-8299-2a63fa0088f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"FourierParameters", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.817129495125703*^9, 3.817130020129476*^9, 3.8171321855370483`*^9, 
   3.8171328825102763`*^9, 3.8171339216368856`*^9, 3.8171341130358796`*^9, 
   3.817134179945239*^9, 3.8171342445261045`*^9, 3.8171343488433547`*^9, 
   3.817135459169955*^9, 3.8171371321213355`*^9, 3.817186306758191*^9, 
   3.8171864805107546`*^9, 3.817191602455773*^9, {3.818844310836171*^9, 
   3.8188443336805277`*^9}, 3.820118102059575*^9, 3.8205888583737283`*^9, {
   3.820646651479824*^9, 3.8206466719945087`*^9}, 3.823586900833867*^9, 
   3.8242842300881844`*^9, 3.824295223466755*^9, {3.8242955190250626`*^9, 
   3.8242955426824317`*^9}, 3.824296005168621*^9, 3.8242979347827697`*^9, 
   3.8242983103418922`*^9, 3.8242985348493404`*^9, 3.8243009242956114`*^9, 
   3.824303269655434*^9, 3.8243066769713273`*^9, 3.8243076429309187`*^9, 
   3.8243550685538926`*^9, 3.8243576353806324`*^9, 3.8243631985257087`*^9, 
   3.824363644924199*^9, 3.8243818438315773`*^9, 3.8243824858441877`*^9, 
   3.8246398946259103`*^9, 3.8246401926482472`*^9, {3.8246403157767267`*^9, 
   3.824640324478941*^9}, 3.8246403900120296`*^9, 3.8246434274049635`*^9, 
   3.824960210164092*^9, 3.824960760284763*^9, 3.8254752938420744`*^9, 
   3.826859699886632*^9, 3.8278364998803463`*^9, 3.8278375423279934`*^9, 
   3.82791443913325*^9, 3.8279155169532533`*^9, 3.8279155550968113`*^9, 
   3.827916707871909*^9, 3.827916891544381*^9, 3.8279760070260687`*^9, 
   3.8279763264719353`*^9, {3.828089107116646*^9, 3.8280891219668303`*^9}, 
   3.82808917616614*^9, 3.8280892682436104`*^9, 3.8280911882580805`*^9, 
   3.828091811572022*^9, 3.828092858338757*^9, 3.828092912475094*^9, 
   3.8281057702126303`*^9, 3.828106039445986*^9, 3.82810615139604*^9, 
   3.8281553856910715`*^9, 3.828156020180326*^9, 3.8281600467133875`*^9, 
   3.828161190934456*^9, {3.828161299032609*^9, 3.828161322376166*^9}, 
   3.828161456898799*^9, 3.8281616497516437`*^9, 3.8281625789571047`*^9, 
   3.8281708409071045`*^9, 3.828171030520504*^9, {3.8281710621916*^9, 
   3.828171079966172*^9}, 3.828171266503962*^9, {3.8281717815583057`*^9, 
   3.8281718115525274`*^9}, 3.8281737240614367`*^9, 3.828502152340372*^9, 
   3.8285034806396017`*^9, 3.8285794477546186`*^9, 3.8285811358565493`*^9, 
   3.8285830516824093`*^9, 3.8285842413464975`*^9, 3.828591670934617*^9, 
   3.828592090684066*^9, 3.828593117650016*^9, 3.828593431688758*^9, 
   3.828593975970276*^9, 3.8298003580720754`*^9, 3.829800490439453*^9, 
   3.8298077118829947`*^9, 3.8298091873180556`*^9, 3.8299651329457197`*^9, 
   3.83058591450051*^9, 3.8305860055978203`*^9, {3.83058770542178*^9, 
   3.830587733088022*^9}, 3.830591920801369*^9, 3.830594799426155*^9, 
   3.8305950106831713`*^9, 3.8316164624181795`*^9, 3.8321437325823956`*^9, 
   3.8321449516817074`*^9, 3.832145063874386*^9, 3.832145173390447*^9, 
   3.8510481360736327`*^9, 3.851050170421983*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"dfae4c9e-8735-453e-803d-533bf4e0d1ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Comparison of Voigt  with Pseudo-Voigt \
distributions", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.8134997618789835`*^9}},
 CellTags->"Title",ExpressionUUID->"5117d418-0557-46f3-99f2-ee3b76580d7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "sigma", ",", " ", "delta", ",", " ", "mix", ",", "fwhm", ",", 
        "fwhmFT", ",", "x0", ",", " ", "dd0", ",", " ", "tt0", ",", " ", 
        "fwhmpos", ",", "\[IndentingNewLine]", "              ", "leftbound", 
        ",", "rightbound", ",", " ", "points", ",", " ", "stepw", ",", 
        "abscissae", ",", "middle", ",", "\[IndentingNewLine]", 
        "              ", "kernel1", ",", " ", "kernel2", ",", " ", "lc1", 
        ",", "lc2", ",", " ", "lp1", ",", " ", "height"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dd0", "  ", "=", 
        RowBox[{"1", "/", "ss0"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"tt0", "=", "  ", 
        RowBox[{"\[Theta]2", "[", 
         RowBox[{"ss0", ",", "\[Lambda]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{"space", "\[Equal]", "\"\<2\[Theta]\>\""}], ",", 
         "\[IndentingNewLine]", "                            ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sigma", "=", "\[Sigma]"}], ",", "\[IndentingNewLine]", 
           "                             ", 
           RowBox[{"delta", "=", "\[Delta]"}], ",", "\[IndentingNewLine]", 
           "                             ", 
           RowBox[{"fwhm", " ", "=", " ", 
            RowBox[{"Voigtfwhm", "[", 
             RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}]}], ",", 
           "\[IndentingNewLine]", "                              ", 
           RowBox[{"x0", "     ", "=", " ", "tt0"}]}], "\[IndentingNewLine]", 
          "                           ", "}"}], ",", "\[IndentingNewLine]", 
         "           ", 
         RowBox[{
         "space", "\[Equal]", 
          "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\)\>\""}], ",", 
         "\[IndentingNewLine]", "                             ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"sigma", "=", 
            RowBox[{"\[Sigma]", " ", 
             RowBox[{"cs", "[", 
              RowBox[{"tt0", ",", "\[Lambda]"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", "                             ", 
           RowBox[{"delta", "=", 
            RowBox[{"\[Delta]", " ", 
             RowBox[{"cs", "[", 
              RowBox[{"tt0", ",", "\[Lambda]"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", "                             ", 
           RowBox[{"fwhm", " ", "=", " ", 
            RowBox[{
             RowBox[{"Voigtfwhm", "[", 
              RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], "]"}], 
             RowBox[{"cs", "[", 
              RowBox[{"tt0", ",", "\[Lambda]"}], "]"}]}]}], ",", 
           "\[IndentingNewLine]", "                              ", 
           RowBox[{"x0", "     ", "=", " ", 
            RowBox[{"s", "[", 
             RowBox[{"tt0", ",", "\[Lambda]"}], "]"}]}]}], 
          "\[IndentingNewLine]", "                           ", "}"}]}], 
        "\[IndentingNewLine]", "         ", "]"}], ";", "\[IndentingNewLine]",
        "\[IndentingNewLine]", " ", 
       RowBox[{"mix", "                  ", "=", 
        RowBox[{"Mix", "[", 
         RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"fwhmFT", "           ", "=", " ", 
        RowBox[{"FTVoigtfwhm", "[", 
         RowBox[{
          RowBox[{"\[Delta]", " ", 
           RowBox[{"cs", "[", 
            RowBox[{"tt0", ",", "\[Lambda]"}], "]"}]}], ",", 
          RowBox[{"\[Sigma]", " ", 
           RowBox[{"cs", "[", 
            RowBox[{"tt0", ",", "\[Lambda]"}], "]"}]}]}], " ", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"leftbound", "   ", "=", 
        RowBox[{"x0", "-", 
         RowBox[{"6.", " ", "fwhm"}]}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"rightbound", "=", " ", 
        RowBox[{"x0", "+", 
         RowBox[{"6.", " ", "fwhm"}]}]}], ";", " ", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"points", "         ", "=", " ", "2000"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"stepw", "           ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound", "-", "leftbound"}], ")"}], "/", "points"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"abscissae", "  ", "=", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound", ",", "rightbound", ",", "stepw"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"middle", "         ", "=", 
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Length", "[", "abscissae", "]"}], "/", "2"}], "]"}]}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{"methods", "\[Equal]", "\"\<Voigt\>\""}], ",", 
         "\[IndentingNewLine]", "                             ", 
         RowBox[{"{", 
          RowBox[{"lc1", "                ", "=", " ", 
           RowBox[{"VoigtTable", "[", "    ", 
            RowBox[{
            "delta", ",", " ", "sigma", ",", "x0", ",", " ", "abscissae"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", "           ", 
         RowBox[{"methods", "\[Equal]", "\"\<Reichel approx.\>\""}], ",", " ",
          "\[IndentingNewLine]", "                              ", 
         RowBox[{"{", 
          RowBox[{"lc1", "                ", "=", " ", 
           RowBox[{"VoigtApproxTable", "[", 
            RowBox[{"delta", ",", "sigma", ",", "x0", ",", "abscissae"}], 
            "]"}]}], "}"}]}], "\[IndentingNewLine]", "     ", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"lc2", "                ", "=", " ", 
        RowBox[{"TCHPseudoVoigtTable", "[", "    ", 
         RowBox[{
         "delta", ",", " ", "sigma", ",", "x0", ",", " ", "abscissae"}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"height", "         ", "=", " ", 
        RowBox[{
         RowBox[{"lc1", "[", 
          RowBox[{"[", "middle", "]"}], "]"}], " ", "1.03"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"lp1", "=", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lc1", ",", " ", "lc2", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"lc2", "-", "lc1"}], ")"}], "diffMag"}]}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", 
                RowBox[{"6.", " ", 
                 RowBox[{"fwhm", "/", "xMag"}]}]}], ",", " ", 
               RowBox[{"x0", "+", 
                RowBox[{"6.", " ", 
                 RowBox[{"fwhm", "/", "xMag"}]}]}]}], "}"}], ",", "Full"}], 
            "}"}]}], ",", "  ", 
          RowBox[{"(*", 
           RowBox[{"{", 
            RowBox[{"0.0", ",", " ", "height"}], "}"}], "*)"}], 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"DataRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"leftbound", ",", " ", "rightbound"}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                                   ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                                    ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                                    ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"space", "\[Equal]", "\"\<2\[Theta]\>\""}], ",", 
               "\"\<2\[Theta]/ \[Degree]\>\"", ",", " ", 
               "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) \
/\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], "]"}], ",", 
             "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                                    ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Which", "[", 
                 RowBox[{
                  RowBox[{"methods", "==", "\"\<Voigt\>\""}], ",", 
                  "\"\<Voigt\>\"", ",", 
                  RowBox[{"methods", "==", "\"\<Reichel approx.\>\""}], ",", 
                  "\"\<Reichel approx.\>\""}], "]"}], ",", " ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                        ", "\"\<TCHZ Pseudo-Voigt\>\"", " ", 
                ",", "\[IndentingNewLine]", 
                "                                                             \
                                        ", "\"\<Difference\>\""}], "}"}], 
              "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                                    ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
          "\[IndentingNewLine]", "                                    ", 
          RowBox[{"ImageSize", "\[Rule]", "1000"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
       RowBox[{"fwhmpos", " ", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", " ", 
           RowBox[{"Arrowheads", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}], "]"}], ",", " ", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x0", "-", 
                 RowBox[{"fwhm", "/", "2"}]}], ",", 
                RowBox[{
                 RowBox[{"lc1", "[", 
                  RowBox[{"[", "middle", "]"}], "]"}], "/", "2"}]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x0", "+", 
                 RowBox[{"fwhm", "/", "2"}]}], ",", 
                RowBox[{
                 RowBox[{"lc1", "[", 
                  RowBox[{"[", "middle", "]"}], "]"}], "/", "2"}]}], "}"}]}], 
             "}"}], "]"}]}], "}"}], "]"}]}], ";", " ", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"export", ",", 
         RowBox[{"{", "\[IndentingNewLine]", "                       ", 
          RowBox[{
           RowBox[{"Export", "[", 
            RowBox[{"filePath", ",", 
             RowBox[{"{", "lp1", "}"}]}], "]"}], ",", " ", 
           "\[IndentingNewLine]", "                       ", 
           RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
          "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
        "]"}], ";", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Column", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Show", "[", 
           RowBox[{"lp1", ",", "fwhmpos"}], "]"}], ",", "\[IndentingNewLine]",
           "          ", 
          RowBox[{"Row", "[", 
           RowBox[{"{", "\[IndentingNewLine]", "           ", 
            RowBox[{
             RowBox[{"Grid", "[", 
              RowBox[{
               RowBox[{"{", "\[IndentingNewLine]", "              ", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{
                    "\"\<Parameter Gaussian\>\"", ",", "Bold", ",", "20"}], 
                    "]"}], "]"}], "}"}], ",", "    ", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                   "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                   "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<Gauss   IB  \>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"GaussIB", "[", "\[Sigma]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                   "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"GaussIB", "[", "\[Sigma]", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                   "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", "               ", 
                 RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{
                    "\"\<Parameter Lorentzian\>\"", ",", "Bold", ",", "20"}], 
                    "]"}], "]"}], "}"}], ",", "               ", 
                 "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                   "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                   "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<Lorentz IB  \>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", "\[Delta]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                   "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LorentzIB", "[", "\[Delta]", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                   "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                  "}"}]}], "\[IndentingNewLine]", "             ", 
                "\[IndentingNewLine]", "        ", "}"}], ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], " ", ",", 
               RowBox[{"ItemStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Bold"}], 
                 "]"}]}]}], " ", "]"}], "\[IndentingNewLine]", "          ", 
             ",", "\"\< \>\"", ",", "\[IndentingNewLine]", 
             RowBox[{"Grid", "[", 
              RowBox[{
               RowBox[{"{", "\[IndentingNewLine]", "              ", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{
                    "\"\<Parameter Voigt\>\"", ",", "Bold", ",", "20"}], 
                    "]"}], "]"}], "}"}], ",", "               ", 
                 "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<Voigt   fwhm\>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"Voigtfwhm", "[", 
                    RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                   "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Voigtfwhm", "[", 
                    RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                   "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<Voigt   IB  \>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", "\[Delta]", "]"}], ",", 
                    RowBox[{"GaussIB", "[", "\[Sigma]", "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                   "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", "\[Delta]", "]"}], ",", 
                    RowBox[{"GaussIB", "[", "\[Sigma]", "]"}]}], " ", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                   "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                  "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", 
                  RowBox[{"\"\<Lorentz  part \>\"", ",", "  ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"(", "           ", 
                    RowBox[{"mix", "*", "100"}], ")"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}]}], "]"}], ",", 
                   "\"\<%\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", 
                  RowBox[{"\"\<Gauss    part \>\"", ",", "  ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"100", "-", 
                    RowBox[{"mix", "*", "100"}]}], ")"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}]}], "]"}], ",", 
                   "\"\<%\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                 "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "}"}], ",", "               ", 
                 "\[IndentingNewLine]", "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<FT       fwhm\>\"", ",", " ", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{"fwhmFT", ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
                   "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<LVol     fwhm\>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Voigtfwhm", "[", 
                    RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
                   "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<LVol     IB  \>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", "\[Delta]", "]"}], ",", 
                    RowBox[{"GaussIB", "[", "\[Sigma]", "]"}]}], " ", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
                   "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                 "              ", 
                 RowBox[{"{", "  ", 
                  RowBox[{"\"\<e0           \>\"", ",", 
                   RowBox[{"NumberForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", "\[Delta]", "]"}], ",", 
                    RowBox[{"GaussIB", "[", "\[Sigma]", "]"}]}], "]"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "360"}], "/", "4"}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "}"}]}], 
                "              ", "\[IndentingNewLine]", "        ", "}"}], 
               ",", 
               RowBox[{"Frame", "\[Rule]", "True"}], " ", ",", 
               RowBox[{"ItemStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{
                  RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Bold"}], 
                 "]"}]}]}], " ", "]"}]}], "\[IndentingNewLine]", "}"}], 
           "]"}]}], "\[IndentingNewLine]", "}"}], "]"}]}]}], "   ", 
     "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Voigt function\>\"", ",", "16"}], "]"}], "]"}], ","}], 
     " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "              ", 
      RowBox[{
       RowBox[{"{", "   ", 
        RowBox[{"\"\<\[Delta]      \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Delta]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
            "0.000001", ",", " ", "1.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", "              ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<\[Sigma]      \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Sigma]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
            "0.000001", ",", " ", "1.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
       "\[IndentingNewLine]", "              ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<wavelength \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "      ", 
             RowBox[{
             "\[Lambda]", ",", "       ", "0.154059", ",", "\"\<\>\""}], 
             "}"}], ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "              ", 
       RowBox[{"{", "   ", 
        RowBox[{
        "\"\<peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))\>\"", ",", 
         "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", " ", 
             RowBox[{"ss0", ",", "5.", ",", "\"\<\>\""}], "}"}], ",", "0.001",
             ",", 
            RowBox[{"2.", "/", "\[Lambda]"}], ",", "Slider", ",", " ", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], "}"}], 
       ",", "\[IndentingNewLine]", "               ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<peak center (d)\>\"", ",", "  ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"1", "/", "ss0"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}], ",", "\[IndentingNewLine]", "               ", 
       RowBox[{"{", " ", 
        RowBox[{"\"\<peak center (2\[Theta])\>\"", ",", "  ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", " ", 
           RowBox[{
            RowBox[{"\[Theta]2", "[", 
             RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
         "\"\<\[Degree]\>\""}], "}"}]}], "               ", 
      "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "              ", 
      RowBox[{
       RowBox[{"{", "   ", 
        RowBox[{"\"\<x-axis spread             \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", "      ", 
             RowBox[{"xMag", ",", "1.", ",", "\"\<\>\""}], "}"}], ",", "1.", 
            ",", "10.", ",", "Slider", ",", " ", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}],
         " ", "}"}], ",", "\[IndentingNewLine]", "              ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<difference plot magnifier \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"diffMag", ",", "1.", ",", "\"\<\>\""}], "}"}], ",", 
            "1.", ",", "10.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}],
         " ", "}"}]}], "\[IndentingNewLine]", "            ", "}"}], "]"}], 
    ",", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "methods", ",", "\"\<Reichel approx.\>\"", ",", "\"\<function\>\""}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Voigt\>\"", ",", "\"\<Reichel approx.\>\""}], "}"}], ",",
        "RadioButton", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"space", ",", "\"\<2\[Theta]\>\"", ",", "\"\<space\>\""}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<2\[Theta]\>\"", ",", 
         "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\)\>\""}], "}"}], ",", 
       "RadioButton", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Export to desktop\>\"", ",", 
      RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier  & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", 
       " ", "\"\<Voigt & modified Thompson-Cox-Hastings (TCHZ) Pseudo-Voigt \
function\\n\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "20"}], "]"}]}], ",", " ", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "->", "True"}]}], " ", "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.794319040412157*^9, 3.7943190536322517`*^9}, {
   3.7943191700338354`*^9, 3.794319189160739*^9}, {3.7943192351881285`*^9, 
   3.79431925642473*^9}, {3.794319314543435*^9, 3.794319361316353*^9}, {
   3.79431961824543*^9, 3.7943197077910643`*^9}, {3.7943197523123317`*^9, 
   3.7943197666154423`*^9}, {3.794321844815527*^9, 3.7943218613481846`*^9}, {
   3.794321896420187*^9, 3.7943219203612504`*^9}, {3.7943241464577656`*^9, 
   3.794324193810634*^9}, {3.794327163066225*^9, 3.7943272668268566`*^9}, {
   3.7943855447790985`*^9, 3.794385554874129*^9}, {3.7943856687927074`*^9, 
   3.794385674652481*^9}, {3.794405321651597*^9, 3.7944054541039405`*^9}, {
   3.7944085088898354`*^9, 3.7944085089991555`*^9}, {3.7944085922154713`*^9, 
   3.794408654383154*^9}, {3.7944087481723895`*^9, 3.794408750656901*^9}, {
   3.794473293847952*^9, 3.7944733226788807`*^9}, {3.794473363382698*^9, 
   3.7944733652265396`*^9}, {3.794487413850478*^9, 3.79448747992292*^9}, {
   3.7944875485627394`*^9, 3.7944876606186657`*^9}, {3.7944877598290653`*^9, 
   3.7944878197534575`*^9}, {3.7944878505530033`*^9, 3.794487867769622*^9}, {
   3.7944881278612623`*^9, 3.7944881330183363`*^9}, {3.794488198028751*^9, 
   3.794488293268178*^9}, {3.7944887038357244`*^9, 3.794488704820224*^9}, {
   3.7944894556133394`*^9, 3.794489458316936*^9}, {3.7944894887437167`*^9, 
   3.7944895040474143`*^9}, {3.7944896716060767`*^9, 
   3.7944896765955935`*^9}, {3.794551114225377*^9, 3.794551142258748*^9}, {
   3.794551173550867*^9, 3.794551185083288*^9}, {3.79455124992372*^9, 
   3.7945512558306837`*^9}, 3.794551420738948*^9, {3.7945514788263187`*^9, 
   3.794551569962475*^9}, {3.794551676995348*^9, 3.7945517363804617`*^9}, {
   3.7945518201970572`*^9, 3.794551871880351*^9}, {3.794551918416395*^9, 
   3.794551920635189*^9}, {3.794551999113268*^9, 3.794552032006339*^9}, {
   3.7945520998913755`*^9, 3.794552100438222*^9}, {3.7945522878978148`*^9, 
   3.794552304008729*^9}, {3.7945523477113094`*^9, 3.794552349758848*^9}, {
   3.794552384309513*^9, 3.794552392843024*^9}, {3.7945524409708576`*^9, 
   3.794552479817137*^9}, {3.7945525149150023`*^9, 3.7945525288171806`*^9}, {
   3.794552624205395*^9, 3.794552695574839*^9}, {3.7945527352232733`*^9, 
   3.794552747786687*^9}, {3.794553497846088*^9, 3.7945535754849143`*^9}, {
   3.794553689160988*^9, 3.794553691973815*^9}, {3.794553728135916*^9, 
   3.7945537515700216`*^9}, {3.7945538162230344`*^9, 
   3.7945538181763334`*^9}, {3.7945543987478914`*^9, 3.794554440520814*^9}, 
   3.7945544762154675`*^9, {3.794554973796583*^9, 3.7945550291984468`*^9}, {
   3.7945550615965567`*^9, 3.794555110229354*^9}, {3.794555145119284*^9, 
   3.7945551526986237`*^9}, {3.794555214743018*^9, 3.7945552647487874`*^9}, {
   3.7945553018591557`*^9, 3.7945553131107264`*^9}, {3.794555349344308*^9, 
   3.794555349500512*^9}, {3.7945553807497425`*^9, 3.794555464875246*^9}, {
   3.794555538797674*^9, 3.7945555902149982`*^9}, {3.7945556238799477`*^9, 
   3.7945556547373266`*^9}, {3.7945557399896708`*^9, 
   3.7945558203725147`*^9}, {3.79455585039869*^9, 3.794555945565084*^9}, {
   3.7945560017663164`*^9, 3.7945560067202597`*^9}, {3.794556047065407*^9, 
   3.794556076195073*^9}, {3.7945561185366898`*^9, 3.7945561200058637`*^9}, {
   3.794556298136647*^9, 3.7945563891605244`*^9}, {3.794559076418931*^9, 
   3.7945592836137004`*^9}, {3.7945593181799917`*^9, 
   3.7945593669625053`*^9}, {3.7945594699749928`*^9, 
   3.7945597456318636`*^9}, {3.794559794470166*^9, 3.79455981491057*^9}, {
   3.7945598569275455`*^9, 3.794559860771781*^9}, {3.794566859362043*^9, 
   3.7945668653784943`*^9}, {3.794567024480095*^9, 3.7945670439350433`*^9}, {
   3.794567098054529*^9, 3.794567098492156*^9}, {3.794567133172125*^9, 
   3.794567203949167*^9}, {3.794567241672026*^9, 3.794567304274367*^9}, 
   3.794568237301137*^9, {3.7945682700580063`*^9, 3.7945683780627437`*^9}, {
   3.7945684447631855`*^9, 3.7945685479952993`*^9}, {3.79456864875313*^9, 
   3.7945686493781385`*^9}, {3.794568696456002*^9, 3.7945688278589478`*^9}, {
   3.7945688958530855`*^9, 3.7945689418462563`*^9}, {3.7945689900072927`*^9, 
   3.7945691318325357`*^9}, 3.7945742668441772`*^9, {3.794574317687008*^9, 
   3.7945744107709694`*^9}, {3.7945745784366703`*^9, 3.794574601126213*^9}, {
   3.794574701167533*^9, 3.794574722064423*^9}, {3.794574821532914*^9, 
   3.7945748375601416`*^9}, {3.794581648512288*^9, 3.7945817024943333`*^9}, {
   3.794581738737074*^9, 3.7945817762374463`*^9}, {3.7946485677307205`*^9, 
   3.794648799384197*^9}, {3.7946495919676976`*^9, 3.794649597874441*^9}, {
   3.7946497047841415`*^9, 3.794649726567209*^9}, {3.794649987262102*^9, 
   3.79464999801672*^9}, {3.7946500390835*^9, 3.794650141382292*^9}, {
   3.7946502051325445`*^9, 3.7946502082267675`*^9}, {3.794650252774948*^9, 
   3.7946503008923054`*^9}, {3.79465036385527*^9, 3.7946503673713694`*^9}, {
   3.794650412765634*^9, 3.7946504186047525`*^9}, {3.7946507631716485`*^9, 
   3.7946507658907433`*^9}, {3.79466335704033*^9, 3.7946633691355*^9}, {
   3.794731134586672*^9, 3.794731164012275*^9}, {3.794738589044266*^9, 
   3.7947385968733606`*^9}, {3.7947392285720735`*^9, 3.794739244886216*^9}, {
   3.7947393045444365`*^9, 3.7947393799970055`*^9}, {3.7947424196158676`*^9, 
   3.794742472236027*^9}, {3.794742610091625*^9, 3.7947427212874994`*^9}, {
   3.7947427534271774`*^9, 3.794742790660822*^9}, {3.794745363571396*^9, 
   3.7947453819852724`*^9}, {3.794745441600724*^9, 3.7947454481796727`*^9}, {
   3.7947455125681133`*^9, 3.7947455207254343`*^9}, {3.79474558926182*^9, 
   3.7947456712650948`*^9}, {3.794753171282148*^9, 3.794753565123219*^9}, {
   3.794754003967055*^9, 3.794754083442675*^9}, 3.7947543248322277`*^9, {
   3.7947543749058304`*^9, 3.794754422496132*^9}, {3.794754462074851*^9, 
   3.794754633346733*^9}, {3.7947546636841764`*^9, 3.794754688547868*^9}, {
   3.79475503393266*^9, 3.7947550601454363`*^9}, {3.794755332509104*^9, 
   3.7947553342604637`*^9}, {3.7947553779622946`*^9, 3.794755381741601*^9}, {
   3.794755444292924*^9, 3.7947554581232295`*^9}, {3.7947649965450983`*^9, 
   3.794765005547078*^9}, 3.7947650859049826`*^9, {3.794765158870441*^9, 
   3.7947651590891795`*^9}, {3.7948067167158785`*^9, 
   3.7948067386088734`*^9}, {3.79480686908705*^9, 3.7948068770568075`*^9}, {
   3.7948069826724443`*^9, 3.79480741102139*^9}, {3.794807460580491*^9, 
   3.79480746229937*^9}, {3.794807525591608*^9, 3.7948075730799303`*^9}, {
   3.7948076493836975`*^9, 3.7948076937685375`*^9}, {3.7948078171257987`*^9, 
   3.79480792341604*^9}, {3.7948156150519996`*^9, 3.794815619192868*^9}, {
   3.7948156742415466`*^9, 3.7948156780700665`*^9}, {3.7948158079670267`*^9, 
   3.7948158294635763`*^9}, {3.7948159017658215`*^9, 
   3.7948159315653553`*^9}, {3.7948160342501554`*^9, 
   3.7948160457357435`*^9}, {3.7948161034878607`*^9, 
   3.7948161445648875`*^9}, {3.7948162016130652`*^9, 3.794816204363353*^9}, {
   3.7948163699361353`*^9, 3.794816403862196*^9}, {3.794816598657875*^9, 
   3.794816601126938*^9}, {3.7948174516826935`*^9, 3.7948174570935755`*^9}, {
   3.7948175166922417`*^9, 3.7948175225685577`*^9}, 3.7948175880100346`*^9, {
   3.794822899898366*^9, 3.7948229712030735`*^9}, {3.7948230174784*^9, 
   3.794823134069487*^9}, {3.794823219780487*^9, 3.7948232241872673`*^9}, {
   3.794823281875688*^9, 3.794823301800047*^9}, 3.794823404834735*^9, {
   3.7948243846117363`*^9, 3.7948244215857067`*^9}, 3.794824515728367*^9, {
   3.7948246886353655`*^9, 3.7948246899793587`*^9}, {3.7948247830389013`*^9, 
   3.7948248988901978`*^9}, {3.7948249404092326`*^9, 
   3.7948249443627963`*^9}, {3.794824981496891*^9, 3.794824989622807*^9}, {
   3.7948251516012535`*^9, 3.7948251604518456`*^9}, {3.794825348336045*^9, 
   3.794825369669573*^9}, {3.7948254044545016`*^9, 3.7948254083455963`*^9}, 
   3.7948256256198673`*^9, {3.7948258464516125`*^9, 3.7948258521398807`*^9}, {
   3.794825926801507*^9, 3.79482593120827*^9}, {3.794825965813887*^9, 
   3.794825979081055*^9}, {3.7948260279656982`*^9, 3.7948260301692915`*^9}, {
   3.794826105879981*^9, 3.7948261210692964`*^9}, {3.7948261737434406`*^9, 
   3.794826174806033*^9}, {3.794826251339073*^9, 3.7948262536985025`*^9}, {
   3.794826726811509*^9, 3.794826794924638*^9}, {3.794826879110653*^9, 
   3.794826895471589*^9}, {3.7948275364111795`*^9, 3.794827540505455*^9}, {
   3.794827611383765*^9, 3.794827652470951*^9}, {3.7948277421565022`*^9, 
   3.7948277501730304`*^9}, {3.794827904298241*^9, 3.7948279060328197`*^9}, {
   3.794827952634156*^9, 3.7948279567596235`*^9}, {3.7948281269437103`*^9, 
   3.7948281378555183`*^9}, {3.7948281744067373`*^9, 
   3.7948282055246673`*^9}, {3.7948291668345814`*^9, 3.794829193540492*^9}, {
   3.794829234898368*^9, 3.7948292424775476`*^9}, {3.7948293060095854`*^9, 
   3.794829315027892*^9}, {3.7948294027646847`*^9, 3.794829407972072*^9}, {
   3.794829631702759*^9, 3.7948296617030473`*^9}, {3.79482974566298*^9, 
   3.794829780450944*^9}, {3.7948299119621744`*^9, 3.7948299128217964`*^9}, {
   3.79483202558685*^9, 3.794832096962912*^9}, 3.7948321671346064`*^9, {
   3.7948322938149815`*^9, 3.7948322997969327`*^9}, {3.794883679001836*^9, 
   3.7948837489948416`*^9}, {3.794883792657653*^9, 3.7948839325929813`*^9}, {
   3.794884155593641*^9, 3.794884156531141*^9}, {3.7948842903666573`*^9, 
   3.7948842959030547`*^9}, {3.7948847560905523`*^9, 
   3.7948847807371387`*^9}, {3.7948886929144926`*^9, 
   3.7948887466817985`*^9}, {3.794888778750741*^9, 3.7948887888455315`*^9}, {
   3.794888885140463*^9, 3.7948888986280603`*^9}, {3.794888962371647*^9, 
   3.794889063299991*^9}, {3.7948891074647694`*^9, 3.7948891190654097`*^9}, {
   3.794889195191227*^9, 3.7948892175536985`*^9}, {3.794889919907044*^9, 
   3.794890026227694*^9}, {3.794890060942475*^9, 3.7948900841332483`*^9}, {
   3.794890130511204*^9, 3.7948901375900064`*^9}, 3.79489017184179*^9, {
   3.794890277111452*^9, 3.794890409898226*^9}, {3.7948905021997213`*^9, 
   3.7948905052937*^9}, {3.7948905777628765`*^9, 3.7948905785441694`*^9}, {
   3.794890773003586*^9, 3.7948907740972977`*^9}, {3.7948908445045404`*^9, 
   3.794890850346617*^9}, {3.7948909104028206`*^9, 3.7948909289986563`*^9}, {
   3.794891106876581*^9, 3.7948911760508184`*^9}, {3.794891219536886*^9, 
   3.794891221224619*^9}, 3.794891556808736*^9, {3.79489241303139*^9, 
   3.7948924592003913`*^9}, {3.7948925347538376`*^9, 3.794892558806944*^9}, {
   3.794892641846098*^9, 3.7948926704768505`*^9}, {3.794892703963497*^9, 
   3.7948927068698916`*^9}, {3.7948979390294156`*^9, 
   3.7948979467334614`*^9}, {3.7948980197753296`*^9, 
   3.7948980422311163`*^9}, {3.7948980968276224`*^9, 3.794898132220888*^9}, {
   3.794904341799693*^9, 3.7949043427216454`*^9}, {3.794904429946576*^9, 
   3.7949044572019167`*^9}, {3.7949052427716055`*^9, 3.794905387915564*^9}, {
   3.794905498034193*^9, 3.7949055252864857`*^9}, {3.7949090001922255`*^9, 
   3.7949090045051527`*^9}, {3.7949091243602204`*^9, 
   3.7949092387331285`*^9}, {3.7949092739492817`*^9, 3.7949092767620487`*^9}, 
   3.7949093217699175`*^9, {3.794909477281195*^9, 3.7949095503933144`*^9}, {
   3.794909612635951*^9, 3.7949096523901014`*^9}, {3.7949097153870993`*^9, 
   3.7949097178248606`*^9}, {3.794909766520816*^9, 3.7949097876645823`*^9}, {
   3.7949100375421543`*^9, 3.794910056747521*^9}, {3.794912489006733*^9, 
   3.794912539514271*^9}, {3.7949125733692455`*^9, 3.794912598725876*^9}, {
   3.794913189646308*^9, 3.794913194725193*^9}, {3.794913228676214*^9, 
   3.7949132369115405`*^9}, {3.7949166528226905`*^9, 3.794916657668517*^9}, {
   3.7950824048847704`*^9, 3.795082494244954*^9}, {3.7950826211396694`*^9, 
   3.7950826787814436`*^9}, {3.7950827277035637`*^9, 3.795082857643416*^9}, {
   3.7950852358240075`*^9, 3.79508524423136*^9}, {3.79508532146773*^9, 
   3.7950854092504168`*^9}, {3.795085553332996*^9, 3.7950855723515205`*^9}, {
   3.7950856479686317`*^9, 3.795085722807432*^9}, {3.7950857550946183`*^9, 
   3.795085776467847*^9}, {3.795086641175069*^9, 3.795086645816002*^9}, {
   3.7950867004131904`*^9, 3.795086841756363*^9}, {3.7950869376659236`*^9, 
   3.7950869666086316`*^9}, {3.795176389063452*^9, 3.7951764223245993`*^9}, {
   3.7951765027923355`*^9, 3.7951765238441086`*^9}, {3.7951765689720964`*^9, 
   3.7951766049967747`*^9}, {3.795176664537774*^9, 3.7951766802356286`*^9}, {
   3.795183508072175*^9, 3.795183546663879*^9}, {3.795184766056965*^9, 
   3.7951847736781764`*^9}, {3.7951848527676444`*^9, 3.795184858363011*^9}, {
   3.7951850956191607`*^9, 3.7951851327736187`*^9}, {3.7951851869832716`*^9, 
   3.7951851874210234`*^9}, {3.795185251325763*^9, 3.79518526392089*^9}, {
   3.7951855646819916`*^9, 3.7951855661194763`*^9}, {3.7951856105825047`*^9, 
   3.7951856226150527`*^9}, {3.7951857779613743`*^9, 3.795185779916667*^9}, {
   3.7956869486749716`*^9, 3.795686964853595*^9}, {3.795687193208358*^9, 
   3.795687200818506*^9}, {3.7956874897242303`*^9, 3.7956875018804655`*^9}, {
   3.795687573376557*^9, 3.7956876159640226`*^9}, {3.795690832063207*^9, 
   3.795690916406209*^9}, {3.7956912732015853`*^9, 3.795691300139863*^9}, {
   3.7957021876008587`*^9, 3.7957021965239215`*^9}, {3.7957023405785403`*^9, 
   3.7957023489389205`*^9}, {3.795702397730529*^9, 3.7957024018873777`*^9}, {
   3.795702481909525*^9, 3.795702486831807*^9}, {3.795758404154941*^9, 
   3.7957584152340975`*^9}, {3.795758772929406*^9, 3.795758856782596*^9}, {
   3.795770042642675*^9, 3.79577004429922*^9}, {3.795770074933889*^9, 
   3.7957701002661767`*^9}, {3.795770242941496*^9, 3.7957702439414845`*^9}, {
   3.7957711070958023`*^9, 3.795771162400639*^9}, {3.7958620579039526`*^9, 
   3.795862061532708*^9}, {3.7958632465565987`*^9, 3.7958633249995484`*^9}, {
   3.7958634575272446`*^9, 3.7958634818588457`*^9}, 3.7958636328483286`*^9, {
   3.7958637757269735`*^9, 3.795863785884303*^9}, {3.795864447769828*^9, 
   3.795864452004612*^9}, {3.7958645507750163`*^9, 3.795864551243695*^9}, {
   3.79586458456017*^9, 3.7958645882793646`*^9}, {3.7958646849458857`*^9, 
   3.7958646882585473`*^9}, {3.795864782385995*^9, 3.7958648353598337`*^9}, {
   3.7958650666962404`*^9, 3.7958650793426714`*^9}, {3.795865430520861*^9, 
   3.795865440957015*^9}, {3.795865793421837*^9, 3.795865833377186*^9}, {
   3.7958659238895664`*^9, 3.7958659349980774`*^9}, {3.7958660376014905`*^9, 
   3.7958660480758734`*^9}, {3.795866127578972*^9, 3.7958661339636345`*^9}, {
   3.7958663101440744`*^9, 3.795866322192334*^9}, {3.7958665622505355`*^9, 
   3.79586657343926*^9}, 3.7958666537828646`*^9, {3.79586674921377*^9, 
   3.79586676827977*^9}, {3.7958672407578382`*^9, 3.7958672503215094`*^9}, {
   3.7958698850380583`*^9, 3.795869886663418*^9}, {3.7958699183071723`*^9, 
   3.795870012359209*^9}, {3.795870044869776*^9, 3.795870064529159*^9}, {
   3.7958701820315905`*^9, 3.7958702551072474`*^9}, {3.7958703211348295`*^9, 
   3.7958703318708706`*^9}, {3.795964440289277*^9, 3.7959644987389307`*^9}, {
   3.7959648649493637`*^9, 3.795964911442204*^9}, {3.7959651307485704`*^9, 
   3.7959651435000906`*^9}, {3.795965217439416*^9, 3.7959652477179084`*^9}, {
   3.795965687920564*^9, 3.795965701422634*^9}, {3.7959657711391897`*^9, 
   3.7959657742018776`*^9}, {3.7959659174992876`*^9, 3.795965917624236*^9}, {
   3.7960092756867547`*^9, 3.79600927832909*^9}, {3.7960101229927883`*^9, 
   3.7960101459487915`*^9}, {3.7960102871251073`*^9, 
   3.7960102902356677`*^9}, {3.796116571485036*^9, 3.796116575188267*^9}, {
   3.796128532695529*^9, 3.796128541712279*^9}, {3.796128797460223*^9, 
   3.796128799262579*^9}, {3.796128948592627*^9, 3.796128951671072*^9}, {
   3.796129036148384*^9, 3.7961290375548406`*^9}, {3.796130049830637*^9, 
   3.796130049924383*^9}, {3.797333106902785*^9, 3.797333127233597*^9}, {
   3.797333158880273*^9, 3.797333198455073*^9}, {3.7973333948349257`*^9, 
   3.7973334433888235`*^9}, {3.797333473695882*^9, 3.797333511192109*^9}, 
   3.7973335619898005`*^9, {3.797333605137972*^9, 3.797333762460471*^9}, {
   3.7973339731645217`*^9, 3.797334032025482*^9}, {3.7973341314748373`*^9, 
   3.7973341784987574`*^9}, {3.797335071071268*^9, 3.7973350747280035`*^9}, {
   3.7974220717500057`*^9, 3.797422107037466*^9}, {3.797422174289169*^9, 
   3.7974221772893105`*^9}, {3.797422310529196*^9, 3.7974223132797155`*^9}, {
   3.7974223556998816`*^9, 3.797422357903324*^9}, {3.7974224078631873`*^9, 
   3.797422411160308*^9}, {3.797422463102729*^9, 3.797422490403185*^9}, {
   3.7974226312243166`*^9, 3.7974226621945105`*^9}, {3.79757249392977*^9, 
   3.797572558272299*^9}, {3.7975725960259037`*^9, 3.797572609136569*^9}, {
   3.797572656410541*^9, 3.797572664583045*^9}, {3.797572698010484*^9, 
   3.7975726985416594`*^9}, {3.7975727580092173`*^9, 3.797572764369032*^9}, {
   3.79757285291026*^9, 3.7975728630294724`*^9}, {3.7975729613013945`*^9, 
   3.797572992305749*^9}, {3.7975731177507367`*^9, 3.7975731457691603`*^9}, {
   3.797577726950145*^9, 3.79757774542181*^9}, {3.7975782899503317`*^9, 
   3.79757835019455*^9}, {3.7975784808594694`*^9, 3.7975784934699388`*^9}, {
   3.7975786166122775`*^9, 3.797578619143634*^9}, {3.79757893175381*^9, 
   3.797578966116908*^9}, {3.7975791221942453`*^9, 3.7975791540026093`*^9}, {
   3.7975792213690777`*^9, 3.7975792898677855`*^9}, {3.797579338282297*^9, 
   3.797579352314595*^9}, {3.7975794680557413`*^9, 3.7975794724658103`*^9}, 
   3.797579543715496*^9, {3.797580347668742*^9, 3.7975804511061*^9}, {
   3.7975804879369726`*^9, 3.797580507330576*^9}, {3.7976523983087068`*^9, 
   3.7976525738213806`*^9}, {3.797652620246495*^9, 3.797652659297518*^9}, {
   3.79765275611486*^9, 3.797652800371394*^9}, {3.797652885294306*^9, 
   3.797652949394085*^9}, {3.7976530204499216`*^9, 3.7976530247639513`*^9}, {
   3.797653076346817*^9, 3.79765307790919*^9}, 3.797653113812152*^9, {
   3.797653228433236*^9, 3.797653240653209*^9}, {3.797653277049228*^9, 
   3.797653288050187*^9}, {3.797653382985401*^9, 3.797653493764831*^9}, {
   3.7976536225973225`*^9, 3.797653624271188*^9}, {3.797653654399988*^9, 
   3.797653705875662*^9}, {3.797653755429599*^9, 3.797653796073965*^9}, 
   3.797653862094228*^9, {3.797673031184019*^9, 3.7976730662505755`*^9}, {
   3.7976732971421843`*^9, 3.797673298611101*^9}, {3.7978338224897523`*^9, 
   3.7978338946257315`*^9}, {3.7978339359891653`*^9, 
   3.7978339417075796`*^9}, {3.7978341897421675`*^9, 3.797834254763647*^9}, {
   3.7978342968304677`*^9, 3.797834304455888*^9}, {3.799306972172969*^9, 
   3.7993069726575975`*^9}, {3.7993886839077034`*^9, 3.799388685157946*^9}, {
   3.799389947825966*^9, 3.799389997953882*^9}, {3.799390110121764*^9, 
   3.7993901105904846`*^9}, {3.799390145789245*^9, 3.7993901797140713`*^9}, {
   3.7993902510492563`*^9, 3.799390262753496*^9}, {3.7993903814085464`*^9, 
   3.7993903921128707`*^9}, {3.8045070835069027`*^9, 3.804507083694357*^9}, {
   3.8045073685696135`*^9, 3.804507588596719*^9}, {3.804508035787322*^9, 
   3.8045080610952463`*^9}, {3.804508256845417*^9, 3.804508339752902*^9}, {
   3.8045084267808886`*^9, 3.8045084650986137`*^9}, {3.80450863035869*^9, 
   3.8045086316244745`*^9}, 3.813044319429139*^9, {3.8134159253611336`*^9, 
   3.8134159418298564`*^9}, {3.8134161071594887`*^9, 3.813416109237638*^9}, {
   3.813416181851777*^9, 3.8134161824103117`*^9}, {3.8134692684717064`*^9, 
   3.813469280470415*^9}, {3.8134693105227847`*^9, 3.813469389816786*^9}, {
   3.813469493350978*^9, 3.8134694985808134`*^9}, 3.8134695393196173`*^9, {
   3.813469632710122*^9, 3.813469636335496*^9}, {3.8134696734446406`*^9, 
   3.8134697077721086`*^9}, {3.813469738619994*^9, 3.813470003870701*^9}, {
   3.813470733722652*^9, 3.8134707393947144`*^9}, {3.8134708389113145`*^9, 
   3.8134708399111795`*^9}, {3.813470889646148*^9, 3.813470893349434*^9}, {
   3.813472103502604*^9, 3.8134721822844453`*^9}, {3.8134722126346908`*^9, 
   3.813472257785468*^9}, {3.813472288551052*^9, 3.8134722919525037`*^9}, {
   3.8134723408616734`*^9, 3.813472349333022*^9}, {3.813472536007084*^9, 
   3.813472537913216*^9}, {3.813472608226265*^9, 3.813472657502568*^9}, {
   3.813472817875557*^9, 3.813472878291521*^9}, {3.813472937456468*^9, 
   3.8134729403476315`*^9}, {3.813472970843219*^9, 3.8134729726517363`*^9}, {
   3.8134730502464266`*^9, 3.8134730523244505`*^9}, {3.8134732247946672`*^9, 
   3.8134732272325134`*^9}, {3.8134736417829237`*^9, 
   3.8134736685021725`*^9}, {3.8134738170789924`*^9, 
   3.8134738265193844`*^9}, {3.8134739664056025`*^9, 3.813473967067075*^9}, {
   3.8134740730529613`*^9, 3.8134740813805676`*^9}, {3.8134741168700256`*^9, 
   3.813474139074894*^9}, {3.8134750923497286`*^9, 3.8134750925307436`*^9}, {
   3.813475137201796*^9, 3.813475350923436*^9}, {3.8134755133308735`*^9, 
   3.813475557612749*^9}, {3.8134756044881215`*^9, 3.813475605711627*^9}, {
   3.813475662206934*^9, 3.8134756808011475`*^9}, {3.813475711520362*^9, 
   3.813475728647706*^9}, {3.8134757766300783`*^9, 3.813475781270919*^9}, {
   3.813476028351012*^9, 3.81347608087871*^9}, {3.8134762518995976`*^9, 
   3.813476274504304*^9}, {3.813476983874482*^9, 3.8134770263120785`*^9}, 
   3.8134770623594832`*^9, {3.813477118375627*^9, 3.8134771381412024`*^9}, {
   3.8134771784912767`*^9, 3.813477181813484*^9}, {3.813477242282816*^9, 
   3.8134773653074083`*^9}, {3.8134773967727923`*^9, 
   3.8134774134716635`*^9}, {3.81348335877118*^9, 3.813483392708284*^9}, {
   3.8134834369857893`*^9, 3.8134834727966347`*^9}, {3.8134836192196236`*^9, 
   3.8134837211422234`*^9}, {3.8134909316670523`*^9, 
   3.8134910859274836`*^9}, {3.81349111959833*^9, 3.81349119022635*^9}, {
   3.813491254601427*^9, 3.813491258758272*^9}, {3.8134913967993145`*^9, 
   3.8134915019971347`*^9}, {3.813491532426489*^9, 3.813491543743369*^9}, {
   3.813491580651368*^9, 3.8134915895270677`*^9}, {3.813492503442853*^9, 
   3.8134925070520115`*^9}, {3.8134951916357737`*^9, 
   3.8134951963077874`*^9}, {3.8134952321994734`*^9, 3.813495302691429*^9}, {
   3.813495488395172*^9, 3.8134955061826506`*^9}, {3.8134971405050583`*^9, 
   3.813497187975027*^9}, {3.8134983776140347`*^9, 3.8134983840828753`*^9}, {
   3.8135006591623545`*^9, 3.813500659584259*^9}, {3.8139277891904345`*^9, 
   3.8139278525358963`*^9}, {3.8139278947070355`*^9, 
   3.8139278981306076`*^9}, {3.813928402631695*^9, 3.8139284033586864`*^9}, {
   3.8139286552853007`*^9, 3.8139286559494686`*^9}, {3.8139290398860188`*^9, 
   3.813929059276938*^9}, 3.817030626532385*^9, 3.817100289790927*^9, {
   3.8171003369929695`*^9, 3.817100358086213*^9}, {3.817100388522984*^9, 
   3.817100479807152*^9}, {3.817128959869089*^9, 3.8171289692134447`*^9}, {
   3.817181781888296*^9, 3.81718178668511*^9}, {3.8171860484732056`*^9, 
   3.8171860714557858`*^9}, {3.817186107162631*^9, 3.8171861108176975`*^9}, {
   3.817186144068221*^9, 3.817186227232422*^9}, 3.8171863428128777`*^9, {
   3.8171863995723667`*^9, 3.817186409381045*^9}, {3.8171865000583024`*^9, 
   3.817186520667934*^9}, {3.8171865924462333`*^9, 3.8171866133412724`*^9}, {
   3.817186645841772*^9, 3.817186654482356*^9}, {3.817186999485355*^9, 
   3.817187001721846*^9}, {3.817187122645564*^9, 3.817187141098855*^9}, {
   3.817187180412469*^9, 3.8171871923030343`*^9}, {3.817187448398262*^9, 
   3.817187452275426*^9}, {3.8171874843690157`*^9, 3.8171874903695927`*^9}, {
   3.817188426836478*^9, 3.8171884500528107`*^9}, {3.817188577041827*^9, 
   3.817188577916956*^9}, {3.817188886226786*^9, 3.817188886843401*^9}, {
   3.8246399712370133`*^9, 3.824639973627698*^9}, {3.824640267446496*^9, 
   3.8246402855252075`*^9}, {3.8246403658396373`*^9, 
   3.8246403784805737`*^9}, {3.824640754065509*^9, 3.824640879616173*^9}, {
   3.8246409242755795`*^9, 3.8246409256313205`*^9}, {3.8246409753519726`*^9, 
   3.824641113699636*^9}, {3.824641151635907*^9, 3.824641176544567*^9}, {
   3.824641355271325*^9, 3.8246413749819527`*^9}, {3.824641456149102*^9, 
   3.8246414645737886`*^9}, {3.8246415025045576`*^9, 3.824641531129277*^9}, {
   3.8246415801657577`*^9, 3.8246415807361097`*^9}, {3.824641613375822*^9, 
   3.824641618275041*^9}, {3.824641658193597*^9, 3.824641729078261*^9}, {
   3.824960072301695*^9, 3.824960107614976*^9}, {3.824960163835018*^9, 
   3.8249601884449005`*^9}, {3.826862277832449*^9, 3.826862455695527*^9}, {
   3.8268625050403852`*^9, 3.826862506868365*^9}, {3.826862759092169*^9, 
   3.8268628266406236`*^9}, {3.8268629828197203`*^9, 3.826863153538027*^9}, {
   3.8268637533013835`*^9, 3.8268640958837805`*^9}, {3.826864190027974*^9, 
   3.826864229528531*^9}, {3.8268642629707947`*^9, 3.8268642675961103`*^9}, {
   3.8268643096450605`*^9, 3.826864346609485*^9}, {3.8268678858201647`*^9, 
   3.8268679024765835`*^9}, 3.826868071276573*^9, {3.8268685412403655`*^9, 
   3.826868541779197*^9}, {3.826868633771976*^9, 3.8268686341315117`*^9}, {
   3.8278365533600664`*^9, 3.827836591758071*^9}, {3.8278366448743763`*^9, 
   3.82783665669242*^9}, 3.8278367637529097`*^9, {3.827836844058298*^9, 
   3.82783684832801*^9}, {3.82783696362245*^9, 3.827836966078536*^9}, {
   3.8281735616615367`*^9, 3.828173562208891*^9}, {3.829807344235507*^9, 
   3.8298073921983995`*^9}, {3.829807449942807*^9, 3.829807504154798*^9}, {
   3.8298075506834645`*^9, 3.8298076218044753`*^9}, {3.829807771756759*^9, 
   3.82980780626591*^9}, {3.8298090957772274`*^9, 3.829809179878687*^9}, {
   3.8299676442593117`*^9, 3.8299676957577796`*^9}, {3.829968266335978*^9, 
   3.8299683112904015`*^9}, {3.8299683416349335`*^9, 3.829968357432226*^9}, 
   3.8299683962927103`*^9, {3.829968507186159*^9, 3.829968531546301*^9}, {
   3.829968580797181*^9, 3.829968614939184*^9}, {3.8299686938319454`*^9, 
   3.829968747177145*^9}, {3.829968937010214*^9, 3.82996900535631*^9}, {
   3.830587905226696*^9, 3.830587957582724*^9}, {3.8305888598029146`*^9, 
   3.830588914077705*^9}, {3.8305899332229414`*^9, 3.8305899409647408`*^9}, 
   3.8305899761297407`*^9, {3.830590020993696*^9, 3.8305900499550953`*^9}, {
   3.8305900915265417`*^9, 3.8305902166382303`*^9}, {3.830590277389676*^9, 
   3.8305903133465123`*^9}, {3.830591119847497*^9, 3.830591164390872*^9}, {
   3.8305912339509325`*^9, 3.8305913250639567`*^9}, {3.8305914495430098`*^9, 
   3.830591470670167*^9}, {3.8305915802862186`*^9, 3.830591590892284*^9}, {
   3.8305916394845314`*^9, 3.830591663374061*^9}, {3.830591701918024*^9, 
   3.8305917059005203`*^9}, {3.830591769762545*^9, 3.8305918604881535`*^9}, {
   3.831616715540963*^9, 3.8316167640279646`*^9}, {3.831616799576932*^9, 
   3.831616847532115*^9}, {3.8316168908468795`*^9, 3.831616946943491*^9}, {
   3.83161698883611*^9, 3.831617021337653*^9}, {3.83161873221855*^9, 
   3.831618769610578*^9}, {3.8316188050490837`*^9, 3.8316188070959864`*^9}, {
   3.831618845378584*^9, 3.8316189098805275`*^9}, {3.831618988523923*^9, 
   3.831619037165784*^9}, {3.832144424110997*^9, 3.8321444316057615`*^9}, {
   3.8321445215889387`*^9, 3.8321445469586797`*^9}, {3.832144595841567*^9, 
   3.83214461046008*^9}, {3.8321446423292108`*^9, 3.832144655727666*^9}, {
   3.83214470278891*^9, 3.8321447737096295`*^9}, {3.8321448055187397`*^9, 
   3.8321448149808283`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"cfff8561-b944-4b02-b9bd-3c5338b33f62"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`diffMag$$ = 1., $CellContext`export$$ = 
    False, $CellContext`methods$$ = "Reichel approx.", $CellContext`space$$ = 
    "2\[Theta]", $CellContext`ss0$$ = 5., $CellContext`xMag$$ = 
    1., $CellContext`\[Delta]$$ = 0.03, $CellContext`\[Lambda]$$ = 
    0.14249059611887502`, $CellContext`\[Sigma]$$ = 0.3, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.03, ""}, 1.*^-6, 1.}, {{
       Hold[$CellContext`\[Sigma]$$], 0.03, ""}, 1.*^-6, 1.}, {{
       Hold[$CellContext`\[Lambda]$$], 0.154059, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`ss0$$], 5., ""}, 0.001, 
      Dynamic[2./$CellContext`\[Lambda]$$]}, {
      Hold[
       Grid[{{"\[Delta]      ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma]      ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"wavelength ", 
          Manipulate`Place[3], "nm"}, {
         "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
          Manipulate`Place[4], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
         "peak center (d)", 
          Dynamic[
           NumberForm[1/$CellContext`ss0$$, {3, 5}]], "nm"}, {
         "peak center (2\[Theta])", 
          Dynamic[
           NumberForm[
            $CellContext`\[Theta]2[$CellContext`ss0$$, \
$CellContext`\[Lambda]$$], {3, 5}]], "\[Degree]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1., ""}, 1., 10.}, {{
       Hold[$CellContext`diffMag$$], 1., ""}, 1., 10.}, {
      Hold[
       Grid[{{"x-axis spread             ", 
          Manipulate`Place[5]}, {"difference plot magnifier ", 
          Manipulate`Place[6]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`methods$$], "Reichel approx.", "function"}, {
      "Voigt", "Reichel approx."}}, {{
       Hold[$CellContext`space$$], "2\[Theta]", "space"}, {
      "2\[Theta]", "\!\(\*SuperscriptBox[\(d\), \(*\)]\)"}}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1000., {469., 475.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`diffMag$$ = 1., $CellContext`export$$ = 
        False, $CellContext`methods$$ = 
        "Reichel approx.", $CellContext`space$$ = 
        "2\[Theta]", $CellContext`ss0$$ = 5., $CellContext`xMag$$ = 
        1., $CellContext`\[Delta]$$ = 0.03, $CellContext`\[Lambda]$$ = 
        0.154059, $CellContext`\[Sigma]$$ = 0.03}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`sigma$, $CellContext`delta$, $CellContext`mix$, \
$CellContext`fwhm$, $CellContext`fwhmFT$, $CellContext`x0$, \
$CellContext`dd0$, $CellContext`tt0$, $CellContext`fwhmpos$, \
$CellContext`leftbound$, $CellContext`rightbound$, $CellContext`points$, \
$CellContext`stepw$, $CellContext`abscissae$, $CellContext`middle$, \
$CellContext`kernel1$, $CellContext`kernel2$, $CellContext`lc1$, \
$CellContext`lc2$, $CellContext`lp1$, $CellContext`height$}, \
$CellContext`dd0$ = 
         1/$CellContext`ss0$$; $CellContext`tt0$ = \
$CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\[Lambda]$$]; 
        Which[$CellContext`space$$ == 
          "2\[Theta]", {$CellContext`sigma$ = $CellContext`\[Sigma]$$, \
$CellContext`delta$ = $CellContext`\[Delta]$$, $CellContext`fwhm$ = \
$CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\[Sigma]$$], \
$CellContext`x0$ = $CellContext`tt0$}, $CellContext`space$$ == 
          "\!\(\*SuperscriptBox[\(d\), \(*\)]\)", {$CellContext`sigma$ = \
$CellContext`\[Sigma]$$ $CellContext`cs[$CellContext`tt0$, $CellContext`\
\[Lambda]$$], $CellContext`delta$ = $CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`tt0$, $CellContext`\[Lambda]$$], \
$CellContext`fwhm$ = $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$] $CellContext`cs[$CellContext`tt0$, $CellContext`\
\[Lambda]$$], $CellContext`x0$ = $CellContext`s[$CellContext`tt0$, \
$CellContext`\[Lambda]$$]}]; $CellContext`mix$ = \
$CellContext`Mix[$CellContext`\[Delta]$$, $CellContext`\[Sigma]$$]; \
$CellContext`fwhmFT$ = $CellContext`FTVoigtfwhm[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`tt0$, $CellContext`\[Lambda]$$], $CellContext`\
\[Sigma]$$ $CellContext`cs[$CellContext`tt0$, $CellContext`\[Lambda]$$]]; \
$CellContext`leftbound$ = $CellContext`x0$ - 
          6. $CellContext`fwhm$; $CellContext`rightbound$ = $CellContext`x0$ + 
          6. $CellContext`fwhm$; $CellContext`points$ = 
         2000; $CellContext`stepw$ = ($CellContext`rightbound$ - \
$CellContext`leftbound$)/$CellContext`points$; $CellContext`abscissae$ = 
         Range[$CellContext`leftbound$, $CellContext`rightbound$, \
$CellContext`stepw$]; $CellContext`middle$ = 
         Ceiling[Length[$CellContext`abscissae$]/2]; 
        Which[$CellContext`methods$$ == 
          "Voigt", {$CellContext`lc1$ = \
$CellContext`VoigtTable[$CellContext`delta$, $CellContext`sigma$, \
$CellContext`x0$, $CellContext`abscissae$]}, $CellContext`methods$$ == 
          "Reichel approx.", {$CellContext`lc1$ = \
$CellContext`VoigtApproxTable[$CellContext`delta$, $CellContext`sigma$, \
$CellContext`x0$, $CellContext`abscissae$]}]; $CellContext`lc2$ = \
$CellContext`TCHPseudoVoigtTable[$CellContext`delta$, $CellContext`sigma$, \
$CellContext`x0$, $CellContext`abscissae$]; $CellContext`height$ = 
         Part[$CellContext`lc1$, $CellContext`middle$] 
          1.03; $CellContext`lp1$ = 
         ListLinePlot[{$CellContext`lc1$, $CellContext`lc2$, \
($CellContext`lc2$ - $CellContext`lc1$) $CellContext`diffMag$$}, 
           PlotRange -> {{$CellContext`x0$ - 
              6. ($CellContext`fwhm$/$CellContext`xMag$$), $CellContext`x0$ + 
              6. ($CellContext`fwhm$/$CellContext`xMag$$)}, Full}, 
           DataRange -> {$CellContext`leftbound$, $CellContext`rightbound$}, 
           GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
           PlotStyle -> {Thick}, Frame -> True, FrameLabel -> {
             
             If[$CellContext`space$$ == "2\[Theta]", "2\[Theta]/ \[Degree]", 
              "\!\(\*SuperscriptBox[\(d\), \(*\)]\) \
/\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"], "Intensity (a.u.)"}, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
             LineLegend[{
               
               Which[$CellContext`methods$$ == "Voigt", 
                "Voigt", $CellContext`methods$$ == "Reichel approx.", 
                "Reichel approx."], "TCHZ Pseudo-Voigt", "Difference"}], {
             0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], AspectRatio -> 0.7, ImageSize -> 
           1000]; $CellContext`fwhmpos$ = Graphics[{Red, 
            Arrowheads[{-0.02, 0.02}], 
            
            Arrow[{{$CellContext`x0$ - $CellContext`fwhm$/2, 
               Part[$CellContext`lc1$, $CellContext`middle$]/
               2}, {$CellContext`x0$ + $CellContext`fwhm$/2, 
               Part[$CellContext`lc1$, $CellContext`middle$]/2}}]}]; 
        If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`lp1$}], \
$CellContext`export$$ = False}]; Column[{
           Show[$CellContext`lp1$, $CellContext`fwhmpos$], 
           Row[{
             Grid[{{
                Text[
                 Style["Parameter Gaussian", Bold, 20]]}, {"Gauss   fwhm", 
                NumberForm[
                 $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 3}], 
                "\[Degree]2\[Theta] (", 
                
                NumberForm[$CellContext`Gaussfwhm[$CellContext`\[Sigma]$$] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {"Gauss   IB  ", 
                NumberForm[
                 $CellContext`GaussIB[$CellContext`\[Sigma]$$], {3, 3}], 
                "\[Degree]2\[Theta] (", 
                
                NumberForm[$CellContext`GaussIB[$CellContext`\[Sigma]$$] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {}, {
                Text[
                 Style["Parameter Lorentzian", Bold, 20]]}, {"Lorentz fwhm", 
                NumberForm[
                 $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 3}], 
                "\[Degree]2\[Theta] (", 
                
                NumberForm[$CellContext`Lorentzfwhm[$CellContext`\[Delta]$$] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {"Lorentz IB  ", 
                NumberForm[
                 $CellContext`LorentzIB[$CellContext`\[Delta]$$], {3, 3}], 
                "\[Degree]2\[Theta] (", 
                
                NumberForm[$CellContext`LorentzIB[$CellContext`\[Delta]$$] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}}, Frame -> True, 
              ItemStyle -> Directive[FontSize -> 18, Bold]], " ", 
             Grid[{{
                Text[
                 Style["Parameter Voigt", Bold, 20]]}, {"Voigt   fwhm", 
                NumberForm[
                 $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 3}], "\[Degree]2\[Theta] (", 
                
                NumberForm[$CellContext`Voigtfwhm[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$] $CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {"Voigt   IB  ", 
                NumberForm[
                 $CellContext`VoigtIB[
                  $CellContext`LorentzIB[$CellContext`\[Delta]$$], 
                  $CellContext`GaussIB[$CellContext`\[Sigma]$$]], {3, 3}], 
                "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`VoigtIB[
                   $CellContext`LorentzIB[$CellContext`\[Delta]$$], 
                   $CellContext`GaussIB[$CellContext`\[Sigma]$$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {
               "Lorentz  part ", 
                NumberForm[$CellContext`mix$ 100, {3, 1}], "%"}, {
               "Gauss    part ", 
                NumberForm[100 - $CellContext`mix$ 100, {3, 1}], "%"}, {}, {
               "FT       fwhm", 
                NumberForm[$CellContext`fwhmFT$, {5, 1}], "nm"}, {
               "LVol     fwhm", 
                NumberForm[
                1/($CellContext`Voigtfwhm[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$] $CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$]), {5, 1}], "nm"}, {"LVol     IB  ", 
                NumberForm[1/($CellContext`VoigtIB[
                   $CellContext`LorentzIB[$CellContext`\[Delta]$$], 
                   $CellContext`GaussIB[$CellContext`\[Sigma]$$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$]), {5, 1}], "nm"}, {"e0           ", 
                NumberForm[$CellContext`VoigtIB[
                   $CellContext`LorentzIB[$CellContext`\[Delta]$$], 
                   $CellContext`GaussIB[$CellContext`\[Sigma]$$]] ((Pi/360)/
                  4), {2, 4}]}}, Frame -> True, ItemStyle -> 
              Directive[FontSize -> 18, Bold]]}]}]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.03, ""}, 1.*^-6, 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.03, ""}, 1.*^-6, 1., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`\[Lambda]$$, 0.154059, ""}, 0.01, 0.3, 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`ss0$$, 5., ""}, 0.001, 
         Dynamic[2./$CellContext`\[Lambda]$$], ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 4}, 
        Grid[{{"\[Delta]      ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma]      ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"wavelength ", 
           Manipulate`Place[3], "nm"}, {
          "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
           Manipulate`Place[4], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
          "peak center (d)", 
           Dynamic[
            NumberForm[1/$CellContext`ss0$$, {3, 5}]], "nm"}, {
          "peak center (2\[Theta])", 
           Dynamic[
            NumberForm[
             $CellContext`\[Theta]2[$CellContext`ss0$$, \
$CellContext`\[Lambda]$$], {3, 5}]], "\[Degree]"}}], 
        Delimiter, {{$CellContext`xMag$$, 1., ""}, 1., 10., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`diffMag$$, 1., ""}, 1., 10., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 6}, 
        Grid[{{"x-axis spread             ", 
           Manipulate`Place[5]}, {"difference plot magnifier ", 
           Manipulate`Place[6]}}], 
        Delimiter, {{$CellContext`methods$$, "Reichel approx.", "function"}, {
         "Voigt", "Reichel approx."}, ControlType -> RadioButton, Appearance -> 
         "Vertical"}, 
        Delimiter, {{$CellContext`space$$, "2\[Theta]", "space"}, {
         "2\[Theta]", "\!\(\*SuperscriptBox[\(d\), \(*\)]\)"}, ControlType -> 
         RadioButton, Appearance -> "Vertical"}, 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier  & Paolo Scardi", "", 
          "Voigt & modified Thompson-Cox-Hastings (TCHZ) Pseudo-Voigt \
function\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 20], ControlPlacement -> {Left}, 
        ControlPlacement -> {Left}, ContinuousAction -> False, TrackedSymbols -> 
        True}, "DefaultOptions" :> {}],
     ImageSizeCache->{1644., {548., 554.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`fwhm = 
       0., $CellContext`abscissae = {-2, (-23)/12, (-11)/6, (-7)/4, (-5)/
         3, (-19)/12, (-3)/2, (-17)/12, (-4)/3, (-5)/4, (-7)/6, (-13)/
         12, -1, (-11)/12, (-5)/6, (-3)/4, (-2)/3, (-7)/12, (-1)/2, (-5)/
         12, (-1)/3, (-1)/4, (-1)/6, (-1)/12, 0}, $CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`\[Lambda]$$ = 
       0.14249059611887502`, $CellContext`\[Sigma]$$ = 
       0.3, $CellContext`Voigtfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Module[{$CellContext`fg = 
          Sqrt[8 Log[2]] $CellContext`\[Sigma], $CellContext`fl = 
          2 $CellContext`\[Delta]}, 0.5346 $CellContext`fl + 
         Sqrt[0.2166 $CellContext`fl $CellContext`fl + $CellContext`fg \
$CellContext`fg]], $CellContext`cs[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := ($CellContext`\[Theta]2 Degree) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`cs[
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := (Pi/180) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`Mix[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Block[{$CellContext`FWHMg = $CellContext`\[Sigma] 
           Sqrt[8 Log[2]], $CellContext`FWHMl = 
          2 $CellContext`\[Delta], $CellContext`FWHMv = ($CellContext`FWHMl^5 + \
$CellContext`FWHMg^5 + 2.69296 $CellContext`FWHMg^4 $CellContext`FWHMl + 
            2.42843 $CellContext`FWHMg^3 $CellContext`FWHMl^2 + 
            4.47163 $CellContext`FWHMg^2 $CellContext`FWHMl^3 + 
            0.07842 $CellContext`FWHMg $CellContext`FWHMl^4)^(1/
            5), $CellContext`\[Eta]}, $CellContext`\[Eta] = \
$CellContext`FWHMl/$CellContext`FWHMv; $CellContext`\[Eta] = $CellContext`\
\[Eta] (1.36603 - 0.47719 $CellContext`\[Eta] + 
            0.11116 $CellContext`\[Eta]^2); Null], $CellContext`FTVoigtfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := (-$CellContext`\[Delta] + 
         Sqrt[$CellContext`\[Delta]^2 + $CellContext`\[Sigma]^2 
            Log[4]])/($CellContext`\[Sigma]^2 Pi), $CellContext`VoigtTable[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`abscissae, 
          Blank[]]] := Chop[
         $CellContext`Voigt[$CellContext`\[Delta], $CellContext`\[Sigma], \
$CellContext`x0, $CellContext`abscissae]], $CellContext`Voigt[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       Re[Erfc[(
             I ($CellContext`x - $CellContext`x0) + $CellContext`\[Delta])/(
            Sqrt[2] $CellContext`\[Sigma])]/
          E^((($CellContext`x - $CellContext`x0) - 
             I $CellContext`\[Delta])^2/(2 $CellContext`\[Sigma]^2))]/(
        Sqrt[2 Pi] $CellContext`\[Sigma]), $CellContext`VoigtApproxTable[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`abscissae, 
          Blank[]]] := Chop[
         $CellContext`VoigtApprox[$CellContext`\[Delta], \
$CellContext`\[Sigma], $CellContext`x0, $CellContext`abscissae]], \
$CellContext`VoigtApprox = CompiledFunction[{11, 12.1, 5596}, {
          Blank[Real], 
          Blank[Real], 
          Blank[Real], 
          Blank[Real]}, {{3, 0, 0}, {3, 0, 1}, {3, 0, 2}, {3, 0, 3}, {3, 0, 
         4}}, {{4, {2, 0, 4}}, {1.4142135623730951`, {3, 0, 7}}, {
          0. + 1. I, {4, 0, 0}}, {{0.933757118080976, 0.760213717643091, 
           0.5396414858162972, 0.3339971859861318, 0.18023873770401833`, 
           0.0848049724711138, 0.03479063445952838, 0.012444321744005098`, 
           0.003881038619955638, 0.0010553403629220352`, 
           0.00025021018490812164`, 0.00005172318620381234, 
           9.322521791405033*^-6, 1.4650397062886184`*^-6, 
           2.0073968320415233`*^-7, 2.3981973818259457`*^-8, 
           2.4980692045821277`*^-9, 2.268777244353523*^-10, 
           1.7965822334136586`*^-11, 1.2404240973367864`*^-12, 
           7.467257702018301*^-14, 3.919403132680891*^-15, 
           1.7936866768385383`*^-16, 7.157165835186059*^-18}, {3, 1, 0}}, {
          2.5066282746310002`, {3, 0, 8}}, {{0.2617993877991494, 
           0.5235987755982988, 0.7853981633974483, 1.0471975511965976`, 
           1.3089969389957472`, 1.5707963267948966`, 1.8325957145940461`, 
           2.0943951023931953`, 2.356194490192345, 2.6179938779914944`, 
           2.8797932657906435`, 3.141592653589793, 3.4033920413889422`, 
           3.6651914291880923`, 3.9269908169872414`, 4.1887902047863905`, 
           4.4505895925855405`, 4.71238898038469, 4.974188368183839, 
           5.235987755982989, 5.497787143782138, 5.759586531581287, 
           6.021385919380437, 6.283185307179586}, {3, 1, 4}}, {
          2, {2, 0, 2}}, {{-1., 1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 
           1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 1.}, {3, 1, 
           1}}, {-1, {2, 0, 3}}, {12, {2, 0, 0}}, {1, {2, 0, 1}}, {
          0., {3, 0, 6}}}, {0, 5, 10, 6, 
         6}, {{19, 2, 4}, {13, 3, 4, 5}, {11, 0, 6, 1}, {17, 0, 1, 2}, {11, 5,
           6, 1}, {14, 1, 2, 1}, {16, 1, 7, 4}, {40, 60, 3, 0, 4, 3, 0, 5}, {
          11, 5, 6, 2}, {17, 1, 2, 1}, {10, 0, 5}, {11, 5, 6, 2}, {17, 0, 2, 
          1, 3}, {40, 32, 4, 0, 3, 4, 0, 2}, {20, 2, 3}, {10, 1, 5}, {11, 5, 
          6, 4}, {14, 4, 3, 4}, {10, 0, 5}, {11, 5, 6, 3}, {17, 3, 1, 3}, {40,
           60, 4, 0, 3, 4, 0, 5}, {17, 4, 5, 4}, {17, 0, 4, 5}, {10, 0, 5}, {
          40, 60, 3, 0, 5, 3, 0, 4}, {11, 4, 6, 4}, {17, 1, 4, 3}, {10, 2, 
          4}, {11, 4, 6, 4}, {17, 4, 0, 3, 4}, {41, 259, 4, 0, 2, 3, 1, 1, 4, 
          1, 2}, {41, 257, 2, 0, 3, 4, 1, 2, 4, 1, 3}, {41, 257, 4, 0, 1, 3, 
          1, 4, 4, 1, 2}, {20, 1, 3}, {41, 257, 4, 0, 3, 3, 1, 4, 4, 1, 5}, {
          45, 2, 5, 2}, {40, 60, 4, 1, 2, 4, 1, 5}, {45, 3, 5, 3}, {
          42, "CoerceTensor", 2, 0, 4, 3, 1, 0, 4, 1, 5}, {
          42, "DotVV", 4, 1, 5, 4, 1, 3, 2, 0, 4, 4, 0, 3}, {17, 4, 3, 4}, {
          14, 5, 4, 5}, {40, 42, 4, 0, 5, 3, 0, 4}, {16, 1, 8, 5}, {40, 60, 3,
           0, 5, 3, 0, 9}, {16, 4, 9, 4}, {1}}, 
         Function[{$CellContext`\[Delta], $CellContext`\[Sigma], \
$CellContext`x0, $CellContext`x}, 
          
          Module[{$CellContext`z$ = (($CellContext`x - $CellContext`x0) + 
              I $CellContext`\[Delta])/($CellContext`\[Sigma] 
             1.4142135623730951`), $CellContext`e$}, $CellContext`e$ = 
            Exp[I 12 $CellContext`z$]; 
           Re[I ((1 - $CellContext`e$)/(12 $CellContext`z$)) + (2 
                I ($CellContext`z$/12)) 
               Dot[{0.933757118080976, 0.760213717643091, 0.5396414858162972, 
                 0.3339971859861318, 0.18023873770401833`, 0.0848049724711138,
                  0.03479063445952838, 0.012444321744005098`, 
                 0.003881038619955638, 0.0010553403629220352`, 
                 0.00025021018490812164`, 0.00005172318620381234, 
                 9.322521791405033*^-6, 1.4650397062886184`*^-6, 
                 2.0073968320415233`*^-7, 2.3981973818259457`*^-8, 
                 2.4980692045821277`*^-9, 2.268777244353523*^-10, 
                 1.7965822334136586`*^-11, 1.2404240973367864`*^-12, 
                 7.467257702018301*^-14, 3.919403132680891*^-15, 
                 1.7936866768385383`*^-16, 
                 7.157165835186059*^-18}, ($CellContext`e$ {-1., 1., -1., 
                    1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 
                    1., -1., 1., -1., 1., -1., 1., -1., 1.} - 
                  1)/(({0.2617993877991494, 0.5235987755982988, 
                   0.7853981633974483, 1.0471975511965976`, 
                   1.3089969389957472`, 1.5707963267948966`, 
                   1.8325957145940461`, 2.0943951023931953`, 
                   2.356194490192345, 2.6179938779914944`, 
                   2.8797932657906435`, 3.141592653589793, 
                   3.4033920413889422`, 3.6651914291880923`, 
                   3.9269908169872414`, 4.1887902047863905`, 
                   4.4505895925855405`, 4.71238898038469, 4.974188368183839, 
                   5.235987755982989, 5.497787143782138, 5.759586531581287, 
                   6.021385919380437, 6.283185307179586} + $CellContext`z$) ({
                   0.2617993877991494, 0.5235987755982988, 0.7853981633974483,
                    1.0471975511965976`, 1.3089969389957472`, 
                   1.5707963267948966`, 1.8325957145940461`, 
                   2.0943951023931953`, 2.356194490192345, 
                   2.6179938779914944`, 2.8797932657906435`, 
                   3.141592653589793, 3.4033920413889422`, 
                   3.6651914291880923`, 3.9269908169872414`, 
                   4.1887902047863905`, 4.4505895925855405`, 4.71238898038469,
                    4.974188368183839, 5.235987755982989, 5.497787143782138, 
                   5.759586531581287, 6.021385919380437, 
                   6.283185307179586} - $CellContext`z$))]]/($CellContext`\
\[Sigma] 2.5066282746310002`)], Listable], Evaluate], 
       Attributes[$CellContext`z$] = {Temporary}, 
       Attributes[$CellContext`e$] = {
        Temporary}, $CellContext`TCHPseudoVoigtTable[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`abscissae, 
          Blank[]]] := Chop[
         $CellContext`TCHPseudoVoigt[$CellContext`\[Delta], $CellContext`\
\[Sigma], $CellContext`x0, $CellContext`abscissae]], \
$CellContext`TCHPseudoVoigt[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       Block[{$CellContext`FWHMg = $CellContext`\[Sigma] 
           Sqrt[8 Log[2]], $CellContext`FWHMl = 
          2 $CellContext`\[Delta], $CellContext`FWHMv = ($CellContext`FWHMl^5 + \
$CellContext`FWHMg^5 + 2.69296 $CellContext`FWHMg^4 $CellContext`FWHMl + 
            2.42843 $CellContext`FWHMg^3 $CellContext`FWHMl^2 + 
            4.47163 $CellContext`FWHMg^2 $CellContext`FWHMl^3 + 
            0.07842 $CellContext`FWHMg $CellContext`FWHMl^4)^(1/
            5), $CellContext`\[Eta]}, $CellContext`\[Eta] = \
$CellContext`FWHMl/$CellContext`FWHMv; $CellContext`\[Eta] = $CellContext`\
\[Eta] (1.36603 - 0.47719 $CellContext`\[Eta] + 
            0.11116 $CellContext`\[Eta]^2); (
            1 - $CellContext`\[Eta]) $CellContext`Gauss2[$CellContext`FWHMv/
             Sqrt[8 Log[
               2]], $CellContext`x0, $CellContext`x] + $CellContext`\[Eta] \
$CellContext`Lorentz[$CellContext`FWHMv/
             2, $CellContext`x0, $CellContext`x]], $CellContext`Gauss2[
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       1/((Sqrt[2 Pi] $CellContext`\[Sigma]) 
        E^(($CellContext`x - $CellContext`x0)^2/(
          2 $CellContext`\[Sigma]^2))), $CellContext`Lorentz[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := (1/(Pi $CellContext`\[Delta])) (1/(
         1 + (($CellContext`x - $CellContext`x0)/$CellContext`\[Delta])^2)), \
$CellContext`filePath = 
       "C:\\Users\\dinne\\DeskTop\\Voigt_function.jpg", $CellContext`Gaussfwhm[
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       2 Sqrt[2 Log[2]] $CellContext`\[Sigma], $CellContext`GaussIB[
         Pattern[$CellContext`fwhm, 
          Blank[]]] := $CellContext`fwhm 
        Sqrt[Pi/(4 Log[2])], $CellContext`Lorentzfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]]] := 2 $CellContext`\[Delta], $CellContext`LorentzIB[
         Pattern[$CellContext`fwhm, 
          Blank[]]] := $CellContext`fwhm (Pi/2), $CellContext`VoigtIB[
         Pattern[$CellContext`IBGauss, 
          Blank[]], 
         Pattern[$CellContext`IBLorentz, 
          Blank[]]] := Condition[
         Module[{$CellContext`k = $CellContext`IBLorentz/(
            Sqrt[Pi] $CellContext`IBGauss)}, $CellContext`IBGauss (1/(
           E^($CellContext`k^2) Erfc[$CellContext`k]))], $CellContext`IBGauss > 
         1.*^-6], $CellContext`VoigtIB[
         Pattern[$CellContext`IBGauss, 
          Blank[]], 
         Pattern[$CellContext`IBLorentz, 
          Blank[]]] := 
       Module[{$CellContext`k = $CellContext`IBLorentz/(
           Sqrt[Pi] $CellContext`IBGauss)}, $CellContext`IBGauss (1/(
          E^($CellContext`k^2) Erfc[$CellContext`k]))], $CellContext`k[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       1/$CellContext`s[$CellContext`\[Theta]2, $CellContext`\[Lambda]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.8139278999272056`*^9, 3.8139279080208497`*^9}, 
   3.81392899324445*^9, 3.8139290614021997`*^9, 3.8139305727250338`*^9, 
   3.8139889851133833`*^9, 3.8140040586942034`*^9, 3.814004904485207*^9, 
   3.8140096497502527`*^9, 3.8170066243736076`*^9, 3.8170112889938316`*^9, 
   3.8170127049184875`*^9, 3.8170185347240133`*^9, 3.8170266956935053`*^9, 
   3.8170306282894692`*^9, 3.8171002448857546`*^9, 3.817100422214856*^9, 
   3.817100485447585*^9, 3.8171056586913576`*^9, 3.817110737810355*^9, 
   3.8171290527349377`*^9, 3.8171291435698156`*^9, 3.817129430605214*^9, 
   3.817129463951465*^9, 3.817129495188113*^9, 3.817130020207267*^9, 
   3.817132185630912*^9, 3.817132882603809*^9, 3.817133921714902*^9, 
   3.8171341130987024`*^9, 3.8171341800234327`*^9, 3.817134244604061*^9, 
   3.8171343489212637`*^9, 3.817135459247678*^9, 3.8171371321991386`*^9, {
   3.8171862088190894`*^9, 3.8171862309914474`*^9}, 3.817186306836645*^9, 
   3.8171863783845587`*^9, 3.817186411994375*^9, {3.81718648057345*^9, 
   3.817186522901981*^9}, 3.8171866144350567`*^9, 3.817186655419675*^9, 
   3.8171870038940506`*^9, {3.81718712778651*^9, 3.817187142083213*^9}, 
   3.817187192865211*^9, 3.817187455666357*^9, 3.8171884571026354`*^9, 
   3.81718857896399*^9, 3.817191602542217*^9, {3.81884431094577*^9, 
   3.8188443337743*^9}, 3.820118102325162*^9, 3.820588858451583*^9, {
   3.8206466515735826`*^9, 3.82064667205702*^9}, 3.8235869009120827`*^9, 
   3.824284230166554*^9, 3.824295223545291*^9, {3.8242955191032753`*^9, 
   3.8242955427918015`*^9}, 3.82429600524661*^9, 3.8242979348611984`*^9, 
   3.8242983104355507`*^9, 3.824298534958413*^9, 3.824300924420722*^9, 
   3.824303269749153*^9, 3.8243066770655117`*^9, 3.824307643008916*^9, 
   3.824355068632304*^9, 3.824357635489976*^9, 3.824363198666938*^9, 
   3.824363645040457*^9, 3.8243818439094973`*^9, 3.8243824859849*^9, 
   3.824639894704235*^9, 3.8246399749402256`*^9, 3.8246401926994677`*^9, {
   3.824640315853736*^9, 3.8246403245417223`*^9}, 3.8246403901213827`*^9, {
   3.824640807474266*^9, 3.8246408270525274`*^9}, 3.8246408809340873`*^9, 
   3.824640928570285*^9, 3.8246410667922707`*^9, 3.824641115324411*^9, 
   3.8246411793100133`*^9, 3.8246413785018682`*^9, 3.82464146661331*^9, 
   3.824641532286525*^9, 3.8246415819125032`*^9, 3.824641619091776*^9, 
   3.824641668961619*^9, 3.8246417309625263`*^9, 3.824643427514426*^9, 
   3.824960110755684*^9, {3.8249601922417765`*^9, 3.8249602102421794`*^9}, 
   3.8249607603941317`*^9, 3.825475293998318*^9, 3.82685969999594*^9, 
   3.826863163272369*^9, 3.826864376110388*^9, 3.826867903398162*^9, 
   3.826868105167918*^9, 3.8278364999672985`*^9, {3.827836567938097*^9, 
   3.8278365934110537`*^9}, 3.8278366579407444`*^9, 3.8278367651231623`*^9, 
   3.827836849883161*^9, 3.8278375424169436`*^9, 3.827914439211372*^9, 
   3.8279155170470037`*^9, 3.8279155551970663`*^9, 3.827916707972165*^9, 
   3.827916891629031*^9, 3.827976007119817*^9, 3.8279763265499663`*^9, {
   3.8280891072005877`*^9, 3.8280891220527873`*^9}, 3.8280891763230557`*^9, 
   3.8280892683485527`*^9, 3.828091188338038*^9, 3.8280918116829605`*^9, 
   3.8280928584367027`*^9, 3.828092912605024*^9, 3.8281057703175755`*^9, 
   3.8281060395513153`*^9, 3.8281061514829793`*^9, 3.8281553858180037`*^9, 
   3.8281560203042593`*^9, 3.828160046830312*^9, 3.8281611910613885`*^9, {
   3.8281612991625366`*^9, 3.8281613225030937`*^9}, 3.828161457062709*^9, 
   3.828161649907558*^9, 3.828162579339902*^9, 3.8281708410230427`*^9, 
   3.828171030614453*^9, {3.8281710623620176`*^9, 3.8281710800641203`*^9}, 
   3.828171266615902*^9, {3.828171781648244*^9, 3.8281718116564713`*^9}, 
   3.828173724172389*^9, 3.828502152440319*^9, 3.828503480766531*^9, 
   3.828579447870553*^9, 3.8285811359694953`*^9, 3.8285830517933564`*^9, 
   3.828584241482428*^9, 3.8285916710235753`*^9, 3.828592090773018*^9, 
   3.828593117736968*^9, 3.8285934317757115`*^9, 3.828593976061226*^9, 
   3.829800358172338*^9, 3.829800490524086*^9, 3.8298073942586937`*^9, 
   3.8298075054435234`*^9, 3.8298076231089125`*^9, 3.8298077121304026`*^9, 
   3.829807809028617*^9, {3.82980918128338*^9, 3.829809187465176*^9}, 
   3.829965133102441*^9, {3.829967661975981*^9, 3.8299676967265096`*^9}, 
   3.829968398386468*^9, 3.8299686208455873`*^9, 3.8299687485522127`*^9, {
   3.829968976636381*^9, 3.8299690063560877`*^9}, 3.830585914671804*^9, 
   3.8305860057723193`*^9, {3.8305877055936394`*^9, 3.8305877332286386`*^9}, 
   3.830588009315192*^9, 3.83059037111183*^9, 3.8305912945906997`*^9, 
   3.830591327194552*^9, 3.8305915195902576`*^9, 3.8305917199458733`*^9, 
   3.8305918191130805`*^9, 3.8305918641130686`*^9, 3.830591920943349*^9, 
   3.830594799566752*^9, 3.8305950108237247`*^9, 3.8316164625119376`*^9, 
   3.8316167310576677`*^9, 3.831616766512478*^9, 3.8316168172024803`*^9, 
   3.8316168491104603`*^9, {3.8316169769292183`*^9, 3.8316170224470625`*^9}, 
   3.8316187352499876`*^9, 3.831618770876093*^9, 3.831618808846085*^9, {
   3.8316188605976467`*^9, 3.8316189105996714`*^9}, {3.831618994258485*^9, 
   3.8316190393221684`*^9}, 3.8321437326826377`*^9, 3.8321444325399466`*^9, 
   3.8321445478617706`*^9, 3.832144612736632*^9, 3.8321446566841946`*^9, 
   3.8321447766509447`*^9, 3.832144816322995*^9, 3.8321449518132534`*^9, 
   3.8321450259967318`*^9, 3.832145064005906*^9, 3.832145173512825*^9, 
   3.851048136167286*^9, 3.8510501705469947`*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"caa186c8-a604-428f-a752-494739b0f746"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Comparison of Voigt  with TCH-Pseudo-Voigt distributions in 3D\n", 
  "Chapter"],
 StyleBox["(maximum deviation at the peak centre in dependence on sigma and \
delta)", "Chapter",
  FontSize->16]
}], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.813499782848096*^9}, {3.813500130542923*^9, 
  3.8135001629185205`*^9}, {3.8171818851555405`*^9, 3.8171818873119135`*^9}},
 CellTags->"Title",ExpressionUUID->"0340cefc-178d-4c9b-9190-a0ac4ced514a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "@", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "TablePseudoVoigt", ",", " ", "TableVoigtApprox", ",", " ", 
        "TableDiff", ",", " ", "HMax", ",", " ", "PMaxIndex", ",", " ", 
        "PMax", ",", " ", "level", ",", " ", "slice", ",", " ", "potential", 
        ",", "gr"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"TablePseudoVoigt", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"TCHPseudoVoigt", "[", 
           RowBox[{"delta", ",", "sigma", ",", "0.0", ",", " ", "pos"}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"delta", ",", " ", "0.01", ",", "max\[Delta]", ",", " ", 
            RowBox[{"max\[Delta]", "/", "50"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"sigma", ",", "0.01", ",", "max\[Sigma]", ",", 
            RowBox[{"max\[Sigma]", "/", "50"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"TableVoigtApprox", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"VoigtApprox", "[", "      ", 
           RowBox[{"delta", ",", "sigma", ",", "0.0", ",", " ", "pos"}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"delta", ",", " ", "0.01", ",", "max\[Delta]", ",", " ", 
            RowBox[{"max\[Delta]", "/", "50"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"sigma", ",", "0.01", ",", "max\[Sigma]", ",", 
            RowBox[{"max\[Sigma]", "/", "50"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"TableDiff", "                ", "=", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"TableVoigtApprox", "-", "TablePseudoVoigt"}], "]"}], "//", 
         "Chop"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"HMax", "                            ", "=", 
        RowBox[{"Max", "[", "TableDiff", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"PMaxIndex", "                 ", "=", 
        RowBox[{"Position", "[", 
         RowBox[{"TableDiff", ",", "HMax"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"PMax", "                            ", "=", 
        RowBox[{
         RowBox[{"PMaxIndex", "*", "0.01"}], "+", "0.01"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"level", "                          ", "=", 
        RowBox[{"-", "0.02"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"slice", "=", 
        RowBox[{"ListContourPlot", "[", 
         RowBox[{
         "TableDiff", ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"DataRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.01", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.01", ",", "0.5"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "\t\t\t      ", 
          RowBox[{"ContourLabels", "\[Rule]", "All"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"BaseStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"FontSize", "\[Rule]", "20"}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"Frame", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ","}], " ", 
           "*)"}], "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"Axes", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"False", ",", "False"}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"Contours", "\[Rule]", "15"}], ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"ImageSize", "\[Rule]", "1000"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "0.03", "]"}], ",", "Red", ",", 
             RowBox[{"Point", "[", "PMax", "]"}]}], "}"}]}]}], " ", 
         "\[IndentingNewLine]", "                           ", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"potential", "=", 
        RowBox[{"ListPlot3D", "[", 
         RowBox[{
         "TableDiff", ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"DataRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.01", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.01", ",", "0.5"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "\t\t                ", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"PlotLegends", "\[Rule]", "All"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"AxesLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\[Delta] (\[Degree]2\[Theta])\>\"", ",", 
             "\"\<\[Sigma] (\[Degree]2\[Theta])\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"ClippingStyle", "\[Rule]", "None"}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"MeshFunctions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"#3", "&"}], "}"}]}], ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
          RowBox[{"MeshStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".5", "]"}]}], ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"MeshShading", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Opacity", "[", ".3", "]"}], ",", "Blue"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Opacity", "[", ".8", "]"}], ",", "Orange"}], "}"}]}], 
            "}"}]}], ",", "\[IndentingNewLine]", 
          "                                  ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "Automatic", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0.015"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
          "\[IndentingNewLine]", "                                  ", 
          RowBox[{"ImageSize", "\[Rule]", "1000"}]}], "\[IndentingNewLine]", 
         "                            ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"gr", "                  ", "=", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Texture", "[", "slice", "]"}], ",", 
            RowBox[{"EdgeForm", "[", "]"}], ",", 
            RowBox[{"Polygon", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01", ",", "0.01", ",", "level"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.01", ",", "level"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5", ",", "level"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.01", ",", "0.5", ",", "level"}], "}"}]}], "}"}], 
              ",", 
              RowBox[{"VertexTextureCoordinates", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "1"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}],
           ",", "\[IndentingNewLine]", 
          "                                                  ", 
          RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"export", ",", 
         RowBox[{"{", "\[IndentingNewLine]", "                       ", 
          RowBox[{
           RowBox[{"Export", "[", 
            RowBox[{"filePath", ",", 
             RowBox[{"{", 
              RowBox[{"potential", ",", "gr"}], "}"}]}], "]"}], ",", " ", 
           "\[IndentingNewLine]", "                       ", 
           RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
          "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
        "]"}], ";", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Show", "[", 
        RowBox[{"potential", ",", "gr", ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"BoxRatios", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", ".6"}], "}"}]}], ",", 
         RowBox[{"FaceGrids", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Back", ",", "Left"}], "}"}]}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "              ", 
      RowBox[{
       RowBox[{"{", "   ", 
        RowBox[{"\"\<max. \[Delta]          \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"max\[Delta]", ",", "0.5", ",", "\"\<\>\""}], "}"}], ",",
             "0.1", ",", " ", "1.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", "              ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<max. \[Sigma]          \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"max\[Sigma]", ",", "0.5", ",", "\"\<\>\""}], "}"}], ",",
             "0.1", ",", " ", "1.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", 
       "\[IndentingNewLine]", "              ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<max. Gauss   fwhm\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"Gaussfwhm", "[", "max\[Sigma]", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
         "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "              ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<max. Lorentz fwhm\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"Lorentzfwhm", "[", "max\[Delta]", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
         "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "              ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<max. Voigt   fwhm\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"Voigtfwhm", "[", 
             RowBox[{"max\[Delta]", ",", "max\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
         "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "            ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<rel. pos.         \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"pos", ",", "0.0", ",", "\"\<\>\""}], "}"}], ",", " ", 
            RowBox[{"-", "3."}], ",", "3.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", " ", "\"\<\[Degree]2\[Theta]\>\""}], "}"}]}], "  ", 
      "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Export to desktop\>\"", ",", 
      RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier  & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", 
       " ", "\"\<Difference betweeen Voigt (Reichel approx.) & \
TCHZ-Pseudo-Voigt function\\n\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "20"}], "]"}]}], ",", " ", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "->", "True"}]}], " ", "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzltIU3EAx/FtGhOHEqIgEeVlTQQngmLiJnms5V3BK3sQRNl0WzARFwR5
GXJEHaEPbixFodLpw3HIUXTMC96QlaMHjVmyboKEcoJpZC3J+f+dhx+fl9/D
N7HJWKURCQQCGRn8LVM5Z3UcZajO/QBv10s+wfdG8znsEd4UOolZ4oMIyFiS
o+BKUmkyDDBv0mFcljYTPlksug+P8wx58NtjZSHsLI0pg4dPDUYPsWMwaIIv
E8K74FGKvBuuKv7SMEah7IOPilItcK2M5f3q2xuCLvXcMHT+DxuH0d0PePut
pin4wr7kgIuJ2x879Rw1dOeU16a2ibuIjM/BGzvyJdDaxlHS18wv6HCnBqF3
33QFY5tVIh1xondMAneKoycGiezbQt6OMzULGwLCeWjNca3Ai2zHKlw3v/JD
d8jzGYo2nh3xP/PZMWT+sSdw4dz/E4b/2PwDZRs5QRi4lIgtxPjJyAh4leJV
wFuVISXci9rKh4dujQpqtaESmB6cLocZ360stHtMC1Dg33ZBpjdjGdr0z2k7
seRklNe7ppey6C7g7kH5/lYt3cNRFQl3G+HuZpUGSusuWmC77pK+QXNUblrN
AGxPklTPEN899PFeA5IzQ3A=
  "],
 CellLabel->
  "In[134]:=",ExpressionUUID->"92d0540f-5a5b-4b9c-9786-2121cf197d90"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`export$$ = 
    False, $CellContext`max\[Delta]$$ = 0.5, $CellContext`max\[Sigma]$$ = 
    0.5, $CellContext`pos$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`max\[Delta]$$], 0.5, ""}, 0.1, 1.}, {{
       Hold[$CellContext`max\[Sigma]$$], 0.5, ""}, 0.1, 1.}, {{
       Hold[$CellContext`pos$$], 0., ""}, -3., 3.}, {
      Hold[
       Grid[{{"max. \[Delta]          ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {
         "max. \[Sigma]          ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"max. Gauss   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`max\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"max. Lorentz fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`max\[Delta]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"max. Voigt   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`max\[Delta]$$, \
$CellContext`max\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {
         "rel. pos.         ", 
          Manipulate`Place[3], "\[Degree]2\[Theta]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1047., {485., 490.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`export$$ = 
        False, $CellContext`max\[Delta]$$ = 0.5, $CellContext`max\[Sigma]$$ = 
        0.5, $CellContext`pos$$ = 0.}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`TablePseudoVoigt$, $CellContext`TableVoigtApprox$, \
$CellContext`TableDiff$, $CellContext`HMax$, $CellContext`PMaxIndex$, \
$CellContext`PMax$, $CellContext`level$, $CellContext`slice$, \
$CellContext`potential$, $CellContext`gr$}, $CellContext`TablePseudoVoigt$ = 
         Table[
           $CellContext`TCHPseudoVoigt[$CellContext`delta, $CellContext`sigma,
             0., $CellContext`pos$$], {$CellContext`delta, 
            0.01, $CellContext`max\[Delta]$$, $CellContext`max\[Delta]$$/
            50}, {$CellContext`sigma, 
            0.01, $CellContext`max\[Sigma]$$, $CellContext`max\[Sigma]$$/
            50}]; $CellContext`TableVoigtApprox$ = Table[
           $CellContext`VoigtApprox[$CellContext`delta, $CellContext`sigma, 
            0., $CellContext`pos$$], {$CellContext`delta, 
            0.01, $CellContext`max\[Delta]$$, $CellContext`max\[Delta]$$/
            50}, {$CellContext`sigma, 
            0.01, $CellContext`max\[Sigma]$$, $CellContext`max\[Sigma]$$/
            50}]; $CellContext`TableDiff$ = Chop[
           
           Abs[$CellContext`TableVoigtApprox$ - \
$CellContext`TablePseudoVoigt$]]; $CellContext`HMax$ = 
         Max[$CellContext`TableDiff$]; $CellContext`PMaxIndex$ = 
         Position[$CellContext`TableDiff$, $CellContext`HMax$]; \
$CellContext`PMax$ = $CellContext`PMaxIndex$ 0.01 + 
          0.01; $CellContext`level$ = -0.02; $CellContext`slice$ = 
         ListContourPlot[$CellContext`TableDiff$, 
           DataRange -> {{0.01, 0.5}, {0.01, 0.5}}, ContourLabels -> All, 
           BaseStyle -> {FontSize -> 20}, Frame -> False, InterpolationOrder -> 
           1, PlotRange -> Automatic, Axes -> {False, False}, Contours -> 15, 
           PlotRangePadding -> 0, ColorFunction -> "DarkRainbow", ImageSize -> 
           1000, Epilog -> {
             PointSize[0.03], Red, 
             Point[$CellContext`PMax$]}]; $CellContext`potential$ = 
         ListPlot3D[$CellContext`TableDiff$, 
           DataRange -> {{0.01, 0.5}, {0.01, 0.5}}, InterpolationOrder -> 1, 
           PlotLegends -> All, 
           AxesLabel -> {
            "\[Delta] (\[Degree]2\[Theta])", "\[Sigma] (\[Degree]2\[Theta])"},
            LabelStyle -> Directive[Bold, 16], ClippingStyle -> None, 
           MeshFunctions -> {#3& }, Mesh -> 15, MeshStyle -> Opacity[0.5], 
           MeshShading -> {{
              Opacity[0.3], Blue}, {
              Opacity[0.8], Orange}}, 
           PlotRange -> {Automatic, Automatic, {0, 0.015}}, Lighting -> 
           "Neutral", ImageSize -> 1000]; $CellContext`gr$ = Graphics3D[{
            Texture[$CellContext`slice$], 
            EdgeForm[], 
            
            Polygon[{{0.01, 0.01, $CellContext`level$}, {
              0.5, 0.01, $CellContext`level$}, {
              0.5, 0.5, $CellContext`level$}, {
              0.01, 0.5, $CellContext`level$}}, 
             VertexTextureCoordinates -> {{0, 0}, {1, 0}, {1, 1}, {0, 1}}]}, 
           Lighting -> "Neutral"]; If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`potential$, \
$CellContext`gr$}], $CellContext`export$$ = False}]; 
        Show[$CellContext`potential$, $CellContext`gr$, PlotRange -> All, 
          BoxRatios -> {1, 1, 0.6}, FaceGrids -> {Back, Left}]], 
      "Specifications" :> {{{$CellContext`max\[Delta]$$, 0.5, ""}, 0.1, 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`max\[Sigma]$$, 0.5, ""}, 0.1, 1., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         2}, {{$CellContext`pos$$, 0., ""}, -3., 3., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 3}, 
        Grid[{{"max. \[Delta]          ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {
          "max. \[Sigma]          ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"max. Gauss   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`max\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"max. Lorentz fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`max\[Delta]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"max. Voigt   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`max\[Delta]$$, \
$CellContext`max\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {
          "rel. pos.         ", 
           Manipulate`Place[3], "\[Degree]2\[Theta]"}}], 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier  & Paolo Scardi", "", 
          "Difference betweeen Voigt (Reichel approx.) & TCHZ-Pseudo-Voigt \
function\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 20], ControlPlacement -> {Left}, 
        ControlPlacement -> {Left}, ContinuousAction -> False, TrackedSymbols -> 
        True}, "DefaultOptions" :> {}],
     ImageSizeCache->{1674., {563., 569.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`TCHPseudoVoigt[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       Block[{$CellContext`FWHMg = $CellContext`\[Sigma] 
           Sqrt[8 Log[2]], $CellContext`FWHMl = 
          2 $CellContext`\[Delta], $CellContext`FWHMv = ($CellContext`FWHMl^5 + \
$CellContext`FWHMg^5 + 2.69296 $CellContext`FWHMg^4 $CellContext`FWHMl + 
            2.42843 $CellContext`FWHMg^3 $CellContext`FWHMl^2 + 
            4.47163 $CellContext`FWHMg^2 $CellContext`FWHMl^3 + 
            0.07842 $CellContext`FWHMg $CellContext`FWHMl^4)^(1/
            5), $CellContext`\[Eta]}, $CellContext`\[Eta] = \
$CellContext`FWHMl/$CellContext`FWHMv; $CellContext`\[Eta] = $CellContext`\
\[Eta] (1.36603 - 0.47719 $CellContext`\[Eta] + 
            0.11116 $CellContext`\[Eta]^2); (
            1 - $CellContext`\[Eta]) $CellContext`Gauss2[$CellContext`FWHMv/
             Sqrt[8 Log[
               2]], $CellContext`x0, $CellContext`x] + $CellContext`\[Eta] \
$CellContext`Lorentz[$CellContext`FWHMv/
             2, $CellContext`x0, $CellContext`x]], $CellContext`\[Sigma] = 
       0.3, $CellContext`Gauss2[
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       1/((Sqrt[2 Pi] $CellContext`\[Sigma]) 
        E^(($CellContext`x - $CellContext`x0)^2/(
          2 $CellContext`\[Sigma]^2))), $CellContext`Lorentz[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := (1/(Pi $CellContext`\[Delta])) (1/(
         1 + (($CellContext`x - $CellContext`x0)/$CellContext`\[Delta])^2)), \
$CellContext`VoigtApprox = CompiledFunction[{11, 12.1, 5596}, {
          Blank[Real], 
          Blank[Real], 
          Blank[Real], 
          Blank[Real]}, {{3, 0, 0}, {3, 0, 1}, {3, 0, 2}, {3, 0, 3}, {3, 0, 
         4}}, {{4, {2, 0, 4}}, {1.4142135623730951`, {3, 0, 7}}, {
          0. + 1. I, {4, 0, 0}}, {{0.933757118080976, 0.760213717643091, 
           0.5396414858162972, 0.3339971859861318, 0.18023873770401833`, 
           0.0848049724711138, 0.03479063445952838, 0.012444321744005098`, 
           0.003881038619955638, 0.0010553403629220352`, 
           0.00025021018490812164`, 0.00005172318620381234, 
           9.322521791405033*^-6, 1.4650397062886184`*^-6, 
           2.0073968320415233`*^-7, 2.3981973818259457`*^-8, 
           2.4980692045821277`*^-9, 2.268777244353523*^-10, 
           1.7965822334136586`*^-11, 1.2404240973367864`*^-12, 
           7.467257702018301*^-14, 3.919403132680891*^-15, 
           1.7936866768385383`*^-16, 7.157165835186059*^-18}, {3, 1, 0}}, {
          2.5066282746310002`, {3, 0, 8}}, {{0.2617993877991494, 
           0.5235987755982988, 0.7853981633974483, 1.0471975511965976`, 
           1.3089969389957472`, 1.5707963267948966`, 1.8325957145940461`, 
           2.0943951023931953`, 2.356194490192345, 2.6179938779914944`, 
           2.8797932657906435`, 3.141592653589793, 3.4033920413889422`, 
           3.6651914291880923`, 3.9269908169872414`, 4.1887902047863905`, 
           4.4505895925855405`, 4.71238898038469, 4.974188368183839, 
           5.235987755982989, 5.497787143782138, 5.759586531581287, 
           6.021385919380437, 6.283185307179586}, {3, 1, 4}}, {
          2, {2, 0, 2}}, {{-1., 1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 
           1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 1.}, {3, 1, 
           1}}, {-1, {2, 0, 3}}, {12, {2, 0, 0}}, {1, {2, 0, 1}}, {
          0., {3, 0, 6}}}, {0, 5, 10, 6, 
         6}, {{19, 2, 4}, {13, 3, 4, 5}, {11, 0, 6, 1}, {17, 0, 1, 2}, {11, 5,
           6, 1}, {14, 1, 2, 1}, {16, 1, 7, 4}, {40, 60, 3, 0, 4, 3, 0, 5}, {
          11, 5, 6, 2}, {17, 1, 2, 1}, {10, 0, 5}, {11, 5, 6, 2}, {17, 0, 2, 
          1, 3}, {40, 32, 4, 0, 3, 4, 0, 2}, {20, 2, 3}, {10, 1, 5}, {11, 5, 
          6, 4}, {14, 4, 3, 4}, {10, 0, 5}, {11, 5, 6, 3}, {17, 3, 1, 3}, {40,
           60, 4, 0, 3, 4, 0, 5}, {17, 4, 5, 4}, {17, 0, 4, 5}, {10, 0, 5}, {
          40, 60, 3, 0, 5, 3, 0, 4}, {11, 4, 6, 4}, {17, 1, 4, 3}, {10, 2, 
          4}, {11, 4, 6, 4}, {17, 4, 0, 3, 4}, {41, 259, 4, 0, 2, 3, 1, 1, 4, 
          1, 2}, {41, 257, 2, 0, 3, 4, 1, 2, 4, 1, 3}, {41, 257, 4, 0, 1, 3, 
          1, 4, 4, 1, 2}, {20, 1, 3}, {41, 257, 4, 0, 3, 3, 1, 4, 4, 1, 5}, {
          45, 2, 5, 2}, {40, 60, 4, 1, 2, 4, 1, 5}, {45, 3, 5, 3}, {
          42, "CoerceTensor", 2, 0, 4, 3, 1, 0, 4, 1, 5}, {
          42, "DotVV", 4, 1, 5, 4, 1, 3, 2, 0, 4, 4, 0, 3}, {17, 4, 3, 4}, {
          14, 5, 4, 5}, {40, 42, 4, 0, 5, 3, 0, 4}, {16, 1, 8, 5}, {40, 60, 3,
           0, 5, 3, 0, 9}, {16, 4, 9, 4}, {1}}, 
         Function[{$CellContext`\[Delta], $CellContext`\[Sigma], \
$CellContext`x0, $CellContext`x}, 
          
          Module[{$CellContext`z$ = (($CellContext`x - $CellContext`x0) + 
              I $CellContext`\[Delta])/($CellContext`\[Sigma] 
             1.4142135623730951`), $CellContext`e$}, $CellContext`e$ = 
            Exp[I 12 $CellContext`z$]; 
           Re[I ((1 - $CellContext`e$)/(12 $CellContext`z$)) + (2 
                I ($CellContext`z$/12)) 
               Dot[{0.933757118080976, 0.760213717643091, 0.5396414858162972, 
                 0.3339971859861318, 0.18023873770401833`, 0.0848049724711138,
                  0.03479063445952838, 0.012444321744005098`, 
                 0.003881038619955638, 0.0010553403629220352`, 
                 0.00025021018490812164`, 0.00005172318620381234, 
                 9.322521791405033*^-6, 1.4650397062886184`*^-6, 
                 2.0073968320415233`*^-7, 2.3981973818259457`*^-8, 
                 2.4980692045821277`*^-9, 2.268777244353523*^-10, 
                 1.7965822334136586`*^-11, 1.2404240973367864`*^-12, 
                 7.467257702018301*^-14, 3.919403132680891*^-15, 
                 1.7936866768385383`*^-16, 
                 7.157165835186059*^-18}, ($CellContext`e$ {-1., 1., -1., 
                    1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 1., -1., 
                    1., -1., 1., -1., 1., -1., 1., -1., 1.} - 
                  1)/(({0.2617993877991494, 0.5235987755982988, 
                   0.7853981633974483, 1.0471975511965976`, 
                   1.3089969389957472`, 1.5707963267948966`, 
                   1.8325957145940461`, 2.0943951023931953`, 
                   2.356194490192345, 2.6179938779914944`, 
                   2.8797932657906435`, 3.141592653589793, 
                   3.4033920413889422`, 3.6651914291880923`, 
                   3.9269908169872414`, 4.1887902047863905`, 
                   4.4505895925855405`, 4.71238898038469, 4.974188368183839, 
                   5.235987755982989, 5.497787143782138, 5.759586531581287, 
                   6.021385919380437, 6.283185307179586} + $CellContext`z$) ({
                   0.2617993877991494, 0.5235987755982988, 0.7853981633974483,
                    1.0471975511965976`, 1.3089969389957472`, 
                   1.5707963267948966`, 1.8325957145940461`, 
                   2.0943951023931953`, 2.356194490192345, 
                   2.6179938779914944`, 2.8797932657906435`, 
                   3.141592653589793, 3.4033920413889422`, 
                   3.6651914291880923`, 3.9269908169872414`, 
                   4.1887902047863905`, 4.4505895925855405`, 4.71238898038469,
                    4.974188368183839, 5.235987755982989, 5.497787143782138, 
                   5.759586531581287, 6.021385919380437, 
                   6.283185307179586} - $CellContext`z$))]]/($CellContext`\
\[Sigma] 2.5066282746310002`)], Listable], Evaluate], 
       Attributes[$CellContext`z$] = {Temporary}, 
       Attributes[$CellContext`e$] = {Temporary}, $CellContext`filePath = 
       "C:\\Users\\dinne\\DeskTop\\Voigt_function.jpg", $CellContext`Gaussfwhm[
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       2 Sqrt[2 Log[2]] $CellContext`\[Sigma], $CellContext`Lorentzfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]]] := 2 $CellContext`\[Delta], $CellContext`Voigtfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Module[{$CellContext`fg = 
          Sqrt[8 Log[2]] $CellContext`\[Sigma], $CellContext`fl = 
          2 $CellContext`\[Delta]}, 0.5346 $CellContext`fl + 
         Sqrt[0.2166 $CellContext`fl $CellContext`fl + $CellContext`fg \
$CellContext`fg]]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.817101831547163*^9, 3.8171018687689867`*^9, {3.8171019211277795`*^9, 
   3.8171019342838593`*^9}, 3.8171027570165253`*^9, {3.8171027947991223`*^9, 
   3.8171028104882355`*^9}, 3.8171056590330257`*^9, 3.8171107381267586`*^9, 
   3.8171290530474415`*^9, 3.8171291439132357`*^9, 3.8171294309649796`*^9, 
   3.8171294643106985`*^9, 3.8171294955160427`*^9, 3.817130020535882*^9, 
   3.817132186005878*^9, 3.8171328829479375`*^9, 3.8171339220590754`*^9, 
   3.8171341134264917`*^9, 3.8171341804137936`*^9, 3.8171342449670153`*^9, 
   3.8171343492649803`*^9, 3.817135459591724*^9, 3.817137132542774*^9, 
   3.817186306993469*^9, 3.8171864807451334`*^9, 3.8171916028861694`*^9, {
   3.8188443121488085`*^9, 3.8188443341334877`*^9}, 3.820118102731447*^9, 
   3.8205888588110237`*^9, {3.8206466525110397`*^9, 3.8206466724163647`*^9}, 
   3.823586901240375*^9, 3.824284230510087*^9, 3.8242952239358387`*^9, {
   3.8242955194506254`*^9, 3.824295543135795*^9}, 3.824296005593989*^9, 
   3.8242979352046623`*^9, 3.8242983107858977`*^9, 3.8242985353334904`*^9, 
   3.8243009247955904`*^9, 3.824303270108447*^9, 3.8243066774713435`*^9, 
   3.82430764333713*^9, 3.8243550692886524`*^9, 3.8243576358495016`*^9, 
   3.8243632000374765`*^9, 3.824363645424509*^9, 3.824381844284661*^9, 
   3.8243824863441105`*^9, 3.8246398950632625`*^9, 3.8246401930233393`*^9, {
   3.8246403161662426`*^9, 3.8246403248852253`*^9}, 3.8246403904648867`*^9, 
   3.824643427873667*^9, 3.8249602106017203`*^9, 3.824960760800412*^9, 
   3.825475295295186*^9, {3.82547838283007*^9, 3.8254784029258595`*^9}, 
   3.8254784655888557`*^9, 3.8268597003401575`*^9, 3.8278365007179003`*^9, 
   3.827837542784176*^9, {3.8278380035656953`*^9, 3.8278380278927083`*^9}, 
   3.8279144396332264`*^9, 3.8279155174168453`*^9, 3.827915555582493*^9, 
   3.8279167083354588`*^9, 3.827916891967579*^9, 3.8279760081043262`*^9, 
   3.827976326877946*^9, {3.8280891072725496`*^9, 3.8280891221197467`*^9}, 
   3.8280891777822742`*^9, 3.8280892691221404`*^9, 3.8280911886903563`*^9, 
   3.8280918120537615`*^9, 3.8280928588105*^9, 3.8280929131632333`*^9, 
   3.8281057706943655`*^9, 3.828106039919623*^9, 3.828106151862769*^9, 
   3.8281553863517175`*^9, 3.8281560206890535`*^9, 3.828160047227601*^9, 
   3.828161191462169*^9, {3.8281612995673156`*^9, 3.8281613229768353`*^9}, 
   3.828161457522484*^9, 3.8281616512693253`*^9, 3.8281625798776073`*^9, 
   3.828170841469816*^9, 3.8281710309832506`*^9, {3.828171063620841*^9, 
   3.828171080493884*^9}, 3.8281712670276747`*^9, {3.828171782036361*^9, 
   3.8281718120742407`*^9}, 3.828173724556165*^9, 3.828502152879102*^9, 
   3.8285034811943007`*^9, 3.828579448289317*^9, 3.8285811363613143`*^9, 
   3.8285830522556334`*^9, 3.82858424191021*^9, 3.828591671378378*^9, 
   3.828592091141326*^9, 3.828593118105767*^9, 3.8285934321555033`*^9, 
   3.82859397645701*^9, 3.8298003586202583`*^9, 3.8298004909095263`*^9, 
   3.829807712600463*^9, 3.8298091879039855`*^9, 3.829965134570799*^9, 
   3.8305859160223446`*^9, 3.830586006234085*^9, {3.830587706062255*^9, 
   3.8305877337297287`*^9}, 3.8305919214637785`*^9, 3.830594800004175*^9, 
   3.830595011278117*^9, 3.831616462996306*^9, 3.832143733785555*^9, 
   3.8321449522767825`*^9, 3.832145064522847*^9, 3.832145173976371*^9, 
   3.8510481372142715`*^9, 3.851050170937677*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"21b80d54-2d18-44d1-894a-62ea903cf14b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reliability of TCHZ PseudoVoigt fitting", "Chapter",
 CellChangeTimes->{3.8171293231134663`*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"5d3d5afd-d957-43ce-b966-15fb84b13168"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
        "fwhm", ",", "fwhmpos", ",", "leftbound", ",", "rightbound", ",", " ",
          "points", ",", " ", "stepw", ",", "abscissae", ",", "middle", ",", 
         "dataY", ",", "noisydata", ",", " ", "dataXY", ",", " ", "poissrnd", 
         ",", " ", "residuals", ",", " ", "low", ",", " ", "high", ",", " ", 
         "fitfunc", ",", "  ", "cm", ",", " ", "cm12", ",", "cm13", ",", 
         "cm23", ",", "ell12", ",", " ", "ell13", ",", "ell23", ",", "fp", 
         ",", " ", "lp1", ",", "lp2"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"fwhm", "            ", "=", " ", 
         RowBox[{"Voigtfwhm", "[", 
          RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"leftbound", "   ", "=", 
         RowBox[{
          RowBox[{"-", "6."}], " ", "fwhm"}]}], ";", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"rightbound", "=", "    ", 
         RowBox[{"6.", " ", "fwhm"}]}], ";", " ", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"points", "         ", "=", " ", "2000"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"stepw", "           ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound", "-", "leftbound"}], ")"}], "/", "points"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"abscissae", "  ", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound", ",", "rightbound", ",", "stepw"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"middle", "         ", "=", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "abscissae", "]"}], "/", "2"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dataY", "            ", "=", "  ", 
         RowBox[{"multiplier", " ", 
          RowBox[{"TCHPseudoVoigtTable", "[", 
           RowBox[{"\[Delta]", ",", "\[Sigma]", ",", "0", ",", "abscissae"}], 
           "]"}]}]}], ";", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{"Round", "[", " ", "]"}], " ", "*)"}], "\[IndentingNewLine]",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"poissrnd", "[", "data_", "]"}], ":=", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"PoissonDistribution", "[", "data", "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"poisson", ",", 
          RowBox[{"noisydata", "=", 
           RowBox[{"poissrnd", "/@", "dataY"}]}], ",", "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{"noisydata", "=", "dataY"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"noisydata", "   ", "=", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"#", "+", 
               RowBox[{"RandomReal", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "noise"}], "/", "2"}], ",", 
                  RowBox[{"noise", "/", "2"}]}], "}"}], "]"}]}], "&"}], "/@", 
             "dataY"}], " ", "+", " ", 
            RowBox[{"2", " ", "noise"}]}]}], ";"}], " ", "*)"}], 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"low", "                 ", "=", " ", 
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"dataY", "[", 
            RowBox[{"[", "middle", "]"}], "]"}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"high", "               ", "=", " ", 
         RowBox[{
          RowBox[{"dataY", "[", 
           RowBox[{"[", "middle", "]"}], "]"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"dataY", "[", 
             RowBox[{"[", "middle", "]"}], "]"}], "]"}]}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"dataXY", "=", 
         RowBox[{"Transpose", "[", 
          RowBox[{"{", 
           RowBox[{"abscissae", ",", "noisydata"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
        RowBox[{
         RowBox[{"fitfunc", "[", 
          RowBox[{"a_", ",", "b_", ",", "c_", ",", "x_"}], "]"}], ":=", " ", 
         RowBox[{"a", "*", " ", 
          RowBox[{"TCHPseudoVoigt", "[", 
           RowBox[{"b", ",", "c", ",", "0.0", ",", "x"}], "]"}]}]}], " ", ";",
         "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"fit", "=", 
         RowBox[{"Quiet", "@", 
          RowBox[{"NonlinearModelFit", "[", 
           RowBox[{"dataXY", ",", 
            RowBox[{"fitfunc", "[", 
             RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", ",", 
                RowBox[{"multiplier", "+", 
                 RowBox[{"multiplier", " ", 
                  RowBox[{"idev", "/", "100."}]}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"b", ",", 
                RowBox[{"\[Delta]", "+", 
                 RowBox[{"\[Delta]", " ", 
                  RowBox[{"\[Delta]dev", "/", "100."}]}]}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"c", ",", 
                RowBox[{"\[Sigma]", "+", 
                 RowBox[{"\[Sigma]", " ", 
                  RowBox[{"\[Sigma]dev", "/", "100."}]}]}]}], "}"}]}], "}"}], 
            ",", "x", ",", 
            RowBox[{"Method", "\[Rule]", "methods"}], ",", " ", 
            RowBox[{"MaxIterations", "\[Rule]", "100"}]}], "]"}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"residuals", "=", 
         RowBox[{"fit", "[", "\"\<FitResiduals\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"cm", "=", 
         RowBox[{"fit", "[", "\"\<CovarianceMatrix\>\"", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cm12", "=", 
         RowBox[{"Take", "[", 
          RowBox[{"cm", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cm23", "=", 
         RowBox[{"Take", "[", 
          RowBox[{"cm", ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cm13", " ", "=", 
         RowBox[{"Take", "[", 
          RowBox[{"cm", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"fp", "=", 
         RowBox[{"Values", "@", 
          RowBox[{"fit", "[", "\"\<BestFitParameters\>\"", "]"}]}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"ell12", " ", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Ellipsoid", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fp", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"fp", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"Quiet", "@", 
               RowBox[{"InverseCDF", "[", 
                RowBox[{
                 RowBox[{"ChiSquareDistribution", "[", "2", "]"}], ",", 
                 "confi"}], "]"}]}], " ", "cm12"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"confi", ",", 
             RowBox[{"{", 
              RowBox[{".68", ",", ".95", ",", ".99"}], "}"}]}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ell23", " ", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Ellipsoid", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fp", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", 
               RowBox[{"fp", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"Quiet", "@", 
               RowBox[{"InverseCDF", "[", 
                RowBox[{
                 RowBox[{"ChiSquareDistribution", "[", "2", "]"}], ",", 
                 "confi"}], "]"}]}], " ", "cm23"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"confi", ",", 
             RowBox[{"{", 
              RowBox[{".68", ",", ".95", ",", ".99"}], "}"}]}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ell13", " ", "=", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Ellipsoid", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"fp", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"fp", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"Quiet", "@", 
               RowBox[{"InverseCDF", "[", 
                RowBox[{
                 RowBox[{"ChiSquareDistribution", "[", "2", "]"}], ",", 
                 "confi"}], "]"}]}], " ", "cm13"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"confi", ",", 
             RowBox[{"{", 
              RowBox[{".68", ",", ".95", ",", ".99"}], "}"}]}], "}"}]}], 
          "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"lp3a", "=", " ", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"EdgeForm", "[", 
              RowBox[{"{", 
               RowBox[{"Thick", ",", "Red", ",", "Dashed"}], "}"}], "]"}], 
             ",", 
             RowBox[{"FaceForm", "[", 
              RowBox[{"{", 
               RowBox[{"White", ",", 
                RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"AbsolutePointSize", "[", "12", "]"}], ",", 
                 "Green"}], "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"multiplier", ",", "\[Delta]"}], "}"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"AbsolutePointSize", "[", "12", "]"}], ",", "Red"}], 
                "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"fp", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"fp", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
             ",", "ell12"}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<I (a.u.)\>\"", ",", 
              "\"\<\[Delta] (\[Degree]2\[Theta])\>\""}], "}"}]}], ",", " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"lp3b", "=", " ", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"EdgeForm", "[", 
              RowBox[{"{", 
               RowBox[{"Thick", ",", "Red", ",", "Dashed"}], "}"}], "]"}], 
             ",", 
             RowBox[{"FaceForm", "[", 
              RowBox[{"{", 
               RowBox[{"White", ",", 
                RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"AbsolutePointSize", "[", "12", "]"}], ",", 
                 "Green"}], "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", "    ", 
                 RowBox[{"\[Delta]", ",", "\[Sigma]"}], "}"}], "]"}]}], "}"}],
              ",", "            ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"AbsolutePointSize", "[", "12", "]"}], ",", "Red"}], 
                "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"fp", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ",", 
                  RowBox[{"fp", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
             ",", "ell23"}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<\[Delta] (\[Degree]2\[Theta])\>\"", ",", 
              "\"\<\[Sigma] (\[Degree]2\[Theta])\>\""}], "}"}]}], ",", " ", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"lp3c", "=", " ", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"EdgeForm", "[", 
              RowBox[{"{", 
               RowBox[{"Thick", ",", "Red", ",", "Dashed"}], "}"}], "]"}], 
             ",", 
             RowBox[{"FaceForm", "[", 
              RowBox[{"{", 
               RowBox[{"White", ",", 
                RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"AbsolutePointSize", "[", "12", "]"}], ",", 
                 "Green"}], "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"multiplier", ",", "\[Sigma]"}], "}"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"AbsolutePointSize", "[", "12", "]"}], ",", "Red"}], 
                "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"fp", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", 
                  RowBox[{"fp", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
             ",", "ell13"}], "}"}], ",", 
           RowBox[{"Frame", "\[Rule]", "True"}], ",", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<I (a.u.)\>\"", ",", 
              "\"\<\[Sigma] (\[Degree]2\[Theta])\>\""}], "}"}]}], ",", 
           RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"lp1", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"fit", "[", "x", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "leftbound", ",", "rightbound"}], "}"}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"Epilog", "\[Rule]", 
            RowBox[{"Point", "[", "dataXY", "]"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Epilog", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Point", "[", "data", "]"}], ",", 
                RowBox[{"Inset", "[", 
                 RowBox[{"lp3", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"rightbound", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rightbound", "-", "leftbound"}], ")"}], "/", 
                    "6"}]}], ",", 
                    RowBox[{"high", "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"high", "-", "low"}], ")"}], "/", "3"}]}]}], 
                   "}"}]}], "]"}]}], "}"}]}], ","}], " ", "*)"}], 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Orange", ",", "Thick"}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftbound", "/", "xMag"}], ",", " ", 
                RowBox[{"rightbound", "/", "xMag"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"low", ",", " ", "high"}], "}"}]}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                      ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta]-2\!\(\*SubscriptBox[\(\[Theta]\), \(0\)]\) (\
\[Degree])\>\"", ",", "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", " ",
            "\[IndentingNewLine]", "                                      ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "18"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<TCHZ Pseudo-Voigt plus fitted function\>\"", " ", 
                "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"Left", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
           "\[IndentingNewLine]", "                                      ", 
           RowBox[{"ImageSize", "\[Rule]", "1000"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
        RowBox[{"fwhmpos", " ", "=", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"Red", ",", " ", 
            RowBox[{"Arrowheads", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}], "]"}], ",", " ", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "fwhm"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"fit", "[", "0.0", "]"}], "/", "2"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"fwhm", "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"fit", "[", "0.0", "]"}], "/", "2"}]}], "}"}]}], 
              "}"}], "]"}]}], "}"}], "]"}]}], ";", " ", "\[IndentingNewLine]",
         "\[IndentingNewLine]", 
        RowBox[{"lp2", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"residuals", "  ", "diffMag"}], ",", "\[IndentingNewLine]",
            "                                     ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound", ",", " ", "rightbound"}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                                     ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"leftbound", "/", "xMag"}], ",", " ", 
                RowBox[{"rightbound", "/", "xMag"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"low", ",", " ", "high"}], "}"}]}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                                     ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", "Thick"}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                                     ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "18"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "                                     ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", "\"\<difference\>\"", " ", "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"Left", ",", "0.8"}], "}"}]}], "]"}]}]}], 
          "                         ", "\[IndentingNewLine]", "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
        RowBox[{"If", "[", 
         RowBox[{"export", ",", 
          RowBox[{"{", "\[IndentingNewLine]", "                       ", 
           RowBox[{
            RowBox[{"Export", "[", 
             RowBox[{"filePath", ",", 
              RowBox[{"{", 
               RowBox[{"lp1", ",", "lp2"}], "}"}]}], "]"}], ",", " ", 
            "\[IndentingNewLine]", "                       ", 
            RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
           "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
         "]"}], ";", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{"{", 
          RowBox[{"lp1", ",", "lp2", ",", " ", "fwhmpos"}], "}"}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", "\[IndentingNewLine]", "              ", 
       RowBox[{
        RowBox[{"{", "   ", 
         RowBox[{"\"\<\[Delta]      \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Delta]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
             "0.000001", ",", " ", "1.", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          " ", ",", "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", 
        "\[IndentingNewLine]", "              ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<\[Sigma]      \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Sigma]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
             "0.000001", ",", " ", "1.", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
        "\[IndentingNewLine]", "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Lorentzfwhm", "[", "\[Sigma]", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<Voigt   fwhm\>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Voigtfwhm", "[", 
              RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<mixing  \[Delta]/\[Sigma]      \>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Mix", "[", 
              RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}], "}"}]}], 
       "\[IndentingNewLine]", "     ", "}"}], "]"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "xMag", ",", "                  ", "1", ",", " ", 
          "\"\<\[Theta]-axis spread\>\""}], "}"}], ",", "               ", 
        "1", ",", "      ", "10", ",", "1", ",", "Slider", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "diffMag", ",", "           ", "1", ",", " ", 
          "\"\<residual multiplier\>\""}], "}"}], ",", "  ", "1", ",", 
        "      ", "10", ",", "1", ",", "Slider", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "multiplier", ",", "100", ",", " ", "\"\<intensity multiplier\>\""}],
          "}"}], ",", "5", ",", " ", "1000", ",", "1", ",", "Slider", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "poisson", ",", "     ", "True", ",", "\"\<Poisson statistics\>\""}],
          "}"}], ",", "Checkbox", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]",
      "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "methods", ",", "\"\<LevenbergMarquardt\>\"", ",", 
          "\"\<Minimization method\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Gradient\>\"", ",", "\"\<LevenbergMarquardt\>\"", ",", 
          "\"\<Newton\>\""}], "}"}], ",", "RadioButton", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", "\[IndentingNewLine]", "              ", 
       RowBox[{
        RowBox[{"{", "   ", 
         RowBox[{"\"\<start deviation Lorentzian \[Delta]\>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Delta]dev", ",", "    ", "0.0", ",", "\"\<\>\""}], 
              "}"}], ",", 
             RowBox[{"-", "25."}], ",", " ", "25.", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          " ", ",", "\"\<%\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<start deviation Gaussian \[Sigma]  \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Sigma]dev", ",", "    ", "0.0", ",", "\"\<\>\""}], 
              "}"}], ",", 
             RowBox[{"-", "25."}], ",", " ", "25.", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          ",", "\"\<%\>\""}], " ", "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<start deviation intensity   \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"idev", ",", "     ", "0.0", ",", "\"\<\>\""}], "}"}], 
             ",", 
             RowBox[{"-", "25."}], ",", " ", "25.", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          ",", "\"\<%\>\""}], " ", "}"}]}], "\[IndentingNewLine]", "      ", 
       "}"}], "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Dynamic", "@", "lp3a"}], ",", 
         RowBox[{"Dynamic", "@", "lp3b"}], ",", 
         RowBox[{"Dynamic", "@", "lp3c"}]}], "}"}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", "\[IndentingNewLine]", "          ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<Adjusted \!\(\*SuperscriptBox[\(R\), \(2\)]\): \>\"", ",", 
          "                ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"fit", "[", "\"\<AdjustedRSquared\>\"", "]"}]}]}], "}"}], 
        ",", "\[IndentingNewLine]", "          ", 
        RowBox[{"{", 
         RowBox[{"\"\<Correlation Matrix: \>\"", ",", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"MatrixForm", "[", 
            RowBox[{"fit", "[", "\"\<CorrelationMatrix\>\"", "]"}], "]"}]}]}],
          "}"}], ",", "\[IndentingNewLine]", "          ", 
        RowBox[{"{", 
         RowBox[{"\"\<Covariance Matrix: \>\"", ",", "  ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"MatrixForm", "[", 
            RowBox[{"fit", "[", "\"\<CovarianceMatrix\>\"", "]"}], "]"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", "          ", 
        RowBox[{"{", 
         RowBox[{"\"\<Fitted parameters: \>\"", ",", "  ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"MatrixForm", "[", 
            RowBox[{
            "fit", "[", "\"\<ParameterConfidenceIntervalTable\>\"", "]"}], 
            "]"}]}]}], "}"}]}], "\[IndentingNewLine]", "     ", "}"}], "]"}], 
     ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", "   ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Export to desktop\>\"", ",", 
       RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", 
        " ", "\"\<Fitting the Thompson-Cox-Hastings Pseudo-Voigt \
function\\n\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Bold", ",", "18"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ControlPlacement", "\[Rule]", 
      RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"TrackedSymbols", " ", "->", "True"}]}], "\[IndentingNewLine]", 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.813929003752968*^9, {3.8139301844842*^9, 3.813930185614908*^9}, {
   3.8139302329228544`*^9, 3.8139302333916445`*^9}, {3.8139303055801034`*^9, 
   3.813930305814413*^9}, {3.8139304485063267`*^9, 3.81393050313334*^9}, {
   3.81393089927765*^9, 3.8139309162936935`*^9}, {3.813931020779604*^9, 
   3.8139310447776213`*^9}, {3.8139311285625725`*^9, 3.813931139094039*^9}, {
   3.8139312732258224`*^9, 3.8139312737837086`*^9}, {3.81393136355266*^9, 
   3.8139313645196934`*^9}, {3.8139313961520796`*^9, 3.813931404029475*^9}, {
   3.813937583186932*^9, 3.8139376177186103`*^9}, {3.8139376540940666`*^9, 
   3.8139376556945257`*^9}, {3.813937790502342*^9, 3.8139378432647*^9}, {
   3.813938187044428*^9, 3.8139381886478186`*^9}, {3.813938501761031*^9, 
   3.8139385145426226`*^9}, {3.8139386044611244`*^9, 
   3.8139386301845913`*^9}, {3.813938669451107*^9, 3.813938677304695*^9}, {
   3.817006504369853*^9, 3.817006575452574*^9}, {3.817006737158446*^9, 
   3.8170067588936634`*^9}, {3.817006823348857*^9, 3.8170068311182404`*^9}, {
   3.8170104999795136`*^9, 3.81701057237348*^9}, {3.817010810705727*^9, 
   3.817010865613445*^9}, 3.8170109045665846`*^9, {3.8170110005694156`*^9, 
   3.817011075805401*^9}, {3.817011108306384*^9, 3.817011177935991*^9}, {
   3.8170112139960403`*^9, 3.81701124063732*^9}, {3.8170113240296297`*^9, 
   3.817011326811078*^9}, {3.817011499314996*^9, 3.817011594223179*^9}, {
   3.8170117022881155`*^9, 3.817011750992533*^9}, {3.8170118086341534`*^9, 
   3.817011820618629*^9}, 3.817011860401012*^9, {3.8170118951673145`*^9, 
   3.817011901148872*^9}, {3.8170119808564043`*^9, 3.8170120188420634`*^9}, {
   3.817012052528022*^9, 3.817012103484317*^9}, {3.8170122223617773`*^9, 
   3.817012225509358*^9}, {3.8170123402862267`*^9, 3.8170123432390494`*^9}, {
   3.817012978814749*^9, 3.8170129871744666`*^9}, {3.8170185733495727`*^9, 
   3.8170186081939025`*^9}, {3.8170187524772167`*^9, 
   3.8170187567199335`*^9}, {3.8170188951514783`*^9, 
   3.8170188969794545`*^9}, {3.8170189493238516`*^9, 3.817018955261445*^9}, {
   3.817019611217564*^9, 3.817019613802657*^9}, {3.8170198186341305`*^9, 
   3.8170198187432346`*^9}, {3.8170199214007883`*^9, 
   3.8170199261821566`*^9}, {3.8170204769403095`*^9, 
   3.8170205003465233`*^9}, {3.81702066475527*^9, 3.817020670818147*^9}, {
   3.8170224077327995`*^9, 3.8170224944821634`*^9}, {3.8170225566037064`*^9, 
   3.8170225716540294`*^9}, {3.817022612459566*^9, 3.8170226144855623`*^9}, {
   3.817026677347643*^9, 3.8170266791464024`*^9}, {3.8170278442051945`*^9, 
   3.8170279191974916`*^9}, {3.817027972859543*^9, 3.8170281103571644`*^9}, {
   3.8170299494585133`*^9, 3.8170299666902637`*^9}, {3.8170306120714445`*^9, 
   3.8170306127119555`*^9}, {3.817100552289649*^9, 3.8171005543365088`*^9}, {
   3.8171031131862803`*^9, 3.817103157776706*^9}, {3.8171043461450014`*^9, 
   3.8171043563166046`*^9}, {3.817104389716573*^9, 3.817104392457156*^9}, {
   3.817104481419347*^9, 3.8171044814883614`*^9}, {3.81710476416893*^9, 
   3.8171048298291245`*^9}, {3.8171048635033283`*^9, 
   3.8171048817865505`*^9}, {3.8171049227391896`*^9, 
   3.8171049341942024`*^9}, {3.8171050474078293`*^9, 3.817105077257427*^9}, {
   3.817105132285033*^9, 3.8171051660113244`*^9}, {3.8171052260010977`*^9, 
   3.81710525008278*^9}, {3.8171053147246065`*^9, 3.817105410333956*^9}, {
   3.8171054686504745`*^9, 3.8171054996812305`*^9}, {3.817105649179471*^9, 
   3.817105649881889*^9}, {3.8171056868777933`*^9, 3.8171057269070883`*^9}, {
   3.8171058923148594`*^9, 3.817105893820018*^9}, {3.817105927115718*^9, 
   3.817105927833763*^9}, {3.817105986573408*^9, 3.8171062008001432`*^9}, {
   3.8171062422777834`*^9, 3.8171063211629705`*^9}, {3.8171064361896615`*^9, 
   3.817106447525876*^9}, {3.8171065012581263`*^9, 3.8171065695039487`*^9}, {
   3.8171066979585733`*^9, 3.817106704279649*^9}, {3.817110249176608*^9, 
   3.8171102541150765`*^9}, {3.817110434405634*^9, 3.8171104422167215`*^9}, {
   3.8171106229336214`*^9, 3.8171106248240185`*^9}, {3.817110676349792*^9, 
   3.817110690840459*^9}, {3.8171290181390357`*^9, 3.817129024045602*^9}, {
   3.8171819820474854`*^9, 3.8171819839697127`*^9}, {3.8171888112953277`*^9, 
   3.817188813232765*^9}, {3.8171889315901403`*^9, 3.8171889453286886`*^9}, {
   3.817188993177454*^9, 3.817188996970024*^9}, {3.8171890312670755`*^9, 
   3.8171891055028334`*^9}, {3.8171891540814867`*^9, 3.817189196879198*^9}, {
   3.817189320943143*^9, 3.817189360381537*^9}, {3.8171894418356133`*^9, 
   3.8171895590562077`*^9}, {3.817189618306841*^9, 3.8171896496179256`*^9}, {
   3.8171898320288043`*^9, 3.81718983596626*^9}, {3.8171899769996376`*^9, 
   3.8171900277973995`*^9}, {3.8171901459712133`*^9, 3.817190156159917*^9}, {
   3.8171902079558425`*^9, 3.8171902197215*^9}, {3.8171902594566393`*^9, 
   3.8171902704723425`*^9}, {3.817190460937191*^9, 3.8171904755589848`*^9}, {
   3.817190510616411*^9, 3.817190528147852*^9}, {3.817190559570356*^9, 
   3.8171906393681865`*^9}, {3.8171906717592487`*^9, 
   3.8171907200256104`*^9}, {3.817190800948298*^9, 3.8171908033237333`*^9}, 
   3.81719085111409*^9, {3.817190898262651*^9, 3.8171909007155094`*^9}, {
   3.817190931465807*^9, 3.8171910037483892`*^9}, {3.8171910796749945`*^9, 
   3.8171910857889643`*^9}, {3.81719138103487*^9, 3.8171914459264603`*^9}, {
   3.817191477989411*^9, 3.8171915160208216`*^9}, {3.817194055696458*^9, 
   3.8171940561351414`*^9}, {3.8246418622938595`*^9, 3.824641943524743*^9}, {
   3.8246419751868467`*^9, 3.8246419931872683`*^9}, {3.82783824380836*^9, 
   3.8278382874750795`*^9}, {3.8278396553676815`*^9, 3.8278396715044336`*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"c46b5711-8e9c-47e6-b7eb-a4bcbb415d6e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`diffMag$$ = 1, $CellContext`export$$ = 
    False, $CellContext`idev$$ = 0., $CellContext`methods$$ = 
    "LevenbergMarquardt", $CellContext`multiplier$$ = 
    100, $CellContext`poisson$$ = True, $CellContext`xMag$$ = 
    1, $CellContext`\[Delta]$$ = 0.03, $CellContext`\[Delta]dev$$ = 
    0., $CellContext`\[Sigma]$$ = 0.3, $CellContext`\[Sigma]dev$$ = 0., 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.03, ""}, 1.*^-6, 1.}, {{
       Hold[$CellContext`\[Sigma]$$], 0.03, ""}, 1.*^-6, 1.}, {
      Hold[
       Grid[{{"\[Delta]      ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma]      ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {
         "mixing  \[Delta]/\[Sigma]      ", 
          Dynamic[
           NumberForm[
            $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1, "\[Theta]-axis spread"}, 1, 10, 1}, {{
       Hold[$CellContext`diffMag$$], 1, "residual multiplier"}, 1, 10, 1}, {{
       Hold[$CellContext`multiplier$$], 100, "intensity multiplier"}, 5, 1000,
       1}, {{
       Hold[$CellContext`poisson$$], True, "Poisson statistics"}, {
      True, False}}, {{
       Hold[$CellContext`methods$$], "LevenbergMarquardt", 
       "Minimization method"}, {
      "Gradient", "LevenbergMarquardt", "Newton"}}, {{
       Hold[$CellContext`\[Delta]dev$$], 0., ""}, -25., 25.}, {{
       Hold[$CellContext`\[Sigma]dev$$], 0., ""}, -25., 25.}, {{
       Hold[$CellContext`idev$$], 0., ""}, -25., 25.}, {
      Hold[
       Grid[{{"start deviation Lorentzian \[Delta]", 
          Manipulate`Place[3], "%"}, {"start deviation Gaussian \[Sigma]  ", 
          Manipulate`Place[4], "%"}, {"start deviation intensity   ", 
          Manipulate`Place[5], "%"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Grid[{{
          Dynamic[$CellContext`lp3a], 
          Dynamic[$CellContext`lp3b], 
          Dynamic[$CellContext`lp3c]}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Grid[{{"Adjusted \!\(\*SuperscriptBox[\(R\), \(2\)]\): ", 
          Dynamic[
           $CellContext`fit["AdjustedRSquared"]]}, {"Correlation Matrix: ", 
          Dynamic[
           MatrixForm[
            $CellContext`fit["CorrelationMatrix"]]]}, {"Covariance Matrix: ", 
          Dynamic[
           MatrixForm[
            $CellContext`fit["CovarianceMatrix"]]]}, {"Fitted parameters: ", 
          Dynamic[
           MatrixForm[
            $CellContext`fit["ParameterConfidenceIntervalTable"]]]}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1000., {352., 358.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`diffMag$$ = 1, $CellContext`export$$ = 
        False, $CellContext`idev$$ = 0., $CellContext`methods$$ = 
        "LevenbergMarquardt", $CellContext`multiplier$$ = 
        100, $CellContext`poisson$$ = True, $CellContext`xMag$$ = 
        1, $CellContext`\[Delta]$$ = 0.03, $CellContext`\[Delta]dev$$ = 
        0., $CellContext`\[Sigma]$$ = 0.03, $CellContext`\[Sigma]dev$$ = 0.}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`fwhm$, $CellContext`fwhmpos$, \
$CellContext`leftbound$, $CellContext`rightbound$, $CellContext`points$, \
$CellContext`stepw$, $CellContext`abscissae$, $CellContext`middle$, \
$CellContext`dataY$, $CellContext`noisydata$, $CellContext`dataXY$, \
$CellContext`poissrnd$, $CellContext`residuals$, $CellContext`low$, \
$CellContext`high$, $CellContext`fitfunc$, $CellContext`cm$, \
$CellContext`cm12$, $CellContext`cm13$, $CellContext`cm23$, \
$CellContext`ell12$, $CellContext`ell13$, $CellContext`ell23$, \
$CellContext`fp$, $CellContext`lp1$, $CellContext`lp2$}, $CellContext`fwhm$ = \
$CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\[Sigma]$$]; \
$CellContext`leftbound$ = (-6.) $CellContext`fwhm$; $CellContext`rightbound$ = 
         6. $CellContext`fwhm$; $CellContext`points$ = 
         2000; $CellContext`stepw$ = ($CellContext`rightbound$ - \
$CellContext`leftbound$)/$CellContext`points$; $CellContext`abscissae$ = 
         Range[$CellContext`leftbound$, $CellContext`rightbound$, \
$CellContext`stepw$]; $CellContext`middle$ = 
         Ceiling[Length[$CellContext`abscissae$]/
           2]; $CellContext`dataY$ = $CellContext`multiplier$$ \
$CellContext`TCHPseudoVoigtTable[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$, 0, $CellContext`abscissae$]; $CellContext`poissrnd$[
           Pattern[$CellContext`data, 
            Blank[]]] := RandomInteger[
           PoissonDistribution[$CellContext`data]]; 
        If[$CellContext`poisson$$, $CellContext`noisydata$ = 
          Map[$CellContext`poissrnd$, $CellContext`dataY$], \
$CellContext`noisydata$ = $CellContext`dataY$]; $CellContext`low$ = (-2) Sqrt[
            
            Part[$CellContext`dataY$, $CellContext`middle$]]; \
$CellContext`high$ = Part[$CellContext`dataY$, $CellContext`middle$] + 2 Sqrt[
             
             Part[$CellContext`dataY$, $CellContext`middle$]]; \
$CellContext`dataXY$ = 
         Transpose[{$CellContext`abscissae$, $CellContext`noisydata$}]; \
$CellContext`fitfunc$[
           Pattern[$CellContext`a, 
            Blank[]], 
           Pattern[$CellContext`b, 
            Blank[]], 
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`x, 
            
            Blank[]]] := $CellContext`a \
$CellContext`TCHPseudoVoigt[$CellContext`b, $CellContext`c, 
            0., $CellContext`x]; $CellContext`fit = Quiet[
           NonlinearModelFit[$CellContext`dataXY$, 
            $CellContext`fitfunc$[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`x], {{$CellContext`a, $CellContext`multiplier$$ + \
$CellContext`multiplier$$ ($CellContext`idev$$/
                100.)}, {$CellContext`b, $CellContext`\[Delta]$$ + \
$CellContext`\[Delta]$$ ($CellContext`\[Delta]dev$$/
                100.)}, {$CellContext`c, $CellContext`\[Sigma]$$ + \
$CellContext`\[Sigma]$$ ($CellContext`\[Sigma]dev$$/100.)}}, $CellContext`x, 
            Method -> $CellContext`methods$$, MaxIterations -> 
            100]]; $CellContext`residuals$ = $CellContext`fit[
          "FitResiduals"]; $CellContext`cm$ = $CellContext`fit[
          "CovarianceMatrix"]; $CellContext`cm12$ = 
         Take[$CellContext`cm$, {1, 2}, {1, 2}]; $CellContext`cm23$ = 
         Take[$CellContext`cm$, {2, 3}, {2, 3}]; $CellContext`cm13$ = 
         Take[$CellContext`cm$, {1, -1, 2}, {1, -1, 2}]; $CellContext`fp$ = 
         Values[
           $CellContext`fit["BestFitParameters"]]; $CellContext`ell12$ = Table[
           Ellipsoid[{
             Part[$CellContext`fp$, 1], 
             Part[$CellContext`fp$, 2]}, Quiet[
              InverseCDF[
               ChiSquareDistribution[
               2], $CellContext`confi]] $CellContext`cm12$], \
{$CellContext`confi, {0.68, 0.95, 0.99}}]; $CellContext`ell23$ = Table[
           Ellipsoid[{
             Part[$CellContext`fp$, 2], 
             Part[$CellContext`fp$, 3]}, Quiet[
              InverseCDF[
               ChiSquareDistribution[
               2], $CellContext`confi]] $CellContext`cm23$], \
{$CellContext`confi, {0.68, 0.95, 0.99}}]; $CellContext`ell13$ = Table[
           Ellipsoid[{
             Part[$CellContext`fp$, 1], 
             Part[$CellContext`fp$, 3]}, Quiet[
              InverseCDF[
               ChiSquareDistribution[
               2], $CellContext`confi]] $CellContext`cm13$], \
{$CellContext`confi, {0.68, 0.95, 0.99}}]; $CellContext`lp3a = Graphics[{
            EdgeForm[{Thick, Red, Dashed}], 
            FaceForm[{White, 
              Opacity[0.4]}], {
             Directive[
              AbsolutePointSize[12], Green], 
             Point[{$CellContext`multiplier$$, $CellContext`\[Delta]$$}]}, {
             Directive[
              AbsolutePointSize[12], Red], 
             Point[{
               Part[$CellContext`fp$, 1], 
               Part[$CellContext`fp$, 2]}]}, $CellContext`ell12$}, Frame -> 
           True, FrameLabel -> {"I (a.u.)", "\[Delta] (\[Degree]2\[Theta])"}, 
           AspectRatio -> 1, ImageSize -> 250]; $CellContext`lp3b = Graphics[{
            EdgeForm[{Thick, Red, Dashed}], 
            FaceForm[{White, 
              Opacity[0.4]}], {
             Directive[
              AbsolutePointSize[12], Green], 
             Point[{$CellContext`\[Delta]$$, $CellContext`\[Sigma]$$}]}, {
             Directive[
              AbsolutePointSize[12], Red], 
             Point[{
               Part[$CellContext`fp$, 2], 
               Part[$CellContext`fp$, 3]}]}, $CellContext`ell23$}, Frame -> 
           True, FrameLabel -> {
            "\[Delta] (\[Degree]2\[Theta])", "\[Sigma] (\[Degree]2\[Theta])"},
            AspectRatio -> 1, ImageSize -> 250]; $CellContext`lp3c = Graphics[{
            EdgeForm[{Thick, Red, Dashed}], 
            FaceForm[{White, 
              Opacity[0.4]}], {
             Directive[
              AbsolutePointSize[12], Green], 
             Point[{$CellContext`multiplier$$, $CellContext`\[Sigma]$$}]}, {
             Directive[
              AbsolutePointSize[12], Red], 
             Point[{
               Part[$CellContext`fp$, 1], 
               Part[$CellContext`fp$, 3]}]}, $CellContext`ell13$}, Frame -> 
           True, FrameLabel -> {"I (a.u.)", "\[Sigma] (\[Degree]2\[Theta])"}, 
           AspectRatio -> 1, ImageSize -> 250]; $CellContext`lp1$ = Plot[
           $CellContext`fit[$CellContext`x], {$CellContext`x, \
$CellContext`leftbound$, $CellContext`rightbound$}, Epilog -> 
           Point[$CellContext`dataXY$], PlotStyle -> {Orange, Thick}, 
           PlotRange -> {{$CellContext`leftbound$/$CellContext`xMag$$, \
$CellContext`rightbound$/$CellContext`xMag$$}, {$CellContext`low$, \
$CellContext`high$}}, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
           Frame -> True, 
           FrameLabel -> {
            "2\[Theta]-2\!\(\*SubscriptBox[\(\[Theta]\), \(0\)]\) \
(\[Degree])", "Intensity (a.u.)"}, 
           FrameTicks -> {{Automatic, None}, {Automatic, None}}, LabelStyle -> 
           Directive[Bold, 18], PlotLegends -> Placed[
             LineLegend[{"TCHZ Pseudo-Voigt plus fitted function"}], {
             Left, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], AspectRatio -> 0.7, ImageSize -> 
           1000]; $CellContext`fwhmpos$ = Graphics[{Red, 
            Arrowheads[{-0.02, 0.02}], 
            
            Arrow[{{(-$CellContext`fwhm$)/2, $CellContext`fit[0.]/
               2}, {$CellContext`fwhm$/2, $CellContext`fit[0.]/
               2}}]}]; $CellContext`lp2$ = 
         ListLinePlot[$CellContext`residuals$ $CellContext`diffMag$$, 
           DataRange -> {$CellContext`leftbound$, $CellContext`rightbound$}, 
           PlotRange -> {{$CellContext`leftbound$/$CellContext`xMag$$, \
$CellContext`rightbound$/$CellContext`xMag$$}, {$CellContext`low$, \
$CellContext`high$}}, PlotStyle -> {Blue, Thick}, LabelStyle -> 
           Directive[Bold, 18], PlotLegends -> Placed[
             LineLegend[{"difference"}], {Left, 0.8}]]; 
        If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`lp1$, \
$CellContext`lp2$}], $CellContext`export$$ = False}]; 
        Show[{$CellContext`lp1$, $CellContext`lp2$, $CellContext`fwhmpos$}]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.03, ""}, 1.*^-6, 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.03, ""}, 1.*^-6, 1., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 2}, 
        Grid[{{"\[Delta]      ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma]      ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {
          "mixing  \[Delta]/\[Sigma]      ", 
           Dynamic[
            NumberForm[
             $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}], 
        Delimiter, {{$CellContext`xMag$$, 1, "\[Theta]-axis spread"}, 1, 10, 
         1, ControlType -> Slider, Appearance -> 
         "Labeled"}, {{$CellContext`diffMag$$, 1, "residual multiplier"}, 1, 
         10, 1, ControlType -> Slider, Appearance -> 
         "Labeled"}, {{$CellContext`multiplier$$, 100, 
          "intensity multiplier"}, 5, 1000, 1, ControlType -> Slider, 
         Appearance -> 
         "Labeled"}, {{$CellContext`poisson$$, True, "Poisson statistics"}, {
         True, False}, ControlType -> Checkbox, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`methods$$, "LevenbergMarquardt", 
          "Minimization method"}, {
         "Gradient", "LevenbergMarquardt", "Newton"}, ControlType -> 
         RadioButton, Appearance -> 
         "Vertical"}, {{$CellContext`\[Delta]dev$$, 0., ""}, -25., 25., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`\[Sigma]dev$$, 0., ""}, -25., 25., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         4}, {{$CellContext`idev$$, 0., ""}, -25., 25., ControlType -> Slider,
          Appearance -> "Labeled", ControlPlacement -> 5}, 
        Grid[{{"start deviation Lorentzian \[Delta]", 
           Manipulate`Place[3], "%"}, {"start deviation Gaussian \[Sigma]  ", 
           Manipulate`Place[4], "%"}, {"start deviation intensity   ", 
           Manipulate`Place[5], "%"}}], Delimiter, 
        Grid[{{
           Dynamic[$CellContext`lp3a], 
           Dynamic[$CellContext`lp3b], 
           Dynamic[$CellContext`lp3c]}}], 
        Grid[{{"Adjusted \!\(\*SuperscriptBox[\(R\), \(2\)]\): ", 
           Dynamic[
            $CellContext`fit["AdjustedRSquared"]]}, {"Correlation Matrix: ", 
           Dynamic[
            MatrixForm[
             $CellContext`fit["CorrelationMatrix"]]]}, {"Covariance Matrix: ", 
           Dynamic[
            MatrixForm[
             $CellContext`fit["CovarianceMatrix"]]]}, {"Fitted parameters: ", 
           Dynamic[
            MatrixForm[
             $CellContext`fit["ParameterConfidenceIntervalTable"]]]}}], 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Fitting the Thompson-Cox-Hastings Pseudo-Voigt function\n"}, 
        LabelStyle -> Directive[
          GrayLevel[0], Bold, 18], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1838., {624., 630.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`fwhm = 
       0., $CellContext`abscissae = {-2, (-23)/12, (-11)/6, (-7)/4, (-5)/
         3, (-19)/12, (-3)/2, (-17)/12, (-4)/3, (-5)/4, (-7)/6, (-13)/
         12, -1, (-11)/12, (-5)/6, (-3)/4, (-2)/3, (-7)/12, (-1)/2, (-5)/
         12, (-1)/3, (-1)/4, (-1)/6, (-1)/12, 0}, $CellContext`Voigtfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Module[{$CellContext`fg = 
          Sqrt[8 Log[2]] $CellContext`\[Sigma], $CellContext`fl = 
          2 $CellContext`\[Delta]}, 0.5346 $CellContext`fl + 
         Sqrt[0.2166 $CellContext`fl $CellContext`fl + $CellContext`fg \
$CellContext`fg]], $CellContext`\[Sigma]$$ = 
       0.3, $CellContext`TCHPseudoVoigtTable[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`abscissae, 
          Blank[]]] := Chop[
         $CellContext`TCHPseudoVoigt[$CellContext`\[Delta], $CellContext`\
\[Sigma], $CellContext`x0, $CellContext`abscissae]], \
$CellContext`TCHPseudoVoigt[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       Block[{$CellContext`FWHMg = $CellContext`\[Sigma] 
           Sqrt[8 Log[2]], $CellContext`FWHMl = 
          2 $CellContext`\[Delta], $CellContext`FWHMv = ($CellContext`FWHMl^5 + \
$CellContext`FWHMg^5 + 2.69296 $CellContext`FWHMg^4 $CellContext`FWHMl + 
            2.42843 $CellContext`FWHMg^3 $CellContext`FWHMl^2 + 
            4.47163 $CellContext`FWHMg^2 $CellContext`FWHMl^3 + 
            0.07842 $CellContext`FWHMg $CellContext`FWHMl^4)^(1/
            5), $CellContext`\[Eta]}, $CellContext`\[Eta] = \
$CellContext`FWHMl/$CellContext`FWHMv; $CellContext`\[Eta] = $CellContext`\
\[Eta] (1.36603 - 0.47719 $CellContext`\[Eta] + 
            0.11116 $CellContext`\[Eta]^2); (
            1 - $CellContext`\[Eta]) $CellContext`Gauss2[$CellContext`FWHMv/
             Sqrt[8 Log[
               2]], $CellContext`x0, $CellContext`x] + $CellContext`\[Eta] \
$CellContext`Lorentz[$CellContext`FWHMv/
             2, $CellContext`x0, $CellContext`x]], $CellContext`Gauss2[
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := 
       1/((Sqrt[2 Pi] $CellContext`\[Sigma]) 
        E^(($CellContext`x - $CellContext`x0)^2/(
          2 $CellContext`\[Sigma]^2))), $CellContext`Lorentz[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := (1/(Pi $CellContext`\[Delta])) (1/(
         1 + (($CellContext`x - $CellContext`x0)/$CellContext`\[Delta])^2)), \
$CellContext`data = CompressedData["
1:eJw0XHc81e8Xt6MoktmSIhqShubnEPJtp10qspqaSntop6GBKCXKiMpeqWMT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        "], $CellContext`filePath = 
       "C:\\Users\\dinne\\DeskTop\\Voigt_function.jpg", $CellContext`Gaussfwhm[
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       2 Sqrt[2 Log[2]] $CellContext`\[Sigma], $CellContext`Lorentzfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]]] := 2 $CellContext`\[Delta], $CellContext`Mix[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Block[{$CellContext`FWHMg = $CellContext`\[Sigma] 
           Sqrt[8 Log[2]], $CellContext`FWHMl = 
          2 $CellContext`\[Delta], $CellContext`FWHMv = ($CellContext`FWHMl^5 + \
$CellContext`FWHMg^5 + 2.69296 $CellContext`FWHMg^4 $CellContext`FWHMl + 
            2.42843 $CellContext`FWHMg^3 $CellContext`FWHMl^2 + 
            4.47163 $CellContext`FWHMg^2 $CellContext`FWHMl^3 + 
            0.07842 $CellContext`FWHMg $CellContext`FWHMl^4)^(1/
            5), $CellContext`\[Eta]}, $CellContext`\[Eta] = \
$CellContext`FWHMl/$CellContext`FWHMv; $CellContext`\[Eta] = $CellContext`\
\[Eta] (1.36603 - 0.47719 $CellContext`\[Eta] + 
            0.11116 $CellContext`\[Eta]^2); Null]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.817104883470211*^9, 3.817104936006906*^9, 3.817105081371746*^9, {
   3.817105144257554*^9, 3.817105167801739*^9}, {3.8171052343913417`*^9, 
   3.8171052529303293`*^9}, 3.8171054219119673`*^9, 3.8171055055005155`*^9, {
   3.8171056513401775`*^9, 3.8171056597474566`*^9}, 3.817105692913767*^9, 
   3.8171057336594763`*^9, 3.817105832934914*^9, 3.817105895425012*^9, 
   3.8171059292223845`*^9, {3.8171060367400017`*^9, 3.8171060605980854`*^9}, {
   3.8171061113145075`*^9, 3.817106156333323*^9}, 3.817106203248412*^9, 
   3.8171063257626996`*^9, 3.8171063686991816`*^9, 3.8171064493308897`*^9, 
   3.8171065162713823`*^9, {3.8171065740665903`*^9, 3.8171065798373656`*^9}, 
   3.817106705552807*^9, 3.8171102258616633`*^9, 3.817110266689021*^9, {
   3.8171102980178385`*^9, 3.817110309491757*^9}, 3.81711034217679*^9, {
   3.8171104434051027`*^9, 3.8171104499242897`*^9}, {3.817110627765266*^9, 
   3.817110656368423*^9}, {3.817110697220559*^9, 3.817110738897667*^9}, 
   3.8171290537662334`*^9, 3.8171291446008162`*^9, 3.817129431605559*^9, 
   3.817129464951763*^9, 3.8171294961722555`*^9, 3.817130021160573*^9, 
   3.8171321866933928`*^9, 3.81713288365072*^9, 3.8171339227151585`*^9, 
   3.8171341141488905`*^9, 3.817134181163782*^9, 3.8171342456982827`*^9, 
   3.8171343499840775`*^9, 3.817135460341444*^9, 3.8171371332459774`*^9, 
   3.817137241109149*^9, 3.817186307680153*^9, 3.817186481432849*^9, {
   3.8171887071218247`*^9, 3.8171887089031787`*^9}, 3.8171888142794547`*^9, 
   3.8171891072370205`*^9, 3.817189361865525*^9, 3.8171894692015843`*^9, {
   3.8171895437118397`*^9, 3.8171895703216815`*^9}, 3.8171896507601676`*^9, 
   3.817190029031384*^9, 3.8171901572677155`*^9, 3.8171902731910343`*^9, 
   3.8171905330052223`*^9, 3.8171906416491795`*^9, 3.8171907213534355`*^9, {
   3.8171908049030223`*^9, 3.8171908328424444`*^9}, 3.817190902184114*^9, 
   3.8171909354813576`*^9, 3.8171909775757313`*^9, {3.8171910107480636`*^9, 
   3.8171910300703344`*^9}, 3.8171910875149016`*^9, 3.817191517661665*^9, 
   3.817191603635948*^9, {3.818844313348957*^9, 3.8188443353053155`*^9}, 
   3.820118103606408*^9, 3.820588859545227*^9, {3.820646653260991*^9, 
   3.8206466731194572`*^9}, 3.823586901928031*^9, 3.8242842316195035`*^9, 
   3.8242952247481728`*^9, {3.8242955202126784`*^9, 3.8242955439010253`*^9}, 
   3.82429600638737*^9, 3.8242979359858956`*^9, 3.8242983115986347`*^9, 
   3.8242985361459026`*^9, 3.82430092559267*^9, 3.8243032708585696`*^9, 
   3.824306678424538*^9, 3.824307644086832*^9, 3.82435507010107*^9, 
   3.8243576365993586`*^9, 3.8243632010729637`*^9, 3.8243636462279196`*^9, 
   3.824381845065806*^9, 3.8243824871251*^9, 3.824639895750842*^9, 
   3.8246401937573595`*^9, {3.8246403169166765`*^9, 3.8246403256196613`*^9}, 
   3.824640391215489*^9, 3.824641945797409*^9, {3.824641994265025*^9, 
   3.8246420194153137`*^9}, 3.824643428592519*^9, 3.8249602113828316`*^9, 
   3.8249607616441917`*^9, 3.8254752966233225`*^9, 3.8268597010524125`*^9, 
   3.827836501466479*^9, 3.8278375435937357`*^9, 3.8278381144093885`*^9, 
   3.827838289255926*^9, {3.8278396293565016`*^9, 3.8278396329065695`*^9}, 
   3.827839681656881*^9, 3.827914440523822*^9, 3.8279155182501793`*^9, 
   3.827915556415865*^9, 3.827916709137551*^9, 3.8279168927853575`*^9, 
   3.827976008854499*^9, 3.8279763275498347`*^9, {3.828089107444456*^9, 
   3.828089122300652*^9}, 3.828089179116559*^9, 3.828089269830759*^9, 
   3.8280911894399524`*^9, 3.8280918128953204`*^9, 3.828092859603071*^9, 
   3.8280929140247645`*^9, 3.8281057715129294`*^9, 3.828106040737187*^9, 
   3.828106152693313*^9, 3.8281553870973167`*^9, 3.828156021446644*^9, 
   3.8281600480436387`*^9, 3.828161192299713*^9, {3.8281613004008675`*^9, 
   3.828161323781352*^9}, 3.8281614583060694`*^9, 3.8281616525196705`*^9, 
   3.8281625806407385`*^9, 3.8281708423048816`*^9, 3.8281710317593994`*^9, {
   3.828171064980157*^9, 3.8281710817022195`*^9}, 3.828171267780262*^9, {
   3.828171782831941*^9, 3.828171812804854*^9}, 3.828173725337753*^9, 
   3.8285021535687404`*^9, 3.8285034818849316`*^9, 3.8285794490289125`*^9, 
   3.8285811371649218`*^9, 3.828583053071848*^9, 3.8285842426698236`*^9, 
   3.828591672180942*^9, 3.8285920919278975`*^9, 3.828593118937314*^9, 
   3.828593432965062*^9, 3.8285939773030663`*^9, 3.8298003593221416`*^9, 
   3.8298004916803875`*^9, 3.8298077132554593`*^9, 3.829809188552467*^9, 
   3.8299651358052197`*^9, 3.8305859168958836`*^9, 3.8305860070431976`*^9, {
   3.8305877068929768`*^9, 3.8305877345435815`*^9}, 3.8305919222332363`*^9, 
   3.830594800794834*^9, 3.8305950120603933`*^9, 3.8316164637620487`*^9, 
   3.832143734556492*^9, 3.8321449532482653`*^9, 3.8321450651934814`*^9, 
   3.832145174662655*^9, 3.851048138417324*^9, 3.8510501720316477`*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"dec511d6-31b7-4290-a739-da2088f7cff6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Angular dependence of TCHZ PseudoVoigt ", "Chapter",
 CellChangeTimes->{{3.8171293231134663`*^9, 3.8171293556157618`*^9}, {
  3.8201183611435833`*^9, 
  3.820118362534153*^9}},ExpressionUUID->"542d06d3-e7a9-409c-8b21-\
a8912066744d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\[Theta]\[Theta]", ",", "\[Delta]", ",", " ", "\[Sigma]", ",", " ", 
        "\[Eta]", ",", "fwhmg", ",", "fwhml", ",", "fwhmv", ",", "fwhmFT", 
        ",", "mix", ",", "min2\[Theta]", ",", " ", "max2\[Theta]", ",", 
        "range2\[Theta]", ",", "ranges", ",", "TCHZ", ",", "FTTCH", ",", 
        "FWHM\[Theta]\[Theta]", ",", "FWHMs", ",", "FWHMPos1", ",", 
        "FWHMPos2", ",", "FWHMPos3", ",", "FWHMPosFT"}], "}"}], ",", 
      "\[IndentingNewLine]", "  ", 
      RowBox[{
       RowBox[{"\[Theta]\[Theta]", "                    ", "=", " ", 
        RowBox[{"\[Theta]2", "[", 
         RowBox[{"ss0", ",", "\[Lambda]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{
        RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]_", "]"}], "         ", ":=", 
        RowBox[{"2", " ", 
         RowBox[{"Delta\[Theta]", "[", 
          RowBox[{"X", ",", "Y", ",", 
           RowBox[{"\[Theta]\[Theta]", "/", "2"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{
        RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]_", "]"}], "         ", ":=", 
        RowBox[{"2", " ", 
         RowBox[{"Sigma\[Theta]", "[", 
          RowBox[{"u", ",", "v", ",", "w", ",", "z", ",", 
           RowBox[{"\[Theta]\[Theta]", "/", "2"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{
        RowBox[{"\[Eta]", "[", "\[Theta]\[Theta]_", "]"}], "         ", ":=", 
        RowBox[{"Mix", "[", 
         RowBox[{
          RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
          RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{
        RowBox[{"fwhmg", "[", "\[Theta]\[Theta]_", "]"}], ":=", 
        RowBox[{"Gaussfwhm", "[", 
         RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{
        RowBox[{"fwhml", "[", "\[Theta]\[Theta]_", "]"}], ":=", 
        RowBox[{"Lorentzfwhm", "[", " ", 
         RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}]}], ";", 
       "   ", "\[IndentingNewLine]", "  ", 
       RowBox[{
        RowBox[{"fwhmv", "[", "\[Theta]\[Theta]_", "]"}], ":=", 
        RowBox[{"Voigtfwhm", "[", 
         RowBox[{
          RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
          RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"fwhmFT", "           ", "=", " ", 
        RowBox[{"FTVoigtfwhm", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], " ", 
           RowBox[{"cs", "[", 
            RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], " ", 
           RowBox[{"cs", "[", 
            RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}]}], " ", 
         "]"}]}], ";", "\[IndentingNewLine]", "  ", 
       RowBox[{"mix", "                  ", "=", 
        RowBox[{"Mix", "[", 
         RowBox[{
          RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
          RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", "  ", 
       RowBox[{"min2\[Theta]", "           ", "=", " ", 
        RowBox[{"\[Theta]\[Theta]", " ", "-", 
         RowBox[{"6.", 
          RowBox[{
           RowBox[{"fwhmv", "[", "45", "]"}], "/", "xMag"}]}]}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"max2\[Theta]", "            ", "=", 
        RowBox[{"\[Theta]\[Theta]", " ", "+", 
         RowBox[{"6.", 
          RowBox[{
           RowBox[{"fwhmv", "[", "45", "]"}], "/", "xMag"}]}]}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"range2\[Theta]", "      ", "=", " ", 
        RowBox[{"{", 
         RowBox[{"min2\[Theta]", ",", "max2\[Theta]"}], "}"}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"ranges", "        ", "=", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"s", "[", 
           RowBox[{"min2\[Theta]", ",", "\[Lambda]"}], "]"}], ",", 
          RowBox[{"s", "[", 
           RowBox[{"max2\[Theta]", ",", "\[Lambda]"}], "]"}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"TCHZ", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"TCHPseudoVoigt", "[", 
             RowBox[{
              RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
              RowBox[{"\[Sigma]", " ", "[", "\[Theta]\[Theta]", "]"}], ",", 
              "\[Theta]\[Theta]", ",", "\[Theta]2"}], "]"}], "/", 
            "\[IndentingNewLine]", "                     ", 
            RowBox[{"TCHPseudoVoigt", "[", 
             RowBox[{
              RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
              RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], ",", 
              "\[Theta]\[Theta]", ",", "\[Theta]\[Theta]"}], "]"}]}], "}"}], 
          ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[Theta]2", ",", "min2\[Theta]", ",", "max2\[Theta]"}], 
           "}"}], ",", "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
          RowBox[{"FillingStyle", "\[Rule]", "Automatic"}], ",", 
          "\[IndentingNewLine]", "\t\t\t ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", " ", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<2\[Theta] (\[Degree])\>\"", ",", 
             "\"\<normalized intensity\>\"", ",", 
             "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) (\!\(\*SuperscriptBox[\
\(nm\), \(-1\)]\))\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", 
               RowBox[{"Charting`FindTicks", "[", 
                RowBox[{"range2\[Theta]", " ", ",", "ranges"}], "]"}]}], 
              "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", "\"\<TCHZ-Pseudo-Voigt\>\"", "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                            ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"ImageSize", "\[Rule]", "600"}]}], "\[IndentingNewLine]", 
         "                    ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"FTTCH", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"FTVoigt", "[", 
           RowBox[{"k", ",", 
            RowBox[{
             RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], 
             RowBox[{"cs", "[", 
              RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], 
             RowBox[{"cs", "[", 
              RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}]}], 
           "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{
             RowBox[{"-", "30."}], "/", "kMag"}], ",", 
            RowBox[{"30.", "/", "kMag"}]}], "}"}], ",", "     ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"k", ",", 
              RowBox[{
               RowBox[{"-", "3."}], "/", " ", 
               RowBox[{"(", 
                RowBox[{"kMag", " ", 
                 RowBox[{"fwhmv", "[", "\[Theta]\[Theta]", "]"}]}], ")"}]}], 
              ",", 
              RowBox[{"3.", "/", 
               RowBox[{"(", 
                RowBox[{"kMag", " ", 
                 RowBox[{"fwhmv", "[", "\[Theta]\[Theta]", "]"}]}], ")"}]}]}],
              "}"}], ","}], " ", "*)"}], "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"PlotRange", "\[Rule]", " ", "Full"}], ",", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
          RowBox[{"FillingStyle", "\[Rule]", "Automatic"}], ",", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
            "}"}]}], ",", "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "All"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", "\"\<analytical FT\>\"", "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                           ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"ImageSize", "\[Rule]", "600"}]}], "\[IndentingNewLine]", 
         "                          ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHM\[Theta]\[Theta]", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"fwhmg", "[", "\[Theta]2", "]"}], ",", " ", 
            RowBox[{"fwhml", "[", "\[Theta]2", "]"}], ",", "  ", 
            RowBox[{"fwhmv", "[", "\[Theta]2", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[Theta]2", ",", "0.01", ",", "160.0"}], "}"}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]",
           "\t\t\t ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<2\[Theta] (\[Degree])\>\"", ",", 
             "\"\<FWHM (\[Degree]2\[Theta])\>\"", ",", 
             "\"\<2\[Theta] (\[Degree])\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "All"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<FWHM(G)\>\"", ",", "\"\<FWHM(L)\>\"", ",", 
                "\"\<FWHM(PV)\>\""}], " ", "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                            ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"ImageSize", "\[Rule]", "600"}]}], "\[IndentingNewLine]", 
         "                         ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHMs", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"fwhmg", "[", 
              RowBox[{"\[Theta]2", "[", 
               RowBox[{"x", ",", "\[Lambda]"}], "]"}], "]"}], 
             RowBox[{"cs", "[", 
              RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}], ",", 
            " ", 
            RowBox[{
             RowBox[{"fwhml", "[", 
              RowBox[{"\[Theta]2", "[", 
               RowBox[{"x", ",", "\[Lambda]"}], "]"}], "]"}], 
             RowBox[{"cs", "[", 
              RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"fwhmv", "[", 
              RowBox[{"\[Theta]2", "[", 
               RowBox[{"x", ",", "\[Lambda]"}], "]"}], "]"}], 
             RowBox[{"cs", "[", 
              RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}]}], 
           "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"s", "[", 
             RowBox[{"0.01", ",", "\[Lambda]"}], "]"}], ",", 
            RowBox[{"s", "[", 
             RowBox[{"160.0", ",", "\[Lambda]"}], "]"}]}], "}"}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]",
           "\t\t\t ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
             "\"\<FWHM (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\""}], 
            "}"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"All", ",", 
               RowBox[{"Charting`FindTicks", "[", 
                RowBox[{"ranges", ",", "range2\[Theta]"}], "]"}]}], "}"}]}], 
            "}"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<FWHM(G)\>\"", ",", "\"\<FWHM(L)\>\"", ",", 
                "\"\<FWHM(PV)\>\""}], " ", "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                            ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"ImageSize", "\[Rule]", "600"}]}], "\[IndentingNewLine]", 
         "                         ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHMPos1", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"\[Theta]\[Theta]", ",", 
              RowBox[{"fwhmv", "[", "\[Theta]\[Theta]", "]"}]}], "}"}], 
            "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHMPos2", " ", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", " ", 
           RowBox[{"Arrowheads", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}], "]"}], ",", " ", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\[Theta]\[Theta]", "-", 
                 RowBox[{
                  RowBox[{"fwhmv", "[", "\[Theta]\[Theta]", "]"}], "/", 
                  "2"}]}], ",", "0.5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\[Theta]\[Theta]", "+", 
                 RowBox[{
                  RowBox[{"fwhmv", "[", "\[Theta]\[Theta]", "]"}], "/", 
                  "2"}]}], ",", "0.5"}], "}"}]}], "}"}], "]"}]}], "}"}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"FWHMPos3", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"s", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}], ",", 
              RowBox[{
               RowBox[{"fwhmv", "[", "\[Theta]\[Theta]", "]"}], 
               RowBox[{"cs", "[", 
                RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}]}], 
             "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHMPosFT", " ", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", " ", 
           RowBox[{"Arrowheads", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}], "]"}], ",", " ", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "fwhmFT"}], "/", "2"}], ",", "0.5"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"+", "fwhmFT"}], "/", "2"}], ",", "0.5"}], "}"}]}], 
             "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", " ", 
       RowBox[{"If", "[", 
        RowBox[{"export", ",", 
         RowBox[{
          RowBox[{"Export", "[", 
           RowBox[{"filePath", ",", 
            RowBox[{"{", 
             RowBox[{
             "TCHZ", ",", "FWHM\[Theta]\[Theta]", ",", "FTTCH", ",", " ", 
              "FWHMs"}], "}"}]}], "]"}], ";", 
          RowBox[{"export", "=", "False"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Show", "[", 
             RowBox[{"TCHZ", ",", "FWHMPos2"}], "]"}], ",", "     ", 
            RowBox[{"Show", "[", 
             RowBox[{"FWHM\[Theta]\[Theta]", ",", "FWHMPos1"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", "          ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Show", "[", 
             RowBox[{"FTTCH", ",", "FWHMPosFT"}], "]"}], ",", 
            RowBox[{"Show", "[", 
             RowBox[{"FWHMs", ",", "   ", "FWHMPos3"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "           ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Grid", "[", 
             RowBox[{
              RowBox[{"{", "\[IndentingNewLine]", "              ", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Text", "[", 
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<Parameter Gaussian\>\"", ",", "Bold", ",", "20"}], 
                   "]"}], "]"}], "}"}], ",", "    ", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", 
                 RowBox[{"\"\<Gauss    \[Sigma]  \>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", 
                "              ", "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"Gaussfwhm", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Gaussfwhm", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], "}"}],
                 ",", "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Gauss   IB  \>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"GaussIB", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"GaussIB", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], "}"}],
                 ",", "\[IndentingNewLine]", "               ", 
                RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", 
                 RowBox[{"Text", "[", 
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<Parameter Lorentzian\>\"", ",", "Bold", ",", "20"}], 
                   "]"}], "]"}], "}"}], ",", "               ", 
                "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Lorentz \[Delta]  \>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", 
                "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"Lorentzfwhm", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Lorentzfwhm", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], "}"}],
                 ",", "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Lorentz IB  \>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"LorentzIB", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"LorentzIB", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], 
                 "}"}]}], "\[IndentingNewLine]", "         ", "}"}], ",", 
              RowBox[{"Frame", "\[Rule]", "True"}], " ", ",", 
              RowBox[{"ItemStyle", "\[Rule]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Bold"}], 
                "]"}]}]}], " ", "]"}], ",", "\[IndentingNewLine]", 
            "              ", 
            RowBox[{"Grid", "[", 
             RowBox[{
              RowBox[{"{", "\[IndentingNewLine]", "              ", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Text", "[", 
                  RowBox[{"Style", "[", 
                   RowBox[{
                   "\"\<Parameter Pseudo-Voigt\>\"", ",", "Bold", ",", "20"}],
                    "]"}], "]"}], "}"}], ",", "               ", 
                "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Voigt  fwhm \>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"Voigtfwhm", "[", 
                    RowBox[{
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
                    " ", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}]}], " ",
                     "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Voigtfwhm", "[", 
                    RowBox[{
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
                    " ", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}]}], " ",
                     "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], "}"}],
                 ",", "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<Voigt  IB   \>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"GaussIB", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], 
                    "]"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
                  "\"\<\[Degree]2\[Theta] (\>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"GaussIB", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], 
                    "]"}]}], " ", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], "]"}], ",", 
                  "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )\>\""}], "}"}],
                 ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "               ", 
                RowBox[{"{", 
                 RowBox[{"\"\<Lorentz  part \>\"", ",", "  ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"(", "           ", 
                    RowBox[{"mix", "*", "100"}], ")"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}]}], "]"}], ",", 
                  "\"\<%\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", 
                 RowBox[{"\"\<Gauss    part \>\"", ",", "  ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"100", "-", 
                    RowBox[{"mix", "*", "100"}]}], ")"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "1"}], "}"}]}], "]"}], ",", 
                  "\"\<%\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", "              ", 
                RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<FT     fwhm  \>\"", ",", " ", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{"fwhmFT", ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
                  "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<LVol   fwhm  \>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Voigtfwhm", "[", 
                    RowBox[{
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], ",", 
                    " ", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}]}], " ",
                     "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
                  "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<LVol   IB    \>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"GaussIB", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], 
                    "]"}]}], " ", "]"}], 
                    RowBox[{"cs", "[", 
                    RowBox[{
                    RowBox[{"\[Theta]2", "[", 
                    RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
                    "\[Lambda]"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"5", ",", "1"}], "}"}]}], "]"}], ",", 
                  "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
                "              ", 
                RowBox[{"{", "  ", 
                 RowBox[{"\"\<e0           \>\"", ",", 
                  RowBox[{"NumberForm", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"VoigtIB", "[", 
                    RowBox[{
                    RowBox[{"LorentzIB", "[", 
                    RowBox[{"\[Delta]", "[", "\[Theta]\[Theta]", "]"}], "]"}],
                     ",", 
                    RowBox[{"GaussIB", "[", 
                    RowBox[{"\[Sigma]", "[", "\[Theta]\[Theta]", "]"}], 
                    "]"}]}], "]"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Pi]", "/", "360"}], "/", "4"}], ")"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "}"}]}], 
               "              ", "\[IndentingNewLine]", "        ", "}"}], 
              ",", 
              RowBox[{"Frame", "\[Rule]", "True"}], " ", ",", 
              RowBox[{"ItemStyle", "\[Rule]", 
               RowBox[{"Directive", "[", 
                RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "18"}], ",", "Bold"}], 
                "]"}]}]}], " ", "]"}]}], "\[IndentingNewLine]", "       ", 
           "}"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "     ", 
         "}"}], "]"}]}]}], " ", "\[IndentingNewLine]", "]"}]}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Parameter diffractometer\>\"", ",", "Bold", ",", "15"}],
          "]"}], "]"}], "}"}], ",", "               ", "\[IndentingNewLine]", 
      "              ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<wavelength \>\"", ",", "              ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "      ", 
            RowBox[{
            "\[Lambda]", ",", "       ", "0.154059", ",", "\"\<\>\""}], "}"}],
            ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "              ", 
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))\>\"", ",", 
        "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", " ", 
            RowBox[{"ss0", ",", "5.", ",", "\"\<\>\""}], "}"}], ",", "0.001", 
           ",", 
           RowBox[{"2.", "/", "\[Lambda]"}], ",", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", ",", "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], "}"}], 
      ",", "\[IndentingNewLine]", "               ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<peak center ( d)\>\"", ",", "  ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"1", "/", "ss0"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
       "}"}], ",", "\[IndentingNewLine]", "               ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<peak center (2\[Theta])\>\"", ",", "  ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", " ", 
          RowBox[{
           RowBox[{"\[Theta]2", "[", 
            RowBox[{"ss0", ",", "\[Lambda]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
        "\"\<\[Degree]\>\""}], "}"}]}], "               ", 
     "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", " ", "Delimiter", ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Parameter Gaussian\>\"", ",", "Bold", ",", "15"}], 
         "]"}], "]"}], "}"}], ",", "               ", "\[IndentingNewLine]", 
      "              ", 
      RowBox[{"{", 
       RowBox[{"\"\<u         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"u", ",", "0.05", ",", "\"\<\>\""}], "}"}], ",", 
           "0.000001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"u", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}]}], " ", "}"}], ",", "     ", 
      "\[IndentingNewLine]", "              ", 
      RowBox[{"{", 
       RowBox[{"\"\<v         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"v", ",", "0.000001", ",", "\"\<\>\""}], "}"}], ",", 
           "0.000001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"v", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}]}], " ", "}"}], ",", "     ", 
      "\[IndentingNewLine]", "              ", 
      RowBox[{"{", 
       RowBox[{"\"\<w         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"w", ",", "0.000001", ",", "\"\<\>\""}], "}"}], ",", 
           "0.000001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"w", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}]}], " ", "}"}], ",", "     ", 
      "\[IndentingNewLine]", "              ", 
      RowBox[{"{", 
       RowBox[{"\"\<z         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", "0.000001", ",", "\"\<\>\""}], "}"}], ",", 
           "0.000001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"z", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}]}], " ", "}"}]}], 
     "                  ", "\[IndentingNewLine]", "        ", "}"}], "]"}], 
   ",", "\[IndentingNewLine]", "    ", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Parameter Lorentzian\>\"", ",", "Bold", ",", "15"}], 
         "]"}], "]"}], "}"}], ",", "               ", "\[IndentingNewLine]", 
      "              ", 
      RowBox[{"{", 
       RowBox[{"\"\<X         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"X", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
           "0.000001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"X", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}]}], " ", "}"}], ",", "     ", 
      "\[IndentingNewLine]", "              ", 
      RowBox[{"{", 
       RowBox[{"\"\<Y         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Y", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
           "0.000001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Y", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}]}], " ", "}"}]}], 
     "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "  ", "Delimiter", ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{"Control", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "       ", 
       RowBox[{
       "xMag", ",", "1.", ",", "\"\<zoom factor in 2\[Theta]-space\>\""}], 
       "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
      ",", 
      RowBox[{"Exclusions", "\[Rule]", 
       RowBox[{"{", "0", "}"}]}], ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
   ",", " ", "\[IndentingNewLine]", " ", 
   RowBox[{"Control", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "       ", 
       RowBox[{
       "kMag", ",", "1.", ",", "\"\<zoom factor in Fourier-space\>\""}], 
       "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
      ",", 
      RowBox[{"Exclusions", "\[Rule]", 
       RowBox[{"{", "0", "}"}]}], ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
   ",", " ", "\[IndentingNewLine]", "  ", "Delimiter", ",", 
   "\[IndentingNewLine]", "   ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
   "\[IndentingNewLine]", "        ", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Export to desktop\>\"", ",", 
     RowBox[{"export", "=", "True"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "        ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
      "\"\<TCHZ-PseudoVoigt\\n\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SaveDefinitions", "\[Rule]", "True"}], " ", ","}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[Rule]", "True"}]}], "  ", 
  "\[IndentingNewLine]", " ", "]"}]], "Input",
 CellChangeTimes->{{3.720419184397894*^9, 3.720419184397894*^9}, 
   3.720425362059741*^9, 3.720425394736561*^9, {3.7204254283629923`*^9, 
   3.720425459227189*^9}, {3.7204255143878975`*^9, 3.720425535845173*^9}, {
   3.7204307540476737`*^9, 3.7204307623489804`*^9}, {3.7815186593573837`*^9, 
   3.781518684979077*^9}, {3.781518753761201*^9, 3.781518754556816*^9}, {
   3.781518813483551*^9, 3.781518862313817*^9}, {3.7815189977922335`*^9, 
   3.7815190510019164`*^9}, {3.781519104680606*^9, 3.781519229903214*^9}, {
   3.78151926462366*^9, 3.7815192925384183`*^9}, {3.781519536078747*^9, 
   3.7815195367963557`*^9}, {3.7815200173336153`*^9, 
   3.7815200598239613`*^9}, {3.781520645254632*^9, 3.78152065133971*^9}, {
   3.7815207024287663`*^9, 3.7815207046137943`*^9}, 3.7815207537236257`*^9, {
   3.7815209232512035`*^9, 3.781520952228775*^9}, {3.7815209972349777`*^9, 
   3.781521050198058*^9}, {3.7816057061807384`*^9, 3.781605748405881*^9}, {
   3.7816057951112814`*^9, 3.7816058274438963`*^9}, {3.7816063675875072`*^9, 
   3.7816063703331423`*^9}, {3.781606926733992*^9, 3.7816069337404823`*^9}, {
   3.7816084632711415`*^9, 3.781608479916661*^9}, {3.78160872664314*^9, 
   3.7816087381163692`*^9}, {3.7820165225809402`*^9, 
   3.7820165533905573`*^9}, {3.7820166161878147`*^9, 3.782016730038094*^9}, {
   3.782016883354186*^9, 3.782016895337426*^9}, {3.7820169873362904`*^9, 
   3.7820170101127462`*^9}, {3.78201793848847*^9, 3.7820180340776925`*^9}, {
   3.7820188017849846`*^9, 3.782018847698904*^9}, {3.782018904275037*^9, 
   3.7820189159692707`*^9}, {3.7820189723764005`*^9, 
   3.7820189828096094`*^9}, {3.7820197256275043`*^9, 3.782019740451801*^9}, {
   3.7820222830793295`*^9, 3.782022293351638*^9}, {3.782022327301657*^9, 
   3.782022333893855*^9}, {3.782022374466073*^9, 3.782022378847204*^9}, {
   3.782022541480973*^9, 3.7820225420909853`*^9}, {3.7820238825858054`*^9, 
   3.7820239034212227`*^9}, {3.7820239357908707`*^9, 
   3.7820239391809387`*^9}, {3.782023982614808*^9, 3.7820239883769236`*^9}, {
   3.782024042961016*^9, 3.78202412040559*^9}, {3.782024160280389*^9, 
   3.7820241812578087`*^9}, {3.782029038046695*^9, 3.782029043168207*^9}, 
   3.7820295411891456`*^9, {3.782029572278768*^9, 3.78202962432181*^9}, {
   3.782035692534664*^9, 3.782035734376848*^9}, {3.782035772610671*^9, 
   3.7820357901074204`*^9}, {3.7820358226526747`*^9, 
   3.7820359114805565`*^9}, {3.782035957027111*^9, 3.7820360157409816`*^9}, {
   3.7820360462694616`*^9, 3.7820360679554615`*^9}, {3.7820361567594614`*^9, 
   3.7820361819744616`*^9}, 3.7820362242754617`*^9, {3.7820362852314615`*^9, 
   3.7820363007744617`*^9}, {3.7820365513985467`*^9, 3.782036554902897*^9}, 
   3.782036598379244*^9, {3.782036633930799*^9, 3.7820366890563107`*^9}, {
   3.782036759583363*^9, 3.782036792896694*^9}, {3.7820369927616787`*^9, 
   3.782036995345937*^9}, {3.782037713057701*^9, 3.7820378402244167`*^9}, {
   3.7820380097113633`*^9, 3.782038018398232*^9}, {3.7820380675461464`*^9, 
   3.782038068545246*^9}, {3.782114686009698*^9, 3.7821147621263084`*^9}, {
   3.782114807464842*^9, 3.7821148592110157`*^9}, {3.7821149201811123`*^9, 
   3.782114954534547*^9}, {3.7821150141615095`*^9, 3.7821150455616493`*^9}, {
   3.782115218345926*^9, 3.7821152696643686`*^9}, {3.7821153298313684`*^9, 
   3.782115338061369*^9}, 3.7821154358153687`*^9, {3.7821154682773685`*^9, 
   3.782115545601653*^9}, 3.782115658575949*^9, {3.7821157517632666`*^9, 
   3.7821157525003405`*^9}, 3.7821157921413045`*^9, {3.7821158892010093`*^9, 
   3.782115937483837*^9}, {3.7821161020342903`*^9, 3.7821161287159586`*^9}, {
   3.7821162219082766`*^9, 3.782116356365721*^9}, {3.7821165095160346`*^9, 
   3.782116548109894*^9}, {3.782116667434825*^9, 3.7821166973238134`*^9}, {
   3.782116836747754*^9, 3.7821168799720764`*^9}, {3.7821171088149586`*^9, 
   3.7821171397680535`*^9}, {3.7821171822363*^9, 3.7821172249795737`*^9}, {
   3.78211800941601*^9, 3.782118053592427*^9}, {3.7821180875938263`*^9, 
   3.782118112059273*^9}, {3.782123395842617*^9, 3.7821233991529484`*^9}, {
   3.78212342957199*^9, 3.782123443883421*^9}, {3.782123476636696*^9, 
   3.7821236086989007`*^9}, {3.782124498090831*^9, 3.7821245040744295`*^9}, {
   3.782447809524685*^9, 3.7824478131170444`*^9}, 3.7824583424248886`*^9, 
   3.782458401218767*^9, {3.7826235733411756`*^9, 3.782623576461488*^9}, 
   3.7826237171245527`*^9, {3.7826335020669584`*^9, 3.7826335548842397`*^9}, {
   3.782633680308184*^9, 3.7826336896252527`*^9}, {3.782633720885126*^9, 
   3.7826337554876657`*^9}, {3.782633859791234*^9, 3.7826338657586374`*^9}, {
   3.7826424622959247`*^9, 3.782642526538348*^9}, {3.7826425673724313`*^9, 
   3.7826425765563498`*^9}, {3.7826428251522064`*^9, 
   3.7826428363283243`*^9}, {3.7826430901137*^9, 3.782643160156704*^9}, {
   3.78264321642333*^9, 3.7826432665853453`*^9}, {3.782643297300417*^9, 
   3.782643516133298*^9}, {3.7826435972324066`*^9, 3.782643637059389*^9}, {
   3.782643775625244*^9, 3.7826438684455256`*^9}, {3.7826439366803484`*^9, 
   3.7826440152022*^9}, 3.7826440549411736`*^9, {3.7826442862303*^9, 
   3.782644383283004*^9}, {3.782644944380108*^9, 3.782645072144883*^9}, {
   3.782645125044173*^9, 3.782645236711338*^9}, 3.7826453503967056`*^9, {
   3.7826454699146566`*^9, 3.782645497075372*^9}, {3.7826457920088625`*^9, 
   3.7826458016808295`*^9}, {3.7826458404177027`*^9, 
   3.7826458574584064`*^9}, {3.7826504108957195`*^9, 3.782650421223752*^9}, {
   3.782650527165345*^9, 3.7826505782874565`*^9}, {3.7849760961625834`*^9, 
   3.784976146572381*^9}, {3.7849761814902897`*^9, 3.784976188182207*^9}, {
   3.78497623907205*^9, 3.78497624366617*^9}, {3.7849763050180035`*^9, 
   3.7849763103084693`*^9}, {3.784976476206009*^9, 3.78497649458287*^9}, {
   3.784976734777512*^9, 3.784976741496743*^9}, {3.815298961246689*^9, 
   3.8152989891534514`*^9}, {3.8152991002332244`*^9, 
   3.8152992233288374`*^9}, {3.8152993162366076`*^9, 3.815299417410099*^9}, {
   3.815299827791165*^9, 3.8152998392136135`*^9}, {3.815299938777238*^9, 
   3.8152999440274906`*^9}, {3.8153000554976845`*^9, 
   3.8153002581415205`*^9}, {3.8153004030027275`*^9, 3.815300497675951*^9}, {
   3.815307334820218*^9, 3.815307348819974*^9}, {3.81530739575838*^9, 
   3.815307438774201*^9}, {3.8153075530251355`*^9, 3.815307728495695*^9}, {
   3.8153078232312665`*^9, 3.815307832887716*^9}, {3.815307869700472*^9, 
   3.8153079228569975`*^9}, {3.815307958513324*^9, 3.815308235532172*^9}, {
   3.8153085002064867`*^9, 3.815308520097618*^9}, {3.8153085911762104`*^9, 
   3.815308605113598*^9}, 3.815308714615159*^9, {3.81530910127466*^9, 
   3.815309181290944*^9}, {3.815309224010398*^9, 3.815309229307101*^9}, {
   3.81530928404218*^9, 3.815309310042589*^9}, {3.8153093625583982`*^9, 
   3.81530936780846*^9}, {3.8153096416079454`*^9, 3.815309649405252*^9}, 
   3.815309723842983*^9, {3.8153119659985085`*^9, 3.8153120169413586`*^9}, {
   3.8153123266550455`*^9, 3.8153123950847626`*^9}, {3.8153124309076138`*^9, 
   3.815312435735865*^9}, {3.8153125001803536`*^9, 3.8153125875017242`*^9}, {
   3.8153127197336245`*^9, 3.8153128235031214`*^9}, {3.815312948268915*^9, 
   3.8153129925109997`*^9}, {3.815313046551177*^9, 3.8153131721814947`*^9}, {
   3.8153133711563673`*^9, 3.815313376547564*^9}, {3.81531350534309*^9, 
   3.8153135160447593`*^9}, {3.8153136371963043`*^9, 3.81531364035318*^9}, {
   3.8153139565817327`*^9, 3.8153142353269005`*^9}, {3.8153142712589045`*^9, 
   3.8153143381853*^9}, {3.8153143853489647`*^9, 3.8153144558944407`*^9}, {
   3.8153145119496727`*^9, 3.8153145384460278`*^9}, {3.8153145717730355`*^9, 
   3.8153145905152793`*^9}, {3.815314810288294*^9, 3.8153148355201483`*^9}, {
   3.815314906306533*^9, 3.815314957807561*^9}, 3.8153149901463523`*^9, {
   3.8153150436110425`*^9, 3.8153150798171654`*^9}, {3.815315125226812*^9, 
   3.815315197513792*^9}, {3.815315230770398*^9, 3.8153152643182497`*^9}, {
   3.815315309600113*^9, 3.8153153636663055`*^9}, {3.8153154371920815`*^9, 
   3.81531556883794*^9}, {3.815315726364873*^9, 3.815315891767622*^9}, {
   3.815315941197909*^9, 3.815315950855852*^9}, {3.81531603265689*^9, 
   3.8153161901594954`*^9}, {3.81531625899579*^9, 3.815316289841632*^9}, {
   3.815316322183053*^9, 3.815316364987257*^9}, {3.81531640991228*^9, 
   3.8153167880369387`*^9}, {3.8153168240567226`*^9, 
   3.8153168294553995`*^9}, {3.815391513340578*^9, 3.8153915424096093`*^9}, {
   3.815391590881131*^9, 3.81539161000537*^9}, {3.8153916514394264`*^9, 
   3.815391660520299*^9}, {3.8153917257448244`*^9, 3.815391757674646*^9}, {
   3.8153919790081987`*^9, 3.8153919928367796`*^9}, {3.8153920352596827`*^9, 
   3.815392113417741*^9}, {3.8153921449999723`*^9, 3.8153921913911996`*^9}, {
   3.815400710138315*^9, 3.8154007152468204`*^9}, {3.81540074663615*^9, 
   3.815400902512925*^9}, {3.815401220673547*^9, 3.8154014786157875`*^9}, 
   3.8154015115369663`*^9, {3.8154016183510146`*^9, 3.8154016528357887`*^9}, {
   3.8154017711162305`*^9, 3.8154017715401945`*^9}, {3.8154018034499235`*^9, 
   3.8154018380097537`*^9}, {3.815401916261078*^9, 3.8154020398719015`*^9}, {
   3.8154021650612774`*^9, 3.8154022059211597`*^9}, {3.815402813020459*^9, 
   3.815402987758815*^9}, {3.8154030299178076`*^9, 3.815403078528965*^9}, {
   3.815403145685523*^9, 3.8154031519483566`*^9}, {3.8154032553493185`*^9, 
   3.8154032612464705`*^9}, {3.815403333797274*^9, 3.815403341400364*^9}, {
   3.8154034042495875`*^9, 3.8154034190921345`*^9}, {3.815403508609011*^9, 
   3.81540351167187*^9}, {3.815403648860731*^9, 3.8154036489700737`*^9}, {
   3.8154037630651865`*^9, 3.8154037807531404`*^9}, {3.815403827269353*^9, 
   3.815403877707283*^9}, {3.815742560192346*^9, 3.8157425820880346`*^9}, {
   3.8157426246650333`*^9, 3.81574285703694*^9}, {3.8157429509071774`*^9, 
   3.8157430207765656`*^9}, {3.81574305640399*^9, 3.815743065009528*^9}, {
   3.815743221816391*^9, 3.8157432818101006`*^9}, {3.815743312429199*^9, 
   3.815743355225202*^9}, {3.8157435460406637`*^9, 3.815743574551504*^9}, {
   3.8157436073637166`*^9, 3.8157436437115335`*^9}, {3.8157439011915207`*^9, 
   3.815744007796675*^9}, {3.815745147369212*^9, 3.81574515274337*^9}, {
   3.8157453954660125`*^9, 3.815745396915242*^9}, {3.8157454354598007`*^9, 
   3.8157454476288567`*^9}, 3.815751075112152*^9, {3.815751248506525*^9, 
   3.8157512508472395`*^9}, 3.815751349767942*^9, {3.8171291214273615`*^9, 
   3.8171291278027596`*^9}, {3.817182318866269*^9, 3.8171823288670635`*^9}, {
   3.817182597527423*^9, 3.8171826097682247`*^9}, {3.817182647387209*^9, 
   3.8171826743411264`*^9}, {3.81718271032616*^9, 3.8171827709365954`*^9}, {
   3.817183167384598*^9, 3.817183182130454*^9}, {3.817183213596586*^9, 
   3.8171832492285748`*^9}, {3.817183462666751*^9, 3.817183468446371*^9}, {
   3.8171835007455616`*^9, 3.817183557687415*^9}, {3.817183644560029*^9, 
   3.81718365502906*^9}, {3.8171860047887173`*^9, 3.817186005285248*^9}, {
   3.8171927695692196`*^9, 3.8171928160730405`*^9}, {3.817192883156549*^9, 
   3.817192930598032*^9}, {3.8171930868769393`*^9, 3.817193117098014*^9}, {
   3.817193165789178*^9, 3.817193173380126*^9}, {3.8171934933154*^9, 
   3.817193496612564*^9}, {3.817193571790508*^9, 3.8171936511871347`*^9}, {
   3.817193879751401*^9, 3.81719397349292*^9}, {3.8171940071044493`*^9, 
   3.8171940132770495`*^9}, {3.8171940777199306`*^9, 3.817194083047754*^9}, {
   3.817194138239242*^9, 3.817194161803602*^9}, {3.8171941973329268`*^9, 
   3.817194227949235*^9}, {3.817194295977786*^9, 3.8171943512235165`*^9}, {
   3.817194402415593*^9, 3.817194448449296*^9}, {3.817195046162238*^9, 
   3.8171951693111877`*^9}, {3.8205795427093983`*^9, 3.820579561866232*^9}, {
   3.820579681291627*^9, 3.8205798511402617`*^9}, {3.820579887406309*^9, 
   3.820579921288543*^9}, 3.8205800070128984`*^9, {3.8205800994877005`*^9, 
   3.8205801359337993`*^9}, {3.820580218948187*^9, 3.820580257859371*^9}, {
   3.8205803070165377`*^9, 3.82058032488892*^9}, {3.820580472799592*^9, 
   3.820580505261987*^9}, {3.8205805379108753`*^9, 3.820580553927019*^9}, {
   3.8205806815402493`*^9, 3.8205806827274637`*^9}, {3.8205886702903185`*^9, 
   3.8205886940257545`*^9}, {3.820588839973402*^9, 3.8205888495450516`*^9}, {
   3.8206468812523613`*^9, 3.8206469192350254`*^9}, {3.8206469603152103`*^9, 
   3.820647007128559*^9}, {3.820647126825299*^9, 3.820647151042935*^9}, {
   3.824288427367212*^9, 3.8242884661512194`*^9}, {3.824289287892456*^9, 
   3.824289294403777*^9}, {3.8242893266600747`*^9, 3.824289355672492*^9}, {
   3.824289540735898*^9, 3.8242896420234723`*^9}, {3.8242950874927244`*^9, 
   3.8242951041030226`*^9}, {3.824295178762129*^9, 3.824295202138088*^9}, 
   3.824295370519452*^9, {3.824295665921438*^9, 3.8242957066767826`*^9}, {
   3.82429581360046*^9, 3.824295826755491*^9}, {3.8242959644638596`*^9, 
   3.824295987691513*^9}, {3.8242960437602882`*^9, 3.824296054529934*^9}, {
   3.8242960929128127`*^9, 3.824296177134121*^9}, {3.8242973142306952`*^9, 
   3.8242973161061487`*^9}, {3.8242973758887815`*^9, 
   3.8242973816080084`*^9}, {3.824297474242863*^9, 3.8242974888797016`*^9}, {
   3.8242982481215525`*^9, 3.8242982504028597`*^9}, {3.8242982829853764`*^9, 
   3.8242982899997435`*^9}, {3.824298353785921*^9, 3.824298377266178*^9}, {
   3.8242984943532257`*^9, 3.8242985253646774`*^9}, {3.824298609428791*^9, 
   3.824298644118224*^9}, {3.8242987372232494`*^9, 3.824298742302313*^9}, {
   3.824300903208012*^9, 3.824300917576725*^9}, {3.824300962422996*^9, 
   3.824300971909096*^9}, {3.8243010380553956`*^9, 3.8243010458629365`*^9}, {
   3.8243819843811417`*^9, 3.8243819882720623`*^9}, {3.8243820219893465`*^9, 
   3.8243820805832324`*^9}, {3.8243821850414367`*^9, 3.824382194322852*^9}, {
   3.8243825647828255`*^9, 3.8243826170342646`*^9}, {3.82438265689438*^9, 
   3.824382663706927*^9}, {3.8243831774040523`*^9, 3.824383287172286*^9}, {
   3.824383582662198*^9, 3.82438368267985*^9}, {3.824383806503149*^9, 
   3.824383808114235*^9}, {3.824383840590618*^9, 3.824383908159114*^9}, {
   3.8243840677961965`*^9, 3.824384100750307*^9}, {3.824384925437691*^9, 
   3.824384952360013*^9}, {3.824385014250978*^9, 3.8243850214240136`*^9}, {
   3.8243850749488688`*^9, 3.824385096128337*^9}, {3.8243851660358305`*^9, 
   3.8243852013025656`*^9}, {3.8243853322267065`*^9, 
   3.8243853359143457`*^9}, {3.8243854618818765`*^9, 
   3.8243854631040783`*^9}, {3.8243855376995125`*^9, 
   3.8243855398245974`*^9}, {3.8243860420637865`*^9, 3.824386085834586*^9}, {
   3.8243866643654394`*^9, 3.8243866710846486`*^9}, {3.8243870362495594`*^9, 
   3.8243870875344005`*^9}, {3.824387510763883*^9, 3.8243875200352345`*^9}, {
   3.824642142422323*^9, 3.824642343663497*^9}, {3.8246423976490765`*^9, 
   3.824642448681205*^9}, {3.8249605453116236`*^9, 3.8249605650152817`*^9}, {
   3.824960597640414*^9, 3.824960644376204*^9}, 3.8254884998660126`*^9, {
   3.8268685620986495`*^9, 3.826868711929744*^9}, {3.827839712114566*^9, 
   3.827839783245147*^9}, {3.827840007942241*^9, 3.8278400322844987`*^9}, {
   3.8280890473186364`*^9, 3.828089047788399*^9}, {3.828155698109503*^9, 
   3.8281557815033827`*^9}, {3.828155814308592*^9, 3.8281559158711796`*^9}, {
   3.828155948386239*^9, 3.8281559634586267`*^9}, {3.8281562595475655`*^9, 
   3.8281563982983236`*^9}, {3.8281564539346857`*^9, 
   3.8281564717261124`*^9}, {3.8281565617759237`*^9, 3.828156620364355*^9}, {
   3.828157138723031*^9, 3.828157162917304*^9}, {3.8281573452527018`*^9, 
   3.8281573484039855`*^9}, {3.8281574209108076`*^9, 
   3.8281574218432894`*^9}, {3.828157523632312*^9, 3.8281575271468334`*^9}, 
   3.828157925651786*^9, 3.82815799226875*^9, {3.828158071762623*^9, 
   3.828158150959413*^9}, {3.8281607092710695`*^9, 3.8281607441230927`*^9}, {
   3.8281607896621923`*^9, 3.8281608537153916`*^9}, {3.828161087630629*^9, 
   3.8281611796085687`*^9}, {3.828161257105278*^9, 3.828161287039934*^9}, {
   3.8281618864667206`*^9, 3.8281618871091185`*^9}, {3.82816922468361*^9, 
   3.8281692632972736`*^9}, {3.8281693169997888`*^9, 3.828169341386613*^9}, {
   3.8281694432177887`*^9, 3.8281694838852806`*^9}, {3.828169516298708*^9, 
   3.8281695269337745`*^9}, {3.828169574644046*^9, 3.8281695949235535`*^9}, {
   3.8281699640080214`*^9, 3.828169999149151*^9}, {3.828170034744137*^9, 
   3.8281700751128063`*^9}, {3.8281702519407067`*^9, 
   3.8281702658199563`*^9}, {3.828170329131667*^9, 3.828170345388244*^9}, {
   3.8281706401069937`*^9, 3.8281706437100153`*^9}, {3.828170675308489*^9, 
   3.828170695740095*^9}, {3.8281707757740135`*^9, 3.828170799210553*^9}, {
   3.8281708747587132`*^9, 3.828170907941951*^9}, {3.828171695004532*^9, 
   3.8281717631890726`*^9}, {3.8281723511336155`*^9, 3.828172372775535*^9}, {
   3.828173583007559*^9, 3.828173614736255*^9}, {3.8281758011542044`*^9, 
   3.828175851868512*^9}, {3.828175893933237*^9, 3.8281759024855385`*^9}, {
   3.8281759383698444`*^9, 3.8281760336527586`*^9}, {3.828176066298232*^9, 
   3.82817609489976*^9}, {3.828502336894289*^9, 3.8285023829189453`*^9}, {
   3.8285031537913857`*^9, 3.828503186744892*^9}, {3.8285032172335925`*^9, 
   3.828503222595706*^9}, {3.828503287141339*^9, 3.8285033019723887`*^9}, {
   3.8285033363579564`*^9, 3.828503336455903*^9}, {3.828503429618955*^9, 
   3.828503442730933*^9}, {3.828503533950947*^9, 3.8285035931910715`*^9}, {
   3.8285036469481373`*^9, 3.8285036761953807`*^9}, {3.828503735158035*^9, 
   3.828503736852358*^9}, {3.828503907018546*^9, 3.8285039107945204`*^9}, {
   3.828503941020194*^9, 3.828503983756275*^9}, {3.828504016783434*^9, 
   3.8285040174130945`*^9}, {3.8285040537814493`*^9, 3.828504129777665*^9}, {
   3.828504209251727*^9, 3.828504280854147*^9}, {3.8285043406485014`*^9, 
   3.8285043455768323`*^9}, {3.8285792900570183`*^9, 
   3.8285794379311604`*^9}, {3.828579593890094*^9, 3.8285795946736517`*^9}, {
   3.828579633769126*^9, 3.82857964259274*^9}, {3.8285796764803686`*^9, 
   3.828579677295908*^9}, {3.828579869772524*^9, 3.8285798869866543`*^9}, {
   3.8285799328897095`*^9, 3.828579940880869*^9}, {3.828580043008348*^9, 
   3.828580052935936*^9}, {3.8285800954647617`*^9, 3.8285800983351803`*^9}, {
   3.8285801873586864`*^9, 3.828580218706696*^9}, {3.8285810637114797`*^9, 
   3.8285811096974916`*^9}, {3.8285811687795353`*^9, 
   3.8285811731515083`*^9}, {3.8285817872969217`*^9, 3.828581833523397*^9}, {
   3.8285819784225407`*^9, 3.8285820627218437`*^9}, 3.828582129893298*^9, 
   3.8285822347147875`*^9, {3.828582312992337*^9, 3.828582314900769*^9}, {
   3.82858248414113*^9, 3.8285824870698037`*^9}, {3.828582525893699*^9, 
   3.828582551131139*^9}, {3.828582868782324*^9, 3.8285828735992928`*^9}, {
   3.828582951526663*^9, 3.828582959586953*^9}, {3.8285829940111103`*^9, 
   3.828583010037509*^9}, {3.828583160548972*^9, 3.8285831701403294`*^9}, {
   3.8285848281042376`*^9, 3.8285848659700637`*^9}, {3.8285853241733084`*^9, 
   3.8285853338559065`*^9}, {3.828585417625368*^9, 3.8285854844763393`*^9}, {
   3.8298004283069496`*^9, 3.829800458700764*^9}, {3.8298005329219427`*^9, 
   3.829800536842119*^9}, {3.8298005888188553`*^9, 3.8298006166092176`*^9}, {
   3.829802408804349*^9, 3.8298024167634993`*^9}, {3.829802481290885*^9, 
   3.8298024924989777`*^9}, {3.829802536005821*^9, 3.829802541007141*^9}, {
   3.830233768112186*^9, 3.8302337738775444`*^9}, {3.830234255964278*^9, 
   3.830234433755868*^9}, {3.8302344648158984`*^9, 3.8302344975883694`*^9}, 
   3.830234621596185*^9, {3.830237929975703*^9, 3.830238204458585*^9}, {
   3.8302382767417927`*^9, 3.830238277290321*^9}, {3.8302384033319674`*^9, 
   3.830238436891142*^9}, {3.8302391529749107`*^9, 3.830239171654669*^9}, {
   3.8302392066596575`*^9, 3.830239224690941*^9}, {3.8302392724993*^9, 
   3.83023930646881*^9}, {3.8302395149583654`*^9, 3.8302395305415106`*^9}, {
   3.830239565425192*^9, 3.8302395705891914`*^9}, {3.830239610355115*^9, 
   3.8302396861470175`*^9}, {3.830240614871057*^9, 3.8302407696165857`*^9}, {
   3.8302408511606627`*^9, 3.830240948309201*^9}, {3.830240984151149*^9, 
   3.8302410021098766`*^9}, {3.8302410539488626`*^9, 3.830241126617241*^9}, {
   3.8302411677125463`*^9, 3.83024116968791*^9}, 3.8302412085183916`*^9, {
   3.8302412991081862`*^9, 3.8302413247794776`*^9}, {3.8305873008381634`*^9, 
   3.830587384994007*^9}, {3.830587476822093*^9, 3.830587597118727*^9}, 
   3.830587636778328*^9, 3.8305877236802816`*^9, {3.8305887688748217`*^9, 
   3.8305887780981092`*^9}, {3.8305919936108274`*^9, 
   3.8305920214528136`*^9}, {3.830592052137885*^9, 3.830592054889703*^9}, {
   3.8305947449462247`*^9, 3.8305947896907654`*^9}, {3.830594842330632*^9, 
   3.8305948470228586`*^9}, {3.832145495437544*^9, 3.832145599764844*^9}, {
   3.832145659267894*^9, 3.83214568139298*^9}, {3.851050149359123*^9, 
   3.8510501547183275`*^9}, {3.851050285300594*^9, 3.851050334223868*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"3d6d232e-46a7-44d0-995b-ac99cd80cc06"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`export$$ = False, $CellContext`kMag$$ = 
    1., $CellContext`ss0$$ = 5., $CellContext`u$$ = 0.05, $CellContext`v$$ = 
    1.*^-6, $CellContext`w$$ = 1.*^-6, $CellContext`X$$ = 
    0.03, $CellContext`xMag$$ = 1., $CellContext`Y$$ = 
    0.03, $CellContext`z$$ = 1.*^-6, $CellContext`\[Lambda]$$ = 0.154059, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Lambda]$$], 0.154059, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`ss0$$], 5., ""}, 0.001, 
      Dynamic[2./$CellContext`\[Lambda]$$]}, {
      Hold[
       Grid[{{
          Text[
           Style["Parameter diffractometer", Bold, 15]]}, {"wavelength ", 
          Manipulate`Place[1], "nm"}, {
         "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
          Manipulate`Place[2], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
         "peak center ( d)", 
          Dynamic[
           NumberForm[1/$CellContext`ss0$$, {3, 5}]], "nm"}, {
         "peak center (2\[Theta])", 
          Dynamic[
           NumberForm[
            $CellContext`\[Theta]2[$CellContext`ss0$$, \
$CellContext`\[Lambda]$$], {3, 5}]], "\[Degree]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`u$$], 0.05, ""}, 1.*^-6, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`u$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`v$$], 1.*^-6, ""}, 1.*^-6, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`v$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`w$$], 1.*^-6, ""}, 1.*^-6, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`w$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`z$$], 1.*^-6, ""}, 1.*^-6, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`z$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{
          Text[
           Style["Parameter Gaussian", Bold, 15]]}, {"u         ", 
          Manipulate`Place[3]}, {"v         ", 
          Manipulate`Place[4]}, {"w         ", 
          Manipulate`Place[5]}, {"z         ", 
          Manipulate`Place[6]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`X$$], 0.03, ""}, 1.*^-6, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`X$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`Y$$], 0.03, ""}, 1.*^-6, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`Y$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{
          Text[
           Style["Parameter Lorentzian", Bold, 15]]}, {"X         ", 
          Manipulate`Place[7]}, {"Y         ", 
          Manipulate`Place[8]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1., "zoom factor in 2\[Theta]-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1., "zoom factor in Fourier-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1209., {541., 547.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`export$$ = False, $CellContext`kMag$$ = 
        1., $CellContext`ss0$$ = 5., $CellContext`u$$ = 
        0.05, $CellContext`v$$ = 1.*^-6, $CellContext`w$$ = 
        1.*^-6, $CellContext`X$$ = 0.03, $CellContext`xMag$$ = 
        1., $CellContext`Y$$ = 0.03, $CellContext`z$$ = 
        1.*^-6, $CellContext`\[Lambda]$$ = 0.154059}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`\[Theta]\[Theta]$, $CellContext`\[Delta]$, \
$CellContext`\[Sigma]$, $CellContext`\[Eta]$, $CellContext`fwhmg$, \
$CellContext`fwhml$, $CellContext`fwhmv$, $CellContext`fwhmFT$, \
$CellContext`mix$, $CellContext`min2\[Theta]$, $CellContext`max2\[Theta]$, \
$CellContext`range2\[Theta]$, $CellContext`ranges$, $CellContext`TCHZ$, \
$CellContext`FTTCH$, $CellContext`FWHM\[Theta]\[Theta]$, $CellContext`FWHMs$, \
$CellContext`FWHMPos1$, $CellContext`FWHMPos2$, $CellContext`FWHMPos3$, \
$CellContext`FWHMPosFT$}, $CellContext`\[Theta]\[Theta]$ = $CellContext`\
\[Theta]2[$CellContext`ss0$$, $CellContext`\[Lambda]$$]; \
$CellContext`\[Delta]$[
            Pattern[$CellContext`\[Theta]\[Theta]$, 
             Blank[]]] := 
          2 $CellContext`Delta\[Theta][$CellContext`X$$, $CellContext`Y$$, \
$CellContext`\[Theta]\[Theta]$/2]; $CellContext`\[Sigma]$[
            Pattern[$CellContext`\[Theta]\[Theta]$, 
             Blank[]]] := 
          2 $CellContext`Sigma\[Theta][$CellContext`u$$, $CellContext`v$$, \
$CellContext`w$$, $CellContext`z$$, $CellContext`\[Theta]\[Theta]$/
             2]; $CellContext`\[Eta]$[
            Pattern[$CellContext`\[Theta]\[Theta]$, 
             Blank[]]] := $CellContext`Mix[
            $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
            $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]; \
$CellContext`fwhmg$[
            Pattern[$CellContext`\[Theta]\[Theta]$, 
             Blank[]]] := $CellContext`Gaussfwhm[
            $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]; \
$CellContext`fwhml$[
            Pattern[$CellContext`\[Theta]\[Theta]$, 
             Blank[]]] := $CellContext`Lorentzfwhm[
            $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]]; \
$CellContext`fwhmv$[
            Pattern[$CellContext`\[Theta]\[Theta]$, 
             Blank[]]] := $CellContext`Voigtfwhm[
            $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
            $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]; \
$CellContext`fwhmFT$ = \
$CellContext`FTVoigtfwhm[$CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$\
] $CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\[Lambda]$$], \
$CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\[Lambda]$$]]; \
$CellContext`mix$ = $CellContext`Mix[
            $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
            $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]; \
$CellContext`min2\[Theta]$ = $CellContext`\[Theta]\[Theta]$ - 
           6. ($CellContext`fwhmv$[
             45]/$CellContext`xMag$$); $CellContext`max2\[Theta]$ = \
$CellContext`\[Theta]\[Theta]$ + 
           6. ($CellContext`fwhmv$[
              45]/$CellContext`xMag$$); $CellContext`range2\[Theta]$ = \
{$CellContext`min2\[Theta]$, $CellContext`max2\[Theta]$}; \
$CellContext`ranges$ = {
            $CellContext`s[$CellContext`min2\[Theta]$, \
$CellContext`\[Lambda]$$], 
            $CellContext`s[$CellContext`max2\[Theta]$, \
$CellContext`\[Lambda]$$]}; $CellContext`TCHZ$ = 
          Plot[{$CellContext`TCHPseudoVoigt[
               $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
               $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$], \
$CellContext`\[Theta]\[Theta]$, \
$CellContext`\[Theta]2]/$CellContext`TCHPseudoVoigt[
              $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
              $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$], \
$CellContext`\[Theta]\[Theta]$, $CellContext`\[Theta]\[Theta]$]}, \
{$CellContext`\[Theta]2, $CellContext`min2\[Theta]$, \
$CellContext`max2\[Theta]$}, PlotRange -> Full, Filling -> Axis, FillingStyle -> 
            Automatic, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1],
             PlotStyle -> {Thick}, Frame -> True, 
            FrameLabel -> {
             "2\[Theta] (\[Degree])", "normalized intensity", 
              "\!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, 
               
               Charting`FindTicks[$CellContext`range2\[Theta]$, \
$CellContext`ranges$]}}, LabelStyle -> Directive[Bold, 16], PlotLegends -> 
            Placed[
              LineLegend[{"TCHZ-Pseudo-Voigt"}], {0.2, Top}], TicksStyle -> 
            Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
            ImageSize -> 600]; $CellContext`FTTCH$ = Plot[
            $CellContext`FTVoigt[$CellContext`k, \
$CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\[Lambda]$$], \
$CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\[Lambda]$$]], \
{$CellContext`k, (-30.)/$CellContext`kMag$$, 30./$CellContext`kMag$$}, 
            PlotRange -> Full, Filling -> Axis, FillingStyle -> Automatic, 
            GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
            PlotStyle -> {Thick}, Frame -> True, 
            FrameLabel -> {"s (nm)", "Fourier transform"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, All}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"analytical FT"}], {0.2, Top}], TicksStyle -> 
            Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
            ImageSize -> 600]; $CellContext`FWHM\[Theta]\[Theta]$ = Plot[{
             $CellContext`fwhmg$[$CellContext`\[Theta]2], 
             $CellContext`fwhml$[$CellContext`\[Theta]2], 
             $CellContext`fwhmv$[$CellContext`\[Theta]2]}, {$CellContext`\
\[Theta]2, 0.01, 160.}, PlotRange -> All, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "2\[Theta] (\[Degree])", "FWHM (\[Degree]2\[Theta])", 
              "2\[Theta] (\[Degree])"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, All}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"FWHM(G)", "FWHM(L)", "FWHM(PV)"}], {0.2, Top}], 
            TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 600]; $CellContext`FWHMs$ = 
          Plot[{$CellContext`fwhmg$[
               $CellContext`\[Theta]2[$CellContext`x, \
$CellContext`\[Lambda]$$]] $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`\[Lambda]$$], $CellContext`fwhml$[
               $CellContext`\[Theta]2[$CellContext`x, \
$CellContext`\[Lambda]$$]] $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`\[Lambda]$$], $CellContext`fwhmv$[
               $CellContext`\[Theta]2[$CellContext`x, \
$CellContext`\[Lambda]$$]] $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`\[Lambda]$$]}, {$CellContext`x, 
             $CellContext`s[0.01, $CellContext`\[Lambda]$$], 
             $CellContext`s[160., $CellContext`\[Lambda]$$]}, PlotRange -> 
            All, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
            PlotStyle -> {Thick}, Frame -> True, 
            FrameLabel -> {
             "\!\(\*SuperscriptBox[\(d\), \(*\)]\) (\!\(\*SuperscriptBox[\(nm\
\), \(-1\)]\))", "FWHM (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))"}, 
            FrameTicks -> {{Automatic, Automatic}, {All, 
               
               Charting`FindTicks[$CellContext`ranges$, $CellContext`range2\
\[Theta]$]}}, LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"FWHM(G)", "FWHM(L)", "FWHM(PV)"}], {0.2, Top}], 
            TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 
            600]; $CellContext`FWHMPos1$ = Graphics[{
             PointSize[Large], Red, 
             Point[{$CellContext`\[Theta]\[Theta]$, 
               $CellContext`fwhmv$[$CellContext`\[Theta]\[Theta]$]}]}]; \
$CellContext`FWHMPos2$ = Graphics[{Red, 
             Arrowheads[{-0.02, 0.02}], 
             
             Arrow[{{$CellContext`\[Theta]\[Theta]$ - \
$CellContext`fwhmv$[$CellContext`\[Theta]\[Theta]$]/2, 
                0.5}, {$CellContext`\[Theta]\[Theta]$ + \
$CellContext`fwhmv$[$CellContext`\[Theta]\[Theta]$]/2, 
                0.5}}]}]; $CellContext`FWHMPos3$ = Graphics[{
             PointSize[Large], Red, 
             Point[{
               $CellContext`s[$CellContext`\[Theta]\[Theta]$, $CellContext`\
\[Lambda]$$], $CellContext`fwhmv$[$CellContext`\[Theta]\[Theta]$] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\[Lambda]$$]}]}]; \
$CellContext`FWHMPosFT$ = Graphics[{Red, 
             Arrowheads[{-0.02, 0.02}], 
             
             Arrow[{{(-$CellContext`fwhmFT$)/2, 0.5}, {
               Plus[$CellContext`fwhmFT$]/2, 0.5}}]}]; 
         If[$CellContext`export$$, 
           Export[$CellContext`filePath, {$CellContext`TCHZ$, \
$CellContext`FWHM\[Theta]\[Theta]$, $CellContext`FTTCH$, \
$CellContext`FWHMs$}]; $CellContext`export$$ = False]; Grid[{{
             Show[$CellContext`TCHZ$, $CellContext`FWHMPos2$], 
             
             Show[$CellContext`FWHM\[Theta]\[Theta]$, \
$CellContext`FWHMPos1$]}, {
             Show[$CellContext`FTTCH$, $CellContext`FWHMPosFT$], 
             Show[$CellContext`FWHMs$, $CellContext`FWHMPos3$]}, {
             Grid[{{
                Text[
                 Style["Parameter Gaussian", Bold, 20]]}, {
               "Gauss    \[Sigma]  ", 
                NumberForm[
                 $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$], {3, 
                 4}], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
                NumberForm[
                 $CellContext`Gaussfwhm[
                  $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]], {3,
                  3}], "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`Gaussfwhm[
                   $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {"Gauss   IB  ", 
                NumberForm[
                 $CellContext`GaussIB[
                  $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]], {3,
                  3}], "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`GaussIB[
                   $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {}, {
                Text[
                 Style["Parameter Lorentzian", Bold, 20]]}, {
               "Lorentz \[Delta]  ", 
                NumberForm[
                 $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], {3, 
                 4}], "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
                NumberForm[
                 $CellContext`Lorentzfwhm[
                  $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]], {3,
                  3}], "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`Lorentzfwhm[
                   $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {"Lorentz IB  ", 
                NumberForm[
                 $CellContext`LorentzIB[
                  $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]], {3,
                  3}], "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`LorentzIB[
                   $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}}, Frame -> True, 
              ItemStyle -> Directive[FontSize -> 18, Bold]], 
             Grid[{{
                Text[
                 Style["Parameter Pseudo-Voigt", Bold, 20]]}, {"Voigt  fwhm ", 
                NumberForm[
                 $CellContext`Voigtfwhm[
                  $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
                  $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]], {3,
                  3}], "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`Voigtfwhm[
                   $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
                   $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {"Voigt  IB   ", 
                NumberForm[
                 $CellContext`VoigtIB[
                  $CellContext`LorentzIB[
                   $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]], 
                  $CellContext`GaussIB[
                   $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]], {
                 3, 3}], "\[Degree]2\[Theta] (", 
                NumberForm[$CellContext`VoigtIB[
                   $CellContext`LorentzIB[
                    $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]], 
                   $CellContext`GaussIB[
                    $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$], {3, 4}], 
                "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) )"}, {
               "Lorentz  part ", 
                NumberForm[$CellContext`mix$ 100, {3, 1}], "%"}, {
               "Gauss    part ", 
                NumberForm[100 - $CellContext`mix$ 100, {3, 1}], "%"}, {}, {
               "FT     fwhm  ", 
                NumberForm[$CellContext`fwhmFT$, {5, 1}], "nm"}, {
               "LVol   fwhm  ", 
                NumberForm[1/($CellContext`Voigtfwhm[
                   $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$], 
                   $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$]), {5, 1}], "nm"}, {"LVol   IB    ", 
                NumberForm[1/($CellContext`VoigtIB[
                   $CellContext`LorentzIB[
                    $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]], 
                   $CellContext`GaussIB[
                    $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]] \
$CellContext`cs[
                   $CellContext`\[Theta]2[$CellContext`ss0$$, $CellContext`\
\[Lambda]$$], $CellContext`\[Lambda]$$]), {5, 1}], "nm"}, {"e0           ", 
                NumberForm[$CellContext`VoigtIB[
                   $CellContext`LorentzIB[
                    $CellContext`\[Delta]$[$CellContext`\[Theta]\[Theta]$]], 
                   $CellContext`GaussIB[
                    $CellContext`\[Sigma]$[$CellContext`\[Theta]\[Theta]$]]] \
((Pi/360)/4), {2, 4}]}}, Frame -> True, ItemStyle -> 
              Directive[FontSize -> 18, Bold]]}}]]], 
      "Specifications" :> {
       Delimiter, {{$CellContext`\[Lambda]$$, 0.154059, ""}, 0.01, 0.3, 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`ss0$$, 5., ""}, 0.001, 
         Dynamic[2./$CellContext`\[Lambda]$$], ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 2}, 
        Grid[{{
           Text[
            Style["Parameter diffractometer", Bold, 15]]}, {"wavelength ", 
           Manipulate`Place[1], "nm"}, {
          "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
           Manipulate`Place[2], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
          "peak center ( d)", 
           Dynamic[
            NumberForm[1/$CellContext`ss0$$, {3, 5}]], "nm"}, {
          "peak center (2\[Theta])", 
           Dynamic[
            NumberForm[
             $CellContext`\[Theta]2[$CellContext`ss0$$, \
$CellContext`\[Lambda]$$], {3, 5}]], "\[Degree]"}}], 
        Delimiter, {{$CellContext`u$$, 0.05, ""}, 1.*^-6, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`u$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         3}, {{$CellContext`v$$, 1.*^-6, ""}, 1.*^-6, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`v$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         4}, {{$CellContext`w$$, 1.*^-6, ""}, 1.*^-6, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`w$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         5}, {{$CellContext`z$$, 1.*^-6, ""}, 1.*^-6, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`z$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 6}, 
        Grid[{{
           Text[
            Style["Parameter Gaussian", Bold, 15]]}, {"u         ", 
           Manipulate`Place[3]}, {"v         ", 
           Manipulate`Place[4]}, {"w         ", 
           Manipulate`Place[5]}, {"z         ", 
           Manipulate`Place[6]}}], 
        Delimiter, {{$CellContext`X$$, 0.03, ""}, 1.*^-6, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`X$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         7}, {{$CellContext`Y$$, 0.03, ""}, 1.*^-6, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`Y$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 8}, 
        Grid[{{
           Text[
            Style["Parameter Lorentzian", Bold, 15]]}, {"X         ", 
           Manipulate`Place[7]}, {"Y         ", 
           Manipulate`Place[8]}}], 
        Delimiter, {{$CellContext`xMag$$, 1., 
          "zoom factor in 2\[Theta]-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> 
         "Labeled"}, {{$CellContext`kMag$$, 1., 
          "zoom factor in Fourier-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", "TCHZ-PseudoVoigt\n"}, 
        LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1935., {610., 616.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8285821314725237`*^9, 3.8285822386749706`*^9, 3.82858231802971*^9, 
   3.8285824900771894`*^9, 3.828582554929398*^9, 3.8285830543072305`*^9, 
   3.828583122170768*^9, {3.8285831711837034`*^9, 3.8285831755739346`*^9}, 
   3.8285842441139946`*^9, {3.828584834694566*^9, 3.8285848513641376`*^9}, 
   3.82858533535163*^9, 3.8285854302595067`*^9, 3.8285854864063435`*^9, 
   3.828591673442259*^9, 3.8285920931712227`*^9, 3.8285931202106247`*^9, 
   3.8285934342323685`*^9, 3.8285939785788593`*^9, 3.8298003604627514`*^9, {
   3.8298004390600443`*^9, 3.829800459735188*^9}, 3.8298004928991175`*^9, 
   3.829800538626232*^9, 3.829800591073514*^9, 3.8298006464302063`*^9, 
   3.8298025694217196`*^9, 3.8298077145366797`*^9, 3.829809189724311*^9, 
   3.8299651372427387`*^9, 3.8302344994480743`*^9, 3.8302346238194075`*^9, 
   3.8302382355133705`*^9, {3.830238412061659*^9, 3.8302384382489505`*^9}, 
   3.830239307588201*^9, 3.8302395329964986`*^9, 3.8302395717084637`*^9, 
   3.8302396277289047`*^9, 3.830239699477801*^9, {3.83024070997293*^9, 
   3.8302407295574756`*^9}, 3.830240770720197*^9, 3.8302409500372195`*^9, 
   3.8302410054683976`*^9, 3.8302411293266687`*^9, 3.830241178865238*^9, 
   3.8302412565853653`*^9, 3.8302413271187334`*^9, 3.830585918536804*^9, {
   3.830585998054742*^9, 3.830586008445449*^9}, 3.8305873897251115`*^9, 
   3.830587606288046*^9, {3.830587698842388*^9, 3.8305877359061174`*^9}, 
   3.8305887830110736`*^9, 3.830591923551552*^9, 3.830592024270887*^9, {
   3.830592061890029*^9, 3.830592066272294*^9}, {3.8305947946553297`*^9, 
   3.8305948020757575`*^9}, 3.83059484903144*^9, 3.830595013359633*^9, 
   3.83161646507458*^9, 3.8321437360070066`*^9, 3.832144954551656*^9, 
   3.832145066380972*^9, 3.8321451758657565`*^9, 3.832145601555255*^9, {
   3.832145664723903*^9, 3.832145682311696*^9}, 3.851048139948773*^9, 
   3.851050173281375*^9, 3.851050342255597*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"3e5c425b-d33f-41ae-8c97-b151afc3a909"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fourier transform of simplified PseudoVoigt function", "Chapter",
 CellChangeTimes->{
  3.8171293231134663`*^9, {3.817129375929954*^9, 3.8171293997597475`*^9}, 
   3.817129839476847*^9},ExpressionUUID->"c867cf81-8e9e-401c-a162-\
6f0142d416a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "scale", ",", "points", ",", " ", "leftbound1", ",", "leftbound2", ",",
         "rightbound1", ",", "rightbound2", ",", " ", "stepw1", ",", " ", 
        "stepw2", ",", " ", "grid1", ",", " ", "grid2", ",", " ", "samples1", 
        ",", " ", "samples2", ",", " ", "g1", ",", "g2", ",", " ", "pl1", ",",
         "pl2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"scale", "            ", "=", " ", 
        SqrtBox[
         RowBox[{"2", "\[Pi]"}]]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"points", "        ", "=", " ", "2000"}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "must", " ", "be", " ", "even", " ", "for", " ", "odd", " ", 
         "interpolation", " ", "orders"}], " ", "*)"}], "\[IndentingNewLine]",
        "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"2", "\[Theta]"}], "-", "space"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"leftbound1", "   ", "=", " ", 
        RowBox[{"peakpos", "-", " ", 
         RowBox[{"12.", " ", "hwhm"}]}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"rightbound1", "=", " ", 
        RowBox[{"peakpos", " ", "+", " ", 
         RowBox[{"12.", " ", "hwhm"}]}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"stepw1", "           ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound1", "-", "leftbound1"}], ")"}], "/", 
         "points"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"grid1", "             ", "=", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound1", ",", "rightbound1", ",", "stepw1"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"samples1", "       ", "=", "  ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PVoigt", "[", 
            RowBox[{"\[Eta]", ",", "hwhm", ",", "peakpos", ",", "#"}], "]"}], 
           "&"}], ",", " ", "grid1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"=", 
            RowBox[{"1", "/", "d"}]}], ")"}]}], " ", "-", "space"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"leftbound2", "   ", "=", " ", 
        RowBox[{"s", "[", 
         RowBox[{"leftbound1", ",", "lambda"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"rightbound2", "=", " ", 
        RowBox[{"s", "[", 
         RowBox[{"rightbound1", ",", "lambda"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"stepw2", "            ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound2", "-", "leftbound2"}], ")"}], "/", 
         "points"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"grid2", "              ", "=", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound2", ",", "rightbound2", ",", "stepw2"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"samples2", "        ", "=", "  ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PVoigt", "[", 
            RowBox[{"\[Eta]", ",", 
             RowBox[{"hwhm", " ", 
              RowBox[{"cs", "[", 
               RowBox[{"peakpos", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{"s", "[", 
              RowBox[{"peakpos", ",", "lambda"}], "]"}], ",", "#"}], "]"}], 
           "&"}], ",", " ", "grid2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"g2", "                  ", "=", "  ", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"fourierData", "[", 
           RowBox[{
            RowBox[{"Transpose", " ", "[", 
             RowBox[{"{", 
              RowBox[{"grid2", ",", "samples2"}], "}"}], "]"}], ",", 
            "scale"}], "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "interpol"}]}], "]"}]}], 
       ";", "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"pl1", "                 ", "=", 
        RowBox[{"Quiet", "@", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PVoigt", "[", 
              RowBox[{"\[Eta]", ",", "hwhm", ",", "peakpos", ",", "k"}], 
              "]"}], "/", 
             RowBox[{"PVoigt", "[", 
              RowBox[{"\[Eta]", ",", "hwhm", ",", "peakpos", ",", "peakpos"}],
               "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"k", ",", "leftbound1", ",", " ", "rightbound1"}], "}"}], 
           ",", "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotRange", "\[Rule]", " ", "Full"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                           ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                           ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<normalized intensity\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", "                           ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", "\"\<Pseudo-Voigt\>\"", "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"pl2", "                 ", "=", 
        RowBox[{"Quiet", "@", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FTPVoigt", "[", 
              RowBox[{"k", ",", "\[Eta]", ",", 
               RowBox[{"hwhm", " ", 
                RowBox[{"cs", "[", 
                 RowBox[{"peakpos", ",", "lambda"}], "]"}]}]}], "]"}], ",", 
             " ", 
             RowBox[{"g2", "[", "k", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"k", ",", 
             RowBox[{
              RowBox[{"-", "30."}], "/", "xmag"}], ",", 
             RowBox[{"30.", "/", "xmag"}]}], "}"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotRange", "\[Rule]", " ", "Full"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                           ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                           ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           "                           ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", "                           ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<analytical FT\>\"", " ", ",", "\"\<numerical FT\>\""}], 
                "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"pl1", ",", "pl2"}], "}"}], "}"}], "]"}]}]}], " ", 
     "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "               ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<mixing parameter \[Eta]\>\"", ",", 
        "                                  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Eta]", ",", " ", "0.5", ",", "\"\<\>\""}], "}"}], ",", 
           "      ", "0.", ",", "    ", "1.", ",", "   ", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<half width at half maximum\>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"hwhm", ",", "0.2", ",", "\"\<\>\""}], "}"}], ",", " ", 
           "0.01", ",", "2.", ",", "  ", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}]}], "             ", 
     "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "               ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<peak position\>\"", ",", "                                 ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"peakpos", ",", " ", "45.", ",", "\"\<\>\""}], "}"}], ",",
            "    ", "1.", ",", "   ", "179.0", ",", " ", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
      "\[IndentingNewLine]", "              ", 
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<wavelength   \>\"", ",", "                                ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lambda", ",", "  ", "0.154", ",", "\"\<\>\""}], "}"}], 
           ",", " ", "0.01", ",", "   ", "0.3", ",", "  ", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", ",", "\"\<nm\>\""}], "}"}]}], "              ", 
     "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<x-axis spread\>\"", ",", 
        "                                              ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xmag", ",", "1", ",", "\"\<\>\""}], "}"}], ",", "     ", 
           "0.1", ",", "    ", "10", ",", "1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "              ", "\[IndentingNewLine]", 
      "            ", 
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<interpolation order\>\"", ",", 
        "                                  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"interpol", ",", "1", ",", "\"\<\>\""}], "}"}], ",", 
           "   ", "1", ",", " ", "7", ",", "2", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}]}], "              ", "\[IndentingNewLine]", "        ", 
     "}"}], "]"}], ",", "   ", "\[IndentingNewLine]", " ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
      "\"\<Simplified Pseudo-Voigt function and its Fourier \
transform\\n\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "->", "True"}]}], " ", "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.8140771304547033`*^9, 3.8140771927183743`*^9}, {
   3.814077259031645*^9, 3.8140773186565495`*^9}, {3.8140773551676607`*^9, 
   3.8140773553683634`*^9}, {3.8140774027978954`*^9, 3.814077419354084*^9}, {
   3.8140774645948315`*^9, 3.8140774705305767`*^9}, {3.814077526878851*^9, 
   3.8140775278667126`*^9}, {3.814077591187489*^9, 3.814077652164401*^9}, {
   3.814077684446787*^9, 3.814077753412609*^9}, {3.8140777941245723`*^9, 
   3.8140778212366753`*^9}, 3.814078189018439*^9, {3.814078225812955*^9, 
   3.8140782461278677`*^9}, {3.814078341911869*^9, 3.8140784096431656`*^9}, {
   3.814078439977064*^9, 3.8140784511678305`*^9}, {3.814078535987029*^9, 
   3.814078543080739*^9}, {3.8140785922166185`*^9, 3.8140785986925907`*^9}, {
   3.8140786296678033`*^9, 3.8140786315521865`*^9}, {3.814078695610015*^9, 
   3.814078698667507*^9}, {3.8140787361495104`*^9, 3.814078878241047*^9}, {
   3.814078972480596*^9, 3.8140790836644907`*^9}, {3.814079145976894*^9, 
   3.8140791539040723`*^9}, {3.814079277383916*^9, 3.8140793088312993`*^9}, {
   3.814079384043247*^9, 3.8140794286893573`*^9}, {3.814079486883639*^9, 
   3.814079493537532*^9}, {3.8140796065033817`*^9, 3.814079651079243*^9}, 
   3.814079724518266*^9, {3.814080861850895*^9, 3.814080873877462*^9}, {
   3.814080905936254*^9, 3.8140809914850245`*^9}, {3.814081032494896*^9, 
   3.8140810425126076`*^9}, {3.814081086224352*^9, 3.814081092575427*^9}, {
   3.814081146258117*^9, 3.814081158598447*^9}, {3.8140862953888397`*^9, 
   3.81408634116351*^9}, {3.8140864010418158`*^9, 3.8140864160244255`*^9}, 
   3.8140864872392178`*^9, 3.8140865665585575`*^9, {3.8140866230305047`*^9, 
   3.8140866239332*^9}, 3.817117157157921*^9, {3.81712941491698*^9, 
   3.817129418276671*^9}, {3.817179825711928*^9, 3.817179828336958*^9}, {
   3.817180365635533*^9, 3.8171803921069765`*^9}, {3.8188444375892086`*^9, 
   3.8188444398703356`*^9}, {3.824302869817028*^9, 3.82430287611112*^9}, {
   3.824302908284425*^9, 3.8243032322013845`*^9}, {3.8243033346008325`*^9, 
   3.8243033368131447`*^9}, {3.824305849334175*^9, 3.824305849890195*^9}, {
   3.82430685316903*^9, 3.82430686313595*^9}, {3.8243083722792807`*^9, 
   3.8243083850564737`*^9}, {3.824308477740466*^9, 3.824308502746392*^9}, 
   3.824308951193722*^9, {3.8243552793325*^9, 3.8243552793797836`*^9}, {
   3.8243556411975293`*^9, 3.8243556414318466`*^9}, {3.824355706272855*^9, 
   3.8243557077949867`*^9}, {3.824355789315383*^9, 3.8243558004250064`*^9}, {
   3.824355847944738*^9, 3.8243558502821817`*^9}, {3.824356694270076*^9, 
   3.8243569083600516`*^9}, {3.8243569405961485`*^9, 3.82435694122112*^9}, {
   3.8243570417986407`*^9, 3.8243570449604826`*^9}, {3.82435712607434*^9, 
   3.824357222110106*^9}, {3.824357287644951*^9, 3.824357339991106*^9}, {
   3.824357530164979*^9, 3.824357560752248*^9}, {3.82435768158278*^9, 
   3.824357756800455*^9}, {3.824357859502189*^9, 3.8243579149100094`*^9}, {
   3.8243584112588587`*^9, 3.8243584172926807`*^9}, {3.8243584692171197`*^9, 
   3.8243584864210176`*^9}, {3.824358583210613*^9, 3.8243586116436377`*^9}, {
   3.8243586630379515`*^9, 3.824358858437659*^9}, {3.8243589056230373`*^9, 
   3.824358920059605*^9}, {3.8243589905996823`*^9, 3.824359090635066*^9}, {
   3.824359147247284*^9, 3.824359216562481*^9}, {3.8243595747186003`*^9, 
   3.8243595819845343`*^9}, {3.8243596946455536`*^9, 3.824359698239518*^9}, {
   3.82435978366495*^9, 3.8243597845865984`*^9}, {3.824359852187502*^9, 
   3.8243598744185147`*^9}, {3.8243601317257504`*^9, 
   3.8243601713837214`*^9}, {3.824360239433177*^9, 3.8243602941072936`*^9}, {
   3.8243603687547197`*^9, 3.8243604210500174`*^9}, {3.824360477801982*^9, 
   3.824360478198121*^9}, {3.824360517460189*^9, 3.82436071187379*^9}, {
   3.824360795437742*^9, 3.824360838206778*^9}, {3.824362346934429*^9, 
   3.8243623582227063`*^9}, {3.8246429848177185`*^9, 
   3.8246430188809676`*^9}, {3.824960662689041*^9, 3.8249606869082565`*^9}, {
   3.826868206188826*^9, 3.8268682063104877`*^9}, {3.827977729569282*^9, 
   3.8279777301791515`*^9}, {3.82861424564155*^9, 3.8286142558455687`*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"02a7173e-3ea6-497d-9e62-a7faf2b02635"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`hwhm$$ = 0.2, $CellContext`interpol$$ = 
    1, $CellContext`lambda$$ = 0.154, $CellContext`peakpos$$ = 
    45., $CellContext`xmag$$ = 1, $CellContext`\[Eta]$$ = 0.5, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Eta]$$], 0.5, ""}, 0., 1.}, {{
       Hold[$CellContext`hwhm$$], 0.2, ""}, 0.01, 2.}, {
      Hold[
       Grid[{{"mixing parameter \[Eta]", 
          Manipulate`Place[1]}, {"half width at half maximum", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`peakpos$$], 45., ""}, 1., 179.}, {{
       Hold[$CellContext`lambda$$], 0.154, ""}, 0.01, 0.3}, {
      Hold[
       Grid[{{"peak position", 
          Manipulate`Place[3], "\[Degree]2\[Theta]"}, {"wavelength   ", 
          Manipulate`Place[4], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xmag$$], 1, ""}, 0.1, 10, 1}, {{
       Hold[$CellContext`interpol$$], 1, ""}, 1, 7, 2}, {
      Hold[
       Grid[{{"x-axis spread", 
          Manipulate`Place[5]}, {"interpolation order", 
          Manipulate`Place[6]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1209., {191., 197.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`hwhm$$ = 0.2, $CellContext`interpol$$ = 
        1, $CellContext`lambda$$ = 0.154, $CellContext`peakpos$$ = 
        45., $CellContext`xmag$$ = 1, $CellContext`\[Eta]$$ = 0.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`scale$, $CellContext`points$, \
$CellContext`leftbound1$, $CellContext`leftbound2$, \
$CellContext`rightbound1$, $CellContext`rightbound2$, $CellContext`stepw1$, \
$CellContext`stepw2$, $CellContext`grid1$, $CellContext`grid2$, \
$CellContext`samples1$, $CellContext`samples2$, $CellContext`g1$, \
$CellContext`g2$, $CellContext`pl1$, $CellContext`pl2$}, $CellContext`scale$ = 
          Sqrt[2 Pi]; $CellContext`points$ = 
          2000; $CellContext`leftbound1$ = $CellContext`peakpos$$ - 
           12. $CellContext`hwhm$$; $CellContext`rightbound1$ = \
$CellContext`peakpos$$ + 
           12. $CellContext`hwhm$$; $CellContext`stepw1$ = \
($CellContext`rightbound1$ - $CellContext`leftbound1$)/$CellContext`points$; \
$CellContext`grid1$ = 
          Range[$CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$]; $CellContext`samples1$ = 
          Map[$CellContext`PVoigt[$CellContext`\[Eta]$$, $CellContext`hwhm$$, \
$CellContext`peakpos$$, #]& , $CellContext`grid1$]; $CellContext`leftbound2$ = \
$CellContext`s[$CellContext`leftbound1$, $CellContext`lambda$$]; \
$CellContext`rightbound2$ = $CellContext`s[$CellContext`rightbound1$, \
$CellContext`lambda$$]; $CellContext`stepw2$ = ($CellContext`rightbound2$ - \
$CellContext`leftbound2$)/$CellContext`points$; $CellContext`grid2$ = 
          Range[$CellContext`leftbound2$, $CellContext`rightbound2$, \
$CellContext`stepw2$]; $CellContext`samples2$ = 
          Map[$CellContext`PVoigt[$CellContext`\[Eta]$$, $CellContext`hwhm$$ \
$CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], 
             $CellContext`s[$CellContext`peakpos$$, $CellContext`lambda$$], \
#]& , $CellContext`grid2$]; $CellContext`g2$ = Interpolation[
            $CellContext`fourierData[
             
             Transpose[{$CellContext`grid2$, $CellContext`samples2$}], \
$CellContext`scale$], 
            InterpolationOrder -> $CellContext`interpol$$]; $CellContext`pl1$ = 
          Quiet[
            
            Plot[{$CellContext`PVoigt[$CellContext`\[Eta]$$, \
$CellContext`hwhm$$, $CellContext`peakpos$$, \
$CellContext`k]/$CellContext`PVoigt[$CellContext`\[Eta]$$, \
$CellContext`hwhm$$, $CellContext`peakpos$$, $CellContext`peakpos$$]}, \
{$CellContext`k, $CellContext`leftbound1$, $CellContext`rightbound1$}, 
             PlotRange -> Full, GridLines -> Automatic, GridLinesStyle -> 
             Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
             FrameLabel -> {
              "2\[Theta] axis (\[Degree])", "normalized intensity"}, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
               LineLegend[{"Pseudo-Voigt"}], {0.2, Top}], TicksStyle -> 
             Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
             ImageSize -> 600]]; $CellContext`pl2$ = Quiet[
            Plot[{
              $CellContext`FTPVoigt[$CellContext`k, $CellContext`\[Eta]$$, \
$CellContext`hwhm$$ $CellContext`cs[$CellContext`peakpos$$, \
$CellContext`lambda$$]], 
              $CellContext`g2$[$CellContext`k]}, {$CellContext`k, \
(-30.)/$CellContext`xmag$$, 30./$CellContext`xmag$$}, PlotRange -> Full, 
             GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
             PlotStyle -> {Thick}, Frame -> True, 
             FrameLabel -> {"s (nm)", "Fourier transform"}, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
               LineLegend[{"analytical FT", "numerical FT"}], {0.2, Top}], 
             TicksStyle -> Directive[Black, 15], AxesStyle -> 
             Directive[Black, Thick], ImageSize -> 600]]; 
         Grid[{{$CellContext`pl1$, $CellContext`pl2$}}]]], 
      "Specifications" :> {{{$CellContext`\[Eta]$$, 0.5, ""}, 0., 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`hwhm$$, 0.2, ""}, 0.01, 2., ControlType -> Slider,
          Appearance -> "Labeled", ControlPlacement -> 2}, 
        Grid[{{"mixing parameter \[Eta]", 
           Manipulate`Place[1]}, {"half width at half maximum", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}}], 
        Delimiter, {{$CellContext`peakpos$$, 45., ""}, 1., 179., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`lambda$$, 0.154, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 4}, 
        Grid[{{"peak position", 
           Manipulate`Place[3], "\[Degree]2\[Theta]"}, {"wavelength   ", 
           Manipulate`Place[4], "nm"}}], 
        Delimiter, {{$CellContext`xmag$$, 1, ""}, 0.1, 10, 1, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`interpol$$, 1, ""}, 1, 7, 2, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 6}, 
        Grid[{{"x-axis spread", 
           Manipulate`Place[5]}, {"interpolation order", 
           Manipulate`Place[6]}}]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Simplified Pseudo-Voigt function and its Fourier transform\n"}, 
        LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ControlPlacement -> {Left}, ContinuousAction -> False, TrackedSymbols -> 
        True}, "DefaultOptions" :> {}],
     ImageSizeCache->{1829., {260., 266.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`PVoigt[
         Pattern[$CellContext`\[Eta], 
          Blank[]], 
         Pattern[$CellContext`hwhm, 
          Blank[]], 
         Pattern[$CellContext`x0, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]]] := (1 - $CellContext`\[Eta]) (
          Sqrt[Pi Log[2]]/((Pi $CellContext`hwhm) 
          E^(Log[2] (($CellContext`x - \
$CellContext`x0)/$CellContext`hwhm)^2))) + $CellContext`\[Eta] (
          1/((Pi $CellContext`hwhm) (
           1 + (($CellContext`x - $CellContext`x0)/$CellContext`hwhm)^2))), \
$CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`\[Lambda] = 
       0.14249059611887502`, $CellContext`cs[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := ($CellContext`\[Theta]2 Degree) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`cs[
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := (Pi/180) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`fourierData[
         PatternTest[
          Pattern[$CellContext`data, 
           Blank[]], MatrixQ], 
         Pattern[$CellContext`scale, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`xGrid, $CellContext`pGrid, $CellContext`f, \
$CellContext`x0, $CellContext`x1, $CellContext`NN, $CellContext`DFT}, \
{$CellContext`xGrid, $CellContext`f} = 
          Transpose[$CellContext`data]; {$CellContext`x0, $CellContext`x1} = 
          MinMax[$CellContext`xGrid]; $CellContext`NN = 
          Length[$CellContext`xGrid] - 1; $CellContext`pGrid = 
          RotateRight[
           Range[-($CellContext`NN/2), $CellContext`NN/
              2]/($CellContext`x1 - $CellContext`x0), 
            Quotient[$CellContext`NN, 2] + 1]; $CellContext`DFT = 
          Fourier[$CellContext`f, FourierParameters -> 
             OptionValue[
              FourierParameters]] (($CellContext`x1 - $CellContext`x0)/Sqrt[
            2 Pi $CellContext`NN]); 
         Transpose[{$CellContext`pGrid, $CellContext`scale 
            Abs[$CellContext`DFT]}]], 
       Options[$CellContext`fourierData] = {
        FourierParameters -> {0, 1}}, $CellContext`data = CompressedData["
1:eJw0XHc81e8Xt6MoktmSIhqShubnEPJtp10qspqaSntop6GBKCXKiMpeqWMT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        "], $CellContext`k[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       1/$CellContext`s[$CellContext`\[Theta]2, $CellContext`\[Lambda]], \
$CellContext`FTPVoigt[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Eta], 
          Blank[]], 
         Pattern[$CellContext`hwhm, 
          Blank[]]] := 
       Module[{$CellContext`k = (
            1 + (1 - $CellContext`\[Eta])/($CellContext`\[Eta] 
             Sqrt[Pi Log[2]]))^(-1)}, (1 - $CellContext`k)/
          E^((Pi^2 $CellContext`hwhm^2 $CellContext`L^2)/Log[
           2]) + $CellContext`k/
          E^(2 Pi $CellContext`hwhm Abs[$CellContext`L])]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8243089537559233`*^9, 3.824355072179535*^9, 3.8243552812544127`*^9, 
   3.8243556470101457`*^9, 3.824355708919628*^9, 3.824357638552684*^9, 
   3.8243577619960566`*^9, {3.8243578876270895`*^9, 3.8243579158939643`*^9}, 
   3.824358418464628*^9, {3.824358845530483*^9, 3.8243588610781264`*^9}, 
   3.824358923966919*^9, {3.8243591764670324`*^9, 3.82435921879714*^9}, 
   3.8243597041143694`*^9, 3.8243597858677187`*^9, 3.8243598752934523`*^9, 
   3.824360175455858*^9, {3.8243602767496195`*^9, 3.824360295669956*^9}, 
   3.824360370626071*^9, 3.82436040437723*^9, 3.824360479427355*^9, 
   3.8243605193663435`*^9, {3.8243605711654496`*^9, 3.824360587462516*^9}, {
   3.8243606615131445`*^9, 3.8243607129210196`*^9}, {3.8243607984711075`*^9, 
   3.824360839925537*^9}, 3.8243632031699133`*^9, 3.8243636479935513`*^9, 
   3.824381846847243*^9, 3.8243824890002847`*^9, 3.824639897547947*^9, 
   3.8246401956636467`*^9, {3.8246403188226414`*^9, 3.8246403273852673`*^9}, 
   3.8246403930587363`*^9, 3.824643022208763*^9, 3.824643430463007*^9, 
   3.824960213539076*^9, 3.82496076394112*^9, 3.825475298888943*^9, 
   3.8268597028869276`*^9, 3.8278365036063213`*^9, 3.8278375455202847`*^9, 
   3.8279144425862103`*^9, 3.827915520057399*^9, 3.827915558173585*^9, 
   3.8279167109015284`*^9, 3.8279168946525936`*^9, 3.8279760110108433`*^9, 
   3.8279763293157406`*^9, {3.8280891076583414`*^9, 3.8280891225045404`*^9}, 
   3.8280891820889654`*^9, 3.8280892717457466`*^9, 3.82809119126497*^9, 
   3.828091814755304*^9, 3.828092861474079*^9, 3.82809291588376*^9, 
   3.8281057733908863`*^9, 3.828106042569167*^9, 3.8281061545481873`*^9, 
   3.8281553891502123`*^9, 3.828156023436572*^9, 3.8281600501215334`*^9, 
   3.828161194378603*^9, {3.8281613026141863`*^9, 3.828161325982689*^9}, 
   3.828161460539855*^9, 3.8281616548144255`*^9, 3.8281625827615814`*^9, 
   3.8281708444207087`*^9, 3.8281710337203703`*^9, {3.828171067351914*^9, 
   3.828171083805087*^9}, 3.828171269869621*^9, {3.8281717848068633`*^9, 
   3.8281718148717055`*^9}, 3.8281737273941154`*^9, 3.8285021555127053`*^9, 
   3.828503483891856*^9, 3.82857945111972*^9, 3.828581139291904*^9, 
   3.828583056038974*^9, 3.8285842449051037`*^9, 3.828591674172863*^9, 
   3.828592093902825*^9, 3.8285931209502215`*^9, 3.8285934349518347`*^9, 
   3.82859397931799*^9, 3.8286142898952184`*^9, 3.829800361195816*^9, 
   3.8298004930996466`*^9, 3.829807715291809*^9, 3.8298091904261503`*^9, 
   3.829965138133495*^9, 3.8305859197728477`*^9, 3.8305860094713135`*^9, {
   3.8305877092247114`*^9, 3.8305877369109244`*^9}, 3.8305919244297333`*^9, 
   3.8305948029997377`*^9, 3.8305950142358637`*^9, 3.8316164658874426`*^9, 
   3.8321437368468904`*^9, 3.8321449553694525`*^9, 3.8321450670984373`*^9, 
   3.832145176552021*^9, 3.8510481409175987`*^9, 3.8510501740626636`*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"4838745d-8632-46d7-8b80-9c0671be228f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fourier transform of Voigt function", "Chapter",
 CellChangeTimes->{
  3.8171293231134663`*^9, {3.817129375929954*^9, 3.8171293997597475`*^9}, {
   3.8171298248820457`*^9, 
   3.817129828835388*^9}},ExpressionUUID->"05d5ab70-5e81-43f9-b7f7-\
ffdfe45a908c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "scale", ",", "points", ",", " ", "leftbound1", ",", "leftbound2", ",",
         "rightbound1", ",", "rightbound2", ",", " ", "stepw1", ",", " ", 
        "stepw2", ",", " ", "grid1", ",", " ", "grid2", ",", " ", "samples1", 
        ",", " ", "samples2", ",", " ", "fwhm", ",", " ", "fwhmFT", ",", " ", 
        "g1", ",", "g2", ",", " ", "pl1", ",", "pl2", ",", " ", "fwhmpos", 
        ",", " ", "fwhmposFT"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"scale", "            ", "=", " ", 
        SqrtBox[
         RowBox[{"2", "\[Pi]"}]]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"points", "        ", "=", " ", "2000"}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
        "must", " ", "be", " ", "even", " ", "for", " ", "odd", " ", 
         "interpolation", " ", "orders"}], " ", "*)"}], "\[IndentingNewLine]",
        "\[IndentingNewLine]", 
       RowBox[{"fwhm", "            ", "=", " ", 
        RowBox[{"Voigtfwhm", "[", 
         RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"fwhmFT", "       ", "=", " ", 
        RowBox[{"FTVoigtfwhm", "[", 
         RowBox[{
          RowBox[{"\[Delta]", " ", 
           RowBox[{"cs", "[", 
            RowBox[{"peakpos", ",", "lambda"}], "]"}]}], ",", 
          RowBox[{"\[Sigma]", " ", 
           RowBox[{"cs", "[", 
            RowBox[{"peakpos", ",", "lambda"}], "]"}]}]}], " ", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"2", "\[Theta]"}], "-", "space"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"leftbound1", "   ", "=", " ", 
        RowBox[{"peakpos", "-", " ", 
         RowBox[{"6.", "fwhm"}]}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"rightbound1", "=", " ", 
        RowBox[{"peakpos", " ", "+", " ", 
         RowBox[{"6.", "fwhm"}]}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"stepw1", "           ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound1", "-", "leftbound1"}], ")"}], "/", 
         "points"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"grid1", "             ", "=", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound1", ",", "rightbound1", ",", "stepw1"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"samples1", "       ", "=", "  ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"VoigtApprox", "[", 
            RowBox[{"\[Delta]", ",", "\[Sigma]", ",", "peakpos", ",", "#"}], 
            "]"}], "&"}], ",", " ", "grid1"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"=", 
            RowBox[{"1", "/", "d"}]}], ")"}]}], " ", "-", "space"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"leftbound2", "   ", "=", " ", 
        RowBox[{"s", "[", 
         RowBox[{"leftbound1", ",", "lambda"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"rightbound2", "=", " ", 
        RowBox[{"s", "[", 
         RowBox[{"rightbound1", ",", "lambda"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"stepw2", "            ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound2", "-", "leftbound2"}], ")"}], "/", 
         "points"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"grid2", "              ", "=", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound2", ",", "rightbound2", ",", "stepw2"}], "]"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"samples2", "       ", "=", "  ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"VoigtApprox", "[", 
            RowBox[{
             RowBox[{"\[Delta]", " ", 
              RowBox[{"cs", "[", 
               RowBox[{"peakpos", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{"\[Sigma]", " ", 
              RowBox[{"cs", "[", 
               RowBox[{"peakpos", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{"s", "[", 
              RowBox[{"peakpos", ",", "lambda"}], "]"}], ",", "#"}], "]"}], 
           "&"}], ",", " ", "grid2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"g2", "                  ", "=", "  ", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"fourierData", "[", 
           RowBox[{
            RowBox[{"Transpose", " ", "[", 
             RowBox[{"{", 
              RowBox[{"grid2", ",", "samples2"}], "}"}], "]"}], ",", 
            "scale"}], "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "interpol"}]}], "]"}]}], 
       ";", "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"pl1", "                 ", "=", 
        RowBox[{"Quiet", "@", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"VoigtApprox", "[", 
              RowBox[{"\[Delta]", ",", "\[Sigma]", ",", "peakpos", ",", "k"}],
               "]"}], "/", 
             RowBox[{"VoigtApprox", "[", 
              RowBox[{
              "\[Delta]", ",", "\[Sigma]", ",", "peakpos", ",", "peakpos"}], 
              "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"k", ",", "leftbound1", ",", " ", "rightbound1"}], "}"}], 
           ",", "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotRange", "\[Rule]", " ", "Full"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                           ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                           ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<normalized intensity\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", "                           ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", "\"\<Pseudo-Voigt\>\"", "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"pl2", "                 ", "=", 
        RowBox[{"Quiet", "@", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"FTVoigt", "[", 
              RowBox[{"k", ",", 
               RowBox[{"\[Delta]", " ", 
                RowBox[{"cs", "[", 
                 RowBox[{"peakpos", ",", "lambda"}], "]"}]}], ",", 
               RowBox[{"\[Sigma]", " ", 
                RowBox[{"cs", "[", 
                 RowBox[{"peakpos", ",", "lambda"}], "]"}]}]}], "]"}], ",", 
             " ", 
             RowBox[{"g2", "[", "k", "]"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"k", ",", 
             RowBox[{
              RowBox[{"-", "30."}], "/", "xmag"}], ",", 
             RowBox[{"30.", "/", "xmag"}]}], "}"}], ",", " ", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotRange", "\[Rule]", " ", "Full"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                           ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                           ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           "                           ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", "                           ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<analytical FT\>\"", " ", ",", "\"\<numerical FT\>\""}], 
                "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                           ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", "                            ", 
           RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"fwhmpos", "      ", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", " ", 
           RowBox[{"Arrowheads", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}], "]"}], ",", " ", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"peakpos", "-", 
                 RowBox[{"fwhm", "/", "2"}]}], ",", "0.5"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"peakpos", "+", 
                 RowBox[{"fwhm", "/", "2"}]}], ",", "0.5"}], "}"}]}], "}"}], 
            "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"fwhmposFT", " ", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"Red", ",", " ", 
           RowBox[{"Arrowheads", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.02"}], ",", "0.02"}], "}"}], "]"}], ",", " ", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "fwhmFT"}], "/", "2"}], ",", "0.5"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"+", "fwhmFT"}], "/", "2"}], ",", "0.5"}], "}"}]}], 
             "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Show", "[", 
            RowBox[{"pl1", ",", "fwhmpos"}], "]"}], ",", 
           RowBox[{"Show", "[", 
            RowBox[{"pl2", ",", "fwhmposFT"}], "]"}]}], "}"}], "}"}], 
        "]"}]}]}], " ", "\[IndentingNewLine]", "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "         ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{"\"\<\[Delta] \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "0.1", ",", "\"\<\>\""}], "}"}], ",", 
           "0.001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Delta]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}], ",", 
        "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
      "\[IndentingNewLine]", "        ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<\[Sigma] \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Sigma]", ",", "0.1", ",", "\"\<\>\""}], "}"}], ",", 
           "0.001", ",", "1.", ",", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Slider", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{"Log10", "[", "#", "]"}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                 RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", "\"\< \>\"",
                ",", 
               RowBox[{"InputField", "[", 
                RowBox[{"#", ",", 
                 RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                 RowBox[{"BaseStyle", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
              "}"}], "]"}], "&"}]}], "}"}]}], ",", 
        "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
      "\[IndentingNewLine]", "        ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<Gauss    fwhm\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
        "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "        ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<Lorentz  fwhm\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
        "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "        ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<Voigt    fwhm\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"Voigtfwhm", "[", 
            RowBox[{"\[Delta]", ",", " ", "\[Sigma]"}], " ", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
        "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "        ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<FT Voigt fwhm\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"FTVoigtfwhm", "[", 
            RowBox[{
             RowBox[{"\[Delta]", " ", 
              RowBox[{"cs", "[", 
               RowBox[{"peakpos", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{"\[Sigma]", " ", 
              RowBox[{"cs", "[", 
               RowBox[{"peakpos", ",", "lambda"}], "]"}]}]}], " ", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
       "}"}], ",", "\[IndentingNewLine]", "        ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<mixing   \[Delta]/\[Sigma]\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"Mix", "[", 
            RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}], "}"}]}], 
     "\[IndentingNewLine]", "     ", "}"}], "]"}], ",", "\[IndentingNewLine]",
    "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "        ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<peak position\>\"", ",", "                                 ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"peakpos", ",", " ", "45.", ",", "\"\<\>\""}], "}"}], ",",
            "    ", "1.", ",", "   ", "179.0", ",", " ", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
      "\[IndentingNewLine]", "        ", 
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<wavelength   \>\"", ",", "                                ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lambda", ",", "  ", "0.154", ",", "\"\<\>\""}], "}"}], 
           ",", " ", "0.01", ",", "   ", "0.3", ",", "  ", "Slider", ",", " ", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", ",", "\"\<nm\>\""}], "}"}]}], "              ", 
     "\[IndentingNewLine]", "      ", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "        ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<x-axis spread\>\"", ",", 
        "                                              ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xmag", ",", "1", ",", "\"\<\>\""}], "}"}], ",", "     ", 
           "0.1", ",", "    ", "10", ",", "1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "              ", "\[IndentingNewLine]", "       ", 
      RowBox[{"{", "   ", 
       RowBox[{
       "\"\<interpolation order\>\"", ",", 
        "                                  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"interpol", ",", "1", ",", "\"\<\>\""}], "}"}], ",", 
           "   ", "1", ",", " ", "7", ",", "2", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}]}], "              ", "\[IndentingNewLine]", "      ", "}"}],
     "]"}], ",", "   ", "\[IndentingNewLine]", " ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
      "\"\<Voigt function and its Fourier transform\\n\>\""}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ","}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "->", "True"}]}], " ", "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.8140771304547033`*^9, 3.8140771927183743`*^9}, {
   3.814077259031645*^9, 3.8140773186565495`*^9}, {3.8140773551676607`*^9, 
   3.8140773553683634`*^9}, {3.8140774027978954`*^9, 3.814077419354084*^9}, {
   3.8140774645948315`*^9, 3.8140774705305767`*^9}, {3.814077526878851*^9, 
   3.8140775278667126`*^9}, {3.814077591187489*^9, 3.814077652164401*^9}, {
   3.814077684446787*^9, 3.814077753412609*^9}, {3.8140777941245723`*^9, 
   3.8140778212366753`*^9}, 3.814078189018439*^9, {3.814078225812955*^9, 
   3.8140782461278677`*^9}, {3.814078341911869*^9, 3.8140784096431656`*^9}, {
   3.814078439977064*^9, 3.8140784511678305`*^9}, {3.814078535987029*^9, 
   3.814078543080739*^9}, {3.8140785922166185`*^9, 3.8140785986925907`*^9}, {
   3.8140786296678033`*^9, 3.8140786315521865`*^9}, {3.814078695610015*^9, 
   3.814078698667507*^9}, {3.8140787361495104`*^9, 3.814078878241047*^9}, {
   3.814078972480596*^9, 3.8140790836644907`*^9}, {3.814079145976894*^9, 
   3.8140791539040723`*^9}, {3.814079277383916*^9, 3.8140793088312993`*^9}, {
   3.814079384043247*^9, 3.8140794286893573`*^9}, {3.814079486883639*^9, 
   3.814079493537532*^9}, {3.8140796065033817`*^9, 3.814079651079243*^9}, 
   3.814079724518266*^9, {3.814080861850895*^9, 3.814080873877462*^9}, {
   3.814080905936254*^9, 3.8140809914850245`*^9}, {3.814081032494896*^9, 
   3.8140810425126076`*^9}, {3.814081086224352*^9, 3.814081092575427*^9}, {
   3.814081146258117*^9, 3.814081158598447*^9}, {3.8140862953888397`*^9, 
   3.81408634116351*^9}, {3.8140864010418158`*^9, 3.8140864160244255`*^9}, 
   3.8140864872392178`*^9, 3.8140865665585575`*^9, {3.8140866230305047`*^9, 
   3.8140866239332*^9}, 3.817117157157921*^9, {3.81712941491698*^9, 
   3.817129418276671*^9}, {3.817179825711928*^9, 3.817179828336958*^9}, {
   3.817180365635533*^9, 3.8171803921069765`*^9}, {3.8188444375892086`*^9, 
   3.8188444398703356`*^9}, {3.824302869817028*^9, 3.82430287611112*^9}, {
   3.824302908284425*^9, 3.8243032322013845`*^9}, {3.8243033346008325`*^9, 
   3.8243033368131447`*^9}, {3.824305849334175*^9, 3.824305849890195*^9}, {
   3.82430685316903*^9, 3.82430686313595*^9}, {3.8243083722792807`*^9, 
   3.8243083850564737`*^9}, {3.824308477740466*^9, 3.824308502746392*^9}, 
   3.824308951193722*^9, {3.8243552793325*^9, 3.8243552793797836`*^9}, {
   3.8243556411975293`*^9, 3.8243556414318466`*^9}, {3.824355706272855*^9, 
   3.8243557077949867`*^9}, {3.824355789315383*^9, 3.8243558004250064`*^9}, {
   3.824355847944738*^9, 3.8243558502821817`*^9}, {3.824356694270076*^9, 
   3.8243569083600516`*^9}, {3.8243569405961485`*^9, 3.82435694122112*^9}, {
   3.8243570417986407`*^9, 3.8243570449604826`*^9}, {3.82435712607434*^9, 
   3.824357222110106*^9}, {3.824357287644951*^9, 3.824357339991106*^9}, {
   3.824357530164979*^9, 3.824357560752248*^9}, {3.82435768158278*^9, 
   3.824357756800455*^9}, {3.824357859502189*^9, 3.8243579149100094`*^9}, {
   3.8243584112588587`*^9, 3.8243584172926807`*^9}, {3.8243584692171197`*^9, 
   3.8243584864210176`*^9}, {3.824358583210613*^9, 3.8243586116436377`*^9}, {
   3.8243586630379515`*^9, 3.824358858437659*^9}, {3.8243589056230373`*^9, 
   3.824358920059605*^9}, {3.8243589905996823`*^9, 3.824359090635066*^9}, {
   3.824359147247284*^9, 3.824359216562481*^9}, {3.8243595747186003`*^9, 
   3.8243595819845343`*^9}, {3.8243596946455536`*^9, 3.824359698239518*^9}, {
   3.82435978366495*^9, 3.8243597845865984`*^9}, {3.824359852187502*^9, 
   3.8243598744185147`*^9}, {3.8243601317257504`*^9, 
   3.8243601713837214`*^9}, {3.824360239433177*^9, 3.8243602941072936`*^9}, {
   3.8243603687547197`*^9, 3.8243604210500174`*^9}, {3.824360477801982*^9, 
   3.824360478198121*^9}, {3.824360517460189*^9, 3.82436071187379*^9}, {
   3.824360795437742*^9, 3.824360838206778*^9}, {3.824362346934429*^9, 
   3.8243623582227063`*^9}, 3.8243627186434913`*^9, {3.8243627664031935`*^9, 
   3.824362835107442*^9}, {3.8243628736631055`*^9, 3.8243629592307143`*^9}, {
   3.824363050567711*^9, 3.824363072146671*^9}, {3.8243632658718643`*^9, 
   3.8243632919979134`*^9}, {3.8243633667977705`*^9, 
   3.8243633671564713`*^9}, {3.824363419618494*^9, 3.8243634673782806`*^9}, 
   3.824363625734894*^9, {3.824382138834611*^9, 3.8243821394000373`*^9}, {
   3.824382532403372*^9, 3.824382532829406*^9}, {3.824643075747881*^9, 
   3.8246430794289227`*^9}, {3.8246431167889996`*^9, 
   3.8246431340083847`*^9}, {3.824960702174142*^9, 3.824960735159259*^9}, 
   3.8268682156096373`*^9, {3.827977739851082*^9, 3.827977741694925*^9}, {
   3.828088797684333*^9, 3.828088856625125*^9}, {3.828088924451937*^9, 
   3.828089022666831*^9}, {3.828089070542207*^9, 3.8280890830615215`*^9}, {
   3.8280892163169394`*^9, 3.8280892180809927`*^9}, {3.8280893391597276`*^9, 
   3.828089340709896*^9}, {3.828090711458505*^9, 3.8280907916227703`*^9}, {
   3.828090856771083*^9, 3.828090858610093*^9}, {3.8280908923039775`*^9, 
   3.8280909359933815`*^9}, {3.828090987321724*^9, 3.8280909878674293`*^9}, {
   3.828091029071227*^9, 3.828091031617379*^9}, {3.8280911120382805`*^9, 
   3.828091114582925*^9}, {3.8280911542293234`*^9, 3.8280911597703376`*^9}, {
   3.828091547731542*^9, 3.8280915818215175`*^9}, {3.8280916518099527`*^9, 
   3.82809166100492*^9}, {3.828091850842126*^9, 3.828091869972158*^9}, 
   3.8281057469234247`*^9, {3.8281058078025446`*^9, 3.8281058713560486`*^9}, {
   3.828105962635137*^9, 3.828105965125249*^9}, {3.8281065012336035`*^9, 
   3.828106556837617*^9}, {3.8281556704842095`*^9, 3.8281556709896035`*^9}, {
   3.828155803586591*^9, 3.8281558303789425`*^9}, {3.8281561950303373`*^9, 
   3.8281562265806055`*^9}, {3.8285844146871123`*^9, 3.8285844183763075`*^9}, 
   3.8286142986771975`*^9},
 CellLabel->
  "In[138]:=",ExpressionUUID->"cd39a20f-8a88-45f5-ad6d-cd1b129540d6"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`interpol$$ = 1, $CellContext`lambda$$ = 
    0.154, $CellContext`peakpos$$ = 45., $CellContext`xmag$$ = 
    1, $CellContext`\[Delta]$$ = 0.1, $CellContext`\[Sigma]$$ = 0.1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.1, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`\[Sigma]$$], 0.1, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{"\[Delta] ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss    fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Lorentz  fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Voigt    fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"FT Voigt fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`FTVoigtfwhm[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], $CellContext`\
\[Sigma]$$ $CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$]], {
            3, 5}]], "nm"}, {"mixing   \[Delta]/\[Sigma]", 
          Dynamic[
           NumberForm[
            $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`peakpos$$], 45., ""}, 1., 179.}, {{
       Hold[$CellContext`lambda$$], 0.154, ""}, 0.01, 0.3}, {
      Hold[
       Grid[{{"peak position", 
          Manipulate`Place[3], "\[Degree]2\[Theta]"}, {"wavelength   ", 
          Manipulate`Place[4], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xmag$$], 1, ""}, 0.1, 10, 1}, {{
       Hold[$CellContext`interpol$$], 1, ""}, 1, 7, 2}, {
      Hold[
       Grid[{{"x-axis spread", 
          Manipulate`Place[5]}, {"interpolation order", 
          Manipulate`Place[6]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1209., {191., 197.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`interpol$$ = 1, $CellContext`lambda$$ = 
        0.154, $CellContext`peakpos$$ = 45., $CellContext`xmag$$ = 
        1, $CellContext`\[Delta]$$ = 0.1, $CellContext`\[Sigma]$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`scale$, $CellContext`points$, \
$CellContext`leftbound1$, $CellContext`leftbound2$, \
$CellContext`rightbound1$, $CellContext`rightbound2$, $CellContext`stepw1$, \
$CellContext`stepw2$, $CellContext`grid1$, $CellContext`grid2$, \
$CellContext`samples1$, $CellContext`samples2$, $CellContext`fwhm$, \
$CellContext`fwhmFT$, $CellContext`g1$, $CellContext`g2$, $CellContext`pl1$, \
$CellContext`pl2$, $CellContext`fwhmpos$, $CellContext`fwhmposFT$}, \
$CellContext`scale$ = Sqrt[2 Pi]; $CellContext`points$ = 
          2000; $CellContext`fwhm$ = $CellContext`Voigtfwhm[$CellContext`\
\[Delta]$$, $CellContext`\[Sigma]$$]; $CellContext`fwhmFT$ = \
$CellContext`FTVoigtfwhm[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], $CellContext`\
\[Sigma]$$ $CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$]]; \
$CellContext`leftbound1$ = $CellContext`peakpos$$ - 
           6. $CellContext`fwhm$; $CellContext`rightbound1$ = \
$CellContext`peakpos$$ + 
           6. $CellContext`fwhm$; $CellContext`stepw1$ = \
($CellContext`rightbound1$ - $CellContext`leftbound1$)/$CellContext`points$; \
$CellContext`grid1$ = 
          Range[$CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$]; $CellContext`samples1$ = 
          Map[$CellContext`VoigtApprox[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$, $CellContext`peakpos$$, #]& , $CellContext`grid1$]; \
$CellContext`leftbound2$ = $CellContext`s[$CellContext`leftbound1$, \
$CellContext`lambda$$]; $CellContext`rightbound2$ = \
$CellContext`s[$CellContext`rightbound1$, $CellContext`lambda$$]; \
$CellContext`stepw2$ = ($CellContext`rightbound2$ - \
$CellContext`leftbound2$)/$CellContext`points$; $CellContext`grid2$ = 
          Range[$CellContext`leftbound2$, $CellContext`rightbound2$, \
$CellContext`stepw2$]; $CellContext`samples2$ = 
          Map[$CellContext`VoigtApprox[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], $CellContext`\
\[Sigma]$$ $CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], 
             $CellContext`s[$CellContext`peakpos$$, $CellContext`lambda$$], \
#]& , $CellContext`grid2$]; $CellContext`g2$ = Interpolation[
            $CellContext`fourierData[
             
             Transpose[{$CellContext`grid2$, $CellContext`samples2$}], \
$CellContext`scale$], 
            InterpolationOrder -> $CellContext`interpol$$]; $CellContext`pl1$ = 
          Quiet[
            
            Plot[{$CellContext`VoigtApprox[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$, $CellContext`peakpos$$, \
$CellContext`k]/$CellContext`VoigtApprox[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$, $CellContext`peakpos$$, $CellContext`peakpos$$]}, \
{$CellContext`k, $CellContext`leftbound1$, $CellContext`rightbound1$}, 
             PlotRange -> Full, GridLines -> Automatic, GridLinesStyle -> 
             Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
             FrameLabel -> {
              "2\[Theta] axis (\[Degree])", "normalized intensity"}, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
               LineLegend[{"Pseudo-Voigt"}], {0.2, Top}], TicksStyle -> 
             Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
             ImageSize -> 600]]; $CellContext`pl2$ = Quiet[
            Plot[{
              $CellContext`FTVoigt[$CellContext`k, $CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], $CellContext`\
\[Sigma]$$ $CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$]], 
              $CellContext`g2$[$CellContext`k]}, {$CellContext`k, \
(-30.)/$CellContext`xmag$$, 30./$CellContext`xmag$$}, PlotRange -> Full, 
             GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
             PlotStyle -> {Thick}, Frame -> True, 
             FrameLabel -> {"s (nm)", "Fourier transform"}, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
               LineLegend[{"analytical FT", "numerical FT"}], {0.2, Top}], 
             TicksStyle -> Directive[Black, 15], AxesStyle -> 
             Directive[Black, Thick], ImageSize -> 
             600]]; $CellContext`fwhmpos$ = Graphics[{Red, 
             Arrowheads[{-0.02, 0.02}], 
             
             Arrow[{{$CellContext`peakpos$$ - $CellContext`fwhm$/2, 
                0.5}, {$CellContext`peakpos$$ + $CellContext`fwhm$/2, 
                0.5}}]}]; $CellContext`fwhmposFT$ = Graphics[{Red, 
             Arrowheads[{-0.02, 0.02}], 
             
             Arrow[{{(-$CellContext`fwhmFT$)/2, 0.5}, {
               Plus[$CellContext`fwhmFT$]/2, 0.5}}]}]; Grid[{{
             Show[$CellContext`pl1$, $CellContext`fwhmpos$], 
             Show[$CellContext`pl2$, $CellContext`fwhmposFT$]}}]]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.1, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.1, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 2}, 
        Grid[{{"\[Delta] ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss    fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Lorentz  fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Voigt    fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"FT Voigt fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`FTVoigtfwhm[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$], $CellContext`\
\[Sigma]$$ $CellContext`cs[$CellContext`peakpos$$, $CellContext`lambda$$]], {
             3, 5}]], "nm"}, {"mixing   \[Delta]/\[Sigma]", 
           Dynamic[
            NumberForm[
             $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}], 
        Delimiter, {{$CellContext`peakpos$$, 45., ""}, 1., 179., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`lambda$$, 0.154, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 4}, 
        Grid[{{"peak position", 
           Manipulate`Place[3], "\[Degree]2\[Theta]"}, {"wavelength   ", 
           Manipulate`Place[4], "nm"}}], 
        Delimiter, {{$CellContext`xmag$$, 1, ""}, 0.1, 10, 1, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`interpol$$, 1, ""}, 1, 7, 2, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 6}, 
        Grid[{{"x-axis spread", 
           Manipulate`Place[5]}, {"interpolation order", 
           Manipulate`Place[6]}}]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Voigt function and its Fourier transform\n"}, LabelStyle -> 
        Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ControlPlacement -> {Left}, ContinuousAction -> False, TrackedSymbols -> 
        True}, "DefaultOptions" :> {}],
     ImageSizeCache->{1928., {260., 266.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.824362996894114*^9, 3.824363203775825*^9, 3.824363305123293*^9, {
   3.824363440346178*^9, 3.82436346899684*^9}, 3.8243636485564938`*^9, 
   3.8243818474288645`*^9, 3.824382489578265*^9, 3.824639898110428*^9, 
   3.824640196320099*^9, {3.8246403193850727`*^9, 3.8246403279635925`*^9}, 
   3.824640393637042*^9, 3.8246431397113066`*^9, 3.8246434310455933`*^9, 
   3.8249602141953726`*^9, 3.824960764722331*^9, 3.8254752994984384`*^9, 
   3.826859703480835*^9, 3.827836504226401*^9, 3.827837546116463*^9, 
   3.827914443164321*^9, 3.8279155206589794`*^9, 3.8279155587907705`*^9, 
   3.8279167114874496`*^9, 3.8279168952385345`*^9, 3.8279760116356297`*^9, 
   3.8279763298627024`*^9, 3.8279777454293585`*^9, {3.8280890854342504`*^9, 
   3.828089122612498*^9}, 3.828089182742618*^9, 3.8280892723534064`*^9, 
   3.8280893415744333`*^9, 3.8280907379853334`*^9, 3.828090937449597*^9, 
   3.8280909896434717`*^9, 3.828091032614827*^9, 3.828091117939103*^9, {
   3.828091164545766*^9, 3.8280911918836355`*^9}, 3.828091590223984*^9, 
   3.828091662579071*^9, 3.8280918153649745`*^9, {3.828091857568492*^9, 
   3.828091872919566*^9}, 3.828092862107737*^9, 3.8280929165129247`*^9, {
   3.828105749445081*^9, 3.8281057740265503`*^9}, 3.828105812002097*^9, 
   3.8281059724212446`*^9, 3.8281060432168117`*^9, 3.82810615514987*^9, 
   3.8281553897908673`*^9, 3.828156024076227*^9, 3.8281562120801735`*^9, 
   3.828160050830613*^9, 3.828161195078228*^9, {3.8281613033147907`*^9, 
   3.8281613266893425`*^9}, 3.8281614612394733`*^9, 3.8281616554559927`*^9, 
   3.828162583501416*^9, 3.8281708450943394`*^9, 3.828171034345546*^9, {
   3.8281710679750843`*^9, 3.82817108445573*^9}, 3.828171270549752*^9, {
   3.82817178544751*^9, 3.8281718155403414`*^9}, 3.8281737280702553`*^9, 
   3.828502156169359*^9, 3.828503484545504*^9, 3.8285794518243237`*^9, 
   3.8285811399945703`*^9, 3.8285830566236825`*^9, 3.8285842455922585`*^9, 
   3.8285843066878567`*^9, 3.8285844195241547`*^9, 3.8285916747588377`*^9, 
   3.8285920944935045`*^9, 3.8285931215478964`*^9, 3.8285934355265245`*^9, 
   3.828593979926657*^9, 3.8286143010367374`*^9, 3.8298003617973747`*^9, 
   3.8298004936009383`*^9, 3.8298077158621264`*^9, 3.829809190958477*^9, 
   3.829965138696*^9, 3.8305859204027076`*^9, 3.8305860100806828`*^9, {
   3.830587709850727*^9, 3.830587737616248*^9}, 3.8305919250716705`*^9, 
   3.8305948036962695`*^9, 3.830595014814983*^9, 3.8316164664499226`*^9, 
   3.832143737479697*^9, 3.8321449559397683`*^9, 3.832145067684372*^9, 
   3.832145177068934*^9, 3.851048141448636*^9, 3.851050174656684*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"ab4d6f87-3716-46c7-b7d6-f903f37c6274"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.8251412791885033`*^9},
 CellLabel->
  "In[139]:=",ExpressionUUID->"52f68ab1-a65c-4904-9619-9780cfc807ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"fwhm", ",", 
        RowBox[{"GaussIB", "[", "fwhm", "]"}], ",", 
        RowBox[{"1", "-", "fwhm"}], ",", 
        RowBox[{"LorentzIB", "[", 
         RowBox[{"1", "-", "fwhm"}], "]"}], ",", 
        RowBox[{"Voigtfwhm", "[", 
         RowBox[{
          RowBox[{"Delta", "[", "fwhm", "]"}], ",", 
          RowBox[{"Sigma", "[", 
           RowBox[{"1", "-", "fwhm"}], "]"}]}], "]"}], ",", 
        RowBox[{"VoigtIB", "[", 
         RowBox[{
          RowBox[{"GaussIB", "[", "fwhm", "]"}], ",", 
          RowBox[{"LorentzIB", "[", 
           RowBox[{"1", "-", "fwhm"}], "]"}]}], "]"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"fwhm", ",", "0.03", ",", "1.0"}], "}"}], ",", " ", 
      "\[IndentingNewLine]", "                             ", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      "\t\t\t ", 
      RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
      "                             ", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", " ", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Blue", ",", "Thick", ",", "Dashed"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Red", ",", " ", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Red", ",", "Thick", ",", "Dashed"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Green", ",", " ", "Thick"}], "]"}], ",", 
         RowBox[{"Directive", "[", 
          RowBox[{"Green", ",", "Thick", ",", "Dashed"}], "]"}]}], "}"}]}], 
      ",", " ", "\[IndentingNewLine]", "                             ", 
      RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
      "                             ", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<FWHM(G) (\[Degree]2\[Theta])\>\"", ",", 
         "\"\<FWHM (\[Degree]2\[Theta])\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", "                             ", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", "                             ", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]",
       "                             ", 
      RowBox[{"PlotLegends", "\[Rule]", 
       RowBox[{"Placed", "[", 
        RowBox[{
         RowBox[{"LineLegend", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*SubscriptBox[\(fwhm\), \(G\)]\)\>\"", ",", 
             "\"\<\!\(\*SubscriptBox[\(\[Beta]\), \(G\)]\)\>\"", ",", 
             "\"\<\!\(\*SubscriptBox[\(fwhm\), \(L\)]\)\>\"", ",", 
             "\"\<\!\(\*SubscriptBox[\(\[Beta]\), \(L\)]\)\>\"", ",", 
             "\"\<\!\(\*SubscriptBox[\(fwhm\), \(V\)]\)\>\"", ",", 
             "\"\<\!\(\*SubscriptBox[\(\[Beta]\), \(V\)]\)\>\""}], " ", "}"}],
            ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"\<Row\>\""}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.65", ",", "0.86"}], "}"}]}], "]"}]}], ",", " ", 
      "\[IndentingNewLine]", "                             ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"SwatchLegend", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<label1\>\"", ",", "\"\<label2\>\"", ",", "\"\<label3\>\""}], 
           "}"}], ",", 
          RowBox[{"LegendFunction", "\[Rule]", "\"\<Frame\>\""}]}], "]"}], 
        ","}], " ", "*)"}], "\[IndentingNewLine]", "                        ", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
      "                            ", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
      "                            ", 
      RowBox[{"ImageSize", "\[Rule]", "600"}]}], "\[IndentingNewLine]", 
     "                         ", "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8235868731451397`*^9, 3.823586910679629*^9}, {
   3.8235870813682146`*^9, 3.8235871780111065`*^9}, {3.823587213121009*^9, 
   3.823587255836424*^9}, {3.8235934952016892`*^9, 3.8235935031995735`*^9}, {
   3.824643173985973*^9, 3.824643184990814*^9}, {3.824643231903392*^9, 
   3.824643237588504*^9}, {3.8246433423456783`*^9, 3.824643400279604*^9}, {
   3.825133044649536*^9, 3.8251330452970204`*^9}, {3.825133302636511*^9, 
   3.825133303365783*^9}, {3.8251337368151636`*^9, 3.825133737266858*^9}, {
   3.825134036555462*^9, 3.825134067853182*^9}, {3.825134121261011*^9, 
   3.8251341864814367`*^9}, {3.8251352853309383`*^9, 3.825135286009676*^9}, {
   3.8251354756224756`*^9, 3.8251354793253813`*^9}, {3.825135518201232*^9, 
   3.825135566593182*^9}, {3.8251356100719104`*^9, 3.8251356542985735`*^9}, {
   3.825135704487335*^9, 3.825135736550723*^9}, {3.825138234392435*^9, 
   3.8251382681122303`*^9}, {3.8251383359577284`*^9, 
   3.8251383632395597`*^9}, {3.8251384971598663`*^9, 3.825138607077653*^9}, {
   3.8251407636911454`*^9, 3.825140788976783*^9}, {3.825140899576192*^9, 
   3.8251409390781326`*^9}, {3.8251412711725483`*^9, 3.825141287235672*^9}, {
   3.8251414709473925`*^9, 3.8251415178343167`*^9}, {3.8251415514514647`*^9, 
   3.825141578608802*^9}, {3.8251416370333166`*^9, 3.8251416409087873`*^9}, 
   3.8251417692038803`*^9, {3.8251418206142406`*^9, 3.8251418899646664`*^9}, {
   3.8251422186230526`*^9, 3.8251424314294195`*^9}, {3.825142464711836*^9, 
   3.825142523699331*^9}, {3.8279145725523434`*^9, 3.827914579739504*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"689af526-9725-4d08-bc13-2d99fdd67b5e"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJxFxWswEwAcAHC5uLNuHteJsuxyRHKqc+cucpNMElIt7yGaRyfckSk3TXSE
c1s57bTmkTOvViSVdiOvkFoeeVyL2dDMREqRQ/Wh///D7377IhPPMbS1tLR8
/vo3ncWnnH8hoPzf0dxAdUa3FDZszeR40/BOrZgp6hJu3M47Tioqg9OpUUr9
/nLY03t1/w/nSlgRZCGSmNXAF07rrAlGGmC3MGbVy65mOK2TfYnIfwWL99aa
111pg9lDg4YseTtcw43g9OZ0wcy1o7xGix44L2TQqpfTB2t3S12DHd7BEtuC
KdMaKcwheek46Q3A34VsuWXgIHztSXFGFWcIPuISHsVQDsNigU/B8qEROI5l
lrYrehT2lN+vZTaPwV5t66WJS+NwhqW+rNL9E3yL7hFafUcGi3aGlbr1fYb1
fG0O7CFNwh3ac06dB+XwfI9fVmQ3bjdglEhOmII377mJhQQFrC7rr/dtwilF
ca2yYCVs5ZHq4PgTt3SSeYkE03CTpqHjm/MMLLpdEkYawV/HyvgM1izM0C08
dn33F9hilnfjUTuelL3Tsj5CBdsQy9XcdXxtNIdW/HAODrk4QY52VcMjdoWF
NDXeovAj23Ln4cMBWUZv7TRwK9FAmPcRn7xJEBgnL8CxCtPnOcSvMCGbnWz6
DHeZDuCmnF2E27apJPY03J2cplH5417BvJP0UNz/w9gGNQZPEgddNmHhlUUh
J1qqcevG+aSUOrxWmi6wF+ENBP5axVNcwpY9zpfgY/F0En0YD8lbOGUyik8I
WcyBcXxG8WCQOokvB07k2qvxq6kJzSoNvnp3U1mxiG++N6eYrOCZGlH8wC98
O4FSkv8bz7WWvqFu4Duo4StbW/gfw3R/ew==
         "]]},
       Annotation[#, "Charting`Private`Tag$17177#1"]& ], 
      TagBox[
       {RGBColor[0, 0, 1], Thickness[Large], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwV0Hk4lAkAx3ERW0pSK5RGMUVl1W7ylKOfWtMhpM19FgmtjZ4Othq5NhXJ
ND0lZs0kN40QqWYpoYucOTIMM4YxM3rfUdkkbPvH9/n8/10dEP5bkLKSkpLj
9/7Xl87CwapMSCZM9+V7cmBB0ZTsV2MjiudqvD6eg8U1sakOLmzMi4tWKS7m
oE4peJBGsrFOo+VJySwH2rVpO/RvcBBqdNL0Yc4dnKMFihY13sHo/kcaDYos
7HH4svaTVTak+bQW0eUcCD0NudUrCiD38nM1eFwI132qk5mdpSCZfmfmTpdh
p19k7qP6SvzEMHmfbFOFqLqYIxqsJ6jpSQqqCPwHvJWFlKI/nuKIrDbjzfln
iGlvW0wfqIX9liZnNd06FDAOpb5KrEdYj2HBSlkDIie3pZUZvsQ2I5q2aukr
XPFuW/Mq9TVCqk45WuxuhHJDs63X5ia05xEmdtrNqF6fPKhb0AxnhZWkqacF
qfr2qpbzW5F8eLj+sGEbPubFDFA92iCOtvgsutiOP+/fjM5NbQe546p6UnsH
frbxDwwSdUCv7PKJVdad4GU6Jo9v7ITO6TDhyswuhNJXRC072oWGPtdttpJu
7BnIKIys7Abz49Cgs9N72D+dYoeTPdAqORtxkdWLaOoifrZdL+7pVDoXqvXh
L99dPvnX+aC0d1laHOsHd6kfe+frPtiaKy0YqRBgvpPJuuX6AtiuDl72PGUA
z5VHLes2DGDruQPLcywGIXvpHB/QMICMGTMjq95BmLZqhRscH8RVD4HLy6tC
zNzayctTF8JdlTkZbC6ClNNY7PRAiNJLei9mJCLgRmgN30uE01uYt/emD2HN
rjObLSZEWLJlsSAXYlAt+fbczCHYLDjkODUuxgN56XOFlRg7zMvNAtKHwb2c
7qffKcb9i5M/0reP4FkInxVEH8a9kiXUa+QIgtRSrM/qjSBhw8bc8psSGA6n
XbhXOwIJnXKg2X4UEQlLqcWHJFhrpBU+PT4KE407UsaUBG8VEwzBLSkmuxJd
bt4dhdqtkr4qexm8D/cbHLWVQvva76xshQydpikpLlIpHvh+jU/MleOx0Nlg
PUMGnuv5CIrHGDa5x2u9MZWDzZnT8mJ6DDUamnlX3smhWevpEVL6AYI49Uzt
k2PwtKg4uMKTQIhQ92Gixgcs7FBxiZsmoJ4Qc1K34gOMs69vJ91J2Ay5M04d
IFDxQ06ySRGJp3Mk1WYuBGJ7s6isYhJ2BlFyiRsBxxIOT5NLwt4rbbevD4Fh
N5Z84j4Jt5buaVowgWW5TIf6ShIRPM9jOnQCUXZxCwNqSWTf8P71cT4B61j/
5IweEsZlsohTRQTmu/pSNXtJFDafyzTjEnhn4s2L45MoVWdNZpUTON7iJg8V
kKiO4ZckVRNgGzg5bBWT6A7z1fftIDCn2nrhO5KE95WxvTpdBJoYltl7xkn0
59EjW3sI3A7aas37SEIs/LuNJiDwi4Z52N0JEuMe/ZfMpAQCfTY0nvhG4vSZ
45USOYGNm9YdEU+T+MKcEWURBKZUjL95zJKYeUuBzmcCzCJDU1tlBWLl3LDW
fwn4X1hVV66iwFx1pCd9JWB6kOJjrKrAJePmF7Tvn7+s1f+UrqbAApr/59lZ
AnVf9ZIXzVPgP1i1dpo=
         "]]},
       Annotation[#, "Charting`Private`Tag$17177#2"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVzH881HcAx/FLkRQy6awuykTsZvVoa00/3pgfJZXNr6KTNFQrP4YYj7NT
StHMFaWyUzInP66U3ajb+e0I8aX8yOXOnR/nHFeiUtG+/fF5fB7Px+vzea8J
DPspSINCoewmz6ebwcyGRzkHRrT5wdt01Nhkoq/Yq5UDveRKVutCNZZWJqa7
eeZAezL+OkNTjTpKyIDTixy8E021MylqGNVk2dMybkASObxF+HoC8U6H5Xot
N1HQ3GQA+QR2uL21mNqSh63x6f/ZCSYg22/GE668jcBnq4wcQyfgtUtzhtNV
ikxvyWp6/Tgc/GPyK+r52LxsQ/MOy3HE1rF+1s1+iIiRMI+ECyoIVhWaFJ2o
AjvWa3Pm4BhYnR1LmdIarN7V/FDqMobb7ID0puR6XO4bua7LUSJm5vuse2aN
yE18ud/jzShS/DrWNqU/gsnRVH6r3yg0GtrsfDe2gqXXEmZ1XwGh9YUB49tt
cJ/OFlUYKZBOc9W0XUSg/KXvbGD8CF5xWVLzfR3QKq78c7xzGL/dvZyQn96J
Om5ZVfF3w9iw7eDhIPkTHDnkvmd32hAEnN0XJr/uQu763gotxSCOMlfGLg/u
hpv9ZO2U2yB2SK8XxvB7INa/Z12XJ4dr1fucsBe96DPVWN+4UI4Ecz1xnmMf
qsffsksYMpxhOB8ouCjGdkJMFPEHwDP0z3F49BxWr93v9q8YwKI966xW0CT4
0PPL2GSEFLUao7Z1X0oR9+6rlJgCCcYa3U8HNkhhHeo/YxvZDzphEGYaOoAC
hnhN9RfPMXfFQcDVkWFBe1zyXWUflDdaiveUyUAXBucHXnkGZBytFPvKcaqb
nujs2ou1zic3bnotBz/S8Oolwx6Y24pdeZxBlKe6HLtV04UyVWntyy1DyLLI
jqWdewre+Wv+tK4h5KkeOYg8nqD6iDg7iDmMBBuXhm80OxGklbY17vMRbHol
P7u4lYDZcNbvJTUjEGx8TPk7rh3hSYbmxQEK2E2Uhu1lPsY63ZtK9nsFAprj
vcoNWjDTnex5+dYoaDekJfkRTfA71G8abKdERtxZVshcA7roaWmeSiUK3ET1
Jd51eCBzN7Vmj8E4WnDK52E11vucNmimq8ByHorkXhWiUlefm/JUBe2LyaJC
jwpITulwjCLHoT1apO8RUoYjMuN/k3UnwOqNSEuyvAOdJFak8T8TCKh8I4rl
5WHboA876kc1AmLnPz1BZKJqnkJo46kGpfGj2bq4TDiaxqoU3mqwqB/CZWaZ
cPXNcmEcUKOKP7XEJyoD3u09s04hathNDznaUS8hXLD/GJVJ/v+1sewzRjry
Mvx+eFBAunuFVRhxBpb3xsKjisj3Jw3r5WZnUNgWz7HhkftGSw7ti0pCqU72
TO59ct9jNsueehpClvhOqpDs7RLtZQwWeo4zaIwn5F7GTiKCiIZfyvhOajfZ
O2wX+UVFoZ/LjCF6yW5At3ekRmJI9leHk4Tsf+iVLmeEY3Jf/zkbJdn1uGti
iCBEnwzlK1SkU8+zd1IP4+2lOXmumrT28Xk0RgDmHpuAOk16QWBNIuGFRBXv
OPGG9JxFrgXDHQt0cC31HekX3fOvEE44Z9kmcpolXVV7tpr4FoudDk5//Eia
QlFG23tt/x//QWvB
         "]]},
       Annotation[#, "Charting`Private`Tag$17177#3"]& ], 
      TagBox[
       {RGBColor[1, 0, 0], Thickness[Large], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwVxX040wkAB3C5OCkvpdLVjrvRm9xUejzPpfqWWnUuslLyPgnVKSQvvaxG
OiPVXG8qZqvOW+W8LFwkbynSLXRezthsbDOzn7zMRLm7Pz7P5/vDYfuCdHV0
dFz+8/++jHTsL+Pgk+MCmoauhYOFiWKvfiZ+V4TuneevhenLOPYe90zsu/Xa
heyrRZ1OSC91OBO56vPOrp5aLKpJ20a6yYUnT749i6bFOWqg1LiJhzL9Fw4H
nbTYvUe7YszxEaKbQ0glVlpIPMn5lctyMRL8Qh4lm8CBn/UmOW2FuJWwkpsd
MAEnv5isP1+VoN28zCurX4PYOuYRo/RymIzzmsxCNaj4Ns/i8YkqjNY50+0V
42C2tpgyxDWIMlyqsTwxjtxUOrsh8RUeOuU8rZSPIWbyx7Qi8hu8rrtOajoy
hmTvluUN7EYkV2RczVKOQrdesNXL/h20Wce/sw8eRaVNSu+SXAF0v/Z7lqIc
AZvkrLdxTjP0CvNmHYgYwWg2U2x9qAXFLiVhgqGPOFNw+0IWuxUz/grR4siP
WLfZPzBI+gGaI50RpuphVHBcUkbs2tBXbFUe+8swjjGWxS4ObodkeJWRj5TA
bvH9vJiSDtD8WXKbLjWcq6Yyw4Y78alsQ/2NviFcsDYWPtrRhekJPwW9U4XL
vjt9cn4TYqjR8czc1kHkm/llOjV2wzwpyNitR4k5rqtWLyWJcN/WSK79MIBa
3YGNdWvEOFQ+q86xW4HBN26XDteLMbsnx8RHKYdt8/wwy5O9MJC944glMny5
41SRbSjBrk6sn1H1Q8lteuLKl0BYaDcnXtIH3Dz2UuglBd2ixVUilGL5zmh7
B40UltHVaUKFBNYbhc75nD44FFNWOIp7wVcV1n507AerS1FqPyBGftI9P1Jb
P67bPQ43U4tQfVSYHsSQofIUU5so7kaQ/rVNZ7+RIzCFYK3VdIEsS7v4tEaO
knAvLk/SifAEM+sndAWYa/yrdo60Y5URT5k6pcAK44YXWXPbMNme6H774QDO
llOcBFOt8A7osQzeqgQVFMEakxa02V675q5U4sKy/fW8EQGeS9wsbVIHYWew
MDfgn7dY63Fp/ltbFep5BhlJBm/w0sgkO/lvFSrej3Gc+mohijfkLIocQsaT
hUWB+lU4KllSmmikRmzB55mxmDIYJjAjlzxT49T66tIdWwqwuc8j9TSNQDKp
w6qBzEPVLEUlxZ1Azeqor7b0cLHDMlalOEhA7LBAWnSXC2evtF2+PgTcaHse
pJtycfB9x2dqCAG/eXHbxNMZCK/wPG7OIBAjojlS+Hfx6Kb39uc5BLIvj1Ia
yalYWTQYfvoxAXPuD+riu2zkCc5xKPkEfn0e8jTDlI1Cw/TJB8UEQnpKPSTT
V1HJFP5xpZLAxUIWbS0/CR2hviTfDwQKPGyoTeQ4eCcP/WTeTuB6Cqc205SJ
nmxGTHMnge745QmyaQb6JRktVBEB9gENYwP/DEYO9bAoSgLVU3ci3pMjEBV9
skShIjDTqNOtnj4B7Y0v0gcEgfOc5rZN/GP48pcFzMcJRFMjGzvIAYhT5Yc2
TxCQrWOxXPiemG2Ie1c+ERB1rD4/QKaBtVLwmvqZwPHJ2yJDq22YS/Ufn5kh
oLevPbWkkL7lX0n3hXA=
         "]]},
       Annotation[#, "Charting`Private`Tag$17177#4"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], Thickness[Large], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV13s4FdsbB3DpdpIthUpnhxxRSClJ6vhKbjluRSr3hMopnBS6klTutyhH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         "]]},
       Annotation[#, "Charting`Private`Tag$17177#5"]& ], 
      TagBox[
       {RGBColor[0, 1, 0], Thickness[Large], Opacity[1.], 
        Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwd13k8lOsXAHAqe/YWZLlEjYislegoFKIkSTIlItmTvRRREknlauxLsqdS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         "]]},
       Annotation[#, "Charting`Private`Tag$17177#6"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(fwhm\\), \\(G\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(\[Beta]\\), \\(G\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(fwhm\\), \\(L\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(\[Beta]\\), \\(L\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(fwhm\\), \\(V\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(\[Beta]\\), \\(V\\)]\\)\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Large], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Large], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}, {
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Thickness[Large], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Thickness[Large], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    Thickness[Large], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}], ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& )], 
     Scaled[{0.65, 0.86}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0.030000019795918365`, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"FWHM (\[Degree]2\[Theta])\"", TraditionalForm], None}, {
      FormBox["\"FWHM(G) (\[Degree]2\[Theta])\"", TraditionalForm], None}},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxFxWswEwAcAHC5uLNuHteJsuxyRHKqc+cucpNMElIt7yGaRyfckSk3TXSE
c1s57bTmkTOvViSVdiOvkFoeeVyL2dDMREqRQ/Wh///D7377IhPPMbS1tLR8
/vo3ncWnnH8hoPzf0dxAdUa3FDZszeR40/BOrZgp6hJu3M47Tioqg9OpUUr9
/nLY03t1/w/nSlgRZCGSmNXAF07rrAlGGmC3MGbVy65mOK2TfYnIfwWL99aa
111pg9lDg4YseTtcw43g9OZ0wcy1o7xGix44L2TQqpfTB2t3S12DHd7BEtuC
KdMaKcwheek46Q3A34VsuWXgIHztSXFGFWcIPuISHsVQDsNigU/B8qEROI5l
lrYrehT2lN+vZTaPwV5t66WJS+NwhqW+rNL9E3yL7hFafUcGi3aGlbr1fYb1
fG0O7CFNwh3ac06dB+XwfI9fVmQ3bjdglEhOmII377mJhQQFrC7rr/dtwilF
ca2yYCVs5ZHq4PgTt3SSeYkE03CTpqHjm/MMLLpdEkYawV/HyvgM1izM0C08
dn33F9hilnfjUTuelL3Tsj5CBdsQy9XcdXxtNIdW/HAODrk4QY52VcMjdoWF
NDXeovAj23Ln4cMBWUZv7TRwK9FAmPcRn7xJEBgnL8CxCtPnOcSvMCGbnWz6
DHeZDuCmnF2E27apJPY03J2cplH5417BvJP0UNz/w9gGNQZPEgddNmHhlUUh
J1qqcevG+aSUOrxWmi6wF+ENBP5axVNcwpY9zpfgY/F0En0YD8lbOGUyik8I
WcyBcXxG8WCQOokvB07k2qvxq6kJzSoNvnp3U1mxiG++N6eYrOCZGlH8wC98
O4FSkv8bz7WWvqFu4Duo4StbW/gfw3R/ew==
           "]]}, "Charting`Private`Tag$17177#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Thickness[Large], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwV0Hk4lAkAx3ERW0pSK5RGMUVl1W7ylKOfWtMhpM19FgmtjZ4Othq5NhXJ
ND0lZs0kN40QqWYpoYucOTIMM4YxM3rfUdkkbPvH9/n8/10dEP5bkLKSkpLj
9/7Xl87CwapMSCZM9+V7cmBB0ZTsV2MjiudqvD6eg8U1sakOLmzMi4tWKS7m
oE4peJBGsrFOo+VJySwH2rVpO/RvcBBqdNL0Yc4dnKMFihY13sHo/kcaDYos
7HH4svaTVTak+bQW0eUcCD0NudUrCiD38nM1eFwI132qk5mdpSCZfmfmTpdh
p19k7qP6SvzEMHmfbFOFqLqYIxqsJ6jpSQqqCPwHvJWFlKI/nuKIrDbjzfln
iGlvW0wfqIX9liZnNd06FDAOpb5KrEdYj2HBSlkDIie3pZUZvsQ2I5q2aukr
XPFuW/Mq9TVCqk45WuxuhHJDs63X5ia05xEmdtrNqF6fPKhb0AxnhZWkqacF
qfr2qpbzW5F8eLj+sGEbPubFDFA92iCOtvgsutiOP+/fjM5NbQe546p6UnsH
frbxDwwSdUCv7PKJVdad4GU6Jo9v7ITO6TDhyswuhNJXRC072oWGPtdttpJu
7BnIKIys7Abz49Cgs9N72D+dYoeTPdAqORtxkdWLaOoifrZdL+7pVDoXqvXh
L99dPvnX+aC0d1laHOsHd6kfe+frPtiaKy0YqRBgvpPJuuX6AtiuDl72PGUA
z5VHLes2DGDruQPLcywGIXvpHB/QMICMGTMjq95BmLZqhRscH8RVD4HLy6tC
zNzayctTF8JdlTkZbC6ClNNY7PRAiNJLei9mJCLgRmgN30uE01uYt/emD2HN
rjObLSZEWLJlsSAXYlAt+fbczCHYLDjkODUuxgN56XOFlRg7zMvNAtKHwb2c
7qffKcb9i5M/0reP4FkInxVEH8a9kiXUa+QIgtRSrM/qjSBhw8bc8psSGA6n
XbhXOwIJnXKg2X4UEQlLqcWHJFhrpBU+PT4KE407UsaUBG8VEwzBLSkmuxJd
bt4dhdqtkr4qexm8D/cbHLWVQvva76xshQydpikpLlIpHvh+jU/MleOx0Nlg
PUMGnuv5CIrHGDa5x2u9MZWDzZnT8mJ6DDUamnlX3smhWevpEVL6AYI49Uzt
k2PwtKg4uMKTQIhQ92Gixgcs7FBxiZsmoJ4Qc1K34gOMs69vJ91J2Ay5M04d
IFDxQ06ySRGJp3Mk1WYuBGJ7s6isYhJ2BlFyiRsBxxIOT5NLwt4rbbevD4Fh
N5Z84j4Jt5buaVowgWW5TIf6ShIRPM9jOnQCUXZxCwNqSWTf8P71cT4B61j/
5IweEsZlsohTRQTmu/pSNXtJFDafyzTjEnhn4s2L45MoVWdNZpUTON7iJg8V
kKiO4ZckVRNgGzg5bBWT6A7z1fftIDCn2nrhO5KE95WxvTpdBJoYltl7xkn0
59EjW3sI3A7aas37SEIs/LuNJiDwi4Z52N0JEuMe/ZfMpAQCfTY0nvhG4vSZ
45USOYGNm9YdEU+T+MKcEWURBKZUjL95zJKYeUuBzmcCzCJDU1tlBWLl3LDW
fwn4X1hVV66iwFx1pCd9JWB6kOJjrKrAJePmF7Tvn7+s1f+UrqbAApr/59lZ
AnVf9ZIXzVPgP1i1dpo=
           "]]}, "Charting`Private`Tag$17177#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwVzH881HcAx/FLkRQy6awuykTsZvVoa00/3pgfJZXNr6KTNFQrP4YYj7NT
StHMFaWyUzInP66U3ajb+e0I8aX8yOXOnR/nHFeiUtG+/fF5fB7Px+vzea8J
DPspSINCoewmz6ebwcyGRzkHRrT5wdt01Nhkoq/Yq5UDveRKVutCNZZWJqa7
eeZAezL+OkNTjTpKyIDTixy8E021MylqGNVk2dMybkASObxF+HoC8U6H5Xot
N1HQ3GQA+QR2uL21mNqSh63x6f/ZCSYg22/GE668jcBnq4wcQyfgtUtzhtNV
ikxvyWp6/Tgc/GPyK+r52LxsQ/MOy3HE1rF+1s1+iIiRMI+ECyoIVhWaFJ2o
AjvWa3Pm4BhYnR1LmdIarN7V/FDqMobb7ID0puR6XO4bua7LUSJm5vuse2aN
yE18ud/jzShS/DrWNqU/gsnRVH6r3yg0GtrsfDe2gqXXEmZ1XwGh9YUB49tt
cJ/OFlUYKZBOc9W0XUSg/KXvbGD8CF5xWVLzfR3QKq78c7xzGL/dvZyQn96J
Om5ZVfF3w9iw7eDhIPkTHDnkvmd32hAEnN0XJr/uQu763gotxSCOMlfGLg/u
hpv9ZO2U2yB2SK8XxvB7INa/Z12XJ4dr1fucsBe96DPVWN+4UI4Ecz1xnmMf
qsffsksYMpxhOB8ouCjGdkJMFPEHwDP0z3F49BxWr93v9q8YwKI966xW0CT4
0PPL2GSEFLUao7Z1X0oR9+6rlJgCCcYa3U8HNkhhHeo/YxvZDzphEGYaOoAC
hnhN9RfPMXfFQcDVkWFBe1zyXWUflDdaiveUyUAXBucHXnkGZBytFPvKcaqb
nujs2ou1zic3bnotBz/S8Oolwx6Y24pdeZxBlKe6HLtV04UyVWntyy1DyLLI
jqWdewre+Wv+tK4h5KkeOYg8nqD6iDg7iDmMBBuXhm80OxGklbY17vMRbHol
P7u4lYDZcNbvJTUjEGx8TPk7rh3hSYbmxQEK2E2Uhu1lPsY63ZtK9nsFAprj
vcoNWjDTnex5+dYoaDekJfkRTfA71G8abKdERtxZVshcA7roaWmeSiUK3ET1
Jd51eCBzN7Vmj8E4WnDK52E11vucNmimq8ByHorkXhWiUlefm/JUBe2LyaJC
jwpITulwjCLHoT1apO8RUoYjMuN/k3UnwOqNSEuyvAOdJFak8T8TCKh8I4rl
5WHboA876kc1AmLnPz1BZKJqnkJo46kGpfGj2bq4TDiaxqoU3mqwqB/CZWaZ
cPXNcmEcUKOKP7XEJyoD3u09s04hathNDznaUS8hXLD/GJVJ/v+1sewzRjry
Mvx+eFBAunuFVRhxBpb3xsKjisj3Jw3r5WZnUNgWz7HhkftGSw7ti0pCqU72
TO59ct9jNsueehpClvhOqpDs7RLtZQwWeo4zaIwn5F7GTiKCiIZfyvhOajfZ
O2wX+UVFoZ/LjCF6yW5At3ekRmJI9leHk4Tsf+iVLmeEY3Jf/zkbJdn1uGti
iCBEnwzlK1SkU8+zd1IP4+2lOXmumrT28Xk0RgDmHpuAOk16QWBNIuGFRBXv
OPGG9JxFrgXDHQt0cC31HekX3fOvEE44Z9kmcpolXVV7tpr4FoudDk5//Eia
QlFG23tt/x//QWvB
           "]]}, "Charting`Private`Tag$17177#3"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Thickness[Large], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwVxX040wkAB3C5OCkvpdLVjrvRm9xUejzPpfqWWnUuslLyPgnVKSQvvaxG
OiPVXG8qZqvOW+W8LFwkbynSLXRezthsbDOzn7zMRLm7Pz7P5/vDYfuCdHV0
dFz+8/++jHTsL+Pgk+MCmoauhYOFiWKvfiZ+V4TuneevhenLOPYe90zsu/Xa
heyrRZ1OSC91OBO56vPOrp5aLKpJ20a6yYUnT749i6bFOWqg1LiJhzL9Fw4H
nbTYvUe7YszxEaKbQ0glVlpIPMn5lctyMRL8Qh4lm8CBn/UmOW2FuJWwkpsd
MAEnv5isP1+VoN28zCurX4PYOuYRo/RymIzzmsxCNaj4Ns/i8YkqjNY50+0V
42C2tpgyxDWIMlyqsTwxjtxUOrsh8RUeOuU8rZSPIWbyx7Qi8hu8rrtOajoy
hmTvluUN7EYkV2RczVKOQrdesNXL/h20Wce/sw8eRaVNSu+SXAF0v/Z7lqIc
AZvkrLdxTjP0CvNmHYgYwWg2U2x9qAXFLiVhgqGPOFNw+0IWuxUz/grR4siP
WLfZPzBI+gGaI50RpuphVHBcUkbs2tBXbFUe+8swjjGWxS4ObodkeJWRj5TA
bvH9vJiSDtD8WXKbLjWcq6Yyw4Y78alsQ/2NviFcsDYWPtrRhekJPwW9U4XL
vjt9cn4TYqjR8czc1kHkm/llOjV2wzwpyNitR4k5rqtWLyWJcN/WSK79MIBa
3YGNdWvEOFQ+q86xW4HBN26XDteLMbsnx8RHKYdt8/wwy5O9MJC944glMny5
41SRbSjBrk6sn1H1Q8lteuLKl0BYaDcnXtIH3Dz2UuglBd2ixVUilGL5zmh7
B40UltHVaUKFBNYbhc75nD44FFNWOIp7wVcV1n507AerS1FqPyBGftI9P1Jb
P67bPQ43U4tQfVSYHsSQofIUU5so7kaQ/rVNZ7+RIzCFYK3VdIEsS7v4tEaO
knAvLk/SifAEM+sndAWYa/yrdo60Y5URT5k6pcAK44YXWXPbMNme6H774QDO
llOcBFOt8A7osQzeqgQVFMEakxa02V675q5U4sKy/fW8EQGeS9wsbVIHYWew
MDfgn7dY63Fp/ltbFep5BhlJBm/w0sgkO/lvFSrej3Gc+mohijfkLIocQsaT
hUWB+lU4KllSmmikRmzB55mxmDIYJjAjlzxT49T66tIdWwqwuc8j9TSNQDKp
w6qBzEPVLEUlxZ1Azeqor7b0cLHDMlalOEhA7LBAWnSXC2evtF2+PgTcaHse
pJtycfB9x2dqCAG/eXHbxNMZCK/wPG7OIBAjojlS+Hfx6Kb39uc5BLIvj1Ia
yalYWTQYfvoxAXPuD+riu2zkCc5xKPkEfn0e8jTDlI1Cw/TJB8UEQnpKPSTT
V1HJFP5xpZLAxUIWbS0/CR2hviTfDwQKPGyoTeQ4eCcP/WTeTuB6Cqc205SJ
nmxGTHMnge745QmyaQb6JRktVBEB9gENYwP/DEYO9bAoSgLVU3ci3pMjEBV9
skShIjDTqNOtnj4B7Y0v0gcEgfOc5rZN/GP48pcFzMcJRFMjGzvIAYhT5Yc2
TxCQrWOxXPiemG2Ie1c+ERB1rD4/QKaBtVLwmvqZwPHJ2yJDq22YS/Ufn5kh
oLevPbWkkL7lX0n3hXA=
           "]]}, "Charting`Private`Tag$17177#4"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwV13s4FdsbB3DpdpIthUpnhxxRSClJ6vhKbjluRSr3hMopnBS6klTutyhH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           "]]}, "Charting`Private`Tag$17177#5"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0], 
           Thickness[Large], 
           Dashing[{Small, Small}]], 
          Line[CompressedData["
1:eJwd13k8lOsXAHAqe/YWZLlEjYislegoFKIkSTIlItmTvRRREknlauxLsqdS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           "]]}, "Charting`Private`Tag$17177#6"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0.030000019795918365`, 0}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, 
      AxesOrigin -> {0.030000019795918365`, 0}, AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"FWHM (\[Degree]2\[Theta])", None}, {
        "FWHM(G) (\[Degree]2\[Theta])", None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 600, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1], 
         Thickness[Large], 
         Dashing[{Small, Small}]], 
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0], 
         Thickness[Large], 
         Dashing[{Small, Small}]], 
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 1, 0], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 1, 0], 
         Thickness[Large], 
         Dashing[{Small, Small}]]}, {
       "\!\(\*SubscriptBox[\(fwhm\), \(G\)]\)", 
        "\!\(\*SubscriptBox[\(\[Beta]\), \(G\)]\)", 
        "\!\(\*SubscriptBox[\(fwhm\), \(L\)]\)", 
        "\!\(\*SubscriptBox[\(\[Beta]\), \(L\)]\)", 
        "\!\(\*SubscriptBox[\(fwhm\), \(V\)]\)", 
        "\!\(\*SubscriptBox[\(\[Beta]\), \(V\)]\)"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Row"]], {0.65, 
     0.86}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8279144436642976`*^9, 3.827914581426877*^9, 3.8279155211601996`*^9, 
   3.827915559323325*^9, 3.8279167119731293`*^9, 3.8279168957775764`*^9, 
   3.8279760121200047`*^9, 3.827976330331236*^9, {3.8280891081001196`*^9, 
   3.828089122934325*^9}, 3.8280891991542892`*^9, 3.8280892728891335`*^9, 
   3.828091192449332*^9, 3.8280918159576697`*^9, 3.8280928626664352`*^9, 
   3.828092917070636*^9, 3.8281057745897493`*^9, 3.8281060437875*^9, 
   3.8281061557195563`*^9, 3.828155390378065*^9, 3.828156024659914*^9, 
   3.828160051614202*^9, 3.8281611957048864`*^9, {3.828161303961438*^9, 
   3.828161327355965*^9}, 3.828161461876127*^9, 3.828161656010704*^9, 
   3.8281625841670666`*^9, 3.828170845708002*^9, 3.8281710349212437`*^9, {
   3.8281710685277843`*^9, 3.8281710850773907`*^9}, 3.82817127116792*^9, {
   3.828171786042183*^9, 3.828171816140026*^9}, 3.8281737286729383`*^9, 
   3.828502156740059*^9, 3.8285034851481805`*^9, 3.8285794524289827`*^9, 
   3.8285811406421633`*^9, 3.82858305721989*^9, 3.828584246208951*^9, 
   3.8285916753445196`*^9, 3.8285920950591965`*^9, 3.828593122119582*^9, 
   3.828593436098198*^9, 3.8285939805128565`*^9, 3.8298003623299217`*^9, 
   3.8298004941491375`*^9, 3.8298077164636927`*^9, 3.829809191491026*^9, 
   3.829965139164755*^9, 3.8305859210795345`*^9, 3.830586010778352*^9, {
   3.830587710651409*^9, 3.830587738402725*^9}, 3.8305919257133636`*^9, 
   3.8305948043535323`*^9, 3.8305950155023565`*^9, 3.831616466965293*^9, 
   3.8321437380656357`*^9, 3.832144956472285*^9, 3.832145068216915*^9, 
   3.832145177601495*^9, 3.8510481420112047`*^9, 3.8510501752189894`*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"6a13c6c7-8047-4c96-943d-c2329e98dff8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Gauss2", "[", 
      RowBox[{"0.25", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"Gauss2", "[", 
      RowBox[{"0.50", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"Gauss2", "[", 
      RowBox[{"0.75", ",", "0", ",", "x"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2."}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", 
      "\"\<normalized intensity (area)\>\"", ",", 
      "\"\<normalized Gaussians\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Sigma] = 0.25\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Sigma] = 0.50\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Sigma] = 0.75\[Degree]2\[Theta]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FTGauss", "[", 
      RowBox[{"x", ",", "0.25"}], "]"}], ",", 
     RowBox[{"FTGauss", "[", 
      RowBox[{"x", ",", "0.50"}], "]"}], ",", 
     RowBox[{"FTGauss", "[", 
      RowBox[{"x", ",", "0.75"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2."}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<s (\!\(\*SuperscriptBox[\(\[Degree]2\[Theta]\), \(-1\)]\))\>\"", 
      ",", "\"\<normalized intensity (height)\>\"", ",", 
      "\"\<normalized FT of Gaussians\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Sigma] = 0.25\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Sigma] = 0.50\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Sigma] = 0.75\[Degree]2\[Theta]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8279143092446375`*^9, 3.8279143756417203`*^9}, {
  3.827914433899171*^9, 3.8279144602572985`*^9}, {3.8279145117199497`*^9, 
  3.827914531569857*^9}, {3.827914656300206*^9, 3.8279146627218275`*^9}, {
  3.827914809449203*^9, 3.827914865065548*^9}, {3.8279152944118433`*^9, 
  3.8279153296148853`*^9}, {3.827915568906023*^9, 3.8279156601582775`*^9}, {
  3.8279157622316637`*^9, 3.8279157626705704`*^9}, {3.8279166726873817`*^9, 
  3.827916683477203*^9}, {3.8279169136822186`*^9, 3.827916943328743*^9}, {
  3.827976265141958*^9, 3.827976289955205*^9}, {3.8285915645702906`*^9, 
  3.828591569584589*^9}, {3.8285916138975716`*^9, 3.8285916151040344`*^9}, {
  3.828591690537289*^9, 3.828591720904499*^9}, {3.8321439067683544`*^9, 
  3.832143918206354*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"8a18c437-cd75-4162-9af3-fd9aa160877e"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3c81t8Xp0USUqFvioQkSfb6fA6SkYyEjOyRloyMSjYpEspIMiMjW0hy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         "]]},
       Annotation[#, "Charting`Private`Tag$17820#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1mnk0VV/Yx00hCimlfkJCkYpCGR8kY4TMM2WIQmUIZQoZEhGZM2We5ykb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         "]]},
       Annotation[#, "Charting`Private`Tag$17820#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw12Gk0lV3YB3BDksxFHmWKKGOReBBXGoRCyPCUIQ3IlGRW5opS5giZM2WO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         "]]},
       Annotation[#, "Charting`Private`Tag$17820#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"\[Sigma] = 0.25\[Degree]2\[Theta]\"", 
       "\"\[Sigma] = 0.50\[Degree]2\[Theta]\"", 
       "\"\[Sigma] = 0.75\[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.8, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity (area)\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"normalized Gaussians\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwUV3c81t8Xp0USUqFvioQkSfb6fA6SkYyEjOyRloyMSjYpEspIMiMjW0hy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           "]]}, "Charting`Private`Tag$17820#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1mnk0VV/Yx00hCimlfkJCkYpCGR8kY4TMM2WIQmUIZQoZEhGZM2We5ykb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           "]]}, "Charting`Private`Tag$17820#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw12Gk0lV3YB3BDksxFHmWKKGOReBBXGoRCyPCUIQ3IlGRW5opS5giZM2WO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           "]]}, "Charting`Private`Tag$17820#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity (area)", None}, {
        "2\[Theta] (\[Degree])", "normalized Gaussians"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 600, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "\[Sigma] = 0.25\[Degree]2\[Theta]", 
        "\[Sigma] = 0.50\[Degree]2\[Theta]", 
        "\[Sigma] = 0.75\[Degree]2\[Theta]"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.8, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.827914355752*^9, 3.827914405312143*^9}, {
   3.8279144353834257`*^9, 3.827914461225953*^9}, 3.82791453380414*^9, {
   3.827914853706668*^9, 3.8279148659248333`*^9}, {3.827915316733615*^9, 
   3.827915330834592*^9}, 3.8279155213763576`*^9, {3.8279155595551386`*^9, 
   3.827915599121584*^9}, {3.8279156414799986`*^9, 3.827915661531643*^9}, 
   3.8279167121892786`*^9, {3.8279168959781213`*^9, 3.827916943999691*^9}, 
   3.827976012338887*^9, 3.8279763305187335`*^9, {3.8280891083119936`*^9, 
   3.8280891231551933`*^9}, 3.828089199433967*^9, 3.8280892731060047`*^9, 
   3.8280911926782093`*^9, 3.828091816184533*^9, 3.8280928628553452`*^9, 
   3.8280929172585335`*^9, 3.8281057747746487`*^9, 3.828106043979413*^9, 
   3.8281061559134502`*^9, 3.828155390603956*^9, 3.8281560248468137`*^9, 
   3.828160051878046*^9, 3.828161195902402*^9, {3.8281613041663404`*^9, 
   3.82816132755086*^9}, 3.828161462075032*^9, 3.8281616562345843`*^9, 
   3.8281625844039373`*^9, 3.828170845914889*^9, 3.8281710351055923`*^9, {
   3.828171068751646*^9, 3.8281710852613015`*^9}, 3.8281712713498344`*^9, {
   3.828171786226082*^9, 3.82817181632491*^9}, 3.8281737288578367`*^9, 
   3.8285021569489493`*^9, 3.8285034854260454`*^9, 3.828579452659851*^9, 
   3.828581140838068*^9, 3.828583057431798*^9, 3.8285842464033737`*^9, 
   3.8285915786566625`*^9, 3.82859161600954*^9, {3.828591675515428*^9, 
   3.828591722049876*^9}, 3.8285920952361007`*^9, 3.8285931222945013`*^9, 
   3.8285934362641215`*^9, 3.8285939806777525`*^9, 3.82980036249922*^9, 
   3.8298004942869635`*^9, 3.829807716610837*^9, 3.8298091916446743`*^9, 
   3.8299651393368187`*^9, 3.830585921263832*^9, 3.830586010935996*^9, {
   3.8305877108868856`*^9, 3.8305877385448484`*^9}, 3.8305919258539553`*^9, 
   3.8305948044941254`*^9, 3.830595015642914*^9, 3.8316164671215525`*^9, 
   3.8321437382505507`*^9, {3.8321439094148207`*^9, 3.83214391903115*^9}, 
   3.8321449566259317`*^9, 3.832145068354932*^9, 3.832145177770802*^9, 
   3.8510481421674476`*^9, 3.8510501753439846`*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"1d2d4eba-86f7-491f-82d3-0489c251a9f6"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw12Xc01X/8B3BR2SNFUWREGWWTwgtJEkIlKaRCRZKvNO2RGVG2CNkzZHvb
K3sms4xk3I/t3uu693d/5/x+f33O43zO+Zz35/1+vt7jvAXvPTW2pqWhoYnZ
Q0Pzv88zwL1AoVDQw4usWqrPXeEpQdifQKQguQbOlL0prlBQJCO6vklB6mvd
M8y9riB7Sv/e3CIFSWaVXhg97QZKB3x+dQxTEN8ZwqzvghuoT6+2x+RTkAid
U8HJsx5g/K4zW86Sgs6kK5SuD3tChMbo5dNmFCT162uB0LonDOzM/xW9QUH/
ncrJc2HzAhPHvSd4r1AQY0XRg/cXveD2rfPxNEoUZKwT7+JZ4gUPJDKDO9ko
aC4qMjE+3htedPs8sa0hI/p56Sd//H0heNFleKOMjA614hxrsn0hmf6RhlcR
Gb2ZTfra0eULHaDPlZBBRopNDyI9uPxAqICrui+cjF5aHTfS/+oHXWFpLGq2
ZGRHk4IKut6BqHFr9iEOMmLPNUmx1A0EFYcKrmQmMirxf3ed9F8gGAXmuEvt
IyODmYSL/QmB8LY+7JoucRe1eMvgpdcCoU/21o77zC5i2HETKEoIAteDC7qL
ZbvI171Lm50mBAYGmBfqrHaRXbQLC89GKHg+KKnJvrOLrs2P1vIfCIMzGxYR
n27uIvrvE1oGp8LA/+A3lUf6u8hH50fKvpthoGpsGsqhvIvkBc35RkrCIK07
Vd6SYxexfDx2+cyrD/CyXdWdVENCob1OFo6HI0DE7O+1uXIS0jvVO/5QNgL6
/oWd6ikmoWMz02le+hEgyTjTm5JFQhuV5Dhenwj4fSnwxJVIEvro2YYm1yJA
t2moLeYJCYX0C6aODX0Evtqnh5SOkdB3NkXuiPJI6OBUcD53mIQO2+lq3PoZ
Ca+tif2qnCR0Kakz6sJ2JAwx+UZoMZBQ9LX3V30VoiDsRiyn8cYO0nh2PbO2
KAroFhs5nnTsIHD+p6FQGg3/uHhZU97uICGvUox5NBaiH07ap73YQdN8fzjj
yLGgXZnakem0gyxKH7YbC8VB8l2p4IKHO4ghsNRf5XEc3MnWYq65voPkXGou
7u7EQbf6U8YRyR2k2CnGe/1kApTYNe5jHyei+AGGGvPPiXBWwEEmbZiI6PjF
7OvaE6Fi4LC5ah8RLX4tsTXbToRaVbtiuxYi0k7P9Ys8lQTt7Jz3WwuJqIWJ
QTPXOwmmiixrPf2ISJhovEMDX4CJRHy9IUVEB31VFdbbkyGkIDUtSJyIejid
m7JmkoHD2qBPSISI+j8GSniQk4Gr64uYES8RtXvy//GRTQGBJJ2fuXuJiKHh
0098XAooaEUq2I4QEDrxmTHZORXuBsusjHgRkPre2mfFqmnwujjcr9OVgAbc
DxVY3EqDT2Prx+peEtB9Sd9+kedp0C75/XKGAwGZihQIMeemgVznuRQXMwIK
rDlrLM+fDvvZtEwOyhLQXvKBwEP7MyAn1KRK7zceXbTyEM5ayoTm0lJj9TE8
CnlmFHCMJQt+Tx75JzeMR8TuhLQ8iSzglh7lOtqJR1dJ6vdl7bLAvcfy6b8y
PMr2bbapWMwC4wOPhPzC8KgZ/iueWssGfPgbfwR4VM41yn6KNw/+Hqtb0D6H
Rz9UCq5WqOfBUNp+/S55PLpzXF3xuW0eFFV8ODAuhkfrIQIO1iV54PAnPZZ4
EI9U/S1bZK/lw7TMQI7C/DaqPykTon+lALp6JHuzw7bRYo65ZPnnQqgyc5KT
C9pGxed13TKLCyF7pvRThe82YipkoeS3F4I/XtOs7fU2YuN1a6VsFcIFgVvT
cw+2UZpMB2+O4Tcoe+q7Kai8jcJKJUu1GIoghW2CJ/r3FkpP9Ncb9y+G8NtA
rzy2hS4/+Mek8qUYvDKSNkaGttCU18xqYXkx3NO83320YwuJrq46Ti8Ug5DL
vE/i9y2kN1ZcYmFQAsnja1ha0Ba68UvNqp7nOyTl0DeXKGwh+wDNooT6UojX
lXHqD9hEXGqf+cIsK+EEs257j88mui+ga3TobSVk/7gn1OW+iRr0M4Pzoyuh
Qu9jX+vzTTRkM6Up0VcJIwbbsjVWm0ij2qb5rHYVcF+rXs9Q3kTBjPsnimWr
IfT25edu/zaQ21yUz3M+BF72Vi/FLm8gbmGNpxyf62DivUV8xYUNFJak0NJV
UAfnCm/XXlHbQAmutrTxDXWwtnmDwUFuA6lkzSje/1cHVu660d/4NlBJkqHI
V4V6UA+XKzu/to56Knxsd3rqgVy6D68ft45Y6Xjuch5shDd0WS+cltfQAY8k
+sGmZrDy6D4xlLGKzrGInbJ/3QGfqmej4x+vIIlOVpUSl16omDzFkiOEQ49O
F6QvPRkEYQ51zeufF1G90UFs490IfBP3f/xneh5Zv35epHZzAiabCgUUFedQ
BZ+SjWDmb5iV/CSLvk+jgcr9NccZZ+CAW6bimT2/UWbVe0whcg4kFTHJr+tj
KI3D5Z3K2Dx4ay33lL8cRutSk44uRxehXmfpqvz9YYSpN4UUCS8Cjf5iV57+
MMLjZiIXJRbh7Y1/HSlCw0hj3OiGnsoiuNjMtoZ0DKFmo5Xh7juL8NB/vNZK
YAjtUWX+OhK/CHodnQWMrQNojvusc9eRJQjs6ZDy+TaALkm+szcXWILWgR95
5PgBVP1BK3zu5BJcHG/LWX82gOr/7Rj8VVwCNVxTxvjRAdTrUrL05foSSHPU
JBU+7UfhD9zQ1vsl4LqeF3brcB+Kvq1StE1egm+iQRUX6frQPK8cq/6+ZTAk
2M7IYL3ovmlFZTzzMgR+FjzL1NKLMpZ190kcWQby/MfJCpdetNk43kcrswxz
rm/OHBvqQez3pr7GWS2Dw9UP0dVi3cioY8zgRs0yZGzoLn3a042u7lc5udyw
DH9i9qo7jHQhezPJXre2ZTCZefGXP6AL7TUwCgwdWAZ4ZaHoMd+JFtteitos
LANHisSAZnoHMh80Kp85hINvW03srSfaUbyj0TdWaxy8z0quVyO0oY6zsqHw
GAd2Fu7PSzrbkOHY9cRHT3FwovnsaLJLG+L209dJe4WDyE/Zaa6trejv0Jh2
XQgOXst/UJWzb0GOrZOmr4txYDL/ZCVTvQUdMLrgcrocB3LxuikCXC1o5Z6V
789qHCzR7WVkq2lGmVpaj7hbcGDR7zIwz96MiDq6Y9IjONB0umP3uagRnTEI
EhvfwQG/qDI/l38jUuT6kcBKg8HOCFdv0J1GhD8S1KqwF4NijW7FV/saUcnP
L3JPWDAQPaBJe/1mA7ryVJnm5TEMmApOxjDu1KGe1pgA4jkMvo7OhvzzqUFw
SvBlwjMMfr3lTkyQq0Hpa61JAc4YsPFfKjD6U434N96dc3iBgcvdjL5yqEYi
xc1lAq4YaM8+PhxIrETmXUNfxf0xmMdhSeKO5Uj6SItHTzwGx8IEvk3wlyOT
wexmzUQMDGWMGsI7y1CYCadF7hcMyv77NksUL0NvYzRe26VhEIB3Fv8x+x0F
CzooBeVjIE5LLLK7XYxeaGYY3azFwCJFvOk4UzHi0lWa1a/HIFzr9lB/WRGq
j9EtUGnEgOhXhT/PXYSI+Rf/0rZi8IPZXZWltxBxnm0slOnGgCY336DWvRCx
U7x//evBQN5gytL5TCFqiF2Siu3DID5Mw2ssqACN0Jfdnh7E4Kc4w/tbIXlI
Gr36dHgMA/UnjwrqFnKRRW/Mng/jGGTkt/eJ6eSi4/X4MNpJDF7Jhxwm0uag
R/GSXF2/MeBV4/wS+zITTSg0Ru7/i4GXx38NtEMZSCSQiUZjHoPF+oHZx3IZ
iFUq1ue/fxhUXYoSP49LQ8O1jGO1ixiYGx0rHr2fioRmk3JIGAZL65vKzxtT
ULOe8e7aCgZvI7sRm0gKOs2YUfh7ldr+Ua8fGnNfUNj3GM2MdQwk3e4YjWp/
QZqTGJ/HBgaVAorDzulJKL3Twsxwk5qXH31NV3s/o9OWShsjWxgMcPj1eoUn
oKVhP8OIbQzWbyiPl1yLR8v1FcwX8RjITiVuHB2KQQM5w/EfCBgYiVyjuRoV
ja7L9z2TJGLg+Hg/i5dpFHqgPpCCqM7fsBee//UReQkZ8HXvYNClLCB1ND4C
rV2ke3CFhAHOrf+cgXk4Sg44t7+WatZGP21P/g/I+2IS3eldDEw5nVMfolB0
S2/udjjVUfG/Krs0QtCRpQa2FaqHRDX65RsDkRpu86g2GYNDhekLsdr+6Hi0
mvdHqq+dZ6Pd0+aL5LOttUapDm9y5rG94o3MrM9a8lIw6Lk6Kt3Z6YHYPAP6
jajmL/YOs0l6izIVZL54Uh3Xaohkv75AgUqsrZlUHxnnw5EznRCU0ei0Uy0x
PagcaW6Hcm02BKapFmVxjDpja4VEnw4Zb1DtMXBq4GiDPnJ/Ezu+S7Uk+/jj
faflQahIuY5C9dCqVyIH3hS4K7/tEqheuXpy7amTDeyUMEYsUf0mQrvdTt4R
WLR0PIepJru9ikuUeg4c3q6tFf/7/cc59v3ir0GHreZhJNV0JpOq9KLuYEIW
vveY6gaBgHcJHF4g8K+rWJFqn0ghR6X3PpD5e/ruDrU/tFmqTHuZ38HMixCb
MqrpvW5o2AUEgGfZTtMTqlu3cWL76IOhRPKB+1GqA5/4cyb6vAfCyJ6IOmr/
p62GuR7zDIMGDa49d6m2tRW3+U4Oh+mCimVf6njqCL0w81b9CBdO/LNnpfrU
eIOB4dtP4CXWfCmEmocFY3OlBUIU4Pfu4XSh5qWdNUui9GwMzB45STtJzVd2
69ZxnxexIKUcfFWdanu1MAb+zXgouTxFt0TNpz5hjLQg9xkszjXYKVJ9plhs
tdQpEfiVOmVfUfOM//h76RQ+CbrsX0/9pea/nOnNYP3zFBjbsW1/RK2XpNNc
/flCqcAeTdG7R60nP8P8nvjuVOALZBw1otbb9cjpHy5iaWC4xsnHvUwdH0G9
evHxDGjO3LomR63fYa05dDgwExT2/9WbmcOgxtajeq9SFlDEdW8Fz2IQlFtc
NhGWDX4h2wV1f6j5UObLD9fKg/1JL13rqPMJy53SHPfVPBAuuC4nMUqtNzej
LPvP+RCl6L0/eASDu3/qjYXfFsAJphtMckPU/zu1rb87WAi2dCP53NT5rK3I
UqswoBg+fWP7oYAwUGmSbDg5VQwO2VxMnNUYFAwRND4rloB7erX7bAUGkYQI
CJqm7gvPX+R2+o7BA2g9Z61aCss6vCJCuRhQ2qVleFbLYZ1v1H8yGgOnsd38
0EsVUEg3cUw6EoO55fYz+z9XwJHnRxleRmDQwWEtua5bCSFvbJeXQzCINYk5
2ZlaBf/6K+WdvDBQ+LOH39MUQf5RpZGJR9T2V9xclc5EkKYXbzluQ+2P8NzG
KQKCzuw114H7GDB/yVFI0q+FsLM6QTnmGJAMTccouFqwfBh6cq8RBuMF+WJI
ph5YJa8/vaaIQaKjRaNqaSOwCMu896auj/F3GPM+TTaCrp50Zcw2DqJ1iqOW
6ZsgmDegJ2MdB2ECTHYJpk1AyUxGhYs48OgpObBLaIL/pPfQPB3FgZU0q2WV
Sgv0t7gmxFDXa+GVSsK5+jZQVmn+0+iIg7edF3w2ltvgotywaJQdDoayfrDl
8bRDWXNZkJUNDgKtR4UFn7XDxIpJ28RtHKz8IurTC/wAeTXp0DfaOKhpUk7u
d+2Ae29vymry4sAsrlTXXrkbGn9xOJyoWobLKSOdBqZ9IMEgYX1tYQlWfPNs
mp70QULbi+fO00vU86o35bx3H9xYMhMJHVuC+dOnZcTy+uCCst6rwq4l8C/z
+Ei3tx+Yznzwz/pG3d91nrxdlt8PTxL46f97tQSX8M/nBekHgaUk57YPLXW/
p89Jt1kyDE64DbkFukUItRz2kC4dA60rSNB6ax5aDPhYDTl/g9S8aqSp3xws
C3K59cVOAz8bjeA34Rl47ixhFco9B5Ei6uIcLb9heIzD2KZ1Ho44X0i/GjAB
d1+p/KXXW4QLa2/EXA79ggYJpcCGfTgIOKg2tyduEEQZq+ZTdVbAYDFDUnKw
F/iq7C7u81+FesZGk6+8nUBDpM10+rMGdwffpaavN8Pd6ZF1979rwJ3N+D1i
ohlqOwrUQpbWwDkbexfS1gweiRYD6VtrYG0ddz8rsRkoWhWUMaZ1uDAVW+qv
1wzk0Gcml+TWQYWz+8tgRhOQRKbojvmsA5d6k32CXSNsG1VbNIlsAFtq8Kw8
Tz14jeSPq0lswP2ohTXyvnpgs0q+Uya9AXnsJxV+rtWBqOM7s+zzG9DrVHWh
rKMOrr83MvlgtAFBr+Twpz3roKB9Vt/cdQOkQjKPLS7VwqMLbKqbAxsgETuQ
xJyIYFTe8qiIzyYYLC3L/HWvBBuCArtvwCYMBNyO0reqhJVqFrrZ95vwbPCR
U5dmJey9VLGQGrMJ9KbaN4/vr4Qzt7gqTuRvAq+g8RtSSAV4uP4wPfFrE67m
8rDFJJeDaLNSpLD0FhhfnF2jmSwFx5scB4TGtiCLIf9xKvU8eS9DKlbk9xb0
nPKZmw4shhsEA2GxuS1IOfvLR8m5GM7FhShIr2xBXj9ph/dSMeybZDJT27sN
st2G0b3LRRBrsy/FTHIbxl8Epa6rFUHjc6J8xNtt2P37/EMlVgjfm3lqIj23
gYMg/vjRaCFkHla+FOu3DQbTMwSxlkJ4X/7i1pewbfjYkcsxTT1P39rdcM1P
3YY0rgejclcLAeeDNf/o2AZ6XNKfi0UFwPNxxnQvHx6WvjMrlx7Ih7Pex7md
hfAQufqYPXAhD0yczPqnT+LhtaKvv29DHoQb9ug3yOJBvvctbvN5HrCwVml6
6eAhWBtvVj6WC2TfCEkaZzxwjZN0CwtzqOugJg2pHQ/xeu1TsS+zgNbWtdqu
Bw/f7vFMXzbJAgGTstejg3g49opvkU8+C8zlz2xWTOEBd7A/Rn4lE4ZWeBZe
beHBMe2YMc/jTGh7tNq/LUgApsSHF9IfZEDe7aT09ZcEYB8elGZ3TgP5YWHi
fjcCvKsqBGHTNKg0Ttfj9SZA9xje87pKGrRezltVDyFAFzlIm21fGkwrVZ1/
/4UA1rwBt8aivsKRQz+7T7UTQIkHY+quTwWvDna8+VEiSF99Kvnf6RRg0InQ
fSZAhLchw860XCkQ2sCd4CNChPy0Y5I5pGSIr+DTzJYiQtbl1DCDjmQozZAI
xl8ggt662mCHfTIs+VwSiLAngvPiNZ/4b1/gpqq7Tms1EXyqD22uGybB2OYc
e309EWItnpRzqiTBvTyD4coWIpSQdG7rnEwC++P8Nvm9RDg+yT6A7SSC155q
78hZIjT3EE53mCZCXhOx5gHrDnyJpfwY5f0Mew1cFPaY70Dx1N0mfRQHgfsn
SEQr6vve8hl8bBywo4uNGzY70Nv5jaHTJQ54pbmuzTvugKX4mw7sTBxIcRY7
dvvsUPf15y4f/RILZkOr2Qk5O5Dxfdt7ITgGCi2eCJ0j7cDBbm69Z55RcK9k
hS9pDwlC3RKm9Cyj4BCLM89+ehJEmWf4XlONApfy1xx9B0gQ0SRw7TchEs4d
8ic/OkmCtbtOakTnSKhvS/4VY0wCbgvzlh2nTzAg/zOckEECQ8ZD/dwhEeAb
dPu9ZR4JblRxnaB1jADFPxMBTUUkkGzB6Ry8FgHRobMeH2pI4ME59iSNJwLM
F9YcxAZI8Kq/sjUoIxzmElmv3KKQ4JxGIEh3fgA80wW68hu7cOlG50SvdBhw
4tg+1pvtgnInzb5enjCQ6P11osNyF+pTnmFLtGFgEeWkPfloF4zGrOU3s0Kh
QTg5YJ/bLvC6zxwe2H4P71X2cBin7YKo5pNoSlwIiDigY4tbu8D/+/X6W5Yg
UDMKyt3Y2YXE/QRDldlAMJW/qUamIYO59wPeMzWBEEjEWR5gJoPDJ48jGY6B
sOLHn6J0nAxsdA8mseEAqEp0FfO5RAbB3RrWpHx/MO49r8gXTYbGF2tCh738
gOk8c11VAhmc6Ubkp+74QV3qryt3UsgQljzPMKXkB9IvX1nF5ZGBQUX7rxfO
F9iOlwbzNJFheP0Ij4GFL7TZy05zrZFBvuUXBV3yAXUGsTA2PQrwXbdm01P3
AvwzPG+eEQV4OPYIOwh6Qf5oy1f9mxQo77+Fq6H1Av58m8rgexSwr+orXWzy
BNKN1DmmVxRwOLHgb2fgCaUpx1Xp0ygQncjs3mPrAQ6sWEtaNgUuBGdI1V/x
ANEXNcbahRRgzZZcmpDygI+65g99qyhw9uBbPZlVd3BajY2g66dAoxR+hfWI
O4jffsyf8pMC1afv1X364wa/G5UzNScosBydLu6Y6waG0T9rPP9RwIxrgOOo
lhsw0GZcFsQocP/43aIFdjdAdi8Gajco8JDhwDnmMVdwGdS2vEukwCWXwbNv
M1zh/+5f4P/vX/4HMa9rxQ==
         "]]},
       Annotation[#, "Charting`Private`Tag$17903#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1m2k01V/Ux6UiKUmaEwkhf5mncjYiUoRQkbEkQzKFzLPMY5FkTqYMUYZw
CpVkVqbM83zN7r2G+3jWep5Xv/VZZ699zt6/s8/57hfnnPFTDRNqKiqqvt1U
VP/75Ydj0xQKBYf6ynyg3eBCT0nnX5DIFHw7krb9UvAFVFAkyLW8SsGN6zN1
dWe5kRC3ivH4DAVL+NZoJ6nxIPHDvj0NnRRcHrM7XWLoInL6Hen0o42Cg282
DEmH86Fyv6RjXxsp+NR17u6Hsv+hK+RyjaIaCjYO2n3G+SM/khlZrH+dT8F7
3xuwKo0JIK+3lMfR2RQc6LK0LqYqiKrvHKQNfUfBV8okriaXCSL5Bu6rnm8o
eK0ruPJMnBC6/sngy6MACr5WF/XS7JkICnr65J6hNwXbD4rydyyLoAYel/V7
bhR8feQR2+Vnokg18ZWwih0Fr5uLdQh7iSGNgMYcYQMK3pAI/NuPJVC07L/r
/+lQ8MRBTSLdXUn0Z2NygkuLgv8paj2pWZZE2tZ7OE7doGCLNs/7ImKXke69
ywlU4jvjzTPvnkxJo4Qj16XIghTM9Yo60zQZof5G7a5lPgpmzlS0SdUFZChn
yzzBTsGzrxLDE5/KoIcXs0IaGSi4+9d9t1kGOfRu7DPvTzoKFmf93dXuKofG
k2rrvu7Z8Xfla6bCnBwyYx7cU0zexl03BtV3d1xFVlvH3OLHt/FURWx0dJ0C
yi/hOB0ztI2dVAzh+c1raMFGqCy0dxt3mA9rmLZfQ7bjKquebdtY2C5ePXVa
ETk2+z4xrdrGRwbyzSJklFHIjEPnSuk2vm7B/pl3Vhml0prJehdt41z+VXba
hBuoAVSOvs3cxrQT6/2EfSqIveBoZVvUNtZxSOG5elANSTTQXjAM3cZy5ru9
Xz9TQyqTpIi5gG08MKVV6T2ohpzY+h/uc9vG6SRqKZUqddQUkXEAmW5jiQ72
nKg3t9FobpzDb6NtbPqG46DqKU1EqgsavHt/G4d/0yByJGgijl1Pi+3Ut7GA
WLiVTZYWcrYRv591eRsf1DOtK5y9gyJCeX6Iie3EN13naud/F73LOi1QK7CN
353XiFk5fw+1DFF2D3Bu45eFjtQR5jqIS6Muh5lxG7dX2q//4NZDV6zKj6bu
38Z3VByfnh7RQ+pBuR6X9m5jkir2XU7RR67VEbeVyVu4i+tIbeMxQ9QmdG/D
Y3QLL4v0+K9gIzSpesPk4MAW/qahKlkuYIy2zKWb47u3cGfNraPi6caIO+1c
2qemLUzbO2gVG/0AuR2ZVp4p3cLz76+7NL80QVGXeoudirZwUt+bfu6zj1Dm
jaazNHlbmO/y9tvvWY9Qm8/HJba0Lbz79ZvVY79NEfeKc7x26BaWWipm1pAw
R4jxyZ7RgC08cTPPe7PXHN3mM7Cy8d7CAr1HYiL9LJD7w6tyIY5b+G3OM52u
YUv05w/99DejLfzDmfqLe8tT5PXwU1XO/R37OrPLU/LWiH9FP/rlnS188yOn
cmKaNXpx5OMVM5Ut/PhgZ5O2qQ2S1rgbzii5hR0uPr2jRGeHpod2PSQLb2Eq
i23mSEc7FGeTIzHKv4UPkyuH5Cft0FLE9lAJxw5/jDFgb7VHGc3pIgaMW1ho
zIZftNoB3TZQpbtOv4UHw3r/aSo4IirCep8QzRZmOSqgoPbbEekw3Aig2dzE
5JqDYicGndAhlcXuDxObeN/+ih/5/C7IqV7aY7NqE5d/1yl4Le6JOHUmbo+X
beKwGiFPqhhP1DYVwd1SvIkDhtpGHi55Ij660da07E3s5xlHVPvkhYYUgzhu
vNrEMv1Lj2c1fVBYpzBJJHIT//Dud7Gv9kFXTPsaz4ZsYosBk11aQr7olb+A
45LXJh6aun5Z/aQfUv7e8ev1k01MoV7XSNkbgNY1PRN9Hm/i5kLmK9oBASh9
lMfuyYNNHNGqPN9I/wJRdrudkb23iS2NNNeBJRAVy51/Oim/ibVYn010PAhG
LF+fMouf2WGbA/T0ihGogUnUXur4JpY/ztM1nRSBnE3I7dJMmzjW7+7bJHIE
6tjvFy2/bxMzW3E8//ApEkVoxTNprGzgNiF1a/Or0QhlGthqETbwnRXLH1S5
0WiOzNF2d3oDi+gNFnw5FoOUk/MjDQY3cE8iR2X9UgzaPVPL+KRhAyfW4o+B
P16hj9JB1tY/N/AcT4yyh2wsMoy41WJXvYFdDucsrlbFogrRnnDn0g3s+ENv
Iu5bHHLwJDC8SN/AOm+fCXNMxKOpo6cOprluYKOKqrw3OAnFPR6wzHDcwIYH
NXJeiCSja1/SG7JsN7BUiPDIelAySjW8FFLweAOzX5M0PSqdgu7nyNNXaW7g
yMkmilxJKtq/TWfx7dYG5g9Q4nx1Kg2VqTXX1ypv4CEf3s9jHmno2Nq9oN8y
G3hDvO9Oilo6apZ5StfNt4Hvrnz1ek+fgdyjRcx6L2xgn2dvikgeGYhvnFQ3
wL6BZcro0t6sZaAXwb4vxk9s4LDP1Cc2p98juY7XtCt7NnDTRb1kp8Us9Mmi
du+hPjJWuDbB9tAzD0mwWQlmdJLxxe7wpWP/5aPyP8f1pNvI+HABf4pjXz76
Km1RbPGTjGeDaNZ/pheg+kNMD+oKyTiK61Dwe+6PSKX2S5hBLhm3VYWEtIR9
RC1OJuVrGWTsYP1qgn39I/o7VHqYM4GMn39+XGvdVIQGiwy+evmT8X9NPv+R
4j4h48d0sye8yPjp2tbrosOf0diZouMFLmQsa+5gsx7yGU370Tzttybjy0GT
U7eCS9DqnQ8sl3V35vPu3lOdWYb2b5KdVy6RsUDGJsXNrgqFFqRnBPOScSoa
tPc9jRGjiWobOycZt1hNCdP8xOhoUwqP+ikyPjkTrGQU8xWxJSt1fdhDxs55
gg8iD1SjVM2l3QoUEpa/z5nh/bQacdIlXOolkbC7yfpBtz/ViNeW4L+fQMJf
jx5z/5xeg0TlX4madpPwa7r7F0wNvqNSIhhtt5PwO/0Pob/bvyOpD1MhL5tI
+CKHZ2aE8g8kc0x6tKaGhOtT75dZwk+kPDkSxZZHwgfv2O/6qfgLGYYILnR7
k7CYd+PP5P5G5Fwc5d/oRsKcfsGFmvZN6GXv8plvTiQsLHTqQdeBZlTP9/l6
phUJk783Ocieb0HCjVJpDjokrDnnOzxn1YpUV99ImmuRcBfDrd/fvreixyxb
zXpqJLwpwqAjcrYNJTzBm/LXSBitmNEd+dOGaBjktY8IkfCifTprqOYfxCb2
bpbmPxJ+xTXccrHsD7qsT+NDvkDChkPbVe9Z/yLrvLr8IRYSPtY3wH1v6S/q
VlWhK6AjYZnpG8yx+Z0oN1y74uYQEacMFFunR/5DP0pKNGR6iXijrLvp/ole
NDRwYkq4k4i15k4ZBqf0omMC/46ebiTirMHvLI5f+pBHi8HTqVIi5qptf/eA
dhDFE7/u7Ssi4mgFJW5xrUFUzMae0JJHxNMH/ATs0wfRpPVoXUk6ETuICw5c
VRxCGofN2P0jiNjtI6F9PnEYWUrWlz4PJmJzI5blauIwCjC6eOuJPxEz1rta
iGqOoIrCORdNVyL2tzIbPcw4ijg1bP+yPybiGWX7AYeEMUSMcnmBgYjzGwlB
Pxim0MSZb9PXpHbi+/npAV/EFOrIoFFpEiHiR70J9xiZp1FReeThPh4iZlVS
sPM6P4Osht/Hk48QsbC2VZKu8Ry6bzm36cVAxDE6WYp7SHPoxpqQAR0dETeH
H2QJi5pH3Purzp/YXsdaAy1Lzk0ENCL4J1d0ch2fFvbpSBRdRG1fTh6qHF7H
k6fbbkiGLqKvCgY28n3reKHtzz638UWUeG9a9HbbOi7Y5qVhTVxCd72osHXF
Og7cOnMkh30FNbXwteZErGNTPut/116sowodW2Hh4HX8rOFJn9b2OsoZLXlZ
7reOf0RuzsY5ENELopzOL+d1PPPyMe/IExK6ynZvZPzhOmZgIPBkOW0goexE
BSuDdTx352CA065NxCYy+n713jouC32g0BKyibYVn1ruubWO19OEza/lbKHS
p36r5yTXsfrY78s39lDBe1L9nSzhdSz1U8jQ6TYVvPJhLBfgX8cnxDw/nUyn
ArvYN+5wfh3793p3tF3fBfy4kFbv4Do2Dv9zrOc9NaQx9J+MG1rDg6Wu32yL
90KULtBK9q7h0GSZIeEzNOCdmbzS3bGGq9pnZ3770YCx3IPm0w1rmE6lTy1Z
nxbYHSZ9kz6vYULnVf6qC3TAVHPdVqZwDf88I5dxMokOqBlzDIZy1vCCSa5F
2In9MJz1ROp8yhrO6KAOnjhMD6l9S4SM4DX8iLUh/B7rQYji1exT9F/D0DpI
8sg8CN6On+onPdfwvMnlwv0iDGB82Okdr8MafvqDXeWZxiE4p7Clk2e4ho9o
KA0PdjBCci7tj0+ia3h3VH3tlN0RiCA9LtIWWMMqNF3fOZuOgOe1+uR13jVs
15Y4NcfDDIaDIS6SbGtY6doL7ivjzMDKzCRYuX8NSzlJ/35hewwYjOzO6u9d
wwJfWn37uo/B9oc/9BTKKs4RJ9KsyB2HfsXYcZnVVRz/Upbd59QJSHQ5k1A7
sIpl2Do7iQMnIazOLdCkZxXHXB6U5dU+Be5HBxxo/q7iZ4/dq+41nQL9/BR1
pfpVvLbGJNpeexpYRrhoG4pX8T0Rh4QTv1kgQVnQtj1wFftu7Ha4yX4OOOiV
61t8V3FZGYsku/k5yPltzN7ksYqn137TMBedg/KbMW11z1ZxZPzD/+4rsUO3
6rpQldEqFuRZer/ieR4MDzEGf7m/ilfPvzJiazsPk83cI6V3VnGJRPWTIA4O
IKrpRBeprGL/m2MlFxs54NjtyuVMyVUcxruHloufCxKPdNzIEFnFjjxNgz8C
uYDzz3xa2qVVfF5G81jDOBeIaLFpJnKu4ja1G/XH310AjTs+xdGHVzH/Spar
gjAPhOtef+Y+tYL/WWcFV8TzwbEzxo0uoyt4YPWePOeh/yCx15nz+cAKDu6X
577h9x/k6eX+tfu7gm+ZuAlPOPBDg8EhMbNvK/h2ldNeOgkB2Pfw79rt1yt4
XsPGhNpQCCI45lXVY1ZwkYz1QGaWEBwfo3mvGr6CE88eEX24IgRcjyTuXPdb
wa3f3IO4Q4VB4fGbEmSzgv3a6Fg1G0TA29LIief6jr8ynqRvvuLQH6afUH51
BT/32+R3mhIHqULdrzfQCm7w5r9ffUsClla19lkJr2BNE+1F7nOSYOShHPeR
ZQXHn7DeM9EpBRUpihVXT6xgsrwocej6ZThRKz/4h2kFX+JMu51SeRla9gH3
Ou0K3lczeDEg+wrIRAmXXl5axv5JIS5Z8QgSigV6G2aXseDmWVGv0wDEjv+o
9CeWsYFli8HtRICC09xKnr3LeOX6yX+7tGSA9d2Zrtofy/hK+NY5wSeysF2y
l6jyZhlbCnC+mW67Cjo91GcGXi5jqqnd+xY55OHzJgWsI5Zx9CmjMGEnebCS
JQdE+S3jyKTzD9zZFaCvfv5459NlPG56OybT/xpIzM1cfmy+47+wt+PAyDWI
OTRlQHq4jJfmNl62yijCTc2R96d1lvGzxsWGcColqOjrFDeUX8Y5Mq1SZpHX
4QTVX91FtIxvFimc1CVdB3v2Ng9vyZ31WZN9/xorA59pw890/mWcRWkSeS51
AxIWvt6ZOrGMBWK/dh3Zugkuu7MdbeeWMHVvB+c1czWweq1PYzi5hB/Jc52y
fq8GxpeOvFQZWcJkRnrhJ2NqoKzr+pG7ewmzHBoTnHmgDieKVOf6a5ew8ZRo
pIyFBhQbLxvfSFjCz/wtXcvfaUIm8f2iROwS1lEZOqq3qAlvwu57ckUt4RzX
jDyKtBZ4l39/u+vFEjanEDjUe7RAnSmuq8RuCU+9PTnkynoH5r9dUeW4sYSv
sfFLtvbfg+E7i72Hry3hLiEGp9XLOvB37p0FRWYJRyHZHNV4Hag4eSiwR2wJ
B3aEGOfp6EKwzVBNBPsSLtYj3Ayavg/c5/wlt0iLmPBiPpeG0xDOlEjVTa8s
Yo7TLCzn9Q3hkApBu4uwiKXvm7GSYg1hzemufdHYIs45Ya3Wc9AIalt4881a
F/EBPY2fH6iNwcizmaMjcxE3/307E8r0ELS7k1Bf2iL+pnzn7Iz2Q1AWsr47
mriIF0IyvVkSHoLIKGPIUswiVjV5eYGexwT2KWksM3gtYuPbivtvqjyCvEN/
vyneW8RveOfbA749hrTH7/6pau7wdYcDOsxmEPft2arWrUU8x+B6juexGXjZ
HeN5qLCILVp+x9YxmYNm550IT8FFPL+bf/89ewvYSOzRL6NbxCQDF0ZxCytY
WM92+rpnET+iFbjB2WwFo2ouUT8pC1i70PgwEnkKTdRnfvxdXcA0Nn9/bFFZ
Q+ojvf+WhhZwPHfj3PZfa1DiH9zgLV/AglWUZ88TbUE6oOCo0KcFnPGm3Ne3
xxaEBj0vSRYs4CXdo9Rw3A5OR517oJixgO8Upqn+irKD+VXj+gdRC5h0/BGX
SZQ9vKwci0swX8DnLAXqtD45gL5TvLu4yQLWK5cxvLPbEbiFbz1sM1jA1V9l
apQ1HKE8s/TSPq0FzPmZ88zhZUfojw7+YQcL2OW/idyHMs/hgrngijLzAv7k
KqfkfsAVFjjGu8cYFrDn46ub3eauUDYQjz3pFrBSlkezRr0rxGbvO/Zki4Bj
KsJs34e4waBn3lX5NgJe2mekdonVA2z/IycuuRDw0+/WlwTBC/akPTDntiHg
gXqT4E1HL3h1olFU/xEBm6QbHHla6AVfdic3/FIjYMu9MVJqXN6wp0eBnMxJ
wLEhHW8FT/jAK/9IrVvN81ilk468wOIH3JtkNr/aefzrQ/8y2cgPym0ezpaX
zePnUtM9PzP8YOC+uA9X+jwuVEXthUL+O/noK9hymse89THd5NsBUD7AfSCX
fR6n27a9P1QVCK5Xdn2IPzGPz/ezmJbSBYH0626VQIZ5bJ+18YtTOwi+agSF
PyLPYd52ah6txSD4+X2G6VzbHH5nnpEuKhgCf3LyTr7ymsPsv2KXPLvC4NW+
gHJfxzksfpGzSVYwHO6YGOjaPZnDeZFKEiNB4dBzlvGt2r05nD/9M8CULQKG
Im3Y6AXnMAOlzRD/i4B5R5ELnoOz+HKSl9by4ygo+HOgzqpjFq/LWBz9lRAF
NoJjj/UaZnHbkccmZ1ujYGX6ZbZU6SxeCdH7fONyNGzorf+3Gj6LbdX6LBqP
xsA++XIRc5jFL4tVybdHX8J5Rhk5zcQZbHfeSGpq/jWECQw5m0fPYKbZDuVE
qfid+9e7yPPFDI7k45s5HBAPDZG1HB9sZ3BL8WidFPsbsD9ynZZGcQaLcrN2
VBglwI9jGg0lhGkcshz6voMmCQTEl/c0jU7jwaU4Gl6DJIi/EyM92j2NXdaf
PNEsTYKncR15jLXTWKQqSzNeLBlOnNKNNIubxvuo4ureLySDOctD7dOy09jy
Occ0n3Mq/JHeGy4oNo3HY8R8nn5IBaSf8VPx4jTmO3D/He9QKhxJmpSwPzqN
ndQ1Bg4qp0EF25PTjVNTmAU51SWdSwcGDodB96gpnF2Z7VEw+Q4+8r4wHx6Z
xDHStg0JvVnA2mpYdrF7Eis6HFe4z5oNIY6S+541TeLUp0Nt2cbZYFI7/Y62
bBLnLF+KJ05nwwl9lSG+sEkMUnYDVtS54BbJdNdRYhJXohXzAJU8mBafyfj6
3yR2PnPLPel1Hmj316zSnZ/E2RQuR83xPBC4+Cw64eAknq6zjInzyofh2s6m
b8MT+HN05kKLQQEoERMUDoRO4PU5sYPoQyF8SnwWo+U9gWcXnoeadBUCu4Lq
SKLjBD5qN/x8ePdH2IikeAoaT+CUVHqtft2PkHfRuEJbfAILjBnITR8qAmaD
C8IpQ+OYOVH0RPGLYhj4XsgmJjaOv63GEhm/loDrbZK8BN84nkTU9nTLJXBi
SMZMin0cX2k+euwuVymobTYXIoZx/Iot4TwptBS+Cs3LKY6P4TfiCdm3jcog
OYnX5O6rMbxbMDat6MQXMH6eluW8NoqFb7mw3Gmogm2amUbX2VE85kFTUbQf
Q3yM0JL78CiObszzs76OoS3/m5RP0yhe13haRV+H4er4wO/gjFH8WylAY/Lh
V+C4fWY+QXsUm5vXl00+/QZjfC+F8OcRzHxT1qwipwZ43d/NT+aMYPjce+7+
nxqwav6UzZQygqWyHVklt2qAaNPB/ih4BKvQvbPKuVUL+0uOHzloOIK3/70Y
tF+vBQHZ+GUduhHcfrla+ZPGD3DRSipe0x3G0UyvXd5K/IKvGfnWbOrDODVM
fOaU2S/YQ8R8yteGMXPnrfiu178gLH4w/a3AMOa5d2KSefMXJA+ceym/dxh3
B7I9jaqphx9m6c+i8oZwYrrW5nv9BjjsniXGv2sIOzw9fUzpezP4f+auY1wf
xNI04w8OkZuBPP/+3vLsIHZNE1UPON4CwwYZrqVdg3j4Pa9hz80W+CibVi1X
MIiZTH9sN5W2gMbet6p3DHbsL1lsT79shQsnzzVSuQzg+dw7c0kP24FPjMD3
brkXuxuRVaXUOuERv4dHWV8vvnldoHTerhOSuA61Nf7sxVy/ye5VsZ3AdPyS
49qbXrxyl90jf6AT1tetvinK9+JLF8hv2qy7oLpsXms65h8Wqc5tXY3thrvS
8+6XxHpwmS/H6G3iP/CRn2spc+rEBywXD1x1HoSjmnkR94634T/ZkjfDo8bg
I1dwucLuNjz2JtnL6t0YqJFMRwUJrXhWPZnteukYBCWek9j/sxXPXYgjEvrG
YHsyZqDcoRV/LD4WR+Eeh3E3F/4zHS14n01DNHXVOFjdioyr5GnG7EIZ0vbD
E5C5ojz7clczTjN862W9MgHDr/fIWHU3YXvIIRvTTIL2qOPE2cAm7PGMZoSH
dxLgub6Y52QjfiwrOCdlMwmMaRf/yL1vwCbVcTPyW5Pwce37oTqOeqwXURrW
Sj8NYdmp1Yj0C5+8984vnWUaLPQ9nn1q/IXvll/5ZXJpGjh+SPxLdfiFh/Zt
P/ioMQ2vXuZkuNXVYZ/oTD6ruGlwFomUFrb8iUs+TUXLsc2AnO19i8SiWkza
CLAhs87CWS7Js0df1OI6CPUVvjQLG91HW4Pv12JBZoOXmmgWimWbxZ7vrcU3
PlYtqdyfBa7DctSad2rwoaNxz0/EzsL+gguv6Ta+4ft+nBajtHPw7t9Y6JRv
FU5ze37j/N856HE9lvRWuApzTo2yXRmcA4azigXqw5V4ODns1uWZOXAwzGwr
g0q8vfz88izVPFwbMz8eRP6C64wFF5gvzsPkPCGZ17oM5/jTfzV1noczEWwf
+8+W4YNh6/u7fOZBTVC9JqqxFD965NPNFzoPpXYfx8i8pdjnW+NLn6R5CCTa
8/4e+4zPfW/IGq6eB15qcpGFbjEePdTIr76HAPppvN9Z9xfjROe0j1v0BIiS
1+1oLy3CZ2dP8oceIQDZv4J4+VgRfs33uUiTnQC/6T2kD7QWYoqacqoPIgDV
h3zVrx6F2FghMFBBgQAiqoMG9vyF2O3p469TNwiQECHr3RtcgD/mX27uukuA
Lt59YfdC83C2jsKDWzYEkHliVvBt+gNublEqOedIgMz8+jYepQ/Y9xxN3V9X
AjwXCT1Ops7F1eMZvcMBBDiFmFLinbJwYrI/Y3gCAbw97WqoOzLxYtOW35MU
AsxU/xkzF87EYhePXf4vgwAVirG8l+czcE25JJ9aPgH01M8U/3uQjv0mbD6z
fyXA7PKq5LPaNCzPpWS0VkMA11fNmIEzDVfkmJ/O/bmz/n/ev2XHU3Dzin90
ZRMB+Nzvq/+7loJlpVSlT7YR4AubWKf9+2SsxLvVqP2XAMW/277fak3Ewzx3
PBz/EeAPo3+rd9RbzDLkHKbTT4BlLcm+T7cTcOOYoxHrEGFHjyatnO54jUvf
JgurjhNAnfM21a3YOKx7Z/V86SQBrM1pDnjfjcXMH5+V754hQP6K5fnJnhjM
dHj3VyAQoEmS7dLphGhsMjHHLrBIgHn3dilVvSjcd+XrEeplAhys9b/mdTYS
bz6WC/20QoC7TPbpj3E4Lp2ODlJeI0BsQs+XJtlQ3OZxkfbbOgE6uGTbRWqD
sIdU5/YJEgGYC99Px197gR1eVjzRIBPg9mUG6l2//LCu/121Jxs7++W7/UnT
Gz44OMwjzWyTAC23/gk0NnpimXq9h4pbBDhb7BPxKNkVn9p2iKDZJsCbOjUs
9M4RU6VlcL7f4RN9LPPbWbZYf4GVnYdCgIsjfyVf6Vngb6NPfEN2mOuAdSy/
qRFuu2l3o3WHPf9w/zldo4Lf1Zk7rO8w36E+873/icCT5vE9lB3uWPROYiTe
Bb/C1rWJHV64dWHpqe0j6It7cvPjDrtEX6u3ELGG4gBNGv0d3nZ//ibp0jOo
0XLinNlZj6d5rmU7rzPk5bDn3Nvh3doD0rRcHjC8uRKXtRNPDVtgwFtGb/jh
MbnQsxOv7yt2a/EwX7jBofppbicf1w5U3G2lD4CuF02TQzv5ovXWkrUIDITY
ObOwkp181q3P8+ylDYHjXE5ZVkQCBD15wZTkGwa3AzOlaXfyn7EY4XbGKwKY
B3fd8lolgKkp76PP21EgdYtCPrlEACV2Rx0f6RjodTVJklggAHdfjaqa68ud
c9fpj8Q8AaY19MSnSbGgGzRB2z9FgPqD2RdLJF5Dq10lk88EAXLq1lh9HePh
tLTIT7oxAliiiH1nVxPA17TwesUAAVRIvZvTwokgwzXONdlLAP5insUS2yR4
LX6iYbWbAMSYoVluYjIwNvpEfG4nQNl+l7/Vz9LAJjiFuvk7AZL/O9qez54O
xHGT/s/fCOCvlt+S0JwOF31O+7lUEkDz1chvB54MqNbJs3xTvPN/zt2s5u3L
BFNNsVviO/XbKT+OjwdlwaQ+Ey/tTn1XmXpW7hHPhv4iNdXiVwQI/lBc2h+R
Ay8+lZRnBO/sD0mW/Cj5HZ3XcF9o3o4AB+6X5Hos5oHsC62H2U926s1dPdsy
MR+4cz46y5sSwHC4WuO8awEwc5tlM+nsxMe9rrL1txD0hTz9T+6cZ7+KDOQL
A4tBy/DfqXHKPFz5zldzYbAYRnKivYPX56GggySbKPYJzrOOaDMS5uEVKRqC
Rz5Bb+enT6V98/AQ6qRMpEtAkEHrWUDZPFDqBQRPLpbB21DTYHGLebDt3coP
VyyHHurZkiHDeRifq+enSSyHwlt+8ER7HhoYTfiWlb+A1Ok3k9yy8xCv/fpC
Y3oF3Jd5ayt2dB5Eh3ed9bqLYdJciq6+ZA74y+8sCmRhuK09PmGROwdcUR9q
B0kYFDr3HVlNngP6lFzRZJWv8KpsuakycA421e72Uua/AvkchyWfzhz0FeTz
YMFqsFA8Y/VmbRaSrPVrpUtq4XH0lTOfzs5Cwn26vJcDtbDs0V7lzTgLcUrF
sXO03yH5MN+xK9SzEMG23+Lt3e/gXm7jajs2A54tnw5vkb5DYSW10VL2DBgJ
HDSouPIT3KJzWwyFZuD8wheSVPUvYHS5zH9YZBpcG6/6rsz9AtP+o3My7NPQ
kf2bIe9kPehG+NboM05DkMm/8+ds6oGaqi7EZHYKFnrIKrRsv6EoLf3Ju7Qp
qPoumdru1gD6Zm8jWA5Ngc6bEmVLyWaobzZ9avFvAq6ndTeq3m0DJjoH+gda
Y6CgwrR79VMnJEYUHrgpOwhhRnSLpF+dcDGT7m4J/yB0PaMa2O7rhH+KezW4
zwyCeeJ8+T6aLqB/YxwqPj8AYYR62zPaXSD+NfNjrM4AdEX6DF9d64KlL8wG
baL9YN6x8i1KrAdeiO8KTl//B+EGnZ4CJb0Qp1Uiu/qxE/xnr8B4Qy+QzzbR
mIV3gvvz1K03w71gc0zXd92iE6yinzjTMvSBin2AkglnJ6j+3G3f/7APJDY6
BF+87gCGSwKmIUz94Jl0yoM+4C+Ebb9QmXwyAFfGWfmnHNvBP3iePtFnAOa7
w1XX7rSD+wnN+tuvd8arJenYJdrBSohVEdcOwI01n7S/xDa4UKTD9vvgIEyb
Wmblu7QB7cTCydSHg3D8Tiw7BLTCT1WWg2pMQ/BBc+/ZB5bNwMw/dMz2zBDM
GXyhnJJoBsOD79hiuIZARWb1Iv2eHT39m0+kS2oIuARf+cckNAHf9Su6hg+G
oEjS99DNlkaIuKqbZV08BBbnFX005BpAR+K1QqT2MFz4rJhbrvYLMo7r3Soy
HIawsQP/PM7/guU1tnt/zYchFo1yuK3VQcinTMuTHsPwOsO9h/VtHWCh0uiU
98OwJDlhvGfuJ3D81zlUSByGUOnuX1dif8DcuaPubfEjIKgk3DPOXAsSLik2
39JH4IrGaeVbhBrw/vOfSUHeCBw/Qq8486sGjgVcuxlWPQJTl254VnrUAJp1
PKU8PQIZExf31s1VQ/jnns/fJEdhWuxP4/32byB4I5lQ0DUKWrSQqh+AwTWd
byRpeBRWM6SZUpQw/Ngq7Qib3bEnxXfI7fRjOgWtlZZUY0Dz0vRKWlgVeB/d
HcLNPQaX/lV5Nr+phPYBE+5kxzFgcYkPifn5BZ7ZXzQKPzYOURdd9hYYl8Kx
/YQK7XPjQBkNNZzjLYXSpI8nzvKNg4Ysv3n4Tj+5WS/Zkis7DmlVw/8ofiXg
fU4J6i3H4dpEtpl//mcIa3rIsrdmHGQCjn6sZ/4EAg+5nzc0jgPXssZutpFi
aCXN/InuGoehZNeL7YXFwMxpF8I+Pw52WXRy6mrFEO/itQEnJ6Bd9LRScmQR
ZHAndjs/nQDnaHXJC5wfQanKSFTOeQIUVGfVOEmFMHWbM5LObwK0hDVEnBsL
gc8jVykufgK082XiuBwL4ePf8pJP3ydAXfvdI7emAqjy7ny5cHoSiLH0sh4n
86Gzl1HjUd0k3LYoiSG+yAblYJMu+7ZJ6B+7yux8PRsqJMv1fXon4Sj9V1bn
/dmQ/OqBRfLCJFjIv6dZDs2Cx2qffXtOTMF8hPHd4vhMINfolqiaTYErvSx3
V30GWNoWSOvZTUFkXvF/81EZ0M+2t9bCbQpCxBqjHHV37im3vJYXkVMQVTNU
MTT3DoLFd01Xl+2M75d+QnXiHZzJyTgjvn8ahs0euDd7pkHYvY1UBeZpoGFq
WPp1Kw2o9qnxaJ6dhu6YRTIfaxqMPiSJ2ghNw6cCnvO8OBU+nL15K0dnGvR9
Ax3nd6cCilr0Ys2Zhl/fCesHk5PB8PmVCdqbM1CsvnvM/koC8D6s+zuvPQNh
YvwK/2bewLKqZu1foxn48Yr5+L6EN+DPYZmS5jgD4kcH6PO34yG3+Y0upM3A
rm0b532Nr4HEudHsQJ6BPlkjxpSQWKhmDKjS2zsLFR6PX1YqxkLIBtMH+Z1z
vvPfObnA3bHA1sobxMQ1C4RAVTdut1dwzVVHPk99FrjD++oMnF5CVFtZ6Vjm
LGyWbu/3Do2G+5UK7xuKdnhjBeY0ooEzs/VlUdUsjCuEHF86EQ2lblO2Xn9m
wdT3e0hNRhT0c5/8j4VqDtK3SvcZ/4oEXg+nFM07c3AQOx125ImAmoviQTV7
5+EozSU3g9dBoH9JM23x0DwM+tUEmN8IAqKQTQXrqXl4l5R7VGY7EPikcuZd
+OdBADP0XH0UCDFKrLdF7syDjbSsnTu8gEcmtGfeZc4DZxlJ9OZRf6Ay4xBt
/zgPtFcy08Xa/SDeUlZ1V+U8PO7/d7010g+a7Fw89VrnoXbf2q7Dh/1A3Jsw
epQ8D0Gq3XLhx31hX1LnB/+dPieiZllf4qo3pKau/CjWIkDYsas3bOi94UrG
4cFhAwJQ15XXyP3xAusPN5jAngCONqs/s0y9oPsLdljf0TnkZ9cLjV56QnbX
e3i8o+Ne79PzenPMHRR6a+++2tGJ9keST/0rdYMFwoKE8a4F4NX96H7uvhsE
LR/UiKBfgFP+BytL37lCFVnRd5Z1Ab49CP3YIO8CXHQVk+lKC9As2FzuUOAE
Sz/5zVNVFkCna7Ik6IETVPmnzCRpLEDb6aNXHI87gfaegPn4+wtQNdoQ0+rl
CH4U9ZUI6wW48fPZCw1DBxhdnaC4xi3A46690fVy9lBQrOPl/HYBzv/RkXCk
tgdXu0Zqp9QFYGC8f7av2g6YFz/utctdgGen5YwbFezg6qwbvdnXBfD9To4+
qGkLqcNHjmtNLkACiZkqIMIarFL84zTmduYzt0pb0bEGKUPSSbWlBTBzy6Cl
4rKGtr7+Mzc2FyD2rL5+u8tT2NWdxS7LuAimdEy7y6aegGEz8P8nsQhb1Qr/
OjbMgS/sYz6v9CLUfXcfJKaaA/EmpyC33CK8TGO4zXXDHMLr94ucv7kItb++
6MUlmu3oib+SJw0X4bZTmF2I+mNgqbBQ2PtiEVqiy8YfjJkA80ky2Sp0EVx9
gKHppQkccHhR0BW1CJ2Xj9rIKprA5qV3p3PfLkL3bfcE8Q8PoSetf1GjaBFo
W8Q5D/o9gFfB6onJ/YvQMJ8b2WZkBGGTA7f3jy7CcfFUoafnjMBPwYrOfmoR
xvjd5SeGDMGeEmSvuLIIJa/t5A1MDEHDrlZ5nm4JWpwHZ1Vm9YFBV3z9sugS
pOW/2NPzXBdoSr/nvpNagufdxjo8TLqwxaxpfEhmCWxv9vQP5ejAbJN147Dy
EmQdKax2HbkH9XLZaYGGS7DFeahq0PguBPCyqHUGL4HHrdldVYla4B6Qs1c2
cgks5m2b393QAodRyS/Zr5ZAMuKr0ieSJjxK1OZyT1mCk07WRlfuaYI8U8Qm
R8kSOPNVmvhx3gYqMnWW7fASnPpt932VoAaGI93LHhNLIPaq3PXIRzX42lCA
QmeXYP+sC8vuZ2o7ukb/z/u1JXiw/+yuBPItoMiXU3r3L0OEhyRrPL8qbIfb
aCsKL8MXFu7HpX3KoP9cKUVTYhkynNqfzD9Xhipj1lkj6WVwL2y2dDuuDO6i
jV6uisug1X333kvt67DVw/2hUHcZakfwS4lRRdjkHNx9xncZhgxq4polFeD+
oRJVnsBl8JhQcMqfkocKYuhrsbBlyKYcD8yKlwfX35cvqcctw3b3Gbp+ylXY
sI7V8c9dhq34SYWJDjkgf1EtXPizDAtjuYKRxTKg845zc6t7Gewhw9HdXgbK
wzav0Q8sw39U94LVRWXguVF2L+fUMlBIN6Ok7ACINDT7dLeWgajb77sSJw3r
6pX63zlXYEJCfKZSUAq8u/P70MUV+PVI+bh4jSQwGKXeLxVYAaldQjom2pLA
ZR2gk3N5BWKKvijUeUmAZpi6dqT6ClQ5tBzanhGDwaPyf/ffWQGFNasvz4LE
wOKtmKbv/R3/gvH1trxi4J17WsPRdAWEuARzx61EoaB+TEXPbQUuNVwsO0Mn
sqObuho6vFdg9LiLOFeRMPzsrr+h9mIFknr1LgTpC0P/ZP71q9Er8P10uYhK
mRAcoHVW4MlagUMxHpli7oJgdpVBevXPCrRW9fDv9uGHlXqqCqueFZi98siE
sPUfeGosS00OrMBr07trW87/QZxRl8S/6RUY5/XIM3Lh2+m7U0W+Ua1CcRpS
fhTDCxq0L4ukaFbBj1ZaN4CVF/rCAoSK6VehoE0oLSSXB1beWgq8P7YKbBPu
1VwN3MBeIcYXyrcKlbSXxNvZLkDeVZ4cGqFVcHQ4IXOrnAskf5/m9RRfBTV2
l0FHLS5Q66HitpNbhaCg4NHiCE5wJ9afv3d3FeptOmf5TnHAPxGD05y+q0Cy
DLjw1+4cPCKJHvILXIWFu0FXMrnOwULlgd1jYavAJ/2rtbKHDfYolk+nv14F
kSK5gYRrbMB/72g5R/4qTE2zMCrfOwulLLMffItX4VDbfvkDbSwgN1ydMlq2
CtcHXnruU2GBOxbWgem1q3BwV9mhkOtnwNPt912OnlW4dSJbvVX3FOyXS73p
O7C6o4dbCuzHTsJLmucyo6OrMKi2JnHI5iRkh3NxpxNWQS6jKWx/2AloT/Fa
P793DeyefmO61n8MuH6IvzovsAZeT+7tf9F6BAqCGIJ8RNfg1pXWan7HIyB1
a8xtRGoN7h0QY7p/9gjc6ooySVNYg0dP5GsFbZjAaXpO5LzuGvQZi6Sd4z4M
1Pm13D6Ga2AjYPRas5sRQu3enBkxWQOOSTfGgWBGSN1U2pNmvQbmtI8u/po6
BL8Z0tvZ/ddAh3HzlFTuQdBud/7pHbwGBQnuB+bYD8JgrPqX4Yg1OJ2VarPx
5gCssFFSU9+sASXKoHT3S3o4K6xjy164Bv4ja1LlKXRgfYfxMHvvGrgybBgv
s9CAcealeM6hNaj/OPJuT+Ve0CKpnucZX4MElkbabL29IPUmVFRgYQ0Onvxm
Fpe2B/YO7NdBe9aB3uPKXV3Z3UC8xDsiS7cOp67XpzycpYZpz+uWCgzroLJO
+d0WRw0t7C/cb55YB8YymrKfq7sg/tHeNB2+ddilo8LqjqkgpISDT19wHUpn
B/eceEYFHvvkPxmJrcOU2IfK2YtU8DDb++djmXVg+/yd5ZEUBV2ap8w4aK4D
Z3busO7pLVT7jCwS7boOd1L+hHXKk9DnHyerXnmtw59hYYNj7USUdVxSMd5/
HXa/cXon/YCIwsoc76VErEPHYn0WV+A6ure14pafvg4O39JDIqZX0U1VZtqi
rHXwaegQkglYRShJOOJz3jqQ6M+ZvOVcRRyytqmVpetAU6BNo2C6guZ9CT9+
N6zDzBbrqfCtJTT0l0GtuXUddESaZBcyltAfLv7uto51mHOL+lavvoTK6ixn
ugfXoV6X4tues4h8D0wfmlxZB8mOJq1w6wV0Mmb07h4WIpxUiD2a8XQWSfiw
HrNnJ4JdE3qvODSDtG112kcuEEEqqbs3SmsGRam1qNQIEaEy4cDaqsI0OnCw
Qs5biQi/jTp0MuUnEe/mGmVRhQi5+n6Mt+onkNKMYKXRbSJ0BXjQyGtMIL9f
78Vl9Ylwioc7ev7xONr2i+ajsifCAc18Lp6CUXTmWdPU0+dEGMmWCzmvOIou
P6R7P+BOBB6lY0/PDI4gJzmPcziQCDUXWgmjx0fQ4rb5MfckIrwcTDHoejuE
Rh3lqDbriZBnnM69i9iHqE3dKi1aiDD/SOf6T70+xKZd6vzvLxG6/+tR9f/R
i/RE+FfLB4mwL5LeoCT5H+pYODn9fI0ImS5dt584dKOVAc33UxtEGE/4/dpz
qQsdaQ5/eG8XCTJCTILO23QhtQ97ByQOkEAzKeDw5LNO9MtssX39HAkq/ntC
5kj4iybv8kWaXiDBruxdt55c/ItolExVO/lI0BfosjhV8QfJcfXVfRYnQQuL
zX/a4+2oYriu8pkKCS4ffH5uQL0N5ekmv192IkG8Bepqp2lGIp3nyTTuJJi2
rh19+6QJfdF4f/OUDwlIvzP7UGcjqruetygTSoKRjJbrbR8b0Ih4xeWwFBJo
5Y4TRgLrkXkRhKVkkCD/wpeifTT1aIG/ZrA4hwSmT10hzfcX2uas9/v3iQRh
5T0zBwLr0AnmrmbuehLQ+PjU+Hz4gRLDddmvNJPgKd3VKK4rPxAn/YD9rT8k
uCZ533K64TsSoh4/6dBPgvDfbdJ5K7VIZWH5Qc0SCTydmK3O3q9B3g2HiHqn
yVCQ8UpwzPsr2qcUrWzDRob00zmcOpe+ovCaY299Ock79ZxxqqEco4RyFrmc
S2T4k3lWS9m1CpVkXgwhXiVDMEtBySJ7BUIc+f3018nQyU10Lov+gmqThARZ
VclAGisyA9ovqO2VZIfCXTKkrSxYa6yVoVlfRbZoSzIoNP6+ILVcguyofttm
2JCBqrA445VTCSK7qH4vcyDDlf3s19WoShCtnZb5oCcZXiiLm+Ud+4zYjR4U
//eSDM8WT9BN6RWjO9IeSnWVOxwiOhKoUoh6V8cPVVeTYUAxzilltQAZ56l2
fvlJBhlSdpNpUgGyZD37KL+VDEq6Tx9XE/KR965Kn1djZJB42Zn8wPED2lfO
cSNimgwC2XI5bYO5KNQ2hCmIQIbPhrsYuFVyUdyIboobiQycpYoXbvHnoLzv
5KqHBzcgOn/zKMvhLCTibuyvz7QBXk52YTciMlGZWL3K3eMboJfZfIB0OBPV
vn/de+PcBvyjUytKOfMedQdKkIVEN2At46vblMo7tEfVQXSX3gbQ8ollrh9L
RUE0/Ztkow1oaauyWSpNQYewQu3Kow2g1F67/f1+CjolcPT2pPUGtAclDzdn
JaNLTMXWzb4bQD336f7hwkRUXH9a4lfgBvwRWGN6z5iIpHx8KNVhG5Bq1XjG
1O4tkl/RCPsctwEyZ036ueUSkE7HYs7b3A3gnjxseXR3PBoMu2cXW7gBlft+
79d3fo1MFL9JRX7egIGCt4/1VuKQdWnEL9+vG1Bywdr1xkIs8o+/NGHxZwP2
yZ/k9qR5hQr1n7BLbW5AEs/RmuGUKGT8aYEledcmpB84YBUiFoWYD9ifpKHd
hIQ5W5uQxkjkUObM2HZ4EwIvOXvpUUciKeYX22YXNqHRSlB/gj4czZjTk5v5
NoGj54LB5p0wlPAtbFVUaBOe28gUUWeGom2rl7O7pDdhCKWZhd0OQdW/Unte
a2yCO3/kE9OOQGTHxtVBubMJzQLmMr8gEHE4ZrWa6G3CPyl7fbfcF8ifo6BO
8PEm5N6WcYgJD0A3PCo//3LbBLq9SzLxzn5o86/Mx0s+m7DmSDf1ftMX5fHV
fnj5YhMye5Lpvbx8EWNPfbpR9CboD6RX3o32QX9EuqJImZvwYMbz9J4OL+QX
rBtmkLcJXktGUa2WXkhsuD/we9EmxAxL6hP3eqG48DHPyKpNeGLorH0WPJHe
9JIVz59NOL0v2Xn4lRtikHUwD+/ehIiP85/uTbiir7Ekk9X+TbCPSwipvuyK
2BWo9L5NbcLMW9HmwwvOaDzp4I17lE34FXiPW8/XCcWuRVzDe7aAU8L7MfOS
I1JSYZbj3L8FdJcbRE49cETZ5FOSi8xbYG9Ebvmp6oCeanFfCOTdAqp7H5kr
le0RW24OO+HSFhC47frWW+xQG/Wls1qiWyDVLJm+fs8OiRSIHj0nswXzP3ed
3mdvi4j7r+4u09qCHOtA/YYf1ohpniGmWmcLvAsfMcJja3SxtYejwWALtH82
Ln+mt0b6sbbXBsy2YLrDx+14oRWqOZ8auNd9C0K+nNfQPmyJemmsTh3y2YLU
wlTpW7YWaG1KMufEiy3Q/5U+/7HDHHEXtDZcjNoCGaEsEdssMxR2ZRejRsYW
LN9883jK3hRlsjYm6+ZswXELrUVVwiP0jfq1oEnBFpDZir1jLR+hlTqB207l
W+CVGSAU89QE6WgZvkps2gIntgXmxJcPkL0E34XM9i2o2v181oXzAQo9TSwp
7NqCBBplt18lxujrUHh37fAWBNC0BXqMGCFOK3xmZm0LXGKQAFHLECH14A8r
G1vQcnjFf4xggO6K3EHbVNtg/UbMYk3cAAWR5w0O028D0YWpgemPHlrwP5sm
zroNoQs8IcOSumi/+bSwLMc2NL2Pm9dP0EHnVT7XKvNsw6ODZRfUqXWQ9hHV
cT3hbaBiD9l3s+suqkhy4/FV3IbTYlyyadnaqMP7ennozW3YfYHvajuXNiKY
HL0Rq74NM7RuibPvtBA73wfLbN1t4H8t1fEmVxMFlPbmtzzdhguu8F62RwMl
v8mU6bHfhshuPrNDlhqo3N2+deT5NhiFC+feotJAs/IHltd8tuGq+e+txUvq
SKP1shhL3DZcD7rxLFvzFtp/mf5bxdttCG8/eO1ZgCr6lt5z437aNiSQLw7p
YhUk4PTc6E3eNvy3IvJ7W/omYmAtCTn5fRsE20vENO2uox8v/I+X1W9D7sZS
RcFvJeS2pJV6t2UbxmO/7pXhVkKz31dKYv9tw1/7zYWwuWvol6XQyNGlbRi8
PqYrkSGPPDt2WX1a34Yh8bZ31izySEKmlai5tQ2fJwyPnI67ijKOWDPE7KPA
oVBfb+tYOeRb/kGSiZUC/RFm7YNfZNAVDrfaQg4KnPbJTjK7KYOWQ2/eUuel
gOaI78lgDMjYaOZhhCgFmD0L1gxYEJLZxxPBcJMCSdzjkXPHLiOiDfFUnjoF
eiokwNlICuX/+/lO5Q4FxLfGtzIKJNHZ/EdfQox37C8Y01rel0CbWunj+59T
gNZFXT5+XBQVYzubbHcK7Bn8oXritiiy4Lm6ed2XAowlwkH6NSKoZ3PocGA4
BdIIEfEjecKoJI1VmjaDAkf8GUAtXxBZHST8zMihwHTasexgcUHE5Vilca2Q
Aiux8dV91QIoRlnvsV8FBbzDK2Tnay8h28X46N3tFGh74EEc8udDvLrmZ9O6
KHAlatgspfYiGqqVzJLrp4AWMee9Oe1FpBbXVeU1RQHiIfGzr9/woH3UmdfP
EShQdMbuDZ7lRtjC8c/XFQr8e+340FaOGzn8vWZgSKZAQsJXSnTCBfR/77fh
/99v/w9+RtNi
         "]]},
       Annotation[#, "Charting`Private`Tag$17903#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3c8V/8XtspISFZRRpEkISpy70FCZWdWtiKkMvvaVCiyQpJCJNmrSPI2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         "]]},
       Annotation[#, "Charting`Private`Tag$17903#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"\[Sigma] = 0.25\[Degree]2\[Theta]\"", 
       "\"\[Sigma] = 0.50\[Degree]2\[Theta]\"", 
       "\"\[Sigma] = 0.75\[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.8, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity (height)\"", TraditionalForm], None}, {
      FormBox[
      "\"s (\\!\\(\\*SuperscriptBox[\\(\[Degree]2\[Theta]\\), \
\\(-1\\)]\\))\"", TraditionalForm], 
      FormBox["\"normalized FT of Gaussians\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw12Xc01X/8B3BR2SNFUWREGWWTwgtJEkIlKaRCRZKvNO2RGVG2CNkzZHvb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           "]]}, "Charting`Private`Tag$17903#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1m2k01V/Ux6UiKUmaEwkhf5mncjYiUoRQkbEkQzKFzLPMY5FkTqYMUYZw
CpVkVqbM83zN7r2G+3jWep5Xv/VZZ699zt6/s8/57hfnnPFTDRNqKiqqvt1U
VP/75Ydj0xQKBYf6ynyg3eBCT0nnX5DIFHw7krb9UvAFVFAkyLW8SsGN6zN1
dWe5kRC3ivH4DAVL+NZoJ6nxIPHDvj0NnRRcHrM7XWLoInL6Hen0o42Cg282
DEmH86Fyv6RjXxsp+NR17u6Hsv+hK+RyjaIaCjYO2n3G+SM/khlZrH+dT8F7
3xuwKo0JIK+3lMfR2RQc6LK0LqYqiKrvHKQNfUfBV8okriaXCSL5Bu6rnm8o
eK0ruPJMnBC6/sngy6MACr5WF/XS7JkICnr65J6hNwXbD4rydyyLoAYel/V7
bhR8feQR2+Vnokg18ZWwih0Fr5uLdQh7iSGNgMYcYQMK3pAI/NuPJVC07L/r
/+lQ8MRBTSLdXUn0Z2NygkuLgv8paj2pWZZE2tZ7OE7doGCLNs/7ImKXke69
ywlU4jvjzTPvnkxJo4Qj16XIghTM9Yo60zQZof5G7a5lPgpmzlS0SdUFZChn
yzzBTsGzrxLDE5/KoIcXs0IaGSi4+9d9t1kGOfRu7DPvTzoKFmf93dXuKofG
k2rrvu7Z8Xfla6bCnBwyYx7cU0zexl03BtV3d1xFVlvH3OLHt/FURWx0dJ0C
yi/hOB0ztI2dVAzh+c1raMFGqCy0dxt3mA9rmLZfQ7bjKquebdtY2C5ePXVa
ETk2+z4xrdrGRwbyzSJklFHIjEPnSuk2vm7B/pl3Vhml0prJehdt41z+VXba
hBuoAVSOvs3cxrQT6/2EfSqIveBoZVvUNtZxSOG5elANSTTQXjAM3cZy5ru9
Xz9TQyqTpIi5gG08MKVV6T2ohpzY+h/uc9vG6SRqKZUqddQUkXEAmW5jiQ72
nKg3t9FobpzDb6NtbPqG46DqKU1EqgsavHt/G4d/0yByJGgijl1Pi+3Ut7GA
WLiVTZYWcrYRv591eRsf1DOtK5y9gyJCeX6Iie3EN13naud/F73LOi1QK7CN
353XiFk5fw+1DFF2D3Bu45eFjtQR5jqIS6Muh5lxG7dX2q//4NZDV6zKj6bu
38Z3VByfnh7RQ+pBuR6X9m5jkir2XU7RR67VEbeVyVu4i+tIbeMxQ9QmdG/D
Y3QLL4v0+K9gIzSpesPk4MAW/qahKlkuYIy2zKWb47u3cGfNraPi6caIO+1c
2qemLUzbO2gVG/0AuR2ZVp4p3cLz76+7NL80QVGXeoudirZwUt+bfu6zj1Dm
jaazNHlbmO/y9tvvWY9Qm8/HJba0Lbz79ZvVY79NEfeKc7x26BaWWipm1pAw
R4jxyZ7RgC08cTPPe7PXHN3mM7Cy8d7CAr1HYiL9LJD7w6tyIY5b+G3OM52u
YUv05w/99DejLfzDmfqLe8tT5PXwU1XO/R37OrPLU/LWiH9FP/rlnS188yOn
cmKaNXpx5OMVM5Ut/PhgZ5O2qQ2S1rgbzii5hR0uPr2jRGeHpod2PSQLb2Eq
i23mSEc7FGeTIzHKv4UPkyuH5Cft0FLE9lAJxw5/jDFgb7VHGc3pIgaMW1ho
zIZftNoB3TZQpbtOv4UHw3r/aSo4IirCep8QzRZmOSqgoPbbEekw3Aig2dzE
5JqDYicGndAhlcXuDxObeN/+ih/5/C7IqV7aY7NqE5d/1yl4Le6JOHUmbo+X
beKwGiFPqhhP1DYVwd1SvIkDhtpGHi55Ij660da07E3s5xlHVPvkhYYUgzhu
vNrEMv1Lj2c1fVBYpzBJJHIT//Dud7Gv9kFXTPsaz4ZsYosBk11aQr7olb+A
45LXJh6aun5Z/aQfUv7e8ev1k01MoV7XSNkbgNY1PRN9Hm/i5kLmK9oBASh9
lMfuyYNNHNGqPN9I/wJRdrudkb23iS2NNNeBJRAVy51/Oim/ibVYn010PAhG
LF+fMouf2WGbA/T0ihGogUnUXur4JpY/ztM1nRSBnE3I7dJMmzjW7+7bJHIE
6tjvFy2/bxMzW3E8//ApEkVoxTNprGzgNiF1a/Or0QhlGthqETbwnRXLH1S5
0WiOzNF2d3oDi+gNFnw5FoOUk/MjDQY3cE8iR2X9UgzaPVPL+KRhAyfW4o+B
P16hj9JB1tY/N/AcT4yyh2wsMoy41WJXvYFdDucsrlbFogrRnnDn0g3s+ENv
Iu5bHHLwJDC8SN/AOm+fCXNMxKOpo6cOprluYKOKqrw3OAnFPR6wzHDcwIYH
NXJeiCSja1/SG7JsN7BUiPDIelAySjW8FFLweAOzX5M0PSqdgu7nyNNXaW7g
yMkmilxJKtq/TWfx7dYG5g9Q4nx1Kg2VqTXX1ypv4CEf3s9jHmno2Nq9oN8y
G3hDvO9Oilo6apZ5StfNt4Hvrnz1ek+fgdyjRcx6L2xgn2dvikgeGYhvnFQ3
wL6BZcro0t6sZaAXwb4vxk9s4LDP1Cc2p98juY7XtCt7NnDTRb1kp8Us9Mmi
du+hPjJWuDbB9tAzD0mwWQlmdJLxxe7wpWP/5aPyP8f1pNvI+HABf4pjXz76
Km1RbPGTjGeDaNZ/pheg+kNMD+oKyTiK61Dwe+6PSKX2S5hBLhm3VYWEtIR9
RC1OJuVrGWTsYP1qgn39I/o7VHqYM4GMn39+XGvdVIQGiwy+evmT8X9NPv+R
4j4h48d0sye8yPjp2tbrosOf0diZouMFLmQsa+5gsx7yGU370Tzttybjy0GT
U7eCS9DqnQ8sl3V35vPu3lOdWYb2b5KdVy6RsUDGJsXNrgqFFqRnBPOScSoa
tPc9jRGjiWobOycZt1hNCdP8xOhoUwqP+ikyPjkTrGQU8xWxJSt1fdhDxs55
gg8iD1SjVM2l3QoUEpa/z5nh/bQacdIlXOolkbC7yfpBtz/ViNeW4L+fQMJf
jx5z/5xeg0TlX4madpPwa7r7F0wNvqNSIhhtt5PwO/0Pob/bvyOpD1MhL5tI
+CKHZ2aE8g8kc0x6tKaGhOtT75dZwk+kPDkSxZZHwgfv2O/6qfgLGYYILnR7
k7CYd+PP5P5G5Fwc5d/oRsKcfsGFmvZN6GXv8plvTiQsLHTqQdeBZlTP9/l6
phUJk783Ocieb0HCjVJpDjokrDnnOzxn1YpUV99ImmuRcBfDrd/fvreixyxb
zXpqJLwpwqAjcrYNJTzBm/LXSBitmNEd+dOGaBjktY8IkfCifTprqOYfxCb2
bpbmPxJ+xTXccrHsD7qsT+NDvkDChkPbVe9Z/yLrvLr8IRYSPtY3wH1v6S/q
VlWhK6AjYZnpG8yx+Z0oN1y74uYQEacMFFunR/5DP0pKNGR6iXijrLvp/ole
NDRwYkq4k4i15k4ZBqf0omMC/46ebiTirMHvLI5f+pBHi8HTqVIi5qptf/eA
dhDFE7/u7Ssi4mgFJW5xrUFUzMae0JJHxNMH/ATs0wfRpPVoXUk6ETuICw5c
VRxCGofN2P0jiNjtI6F9PnEYWUrWlz4PJmJzI5blauIwCjC6eOuJPxEz1rta
iGqOoIrCORdNVyL2tzIbPcw4ijg1bP+yPybiGWX7AYeEMUSMcnmBgYjzGwlB
Pxim0MSZb9PXpHbi+/npAV/EFOrIoFFpEiHiR70J9xiZp1FReeThPh4iZlVS
sPM6P4Osht/Hk48QsbC2VZKu8Ry6bzm36cVAxDE6WYp7SHPoxpqQAR0dETeH
H2QJi5pH3Purzp/YXsdaAy1Lzk0ENCL4J1d0ch2fFvbpSBRdRG1fTh6qHF7H
k6fbbkiGLqKvCgY28n3reKHtzz638UWUeG9a9HbbOi7Y5qVhTVxCd72osHXF
Og7cOnMkh30FNbXwteZErGNTPut/116sowodW2Hh4HX8rOFJn9b2OsoZLXlZ
7reOf0RuzsY5ENELopzOL+d1PPPyMe/IExK6ynZvZPzhOmZgIPBkOW0goexE
BSuDdTx352CA065NxCYy+n713jouC32g0BKyibYVn1ruubWO19OEza/lbKHS
p36r5yTXsfrY78s39lDBe1L9nSzhdSz1U8jQ6TYVvPJhLBfgX8cnxDw/nUyn
ArvYN+5wfh3793p3tF3fBfy4kFbv4Do2Dv9zrOc9NaQx9J+MG1rDg6Wu32yL
90KULtBK9q7h0GSZIeEzNOCdmbzS3bGGq9pnZ3770YCx3IPm0w1rmE6lTy1Z
nxbYHSZ9kz6vYULnVf6qC3TAVHPdVqZwDf88I5dxMokOqBlzDIZy1vCCSa5F
2In9MJz1ROp8yhrO6KAOnjhMD6l9S4SM4DX8iLUh/B7rQYji1exT9F/D0DpI
8sg8CN6On+onPdfwvMnlwv0iDGB82Okdr8MafvqDXeWZxiE4p7Clk2e4ho9o
KA0PdjBCci7tj0+ia3h3VH3tlN0RiCA9LtIWWMMqNF3fOZuOgOe1+uR13jVs
15Y4NcfDDIaDIS6SbGtY6doL7ivjzMDKzCRYuX8NSzlJ/35hewwYjOzO6u9d
wwJfWn37uo/B9oc/9BTKKs4RJ9KsyB2HfsXYcZnVVRz/Upbd59QJSHQ5k1A7
sIpl2Do7iQMnIazOLdCkZxXHXB6U5dU+Be5HBxxo/q7iZ4/dq+41nQL9/BR1
pfpVvLbGJNpeexpYRrhoG4pX8T0Rh4QTv1kgQVnQtj1wFftu7Ha4yX4OOOiV
61t8V3FZGYsku/k5yPltzN7ksYqn137TMBedg/KbMW11z1ZxZPzD/+4rsUO3
6rpQldEqFuRZer/ieR4MDzEGf7m/ilfPvzJiazsPk83cI6V3VnGJRPWTIA4O
IKrpRBeprGL/m2MlFxs54NjtyuVMyVUcxruHloufCxKPdNzIEFnFjjxNgz8C
uYDzz3xa2qVVfF5G81jDOBeIaLFpJnKu4ja1G/XH310AjTs+xdGHVzH/Spar
gjAPhOtef+Y+tYL/WWcFV8TzwbEzxo0uoyt4YPWePOeh/yCx15nz+cAKDu6X
577h9x/k6eX+tfu7gm+ZuAlPOPBDg8EhMbNvK/h2ldNeOgkB2Pfw79rt1yt4
XsPGhNpQCCI45lXVY1ZwkYz1QGaWEBwfo3mvGr6CE88eEX24IgRcjyTuXPdb
wa3f3IO4Q4VB4fGbEmSzgv3a6Fg1G0TA29LIief6jr8ynqRvvuLQH6afUH51
BT/32+R3mhIHqULdrzfQCm7w5r9ffUsClla19lkJr2BNE+1F7nOSYOShHPeR
ZQXHn7DeM9EpBRUpihVXT6xgsrwocej6ZThRKz/4h2kFX+JMu51SeRla9gH3
Ou0K3lczeDEg+wrIRAmXXl5axv5JIS5Z8QgSigV6G2aXseDmWVGv0wDEjv+o
9CeWsYFli8HtRICC09xKnr3LeOX6yX+7tGSA9d2Zrtofy/hK+NY5wSeysF2y
l6jyZhlbCnC+mW67Cjo91GcGXi5jqqnd+xY55OHzJgWsI5Zx9CmjMGEnebCS
JQdE+S3jyKTzD9zZFaCvfv5459NlPG56OybT/xpIzM1cfmy+47+wt+PAyDWI
OTRlQHq4jJfmNl62yijCTc2R96d1lvGzxsWGcColqOjrFDeUX8Y5Mq1SZpHX
4QTVX91FtIxvFimc1CVdB3v2Ng9vyZ31WZN9/xorA59pw890/mWcRWkSeS51
AxIWvt6ZOrGMBWK/dh3Zugkuu7MdbeeWMHVvB+c1czWweq1PYzi5hB/Jc52y
fq8GxpeOvFQZWcJkRnrhJ2NqoKzr+pG7ewmzHBoTnHmgDieKVOf6a5ew8ZRo
pIyFBhQbLxvfSFjCz/wtXcvfaUIm8f2iROwS1lEZOqq3qAlvwu57ckUt4RzX
jDyKtBZ4l39/u+vFEjanEDjUe7RAnSmuq8RuCU+9PTnkynoH5r9dUeW4sYSv
sfFLtvbfg+E7i72Hry3hLiEGp9XLOvB37p0FRWYJRyHZHNV4Hag4eSiwR2wJ
B3aEGOfp6EKwzVBNBPsSLtYj3Ayavg/c5/wlt0iLmPBiPpeG0xDOlEjVTa8s
Yo7TLCzn9Q3hkApBu4uwiKXvm7GSYg1hzemufdHYIs45Ya3Wc9AIalt4881a
F/EBPY2fH6iNwcizmaMjcxE3/307E8r0ELS7k1Bf2iL+pnzn7Iz2Q1AWsr47
mriIF0IyvVkSHoLIKGPIUswiVjV5eYGexwT2KWksM3gtYuPbivtvqjyCvEN/
vyneW8RveOfbA749hrTH7/6pau7wdYcDOsxmEPft2arWrUU8x+B6juexGXjZ
HeN5qLCILVp+x9YxmYNm550IT8FFPL+bf/89ewvYSOzRL6NbxCQDF0ZxCytY
WM92+rpnET+iFbjB2WwFo2ouUT8pC1i70PgwEnkKTdRnfvxdXcA0Nn9/bFFZ
Q+ojvf+WhhZwPHfj3PZfa1DiH9zgLV/AglWUZ88TbUE6oOCo0KcFnPGm3Ne3
xxaEBj0vSRYs4CXdo9Rw3A5OR517oJixgO8Upqn+irKD+VXj+gdRC5h0/BGX
SZQ9vKwci0swX8DnLAXqtD45gL5TvLu4yQLWK5cxvLPbEbiFbz1sM1jA1V9l
apQ1HKE8s/TSPq0FzPmZ88zhZUfojw7+YQcL2OW/idyHMs/hgrngijLzAv7k
KqfkfsAVFjjGu8cYFrDn46ub3eauUDYQjz3pFrBSlkezRr0rxGbvO/Zki4Bj
KsJs34e4waBn3lX5NgJe2mekdonVA2z/IycuuRDw0+/WlwTBC/akPTDntiHg
gXqT4E1HL3h1olFU/xEBm6QbHHla6AVfdic3/FIjYMu9MVJqXN6wp0eBnMxJ
wLEhHW8FT/jAK/9IrVvN81ilk468wOIH3JtkNr/aefzrQ/8y2cgPym0ezpaX
zePnUtM9PzP8YOC+uA9X+jwuVEXthUL+O/noK9hymse89THd5NsBUD7AfSCX
fR6n27a9P1QVCK5Xdn2IPzGPz/ezmJbSBYH0626VQIZ5bJ+18YtTOwi+agSF
PyLPYd52ah6txSD4+X2G6VzbHH5nnpEuKhgCf3LyTr7ymsPsv2KXPLvC4NW+
gHJfxzksfpGzSVYwHO6YGOjaPZnDeZFKEiNB4dBzlvGt2r05nD/9M8CULQKG
Im3Y6AXnMAOlzRD/i4B5R5ELnoOz+HKSl9by4ygo+HOgzqpjFq/LWBz9lRAF
NoJjj/UaZnHbkccmZ1ujYGX6ZbZU6SxeCdH7fONyNGzorf+3Gj6LbdX6LBqP
xsA++XIRc5jFL4tVybdHX8J5Rhk5zcQZbHfeSGpq/jWECQw5m0fPYKbZDuVE
qfid+9e7yPPFDI7k45s5HBAPDZG1HB9sZ3BL8WidFPsbsD9ynZZGcQaLcrN2
VBglwI9jGg0lhGkcshz6voMmCQTEl/c0jU7jwaU4Gl6DJIi/EyM92j2NXdaf
PNEsTYKncR15jLXTWKQqSzNeLBlOnNKNNIubxvuo4ureLySDOctD7dOy09jy
Occ0n3Mq/JHeGy4oNo3HY8R8nn5IBaSf8VPx4jTmO3D/He9QKhxJmpSwPzqN
ndQ1Bg4qp0EF25PTjVNTmAU51SWdSwcGDodB96gpnF2Z7VEw+Q4+8r4wHx6Z
xDHStg0JvVnA2mpYdrF7Eis6HFe4z5oNIY6S+541TeLUp0Nt2cbZYFI7/Y62
bBLnLF+KJ05nwwl9lSG+sEkMUnYDVtS54BbJdNdRYhJXohXzAJU8mBafyfj6
3yR2PnPLPel1Hmj316zSnZ/E2RQuR83xPBC4+Cw64eAknq6zjInzyofh2s6m
b8MT+HN05kKLQQEoERMUDoRO4PU5sYPoQyF8SnwWo+U9gWcXnoeadBUCu4Lq
SKLjBD5qN/x8ePdH2IikeAoaT+CUVHqtft2PkHfRuEJbfAILjBnITR8qAmaD
C8IpQ+OYOVH0RPGLYhj4XsgmJjaOv63GEhm/loDrbZK8BN84nkTU9nTLJXBi
SMZMin0cX2k+euwuVymobTYXIoZx/Iot4TwptBS+Cs3LKY6P4TfiCdm3jcog
OYnX5O6rMbxbMDat6MQXMH6eluW8NoqFb7mw3Gmogm2amUbX2VE85kFTUbQf
Q3yM0JL78CiObszzs76OoS3/m5RP0yhe13haRV+H4er4wO/gjFH8WylAY/Lh
V+C4fWY+QXsUm5vXl00+/QZjfC+F8OcRzHxT1qwipwZ43d/NT+aMYPjce+7+
nxqwav6UzZQygqWyHVklt2qAaNPB/ih4BKvQvbPKuVUL+0uOHzloOIK3/70Y
tF+vBQHZ+GUduhHcfrla+ZPGD3DRSipe0x3G0UyvXd5K/IKvGfnWbOrDODVM
fOaU2S/YQ8R8yteGMXPnrfiu178gLH4w/a3AMOa5d2KSefMXJA+ceym/dxh3
B7I9jaqphx9m6c+i8oZwYrrW5nv9BjjsniXGv2sIOzw9fUzpezP4f+auY1wf
xNI04w8OkZuBPP/+3vLsIHZNE1UPON4CwwYZrqVdg3j4Pa9hz80W+CibVi1X
MIiZTH9sN5W2gMbet6p3DHbsL1lsT79shQsnzzVSuQzg+dw7c0kP24FPjMD3
brkXuxuRVaXUOuERv4dHWV8vvnldoHTerhOSuA61Nf7sxVy/ye5VsZ3AdPyS
49qbXrxyl90jf6AT1tetvinK9+JLF8hv2qy7oLpsXms65h8Wqc5tXY3thrvS
8+6XxHpwmS/H6G3iP/CRn2spc+rEBywXD1x1HoSjmnkR94634T/ZkjfDo8bg
I1dwucLuNjz2JtnL6t0YqJFMRwUJrXhWPZnteukYBCWek9j/sxXPXYgjEvrG
YHsyZqDcoRV/LD4WR+Eeh3E3F/4zHS14n01DNHXVOFjdioyr5GnG7EIZ0vbD
E5C5ojz7clczTjN862W9MgHDr/fIWHU3YXvIIRvTTIL2qOPE2cAm7PGMZoSH
dxLgub6Y52QjfiwrOCdlMwmMaRf/yL1vwCbVcTPyW5Pwce37oTqOeqwXURrW
Sj8NYdmp1Yj0C5+8984vnWUaLPQ9nn1q/IXvll/5ZXJpGjh+SPxLdfiFh/Zt
P/ioMQ2vXuZkuNXVYZ/oTD6ruGlwFomUFrb8iUs+TUXLsc2AnO19i8SiWkza
CLAhs87CWS7Js0df1OI6CPUVvjQLG91HW4Pv12JBZoOXmmgWimWbxZ7vrcU3
PlYtqdyfBa7DctSad2rwoaNxz0/EzsL+gguv6Ta+4ft+nBajtHPw7t9Y6JRv
FU5ze37j/N856HE9lvRWuApzTo2yXRmcA4azigXqw5V4ODns1uWZOXAwzGwr
g0q8vfz88izVPFwbMz8eRP6C64wFF5gvzsPkPCGZ17oM5/jTfzV1noczEWwf
+8+W4YNh6/u7fOZBTVC9JqqxFD965NPNFzoPpXYfx8i8pdjnW+NLn6R5CCTa
8/4e+4zPfW/IGq6eB15qcpGFbjEePdTIr76HAPppvN9Z9xfjROe0j1v0BIiS
1+1oLy3CZ2dP8oceIQDZv4J4+VgRfs33uUiTnQC/6T2kD7QWYoqacqoPIgDV
h3zVrx6F2FghMFBBgQAiqoMG9vyF2O3p469TNwiQECHr3RtcgD/mX27uukuA
Lt59YfdC83C2jsKDWzYEkHliVvBt+gNublEqOedIgMz8+jYepQ/Y9xxN3V9X
AjwXCT1Ops7F1eMZvcMBBDiFmFLinbJwYrI/Y3gCAbw97WqoOzLxYtOW35MU
AsxU/xkzF87EYhePXf4vgwAVirG8l+czcE25JJ9aPgH01M8U/3uQjv0mbD6z
fyXA7PKq5LPaNCzPpWS0VkMA11fNmIEzDVfkmJ/O/bmz/n/ev2XHU3Dzin90
ZRMB+Nzvq/+7loJlpVSlT7YR4AubWKf9+2SsxLvVqP2XAMW/277fak3Ewzx3
PBz/EeAPo3+rd9RbzDLkHKbTT4BlLcm+T7cTcOOYoxHrEGFHjyatnO54jUvf
JgurjhNAnfM21a3YOKx7Z/V86SQBrM1pDnjfjcXMH5+V754hQP6K5fnJnhjM
dHj3VyAQoEmS7dLphGhsMjHHLrBIgHn3dilVvSjcd+XrEeplAhys9b/mdTYS
bz6WC/20QoC7TPbpj3E4Lp2ODlJeI0BsQs+XJtlQ3OZxkfbbOgE6uGTbRWqD
sIdU5/YJEgGYC99Px197gR1eVjzRIBPg9mUG6l2//LCu/121Jxs7++W7/UnT
Gz44OMwjzWyTAC23/gk0NnpimXq9h4pbBDhb7BPxKNkVn9p2iKDZJsCbOjUs
9M4RU6VlcL7f4RN9LPPbWbZYf4GVnYdCgIsjfyVf6Vngb6NPfEN2mOuAdSy/
qRFuu2l3o3WHPf9w/zldo4Lf1Zk7rO8w36E+873/icCT5vE9lB3uWPROYiTe
Bb/C1rWJHV64dWHpqe0j6It7cvPjDrtEX6u3ELGG4gBNGv0d3nZ//ibp0jOo
0XLinNlZj6d5rmU7rzPk5bDn3Nvh3doD0rRcHjC8uRKXtRNPDVtgwFtGb/jh
MbnQsxOv7yt2a/EwX7jBofppbicf1w5U3G2lD4CuF02TQzv5ovXWkrUIDITY
ObOwkp181q3P8+ylDYHjXE5ZVkQCBD15wZTkGwa3AzOlaXfyn7EY4XbGKwKY
B3fd8lolgKkp76PP21EgdYtCPrlEACV2Rx0f6RjodTVJklggAHdfjaqa68ud
c9fpj8Q8AaY19MSnSbGgGzRB2z9FgPqD2RdLJF5Dq10lk88EAXLq1lh9HePh
tLTIT7oxAliiiH1nVxPA17TwesUAAVRIvZvTwokgwzXONdlLAP5insUS2yR4
LX6iYbWbAMSYoVluYjIwNvpEfG4nQNl+l7/Vz9LAJjiFuvk7AZL/O9qez54O
xHGT/s/fCOCvlt+S0JwOF31O+7lUEkDz1chvB54MqNbJs3xTvPN/zt2s5u3L
BFNNsVviO/XbKT+OjwdlwaQ+Ey/tTn1XmXpW7hHPhv4iNdXiVwQI/lBc2h+R
Ay8+lZRnBO/sD0mW/Cj5HZ3XcF9o3o4AB+6X5Hos5oHsC62H2U926s1dPdsy
MR+4cz46y5sSwHC4WuO8awEwc5tlM+nsxMe9rrL1txD0hTz9T+6cZ7+KDOQL
A4tBy/DfqXHKPFz5zldzYbAYRnKivYPX56GggySbKPYJzrOOaDMS5uEVKRqC
Rz5Bb+enT6V98/AQ6qRMpEtAkEHrWUDZPFDqBQRPLpbB21DTYHGLebDt3coP
VyyHHurZkiHDeRifq+enSSyHwlt+8ER7HhoYTfiWlb+A1Ok3k9yy8xCv/fpC
Y3oF3Jd5ayt2dB5Eh3ed9bqLYdJciq6+ZA74y+8sCmRhuK09PmGROwdcUR9q
B0kYFDr3HVlNngP6lFzRZJWv8KpsuakycA421e72Uua/AvkchyWfzhz0FeTz
YMFqsFA8Y/VmbRaSrPVrpUtq4XH0lTOfzs5Cwn26vJcDtbDs0V7lzTgLcUrF
sXO03yH5MN+xK9SzEMG23+Lt3e/gXm7jajs2A54tnw5vkb5DYSW10VL2DBgJ
HDSouPIT3KJzWwyFZuD8wheSVPUvYHS5zH9YZBpcG6/6rsz9AtP+o3My7NPQ
kf2bIe9kPehG+NboM05DkMm/8+ds6oGaqi7EZHYKFnrIKrRsv6EoLf3Ju7Qp
qPoumdru1gD6Zm8jWA5Ngc6bEmVLyWaobzZ9avFvAq6ndTeq3m0DJjoH+gda
Y6CgwrR79VMnJEYUHrgpOwhhRnSLpF+dcDGT7m4J/yB0PaMa2O7rhH+KezW4
zwyCeeJ8+T6aLqB/YxwqPj8AYYR62zPaXSD+NfNjrM4AdEX6DF9d64KlL8wG
baL9YN6x8i1KrAdeiO8KTl//B+EGnZ4CJb0Qp1Uiu/qxE/xnr8B4Qy+QzzbR
mIV3gvvz1K03w71gc0zXd92iE6yinzjTMvSBin2AkglnJ6j+3G3f/7APJDY6
BF+87gCGSwKmIUz94Jl0yoM+4C+Ebb9QmXwyAFfGWfmnHNvBP3iePtFnAOa7
w1XX7rSD+wnN+tuvd8arJenYJdrBSohVEdcOwI01n7S/xDa4UKTD9vvgIEyb
Wmblu7QB7cTCydSHg3D8Tiw7BLTCT1WWg2pMQ/BBc+/ZB5bNwMw/dMz2zBDM
GXyhnJJoBsOD79hiuIZARWb1Iv2eHT39m0+kS2oIuARf+cckNAHf9Su6hg+G
oEjS99DNlkaIuKqbZV08BBbnFX005BpAR+K1QqT2MFz4rJhbrvYLMo7r3Soy
HIawsQP/PM7/guU1tnt/zYchFo1yuK3VQcinTMuTHsPwOsO9h/VtHWCh0uiU
98OwJDlhvGfuJ3D81zlUSByGUOnuX1dif8DcuaPubfEjIKgk3DPOXAsSLik2
39JH4IrGaeVbhBrw/vOfSUHeCBw/Qq8486sGjgVcuxlWPQJTl254VnrUAJp1
PKU8PQIZExf31s1VQ/jnns/fJEdhWuxP4/32byB4I5lQ0DUKWrSQqh+AwTWd
byRpeBRWM6SZUpQw/Ngq7Qib3bEnxXfI7fRjOgWtlZZUY0Dz0vRKWlgVeB/d
HcLNPQaX/lV5Nr+phPYBE+5kxzFgcYkPifn5BZ7ZXzQKPzYOURdd9hYYl8Kx
/YQK7XPjQBkNNZzjLYXSpI8nzvKNg4Ysv3n4Tj+5WS/Zkis7DmlVw/8ofiXg
fU4J6i3H4dpEtpl//mcIa3rIsrdmHGQCjn6sZ/4EAg+5nzc0jgPXssZutpFi
aCXN/InuGoehZNeL7YXFwMxpF8I+Pw52WXRy6mrFEO/itQEnJ6Bd9LRScmQR
ZHAndjs/nQDnaHXJC5wfQanKSFTOeQIUVGfVOEmFMHWbM5LObwK0hDVEnBsL
gc8jVykufgK082XiuBwL4ePf8pJP3ydAXfvdI7emAqjy7ny5cHoSiLH0sh4n
86Gzl1HjUd0k3LYoiSG+yAblYJMu+7ZJ6B+7yux8PRsqJMv1fXon4Sj9V1bn
/dmQ/OqBRfLCJFjIv6dZDs2Cx2qffXtOTMF8hPHd4vhMINfolqiaTYErvSx3
V30GWNoWSOvZTUFkXvF/81EZ0M+2t9bCbQpCxBqjHHV37im3vJYXkVMQVTNU
MTT3DoLFd01Xl+2M75d+QnXiHZzJyTgjvn8ahs0euDd7pkHYvY1UBeZpoGFq
WPp1Kw2o9qnxaJ6dhu6YRTIfaxqMPiSJ2ghNw6cCnvO8OBU+nL15K0dnGvR9
Ax3nd6cCilr0Ys2Zhl/fCesHk5PB8PmVCdqbM1CsvnvM/koC8D6s+zuvPQNh
YvwK/2bewLKqZu1foxn48Yr5+L6EN+DPYZmS5jgD4kcH6PO34yG3+Y0upM3A
rm0b532Nr4HEudHsQJ6BPlkjxpSQWKhmDKjS2zsLFR6PX1YqxkLIBtMH+Z1z
vvPfObnA3bHA1sobxMQ1C4RAVTdut1dwzVVHPk99FrjD++oMnF5CVFtZ6Vjm
LGyWbu/3Do2G+5UK7xuKdnhjBeY0ooEzs/VlUdUsjCuEHF86EQ2lblO2Xn9m
wdT3e0hNRhT0c5/8j4VqDtK3SvcZ/4oEXg+nFM07c3AQOx125ImAmoviQTV7
5+EozSU3g9dBoH9JM23x0DwM+tUEmN8IAqKQTQXrqXl4l5R7VGY7EPikcuZd
+OdBADP0XH0UCDFKrLdF7syDjbSsnTu8gEcmtGfeZc4DZxlJ9OZRf6Ay4xBt
/zgPtFcy08Xa/SDeUlZ1V+U8PO7/d7010g+a7Fw89VrnoXbf2q7Dh/1A3Jsw
epQ8D0Gq3XLhx31hX1LnB/+dPieiZllf4qo3pKau/CjWIkDYsas3bOi94UrG
4cFhAwJQ15XXyP3xAusPN5jAngCONqs/s0y9oPsLdljf0TnkZ9cLjV56QnbX
e3i8o+Ne79PzenPMHRR6a+++2tGJ9keST/0rdYMFwoKE8a4F4NX96H7uvhsE
LR/UiKBfgFP+BytL37lCFVnRd5Z1Ab49CP3YIO8CXHQVk+lKC9As2FzuUOAE
Sz/5zVNVFkCna7Ik6IETVPmnzCRpLEDb6aNXHI87gfaegPn4+wtQNdoQ0+rl
CH4U9ZUI6wW48fPZCw1DBxhdnaC4xi3A46690fVy9lBQrOPl/HYBzv/RkXCk
tgdXu0Zqp9QFYGC8f7av2g6YFz/utctdgGen5YwbFezg6qwbvdnXBfD9To4+
qGkLqcNHjmtNLkACiZkqIMIarFL84zTmduYzt0pb0bEGKUPSSbWlBTBzy6Cl
4rKGtr7+Mzc2FyD2rL5+u8tT2NWdxS7LuAimdEy7y6aegGEz8P8nsQhb1Qr/
OjbMgS/sYz6v9CLUfXcfJKaaA/EmpyC33CK8TGO4zXXDHMLr94ucv7kItb++
6MUlmu3oib+SJw0X4bZTmF2I+mNgqbBQ2PtiEVqiy8YfjJkA80ky2Sp0EVx9
gKHppQkccHhR0BW1CJ2Xj9rIKprA5qV3p3PfLkL3bfcE8Q8PoSetf1GjaBFo
W8Q5D/o9gFfB6onJ/YvQMJ8b2WZkBGGTA7f3jy7CcfFUoafnjMBPwYrOfmoR
xvjd5SeGDMGeEmSvuLIIJa/t5A1MDEHDrlZ5nm4JWpwHZ1Vm9YFBV3z9sugS
pOW/2NPzXBdoSr/nvpNagufdxjo8TLqwxaxpfEhmCWxv9vQP5ejAbJN147Dy
EmQdKax2HbkH9XLZaYGGS7DFeahq0PguBPCyqHUGL4HHrdldVYla4B6Qs1c2
cgks5m2b393QAodRyS/Zr5ZAMuKr0ieSJjxK1OZyT1mCk07WRlfuaYI8U8Qm
R8kSOPNVmvhx3gYqMnWW7fASnPpt932VoAaGI93LHhNLIPaq3PXIRzX42lCA
QmeXYP+sC8vuZ2o7ukb/z/u1JXiw/+yuBPItoMiXU3r3L0OEhyRrPL8qbIfb
aCsKL8MXFu7HpX3KoP9cKUVTYhkynNqfzD9Xhipj1lkj6WVwL2y2dDuuDO6i
jV6uisug1X333kvt67DVw/2hUHcZakfwS4lRRdjkHNx9xncZhgxq4polFeD+
oRJVnsBl8JhQcMqfkocKYuhrsbBlyKYcD8yKlwfX35cvqcctw3b3Gbp+ylXY
sI7V8c9dhq34SYWJDjkgf1EtXPizDAtjuYKRxTKg845zc6t7Gewhw9HdXgbK
wzav0Q8sw39U94LVRWXguVF2L+fUMlBIN6Ok7ACINDT7dLeWgajb77sSJw3r
6pX63zlXYEJCfKZSUAq8u/P70MUV+PVI+bh4jSQwGKXeLxVYAaldQjom2pLA
ZR2gk3N5BWKKvijUeUmAZpi6dqT6ClQ5tBzanhGDwaPyf/ffWQGFNasvz4LE
wOKtmKbv/R3/gvH1trxi4J17WsPRdAWEuARzx61EoaB+TEXPbQUuNVwsO0Mn
sqObuho6vFdg9LiLOFeRMPzsrr+h9mIFknr1LgTpC0P/ZP71q9Er8P10uYhK
mRAcoHVW4MlagUMxHpli7oJgdpVBevXPCrRW9fDv9uGHlXqqCqueFZi98siE
sPUfeGosS00OrMBr07trW87/QZxRl8S/6RUY5/XIM3Lh2+m7U0W+Ua1CcRpS
fhTDCxq0L4ukaFbBj1ZaN4CVF/rCAoSK6VehoE0oLSSXB1beWgq8P7YKbBPu
1VwN3MBeIcYXyrcKlbSXxNvZLkDeVZ4cGqFVcHQ4IXOrnAskf5/m9RRfBTV2
l0FHLS5Q66HitpNbhaCg4NHiCE5wJ9afv3d3FeptOmf5TnHAPxGD05y+q0Cy
DLjw1+4cPCKJHvILXIWFu0FXMrnOwULlgd1jYavAJ/2rtbKHDfYolk+nv14F
kSK5gYRrbMB/72g5R/4qTE2zMCrfOwulLLMffItX4VDbfvkDbSwgN1ydMlq2
CtcHXnruU2GBOxbWgem1q3BwV9mhkOtnwNPt912OnlW4dSJbvVX3FOyXS73p
O7C6o4dbCuzHTsJLmucyo6OrMKi2JnHI5iRkh3NxpxNWQS6jKWx/2AloT/Fa
P793DeyefmO61n8MuH6IvzovsAZeT+7tf9F6BAqCGIJ8RNfg1pXWan7HIyB1
a8xtRGoN7h0QY7p/9gjc6ooySVNYg0dP5GsFbZjAaXpO5LzuGvQZi6Sd4z4M
1Pm13D6Ga2AjYPRas5sRQu3enBkxWQOOSTfGgWBGSN1U2pNmvQbmtI8u/po6
BL8Z0tvZ/ddAh3HzlFTuQdBud/7pHbwGBQnuB+bYD8JgrPqX4Yg1OJ2VarPx
5gCssFFSU9+sASXKoHT3S3o4K6xjy164Bv4ja1LlKXRgfYfxMHvvGrgybBgv
s9CAcealeM6hNaj/OPJuT+Ve0CKpnucZX4MElkbabL29IPUmVFRgYQ0Onvxm
Fpe2B/YO7NdBe9aB3uPKXV3Z3UC8xDsiS7cOp67XpzycpYZpz+uWCgzroLJO
+d0WRw0t7C/cb55YB8YymrKfq7sg/tHeNB2+ddilo8LqjqkgpISDT19wHUpn
B/eceEYFHvvkPxmJrcOU2IfK2YtU8DDb++djmXVg+/yd5ZEUBV2ap8w4aK4D
Z3busO7pLVT7jCwS7boOd1L+hHXKk9DnHyerXnmtw59hYYNj7USUdVxSMd5/
HXa/cXon/YCIwsoc76VErEPHYn0WV+A6ure14pafvg4O39JDIqZX0U1VZtqi
rHXwaegQkglYRShJOOJz3jqQ6M+ZvOVcRRyytqmVpetAU6BNo2C6guZ9CT9+
N6zDzBbrqfCtJTT0l0GtuXUddESaZBcyltAfLv7uto51mHOL+lavvoTK6ixn
ugfXoV6X4tues4h8D0wfmlxZB8mOJq1w6wV0Mmb07h4WIpxUiD2a8XQWSfiw
HrNnJ4JdE3qvODSDtG112kcuEEEqqbs3SmsGRam1qNQIEaEy4cDaqsI0OnCw
Qs5biQi/jTp0MuUnEe/mGmVRhQi5+n6Mt+onkNKMYKXRbSJ0BXjQyGtMIL9f
78Vl9Ylwioc7ev7xONr2i+ajsifCAc18Lp6CUXTmWdPU0+dEGMmWCzmvOIou
P6R7P+BOBB6lY0/PDI4gJzmPcziQCDUXWgmjx0fQ4rb5MfckIrwcTDHoejuE
Rh3lqDbriZBnnM69i9iHqE3dKi1aiDD/SOf6T70+xKZd6vzvLxG6/+tR9f/R
i/RE+FfLB4mwL5LeoCT5H+pYODn9fI0ImS5dt584dKOVAc33UxtEGE/4/dpz
qQsdaQ5/eG8XCTJCTILO23QhtQ97ByQOkEAzKeDw5LNO9MtssX39HAkq/ntC
5kj4iybv8kWaXiDBruxdt55c/ItolExVO/lI0BfosjhV8QfJcfXVfRYnQQuL
zX/a4+2oYriu8pkKCS4ffH5uQL0N5ekmv192IkG8Bepqp2lGIp3nyTTuJJi2
rh19+6QJfdF4f/OUDwlIvzP7UGcjqruetygTSoKRjJbrbR8b0Ih4xeWwFBJo
5Y4TRgLrkXkRhKVkkCD/wpeifTT1aIG/ZrA4hwSmT10hzfcX2uas9/v3iQRh
5T0zBwLr0AnmrmbuehLQ+PjU+Hz4gRLDddmvNJPgKd3VKK4rPxAn/YD9rT8k
uCZ533K64TsSoh4/6dBPgvDfbdJ5K7VIZWH5Qc0SCTydmK3O3q9B3g2HiHqn
yVCQ8UpwzPsr2qcUrWzDRob00zmcOpe+ovCaY299Ock79ZxxqqEco4RyFrmc
S2T4k3lWS9m1CpVkXgwhXiVDMEtBySJ7BUIc+f3018nQyU10Lov+gmqThARZ
VclAGisyA9ovqO2VZIfCXTKkrSxYa6yVoVlfRbZoSzIoNP6+ILVcguyofttm
2JCBqrA445VTCSK7qH4vcyDDlf3s19WoShCtnZb5oCcZXiiLm+Ud+4zYjR4U
//eSDM8WT9BN6RWjO9IeSnWVOxwiOhKoUoh6V8cPVVeTYUAxzilltQAZ56l2
fvlJBhlSdpNpUgGyZD37KL+VDEq6Tx9XE/KR965Kn1djZJB42Zn8wPED2lfO
cSNimgwC2XI5bYO5KNQ2hCmIQIbPhrsYuFVyUdyIboobiQycpYoXbvHnoLzv
5KqHBzcgOn/zKMvhLCTibuyvz7QBXk52YTciMlGZWL3K3eMboJfZfIB0OBPV
vn/de+PcBvyjUytKOfMedQdKkIVEN2At46vblMo7tEfVQXSX3gbQ8ollrh9L
RUE0/Ztkow1oaauyWSpNQYewQu3Kow2g1F67/f1+CjolcPT2pPUGtAclDzdn
JaNLTMXWzb4bQD336f7hwkRUXH9a4lfgBvwRWGN6z5iIpHx8KNVhG5Bq1XjG
1O4tkl/RCPsctwEyZ036ueUSkE7HYs7b3A3gnjxseXR3PBoMu2cXW7gBlft+
79d3fo1MFL9JRX7egIGCt4/1VuKQdWnEL9+vG1Bywdr1xkIs8o+/NGHxZwP2
yZ/k9qR5hQr1n7BLbW5AEs/RmuGUKGT8aYEledcmpB84YBUiFoWYD9ifpKHd
hIQ5W5uQxkjkUObM2HZ4EwIvOXvpUUciKeYX22YXNqHRSlB/gj4czZjTk5v5
NoGj54LB5p0wlPAtbFVUaBOe28gUUWeGom2rl7O7pDdhCKWZhd0OQdW/Unte
a2yCO3/kE9OOQGTHxtVBubMJzQLmMr8gEHE4ZrWa6G3CPyl7fbfcF8ifo6BO
8PEm5N6WcYgJD0A3PCo//3LbBLq9SzLxzn5o86/Mx0s+m7DmSDf1ftMX5fHV
fnj5YhMye5Lpvbx8EWNPfbpR9CboD6RX3o32QX9EuqJImZvwYMbz9J4OL+QX
rBtmkLcJXktGUa2WXkhsuD/we9EmxAxL6hP3eqG48DHPyKpNeGLorH0WPJHe
9JIVz59NOL0v2Xn4lRtikHUwD+/ehIiP85/uTbiir7Ekk9X+TbCPSwipvuyK
2BWo9L5NbcLMW9HmwwvOaDzp4I17lE34FXiPW8/XCcWuRVzDe7aAU8L7MfOS
I1JSYZbj3L8FdJcbRE49cETZ5FOSi8xbYG9Ebvmp6oCeanFfCOTdAqp7H5kr
le0RW24OO+HSFhC47frWW+xQG/Wls1qiWyDVLJm+fs8OiRSIHj0nswXzP3ed
3mdvi4j7r+4u09qCHOtA/YYf1ohpniGmWmcLvAsfMcJja3SxtYejwWALtH82
Ln+mt0b6sbbXBsy2YLrDx+14oRWqOZ8auNd9C0K+nNfQPmyJemmsTh3y2YLU
wlTpW7YWaG1KMufEiy3Q/5U+/7HDHHEXtDZcjNoCGaEsEdssMxR2ZRejRsYW
LN9883jK3hRlsjYm6+ZswXELrUVVwiP0jfq1oEnBFpDZir1jLR+hlTqB207l
W+CVGSAU89QE6WgZvkps2gIntgXmxJcPkL0E34XM9i2o2v181oXzAQo9TSwp
7NqCBBplt18lxujrUHh37fAWBNC0BXqMGCFOK3xmZm0LXGKQAFHLECH14A8r
G1vQcnjFf4xggO6K3EHbVNtg/UbMYk3cAAWR5w0O028D0YWpgemPHlrwP5sm
zroNoQs8IcOSumi/+bSwLMc2NL2Pm9dP0EHnVT7XKvNsw6ODZRfUqXWQ9hHV
cT3hbaBiD9l3s+suqkhy4/FV3IbTYlyyadnaqMP7ennozW3YfYHvajuXNiKY
HL0Rq74NM7RuibPvtBA73wfLbN1t4H8t1fEmVxMFlPbmtzzdhguu8F62RwMl
v8mU6bHfhshuPrNDlhqo3N2+deT5NhiFC+feotJAs/IHltd8tuGq+e+txUvq
SKP1shhL3DZcD7rxLFvzFtp/mf5bxdttCG8/eO1ZgCr6lt5z437aNiSQLw7p
YhUk4PTc6E3eNvy3IvJ7W/omYmAtCTn5fRsE20vENO2uox8v/I+X1W9D7sZS
RcFvJeS2pJV6t2UbxmO/7pXhVkKz31dKYv9tw1/7zYWwuWvol6XQyNGlbRi8
PqYrkSGPPDt2WX1a34Yh8bZ31izySEKmlai5tQ2fJwyPnI67ijKOWDPE7KPA
oVBfb+tYOeRb/kGSiZUC/RFm7YNfZNAVDrfaQg4KnPbJTjK7KYOWQ2/eUuel
gOaI78lgDMjYaOZhhCgFmD0L1gxYEJLZxxPBcJMCSdzjkXPHLiOiDfFUnjoF
eiokwNlICuX/+/lO5Q4FxLfGtzIKJNHZ/EdfQox37C8Y01rel0CbWunj+59T
gNZFXT5+XBQVYzubbHcK7Bn8oXritiiy4Lm6ed2XAowlwkH6NSKoZ3PocGA4
BdIIEfEjecKoJI1VmjaDAkf8GUAtXxBZHST8zMihwHTasexgcUHE5Vilca2Q
Aiux8dV91QIoRlnvsV8FBbzDK2Tnay8h28X46N3tFGh74EEc8udDvLrmZ9O6
KHAlatgspfYiGqqVzJLrp4AWMee9Oe1FpBbXVeU1RQHiIfGzr9/woH3UmdfP
EShQdMbuDZ7lRtjC8c/XFQr8e+340FaOGzn8vWZgSKZAQsJXSnTCBfR/77fh
/99v/w9+RtNi
           "]]}, "Charting`Private`Tag$17903#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwUV3c8V/8XtspISFZRRpEkISpy70FCZWdWtiKkMvvaVCiyQpJCJNmrSPI2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           "]]}, "Charting`Private`Tag$17903#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity (height)", None}, {
        "s (\!\(\*SuperscriptBox[\(\[Degree]2\[Theta]\), \(-1\)]\))", 
         "normalized FT of Gaussians"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 600, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "\[Sigma] = 0.25\[Degree]2\[Theta]", 
        "\[Sigma] = 0.50\[Degree]2\[Theta]", 
        "\[Sigma] = 0.75\[Degree]2\[Theta]"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.8, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.827914355752*^9, 3.827914405312143*^9}, {
   3.8279144353834257`*^9, 3.827914461225953*^9}, 3.82791453380414*^9, {
   3.827914853706668*^9, 3.8279148659248333`*^9}, {3.827915316733615*^9, 
   3.827915330834592*^9}, 3.8279155213763576`*^9, {3.8279155595551386`*^9, 
   3.827915599121584*^9}, {3.8279156414799986`*^9, 3.827915661531643*^9}, 
   3.8279167121892786`*^9, {3.8279168959781213`*^9, 3.827916943999691*^9}, 
   3.827976012338887*^9, 3.8279763305187335`*^9, {3.8280891083119936`*^9, 
   3.8280891231551933`*^9}, 3.828089199433967*^9, 3.8280892731060047`*^9, 
   3.8280911926782093`*^9, 3.828091816184533*^9, 3.8280928628553452`*^9, 
   3.8280929172585335`*^9, 3.8281057747746487`*^9, 3.828106043979413*^9, 
   3.8281061559134502`*^9, 3.828155390603956*^9, 3.8281560248468137`*^9, 
   3.828160051878046*^9, 3.828161195902402*^9, {3.8281613041663404`*^9, 
   3.82816132755086*^9}, 3.828161462075032*^9, 3.8281616562345843`*^9, 
   3.8281625844039373`*^9, 3.828170845914889*^9, 3.8281710351055923`*^9, {
   3.828171068751646*^9, 3.8281710852613015`*^9}, 3.8281712713498344`*^9, {
   3.828171786226082*^9, 3.82817181632491*^9}, 3.8281737288578367`*^9, 
   3.8285021569489493`*^9, 3.8285034854260454`*^9, 3.828579452659851*^9, 
   3.828581140838068*^9, 3.828583057431798*^9, 3.8285842464033737`*^9, 
   3.8285915786566625`*^9, 3.82859161600954*^9, {3.828591675515428*^9, 
   3.828591722049876*^9}, 3.8285920952361007`*^9, 3.8285931222945013`*^9, 
   3.8285934362641215`*^9, 3.8285939806777525`*^9, 3.82980036249922*^9, 
   3.8298004942869635`*^9, 3.829807716610837*^9, 3.8298091916446743`*^9, 
   3.8299651393368187`*^9, 3.830585921263832*^9, 3.830586010935996*^9, {
   3.8305877108868856`*^9, 3.8305877385448484`*^9}, 3.8305919258539553`*^9, 
   3.8305948044941254`*^9, 3.830595015642914*^9, 3.8316164671215525`*^9, 
   3.8321437382505507`*^9, {3.8321439094148207`*^9, 3.83214391903115*^9}, 
   3.8321449566259317`*^9, 3.832145068354932*^9, 3.832145177770802*^9, 
   3.8510481421674476`*^9, 3.851050175453353*^9},
 CellLabel->
  "Out[142]=",ExpressionUUID->"10213499-4fc5-4068-a108-dfd0010af1ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Lorentz", "[", 
      RowBox[{"0.25", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"Lorentz", "[", 
      RowBox[{"0.50", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"Lorentz", "[", 
      RowBox[{"0.75", ",", "0", ",", "x"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2."}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", 
      "\"\<normalized intensity (area)\>\"", ",", 
      "\"\<normalized Lorentzians\>\""}], "}"}]}], ",", "\[IndentingNewLine]",
    "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Delta] = 0.25\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta] = 0.50\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta] = 0.75\[Degree]2\[Theta]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FTLorentz", "[", 
      RowBox[{"x", ",", "0.25"}], "]"}], ",", 
     RowBox[{"FTLorentz", "[", 
      RowBox[{"x", ",", "0.50"}], "]"}], ",", 
     RowBox[{"FTLorentz", "[", 
      RowBox[{"x", ",", "0.75"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2."}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<s (\!\(\*SuperscriptBox[\(\[Degree]2\[Theta]\), \(-1\)]\))\>\"", 
      ",", "\"\<normalized intensity (height)\>\"", ",", 
      "\"\<normalized FT of Lorentzians\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Delta] = 0.25\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta] = 0.50\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta] = 0.75\[Degree]2\[Theta]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8279157698406734`*^9, 3.827915858486621*^9}, {
   3.827916645311453*^9, 3.82791666591105*^9}, {3.827916948251337*^9, 
   3.8279169493705697`*^9}, 3.8279763022367516`*^9},
 CellLabel->
  "In[143]:=",ExpressionUUID->"0e748121-2d77-4824-8368-30cae420bf84"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1mXc0FX78xqWEkpa0ZDQkqSQlSc+3KFJmkVJGQ0IlEUVI0jTSNVNkpew9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         "]]},
       Annotation[#, "Charting`Private`Tag$17986#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1mHk0lV/Ux6WfSAiVocFYMtyIZGiwkZQxQ4bMFRLKkCGZRQmZkiEydJEh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         "]]},
       Annotation[#, "Charting`Private`Tag$17986#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw113k0lVsfB3CRawy5qQiRebiueaj0i0qllGQqSnQjQ5NkiExJUUkikjEl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         "]]},
       Annotation[#, "Charting`Private`Tag$17986#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"\[Delta] = 0.25\[Degree]2\[Theta]\"", 
       "\"\[Delta] = 0.50\[Degree]2\[Theta]\"", 
       "\"\[Delta] = 0.75\[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.8, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity (area)\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"normalized Lorentzians\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1mXc0FX78xqWEkpa0ZDQkqSQlSc+3KFJmkVJGQ0IlEUVI0jTSNVNkpew9
80H2yN7z2nvce83k/vzO+f3++pznnOecz/PHZzyv8xa6+VDjDisLC0v+MhaW
/10PgneIyWSS/iqjZAY3BQ/ndr2Zm2cSSVFrVtFNFMQmHBamTzGJ16tpsZvb
KZAQUb7ZN8wksqIXdrfspUBqvVNzWQOTPGgcLh//j4L/uidLfGOYJMblv6+h
jynQeF0ecUSPSYZerlyp1kKBVYXT/btZi8RW5rza6kRP1NauHsox+EfW+v+o
tkjzxo7shzxSfAvkrMLs/pOdvkgyyWNb2zZPmpcVDSco+EP/w+GJJsc5kvto
z1iSYgBmPWzeEMySC+KWHcny3xDM3b7VhzpNAgNPb+q5HAx/pcPmNW+nyL0N
lVeXZYZi92qlkkqnKSKtsXWmJD8UEaU3d/6xnyIe4TX8nytCkX6RUl1kOUXW
P4vZrdodiiaVGYksgykSPjQeuXJ1GHgv/aKHS08R+p6FllSdMLjpnLe0G2QQ
sZMx5pdZv8PR1MB633kGWciN8667E452V13/dDkGMXudl//APBwn4nSyL5xi
kEt0qvd6+3DQpjQ5HhxhkJo/O1UtfMJhYK/kE7+DQTYGRfPFlIbjP48jqTI0
OjHvW8tglfyBxRS2WeXPdDK4tvaoKddP2Cz/aWU+SiNyxXT1lPYIPPDVXak/
QCO1a49u5ByNwM1DGz2Vu2nklOfO5Dt/I6CkYxsv0kQjkskvy7AlElsSVEbb
82jEV6ThgbVGJBJv0m9e8KeRmV5dDbbiSIzlnFTZfYFGvP04c9qzomDgULG7
PnyS3N7T9eZCZQy0mgJOtQVPkqmCGynXqTFQkjDT7vk6SSzWThjZ0GIg2bPu
A40ySbrmsgrMVsWCQ1GDzv1ikrxr8pHcdyAW0WvrchSuTpI/zQqvBx/H4u/X
Zt00zklyo6b9TevKOHj+6vXxN54gH0sjX6nLx0PX2s9O6s4E4ZWRXBapGg+R
I6q3q/UmiOx8csc6nXikh6ce4tCcII/uG8/MPYpH+6f3BY8xQUx3R04qBcZj
r/FhhhLPBDlpMapKX4yH+YH5rzSbccJ9zSM4Iy8BK4JvGYs8GifrL2xetKlK
gNeW8qO6huPk2vq3DxTbE5CxPLCsWG2crHzHWc42u+RvPjsfuGecMMLVRHjE
EuHl/FFTtWKMcGZ7dX3wSkR6hwhX5M4xwl6JOD3LJNieXBblt2WM6HAHJpU4
JkHWt0n5LfcYSTf7xH7GPQnZGu/cDOdHyQvawh/NiCQU5g9vEKoeJa+EuD5s
7EpCbUT0Vq8Xo0TyqCXHlHoyxqwk9zp0jpDejDhWIpOC2Fquogf1I8TvVlhT
lVIKHh3uNbpRNkJ26wwzaVdTwBjy/HkidYR8UmJ7oW+dgr83Zg5MuY2QB1sC
zg8lpYBDPl3SGCPko5rtWNGRVOxa99+Zy1+HycSu1buOy6TBVZz6zPjTMBGN
UjH8rpyGWTXHBIc3w+QSz7pLovppKPuYtzvKfJjEpRV5mrxKg8XG8+wrFYbJ
FK/47/bKNBTwapSljA+RO/kcZoEm6TDecVtr++kh8uWhbJR+XAZqZdncDh8b
ItTv+y4/L8jAKd2wQoX9Q2TsXuLduJYMbAwYOG6xaYhYpw1d01+ZiUzB+9vL
BwfJsdWPRduuZ4J795NOO49BUnmZfdqM+xfiRd8Yd3UPkOnDvKqsr7IgUKWf
tr9pgPwRE1nZ6Z+FD1bSHJZ/BohJbWp5Y2IW7uQNhbKnDRBOgSNifL1Z2KKr
TBVzHSCjvPHOY+cInn/coG11fIDQuiPKaezZUJz1P8vl0k/wMK13T2s2kr5a
UjQd+4m2e0/82GA2dp5V6f5q1U9mF50KCmey8fcj0+HwzX7yofzproiNOYje
fzNTS6qfrPQVeyB9MQc8enuPfKP2kfarVyLeZeegIz9O8NixPiJRbxedmZwL
20tz8sfF+kjAsembkfm52EL9796JnX3EXu/t8ajaXKgtVMSd4u4jJm87fnbR
cpEtMXZGoa+X+NYmmwmI/0ZggOgdba9ekrHwXXIm6jduPg3+8Wy6h6g6q/5s
T8nD4srhctuRHiInxy0pXJwHP4oEza6rh7z2t9B0bM5DdUzOiZd/eohZ1ZoW
6395kOvrKH0f1kMGj4rq35TPx+5LfGP+Wj1kyETUTq4+H71inhIkuZt0k+/a
+1cXQtQudGwgopt4RGX4zgsW4kFF0s8N37qJ8pqSvf3HCjH7qH6n4ftuwlEX
O77lViFWpWzeuEa/m3ReNwrtySyE+Gk/+jXOblIozvf1/JMi2GgGJE7rdBG3
BhajgmUlyA6LMRNU7yKaiuqsYdtLsGKWiCmd6yJG5Xw1P46WwNWvM+SLeBeh
22ltEDAuQWCHkKc8WxfRrj86V1BbgoJ7IZYe0VQifmy/29m4Uqy3+3Hs4DIq
ebFKJYX6phzOySJF62Y6ycmQ23zpoeWYH/t+lT7SSabl3sem5ZajSy/MNrWx
k5zZf9To0L9yxJ8Ozj0T20lkLI1kFx7/gQbbF5Urep0kTlVBXuteBfZuFSpn
sekgmZnuT56nV2LdO4GJfMMOMq/m9yGgtBKz8zs2vtfoIHtaBpObWitR1Lrt
6ibRDsJq2zbgxayEUSBP776mdtLwKUVS+lwVfu7l+Kch1U68/jzqO91YBbFj
42Kh9FbSVHHkhNe6GhgetLdPa2sl6zPMuPKFaxAgvLa6vLCVZBhsiuKVrcGG
zYespj+3kt+KTpd3GddgZuZBjoJ8K+nXyjo0mF+D3LQxzSFKCxkyd+PRd6qF
tuyY3aFjzWSIf8qpkb8eHkftquQEm8l5Rz7PLul6lB7g3q29qplMX+TevEWz
Hqf4DxY7tDeRnBmLwJUf6rGLeX9jtXMTeStoLz7/tx5j2aPfLRoaiefQ/jz7
nga8lB+tTLNuIM75drEyzU3IVRxRlbzVQKRnOuMT5pvAojz8J1q5gZh+tzbU
294MW83BsuCdDUSxIlTk0o1mPDHsLXIpqycbv+TwJnU3w+hNW7aBYD0Jjv++
ImK+BRfLymM5i2pJt5ELW9ildryrLDvkFF9LqCKK8ZI27SiqLY1e9K8lWy9V
3VsW3I6zbcWR9Ee1ZFvgzEktejtOjeWHt22vJdKeb49Pe3VAfF1WYNzDGrI/
g4tX1LITmy5Hu1/dXE34O7eZ5VOpiBd+n352eTXJOxyzZ9ssFWpzd3sOj1eR
iJtWCS7cXXj3Vej4qsIq8k6uP6pKpguLA5SO9CdLeg25UuHdhb7nNgf56itJ
/Nn16+M0u/FA9aPPr30VxIxfOk9vsAfx0/lri3aXkIsSD2qPPByA68+g3FNz
xeTrVtZ7DW4DMNG1t0wqLya7Ci1Of44dwO6C4y1BT4oJR0avkiNtAF6eEWHP
i4oICvjLcq0G8Uzyo+wR00Ly3Y0h+uP1EM6YXzf5mpBHvOqVujjSRsAvLM2/
6U0eMWNPOJrYOoK/TZuq3l/PI5yqh3aasowi8XTFsadseWQhRJh7UWEUwuvP
sF6+8pvY1h5fcG0YxarYvb6cf3NI+rhgxNOZMYS29LoMOmWRm/Y2vH99JtBs
yxvw5UgWkXOJPnLlxwS4+RVi1bt+EeUWZ/3vaRN4oh9enYZfpM5wXl2oeQLn
eo03v5vPINmmVevvbZvEwNh4oKhZGjlcqpUT7T0JPnfB+Hb+NLLSvK1kPmwS
aofVf3uUp5Ip7rc1h5Inkfo4vndeNJXIn1w1qV47ibezFqKlvclEzj/zo8Fa
GkRZ5xNMdBLJVvnQTjYHGnSDRfMFViWSSI6ILW9caPCQ16mvSU0gX4/ckev3
o2HeOXNWhjeBvFThuCudREPpantZrqo4MuAYmLJ5gAaWqBiVbPs44j3Lq2nK
oEFSpVPP4mAcuSZn3+7NQoe/+2nH1vex5LQess220NEoyuF61SWaGOt1qmw6
R8d/9+/F5gxFkdXhR+q41OkIjymp3qcYRZT/HLOv06HjqaTL5nnWSKK3vs+q
wYyObac2fPOz/kFqX8csvvOhw9Hh8W/W+nAi0mPvO/uNjuHc2l7jI+Fk1H8z
q0QEHZkK3qIyY2Hkwd5lhO0XHTfU+RJbboWQAFu/TYLtdIzQp6Qt84JJbQ7v
YGIvHbZeFYR7TzAZO969cePoUv4Wx9LTfd+IzcU/5vv+0iFmd1295dw3Il+U
ENu5jIEMwWMNFt8DCYMl8KoeBwOJpdX5qlVfyS2vm3vieBioXedc5ejxhWiU
299/uY0BuqZ0W9Ilf7LCTctkuyADEp0BjO31voQ2JPfXT5QB9T2XWFS9fchV
LvPKF4cYMDNeyeWo7U3knvygikkyEMMw3TXQTCHPTAvv/TnJwB9pwUPb/T+R
1kuBcnn/MTBmV3NC5YYHsW9yFHguz8CaPOdzL/g/EolG5bRZBQa0N1iEGBE3
InBBoOrYBQa8/Zsz/px2ISsi9fZLqTBQL3y6RjLvHXnpWeY+p8YAT9z3Ib9z
b4hKmOOf55cYuCTDzbqs+BUJ/LYy+bcmAx75FlvvXnhJxEuUd5ReYaBStUW8
vNyBJFnkt3+6ygB/4kt3w0BbYllxtWmHDgOfi9SIRKgV+dZqM2F0nYEtbTvG
Fn+YE6MvwlyWNxjY310n7XXDhIiYdm85o8uAMJeZ98G7BmSdUzl75ZJ2qBWp
3f5bmYgmUf7w6zEgtrbNmO2AJDrl7O8eXNL1k44B62a1cZRuXLW45J9Q3Ut7
aG4Id+nyte5L2ubTuRITSTNUBMSLdi3tt2j39HPAIUuwX/h1cGopj4NxpGmN
6DOoxO08ULyUd7lWhyy7sD2Mn4XL6F5j4Lfg29df1jnC2CXQIlGbASevnWZS
rk54ebFnulSLgXNcmdpVq1/jD0tFb8hlBtgdNU+bvH2LbCupe9BgoGhmbB8b
+we41BpFfVZl4N39NxsCnFzR6r2tO+0iA2GT7s/5XrjDuPMu/M4zcPeuqGHy
ogeEf81pBp1hQHGn1bWXshRsO7vGveQUAyJtv1XUbD0haCs3kXSCgSGNG1JD
c97YwzGt1nCYgZI1P/enHPeFq04Qbc0BBiKKpgWcrPzQwZ20wCHCgOkpdw7+
KX/kvtVIVd7BgPJc68LQka+QUv8p6rOZgYOJ+yZTzANwSZzqHL6egVkKdURk
NhDiFwO/87ExkLbKpi7XMhhCGVsXdAfpCDywqSZmZwgm58v2/0elw1ktptK/
IgR8PmduUhvpuOzVXfpkXxg+k1ZXw0I6JoQu5oq2heN6z/Mnbkv3t0G+j2x+
9wOX90opO3nTkXXX4dcKqZ94bvKs95QLHe+jElPb3SOw0UnqGYc1HcLSO2I8
5KPBI9KZuPwCHVzXUyLtJ6ORd3WARRZ00O3Uf5p+jcHPn8c9zxyhQ78rV2OX
bSw+V4uzJ2+j46DIjPK/ujisCbr3RqufhuIEPfm4t4m4fW7y8DlrGk7mi/3e
25mInR/3HY++R0Ns/dzpr8eS4BEU3DpxjQavuU94352E+zMbfnLK0nAbRSfu
yKaAPenBSBBzEswS8cNbJ9NAtV2Xe8p+Eke7lvG/0CaQOcwtdeTBBA6mX5kU
/0Fg+PjE+qobExD2iMrrnCOYmz+6eEd5Aqu/RR4NVM7Go+fzplZiE1hQ025l
jmUj2lnf4mPtONpiY/aRw7mYn6PtQskYAsx082SXenB3flTi+uQR+F/njPbs
yEPAi89i6z1H4KOY6D3Kno890mUsOyxG4C64yuSLdj6O6Vc/vS4xAofKpPX/
5vLxubZp4UPMMAzE1+hlnixE7Yl9PieihrBrImPuRG4xVnxRXSufNgDbcjkn
xmgxePal213yGUD9z1Lu6K0laPVfMHhpNYB3d1p2CT0qQcMm+uDZYwOYaJ5X
Zhcsxf7P51foJfUjK186qOZ5GSQEFML50/tw7XOKkql0BRQiiMeujh4kWqNu
z50K+LP+7U3I7QG3VqFeh3sFPDiVpIzDepCzrsFCY6ACBaus+hUf9IBHzkbV
/0Il/m2SCfnD7IZNqt9Tx/lK3JXQdZ7Z143zwU3lKtrVGJgP49H2o2LiVbRh
/v1qOHYVOK54SYWP0UumzMtqKMX6BtWYUDFw4MDhfdHVuPdYwbZJloo3qQ6U
5StqoOEfutWhuxNF5Xt1UmNq8C5uu872o51QmLUcEGKvwwjP3cPrqG0Ya1Z6
4cNXh/oQ35Uu6W3w+iWwba1EHVgZr5hnKW3ocyy+sHC9Ds8cenhMFNvgvGZH
TH18HXbWylRYJ7SiYGee5XvdehivWHPyGqUFZ5U3LJ9KakDHrS+zNLsmuBpw
Ts4VN6C1PSz8sUETGi1ZOhbbGuDn7PJbQL4Jxl/H0jlWNsJJbfzYHOeSf7zE
nE+rEdFcOZw/vRvR+PFll9x0I6an/DJL0xtgXM/I8TjWjLqV9Va6S304YWg4
xlupGWN+ccdq2OqxsNj1xV+3GTZBF1JNRuvgurfqaZhzMy6KSgqy/6pDgnXU
4fT6Zky95blGvVGHhW2G36hPWkBlXhOih9bCTa/BQTylFXN7nvhtUamB88hJ
9JW1wnn1iofdUjWwexr073NXKzZIBHtVCtXgwaf7z9i521BfZzOybroaKoXL
Ldpvt2Ek0Vd4V2A1uA+J3/2woR19a0uzrs1XwXXxjfLA/Q4IjZexeeRXwvn9
2OqvLztwtVxwvXRCJey2XC655NsBuWxjr7+BlXiwdPBIXgdOvTe6WG1bib0J
1wRL13QibddBkZyjlWDvn9gadLsTDkHX/We0K1CosmON2gYq+Lhe8Otpl4Pn
IJXXnI+KQnXC3yVTDv01oYIUYSrKcn86vxdY4qtSMcnGE1TUnRH9pNZfBrHz
J3X0b1FhceZWu791GdzldH6YJVKxa67zC2dQKa4d9z37UasLl9yXbQ7hLkHY
5huqCfpdqJac8nOcLgZ9WvBqnXEXhqWVnjm0F+NDUrjpVvsulG2hOzZFF4NI
pH769r0LcQmpWn/VirH7QAM1brYLhXrJczV+RRgV2mRX7deN1teTtb5yhThu
8+1RTkg3HtsEvTc7VAjH2gN3YqO7sdWy6q/e9kLwvj530TW3G30844/e0Atw
asRqm9JQNzw26oX8DSmAW3Jzco50D/7ufHX/AlcBDl8IHI9t7MGd1wetAobz
YBsi1h3Q1QMdDdZZxSX+LviXWu860oPfVvqTK5f4/Fps1S9Tll6wOljXkrA8
OG5a/kFEpBcy3315d97KQ03HHZFAq17MGbOxuXX8hqXFfgM33j4c5VJQUezL
Be+q8UwtoT48/eczsrw+F6kB8Vv4xfqQ45PuW5Ofi4US6crI033o1DMPjg7N
haOQIkpM+3A9R4lXzTAXrn9u72D73YcFTumTwsM5CBP52vTsYT/SN5uZa7Pm
QDHL4OiZZ/0Y9D+od4ORjcFLez5yvupHaQi1wbwvG2L2kYo+fv34vfktZ0VJ
NuLr0lOS8vvxo+VM1nlKNrIcGzwnti9xyfOp50dEs9HQuk7DsGgAcjcl3cxz
s6D0/k6jRfUAuE8sb+yKyEKmdLruy9YBZE09XmvimYVAr1smgRMDKFh3uyjX
KAtGaslOzVsGYeLDTX2/Lgvzv3VSVO4NwrOx8Py927/AFxHGJ7VqCLUWg132
fJlwvfo36CzPENLX7i6L58gEC4favsv8QwjdWESbY2Sg5/bc0UcSQ/DWWe2a
V56BKP6LqhHXhjAgU7tD0SEDpzwmXwhEDOG/A6kStIF06D892c9+cRgWBqkJ
wkVpEL1dVDemNQzvdJ0q6aQ00FUu59UZDMOoiCJsEJQG592m34KthsG0f84x
YpuGyIrPOggehty//T/GJdKW3oG/FU/mh9EqcWrQKygVHtVpqb3hIwjK7Hkd
75aC3/ul3v1mG0NVn0s3u38SdA9dDp5cO4ZN1NOX9VyTMCvxKFNg2xgU1TgN
fzskQexExJjNwTHI46x43J0kUBQFLkleGcPJPv1MIfEkGN5h5wsNH8NeSSHq
+cJEcAQ0RDlfGMfi3mj2y4sJEObMHAhRnICBgGaQzYd40AoPGgct/cN3b227
W/giHlnO34YDNCYge7ZMls8qHlorXo/5XZ/A59Hx2U6DeLxiqjPczSbQbbfg
XicVj56pfqbtEgdeSXpZfLM3DkFdGzdrDkzgBQ9Yys7FYUemyVm2N5MYfaMg
OyUYC56t8/MPXCZhtX13+YvNseB68ia20WMSzxLtnHi5Y7FwKHR75JdJrFFq
eRs7HYPm4PZJjYRJXEg25LOOjIHXe/Wvge2TWFy9bGxuWwy4daRmZI7SEDV9
76Ha8miwzLP+MO+ioU1TLrr6XwT0u5vo9ku9x/UXChzHI5BdFnvKZYQGIfek
CFlqBBwCdGu/T9Oww08zsSYvAkz5dGbrKjqmV0lS7D9EYNHtkZbCUq+SCnz6
pHxHBBb2dC7nc6LDiJ709q/CT8yo/9LN38OAwIrxaEpqOBybYtpO7WcgvGBD
XWREOLgNgq6nii/16h2zk3++hkPY7PW1CBkGrJeH9Yu/CsdlV3Wtj+oMHI8P
+mmsEY7Ykl7lG8+XuEBGbDZy7DvuyXHLTtUyIPf3hLHowe9okdTbvsdpCnU3
VOq3FYbCcO7o2ldvp/DyePd5v8xQTPziWt7rOgX7HSKnhOJDsUIhfSjEdwrc
3h8/nP0SioNXN6XvjpnC4Artf32PQ+HwvFR7d/MUpkx9xV7vDIVwgZTXLvFp
xN/2VuB+FQKzK+vW72ydhrxKpEnLjWBspfRor9gxC283fUU5y2+I1gn8Tree
Q5bdvXhL/QBckbVXLPo1j/iPH9a7vvFHnO79nScW/iK2gumiuc0Ps6vklqdp
/sPK5Ct8nmXe0KiSObbDZxEPqRdPeQ16YpXM6pzML0s6epQWSfVETkjzhevB
i3CTuzlY2OQJceunBp+jF+ExG+q2qsQT3AIpH7bmLyLml8L93J+eKDaV6N5E
W4TVlEDNnKkn/uPY5859kQnu3d+WPWZQMPtodlu0OhNU0Q1nuEYpiGkpDFW+
wgTz2gmjH70U8McYZny4ycTV6apr4/UULGiG9K16ysT3QheXH2kUpAQLyLKH
McGep1pba0/BgzXjhWERTGQVzByMsKZA2CpL41wcE7d5huRfPaKAonTD6FUm
ExfeGPjI36LAfNLv0/IaJnyaWb3Gz1EgqmPMH9zIhFfo5ZfdoICaJ/3jTDsT
hd8+bm45ToGaT2PWi0Em0isKROtEKeBgDT8vNM4Ev2hOSMMuCoiJVW02g4kA
1oiMNj4KntSd09OfZ8IwY9X9/k0U/N/8EP8/P/wf+vjbUg==
           "]]}, "Charting`Private`Tag$17986#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1mHk0lV/Ux6WfSAiVocFYMtyIZGiwkZQxQ4bMFRLKkCGZRQmZkiEydJEh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           "]]}, "Charting`Private`Tag$17986#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw113k0lVsfB3CRawy5qQiRebiueaj0i0qllGQqSnQjQ5NkiExJUUkikjEl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           "]]}, "Charting`Private`Tag$17986#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity (area)", None}, {
        "2\[Theta] (\[Degree])", "normalized Lorentzians"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 600, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "\[Delta] = 0.25\[Degree]2\[Theta]", 
        "\[Delta] = 0.50\[Degree]2\[Theta]", 
        "\[Delta] = 0.75\[Degree]2\[Theta]"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.8, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.827915797045706*^9, 3.8279158597063465`*^9, 3.8279167125212965`*^9, 
   3.8279168963792076`*^9, 3.8279169498499937`*^9, 3.8279760126514044`*^9, 
   3.8279763307844563`*^9, {3.828089108610833*^9, 3.8280891234660273`*^9}, 
   3.8280891998737288`*^9, 3.8280892734238353`*^9, 3.8280911930140285`*^9, 
   3.8280918165433397`*^9, 3.8280928631771727`*^9, 3.8280929175883427`*^9, 
   3.828105775100469*^9, 3.828106044315216*^9, 3.828106156232275*^9, 
   3.828155390923771*^9, 3.8281560251306725`*^9, 3.8281600521933804`*^9, 
   3.82816119623622*^9, {3.8281613044881654`*^9, 3.8281613278812237`*^9}, 
   3.8281614624063864`*^9, 3.828161656521414*^9, 3.828162584715767*^9, 
   3.8281708462007437`*^9, 3.8281710353944187`*^9, {3.828171069032504*^9, 
   3.8281710855961094`*^9}, 3.8281712716411676`*^9, {3.8281717865099263`*^9, 
   3.8281718166207843`*^9}, 3.8281737291476793`*^9, 3.8285021572787895`*^9, 
   3.828503485758854*^9, 3.828579452954698*^9, 3.82858114116591*^9, 
   3.8285830577266517`*^9, 3.828584246714204*^9, 3.828591675815278*^9, 
   3.828592095522944*^9, 3.8285931225733547`*^9, 3.8285934365429783`*^9, 
   3.828593980945621*^9, 3.829800362768756*^9, 3.829800494518754*^9, 
   3.829807716927286*^9, 3.829809191945455*^9, 3.829965139602191*^9, 
   3.8305859215621676`*^9, 3.8305860112100573`*^9, {3.83058771118369*^9, 
   3.8305877388116417`*^9}, 3.8305919261663704`*^9, 3.8305948047909317`*^9, 
   3.830595015924131*^9, 3.831616467355917*^9, 3.8321437386516204`*^9, 
   3.8321449568954916`*^9, 3.832145068655706*^9, 3.83214517804037*^9, 
   3.8510481424174533`*^9, 3.851050175578369*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"bbd8beb6-6367-495f-8734-e56a707fa939"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1lXk01vkCxqUcRbZQmSJblpeayBJlnmqMUq9dlzRCzcXQoneypSuJ0FXN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         "]]},
       Annotation[#, "Charting`Private`Tag$18069#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1mmc4F27UxwkllaTSMouGFA2VjG8pGkooMjIrRRH+VpSVKCsjQkQIqURk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         "]]},
       Annotation[#, "Charting`Private`Tag$18069#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1WndUD17cjlBCiEqU0lRKQ9KgR5GIpgqlqaGi4UehKBoiDVFIKm3aKtpX
aWko7b2X9h7f1us9533/ufc853nu5/5z73M+zzmfQ8Y2GqYbqaioTP4t/7sf
BdPw+vo6kZ6TTo7hY4TNEpfnEmWdGDxc6dqhyIjkVFHembl1UthkHR9uxgix
w8rGAyPrJObao8PXohlxYrdbS0XjOmHueGiw4TATTvdOlb1PWicefLP/PRJn
hsazyrhjButkW0LJqPBdFryWa70gpLNOuHeUvFl4z4K65aFBXq11cvbapOoC
YYG27Sbu/RfXSWc/r3LY9v3QvSYTTHVinSyLsgV/it0PkyOfX1bSr5MXM6oz
8SMH4FDldts8b410fH/w+XrYQbwcsW+czVgj83czImP+HEQ4jYXc09Q1sm2Y
cV6Omh0VUGb8GLtGhiTygszM2cGZzJhb479Gos+s0hEWDvz2i94ua75G9t9h
G4sf4wCvRmnc3l1rZFAus7/0GydOWmcxhtOtkSvmMR8H6zih/iLeWXjzGpns
HKySmOGEU4HfZSXKKll9Mt9qLsKFGrFry859qyRPj16aLYELj/YMK41krJIU
N72ZA8ncqKvbNpxvtEpqi2upczp48cQkPS/u+iphY/Ju37eBD0dn9V8HXFkl
adu+Xf3MxQfPPV9PWiivkiPnWCzNLPhwSuOq7y6pVcIqd8D/2gIfoqsixQ12
rRKq3Pxzlmz8uF92ynklb4UIlv/if/LmCHh0Bi8PZK4Qkx31aVO5R1Dz1+9w
ddoKKbpo6Ro2eASCW/v+RHxZIYO8c0ZZMoLoVnzBfTFwhagIlz/9OyAIpaKG
X+9vr5D34kIHX1w4CrYfNntPsK4Qro2mrZc+iaCC4fhdaeYVwhlfkFKeKYKH
ppTaUwz/9Gq1wdY1Imigc399lnaF0G2ccj+0SRR+WkEMGrPLZJe57zM5C1FQ
jxTuul2xTOY/0loFSYvhL+P+HRFOy6TUXLVObvkY3t3svBXtsEwG2I3Mk/eJ
41x2ZMXnO8vEQSNAU0lCHOGGwi+Tby6T28nCpzbcEcf1uLPb8jSXiUqCuc7T
EXFUnbbZ2iy4TBobR4O2DR5HulXh5p3tFFK2tc2AbaMkJDmsRaMbKYSD8mCn
02FJZNUx652qoRCVzzG796lK4scpqzSrEgoZVNEM3PpREmU7GW6UplDIFpVW
53YZKXSlGvx44kEhem3OLZ/cpUG3Qnk4K0whvqfthZ5dOgXv5MhoLwEKsdmR
+lDH8RR2marUcPJQiGbI0sf7X06B8fcnfvX9FCKpUKHwdqssOMLONyVsopBv
3mn6VuWyOH428Lh58xLpHbNKGDt6GoYvRSebny4R4vs4L61LDg/T/D0qHy0R
r5vRsXrLcghom2HNv79E2ETVNI8yyaNM8NuFWOslYjsR1a54SR7HKqUj7HWW
SO0dcSXjLHlsoT+rvUdsiaiazstbhpxBvK92zqXuRWLxs+P7s2cKKP7+XeN0
2yK5EHI1LjxGAd2d+/4ea1wkxsyHncdKFMAk0sp4oHKR2Fwp7t+z9Rycqw1s
/mYsEnYW43dx3uegsduC08NvkXBH8ZxVDFPEor+jJ8Eiufu02O7S2AUMsuYP
n5NeJDuUfeyOMyuhIXqL8m/xReLH8Z+IsZwSUrNe7W7nXySud1TDPQOVYN0T
E0TZs0gqQ62cGM9eRK9oXfzxoQWi5GPj6x9/Cb+rBf/E+S2QSd8MDr1vqsjR
uXPsmNcCEbmbJRX2VxVxfd8DstwXSMKdEeYP9GrwXJTX+fVwgQinUpklyqvh
DMe13gGTBVKksb/6T7waMmzc5w5JLZAD8SKZ55+rI4K+g+Vd9zxJWIt7PGdy
Gf66oJFqmydtzG3GOa6X8TQ2bLa5YZ6sh9AfTAu/DGP5G1UHKubJ1FaK6onu
y+C0H3IL/TZPtgjYSwcYaiK8fXoi2muecGe9ezl3Uwth8TTF6cfnyabZm5yB
4Vfgt3QzVVtknuhakN/MpVfgcq4sbEFgnjRvpazXjV2BYddLRymOecJ8zdmK
Wvoq2PcyiObSzZPtuS5d0vVXEeLIGlzYOUd2vGyltWTWQbCS6J3a53NE7baM
+rvK6+DeplRW7TZH6tgzSyUXryOu3Jjzt/Mc8VNa09rHpYesS29qSu/NkYCR
Vr7AB3poVlkQyzOaIx4z4hve8uuD6XLuTKzUHFnaac62MdAAvroX7j3+O0t+
c1zRDlM3AhOrcaVj3yyJyKipk7MyQkjbQ54HnbPk5O+/clvdjZCoF1//X/0s
GRj/VUqXaYQKg50SFvmzhKoxPb+D0xi0JvXzl9/PkvGTn6VXV43x9JbRff4L
s4Q6hv54bq0JOnz0g7POzBLT0+wBR+ZMIJ2i++Oi7CyR6ukKqWIyxfScFq31
sVny7aAvbZaOKYycld59ZZsl/yGx4FC/KU77H8uQmZ4h9u0P9nptMsfa982L
yh9myFXRv8+0bC2g07KRtTNghhxqqlgQeG+BbyvrsPWbIeddL8zIFVjAWo7y
zN99huj4+opJMFqivWycudFmhihvp3l8Js8SOe2NJwzPzpDir1c71dhuwZH6
i8OdsWly+Hrqw6sMNrB+r7/FcGiaiD0Wze4/bQNj4T0Byr3TxO61SFaGjQ2U
dJ2+Hm6eJo8YFAJFf9tgX6rKWEfhNDm/HCZ0StEWacYzxheDp0mKjpXpDXo7
jOefVOG+OE0COw0fpGTeQc+Vqbbd56aJiKu/Jam/g/qxKKv109NEUq/ixsLU
HeSw7HzeIvGP3x5kOSDwH7zsun/6cU6Tzq38hSUh/+HwIQ+p1aUpUqiQmVHt
cxdGLlXcDbFT5FyEc1HTK3toN4fKtkdMkffaimZrX+2hJGZ7tS9kiujfd0jX
rLOHeN+ul9Nvpohv+L1Hb5gdQHteY4b+yRRx//kz9GaYAxJ31ucrXpsia+KW
YxHZ97Ec0qKfuXWKeC/rP3Pd74jJhS/3f2yaIh0L/YXq8o7oU3P0L1mfJB/u
q97XsXTE742sxfVzk0Q/8ts71mxHhJvpCU13TxL7/m1nbhs44fzRrmWBrH98
v+66d+ojBOT2vwu2nCRvdO0vHjnnAv37QY9PmE4S2psScQcMXXD4mKpJjcEk
qRQfNT7+0AVZsRnCtFqTZP9VyZ7+RBd0vPYq/g+TJEXulo38/ifgsxSdVdo7
SXZJ14bwLD3BHSFKyLTjBBHUE+V80eyKTRE3LA/bTZBnna+dhZZcEbiv8ri+
2QThnTVUomZxQzZ1WMUvtQlySFjGUvGaGza1KFDCeCYIvRJPrnSbGwI9Xmmp
Vo0TekFKMtOoO7I6D2+P5xwnzecbe2gkPOF0ckNC0L5xkmB2u4FGxxOn3jcr
P6cfJymHr6ufeuyJHxovfM0oY0SmeR+rUoknSopGGA7VjJHMvLGGGd3nqItL
ZAl88g93D65V+b7AuIM4n0vXKGEf1C7dzO2N5LrtpdYNo6SwOfe4jqo37ET7
b+pVjBLusehdEw+9MTsc8EU6Y5SI5ROf1hpvLOstCM35jhLRF1EXytx9QHs2
S9wSo8SOZ81da9EXXLtOy2uGjBDPOKrTTs9fwUek+6Hl6xFSS29KVRD1Cotq
T1NdPEeI2wlBreMFr1DxqpD7n1cTdZ1zPVHLr3B3zwWaLYojhFnZPuWbrT+K
mTQqvk8Mk1cvL/xtvvEalmwm2gfkhklAsEmbtm0A6k5t9hWVGCbj3cUjA/4B
kNWPLlE8Mkye+H5MTUwPwJ7QIcm7jMMkl8GrbmA5ADkctw9U/v1L5OycNKi9
AkHPbd/12P8v2dij2Smb9hZfBTwte3qHSCf90OKt40Fg/2OYeaR5iKTSX5QY
1A/CSwcp2nu/h0h18QxzhGcQTAuHo2gyh8hu/zM3u9uCsE9fuVvQZ4jMp54v
cPX8gEevGK46SA4RppqJ5NzRYJxfDFbY7j1IchYGmdhGQ5Eecu+N1tNBsn5Q
eq/6zjBwKqj0hjgMEgGBpsDsw2FYfrXuImo8SD7W7Hy29XoYEo8Y52ifGCSh
NOHMfoVh2GvAd+xT9wDZvp3r1pOPn9BZlMIhITFAnNyDDBpsI+B0eemspOAA
iSoWuOzhHYF93actpDkHiNyF2A+GXyKgtlKVIks/QFzkI3kC+iLwQ2xcXnGg
n7jT3t+6WTcSYaECplcD+4nKlGCUpFoUjB9EfH4430ccnXP7SvRisLZlpNJp
tI8we9IWyrvEIOiN2PTjnj6ievuR22R4DGqS8qVdf/eR4YTI+v6hGJwZ6Cz3
iu4jL8U96U47xIL7Mut4sHYfYXDd/mP+42f0CwaIkW+9pCZ0k0cUYzwEHkeN
D8X1koULr3g+yMfDuir9C8OnXiLTb5XXZBOPRbsGTjOvXqJQHPlZqDwedN+Z
9+ww7CXLvLNCF90TICIXNKOztZcI5TW9z6VJgqNWaNq8bg/R1cnqsOdOwY/o
JFsO9R7yn+JPkSGkYNMiEVQ610M6fXXt3HVT4BPUFflRpIf0PFpuPPs6BWGd
hwLObu4hqmfpaDs3fUWxReQ9/8Ru8sVDtPHH5FfsfvxZ4uiGbvLh+bE59bE0
eHw7XLproYs4eaRJBWxPB2U85trMaBfRzj8lRiOYjh6DaKeMpi5ifKVf+75V
Or7KRRTIJ3eR/SUd/G9H06Gx+aPKFYMu8jg7SnjL4jfwsRyqpHLsJDtCuWSy
jmdi1wv2ySKzTnJxVNDyhm4mFilse7w0OonIMFvb2SeZKG3bf41RoJNICJo1
p1Rm4mbY3n7+5g6yMZXy/JRFFr7w0a5qnOgg3L8LRs3jsiEoMSEYNdNGyg2S
jd3182B21Nk5s72N2P08bJ7im4dQ3p01lSVtZLxdd6tQfh4YmIUd5j+0EYMT
ZkcYeQgWFqzzFc+2kSuMAse+TxIUZI5rDb9pJYMBzTmt5T9w9dT4Y2GJFpLd
QTWBNwXwP/74zxmOFkJn5TWr+bUA5UL03FfpWshmKpakoOoCyB48+sulo5lk
cog6Z+74Ca7123tqPJrJ9GXWi8ovfmL8x1jM3camf/2EriyjdyFcz45VZ95v
JDMnFCacs4tRcH5UVfxGI9mimWYR3lkMKuWR34nKjSRqt7HmGnUJnLT+VkRw
NhKTraeHbiiXwN6sv9S7ooHUbzYTmOwpwU3P9h9GHA0kdR/fJkOWX7hUUZm8
tbSODNDOC2p+K8eL6gpht691xEODe69RTzlK68oT14LryNpyKlUafQUU2n/F
z9jVkYKojhihmxWQHS+KbT9QRx6ejfJwOlgJkV15YSk2tWRvx/yHsXe/waiZ
6HeNuYaYSuUqSPRV4yuvV5YCdQ2pdTLXk1uthtqSeZ/oxB/SEyUUaMf0By9C
DknSlfwh5U/9FOUv/MHa0JvOLPs/pFZd6ueX5D8YeOR4lLWhmtw683Pll0cN
rFVfvcvlryL8Mz7He9TrEDurNBqwoYpwbbnzYqNtHXrebzpt3fybVFR8fq7q
UwftPofBg89/k1dzun625XXAA30Jl6FK4i9+lrFBsR67Io7UycdUkHzLLcuW
Fxrwdb5oZyl3GRlgjfRMsWuCz5fwAtmlX6R1du3v2rsmWOk730uv/EVst95z
8vrRBO5iydZw+1+k7Qgpv7GrGYEBcdGPSkuJyUbma6ypzXgo/urUsVslRMvC
x3nr5lbI37luFZJaSAQZTM61tLfjIK/UQUbPQuIdbvGuc0cHlpsZ/3hdLySr
kTwcYrIdSJOrkniwuZDs5GEp+BHaAd7d8hs1r/wk9LsVGf3NOkGXzPd+63I+
eeO+0p31pAtRrf3ef93yiIWoVeySbA9anJhCPx7LI+XMN0Wv6/SA/qBisnpP
LvnAqVo3eK8H9oaxNZnIJeEWi/qOCT0412/J/IKSTQz1uvSCDvZiaHwiTMA2
kxT0fR6eoO2DwEZKqpVuGiliNkurWO+HfoRAETtdGlF6aqb2h2MA/md1G2oz
UkmybdJDGvkBUDxyFmWYUomk1fbIre4DKN/mfGr7nxSy0s3meXvHIJoEaH2u
eScSlWbjtXm+Ieips6a13ogk9/vf46zHMEZn5qTuFUaQLc+y25QShuEUWEXo
eSKIm7Vo/4u6YQS3Pi2XG/hEHONcX2RwjSCtvKZI9U8Icdy49rS2cARJs7e4
hlreEBGTtURNhjH8luIQPhD8mux/JZe8/9QYxh/XSqvo+ZMD5RZh7DfHcJXh
buRN4kva9DV+DOaN4bIM/cYNv9zJdUrraUebcfgX3WUxv+hKguYmF+SDx1Gt
2ipSWelCnCXJq0u/xvGhVI2IRTkQLtHGKV7uCexrZxtf+3yHDDAnOi6qT+BI
b71UoJ4VgbKOzQ6XCfBut3171NyI/H2yTcQscQIudYfrDvxUJoVaroeo2ycg
uLPdcrOQOK4pteazz06gYepp6K7Fqyg3H6EyKprApCrftM0dM4wpSoYPBE7A
8fW5MitxW+hMfJdLvjmBtccPPoQK30N89rRjrvS/+pbxt2oFHsLce+P4jh0T
+Mnx/NnHXU8Rr9U6af91HObmAmbf1vyRNPF2RlVjDJl0jvUF9yLgUj5iE/lj
GGFCjLVJnJHYUZdAIxY4DA+1pOrgqkic/R2+uPHWMDQDe8vt+aPxkd5Q5va+
YUweulQg0B6Ls0vBuVfu/gWvFFuS/9lEZHvUhghIDuFXqsHZlOdpkBiuyWEe
68fJIsGffF1p+JL1+LtyWT+SG5bkQiTSwWs63JcV04/Apdfw6k2H1qzUQ6kb
/TBBqbTpqe8o1XZizWvrw3qZiCjLVCZowrssPjT34njPhoNPrhJ08fYeu7PY
jaNZV6ZEPhM4cDkeqG/vBq9/QmHXEgEX35bbBj+7se1T/PEw5R8ov1Rt8ten
GytqV9vWx3/grdL6tQq+brQnJ/ET0QIMV09u/mjYhVBb/cJT3wsxLljV0dHc
juDrWxMDOgtBm9Tp+TmhHe/Op70doykCy50ncelP2uHHQWf18WoRjnOKNvoJ
tMOlOn336lIRLvd5qJ13boORyA6DnJMl+PSGqdlCvBVck9lL0gW/QMX77TZ1
eROcKs+4zY79QuiVtwbSEU1o+FJOn8hSBoNRa/4Uxya8MG3lOmRXBou1prjr
Qk2YbKEo03CUo2hSxiDsdSPyiqTCax9VwNeyUMDNqgE6H74r3ZKqQuWJ/tMC
5+qQdh/1PKZVeHFv8O0nnjrQa5cYdPpVYUPbMJfy5jrk72q8qzFUhWvyhi9R
VIu9ZxxVgy9W42O6YKCnYi0cM4IePKVUw+Wl8KyJVg0uRDRXqlytQRp12MCR
N9WYdE80K7pdA0duLukdD6vx7qbruoxrDX4GP0hjNqzGkJCQKH9iDTxtkvfH
CFbDM8PlDfWmWny0qtVT961CaSWfbkZSLcKpX7+hovsNxcV7Q4do6rEo5spF
JMox3qL05B1rPWiL5XZ2bitHYC77/p1i9RA+XvhMvrsMA09/XVy5Xg9KyFb7
mpdl8NjBltTwtR7TBrkVdIO/UMxZeM9LvwFUuYciXWNKoaDMQD2X3ogHvTvO
D2kVw8do69TSr0b82K67d+/xYjTdo+pca28Enb7wIdu9xbAMGc+i3dKE6Be8
3d9ri+AzUXaHVbsJxr50Go81i9D0yrXnzHwTTlpZUMfpF8KyYTbfX6IFnSUJ
vBmvC5A6PJL0Vqnl3z+UFbK8X4CVtZ6Pwfot+MmUqnVWrwA+fH8eRHu0IHgs
nsOW75/+foJoVkMLDlY7ng7NzcfKfrNP3fat2PJ4cxn/1A/4GjS6iHxvw59y
t6+9A3nwGD2JgYo2PBf214pKz8PjB+GrH3raQMNga5fulgfr17cf0tC3g7dO
jINw5UGlhPpuh0k7pLNPtlua5oJeWMT8JUMHqjPDb2fNZ8NnzVN56HYnvn3V
XdqrkgkPr/FtIa6dGGAabMnnycTjfZpll9934lDL77XE1QxYi7ErksJO1O3O
vXs+MQN8qToc5Tu6YB1VveM2QwZoBidZwk26IPxNK5J34BtKVNh2qDF0g+qw
gGxpRhr2Hu1musPaDZ6K5/Yz79NguCOK4w1vN2S6FHwuOaaBUi4o3iTdDfkx
iYvPZNMgeOGkruGNbuBxeTBzSSr8zuh+tk3rxlyU8bRF11foSL5XeKXdg7L6
mtADYimIZtZTTTXswcF1ugH3fSmYmee4Vm/ZAwmzq6eY1pPxMj32FotzD/w6
l07GViSDiGW8/hTTg5CWAze8LJLBLdTYnbLYA+kbCe0nNZMwdojxcU1QL2i4
/Gt2v4iHpOMnu/zIXpyUXei0NYzH0zoh0+TEXsSxbovefiIeTM/OXfIp6EV7
vgNlsS8OsqMO+5WGe2GaQyf+4UwcfL+1fMuX6oN7ueDm7G1fIHoxbCK5qQ+y
AiZT/EUxcIoU7A3t6UN7pUXbo3/5pXg1o8FntA8KDvd1Nv3LNzrJf3JvUfXD
Yzvt3xiZGDxlpH55+PA/LJx1VS49GrWdpofDHPqhaHr3kHNKFO7dPWLkyzSA
m1efsZ2viAAT3USO9qEBKL76wDYbH4GM0K/7DgoOYHP53eQ///LZSplUdbzc
AFaMjmhxqEXg6aHzKLs1AHGb99zUjeHw+W3CtvnnAHwONn8PHvuE6MMhzQ9t
BiF9btN/vCfDcD7P6Lj8w0GE0otW3OMMw9/LPK+2ug+CTUasYow2DILO8eff
BQ1CMP+Vc0J8KL7WZ31PLxqEUs5eum0DIch72hgweWAIuSm/A0+bf0Rj2y4N
s9IhRBr2T1wNC4KSl2nT3ZohPOK3kKZ5EIQcqSx917YhmHosvplQD0JY4A2r
sMkh1LzJ57q9KQg31b65tez7i8gKGTOGW+9B+an7XcXiLzbXX9iSq/AOrHHR
rCfohhGYlHnDnCMQPteWwxX2DsPtdG1+1noAqGjV+DUPDuPItlUD2c4A9Jks
HbcTGwat0l/UhwQg4eAl1Tidf+dfd7RJcfzL//5TT9jjhnEzjlYj/MgbGD44
OUhzaQRibIVfOW/4Q8CktH5cewT3ywQk0hX8MaOiWVhvNAL7uHs19of94cF9
61OEwz+9btJhj/FXiK/6oIuIEewWShKodHqFJZ7lKnvKCAYzddZyPvnBvyYz
oz92FKtv68kjJh9cz1WIqUgdBeeUnqH2gDd4Yv8EpOaNomCMjcHpmzcyHv29
86RuFFEe8TnxV7zRcZhFiI1qDKLffnYFfHwJAef7nzSvjME4vtiO/YQXfh45
8eLn5nHQxprsnP/oCX1hzYipneNodurkFXjg+c+37XLY949D379BNkDTE4LS
ceOOR8chmdbEt3O7J96cZ78sfmUcR5nk1jwfPYOZKQ1rVOw4on/knFO19ABt
aGOCx8UJzIj8UmWwcEN4+GxxmtYEZCuqmf2U3HAyendXj8EEhtplHsoIusE2
4SID7k6gPmtxlWXSFc3ZxH4h+F8fZn49avyBK740xeDm+AQsPjq35QQ8Be/W
nKHI85PQDMtqOzbqgumSo5bhypM45vml0azWBXken0ZCNSZh1nLtSF6WC7Q3
PRsPuj6Js61itM3PXeC+rj7rZzuJrIbbjZn8LuibG1x3ejcJ+3tHPOY6HyO8
Zw+z1tAk/I+5yMgJOMH6k8c7jbFJTGTJqVKonCBtuMSiNj2Jz9QK3RONjqhp
72C9uDIJjaoZNl8PR2xo/swpt2sKsfYW5m8GHsKwCkeFJKdw/+WnczYpD8CW
Y6Ww2XMKzjf9UvhsHbCXhUKx9p4CjYhg7qCSA7bbeyY3+U8hsZBjpYfHASvC
UQfiP07BXFI9+HmbPVoiOqY0UqfQpLcM70v2CPRSDwnr+HcfdevPgyfugV73
xILM8WmcESha2i7+H7ZkFMVHSU+j8lja4jPG/7C6V9N45+lp9BZl3j+2cAej
v20re5SmsdjJX7o/+w7K5L9EPDechl02vyanwh08E2BTa/SaBn9PAnedkR2o
KBs/3+mZhtHvkIRIBxsY9jbPOA9Oo+2pvvbceRv8qEiW9R6dRvQxVnmv/TZw
CdWvi5mfRqAS13n3PGusn81ab6ObQYqZ23z0Vmus+dppKx6bwfsTA5uV4m9h
haeLmtVtBleqjb/c47DE9Z3fVfifz4BT7EjC1yUL5Cx6v5fwmYEvU5Iof60F
nMplhNXfzeCYJZdVvocFlm3f6njEz8AppNUiYPImKNkqKZN1M/BBpZPrb3Ms
qOfqF/HMwm1VLVg1xRRPm5PaZY/MQn+bXKCdjynojcKvZ4jM4vw5pQ/lVqbg
tX2mEyczC/v8AX1ePlNo+qhrv1KfxX9f7Rlvh5kguaxfWe/RLITOcF+dCb4B
izP0p+bqZpGr9qAkNNsIs2VUOdYts/BtjmFiDzWCi8aM9FDnLLLqdkhUPDXC
O6MmydbhWfC0W5BEJSMUO4eL51PNwWnFZZt3myE4cyQEvQXnkM9p6mRLa4hW
cYMDPG5z6P46Ijq9eh1mS8d3uj+fQ5JNjrlo9XVM5m6n7veZg2Rt05+M8OvY
pJg1HPl+Dq9m2x1Dzl/H0WuMWdxJc7BNfN2W8VYXLo/Kr3K3zCFWzD77l7wO
eItPBHKJzMOB+mb7o19XkPyC/oXr8Xnc/u9k20zEFUir9j/qlZ6HKH3/vqjH
V6Da5G8aoTCP5XzVhu/iV3B/eEycS3ce66/+XnwToY1y+shaTo95bErtvtTi
pQXbK7t2c7bNo37trd5pt8swjhUO4umeRzOVZYqr+WVoLalw8Q/MI1jbUWtK
6TKkP3gfF5mcx/d7LgFKDJexuZNOR3bTAhTTaGTGwzUQZLY5QkdwAfvePrAr
KldH4T2K+GunBfTYfZtkl1bDt2KWvMAnC1ijuwwZTjV8ZpZSDPJYQHHpjZwH
dGrwyXS49slvAQu6k/1531RxbXX2UVLkAs78lbvrt6qCcbeJ4vKKBVw0La0o
fqsMljd9VzexLeKS+huF7mUlSLqyM93lXIQVvcDOqmolaN/Rqe3lW8SxLJ93
G6KV4K9WrfxTbBG7Tj8VP6auhO07cuSfnl/E5pDL2TlfLmDN/bUg1d1FyKf4
emy3PI8+B3mqlbJFbPTp/d3GdA4bzR/lWlUvQmkmMzxoRgEc2hkPW+sXwX9x
JtevWgF64kfnsroWsYG7/Aa3lwIaJlmGH8wvYtiuO6dzowJ+WUzVLhxaAk36
yzGdlTNI1A2Lmbm/hHSFGxyHGOUh3shF2fJ4CRnZHbeFKHLI1oi5tN91CWvy
GoNGnXIovZA4ddp7Cf4jS9byX+TQeyJHxufTEtI4QnVa5eSwb29T1eGyJRTt
Ddsmff80nlbsXNQ7QEGSnlGkCpUsaM+/VrLjoOC7tI3Q29pT8P3J9NGNh4Li
tz3XOWNOITiLTT5OmAJxIRHOdZVT+B575OXiGQoGJpi8Sz6dxKibIsfrWxS4
xqfM/Av/uHLK+XxpLgVs1+iYL/VKom1uYGdBAQWna5paxvIkYZyo0phdQoHf
hcc/C4MkcYv9oFnSHwoSutgqd12WxNMNua6B/RQo82w3YCk+gcQiSp7JjmVU
6TLUfUmXwCYV++Mb/nlrz4xmVGOGOF5s6VihGC0j8s/hCt8gcewkCoWzZsuo
l3srdtdJHPtFGC8P2S6jT3o9+8dpcQgzpNlWuS1jv1JskVH5Meg0TMV9jF+G
04e7tN5DYkjRv80pvfKvXne/cP9pURinT7KFbVjBw85w5Zc8oti7/S7LFpoV
HKSd+qlPJwr7zIe7anavoOVeW4xbnQik93quWfCt4H1Ce2+FpQgKfoW3vNdY
gVQnXARkhVEn3uS/FLsCv/dFwoEXBOHupetjkLiCC+G+LD9YBSHR0/G8KHUF
PwZu7BWdPIJ3vv0ur/JWILznkuPA2yPQG5625q9bgRBbzaD/sAAGQndcvLa+
Ao5AmbOvg/mxSHeGOlNrFbmZjFHXRfjAME7/pkBnFX7fw4vo6flw5E8Ld4XB
Kp57ekTNjPBC/+2dc50W/7Cjg4NmLC9+coU/3/x4FQ/H+S5YcvHC5+SGXRrR
qzigmCkSw8kDHmvCOjK/ihi71yPOZ7ggq+6VMLu8inFqh9dUfFy4Kn5Fdo1q
DdZHQ27E0XHhBWXcYPe2NWhvCXF9XMOJSY+DESfY1/Dg5c8te004kRP6iN9N
cQ1SCQdMSnwOQeOPjATbuzWI1N4Ky6biAJ3Mtvycj2tg43kg/6mCHfmRLRev
R6xB1P/II8537BC5/8DoQ+Lav/eZr39YhB307N9fshStQWaQQ1nM5CB+3RLr
ZZz+x280+FTUyorTtPx+9JfWsTKryaiyeT8W7Rb3J6qvo4xn061rLSxIai2J
Ur6yDtvB8/FxSSw4mGSW/dJ4HW1fGJi4dFmwohU5QPdgHe9juCfV0vfhewT7
KZrodVwU1jl2zp4Z1jsmSqLj1sHkldr9QpUZvA55GudS1nHQ3cNlJz8z3ijp
3XTPWUexy+7hhjYm3JkKek1duw4x+r5tlxWZIKBreTCiaR2B3gZNXpxM6C6U
+izfsY4zjJm6G9YYofauKe/J33Xw6+fPh6UzgnZj7IVDE+tQVBhWLHvFCGLl
UPdjdh0Ug96Co9aMsK8/Z2BIWYe334Ytv5UY8X/zYvj/ebH/Aa2Ddlk=
         "]]},
       Annotation[#, "Charting`Private`Tag$18069#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"\[Delta] = 0.25\[Degree]2\[Theta]\"", 
       "\"\[Delta] = 0.50\[Degree]2\[Theta]\"", 
       "\"\[Delta] = 0.75\[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.8, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity (height)\"", TraditionalForm], None}, {
      FormBox[
      "\"s (\\!\\(\\*SuperscriptBox[\\(\[Degree]2\[Theta]\\), \
\\(-1\\)]\\))\"", TraditionalForm], 
      FormBox["\"normalized FT of Lorentzians\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1lXk01vkCxqUcRbZQmSJblpeayBJlnmqMUq9dlzRCzcXQoneypSuJ0FXN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           "]]}, "Charting`Private`Tag$18069#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1mmc4F27UxwkllaTSMouGFA2VjG8pGkooMjIrRRH+VpSVKCsjQkQIqURk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           "]]}, "Charting`Private`Tag$18069#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1WndUD17cjlBCiEqU0lRKQ9KgR5GIpgqlqaGi4UehKBoiDVFIKm3aKtpX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           "]]}, "Charting`Private`Tag$18069#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity (height)", None}, {
        "s (\!\(\*SuperscriptBox[\(\[Degree]2\[Theta]\), \(-1\)]\))", 
         "normalized FT of Lorentzians"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 600, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "\[Delta] = 0.25\[Degree]2\[Theta]", 
        "\[Delta] = 0.50\[Degree]2\[Theta]", 
        "\[Delta] = 0.75\[Degree]2\[Theta]"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.8, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.827915797045706*^9, 3.8279158597063465`*^9, 3.8279167125212965`*^9, 
   3.8279168963792076`*^9, 3.8279169498499937`*^9, 3.8279760126514044`*^9, 
   3.8279763307844563`*^9, {3.828089108610833*^9, 3.8280891234660273`*^9}, 
   3.8280891998737288`*^9, 3.8280892734238353`*^9, 3.8280911930140285`*^9, 
   3.8280918165433397`*^9, 3.8280928631771727`*^9, 3.8280929175883427`*^9, 
   3.828105775100469*^9, 3.828106044315216*^9, 3.828106156232275*^9, 
   3.828155390923771*^9, 3.8281560251306725`*^9, 3.8281600521933804`*^9, 
   3.82816119623622*^9, {3.8281613044881654`*^9, 3.8281613278812237`*^9}, 
   3.8281614624063864`*^9, 3.828161656521414*^9, 3.828162584715767*^9, 
   3.8281708462007437`*^9, 3.8281710353944187`*^9, {3.828171069032504*^9, 
   3.8281710855961094`*^9}, 3.8281712716411676`*^9, {3.8281717865099263`*^9, 
   3.8281718166207843`*^9}, 3.8281737291476793`*^9, 3.8285021572787895`*^9, 
   3.828503485758854*^9, 3.828579452954698*^9, 3.82858114116591*^9, 
   3.8285830577266517`*^9, 3.828584246714204*^9, 3.828591675815278*^9, 
   3.828592095522944*^9, 3.8285931225733547`*^9, 3.8285934365429783`*^9, 
   3.828593980945621*^9, 3.829800362768756*^9, 3.829800494518754*^9, 
   3.829807716927286*^9, 3.829809191945455*^9, 3.829965139602191*^9, 
   3.8305859215621676`*^9, 3.8305860112100573`*^9, {3.83058771118369*^9, 
   3.8305877388116417`*^9}, 3.8305919261663704`*^9, 3.8305948047909317`*^9, 
   3.830595015924131*^9, 3.831616467355917*^9, 3.8321437386516204`*^9, 
   3.8321449568954916`*^9, 3.832145068655706*^9, 3.83214517804037*^9, 
   3.8510481424174533`*^9, 3.8510501756565065`*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"6c1288b4-440c-46e9-883e-3c01f6889744"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"VoigtApprox", "[", 
      RowBox[{"0.1", ",", "0.4", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"VoigtApprox", "[", 
      RowBox[{"0.25", ",", "0.25", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"VoigtApprox", "[", 
      RowBox[{"0.4", ",", "0.1", ",", "0", ",", "x"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2."}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", 
      "\"\<normalized intensity (area)\>\"", ",", 
      "\"\<normalized Voigtians\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Delta]/\[Sigma] = 0.10/0.40\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta]/\[Sigma] = 0.25/0.25\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta]/\[Sigma] = 0.40/0.10\[Degree]2\[Theta]\>\""}], "}"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FTVoigt", "[", 
      RowBox[{"x", ",", "0.1", ",", "0.4"}], "]"}], ",", 
     RowBox[{"FTVoigt", "[", 
      RowBox[{"x", ",", "0.25", ",", "0.25"}], "]"}], ",", 
     RowBox[{"FTVoigt", "[", 
      RowBox[{"x", ",", "0.40", ",", "0.10"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2."}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<s (\!\(\*SuperscriptBox[\(\[Degree]2\[Theta]\), \(-1\)]\))\>\"", 
      ",", "\"\<normalized intensity (height)\>\"", ",", 
      "\"\<normalized FT of Voigtians\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Delta]/\[Sigma] = 0.10/0.40\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta]/\[Sigma] = 0.25/0.25\[Degree]2\[Theta]\>\"", ",", 
         "\"\<\[Delta]/\[Sigma] = 0.40/0.10\[Degree]2\[Theta]\>\""}], "}"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.8", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8279160311185503`*^9, 3.8279160503821173`*^9}, {
  3.827916101862641*^9, 3.827916136876086*^9}, {3.8279161694152794`*^9, 
  3.82791623439019*^9}, {3.8279162675513687`*^9, 3.827916304076659*^9}, {
  3.8279163491838217`*^9, 3.8279163895206356`*^9}, {3.8279164283989296`*^9, 
  3.827916430010417*^9}, {3.8279165182939568`*^9, 3.827916534769665*^9}, {
  3.8279166890115457`*^9, 3.827916701598633*^9}, {3.8279169570429363`*^9, 
  3.827916958061427*^9}, {3.827917096344989*^9, 3.827917167103284*^9}, {
  3.8279172684937057`*^9, 3.827917268910597*^9}, {3.8279763171902695`*^9, 
  3.8279763416127567`*^9}, {3.8279768151873255`*^9, 3.8279768267344956`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"4805e3ff-1f8f-425b-bbb2-27f1833afa1c"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1mXdUDm7Yx1OIpOGHRFqEhmhJy9dIEqWSZJREVoRQQqISlfairdKQ9p53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         "]]},
       Annotation[#, "Charting`Private`Tag$18153#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw1mXdUz1/8x1OyGlRGERGSykiJEk8hEqWhIWTzpYQ0NGhIQlr6NEh7772U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         "]]},
       Annotation[#, "Charting`Private`Tag$18153#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw12Hc4FV78B3ApGUmliBINSZJRCknvNDXMMoqsom9GSUVKCIlSCalULhkp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         "]]},
       Annotation[#, "Charting`Private`Tag$18153#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"\[Delta]/\[Sigma] = 0.10/0.40\[Degree]2\[Theta]\"", 
       "\"\[Delta]/\[Sigma] = 0.25/0.25\[Degree]2\[Theta]\"", 
       "\"\[Delta]/\[Sigma] = 0.40/0.10\[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.8, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity (area)\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"normalized Voigtians\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->600,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1mXdUDm7Yx1OIpOGHRFqEhmhJy9dIEqWSZJREVoRQQqISlfairdKQ9p53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           "]]}, "Charting`Private`Tag$18153#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw1mXdUz1/8x1OyGlRGERGSykiJEk8hEqWhIWTzpYQ0NGhIQlr6NEh7772U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           "]]}, "Charting`Private`Tag$18153#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw12Hc4FV78B3ApGUmliBINSZJRCknvNDXMMoqsom9GSUVKCIlSCalULhkp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           "]]}, "Charting`Private`Tag$18153#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity (area)", None}, {
        "2\[Theta] (\[Degree])", "normalized Voigtians"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 600, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "\[Delta]/\[Sigma] = 0.10/0.40\[Degree]2\[Theta]", 
        "\[Delta]/\[Sigma] = 0.25/0.25\[Degree]2\[Theta]", 
        "\[Delta]/\[Sigma] = 0.40/0.10\[Degree]2\[Theta]"}, LegendMarkers -> 
       None, LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.8, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.827916138465838*^9, 3.8279161729333773`*^9, 3.827916306284012*^9, {
   3.8279163726312995`*^9, 3.827916390671317*^9}, 3.827916430929089*^9, 
   3.8279165358512225`*^9, 3.827916712790847*^9, 3.8279168966578655`*^9, 
   3.8279169586321273`*^9, {3.8279171466969786`*^9, 3.8279171739579916`*^9}, 
   3.8279760128856096`*^9, 3.8279763310188217`*^9, {3.8279768004681177`*^9, 
   3.8279768289379807`*^9}, {3.828089108832715*^9, 3.828089123691907*^9}, 
   3.8280892000966086`*^9, 3.8280892736337223`*^9, 3.828091193235922*^9, 
   3.828091816783701*^9, 3.828092863417029*^9, 3.8280929178302107`*^9, 
   3.8281057753393383`*^9, 3.8281060445650773`*^9, 3.8281061564751277`*^9, 
   3.8281553911486626`*^9, 3.828156025358536*^9, 3.8281600524652476`*^9, 
   3.8281611964890814`*^9, {3.8281613047420273`*^9, 3.828161328141099*^9}, 
   3.8281614626582346`*^9, 3.8281616567413063`*^9, 3.828162584966631*^9, 
   3.8281708464346013`*^9, 3.8281710356212945`*^9, {3.82817106925137*^9, 
   3.8281710858339796`*^9}, 3.828171271871042*^9, {3.828171786726809*^9, 
   3.828171816859639*^9}, 3.8281737293810596`*^9, 3.8285021575526333`*^9, 
   3.828503485991728*^9, 3.8285794531865683`*^9, 3.8285811414217887`*^9, 
   3.8285830579715166`*^9, 3.828584246959587*^9, 3.8285