(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    484880,       9491]
NotebookOptionsPosition[    480947,       9404]
NotebookOutlinePosition[    482252,       9441]
CellTagsIndexPosition[    482182,       9436]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Size & Pseudo-VoigtMicrostrain profiles", "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
   3.794473182921484*^9, 3.794473193906823*^9}, 3.797331640127709*^9, {
   3.797653041984359*^9, 3.797653047469375*^9}, {3.8172051525538883`*^9, 
   3.8172051657572813`*^9}},
 CellTags->"Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{3.800596771824752*^9, 3.800597284202766*^9, 
  3.814004666591812*^9},
 CellLabel->
  "In[190]:=",ExpressionUUID->"638de314-7056-49bd-af21-319f457c40a4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"filePath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HomeDirectory", "[", "]"}], ",", "\"\<DeskTop\>\"", ",", 
       "\"\<SizeStrain_functions.jpg\>\""}], "}"}], "]"}]}], ";"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.794487949165287*^9, 3.7944879555406275`*^9}, {
  3.795686926938303*^9, 3.79568693015725*^9}, {3.7956871831566043`*^9, 
  3.795687184703747*^9}, {3.8134955442873125`*^9, 3.8134955519283504`*^9}, {
  3.8172052460408936`*^9, 3.817205256259839*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"7ee0b89d-b3e5-44a5-836e-8ce0856b95e9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Get", "[", "\"\<Voigt_functions_general.m\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<SizeStrain_functions_general.m\>\"", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.817128916523795*^9, 3.817128924413577*^9}, {
  3.8172051006619625`*^9, 3.8172051384284296`*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"c0c5201b-c383-4468-8299-2a63fa0088f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"FourierParameters", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.817129495125703*^9, 3.817130020129476*^9, 3.8171321855370483`*^9, 
   3.8171328825102763`*^9, 3.8171339216368856`*^9, 3.8171341130358796`*^9, 
   3.817134179945239*^9, 3.8171342445261045`*^9, 3.8171343488433547`*^9, 
   3.817135459169955*^9, 3.8171371321213355`*^9, 3.817186306758191*^9, 
   3.8171864805107546`*^9, 3.817191602455773*^9, 3.8172057630392785`*^9, 
   3.8172059794982147`*^9, 3.817217111081523*^9, 3.8172732175485954`*^9, 
   3.8172735339153957`*^9, 3.8172745162510815`*^9, {3.817274639081896*^9, 
   3.8172746528478837`*^9}, 3.817274695536309*^9, {3.81727473320909*^9, 
   3.8172747556157894`*^9}, 3.817992109644123*^9, 3.818071285232978*^9, 
   3.8181344098266635`*^9, 3.818134594155491*^9, 3.818151748161479*^9, 
   3.818153758488387*^9, 3.81822102696124*^9, 3.8202988224825096`*^9, 
   3.820306568702219*^9, 3.8243410842396855`*^9, 3.824342986561601*^9, 
   3.8243443323310223`*^9, 3.8243445609376736`*^9, 3.824344786635137*^9, 
   3.8243453053930745`*^9, 3.8243484615043707`*^9, 3.824354453144543*^9, 
   3.8243569076267033`*^9, 3.824882479811348*^9, 3.8248827393322773`*^9, 
   3.824954813130438*^9, 3.8249665052318206`*^9, 3.8249734622196445`*^9, 
   3.824978880026297*^9, 3.824980659280532*^9, 3.8249816575795107`*^9, 
   3.8249832553447475`*^9, 3.825498227664085*^9, 3.8272308027586994`*^9, {
   3.8274007048770328`*^9, 3.8274007234718714`*^9}, 3.827465122957241*^9, 
   3.82746587338111*^9, 3.8274699247249713`*^9, 3.8274754567092257`*^9, 
   3.827475612732568*^9, 3.82748192898732*^9, 3.8275622669149103`*^9, 
   3.8275628050954647`*^9, 3.827840317355815*^9, 3.828187846538261*^9, 
   3.8283525600054846`*^9, 3.828505830327871*^9, 3.828510855219163*^9, 
   3.82851557076046*^9, 3.8286882759265523`*^9, 3.8321495343288164`*^9},
 CellLabel->
  "Out[192]=",ExpressionUUID->"dd75fa14-bd6a-4986-bfe7-3a7a0030c6ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FT of size distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.809159709373041*^9, 3.8091597165513396`*^9}},
 CellTags->"Title",ExpressionUUID->"9004c831-7d6f-49ee-bde6-b915ab17c4da"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "MeanSize", ",", "StdSize", ",", " ", "EffectiveSize", ",", "l1", ",", 
        "l2", ",", "l3"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MeanSize", "            ", "=", 
        RowBox[{"dmean", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"StdSize", "              ", "=", 
        RowBox[{"sd", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"EffectiveSize", "=", 
        RowBox[{"LV", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"h", ",", "k", ",", "l"}], "}"}], "=", 
        RowBox[{"Sort", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"h", ",", "k", ",", "l"}], "}"}], ",", "Greater"}], 
         "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"l1", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{
               "\"\<sphere\>\"", ",", "            ", "L", ",", "Size", ",", 
                "h", ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.0", " ", "Size"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", "                 ", 
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{
               "\"\<cube\>\"", ",", "                 ", "L", ",", "Size", 
                ",", "h", ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.5", " ", "Size"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", "                 ", 
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{
               "\"\<tetrahedron\>\"", ",", " ", "L", ",", "Size", ",", "h", 
                ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.0", "Size"}]}]}], "]"}], ",", "\[IndentingNewLine]",
             "                 ", 
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{
               "\"\<octahedron\>\"", ",", "   ", "L", ",", "Size", ",", "h", 
                ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.0", " ", "Size"}]}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "                  ", 
          RowBox[{"{", 
           RowBox[{"L", ",", "0.0", ",", 
            RowBox[{"2.6", " ", "Size"}]}], "}"}], ",", "\[IndentingNewLine]",
           "                   ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.0", ",", 
               RowBox[{"2.6", "Size"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Orange"}], 
            "}"}]}], ",", "\[IndentingNewLine]", "                   ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                   ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<Fourier Transform\>\"", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<Fourier length, s (nm)\>\"", ",", 
               "\"\<Single particle\>\""}], "}"}]}], "}"}]}], ",", "  ", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                   ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                    ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"PointLegend", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Orange"}], 
                "}"}], ",", 
               RowBox[{"Range", "[", "4", "]"}], ",", "\[IndentingNewLine]", 
               "                                           ", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Sphere", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "                                                           \
                ", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Cube", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "                                                           \
                ", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Tetrahedron", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "                                                           \
                ", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Octahedron", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "}"}]}],
                ",", "\[IndentingNewLine]", 
               "                                                              \
                  ", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "35"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                     ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                  ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"l2", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<sphere\>\"", ",", "            ", "L", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", "                  ", 
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<cube\>\"", ",", "                 ", "L", ",", "\[Mu]", 
                ",", "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", "                  ", 
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<tetrahedron\>\"", ",", " ", "L", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", "                  ", 
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<octahedron\>\"", ",", "   ", "L", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}]}], "}"}], 
          ",", "\[IndentingNewLine]", "                    ", 
          RowBox[{"{", 
           RowBox[{"L", ",", " ", "0.", ",", 
            RowBox[{"2.6", " ", "MeanSize"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.0", ",", 
               RowBox[{"2.6", " ", "MeanSize"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Orange"}], 
            "}"}]}], ",", "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                    ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                    ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<Fourier Transform\>\"", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<Fourier length, s (nm)\>\"", ",", 
               "\"\<Lognormal domain size distribution\>\""}], "}"}]}], 
            "}"}]}], ",", "  ", "\[IndentingNewLine]", "                    ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                    ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                    ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"PointLegend", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"Red", ",", "Blue", ",", "Green", ",", "Orange"}], 
                "}"}], ",", 
               RowBox[{"Range", "[", "4", "]"}], ",", "\[IndentingNewLine]", 
               "                                           ", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Sphere", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "                                                           \
                ", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Cube", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "                                                           \
                ", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Tetrahedron", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "                                                           \
                ", 
                  RowBox[{"Graphics3D", "[", 
                   RowBox[{
                    RowBox[{"Octahedron", "[", "]"}], ",", 
                    RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "}"}]}],
                ",", "\[IndentingNewLine]", 
               "                                                              \
                  ", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "35"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                      ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                   ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "        ", 
       RowBox[{"l3", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"G", "[", 
           RowBox[{"x", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
          "                ", "\[IndentingNewLine]", "                ", 
          RowBox[{"{", 
           RowBox[{"x", ",", " ", "0.", ",", " ", 
            RowBox[{"MeanSize", " ", "+", " ", 
             RowBox[{"6", " ", "StdSize"}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                 ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                 ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)\>\"", ",", "None"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<domain size, D  (nm)\>\"", ",", 
               "\"\<Lognormal domain size distribution\>\""}], "}"}]}], 
            "}"}]}], ",", "  ", "\[IndentingNewLine]", "                 ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                 ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                 ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tooltip", "[", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], "]"}], "]"}], ",", 
                 RowBox[{"Tooltip", "[", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{",", "0"}], "}"}], "]"}], "]"}]}], "}"}]}], 
              "}"}]}], ","}], " ", "*)"}], "\[IndentingNewLine]", 
          "                 ", 
          RowBox[{"(*", "  ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", "Thick", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
                 "  ", 
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"LV", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "      ", ",", 
                    "0"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"LV", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "       ", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"LV", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "      ", 
                    "\[Mu]", ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}]}], " ", "}"}]}], ","}], " ", "*)"}], 
          "\[IndentingNewLine]", "                ", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", " ", "Thick", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
               "  ", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
              "}"}]}], " ", "}"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", " ", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", "Thick", ",", " ", 
               RowBox[{"Arrow", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                   RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
            ","}], "*)"}], "\[IndentingNewLine]", "                  ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "l1", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l2", ",", "l3"}], "}"}]}], "}"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Single particle\>\"", ",", "16"}], "]"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "         ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Size", ",", "7.43", ",", "\"\<domain size, D\>\""}], 
            "}"}], ",", "0.1", ",", " ", "500.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<nm\>\""}], "}"}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "  ", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Lognormal domain size distribution\>\"", ",", "16"}], 
      "]"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "         ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Mu]", ",", "2.", ",", "\"\<logn. median\>\""}], "}"}], 
           ",", "0.1", ",", " ", "5.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Sigma]", ",", ".1", ",", "\"\<logn. std. dev.\>\""}], 
            "}"}], ",", "0.01", ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Mean Size\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"dmean", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Std. dev.\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"sd", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}]}], "\[IndentingNewLine]", "        ", 
      RowBox[{"(*", " ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Effect. Size /nm \>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"LV", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}]}], "}"}], "*)"}], 
      "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", "  ", 
    "Delimiter", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", "  ", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Reflection indices in cubic crystal system (h>=k>=l)\>\"", ",", 
       "16"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "         ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"h", ",", "1", ",", "\"\<h\>\""}], "}"}], ",", "1", ",", 
           " ", "10", ",", "1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"k", ",", "1", ",", "\"\<k\>\""}], "}"}], ",", "0", ",", 
           " ", "10", ",", "1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"l", ",", "1", ",", "\"\<l\>\""}], "}"}], ",", "0", ",", 
           " ", "10", ",", "1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
       "\"\<Fourier transform of mean size & size distribution\\n\>\""}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", 
    "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", "  ", 
     RowBox[{
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.8093210929765987`*^9, 3.809321112527949*^9}, {
   3.809321168618717*^9, 3.8093211687905836`*^9}, {3.809321270972602*^9, 
   3.809321308095614*^9}, {3.809324927588235*^9, 3.809325039956688*^9}, {
   3.809325782913205*^9, 3.8093258254276285`*^9}, {3.809325872385377*^9, 
   3.8093258850361786`*^9}, {3.809328014685336*^9, 3.8093280450947256`*^9}, 
   3.8093280766972446`*^9, {3.8093329812143817`*^9, 3.80933300912864*^9}, {
   3.8093330391517677`*^9, 3.809333050335993*^9}, {3.8093365467645416`*^9, 
   3.809336552499751*^9}, {3.8100270986953735`*^9, 3.8100271870271792`*^9}, {
   3.8100276498574796`*^9, 3.8100276658895574`*^9}, {3.8100296476643085`*^9, 
   3.810029661258322*^9}, {3.8101044611832523`*^9, 3.810104497183741*^9}, 
   3.810104537575389*^9, {3.8101046056549697`*^9, 3.8101046166242332`*^9}, 
   3.81010468204745*^9, 3.8101047182667894`*^9, {3.8101047542209806`*^9, 
   3.810104764674142*^9}, {3.8101048411760817`*^9, 3.8101048540204725`*^9}, {
   3.810105054555794*^9, 3.8101050741967807`*^9}, 3.8101065251667757`*^9, {
   3.8101065558391886`*^9, 3.8101066146842422`*^9}, {3.8101067944693813`*^9, 
   3.81010685515835*^9}, {3.8101068900964503`*^9, 3.8101069104718857`*^9}, {
   3.8101070020367584`*^9, 3.8101070644908514`*^9}, {3.810107127007743*^9, 
   3.810107149477058*^9}, {3.8101071861029615`*^9, 3.8101073271058273`*^9}, {
   3.81010753468847*^9, 3.81010766891008*^9}, {3.8102900910312977`*^9, 
   3.810290104094431*^9}, {3.810293252768174*^9, 3.8102932885812263`*^9}, {
   3.81030675124701*^9, 3.8103067797638607`*^9}, {3.810307189983172*^9, 
   3.81030720734319*^9}, {3.810307396928277*^9, 3.810307397381398*^9}, {
   3.8103076053889246`*^9, 3.8103076124828086`*^9}, {3.8103683376362424`*^9, 
   3.8103683492302647`*^9}, {3.8103710603075852`*^9, 
   3.8103711097637053`*^9}, {3.8103750522785463`*^9, 
   3.8103750527878323`*^9}, {3.81046480209894*^9, 3.810464805677054*^9}, {
   3.8104648519119453`*^9, 3.810464884849893*^9}, {3.810526597769988*^9, 
   3.810526599228246*^9}, {3.8146862063902874`*^9, 3.81468620942505*^9}, {
   3.8179932855209384`*^9, 3.8179933859459686`*^9}, {3.8179934711667953`*^9, 
   3.8179934752606716`*^9}, {3.817993544434509*^9, 3.817993548590946*^9}, {
   3.8179938678184896`*^9, 3.817993870396638*^9}, {3.817993902959841*^9, 
   3.8179939343044004`*^9}, {3.8179939712902584`*^9, 
   3.8179939770399528`*^9}, {3.817994013103382*^9, 3.817994069229924*^9}, {
   3.818059215446555*^9, 3.818059216399418*^9}, {3.818059253775398*^9, 
   3.8180592914816155`*^9}, {3.818070837852042*^9, 3.818070838379886*^9}, {
   3.81807125609661*^9, 3.818071256857532*^9}, {3.8180712954366035`*^9, 
   3.8180713036709375`*^9}, {3.8180713488281584`*^9, 
   3.8180713929087706`*^9}, {3.818071487380561*^9, 3.8180715002849426`*^9}, {
   3.8180715441449146`*^9, 3.8180715443214245`*^9}, {3.8180715949642787`*^9, 
   3.8180716713197336`*^9}, {3.818072028311414*^9, 3.818072136697468*^9}, {
   3.818072171705209*^9, 3.8180721735332155`*^9}, {3.8181345534678907`*^9, 
   3.8181345636243296`*^9}, {3.8181347043250446`*^9, 
   3.8181347407205334`*^9}, {3.8181348069012537`*^9, 
   3.8181348681126833`*^9}, {3.818134929807697*^9, 3.818134951997043*^9}, {
   3.818135008174267*^9, 3.8181350670548973`*^9}, {3.818135991220065*^9, 
   3.818136021174217*^9}, {3.818136058316409*^9, 3.818136072488676*^9}, {
   3.818136133303255*^9, 3.8181361507253704`*^9}, {3.818140997334888*^9, 
   3.8181410102726693`*^9}, {3.8181410535549154`*^9, 
   3.8181410910401063`*^9}, {3.818141194964082*^9, 3.8181412557937565`*^9}, {
   3.8181423493741703`*^9, 3.8181423642648954`*^9}, {3.8181424672818537`*^9, 
   3.8181424995789585`*^9}, {3.818142532314085*^9, 3.818142730222618*^9}, {
   3.818142815537163*^9, 3.8181429356534843`*^9}, {3.818143044769533*^9, 
   3.818143065348751*^9}, {3.818143218294505*^9, 3.818143231717112*^9}, {
   3.8181433441448383`*^9, 3.8181433583957005`*^9}, {3.818143418070445*^9, 
   3.8181434687290688`*^9}, {3.8181435930158625`*^9, 3.818143685629195*^9}, {
   3.8181437528819284`*^9, 3.8181437891645565`*^9}, {3.818143896325016*^9, 
   3.8181440660187483`*^9}, {3.8181458931096287`*^9, 3.818146173426312*^9}, {
   3.818151475546924*^9, 3.8181516115051174`*^9}, {3.818151647332489*^9, 
   3.8181516523324785`*^9}, 3.8181517126766424`*^9, {3.8181517886230183`*^9, 
   3.8181517973184767`*^9}, 3.8181518591869287`*^9, {3.818151894194189*^9, 
   3.818151925245247*^9}, {3.81815240221412*^9, 3.818152523058318*^9}, {
   3.8202988599159083`*^9, 3.8202988620895944`*^9}, {3.8202992017681923`*^9, 
   3.8202992045856953`*^9}, {3.8202992571803756`*^9, 3.820299258305623*^9}, {
   3.820299332213524*^9, 3.820299504889798*^9}, {3.82029954130418*^9, 
   3.8202995429996395`*^9}, {3.8203000437928777`*^9, 3.82030004480836*^9}, {
   3.8203000794269686`*^9, 3.820300108606969*^9}, {3.820300176247085*^9, 
   3.8203003696440535`*^9}, {3.8203004082902737`*^9, 
   3.8203004457554674`*^9}, {3.820300612150039*^9, 3.82030061418146*^9}, {
   3.820300655572935*^9, 3.8203006566508994`*^9}, {3.820301229828264*^9, 
   3.8203014640766325`*^9}, {3.8203015011725473`*^9, 
   3.8203015057351913`*^9}, {3.820301595013321*^9, 3.8203016062890916`*^9}, {
   3.820301827647316*^9, 3.8203018620087476`*^9}, {3.82030189533904*^9, 
   3.820301987485383*^9}, {3.820302068574264*^9, 3.8203021574023952`*^9}, {
   3.8203022150775476`*^9, 3.820302218265806*^9}, {3.820302301311674*^9, 
   3.8203023827160463`*^9}, {3.8203030362168646`*^9, 
   3.8203030367686234`*^9}, {3.8243412501294975`*^9, 3.824341315175481*^9}, {
   3.8243413480315027`*^9, 3.824341407830791*^9}, {3.824341784398752*^9, 
   3.824341800276765*^9}, {3.824342174826269*^9, 3.824342218834298*^9}, {
   3.8243429567962465`*^9, 3.8243429757167273`*^9}, {3.8243568146214075`*^9, 
   3.8243568507975483`*^9}, {3.824356887900546*^9, 3.8243569011722775`*^9}, {
   3.8243570388621864`*^9, 3.8243570403104773`*^9}, {3.824357198058693*^9, 
   3.8243572767614856`*^9}, 3.824357317197325*^9, 3.824357379228897*^9, {
   3.8248826134031134`*^9, 3.8248826167458773`*^9}, {3.8248826836790547`*^9, 
   3.8248826966232443`*^9}, {3.824885159210491*^9, 3.824885174531227*^9}, {
   3.8248855621512556`*^9, 3.8248856169298177`*^9}, {3.8248857060719967`*^9, 
   3.8248857119923296`*^9}, {3.8249550254160695`*^9, 
   3.8249550259473276`*^9}, {3.8254982509773417`*^9, 3.825498277650654*^9}, {
   3.827231090780511*^9, 3.8272311417032833`*^9}, {3.8272312435651956`*^9, 
   3.827231260802016*^9}, {3.8272313024883437`*^9, 3.8272313274946766`*^9}, {
   3.827231483745765*^9, 3.827231484213229*^9}, {3.82818961857297*^9, 
   3.8281896190357227`*^9}, {3.828505808002137*^9, 3.8285058234166813`*^9}, {
   3.8285059186769023`*^9, 3.828505922956532*^9}, {3.828505977597528*^9, 
   3.828505981093603*^9}, {3.828506020319989*^9, 3.828506022653716*^9}, {
   3.8285060630884504`*^9, 3.828506069334998*^9}, {3.8285109861718435`*^9, 
   3.828510992849109*^9}, {3.832149633690675*^9, 3.832149655251933*^9}},
 CellLabel->
  "In[201]:=",ExpressionUUID->"ef4a8e38-7c6b-424d-a4dc-0634896bc416"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`h$$ = 1, $CellContext`k$$ = 
    1, $CellContext`l$$ = 1, $CellContext`Size$$ = 
    7.43, $CellContext`\[Mu]$$ = 2., $CellContext`\[Sigma]$$ = 0.3, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Text[
        Style["Single particle", 16]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Size$$], 7.43, "domain size, D"}, 0.1, 500.}, {
      Hold[
       Grid[{{
          Manipulate`Place[1], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Lognormal domain size distribution", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Mu]$$], 2., "logn. median"}, 0.1, 5.}, {{
       Hold[$CellContext`\[Sigma]$$], 0.1, "logn. std. dev."}, 0.01, 1.}, {
      Hold[
       Grid[{{
          Manipulate`Place[2]}, {
          Manipulate`Place[3]}, {"Mean Size", 
          Dynamic[
           NumberForm[
            $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
          Dynamic[
           NumberForm[
            $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
            5, 2}]], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Reflection indices in cubic crystal system (h>=k>=l)", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`h$$], 1, "h"}, 1, 10, 1}, {{
       Hold[$CellContext`k$$], 1, "k"}, 0, 10, 1}, {{
       Hold[$CellContext`l$$], 1, "l"}, 0, 10, 1}, {
      Hold[
       Grid[{{
          Manipulate`Place[4]}, {
          Manipulate`Place[5]}, {
          Manipulate`Place[6]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {757., {262.5, 267.5}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`h$$ = 1, $CellContext`k$$ = 
        1, $CellContext`l$$ = 1, $CellContext`Size$$ = 
        7.43, $CellContext`\[Mu]$$ = 2., $CellContext`\[Sigma]$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`MeanSize$, $CellContext`StdSize$, \
$CellContext`EffectiveSize$, $CellContext`l1$, $CellContext`l2$, \
$CellContext`l3$}, $CellContext`MeanSize$ = $CellContext`dmean[$CellContext`\
\[Mu]$$, $CellContext`\[Sigma]$$]; $CellContext`StdSize$ = \
$CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]; \
$CellContext`EffectiveSize$ = $CellContext`LV[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$]; {$CellContext`h$$, $CellContext`k$$, \
$CellContext`l$$} = 
         Sort[{$CellContext`h$$, $CellContext`k$$, $CellContext`l$$}, 
           Greater]; $CellContext`l1$ = Plot[{
            ConditionalExpression[
             $CellContext`FTAgen[
             "sphere", $CellContext`L, $CellContext`Size$$, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 1. $CellContext`Size$$]], 
            ConditionalExpression[
             $CellContext`FTAgen[
             "cube", $CellContext`L, $CellContext`Size$$, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 1.5 $CellContext`Size$$]], 
            ConditionalExpression[
             $CellContext`FTAgen[
             "tetrahedron", $CellContext`L, $CellContext`Size$$, \
$CellContext`h$$, $CellContext`k$$, $CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 1. $CellContext`Size$$]], 
            ConditionalExpression[
             $CellContext`FTAgen[
             "octahedron", $CellContext`L, $CellContext`Size$$, \
$CellContext`h$$, $CellContext`k$$, $CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 
              1. $CellContext`Size$$]]}, {$CellContext`L, 0., 
            2.6 $CellContext`Size$$}, 
           PlotRange -> {{0., 2.6 $CellContext`Size$$}, {0, 1}}, 
           PlotStyle -> {Red, Blue, Green, Orange}, PlotStyle -> {Thick}, 
           Frame -> True, 
           FrameLabel -> {{"Fourier Transform", None}, {
             "Fourier length, s (nm)", "Single particle"}}, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           PlotLegends -> Placed[
             PointLegend[{Red, Blue, Green, Orange}, 
              Range[4], LegendMarkers -> {
                Graphics3D[
                 Sphere[], Boxed -> False], 
                Graphics3D[
                 Cube[], Boxed -> False], 
                Graphics3D[
                 Tetrahedron[], Boxed -> False], 
                Graphics3D[
                 Octahedron[], Boxed -> False]}, LegendMarkerSize -> 35], {
             0.9, Top}], ImageSize -> 500]; $CellContext`l2$ = Plot[{
            ConditionalExpression[
             $CellContext`FTASgen[
             "sphere", $CellContext`L, $CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$, $CellContext`h$$, $CellContext`k$$, $CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], 
            ConditionalExpression[
             $CellContext`FTASgen[
             "cube", $CellContext`L, $CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$, $CellContext`h$$, $CellContext`k$$, $CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], 
            ConditionalExpression[
             $CellContext`FTASgen[
             "tetrahedron", $CellContext`L, $CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$, $CellContext`h$$, $CellContext`k$$, \
$CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], 
            ConditionalExpression[
             $CellContext`FTASgen[
             "octahedron", $CellContext`L, $CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$, $CellContext`h$$, $CellContext`k$$, \
$CellContext`l$$], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]]}, {$CellContext`L, 0., 
            2.6 $CellContext`MeanSize$}, 
           PlotRange -> {{0., 2.6 $CellContext`MeanSize$}, {0, 1}}, 
           PlotStyle -> {Red, Blue, Green, Orange}, PlotStyle -> {Thick}, 
           GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], Frame -> 
           True, FrameLabel -> {{"Fourier Transform", None}, {
             "Fourier length, s (nm)", "Lognormal domain size distribution"}},
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           PlotLegends -> Placed[
             PointLegend[{Red, Blue, Green, Orange}, 
              Range[4], LegendMarkers -> {
                Graphics3D[
                 Sphere[], Boxed -> False], 
                Graphics3D[
                 Cube[], Boxed -> False], 
                Graphics3D[
                 Tetrahedron[], Boxed -> False], 
                Graphics3D[
                 Octahedron[], Boxed -> False]}, LegendMarkerSize -> 35], {
             0.9, Top}], ImageSize -> 500]; $CellContext`l3$ = Plot[
           $CellContext`G[$CellContext`x, $CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], {$CellContext`x, 0., $CellContext`MeanSize$ + 
            6 $CellContext`StdSize$}, PlotRange -> Full, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, 
           FrameLabel -> {{"\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)", None}, {
             "domain size, D  (nm)", "Lognormal domain size distribution"}}, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           Epilog -> {Red, Thick, {
              Arrow[{{
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                 $CellContext`G[
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}], 
              Arrow[{{
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                 $CellContext`G[
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}]}}, ImageSize -> 
           500]; Grid[{{$CellContext`l1$}, {$CellContext`l2$, \
$CellContext`l3$}}]], "Specifications" :> {
        Text[
         Style[
         "Single particle", 16]], {{$CellContext`Size$$, 7.43, 
          "domain size, D"}, 0.1, 500., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 1}, 
        Grid[{{
           Manipulate`Place[1], "nm"}}], Delimiter, 
        Text[
         Style[
         "Lognormal domain size distribution", 16]], {{$CellContext`\[Mu]$$, 
          2., "logn. median"}, 0.1, 5., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         2}, {{$CellContext`\[Sigma]$$, 0.1, "logn. std. dev."}, 0.01, 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, 
        Grid[{{
           Manipulate`Place[2]}, {
           Manipulate`Place[3]}, {"Mean Size", 
           Dynamic[
            NumberForm[
             $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
           Dynamic[
            NumberForm[
             $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
             5, 2}]], "nm"}}], Delimiter, 
        Text[
         Style[
         "Reflection indices in cubic crystal system (h>=k>=l)", 
          16]], {{$CellContext`h$$, 1, "h"}, 1, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         4}, {{$CellContext`k$$, 1, "k"}, 0, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`l$$, 1, "l"}, 0, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 6}, 
        Grid[{{
           Manipulate`Place[4]}, {
           Manipulate`Place[5]}, {
           Manipulate`Place[6]}}]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Fourier transform of mean size & size distribution\n"}, LabelStyle -> 
        Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1163., {316., 321.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`dmean[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       E^($CellContext`\[Mu] + $CellContext`\[Sigma]^2/
          2), $CellContext`\[Sigma]$$ = 0.3, $CellContext`sd[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Sqrt[E^(2 $CellContext`\[Mu] + $CellContext`\[Sigma]^2) (
          E^($CellContext`\[Sigma]^2) - 1)], $CellContext`LV[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := (3/4) 
        E^($CellContext`\[Mu] + (7 $CellContext`\[Sigma]^2)/
           2), $CellContext`k$$[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       1/$CellContext`s[$CellContext`\[Theta]2, $CellContext`\[Lambda]], \
$CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`\[Lambda] = 
       0.14249059611887502`, $CellContext`FTAgen[
         Pattern[$CellContext`type, 
          Blank[]], 
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`d, 
          Blank[]], 
         Pattern[$CellContext`h, 
          Blank[]], 
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`l, 
          Blank[]]] := Piecewise[{{1., $CellContext`L == 0}}, 
         Block[{$CellContext`t = 
           Sqrt[$CellContext`h^2 + $CellContext`k^2 + $CellContext`l^2], \
$CellContext`A = $CellContext`h/$CellContext`t, $CellContext`B = \
$CellContext`k/$CellContext`t, 
           C = $CellContext`l/$CellContext`t, $CellContext`H = Range[4], K = 
           1}, Which[$CellContext`type == "sphere", {
            Part[$CellContext`H, 0] = 1, Part[$CellContext`H, 1] = -1.5, 
             Part[$CellContext`H, 2] = 0, Part[$CellContext`H, 3] = 1/2, K = 
             1}, $CellContext`type == "cube", {
            Part[$CellContext`H, 0] = 1, 
             Part[$CellContext`H, 1] = -($CellContext`A + $CellContext`B + C),
              Part[$CellContext`H, 
               2] = $CellContext`A $CellContext`B + $CellContext`B C + 
              C $CellContext`A, 
             Part[$CellContext`H, 3] = (-$CellContext`A) $CellContext`B C, 
             K = $CellContext`A}, $CellContext`type == "tetrahedron", 
            
            If[$CellContext`A >= $CellContext`B + C, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = (-3) Sqrt[2] $CellContext`A, 
              Part[$CellContext`H, 2] = 6 $CellContext`A^2, 
              Part[$CellContext`H, 3] = (-2) Sqrt[2] $CellContext`A^3, K = 
              Sqrt[2] $CellContext`A}, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 
                1] = -((3 ($CellContext`A + $CellContext`B + C))/Sqrt[2]), 
              Part[$CellContext`H, 2] = (
                3 ($CellContext`A + $CellContext`B + C)^2)/2, 
              Part[$CellContext`H, 
                3] = -(($CellContext`A + $CellContext`B + C)^3/(2 Sqrt[2])), 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[
               2]}], $CellContext`type == "octahedron", 
            
            If[$CellContext`A >= $CellContext`B + C, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = -((3 $CellContext`A)/Sqrt[2]), 
              Part[$CellContext`H, 2] = 
              3 (($CellContext`A^2 - $CellContext`B^2 - C^2)/2), 
              Part[$CellContext`H, 3] = (-$CellContext`A^3 + 
                3 $CellContext`A ($CellContext`B^2 + C^2) + 
                2 ($CellContext`B^3 + C^3))/(2 Sqrt[2]), 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[2]}, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = -(
                3 (($CellContext`A + $CellContext`B + C)/(2 Sqrt[2]))), 
              Part[$CellContext`H, 2] = -(
                3 (($CellContext`A^2 + ($CellContext`B - C)^2 - 
                  2 $CellContext`A ($CellContext`B + C))/4)), 
              Part[$CellContext`H, 3] = ($CellContext`A^3 + $CellContext`B^3 + 
                C^3 - 3 $CellContext`A $CellContext`B C)/Sqrt[2], 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[2]}]]; 
          Sum[Part[$CellContext`H, $CellContext`n] (
              Abs[$CellContext`L]/$CellContext`d)^$CellContext`n, \
{$CellContext`n, 0, 3}]]], $CellContext`FTASgen[
         Pattern[$CellContext`type, 
          Blank[]], 
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`h, 
          Blank[]], 
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`l, 
          Blank[]]] := Piecewise[{{1., $CellContext`L == 0}}, 
         Block[{$CellContext`t = 
           Sqrt[$CellContext`h^2 + $CellContext`k^2 + $CellContext`l^2], \
$CellContext`A = $CellContext`h/$CellContext`t, $CellContext`B = \
$CellContext`k/$CellContext`t, 
           C = $CellContext`l/$CellContext`t, $CellContext`H = Range[4], K = 
           1}, Which[$CellContext`type == "sphere", {
            Part[$CellContext`H, 0] = 1, Part[$CellContext`H, 1] = -1.5, 
             Part[$CellContext`H, 2] = 0, Part[$CellContext`H, 3] = 0.5, K = 
             1}, $CellContext`type == "cube", {
            Part[$CellContext`H, 0] = 1, 
             Part[$CellContext`H, 1] = -($CellContext`A + $CellContext`B + C),
              Part[$CellContext`H, 
               2] = $CellContext`A $CellContext`B + $CellContext`B C + 
              C $CellContext`A, 
             Part[$CellContext`H, 3] = (-$CellContext`A) $CellContext`B C, 
             K = $CellContext`A}, $CellContext`type == "tetrahedron", 
            
            If[$CellContext`A >= $CellContext`B + C, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = (-3) Sqrt[2] $CellContext`A, 
              Part[$CellContext`H, 2] = 6 $CellContext`A^2, 
              Part[$CellContext`H, 3] = (-2) Sqrt[2] $CellContext`A^3, K = 
              Sqrt[2] $CellContext`A}, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 
                1] = -((3 ($CellContext`A + $CellContext`B + C))/Sqrt[2]), 
              Part[$CellContext`H, 2] = (
                3 ($CellContext`A + $CellContext`B + C)^2)/2, 
              Part[$CellContext`H, 
                3] = -(($CellContext`A + $CellContext`B + C)^3/(2 Sqrt[2])), 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[
               2]}], $CellContext`type == "octahedron", 
            
            If[$CellContext`A >= $CellContext`B + C, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = -((3 $CellContext`A)/Sqrt[2]), 
              Part[$CellContext`H, 2] = 
              3 (($CellContext`A^2 - $CellContext`B^2 - C^2)/2), 
              Part[$CellContext`H, 3] = (-$CellContext`A^3 + 
                3 $CellContext`A ($CellContext`B^2 + C^2) + 
                2 ($CellContext`B^3 + C^3))/(2 Sqrt[2]), 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[2]}, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = -(
                3 (($CellContext`A + $CellContext`B + C)/(2 Sqrt[2]))), 
              Part[$CellContext`H, 2] = -(
                3 (($CellContext`A^2 + ($CellContext`B - C)^2 - 
                  2 $CellContext`A ($CellContext`B + C))/4)), 
              Part[$CellContext`H, 3] = ($CellContext`A^3 + $CellContext`B^3 + 
                C^3 - 3 $CellContext`A $CellContext`B C)/Sqrt[2], 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[2]}]]; 
          Sum[Part[$CellContext`H, $CellContext`n] 
            Erfc[(Log[Abs[$CellContext`L] K] - $CellContext`\[Mu] - (
                3 - $CellContext`n) $CellContext`\[Sigma]^2)/($CellContext`\
\[Sigma] Sqrt[2])] (
             E^((3 - $CellContext`n) $CellContext`\[Mu] + ((
                   3 - $CellContext`n)^2/2) $CellContext`\[Sigma]^2)/(2 
             E^(3 $CellContext`\[Mu] + (9/2) $CellContext`\[Sigma]^2))) 
            Abs[$CellContext`L]^$CellContext`n, {$CellContext`n, 0, 
             3}]]], $CellContext`G[
         Pattern[$CellContext`d, 
          Blank[]], 
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Piecewise[{{0., $CellContext`d <= 0}}, 1/(
         E^((Log[$CellContext`d] - $CellContext`\[Mu])^2/(
           2 $CellContext`\[Sigma]^2)) ($CellContext`d $CellContext`\[Sigma] 
          Sqrt[2 Pi]))]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8272311431690063`*^9, 3.8272312634870043`*^9, 3.8272313284977813`*^9, {
   3.827400704986519*^9, 3.8274007235652885`*^9}, 3.827465123066655*^9, 
   3.827465873506243*^9, 3.8274699248032804`*^9, 3.827475456836932*^9, 
   3.827475612838875*^9, 3.82748192913471*^9, 3.827562267055532*^9, 
   3.827562805220461*^9, 3.827840317494484*^9, 3.8281878466631927`*^9, 
   3.828352560186387*^9, 3.828505830448804*^9, 3.8285059240269594`*^9, 
   3.8285060244017425`*^9, 3.828510855688053*^9, 3.828515570886392*^9, 
   3.828688276249315*^9, 3.832149534453823*^9, {3.832149640330881*^9, 
   3.8321496575799165`*^9}},
 CellLabel->
  "Out[201]=",ExpressionUUID->"c24345ef-725b-458c-9066-086d9c2bc399"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FT of size distribution - different hkl\
\[CloseCurlyQuote]s", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.809159709373041*^9, 3.8091597165513396`*^9}, {
  3.8281886153584623`*^9, 3.828188622646639*^9}},
 CellTags->"Title",ExpressionUUID->"614fb7d8-b5b8-4315-b0cc-39cf1a5d0d88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "MeanSize", ",", "StdSize", ",", " ", "EffectiveSize", ",", "hkl", ",",
         "tbl1", ",", "tbl2", ",", "l1", ",", "l2", ",", "l3"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"MeanSize", "            ", "=", 
        RowBox[{"dmean", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"StdSize", "              ", "=", 
        RowBox[{"sd", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"EffectiveSize", "=", 
        RowBox[{"LV", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"hkl", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tbl1", "=", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", "               ", 
         RowBox[{
          RowBox[{"shape", "\[Equal]", "1"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{
               "\"\<sphere\>\"", ",", "           ", "L", ",", "Size", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.0", " ", "Size"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"shape", "\[Equal]", "2"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{
               "\"\<cube\>\"", ",", "                ", "L", ",", "Size", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.5", " ", "Size"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"shape", "\[Equal]", "3"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{"\"\<tetrahedron\>\"", ",", "L", ",", "Size", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.0", " ", "Size"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"shape", "\[Equal]", "4"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTAgen", "[", 
               RowBox[{"\"\<octahedron\>\"", ",", "  ", "L", ",", "Size", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", 
               RowBox[{"1.0", " ", "Size"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}]}], " ", 
         "\[IndentingNewLine]", "              ", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
       RowBox[{"l1", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{"tbl1", ",", "\[IndentingNewLine]", "                  ", 
          RowBox[{"{", 
           RowBox[{"L", ",", "0.0", ",", 
            RowBox[{"2.6", " ", "Size"}]}], "}"}], ",", "\[IndentingNewLine]",
           "                   ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.0", ",", 
               RowBox[{"2.6", "Size"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Green", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Orange", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Yellow", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<Fourier Transform\>\"", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<Fourier length, s (nm)\>\"", ",", 
               "\"\<Single particle\>\""}], "}"}]}], "}"}]}], ",", "  ", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                   ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                   ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                    ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"PointLegend", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "Red", ",", "Blue", ",", "Green", ",", "Orange", ",", 
                 "Yellow"}], "}"}], ",", 
               RowBox[{"Range", "[", "5", "]"}], ",", "\[IndentingNewLine]", 
               "                                           ", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<1 0 0 \>\"", ",", "\"\<1 1 0 \>\"", ",", 
                  "\"\<1 1 1 \>\"", ",", "\"\<2 0 0 \>\"", ",", 
                  "\"\<2 1 0 \>\""}], "}"}]}], ",", "  ", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "35"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "        ", "             ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                  ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"tbl2", "=", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", "               ", 
         RowBox[{
          RowBox[{"shape", "\[Equal]", "1"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<sphere\>\"", ",", "           ", "L", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"shape", "\[Equal]", "2"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<cube\>\"", ",", "                ", "L", ",", "\[Mu]", 
                ",", "\[Sigma]", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"shape", "\[Equal]", "3"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<tetrahedron\>\"", ",", "L", ",", "\[Mu]", ",", "\[Sigma]",
                 ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"shape", "\[Equal]", "4"}], ",", " ", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"ConditionalExpression", "[", 
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<octahedron\>\"", ",", "  ", "L", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
                RowBox[{"hkl", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}], ",", 
              RowBox[{"0", "\[LessEqual]", "L", "<", " ", 
               RowBox[{"(", " ", 
                RowBox[{"MeanSize", "+", 
                 RowBox[{"6", " ", "StdSize"}]}], ")"}]}]}], "]"}], "  ", ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", 
              RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}]}], " ", 
         "\[IndentingNewLine]", "              ", "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "  ", 
       RowBox[{"l2", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{"tbl2", ",", "\[IndentingNewLine]", "                    ", 
          RowBox[{"{", 
           RowBox[{"L", ",", " ", "0.", ",", 
            RowBox[{"2.6", " ", "MeanSize"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0.0", ",", 
               RowBox[{"2.6", " ", "MeanSize"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Red", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Green", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Orange", ",", "Thick"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Yellow", ",", "Thick"}], "}"}]}], "}"}]}], ",", 
          "                    ", "\[IndentingNewLine]", 
          "                    ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                    ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<Fourier Transform\>\"", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<Fourier length, s (nm)\>\"", ",", 
               "\"\<Lognormal domain size distribution\>\""}], "}"}]}], 
            "}"}]}], ",", "  ", "\[IndentingNewLine]", "                    ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                    ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                    ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                    ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"PointLegend", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "Red", ",", "Blue", ",", "Green", ",", "Orange", ",", 
                 "Yellow"}], "}"}], ",", 
               RowBox[{"Range", "[", "5", "]"}], ",", "\[IndentingNewLine]", 
               "                                           ", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                 "\"\<1 0 0 \>\"", ",", "\"\<1 1 0 \>\"", ",", 
                  "\"\<1 1 1 \>\"", ",", "\"\<2 1 0 \>\"", ",", 
                  "\"\<2 1 1 \>\""}], "}"}]}], ",", "  ", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "35"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "        ", "        ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                   ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "        ", 
       RowBox[{"l3", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"G", "[", 
           RowBox[{"x", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
          "                ", "\[IndentingNewLine]", "                ", 
          RowBox[{"{", 
           RowBox[{"x", ",", " ", "0.", ",", " ", 
            RowBox[{"MeanSize", " ", "+", " ", 
             RowBox[{"6", " ", "StdSize"}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                 ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                 ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)\>\"", ",", "None"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<domain size, D  (nm)\>\"", ",", 
               "\"\<Lognormal domain size distribution\>\""}], "}"}]}], 
            "}"}]}], ",", "  ", "\[IndentingNewLine]", "                 ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                 ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                 ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tooltip", "[", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], "]"}], "]"}], ",", 
                 RowBox[{"Tooltip", "[", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{",", "0"}], "}"}], "]"}], "]"}]}], "}"}]}], 
              "}"}]}], ","}], " ", "*)"}], "\[IndentingNewLine]", 
          "                 ", 
          RowBox[{"(*", "  ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", "Thick", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
                 "  ", 
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"LV", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "      ", ",", 
                    "0"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"LV", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "       ", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"LV", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "      ", 
                    "\[Mu]", ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], 
                  "]"}]}], "}"}]}], " ", "}"}]}], ","}], " ", "*)"}], 
          "\[IndentingNewLine]", "                ", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", " ", "Thick", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
               "  ", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
              "}"}]}], " ", "}"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", " ", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", "Thick", ",", " ", 
               RowBox[{"Arrow", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                   RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
            ","}], "*)"}], "\[IndentingNewLine]", "                  ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "l1", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l2", ",", "l3"}], "}"}]}], "}"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Single particle\>\"", ",", "16"}], "]"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "         ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Size", ",", "7.43", ",", "\"\<domain size, D\>\""}], 
            "}"}], ",", "0.1", ",", " ", "500.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<nm\>\""}], "}"}], "\[IndentingNewLine]", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "  ", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Lognormal domain size distribution\>\"", ",", "16"}], 
      "]"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "         ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Mu]", ",", "2.", ",", "\"\<logn. median\>\""}], "}"}], 
           ",", "0.1", ",", " ", "5.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Sigma]", ",", ".1", ",", "\"\<logn. std. dev.\>\""}], 
            "}"}], ",", "0.01", ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Mean Size\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"dmean", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Std. dev.\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"sd", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}]}], "\[IndentingNewLine]", "        ", 
      RowBox[{"(*", " ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Effect. Size /nm \>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"LV", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}]}], "}"}], "*)"}], 
      "\[IndentingNewLine]", "}"}], "]"}], ",", "\[IndentingNewLine]", "  ", 
    "Delimiter", ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Shape of particles (in the cubic system)\>\"", ",", "16"}],
       "]"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{"shape", ",", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"1", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Sphere", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", " ", 
         "\[IndentingNewLine]", "                                 ", 
         RowBox[{"2", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Cube", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", "                                 ", 
         RowBox[{"3", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Tetrahedron", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", "                                 ", 
         RowBox[{"4", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Octahedron", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], "}"}], ",", 
       "RadioButtonBar"}], "}"}]}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
       "\"\<Fourier transform of mean size & size distribution for \
differently shaped particles\\n\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", 
    "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ","}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", "  ", 
     RowBox[{
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.8093210929765987`*^9, 3.809321112527949*^9}, {
   3.809321168618717*^9, 3.8093211687905836`*^9}, {3.809321270972602*^9, 
   3.809321308095614*^9}, {3.809324927588235*^9, 3.809325039956688*^9}, {
   3.809325782913205*^9, 3.8093258254276285`*^9}, {3.809325872385377*^9, 
   3.8093258850361786`*^9}, {3.809328014685336*^9, 3.8093280450947256`*^9}, 
   3.8093280766972446`*^9, {3.8093329812143817`*^9, 3.80933300912864*^9}, {
   3.8093330391517677`*^9, 3.809333050335993*^9}, {3.8093365467645416`*^9, 
   3.809336552499751*^9}, {3.8100270986953735`*^9, 3.8100271870271792`*^9}, {
   3.8100276498574796`*^9, 3.8100276658895574`*^9}, {3.8100296476643085`*^9, 
   3.810029661258322*^9}, {3.8101044611832523`*^9, 3.810104497183741*^9}, 
   3.810104537575389*^9, {3.8101046056549697`*^9, 3.8101046166242332`*^9}, 
   3.81010468204745*^9, 3.8101047182667894`*^9, {3.8101047542209806`*^9, 
   3.810104764674142*^9}, {3.8101048411760817`*^9, 3.8101048540204725`*^9}, {
   3.810105054555794*^9, 3.8101050741967807`*^9}, 3.8101065251667757`*^9, {
   3.8101065558391886`*^9, 3.8101066146842422`*^9}, {3.8101067944693813`*^9, 
   3.81010685515835*^9}, {3.8101068900964503`*^9, 3.8101069104718857`*^9}, {
   3.8101070020367584`*^9, 3.8101070644908514`*^9}, {3.810107127007743*^9, 
   3.810107149477058*^9}, {3.8101071861029615`*^9, 3.8101073271058273`*^9}, {
   3.81010753468847*^9, 3.81010766891008*^9}, {3.8102900910312977`*^9, 
   3.810290104094431*^9}, {3.810293252768174*^9, 3.8102932885812263`*^9}, {
   3.81030675124701*^9, 3.8103067797638607`*^9}, {3.810307189983172*^9, 
   3.81030720734319*^9}, {3.810307396928277*^9, 3.810307397381398*^9}, {
   3.8103076053889246`*^9, 3.8103076124828086`*^9}, {3.8103683376362424`*^9, 
   3.8103683492302647`*^9}, {3.8103710603075852`*^9, 
   3.8103711097637053`*^9}, {3.8103750522785463`*^9, 
   3.8103750527878323`*^9}, {3.81046480209894*^9, 3.810464805677054*^9}, {
   3.8104648519119453`*^9, 3.810464884849893*^9}, {3.810526597769988*^9, 
   3.810526599228246*^9}, {3.8146862063902874`*^9, 3.81468620942505*^9}, {
   3.8179932855209384`*^9, 3.8179933859459686`*^9}, {3.8179934711667953`*^9, 
   3.8179934752606716`*^9}, {3.817993544434509*^9, 3.817993548590946*^9}, {
   3.8179938678184896`*^9, 3.817993870396638*^9}, {3.817993902959841*^9, 
   3.8179939343044004`*^9}, {3.8179939712902584`*^9, 
   3.8179939770399528`*^9}, {3.817994013103382*^9, 3.817994069229924*^9}, {
   3.818059215446555*^9, 3.818059216399418*^9}, {3.818059253775398*^9, 
   3.8180592914816155`*^9}, {3.818070837852042*^9, 3.818070838379886*^9}, {
   3.81807125609661*^9, 3.818071256857532*^9}, {3.8180712954366035`*^9, 
   3.8180713036709375`*^9}, {3.8180713488281584`*^9, 
   3.8180713929087706`*^9}, {3.818071487380561*^9, 3.8180715002849426`*^9}, {
   3.8180715441449146`*^9, 3.8180715443214245`*^9}, {3.8180715949642787`*^9, 
   3.8180716713197336`*^9}, {3.818072028311414*^9, 3.818072136697468*^9}, {
   3.818072171705209*^9, 3.8180721735332155`*^9}, {3.8181345534678907`*^9, 
   3.8181345636243296`*^9}, {3.8181347043250446`*^9, 
   3.8181347407205334`*^9}, {3.8181348069012537`*^9, 
   3.8181348681126833`*^9}, {3.818134929807697*^9, 3.818134951997043*^9}, {
   3.818135008174267*^9, 3.8181350670548973`*^9}, {3.818135991220065*^9, 
   3.818136021174217*^9}, {3.818136058316409*^9, 3.818136072488676*^9}, {
   3.818136133303255*^9, 3.8181361507253704`*^9}, {3.818140997334888*^9, 
   3.8181410102726693`*^9}, {3.8181410535549154`*^9, 
   3.8181410910401063`*^9}, {3.818141194964082*^9, 3.8181412557937565`*^9}, {
   3.8181423493741703`*^9, 3.8181423642648954`*^9}, {3.8181424672818537`*^9, 
   3.8181424995789585`*^9}, {3.818142532314085*^9, 3.818142730222618*^9}, {
   3.818142815537163*^9, 3.8181429356534843`*^9}, {3.818143044769533*^9, 
   3.818143065348751*^9}, {3.818143218294505*^9, 3.818143231717112*^9}, {
   3.8181433441448383`*^9, 3.8181433583957005`*^9}, {3.818143418070445*^9, 
   3.8181434687290688`*^9}, {3.8181435930158625`*^9, 3.818143685629195*^9}, {
   3.8181437528819284`*^9, 3.8181437891645565`*^9}, {3.818143896325016*^9, 
   3.8181440660187483`*^9}, {3.8181458931096287`*^9, 3.818146173426312*^9}, {
   3.818151475546924*^9, 3.8181516115051174`*^9}, {3.818151647332489*^9, 
   3.8181516523324785`*^9}, 3.8181517126766424`*^9, {3.8181517886230183`*^9, 
   3.8181517973184767`*^9}, 3.8181518591869287`*^9, {3.818151894194189*^9, 
   3.818151925245247*^9}, {3.81815240221412*^9, 3.818152523058318*^9}, {
   3.8202988599159083`*^9, 3.8202988620895944`*^9}, {3.8202992017681923`*^9, 
   3.8202992045856953`*^9}, {3.8202992571803756`*^9, 3.820299258305623*^9}, {
   3.820299332213524*^9, 3.820299504889798*^9}, {3.82029954130418*^9, 
   3.8202995429996395`*^9}, {3.8203000437928777`*^9, 3.82030004480836*^9}, {
   3.8203000794269686`*^9, 3.820300108606969*^9}, {3.820300176247085*^9, 
   3.8203003696440535`*^9}, {3.8203004082902737`*^9, 
   3.8203004457554674`*^9}, {3.820300612150039*^9, 3.82030061418146*^9}, {
   3.820300655572935*^9, 3.8203006566508994`*^9}, {3.820301229828264*^9, 
   3.8203014640766325`*^9}, {3.8203015011725473`*^9, 
   3.8203015057351913`*^9}, {3.820301595013321*^9, 3.8203016062890916`*^9}, {
   3.820301827647316*^9, 3.8203018620087476`*^9}, {3.82030189533904*^9, 
   3.820301987485383*^9}, {3.820302068574264*^9, 3.8203021574023952`*^9}, {
   3.8203022150775476`*^9, 3.820302218265806*^9}, {3.820302301311674*^9, 
   3.8203023827160463`*^9}, {3.8203030362168646`*^9, 
   3.8203030367686234`*^9}, {3.8243412501294975`*^9, 3.824341315175481*^9}, {
   3.8243413480315027`*^9, 3.824341407830791*^9}, {3.824341784398752*^9, 
   3.824341800276765*^9}, {3.824342174826269*^9, 3.824342218834298*^9}, {
   3.8243429567962465`*^9, 3.8243429757167273`*^9}, {3.8243568146214075`*^9, 
   3.8243568507975483`*^9}, {3.824356887900546*^9, 3.8243569011722775`*^9}, {
   3.8243570388621864`*^9, 3.8243570403104773`*^9}, {3.824357198058693*^9, 
   3.8243572767614856`*^9}, 3.824357317197325*^9, 3.824357379228897*^9, {
   3.8248826134031134`*^9, 3.8248826167458773`*^9}, {3.8248826836790547`*^9, 
   3.8248826966232443`*^9}, {3.824885159210491*^9, 3.824885174531227*^9}, {
   3.8248855621512556`*^9, 3.8248856169298177`*^9}, {3.8248857060719967`*^9, 
   3.8248857119923296`*^9}, {3.8249550254160695`*^9, 
   3.8249550259473276`*^9}, {3.8254982509773417`*^9, 3.825498277650654*^9}, {
   3.827231090780511*^9, 3.8272311417032833`*^9}, {3.8272312435651956`*^9, 
   3.827231260802016*^9}, {3.8272313024883437`*^9, 3.8272313274946766`*^9}, {
   3.827231483745765*^9, 3.827231484213229*^9}, {3.8281887147369614`*^9, 
   3.8281887519758244`*^9}, {3.828188798235077*^9, 3.828188824008374*^9}, {
   3.8281889260292807`*^9, 3.8281889339630632`*^9}, {3.8281890683075223`*^9, 
   3.828189078519459*^9}, {3.828189170309288*^9, 3.8281892297842493`*^9}, {
   3.8281893822767735`*^9, 3.8281894338699074`*^9}, {3.828189521119772*^9, 
   3.828189590755748*^9}, {3.828189626794451*^9, 3.828189684200942*^9}, {
   3.8281897408003235`*^9, 3.828189900259886*^9}, {3.8281899355107756`*^9, 
   3.8281899567574177`*^9}, {3.828189988331031*^9, 3.828190160705653*^9}, {
   3.828190375123417*^9, 3.8281906314183874`*^9}, {3.8281906867496047`*^9, 
   3.8281907445560784`*^9}, {3.828190892837818*^9, 3.8281909283868437`*^9}, {
   3.8283474762359858`*^9, 3.828347625783256*^9}, {3.828347658302624*^9, 
   3.828347692979757*^9}, {3.828348167263377*^9, 3.8283481709624195`*^9}, {
   3.8283482073436785`*^9, 3.828348255452448*^9}, {3.828348325810521*^9, 
   3.828348480623844*^9}, {3.828506100819674*^9, 3.828506103249611*^9}, {
   3.832149719170274*^9, 3.8321497250918183`*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"f88a6359-607b-4714-82c5-2f44741394a2"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`shape$$ = 1, $CellContext`Size$$ = 
    7.43, $CellContext`\[Mu]$$ = 2., $CellContext`\[Sigma]$$ = 0.1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Text[
        Style["Single particle", 16]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`Size$$], 7.43, "domain size, D"}, 0.1, 500.}, {
      Hold[
       Grid[{{
          Manipulate`Place[1], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Lognormal domain size distribution", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Mu]$$], 2., "logn. median"}, 0.1, 5.}, {{
       Hold[$CellContext`\[Sigma]$$], 0.1, "logn. std. dev."}, 0.01, 1.}, {
      Hold[
       Grid[{{
          Manipulate`Place[2]}, {
          Manipulate`Place[3]}, {"Mean Size", 
          Dynamic[
           NumberForm[
            $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
          Dynamic[
           NumberForm[
            $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
            5, 2}]], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Shape of particles (in the cubic system)", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[$CellContext`shape$$], {1 -> Graphics3D[
         Sphere[{0, 0, 0}], Boxed -> False], 2 -> Graphics3D[
         Cube[], Boxed -> False], 3 -> Graphics3D[
         Tetrahedron[], Boxed -> False], 4 -> Graphics3D[
         Octahedron[], Boxed -> False]}}}, Typeset`size$$ = {
    1009., {349.5, 355.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`shape$$ = 1, $CellContext`Size$$ = 
        7.43, $CellContext`\[Mu]$$ = 2., $CellContext`\[Sigma]$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`MeanSize$, $CellContext`StdSize$, \
$CellContext`EffectiveSize$, $CellContext`hkl$, $CellContext`tbl1$, \
$CellContext`tbl2$, $CellContext`l1$, $CellContext`l2$, $CellContext`l3$}, \
$CellContext`MeanSize$ = $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$]; $CellContext`StdSize$ = \
$CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]; \
$CellContext`EffectiveSize$ = $CellContext`LV[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$]; $CellContext`hkl$ = {{1, 0, 0}, {1, 1, 0}, {1, 1, 
          1}, {2, 1, 0}, {2, 1, 1}}; $CellContext`tbl1$ = 
         Which[$CellContext`shape$$ == 1, 
           Table[
            ConditionalExpression[
             $CellContext`FTAgen[
             "sphere", $CellContext`L, $CellContext`Size$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 
              1. $CellContext`Size$$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}], $CellContext`shape$$ == 2, 
           Table[
            ConditionalExpression[
             $CellContext`FTAgen["cube", $CellContext`L, $CellContext`Size$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 
              1.5 $CellContext`Size$$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}], $CellContext`shape$$ == 3, 
           Table[
            ConditionalExpression[
             $CellContext`FTAgen[
             "tetrahedron", $CellContext`L, $CellContext`Size$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 
              1. $CellContext`Size$$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}], $CellContext`shape$$ == 4, 
           Table[
            ConditionalExpression[
             $CellContext`FTAgen[
             "octahedron", $CellContext`L, $CellContext`Size$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, 
              1. $CellContext`Size$$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}]]; $CellContext`l1$ = 
         Plot[$CellContext`tbl1$, {$CellContext`L, 0., 
            2.6 $CellContext`Size$$}, 
           PlotRange -> {{0., 2.6 $CellContext`Size$$}, {0, 1}}, 
           PlotStyle -> {{Red, Thick}, {Blue, Thick}, {Green, Thick}, {
             Orange, Thick}, {Yellow, Thick}}, Frame -> True, 
           FrameLabel -> {{"Fourier Transform", None}, {
             "Fourier length, s (nm)", "Single particle"}}, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           PlotLegends -> Placed[
             PointLegend[{Red, Blue, Green, Orange, Yellow}, 
              Range[5], 
              LegendMarkers -> {
               "1 0 0 ", "1 1 0 ", "1 1 1 ", "2 0 0 ", "2 1 0 "}, 
              LegendMarkerSize -> 35], {0.9, Top}], ImageSize -> 
           500]; $CellContext`tbl2$ = Which[$CellContext`shape$$ == 1, 
           Table[
            ConditionalExpression[
             $CellContext`FTASgen[
             "sphere", $CellContext`L, $CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}], $CellContext`shape$$ == 2, 
           Table[
            ConditionalExpression[
             $CellContext`FTASgen[
             "cube", $CellContext`L, $CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}], $CellContext`shape$$ == 3, 
           Table[
            ConditionalExpression[
             $CellContext`FTASgen[
             "tetrahedron", $CellContext`L, $CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}], $CellContext`shape$$ == 4, 
           Table[
            ConditionalExpression[
             $CellContext`FTASgen[
             "octahedron", $CellContext`L, $CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$, 
              Part[$CellContext`hkl$, $CellContext`i, 1], 
              Part[$CellContext`hkl$, $CellContext`i, 2], 
              Part[$CellContext`hkl$, $CellContext`i, 3]], 
             Inequality[
             0, LessEqual, $CellContext`L, Less, $CellContext`MeanSize$ + 
              6 $CellContext`StdSize$]], {$CellContext`i, 
             Length[$CellContext`hkl$]}]]; $CellContext`l2$ = 
         Plot[$CellContext`tbl2$, {$CellContext`L, 0., 
            2.6 $CellContext`MeanSize$}, 
           PlotRange -> {{0., 2.6 $CellContext`MeanSize$}, {0, 1}}, 
           PlotStyle -> {{Red, Thick}, {Blue, Thick}, {Green, Thick}, {
             Orange, Thick}, {Yellow, Thick}}, GridLines -> Automatic, 
           GridLinesStyle -> Opacity[0.1], Frame -> True, 
           FrameLabel -> {{"Fourier Transform", None}, {
             "Fourier length, s (nm)", "Lognormal domain size distribution"}},
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           PlotLegends -> Placed[
             PointLegend[{Red, Blue, Green, Orange, Yellow}, 
              Range[5], 
              LegendMarkers -> {
               "1 0 0 ", "1 1 0 ", "1 1 1 ", "2 1 0 ", "2 1 1 "}, 
              LegendMarkerSize -> 35], {0.9, Top}], ImageSize -> 
           500]; $CellContext`l3$ = Plot[
           $CellContext`G[$CellContext`x, $CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], {$CellContext`x, 0., $CellContext`MeanSize$ + 
            6 $CellContext`StdSize$}, PlotRange -> Full, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, 
           FrameLabel -> {{"\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)", None}, {
             "domain size, D  (nm)", "Lognormal domain size distribution"}}, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           Epilog -> {Red, Thick, {
              Arrow[{{
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                 $CellContext`G[
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}], 
              Arrow[{{
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                 $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                 $CellContext`G[
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}]}}, ImageSize -> 
           500]; Grid[{{$CellContext`l1$}, {$CellContext`l2$, \
$CellContext`l3$}}]], "Specifications" :> {
        Text[
         Style[
         "Single particle", 16]], {{$CellContext`Size$$, 7.43, 
          "domain size, D"}, 0.1, 500., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 1}, 
        Grid[{{
           Manipulate`Place[1], "nm"}}], Delimiter, 
        Text[
         Style[
         "Lognormal domain size distribution", 16]], {{$CellContext`\[Mu]$$, 
          2., "logn. median"}, 0.1, 5., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         2}, {{$CellContext`\[Sigma]$$, 0.1, "logn. std. dev."}, 0.01, 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, 
        Grid[{{
           Manipulate`Place[2]}, {
           Manipulate`Place[3]}, {"Mean Size", 
           Dynamic[
            NumberForm[
             $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
           Dynamic[
            NumberForm[
             $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
             5, 2}]], "nm"}}], Delimiter, 
        Text[
         Style[
         "Shape of particles (in the cubic system)", 
          16]], {$CellContext`shape$$, {1 -> Graphics3D[
            Sphere[{0, 0, 0}], Boxed -> False], 2 -> Graphics3D[
            Cube[], Boxed -> False], 3 -> Graphics3D[
            Tetrahedron[], Boxed -> False], 4 -> Graphics3D[
            Octahedron[], Boxed -> False]}, ControlType -> RadioButtonBar}}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Fourier transform of mean size & size distribution for differently \
shaped particles\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1593., {419., 425.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.8281895780550437`*^9, 3.8281895946666384`*^9}, 
   3.8281896667167873`*^9, {3.8281898870116153`*^9, 3.8281899010125213`*^9}, 
   3.828190009036641*^9, 3.828190135026636*^9, 3.828190501836684*^9, 
   3.8281906353733034`*^9, 3.828190714677554*^9, 3.8281909363925548`*^9, 
   3.828347635880678*^9, 3.8283476956038623`*^9, 3.828348171932892*^9, {
   3.8283482115004635`*^9, 3.828348238742259*^9}, {3.8283483270798464`*^9, 
   3.8283483400930996`*^9}, 3.828348380749912*^9, 3.8283484498591847`*^9, 
   3.8283525608940067`*^9, 3.8285058311833997`*^9, 3.8285061078610587`*^9, 
   3.828510858520464*^9, 3.8285155715510454`*^9, 3.828688277120285*^9, 
   3.8321495352818885`*^9, 3.8321497259354734`*^9},
 CellLabel->
  "Out[202]=",ExpressionUUID->"9ce39970-a60e-4acc-9b78-67fdb5244527"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Fourier (back)transform of Pseudo-Voigt function \
convoluted with lognormal size distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.809159709373041*^9, 3.8091597165513396`*^9}, {
  3.8146861797822194`*^9, 3.8146861829539366`*^9}},
 CellTags->"Title",ExpressionUUID->"87089602-e95a-48e2-9bc8-643af66f361b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Quiet", "@", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "MeanSize", ",", "StdSize", ",", " ", "EffectiveSize", ",", "n", ",", 
         "x1", ",", "x2", ",", " ", "deltax", ",", " ", "k1", ",", "k2", ",", 
         " ", "deltak", ",", "grid", ",", " ", "samples1", ",", " ", 
         "samples2", ",", " ", "samples3", ",", "g1", ",", "g1t", ",", " ", 
         "g2", ",", "g3", ",", "l1", ",", "l2", ",", "l2t", ",", "l3"}], 
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"MeanSize", "   ", "=", 
         RowBox[{"dmean", "[", 
          RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"StdSize", "      ", "=", 
         RowBox[{"sd", "[", 
          RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"n", "           ", "=", " ", "2048"}], ";", "  ", 
        RowBox[{"(*", "  ", 
         RowBox[{"multiples", " ", "of", " ", "2"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"deltak", "=", 
         RowBox[{"10", "  ", 
          RowBox[{"MeanSize", "/", "n"}]}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"k1", "         ", "=", "          ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"n", "/", "2"}], ")"}]}], "   ", "deltak"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "         ", "=", "   ", 
         RowBox[{"k1", " ", "+", "   ", 
          RowBox[{"n", "           ", "deltak"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"grid", "     ", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"k1", ",", "k2", ",", "deltak"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"samples1", " ", "=", "  ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"FTPVoigt", "[", 
             RowBox[{"#", ",", "\[Eta]", ",", 
              RowBox[{
               RowBox[{"cs", "[", 
                RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}], "  ", 
               "hwhm"}]}], "]"}], "&"}], ",", " ", "grid"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"h", ",", "k", ",", "l"}], "}"}], "=", 
         RowBox[{"Sort", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"h", ",", "k", ",", "l"}], "}"}], ",", "Greater"}], 
          "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"shape", "\[Equal]", "1"}], ",", " ", 
          RowBox[{"samples2", " ", "=", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<sphere\>\"", ",", "            ", "#", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], " ", "&"}],
              ",", " ", "grid"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"shape", "\[Equal]", "2"}], ",", " ", 
          RowBox[{"samples2", " ", "=", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<cube\>\"", ",", "                ", "#", ",", "\[Mu]", 
                ",", "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], " ", 
              "&"}], ",", " ", "grid"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"shape", "\[Equal]", "3"}], ",", " ", 
          RowBox[{"samples2", " ", "=", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<tetrahedron\>\"", ",", "#", ",", "\[Mu]", ",", "\[Sigma]",
                 ",", "h", ",", "k", ",", "l"}], "]"}], " ", "&"}], ",", " ", 
             "grid"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"shape", "\[Equal]", "4"}], ",", " ", 
          RowBox[{"samples2", " ", "=", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"FTASgen", "[", 
               RowBox[{
               "\"\<octahedron\>\"", ",", "  ", "#", ",", "\[Mu]", ",", 
                "\[Sigma]", ",", "h", ",", "k", ",", "l"}], "]"}], " ", "&"}],
              ",", " ", "grid"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"samples3", " ", "=", " ", 
         RowBox[{"samples1", "*", "samples2"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"g1", "            ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{"grid", ",", "samples1"}], "}"}], "]"}], ",", "1.0"}], 
            "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", 
        RowBox[{"g2", "            ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{"grid", ",", "samples2"}], "}"}], "]"}], ",", "1.0"}], 
            "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", 
        RowBox[{"g3", "            ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{"grid", ",", "samples3"}], "}"}], "]"}], ",", "1.0"}], 
            "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"x1", "            ", "=", " ", 
         RowBox[{"10", " ", 
          SuperscriptBox["k1", 
           RowBox[{"-", "1"}]]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x2", "            ", "=", " ", 
         RowBox[{"10", " ", 
          SuperscriptBox["k2", 
           RowBox[{"-", "1"}]]}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"\[Theta]2", "[", 
           RowBox[{
            RowBox[{"1", "/", "k1"}], ",", "lambda"}], "]"}], ";"}], " ", 
         "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"l1", "=", " ", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"samples1", ",", " ", "samples2", ",", " ", "samples3"}], 
            "}"}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"k1", ",", "k2"}], "}"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", " ", 
               RowBox[{
                RowBox[{"k1", "/", "kMag"}], ",", "  ", 
                RowBox[{"k2", "/", "kMag"}]}], "}"}], ",", "Full"}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<Fourier length, s (nm)\>\"", ",", 
              "\"\<Fourier Transform\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<FT of peak shape\>\"", ",", "\"\<FT of size distr.\>\"", 
                 ",", "\"\<FT of convolution\>\""}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"l2", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"g1", "[", "x", "]"}], " ", ",", 
             RowBox[{"g2", "[", "x", "]"}], ",", 
             RowBox[{"g3", "[", "x", "]"}]}], "}"}], ",", 
           "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{"x1", "/", "xMag"}], ",", 
             RowBox[{"x2", "/", "xMag"}]}], "}"}], ",", "\[IndentingNewLine]",
            "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x1", "/", "xMag"}], ",", " ", 
                RowBox[{"x2", "/", "xMag"}]}], "}"}], ",", "Full"}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<rel. \!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<peak shape\>\"", ",", "\"\<size distribution\>\"", ",", 
                 "\"\<convolution\>\""}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"l2t", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"g1", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"x", "-", "\[Theta]\[Theta]"}], ",", "lambda"}], 
                "]"}], "]"}], 
              RowBox[{"cs", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"g2", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"x", "-", "\[Theta]\[Theta]"}], ",", "lambda"}], 
                "]"}], "]"}], 
              RowBox[{"cs", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"g3", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"x", "-", "\[Theta]\[Theta]"}], ",", "lambda"}], 
                "]"}], "]"}], 
              RowBox[{"cs", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}]}], "}"}], 
           ",", "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{
                RowBox[{"x1", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
              "\[Theta]\[Theta]"}], ",", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{
                RowBox[{"x2", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
              "\[Theta]\[Theta]"}]}], "}"}], ",", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"\[Theta]2", "[", 
                  RowBox[{
                   RowBox[{"x1", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
                 "\[Theta]\[Theta]"}], ",", " ", 
                RowBox[{
                 RowBox[{"\[Theta]2", "[", 
                  RowBox[{
                   RowBox[{"x2", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
                 "\[Theta]\[Theta]"}]}], "}"}], ",", "Full"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta]  (\[Degree])\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<peak shape\>\"", ",", "\"\<size distribution\>\"", ",", 
                 "\"\<convolution\>\""}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"l3", "=", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"G", "[", 
            RowBox[{"x", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
           "                ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", "0.", ",", 
             RowBox[{"MeanSize", " ", "+", " ", 
              RowBox[{"6", " ", "StdSize"}]}]}], "}"}], ",", 
           "\[IndentingNewLine]", "\t\t\t\t\t\t  ", 
           RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<domain size, D  (nm)\>\"", ",", 
              "\"\<\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)\>\""}], "}"}]}], ",",
            "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Lognormal domain size distribution\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.7", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Epilog", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Red", ",", 
                RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Tooltip", "[", 
                   RowBox[{"Point", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], "]"}], "]"}], ",", 
                  RowBox[{"Tooltip", "[", 
                   RowBox[{"Point", "[", 
                    RowBox[{"{", 
                    RowBox[{",", "0"}], "}"}], "]"}], "]"}]}], "}"}]}], 
               "}"}]}], ","}], " ", "*)"}], "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"Epilog", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", " ", "Thick", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
                " ", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
               "}"}]}], " ", "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Epilog", "\[Rule]", " ", 
              RowBox[{"{", 
               RowBox[{"Red", ",", " ", 
                RowBox[{"Arrow", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
             ","}], " ", "*)"}], "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Grid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"l1", ",", "l2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l2t", ",", "l3"}], "}"}]}], "}"}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Lognormal domain size distribution\>\"", ",", "16"}], 
      "]"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "         ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Mu]", ",", "3.", ",", "\"\<lognormal mean\>\""}], 
            "}"}], ",", "0.1", ",", " ", "5.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\[Sigma]", ",", ".1", ",", "\"\<lognormal std. dev.\>\""}], 
            "}"}], ",", "0.01", ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Mean Size\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"dmean", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}], ",", "\[IndentingNewLine]", "         ", 
       RowBox[{"{", "  ", 
        RowBox[{"\"\<Std. dev.\>\"", ",", " ", 
         RowBox[{"Dynamic", "@", 
          RowBox[{"NumberForm", "[", 
           RowBox[{
            RowBox[{"sd", "[", 
             RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
        "}"}]}], "         ", "\[IndentingNewLine]", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{"shape", ",", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"1", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Sphere", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", " ", 
         "\[IndentingNewLine]", "                                 ", 
         RowBox[{"2", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Cube", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", "                                 ", 
         RowBox[{"3", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Tetrahedron", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", "                                 ", 
         RowBox[{"4", "->", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{
            RowBox[{"Octahedron", "[", "]"}], ",", 
            RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], "}"}], ",", 
       "RadioButtonBar"}], "}"}]}], ",", "\[IndentingNewLine]", " ", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Reflection indices in cubic crystal system (h>=k>=l)\>\"", ",", 
       "16"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", "1", ",", "\"\<h\>\""}], "}"}], ",", "1", ",", " ", 
       "10", ",", "1", ",", "Slider", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "\"\<k\>\""}], "}"}], ",", "0", ",", " ", 
       "10", ",", "1", ",", "Slider", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"l", ",", "0", ",", "\"\<l\>\""}], "}"}], ",", "0", ",", " ", 
       "10", ",", "1", ",", "Slider", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", " ", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Pseudo-Voigt function\>\"", ",", "16"}], "]"}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\[Eta]", ",", "      ", "0.5", ",", "\"\<mixing param. \>\""}], 
            "}"}], ",", "0.", ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
             "hwhm", ",", "0.1", ",", "\"\<half width at half maximum\>\""}], 
             "}"}], ",", "0.001", ",", " ", "2.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\[Degree]2\[Theta]\>\""}], "}"}]}], "\[IndentingNewLine]", 
      "}"}], "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "               ", 
      RowBox[{
       RowBox[{"{", "   ", 
        RowBox[{"\"\<peak position\>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Theta]\[Theta]", ",", " ", "45.", ",", "\"\<\>\""}], 
             "}"}], ",", "    ", "1.", ",", "   ", "179.0", ",", " ", 
            "Slider", ",", " ", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
       "              ", "\[IndentingNewLine]", "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<wavelength   \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lambda", ",", "  ", "0.154", ",", "\"\<\>\""}], "}"}], 
            ",", " ", "0.01", ",", "   ", "0.3", ",", "  ", "Slider", ",", 
            " ", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<nm\>\""}], "}"}]}], "               ", 
      "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Zoom factors\>\"", ",", "16"}], "]"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "       ", 
            RowBox[{"xMag", ",", "1."}], "}"}], ",", "0.1", ",", " ", "10.", 
           ",", "0.1", ",", "Slider", ",", 
           RowBox[{"Exclusions", "\[Rule]", 
            RowBox[{"{", "0", "}"}]}], ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", "}"}], ",", " ", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "       ", 
            RowBox[{"kMag", ",", "1."}], "}"}], ",", "0.1", ",", " ", "10.", 
           ",", "0.1", ",", "Slider", ",", 
           RowBox[{"Exclusions", "\[Rule]", 
            RowBox[{"{", "0", "}"}]}], ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}]}], " ", "\[IndentingNewLine]", "}"}], "]"}], ",", " ", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
       "\"\<Fourier (back)transform of Pseudo-Voigt function convoluted with \
lognormal domain size distribution\\n\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", 
    "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", "  ", 
     RowBox[{
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7990519264473877`*^9, 3.799051926962989*^9}, {
   3.7990519614593573`*^9, 3.799052026988535*^9}, {3.799052078908862*^9, 
   3.7990521378860164`*^9}, {3.7991199675173535`*^9, 
   3.7991199730024023`*^9}, {3.7991201568905897`*^9, 
   3.7991201834982595`*^9}, {3.7991202156536255`*^9, 
   3.7991202519342046`*^9}, {3.799120313459937*^9, 3.799120337227936*^9}, {
   3.799120495825898*^9, 3.7991204969823923`*^9}, {3.7991211294355335`*^9, 
   3.7991211432190757`*^9}, {3.7991214271026497`*^9, 
   3.7991215023012996`*^9}, {3.7991215778593035`*^9, 3.799121626027424*^9}, {
   3.7991448624053364`*^9, 3.7991449148510504`*^9}, {3.799145083200984*^9, 
   3.799145098640134*^9}, {3.799145174322327*^9, 3.7991452033592834`*^9}, {
   3.7991454730901756`*^9, 3.799145479184555*^9}, {3.7991455263947115`*^9, 
   3.7991455571180277`*^9}, {3.7991456376507683`*^9, 3.799145650527478*^9}, {
   3.7991457847406616`*^9, 3.799145797142044*^9}, {3.7992242314229536`*^9, 
   3.79922431989464*^9}, {3.7992243723608894`*^9, 3.7992244458312597`*^9}, {
   3.7992246650486574`*^9, 3.7992246653455033`*^9}, {3.799224775781803*^9, 
   3.79922482639511*^9}, {3.7992248914030824`*^9, 3.799224900795082*^9}, {
   3.7992249826645126`*^9, 3.799225005440734*^9}, {3.7992251364309015`*^9, 
   3.7992251504635673`*^9}, {3.7992252100033016`*^9, 
   3.7992252235959034`*^9}, {3.7992252920575657`*^9, 
   3.7992253148824177`*^9}, {3.799247200461684*^9, 3.799247219574475*^9}, {
   3.799390419193269*^9, 3.799390428484346*^9}, {3.799405441462678*^9, 
   3.799405499704444*^9}, {3.7994055361212697`*^9, 3.7994056708286853`*^9}, {
   3.799405723305327*^9, 3.7994057782608595`*^9}, {3.7994058533903117`*^9, 
   3.7994058561094694`*^9}, {3.8045670024826074`*^9, 3.80456701376495*^9}, {
   3.8045670542396994`*^9, 3.804567054802306*^9}, {3.8045671822234917`*^9, 
   3.8045672119155273`*^9}, {3.8045672869246063`*^9, 3.80456735892441*^9}, {
   3.804567397497778*^9, 3.804567410972373*^9}, {3.804567465384981*^9, 
   3.8045674658849525`*^9}, {3.8045675832694855`*^9, 3.804567642136302*^9}, {
   3.8045676843905973`*^9, 3.8045676914248543`*^9}, {3.80456774596828*^9, 
   3.804567779170571*^9}, {3.804567811269348*^9, 3.804567829913135*^9}, {
   3.8045678839697495`*^9, 3.804567900174443*^9}, {3.8045679843109493`*^9, 
   3.8045680034304132`*^9}, {3.8045680389338264`*^9, 
   3.8045680405901656`*^9}, {3.8045710175777664`*^9, 3.804571206354971*^9}, {
   3.8045712495947876`*^9, 3.8045712507354574`*^9}, {3.8045712898481493`*^9, 
   3.804571324087729*^9}, {3.8092317916027813`*^9, 3.8092317970680885`*^9}, {
   3.809231854103389*^9, 3.8092318600855713`*^9}, {3.8092319105615053`*^9, 
   3.8092319150612183`*^9}, {3.8092325419576764`*^9, 3.809232715247785*^9}, {
   3.809233942427601*^9, 3.809233955589283*^9}, {3.8092339879808908`*^9, 
   3.8092340107755404`*^9}, {3.809234056309925*^9, 3.8092341206505847`*^9}, {
   3.8092341620636415`*^9, 3.809234187791301*^9}, 3.809234300727456*^9, {
   3.809234488772273*^9, 3.8092344915506363`*^9}, {3.8092345771482267`*^9, 
   3.809234605108821*^9}, 3.809234859957323*^9, 3.809234935467799*^9, {
   3.809235403284978*^9, 3.8092354357261286`*^9}, {3.809235832949008*^9, 
   3.809235857987056*^9}, {3.809235898240383*^9, 3.809235906129998*^9}, {
   3.809235950061078*^9, 3.809235965889228*^9}, {3.809236077854583*^9, 
   3.8092360780082254`*^9}, {3.809260138109808*^9, 3.809260172782078*^9}, {
   3.809260308190755*^9, 3.8092603539258356`*^9}, 3.8092604454271355`*^9, {
   3.8092624085811887`*^9, 3.8092624404105053`*^9}, {3.809262486379896*^9, 
   3.8092624946300635`*^9}, {3.810288279114811*^9, 3.8102883214233985`*^9}, 
   3.810288794695775*^9, {3.8102888711024785`*^9, 3.810288926755621*^9}, {
   3.810289001806428*^9, 3.810289041478368*^9}, {3.8102890717504272`*^9, 
   3.810289084978651*^9}, {3.810289459832657*^9, 3.810289474693591*^9}, {
   3.810289620259222*^9, 3.8102896716318674`*^9}, {3.81028976718307*^9, 
   3.8102897895317607`*^9}, {3.810289836478634*^9, 3.810289861527444*^9}, {
   3.810289945519662*^9, 3.8102899464411917`*^9}, {3.8102901554266286`*^9, 
   3.8102901711359243`*^9}, {3.8102902368704824`*^9, 
   3.8102902601228175`*^9}, {3.8102903561147137`*^9, 3.810290395540236*^9}, {
   3.810291347026215*^9, 3.8102913541739674`*^9}, {3.8102914054536285`*^9, 
   3.8102914098618717`*^9}, {3.810291441105032*^9, 3.8102917368280015`*^9}, {
   3.810292563253299*^9, 3.8102925975823917`*^9}, {3.8102926831624966`*^9, 
   3.810292683287512*^9}, {3.8102928586194963`*^9, 3.810292873807233*^9}, {
   3.810301294436025*^9, 3.810301309561745*^9}, {3.810301342765251*^9, 
   3.8103013516716433`*^9}, {3.8103014125948715`*^9, 
   3.8103014181422243`*^9}, {3.810301730850793*^9, 3.8103017403352585`*^9}, {
   3.8103073114877367`*^9, 3.8103073401607037`*^9}, {3.810368074945135*^9, 
   3.8103680811952057`*^9}, {3.8103683906055174`*^9, 3.810368397574511*^9}, {
   3.810368522107299*^9, 3.8103685702952113`*^9}, {3.8103686176551604`*^9, 
   3.8103686198585615`*^9}, {3.810368659780779*^9, 3.8103687501724997`*^9}, {
   3.8103687944701586`*^9, 3.8103688308766513`*^9}, {3.8103688626113453`*^9, 
   3.810368881643145*^9}, {3.8103689654720526`*^9, 3.810368966659535*^9}, {
   3.810369108286147*^9, 3.8103691389427223`*^9}, {3.8103705832234535`*^9, 
   3.8103705839892893`*^9}, {3.810370614020576*^9, 3.810370630052232*^9}, {
   3.810375060897814*^9, 3.8103750782889132`*^9}, {3.8105304930079455`*^9, 
   3.8105305176234465`*^9}, {3.810530556266593*^9, 3.8105305669411545`*^9}, {
   3.810530710665185*^9, 3.810530712540331*^9}, {3.8105307429894743`*^9, 
   3.810530774253314*^9}, {3.810530832942602*^9, 3.810530836670864*^9}, 
   3.81053355375762*^9, {3.810535276957549*^9, 3.810535322083971*^9}, {
   3.8105353819608088`*^9, 3.810535382070188*^9}, {3.810535420649542*^9, 
   3.8105354426346464`*^9}, {3.8105355823730326`*^9, 3.810535589362895*^9}, {
   3.8105356515334353`*^9, 3.810535654236637*^9}, {3.810535778633816*^9, 
   3.8105357853214808`*^9}, {3.8105359200435114`*^9, 
   3.8105359648500013`*^9}, {3.8105360177184153`*^9, 3.810536019218416*^9}, {
   3.810536076511289*^9, 3.810536092386629*^9}, {3.810536125684181*^9, 
   3.8105361851626797`*^9}, {3.8105362326377583`*^9, 3.810536240919186*^9}, 
   3.810555519330304*^9, {3.8105555853781433`*^9, 3.8105555895031233`*^9}, {
   3.8105556224414105`*^9, 3.8105556335038877`*^9}, {3.8105556901453295`*^9, 
   3.810555725911534*^9}, {3.8105560829638577`*^9, 3.8105560880732803`*^9}, {
   3.810556311983223*^9, 3.810556394812248*^9}, {3.810556468969961*^9, 
   3.8105565279080343`*^9}, {3.810556562424244*^9, 3.8105566006903114`*^9}, {
   3.8105566453316298`*^9, 3.8105566493945265`*^9}, {3.810556761333581*^9, 
   3.8105567831461*^9}, {3.810556901726198*^9, 3.8105569019447303`*^9}, {
   3.810556932289097*^9, 3.810556935054646*^9}, {3.8105633184464936`*^9, 
   3.8105633364623575`*^9}, {3.810628104798641*^9, 3.810628196239359*^9}, {
   3.810629876251961*^9, 3.8106299341234818`*^9}, {3.810629996822749*^9, 
   3.8106299976664815`*^9}, {3.810630069903042*^9, 3.8106301044278965`*^9}, {
   3.810630405340437*^9, 3.810630465071159*^9}, {3.8109805948892508`*^9, 
   3.810980621780734*^9}, {3.8109809921469193`*^9, 3.8109809933813343`*^9}, {
   3.8109810826798873`*^9, 3.8109810840240993`*^9}, 3.810981284136737*^9, {
   3.810983394221871*^9, 3.8109833947689877`*^9}, {3.810987107723233*^9, 
   3.810987131189526*^9}, {3.8110734607705965`*^9, 3.8110735092561407`*^9}, {
   3.8110778372784967`*^9, 3.8110778842483587`*^9}, 3.811147361063284*^9, {
   3.81115112677529*^9, 3.8111512310469723`*^9}, {3.8111516179408813`*^9, 
   3.8111517968342543`*^9}, {3.811151880970153*^9, 3.811151881579545*^9}, {
   3.8111519783500204`*^9, 3.8111519836028533`*^9}, {3.81459420203586*^9, 
   3.8145942107074757`*^9}, {3.81459894004951*^9, 3.8145989422707367`*^9}, 
   3.814599023966628*^9, {3.81459912320918*^9, 3.814599184800544*^9}, {
   3.814599223178383*^9, 3.814599299839842*^9}, {3.8145994090130925`*^9, 
   3.814599410206589*^9}, {3.814599629003039*^9, 3.8145996300494676`*^9}, {
   3.814599889441954*^9, 3.8145999008957524`*^9}, 3.8146001216286535`*^9, {
   3.814600334344943*^9, 3.814600335814014*^9}, {3.814600995807257*^9, 
   3.8146010078547697`*^9}, {3.8146013659689884`*^9, 
   3.8146013661939335`*^9}, {3.8146017550687904`*^9, 3.814601763366506*^9}, {
   3.8146021773961344`*^9, 3.8146021830451283`*^9}, {3.8146022380388255`*^9, 
   3.814602246314247*^9}, {3.814602671007721*^9, 3.814602711072196*^9}, {
   3.8146027467461023`*^9, 3.814602949521979*^9}, {3.814602991431796*^9, 
   3.8146031331543913`*^9}, {3.814603173501558*^9, 3.8146032433016815`*^9}, {
   3.814608517821357*^9, 3.814608549795789*^9}, {3.814608653764597*^9, 
   3.8146086538738403`*^9}, {3.8146086930781493`*^9, 
   3.8146086948595276`*^9}, {3.8146087466097703`*^9, 3.814608746720665*^9}, {
   3.814608861165512*^9, 3.814608869489973*^9}, {3.8146090295106115`*^9, 
   3.8146090631681724`*^9}, {3.814609160124211*^9, 3.814609160405352*^9}, {
   3.814609209093858*^9, 3.8146092254802375`*^9}, {3.8146092634398203`*^9, 
   3.8146092635807767`*^9}, {3.814609302628834*^9, 3.814609304925516*^9}, {
   3.8146093828172016`*^9, 3.8146094225542808`*^9}, {3.8146094786932755`*^9, 
   3.8146094885174437`*^9}, {3.814609531905155*^9, 3.8146095319950666`*^9}, {
   3.8146104617442865`*^9, 3.814610471179207*^9}, {3.8146105945576773`*^9, 
   3.8146106090288*^9}, {3.814610834413989*^9, 3.8146108417835913`*^9}, {
   3.8146108967479477`*^9, 3.814610902629107*^9}, {3.8146110526957684`*^9, 
   3.814611059617625*^9}, {3.814611334234791*^9, 3.81461134445383*^9}, {
   3.8146113819235554`*^9, 3.8146113820330796`*^9}, 3.8146114640510807`*^9, {
   3.8146115010515647`*^9, 3.814611501598613*^9}, {3.814611560990673*^9, 
   3.8146116097513933`*^9}, 3.814614289538726*^9, {3.814614326826544*^9, 
   3.8146144586738815`*^9}, {3.814614499439996*^9, 3.8146145062993975`*^9}, {
   3.8146146427714996`*^9, 3.8146146853884163`*^9}, {3.8146147238982573`*^9, 
   3.8146148178850517`*^9}, {3.8146148876929264`*^9, 3.814614889105199*^9}, {
   3.8146177066983385`*^9, 3.814617718073777*^9}, {3.814617749043063*^9, 
   3.8146177496837115`*^9}, {3.814617884764719*^9, 3.814617885342657*^9}, {
   3.8146179349842787`*^9, 3.8146179607348537`*^9}, {3.814618535106042*^9, 
   3.8146185415281906`*^9}, 3.8146187109221334`*^9, {3.8146192877940397`*^9, 
   3.8146193238096523`*^9}, {3.8146193719276857`*^9, 3.814619446171419*^9}, {
   3.8146195974557467`*^9, 3.814619684519815*^9}, {3.8146197190204477`*^9, 
   3.814619755911885*^9}, {3.814619787040416*^9, 3.814619864289318*^9}, {
   3.8146205929438744`*^9, 3.8146206600546823`*^9}, {3.8146823673677883`*^9, 
   3.814682423740196*^9}, {3.8146824653967543`*^9, 3.8146824910512676`*^9}, {
   3.814682681651716*^9, 3.814682689184199*^9}, {3.8146830988836937`*^9, 
   3.814683146792658*^9}, {3.814683239569524*^9, 3.8146832551781588`*^9}, {
   3.81468329587936*^9, 3.814683300347901*^9}, {3.8146833932653804`*^9, 
   3.8146834017337313`*^9}, {3.8146834388725986`*^9, 3.8146835070256166`*^9}, 
   3.814683577912875*^9, {3.8146836265199423`*^9, 3.8146836890526314`*^9}, {
   3.8146837260196266`*^9, 3.8146837972662315`*^9}, {3.8146863674954224`*^9, 
   3.8146863713233585`*^9}, {3.814686521886073*^9, 3.8146865419660835`*^9}, {
   3.8146867996721935`*^9, 3.814686833139287*^9}, {3.8172057032564096`*^9, 
   3.817205704865884*^9}, {3.8172736057298117`*^9, 3.817273606260914*^9}, 
   3.8172737084820995`*^9, {3.817274057646897*^9, 3.8172740842567463`*^9}, {
   3.8172741203825483`*^9, 3.8172741346328773`*^9}, {3.8172741678366776`*^9, 
   3.8172742433230505`*^9}, {3.817274369841485*^9, 3.8172743829668655`*^9}, {
   3.8181360518004103`*^9, 3.8181360524566793`*^9}, {3.818143585422042*^9, 
   3.8181435858903613`*^9}, {3.8181437300997553`*^9, 3.818143743897153*^9}, {
   3.818153728957152*^9, 3.8181537332385683`*^9}, {3.8203024711722393`*^9, 
   3.820302479516411*^9}, {3.8203030460189867`*^9, 3.8203030703956537`*^9}, {
   3.8203032584535503`*^9, 3.820303272764925*^9}, {3.820303350943309*^9, 
   3.82030335603736*^9}, {3.8203034055001493`*^9, 3.820303503483367*^9}, {
   3.8203035571111946`*^9, 3.820303561606125*^9}, {3.8203036541793156`*^9, 
   3.820303717807555*^9}, {3.820304679490182*^9, 3.8203047392323475`*^9}, {
   3.8203047726930385`*^9, 3.8203048048507366`*^9}, {3.820306423758139*^9, 
   3.8203064243516808`*^9}, {3.8243419308416944`*^9, 
   3.8243420385197363`*^9}, {3.8243422778480005`*^9, 
   3.8243423679503484`*^9}, {3.82434241332885*^9, 3.824342414471657*^9}, {
   3.8243429349495835`*^9, 3.8243429476569614`*^9}, {3.824357441927737*^9, 
   3.824357501613231*^9}, {3.8248858778432894`*^9, 3.8248859030454655`*^9}, {
   3.824954956820922*^9, 3.824954996181101*^9}, 3.824955039385219*^9, {
   3.824955082495472*^9, 3.8249552473582563`*^9}, 3.824955311328417*^9, {
   3.824955376595307*^9, 3.824955396236309*^9}, {3.8249554551598454`*^9, 
   3.82495545878467*^9}, {3.8249615013470564`*^9, 3.824961533925784*^9}, {
   3.824966599327751*^9, 3.824966702814097*^9}, {3.8249667875974216`*^9, 
   3.8249668165039425`*^9}, {3.8249668468327074`*^9, 
   3.8249668653955245`*^9}, {3.8249669086778984`*^9, 3.824966958428671*^9}, {
   3.824972452620878*^9, 3.824972547482029*^9}, {3.8249725909674215`*^9, 
   3.824972635550889*^9}, {3.8249727307746353`*^9, 3.8249727467675953`*^9}, 
   3.824972788525335*^9, {3.82497282612834*^9, 3.824972829316347*^9}, {
   3.8249729071420126`*^9, 3.8249729110051785`*^9}, {3.824973024992236*^9, 
   3.8249730441669903`*^9}, {3.824973132147521*^9, 3.824973165088724*^9}, {
   3.8249732628311367`*^9, 3.8249733428425436`*^9}, {3.824973600456954*^9, 
   3.8249736015041313`*^9}, {3.824973802554866*^9, 3.8249738740919137`*^9}, {
   3.824973916294118*^9, 3.824973979281907*^9}, {3.824974020012738*^9, 
   3.8249740652791996`*^9}, {3.824974098607857*^9, 3.8249740987487593`*^9}, {
   3.824974208188595*^9, 3.824974215704172*^9}, 3.8249742998263087`*^9, {
   3.824974334394085*^9, 3.824974335469881*^9}, {3.8249744857095733`*^9, 
   3.8249745151635823`*^9}, {3.8249746231475563`*^9, 
   3.8249746265376787`*^9}, {3.8249747087298565`*^9, 
   3.8249747101049533`*^9}, {3.8249749202655163`*^9, 
   3.8249749649541073`*^9}, {3.8249750200335827`*^9, 3.824975020548727*^9}, {
   3.824975198070615*^9, 3.8249752018990717`*^9}, {3.82497524602592*^9, 
   3.82497526877671*^9}, {3.8249753037156134`*^9, 3.824975306012391*^9}, {
   3.824975470233815*^9, 3.8249754717224565`*^9}, {3.8249755601635413`*^9, 
   3.8249755740390773`*^9}, {3.8249756629022865`*^9, 
   3.8249756855124474`*^9}, {3.8249757246560736`*^9, 3.824975789266418*^9}, {
   3.8249758432688723`*^9, 3.82497587845779*^9}, {3.8249759993060493`*^9, 
   3.8249761065299816`*^9}, 3.8249762115245776`*^9, 3.8249768312569466`*^9, {
   3.824976888116654*^9, 3.8249769004978924`*^9}, {3.8249769409459577`*^9, 
   3.8249769905689116`*^9}, {3.8249771585922403`*^9, 
   3.8249772097761564`*^9}, {3.8249781061970716`*^9, 
   3.8249781357041035`*^9}, {3.824978182116722*^9, 3.8249782284894476`*^9}, {
   3.824978574283792*^9, 3.824978614427347*^9}, {3.824978672135244*^9, 
   3.8249786827438245`*^9}, {3.8249787788064685`*^9, 3.824978780065553*^9}, {
   3.824979270668151*^9, 3.824979282823262*^9}, {3.8249807949912863`*^9, 
   3.8249807959460096`*^9}, {3.8249819142362785`*^9, 3.824981914688999*^9}, {
   3.825500461395751*^9, 3.825500461509809*^9}, {3.825504720076028*^9, 
   3.825504720574035*^9}, 3.827231496149244*^9, {3.827562795907789*^9, 
   3.827562798111312*^9}, {3.8283528227191215`*^9, 3.828352833511307*^9}, {
   3.8285109491586103`*^9, 3.8285109499401703`*^9}, {3.828511003827886*^9, 
   3.8285110044995093`*^9}, {3.8321497392850976`*^9, 3.832149743921381*^9}},
 CellLabel->
  "In[203]:=",ExpressionUUID->"8ed16028-e390-4f33-a637-2d59df92a45e"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`h$$ = 1, $CellContext`hwhm$$ = 
    0.1, $CellContext`k$$ = 0, $CellContext`kMag$$ = 1., $CellContext`l$$ = 
    0, $CellContext`lambda$$ = 0.154, $CellContext`shape$$ = 
    1, $CellContext`xMag$$ = 1., $CellContext`\[Eta]$$ = 
    0.5, $CellContext`\[Theta]\[Theta]$$ = 45., $CellContext`\[Mu]$$ = 
    3., $CellContext`\[Sigma]$$ = 0.3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Text[
        Style["Lognormal domain size distribution", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Mu]$$], 3., "lognormal mean"}, 0.1, 5.}, {{
       Hold[$CellContext`\[Sigma]$$], 0.1, "lognormal std. dev."}, 0.01, 1.}, {
      Hold[
       Grid[{{
          Manipulate`Place[1]}, {
          Manipulate`Place[2]}, {"Mean Size", 
          Dynamic[
           NumberForm[
            $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
          Dynamic[
           NumberForm[
            $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
            5, 2}]], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[$CellContext`shape$$], {1 -> Graphics3D[
         Sphere[{0, 0, 0}], Boxed -> False], 2 -> Graphics3D[
         Cube[], Boxed -> False], 3 -> Graphics3D[
         Tetrahedron[], Boxed -> False], 4 -> Graphics3D[
         Octahedron[], Boxed -> False]}}, {
      Hold[
       Text[
        Style["Reflection indices in cubic crystal system (h>=k>=l)", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`h$$], 1, "h"}, 1, 10, 1}, {{
       Hold[$CellContext`k$$], 0, "k"}, 0, 10, 1}, {{
       Hold[$CellContext`l$$], 0, "l"}, 0, 10, 1}, {
      Hold[
       Text[
        Style["Pseudo-Voigt function", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Eta]$$], 0.5, "mixing param. "}, 0., 1.}, {{
       Hold[$CellContext`hwhm$$], 0.1, "half width at half maximum"}, 0.001, 
      2.}, {
      Hold[
       Grid[{{
          Manipulate`Place[3]}, {
          Manipulate`Place[4], "\[Degree]2\[Theta]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Theta]\[Theta]$$], 45., ""}, 1., 179.}, {{
       Hold[$CellContext`lambda$$], 0.154, ""}, 0.01, 0.3}, {
      Hold[
       Grid[{{"peak position", 
          Manipulate`Place[5], "\[Degree]2\[Theta]"}, {"wavelength   ", 
          Manipulate`Place[6], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Zoom factors", 16]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1.}, 0.1, 10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1.}, 0.1, 10., 0.1}, {
      Hold[
       Grid[{{
          Manipulate`Place[7]}, {
          Manipulate`Place[8]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1009., {328., 334.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`h$$ = 1, $CellContext`hwhm$$ = 
        0.1, $CellContext`k$$ = 0, $CellContext`kMag$$ = 1., $CellContext`l$$ = 
        0, $CellContext`lambda$$ = 0.154, $CellContext`shape$$ = 
        1, $CellContext`xMag$$ = 1., $CellContext`\[Eta]$$ = 
        0.5, $CellContext`\[Theta]\[Theta]$$ = 45., $CellContext`\[Mu]$$ = 
        3., $CellContext`\[Sigma]$$ = 0.1}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`MeanSize$, $CellContext`StdSize$, \
$CellContext`EffectiveSize$, $CellContext`n$, $CellContext`x1$, \
$CellContext`x2$, $CellContext`deltax$, $CellContext`k1$, $CellContext`k2$, \
$CellContext`deltak$, $CellContext`grid$, $CellContext`samples1$, \
$CellContext`samples2$, $CellContext`samples3$, $CellContext`g1$, \
$CellContext`g1t$, $CellContext`g2$, $CellContext`g3$, $CellContext`l1$, \
$CellContext`l2$, $CellContext`l2t$, $CellContext`l3$}, \
$CellContext`MeanSize$ = $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$]; $CellContext`StdSize$ = \
$CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]; \
$CellContext`n$ = 2048; $CellContext`deltak$ = 
          10 ($CellContext`MeanSize$/$CellContext`n$); $CellContext`k1$ = \
(-($CellContext`n$/
             2)) $CellContext`deltak$; $CellContext`k2$ = $CellContext`k1$ + \
$CellContext`n$ $CellContext`deltak$; $CellContext`grid$ = 
          Range[$CellContext`k1$, $CellContext`k2$, $CellContext`deltak$]; \
$CellContext`samples1$ = 
          Map[$CellContext`FTPVoigt[#, $CellContext`\[Eta]$$, \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$] \
$CellContext`hwhm$$]& , $CellContext`grid$]; {$CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$} = 
          Sort[{$CellContext`h$$, $CellContext`k$$, $CellContext`l$$}, 
            Greater]; 
         Which[$CellContext`shape$$ == 1, $CellContext`samples2$ = 
           Map[$CellContext`FTASgen[
             "sphere", #, $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$, \
$CellContext`h$$, $CellContext`k$$, $CellContext`l$$]& , $CellContext`grid$], \
$CellContext`shape$$ == 2, $CellContext`samples2$ = 
           Map[$CellContext`FTASgen[
             "cube", #, $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$, \
$CellContext`h$$, $CellContext`k$$, $CellContext`l$$]& , $CellContext`grid$], \
$CellContext`shape$$ == 3, $CellContext`samples2$ = 
           Map[$CellContext`FTASgen[
             "tetrahedron", #, $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$, \
$CellContext`h$$, $CellContext`k$$, $CellContext`l$$]& , $CellContext`grid$], \
$CellContext`shape$$ == 4, $CellContext`samples2$ = 
           Map[$CellContext`FTASgen[
             "octahedron", #, $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$, \
$CellContext`h$$, $CellContext`k$$, $CellContext`l$$]& , $CellContext`grid$]]; \
$CellContext`samples3$ = $CellContext`samples1$ $CellContext`samples2$; \
$CellContext`g1$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples1$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`g2$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples2$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`g3$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples3$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`x1$ = 
          10/$CellContext`k1$; $CellContext`x2$ = 
          10/$CellContext`k2$; $CellContext`l1$ = 
          ListLinePlot[{$CellContext`samples1$, $CellContext`samples2$, \
$CellContext`samples3$}, DataRange -> {$CellContext`k1$, $CellContext`k2$}, 
            PlotRange -> {{$CellContext`k1$/$CellContext`kMag$$, \
$CellContext`k2$/$CellContext`kMag$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "Fourier length, s (nm)", "Fourier Transform"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              
              LineLegend[{
               "FT of peak shape", "FT of size distr.", 
                "FT of convolution"}], {0.2, Top}], TicksStyle -> 
            Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
            ImageSize -> 500]; $CellContext`l2$ = Plot[{
             $CellContext`g1$[$CellContext`x], 
             $CellContext`g2$[$CellContext`x], 
             $CellContext`g3$[$CellContext`x]}, {$CellContext`x, \
$CellContext`x1$/$CellContext`xMag$$, $CellContext`x2$/$CellContext`xMag$$}, 
            PlotRange -> {{$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`x2$/$CellContext`xMag$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "rel. \!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              
              LineLegend[{
               "peak shape", "size distribution", "convolution"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; $CellContext`l2t$ = 
          Plot[{$CellContext`g1$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$], \
$CellContext`g2$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$], \
$CellContext`g3$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]}, \
{$CellContext`x, $CellContext`\[Theta]2[$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`lambda$$] + $CellContext`\[Theta]\[Theta]$$, $CellContext`\
\[Theta]2[$CellContext`x2$/$CellContext`xMag$$, $CellContext`lambda$$] + \
$CellContext`\[Theta]\[Theta]$$}, 
            PlotRange -> \
{{$CellContext`\[Theta]2[$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`lambda$$] + $CellContext`\[Theta]\[Theta]$$, $CellContext`\
\[Theta]2[$CellContext`x2$/$CellContext`xMag$$, $CellContext`lambda$$] + \
$CellContext`\[Theta]\[Theta]$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, 
            FrameLabel -> {"2\[Theta]  (\[Degree])", "Intensity (a.u.)"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              
              LineLegend[{
               "peak shape", "size distribution", "convolution"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; $CellContext`l3$ = 
          Plot[
            $CellContext`G[$CellContext`x, $CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {$CellContext`x, 0., $CellContext`MeanSize$ + 
             6 $CellContext`StdSize$}, PlotRange -> Full, GridLines -> 
            Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
            Frame -> True, 
            FrameLabel -> {
             "domain size, D  (nm)", "\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)"},
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"Lognormal domain size distribution"}], {0.7, Top}],
             TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], Epilog -> {Red, Thick, {
               Arrow[{{
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                  $CellContext`G[
                   $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}], 
               Arrow[{{
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                  $CellContext`G[
                   $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}]}}, ImageSize -> 
            500]; Grid[{{$CellContext`l1$, $CellContext`l2$}, \
{$CellContext`l2t$, $CellContext`l3$}}]]], "Specifications" :> {
        Text[
         Style[
         "Lognormal domain size distribution", 16]], {{$CellContext`\[Mu]$$, 
          3., "lognormal mean"}, 0.1, 5., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.1, "lognormal std. dev."}, 0.01, 1.,
          ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         2}, 
        Grid[{{
           Manipulate`Place[1]}, {
           Manipulate`Place[2]}, {"Mean Size", 
           Dynamic[
            NumberForm[
             $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
           Dynamic[
            NumberForm[
             $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
             5, 2}]], "nm"}}], {$CellContext`shape$$, {1 -> Graphics3D[
            Sphere[{0, 0, 0}], Boxed -> False], 2 -> Graphics3D[
            Cube[], Boxed -> False], 3 -> Graphics3D[
            Tetrahedron[], Boxed -> False], 4 -> Graphics3D[
            Octahedron[], Boxed -> False]}, ControlType -> RadioButtonBar}, 
        Text[
         Style[
         "Reflection indices in cubic crystal system (h>=k>=l)", 
          16]], {{$CellContext`h$$, 1, "h"}, 1, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled"}, {{$CellContext`k$$, 0, "k"}, 0, 10, 1, 
         ControlType -> Slider, Appearance -> 
         "Labeled"}, {{$CellContext`l$$, 0, "l"}, 0, 10, 1, ControlType -> 
         Slider, Appearance -> "Labeled"}, Delimiter, 
        Text[
         Style[
         "Pseudo-Voigt function", 16]], {{$CellContext`\[Eta]$$, 0.5, 
          "mixing param. "}, 0., 1., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         3}, {{$CellContext`hwhm$$, 0.1, "half width at half maximum"}, 0.001,
          2., ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 4}, 
        Grid[{{
           Manipulate`Place[3]}, {
           Manipulate`Place[4], "\[Degree]2\[Theta]"}}], 
        Delimiter, {{$CellContext`\[Theta]\[Theta]$$, 45., ""}, 1., 179., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`lambda$$, 0.154, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 6}, 
        Grid[{{"peak position", 
           Manipulate`Place[5], "\[Degree]2\[Theta]"}, {"wavelength   ", 
           Manipulate`Place[6], "nm"}}], Delimiter, 
        Text[
         Style["Zoom factors", 16]], {{$CellContext`xMag$$, 1.}, 0.1, 10., 
         0.1, ControlType -> Slider, Exclusions -> {0}, Appearance -> 
         "Labeled", ControlPlacement -> 7}, {{$CellContext`kMag$$, 1.}, 0.1, 
         10., 0.1, ControlType -> Slider, Exclusions -> {0}, Appearance -> 
         "Labeled", ControlPlacement -> 8}, 
        Grid[{{
           Manipulate`Place[7]}, {
           Manipulate`Place[8]}}], Delimiter}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Fourier (back)transform of Pseudo-Voigt function convoluted with \
lognormal domain size distribution\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1618., {397., 403.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`dmean[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       E^($CellContext`\[Mu] + $CellContext`\[Sigma]^2/
          2), $CellContext`\[Sigma]$$ = 0.3, $CellContext`sd[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Sqrt[E^(2 $CellContext`\[Mu] + $CellContext`\[Sigma]^2) (
          E^($CellContext`\[Sigma]^2) - 1)], $CellContext`FTPVoigt[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Eta], 
          Blank[]], 
         Pattern[$CellContext`hwhm, 
          Blank[]]] := 
       Module[{$CellContext`k = (
            1 + (1 - $CellContext`\[Eta])/($CellContext`\[Eta] 
             Sqrt[Pi Log[2]]))^(-1)}, (1 - $CellContext`k)/
          E^(((Pi^2 $CellContext`hwhm^2) $CellContext`L^2)/Log[
           2]) + $CellContext`k/
          E^(((2 Pi) $CellContext`hwhm) 
           Abs[$CellContext`L])], $CellContext`k$$[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       1/$CellContext`s[$CellContext`\[Theta]2, $CellContext`\[Lambda]], \
$CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`\[Lambda] = 
       0.14249059611887502`, $CellContext`cs[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := ($CellContext`\[Theta]2 Degree) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`cs[
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := (Pi/180) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`FTASgen[
         Pattern[$CellContext`type, 
          Blank[]], 
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]], 
         Pattern[$CellContext`h, 
          Blank[]], 
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`l, 
          Blank[]]] := Piecewise[{{1., $CellContext`L == 0}}, 
         Block[{$CellContext`t = 
           Sqrt[$CellContext`h^2 + $CellContext`k^2 + $CellContext`l^2], \
$CellContext`A = $CellContext`h/$CellContext`t, $CellContext`B = \
$CellContext`k/$CellContext`t, 
           C = $CellContext`l/$CellContext`t, $CellContext`H = Range[4], K = 
           1}, Which[$CellContext`type == "sphere", {
            Part[$CellContext`H, 0] = 1, Part[$CellContext`H, 1] = -1.5, 
             Part[$CellContext`H, 2] = 0, Part[$CellContext`H, 3] = 0.5, K = 
             1}, $CellContext`type == "cube", {
            Part[$CellContext`H, 0] = 1, 
             Part[$CellContext`H, 1] = -($CellContext`A + $CellContext`B + C),
              Part[$CellContext`H, 
               2] = $CellContext`A $CellContext`B + $CellContext`B C + 
              C $CellContext`A, 
             Part[$CellContext`H, 3] = (-$CellContext`A) $CellContext`B C, 
             K = $CellContext`A}, $CellContext`type == "tetrahedron", 
            
            If[$CellContext`A >= $CellContext`B + C, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = (-3) Sqrt[2] $CellContext`A, 
              Part[$CellContext`H, 2] = 6 $CellContext`A^2, 
              Part[$CellContext`H, 3] = (-2) Sqrt[2] $CellContext`A^3, K = 
              Sqrt[2] $CellContext`A}, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 
                1] = -((3 ($CellContext`A + $CellContext`B + C))/Sqrt[2]), 
              Part[$CellContext`H, 2] = (
                3 ($CellContext`A + $CellContext`B + C)^2)/2, 
              Part[$CellContext`H, 
                3] = -(($CellContext`A + $CellContext`B + C)^3/(2 Sqrt[2])), 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[
               2]}], $CellContext`type == "octahedron", 
            
            If[$CellContext`A >= $CellContext`B + C, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = -((3 $CellContext`A)/Sqrt[2]), 
              Part[$CellContext`H, 2] = 
              3 (($CellContext`A^2 - $CellContext`B^2 - C^2)/2), 
              Part[$CellContext`H, 3] = (-$CellContext`A^3 + 
                3 $CellContext`A ($CellContext`B^2 + C^2) + 
                2 ($CellContext`B^3 + C^3))/(2 Sqrt[2]), 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[2]}, {
             Part[$CellContext`H, 0] = 1, 
              Part[$CellContext`H, 1] = -(
                3 (($CellContext`A + $CellContext`B + C)/(2 Sqrt[2]))), 
              Part[$CellContext`H, 2] = -(
                3 (($CellContext`A^2 + ($CellContext`B - C)^2 - 
                  2 $CellContext`A ($CellContext`B + C))/4)), 
              Part[$CellContext`H, 3] = ($CellContext`A^3 + $CellContext`B^3 + 
                C^3 - 3 $CellContext`A $CellContext`B C)/Sqrt[2], 
              K = ($CellContext`A + $CellContext`B + C)/Sqrt[2]}]]; 
          Sum[Part[$CellContext`H, $CellContext`n] 
            Erfc[(Log[Abs[$CellContext`L] K] - $CellContext`\[Mu] - (
                3 - $CellContext`n) $CellContext`\[Sigma]^2)/($CellContext`\
\[Sigma] Sqrt[2])] (
             E^((3 - $CellContext`n) $CellContext`\[Mu] + ((
                   3 - $CellContext`n)^2/2) $CellContext`\[Sigma]^2)/(2 
             E^(3 $CellContext`\[Mu] + (9/2) $CellContext`\[Sigma]^2))) 
            Abs[$CellContext`L]^$CellContext`n, {$CellContext`n, 0, 
             3}]]], $CellContext`fourierData[
         PatternTest[
          Pattern[$CellContext`data, 
           Blank[]], MatrixQ], 
         Pattern[$CellContext`scale, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`xGrid, $CellContext`pGrid, $CellContext`f, \
$CellContext`x0, $CellContext`x1, $CellContext`NN, $CellContext`DFT}, \
{$CellContext`xGrid, $CellContext`f} = 
          Transpose[$CellContext`data]; {$CellContext`x0, $CellContext`x1} = 
          MinMax[$CellContext`xGrid]; $CellContext`NN = 
          Length[$CellContext`xGrid] - 1; $CellContext`pGrid = 
          RotateRight[
           Range[-($CellContext`NN/2), $CellContext`NN/
              2]/($CellContext`x1 - $CellContext`x0), 
            Quotient[$CellContext`NN, 2] + 1]; $CellContext`DFT = 
          Fourier[$CellContext`f, FourierParameters -> 
             OptionValue[
              FourierParameters]] (($CellContext`x1 - $CellContext`x0)/
            Sqrt[(2 Pi) $CellContext`NN]); 
         Transpose[{$CellContext`pGrid, $CellContext`scale 
            Abs[$CellContext`DFT]}]], 
       Options[$CellContext`fourierData] = {
        FourierParameters -> {0, 1}}, $CellContext`data = CompressedData["
1:eJw0XHc81e8Xt6MoktmSIhqShubnEPJtp10qspqaSntop6GBKCXKiMpeqWMT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        "], $CellContext`G[
         Pattern[$CellContext`d, 
          Blank[]], 
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Piecewise[{{0., $CellContext`d <= 0}}, 1/(
         E^((Log[$CellContext`d] - $CellContext`\[Mu])^2/(
           2 $CellContext`\[Sigma]^2)) ($CellContext`d $CellContext`\[Sigma] 
          Sqrt[2 Pi]))]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8146823408377757`*^9, {3.8146834225921206`*^9, 3.814683441200614*^9}, 
   3.8146835091973877`*^9, 3.8146836297229156`*^9, 3.8146836900213375`*^9, 
   3.814686125753611*^9, 3.8146865266045914`*^9, {3.814686803406373*^9, 
   3.81468682340539*^9}, 3.8146868791838956`*^9, 3.817205763726719*^9, 
   3.8172059801079617`*^9, 3.817217111862698*^9, 3.817273218454571*^9, 
   3.81727353450917*^9, 3.8172736099016514`*^9, {3.8172740587718463`*^9, 
   3.817274085303668*^9}, 3.817274135570448*^9, {3.8172741711180735`*^9, 
   3.817274230353862*^9}, 3.8172743708883686`*^9, 3.8172744362179403`*^9, 
   3.817274516923213*^9, {3.8172746396913357`*^9, 3.81727465345724*^9}, 
   3.8172746961773453`*^9, {3.817274733834472*^9, 3.817274756225366*^9}, 
   3.8179921102690415`*^9, 3.8180712859364643`*^9, 3.8181344105295615`*^9, 
   3.8181345947807426`*^9, 3.8181517489582186`*^9, 3.8181537592072115`*^9, 
   3.8182210277584243`*^9, 3.8202988238578067`*^9, 3.8203024806819205`*^9, 
   3.8203030740072594`*^9, 3.820303359209087*^9, 3.820303534125504*^9, 
   3.8203035703461056`*^9, 3.820303623380395*^9, 3.8203037201828985`*^9, {
   3.8203046847973633`*^9, 3.8203047406912746`*^9}, {3.8203047801932325`*^9, 
   3.8203048059755726`*^9}, 3.8203065695147095`*^9, 3.8243410849182835`*^9, 
   3.824342040071211*^9, 3.824342373254521*^9, 3.8243424166670055`*^9, 
   3.8243429870938034`*^9, 3.824344332891595*^9, {3.824344534589797*^9, 
   3.8243445421812983`*^9}, 3.824344787187394*^9, 3.824345305913195*^9, 
   3.8243484626457777`*^9, 3.824354454284233*^9, 3.824356908282713*^9, {
   3.824357443508989*^9, 3.824357464494218*^9}, 3.8243575025556507`*^9, 
   3.8248824808296185`*^9, 3.8248827401410103`*^9, 3.824885905068084*^9, 
   3.8249548151304493`*^9, 3.8249549590241165`*^9, 3.824955057213567*^9, {
   3.824955147309334*^9, 3.8249551700757046`*^9}, 3.8249665060600367`*^9, {
   3.8249725013876195`*^9, 3.8249725209659805`*^9}, 3.8249725527792664`*^9, {
   3.824972592561208*^9, 3.8249726214213123`*^9}, 3.8249726528280272`*^9, {
   3.824972732251612*^9, 3.8249727483458652`*^9}, 3.8249728308783965`*^9, 
   3.824972920302506*^9, 3.824973046320779*^9, {3.8249731338849645`*^9, 
   3.8249731773545403`*^9}, 3.8249732686818027`*^9, {3.824973298841203*^9, 
   3.824973314450909*^9}, 3.8249733456547155`*^9, 3.8249734629853163`*^9, 
   3.824973602629156*^9, {3.8249738047580137`*^9, 3.8249738442899485`*^9}, 
   3.8249738764937954`*^9, {3.8249739471205435`*^9, 3.824973980839675*^9}, {
   3.8249740288875403`*^9, 3.824974066076256*^9}, 3.8249741012800064`*^9, 
   3.824974222438451*^9, 3.8249743016277075`*^9, 3.8249743383472176`*^9, 
   3.8249745163666544`*^9, 3.82497462811876*^9, 3.8249747111203947`*^9, 
   3.824974966782159*^9, 3.824975023470933*^9, 3.8249752035237603`*^9, {
   3.824975253729116*^9, 3.8249752701203146`*^9}, 3.824975307715553*^9, 
   3.8249754728942337`*^9, 3.8249755758673873`*^9, 3.8249756872157993`*^9, {
   3.824975742983334*^9, 3.8249757907352395`*^9}, 3.82497584959725*^9, 
   3.824975881207924*^9, {3.82497602822947*^9, 3.824976108514387*^9}, 
   3.8249769027948313`*^9, 3.8249770419954233`*^9, {3.82497718577427*^9, 
   3.8249772134942484`*^9}, 3.824978138607072*^9, 3.8249781917393064`*^9, 
   3.8249782296452446`*^9, {3.824978663665657*^9, 3.824978684011065*^9}, 
   3.8249787811595674`*^9, 3.824978880901387*^9, {3.824979277494644*^9, 
   3.824979289177216*^9}, 3.8249806600776877`*^9, 3.8249816583921804`*^9, 
   3.824983256095187*^9, 3.825498228648226*^9, 3.825500478025553*^9, 
   3.8272308040711403`*^9, 3.8272314974484344`*^9, {3.8274007056114764`*^9, 
   3.827400724518515*^9}, 3.8274651237854023`*^9, 3.8274658741624656`*^9, 
   3.827469925474931*^9, 3.8274754575217204`*^9, 3.8274756135262012`*^9, 
   3.827481929800009*^9, 3.8275622677430143`*^9, 3.827562805923568*^9, 
   3.8278403182440863`*^9, 3.828187848043459*^9, 3.828352561446722*^9, 
   3.828352824367219*^9, 3.8285058317271013`*^9, 3.8285108595698757`*^9, 
   3.828510957745792*^9, 3.8285110185326433`*^9, 3.8285155720448017`*^9, 
   3.8286882777922916`*^9, 3.83214953578186*^9, 3.8321497447181635`*^9},
 CellLabel->
  "Out[203]=",ExpressionUUID->"d83010df-b4e2-4dee-8474-0c8428f3e1f3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Fourier (back)transform of Pseudo-Voigt function \
convoluted with microstrain ", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.809159709373041*^9, 3.8091597165513396`*^9}, {
  3.8146861797822194`*^9, 3.8146861829539366`*^9}, {3.814769293633284*^9, 
  3.8147692992256017`*^9}},
 CellTags->"Title",ExpressionUUID->"9ab5a89b-d659-4faa-a591-779b5f7e289d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Quiet", "@", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "n", ",", "x1", ",", "x2", ",", " ", "deltax", ",", " ", "k1", ",", 
         "k2", ",", " ", "deltak", ",", "grid", ",", " ", "samples1", ",", 
         " ", "samples2", ",", "samples3", ",", "g1", ",", "g2", ",", "g3", 
         ",", "l1", ",", "l2t", ",", "l2", ",", "l3"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"n", "           ", "=", " ", "2048"}], ";", "  ", 
        RowBox[{"(*", "  ", 
         RowBox[{"multiples", " ", "of", " ", "2"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"deltak", "=", 
         RowBox[{"400", "  ", "/", "n"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"k1", "         ", "=", "          ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"n", "/", "2"}], ")"}]}], "   ", "deltak"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"k2", "         ", "=", "   ", 
         RowBox[{"k1", " ", "+", "   ", 
          RowBox[{"n", "           ", "deltak"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"grid", "     ", "=", 
         RowBox[{"Range", "[", 
          RowBox[{"k1", ",", "k2", ",", "deltak"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"samples1", " ", "=", "  ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"FTPVoigt", "[", 
             RowBox[{"#", ",", "\[Eta]", ",", 
              RowBox[{
               RowBox[{"cs", "[", 
                RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}], "  ", 
               "hwhm"}]}], "]"}], "&"}], ",", " ", "grid"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"structure", " ", "\[Equal]", " ", "\"\<bcc iron\>\""}], 
          ",", "   ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"clp", "=", "0.28600"}], ",", 
            RowBox[{"AA", "=", "0.300"}], ",", 
            RowBox[{"BB", "=", "  ", 
             RowBox[{"-", "0.500"}]}], ",", 
            RowBox[{"\[Rho]", "=", "0.005"}], ",", 
            RowBox[{"RRe", "=", "2.98"}]}], "}"}], ",", "      ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"\[Mu]", "=", "3"}], ",", "  ", 
            RowBox[{"\[Sigma]", "=", "0.3"}], ",", "    ", 
            RowBox[{"aa", "=", "0.0005"}], ",", " ", 
            RowBox[{"bb", "=", "0.0001"}]}], " ", "*)"}], " ", 
          "\[IndentingNewLine]", "           ", 
          RowBox[{"structure", " ", "==", "\"\<fluorite\>\""}], ",", "   ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"clp", "=", "0.54616"}], ",", 
            RowBox[{"AA", "=", "0.111"}], ",", 
            RowBox[{"BB", "=", "    ", "0.282"}], ",", 
            RowBox[{"\[Rho]", "=", "0.101"}], ",", 
            RowBox[{"RRe", "=", "2.98"}]}], "}"}]}], "]"}], ";", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"\[Mu]", "=", "2.30"}], ",", 
          RowBox[{"\[Sigma]", "=", "0.478"}], ",", " ", 
          RowBox[{"aa", "=", "0.0005"}], ",", " ", 
          RowBox[{"bb", "=", "0.0001"}]}], " ", "*)"}], "\[IndentingNewLine]",
         "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"model", "\[Equal]", "\"\<Popa-Adler-Houska\>\""}], ",", 
          " ", 
          RowBox[{"samples2", " ", "=", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ALDPAH", "[", "  ", 
               RowBox[{
               "#", ",", "clp", ",", "    ", "h", ",", "k", ",", "l", ",", 
                "AA", ",", "BB", ",", "aa", ",", "bb"}], "]"}], " ", "&"}], 
             ",", " ", "grid"}], "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"model", "\[Equal]", "\"\<Krivoglaz-Wilkens\>\""}], ",", 
          " ", 
          RowBox[{"samples2", " ", "=", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ALDWILK", "[", 
               RowBox[{
               "#", ",", "clp", ",", "h", ",", "k", ",", "l", ",", "AA", ",", 
                "BB", ",", "\[Rho]", ",", "RRe", ",", 
                RowBox[{"clp", " ", 
                 FractionBox[
                  SqrtBox["2"], "2"]}]}], "]"}], " ", "&"}], ",", " ", 
             "grid"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"samples3", " ", "=", " ", 
         RowBox[{"samples1", "*", "samples2"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"g1", "            ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{"grid", ",", "samples1"}], "}"}], "]"}], ",", "1.0"}], 
            "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", 
        RowBox[{"g2", "            ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{"grid", ",", "samples2"}], "}"}], "]"}], ",", "1.0"}], 
            "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", 
        RowBox[{"g3", "            ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{"grid", ",", "samples3"}], "}"}], "]"}], ",", "1.0"}], 
            "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"x1", "            ", "=", " ", 
         RowBox[{"50", " ", 
          SuperscriptBox["k1", 
           RowBox[{"-", "1"}]]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"x2", "            ", "=", " ", 
         RowBox[{"50", " ", 
          SuperscriptBox["k2", 
           RowBox[{"-", "1"}]]}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"l1", "=", " ", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"samples1", ",", " ", "samples2", ",", " ", "samples3"}], 
            "}"}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"k1", ",", "k2"}], "}"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", " ", 
               RowBox[{
                RowBox[{"k1", "/", "kMag"}], ",", "  ", 
                RowBox[{"k2", "/", "kMag"}]}], "}"}], ",", "Full"}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<Fourier length, s (nm)\>\"", ",", 
              "\"\<Fourier Transform\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<FT of peak shape\>\"", ",", "\"\<FT of microstrain\>\"", 
                 ",", "\"\<FT of convolution\>\""}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"l2", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"g1", "[", "x", "]"}], " ", ",", 
             RowBox[{"g2", "[", "x", "]"}], ",", 
             RowBox[{"g3", "[", "x", "]"}]}], "}"}], ",", 
           "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{"x1", "/", "xMag"}], ",", 
             RowBox[{"x2", "/", "xMag"}]}], "}"}], ",", "\[IndentingNewLine]",
            "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x1", "/", "xMag"}], ",", " ", 
                RowBox[{"x2", "/", "xMag"}]}], "}"}], ",", "Full"}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<rel. \!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<peak shape\>\"", ",", "\"\<microstrain\>\"", ",", 
                 "\"\<convolution\>\""}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"l2t", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"g1", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"x", "-", "\[Theta]\[Theta]"}], ",", "lambda"}], 
                "]"}], "]"}], 
              RowBox[{"cs", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"g2", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"x", "-", "\[Theta]\[Theta]"}], ",", "lambda"}], 
                "]"}], "]"}], 
              RowBox[{"cs", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"g3", "[", 
               RowBox[{"s", "[", 
                RowBox[{
                 RowBox[{"x", "-", "\[Theta]\[Theta]"}], ",", "lambda"}], 
                "]"}], "]"}], 
              RowBox[{"cs", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}]}], "}"}], 
           ",", "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{
                RowBox[{"x1", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
              "\[Theta]\[Theta]"}], ",", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{
                RowBox[{"x2", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
              "\[Theta]\[Theta]"}]}], "}"}], ",", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"\[Theta]2", "[", 
                  RowBox[{
                   RowBox[{"x1", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
                 "\[Theta]\[Theta]"}], ",", " ", 
                RowBox[{
                 RowBox[{"\[Theta]2", "[", 
                  RowBox[{
                   RowBox[{"x2", "/", "xMag"}], ",", "lambda"}], "]"}], "+", 
                 "\[Theta]\[Theta]"}]}], "}"}], ",", "Full"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta]  (\[Degree])\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", 
                RowBox[{
                "\"\<peak shape\>\"", ",", "\"\<microstrain\>\"", ",", 
                 "\"\<convolution\>\""}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"model", "\[Equal]", "\"\<Popa-Adler-Houska\>\""}], ",", 
          " ", 
          RowBox[{"l3", "=", 
           RowBox[{"Plot", "[", 
            RowBox[{
             RowBox[{"WPLTPAH", "[", 
              RowBox[{
              "L", ",", "h", ",", "k", ",", "l", ",", "AA", ",", "BB", ",", 
               "aa", ",", "bb"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"L", ",", "0", ",", "50"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                 ", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "50"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
               "\"\<Fourier length, s  (nm)\>\"", ",", 
                "\"\<<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\)  (nm)\>\""}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"GridLinesStyle", "\[Rule]", 
              RowBox[{"Opacity", "[", ".1", "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"FrameTicks", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], 
             ",", " ", "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"PlotLegends", "\[Rule]", 
              RowBox[{"Placed", "[", 
               RowBox[{
                RowBox[{"LineLegend", "[", 
                 RowBox[{
                 "{", "\"\<Warren plot - Popa-Adler-Houska strain model\>\"", 
                  "}"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "Top"}], "}"}]}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                 ", 
             RowBox[{"TicksStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                 ", 
             RowBox[{"AxesStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                 ", 
             RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]",
             "                                                                \
                ", "]"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"model", "\[Equal]", "\"\<Krivoglaz-Wilkens\>\""}], ",", 
          " ", 
          RowBox[{"l3", "=", 
           RowBox[{"Plot", "[", 
            RowBox[{
             RowBox[{"WPLTWILK", "[", 
              RowBox[{
              "L", ",", "h", ",", "k", ",", "l", ",", "AA", ",", "BB", ",", 
               "\[Rho]", ",", "RRe", ",", 
               RowBox[{"clp", 
                FractionBox[
                 SqrtBox["2"], "2"]}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"L", ",", "0", ",", "50"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                   ", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "50"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
               "\"\<Fourier length, L (nm)\>\"", ",", 
                "\"\<<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\) (nm)\>\""}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
             RowBox[{"GridLinesStyle", "\[Rule]", 
              RowBox[{"Opacity", "[", ".1", "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
             
             "                                                                \
                  ", 
             RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"FrameTicks", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], 
             ",", " ", "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
             "\[IndentingNewLine]", 
             "                                                                \
                  ", 
             RowBox[{"PlotLegends", "\[Rule]", 
              RowBox[{"Placed", "[", 
               RowBox[{
                RowBox[{"LineLegend", "[", 
                 RowBox[{
                 "{", "\"\<Warren plot - Krivoglaz-Wilkens strain model\>\"", 
                  "}"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "Top"}], "}"}]}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                 ", 
             RowBox[{"TicksStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                 ", 
             RowBox[{"AxesStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
             "\[IndentingNewLine]", 
             
             "                                                                \
                 ", 
             RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]",
             "                                                                \
               ", "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Grid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"l1", ",", "l2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"l2t", ",", "l3"}], "}"}]}], "}"}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Pseudo-Voigt function\>\"", ",", "16"}], "]"}], "]"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "\[Eta]", ",", "      ", "0.5", ",", "\"\<mixing param.\>\""}], 
            "}"}], ",", "0.", ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"hwhm", ",", "0.1", ",", "\"\<hwhm\>\""}], "}"}], ",", 
            "0.001", ",", " ", "2.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\[Degree]2\[Theta]\>\""}], "}"}]}], "\[IndentingNewLine]", 
      "}"}], "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "model", ",", "\"\<Popa-Adler-Houska\>\"", ",", 
         "\"\<Microstrain model\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Popa-Adler-Houska\>\"", ",", " ", "\"\<Krivoglaz-Wilkens\>\""}], 
        "}"}], ",", "RadioButton", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"structure", ",", "\"\<bcc iron\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<bcc iron\>\"", ",", "\"\<fluorite\>\"", ",", 
         "\"\<free input\>\""}], "}"}], ",", "RadioButton", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "               ", 
      RowBox[{
       RowBox[{"{", "   ", 
        RowBox[{"\"\<cubic a\>\"", ",", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"clp", ",", "0.286", ",", "\"\<\>\""}], "}"}], ",", 
            "0.1", ",", " ", "1.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<nm\>\""}], "}"}], ",", "              ", 
       "\[IndentingNewLine]", "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<A      \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"AA", ",", "0.3", ",", "\"\<\>\""}], "}"}], ",", "0.0", 
            ",", " ", "1.0", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<B      \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"BB", ",", 
              RowBox[{"-", "0.5"}], ",", "\"\<\>\""}], "}"}], ",", 
            RowBox[{"-", "1."}], ",", " ", "1.", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<\[Alpha]      \>\"", ",", "  ", 
         RowBox[{"Control", "@", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"aa", ",", "0.0005", ",", "\"\<\>\""}], "}"}], ",", 
            "0.0000001", ",", "0.005", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<\[Beta]      \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"bb", ",", "0.0001", ",", "\"\<\>\""}], "}"}], ",", 
            "0.0000002", ",", "0.002", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "              ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<\[Rho]       \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Rho]", ",", "0.0101", ",", "\"\<\>\""}], "}"}], ",", 
            "0.0000001", ",", "0.11", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<RRe     \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"RRe", ",", "2.98", ",", "\"\<\>\""}], "}"}], ",", "0.1",
             ",", "100", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\>\""}], "}"}]}], "\[IndentingNewLine]", "    ", "}"}], 
     "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", "               ", 
      RowBox[{
       RowBox[{"{", "   ", 
        RowBox[{"\"\<peak position \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"\[Theta]\[Theta]", ",", " ", "45.", ",", "\"\<\>\""}], 
             "}"}], ",", "    ", "1.", ",", "   ", "179.0", ",", " ", 
            "Slider", ",", " ", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         ",", "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
       "              ", "\[IndentingNewLine]", "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<wavelength    \>\"", ",", "  ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lambda", ",", "  ", "0.154", ",", "\"\<\>\""}], "}"}], 
            ",", " ", "0.01", ",", "   ", "0.3", ",", "  ", "Slider", ",", 
            " ", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
         " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
       "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<Miller index h\>\"", ",", " ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"h", ",", "1", ",", "\"\<\>\""}], "}"}], ",", "1", ",", 
            " ", "10", ",", "1", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}],
         "}"}], ",", "\[IndentingNewLine]", "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<Miller index k\>\"", ",", " ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "\"\<\>\""}], "}"}], ",", "0", ",", 
            " ", "10", ",", "1", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}],
         "}"}], ",", "\[IndentingNewLine]", "               ", 
       RowBox[{"{", "   ", 
        RowBox[{"\"\<Miller index l\>\"", ",", " ", 
         RowBox[{"Control", "@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"l", ",", "0", ",", "\"\<\>\""}], "}"}], ",", "0", ",", 
            " ", "10", ",", "1", ",", "Slider", ",", 
            RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}],
         "}"}]}], "            ", "\[IndentingNewLine]", "        ", "}"}], 
     "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Zoom factors\>\"", ",", "16"}], "]"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "       ", 
            RowBox[{"xMag", ",", "1."}], "}"}], ",", "0.1", ",", " ", "10.", 
           ",", "0.1", ",", "Slider", ",", 
           RowBox[{"Exclusions", "\[Rule]", 
            RowBox[{"{", "0", "}"}]}], ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", "}"}], ",", " ", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "       ", 
            RowBox[{"kMag", ",", "1."}], "}"}], ",", "0.1", ",", " ", "10.", 
           ",", "0.1", ",", "Slider", ",", 
           RowBox[{"Exclusions", "\[Rule]", 
            RowBox[{"{", "0", "}"}]}], ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        "}"}]}], " ", "\[IndentingNewLine]", "}"}], "]"}], ",", " ", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
       "\"\<Fourier (back)transform of Pseudo-Voigt function convoluted with \
microstrain\\n\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", 
    "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", "  ", 
     RowBox[{
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "->", "True"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7990519264473877`*^9, 3.799051926962989*^9}, {
   3.7990519614593573`*^9, 3.799052026988535*^9}, {3.799052078908862*^9, 
   3.7990521378860164`*^9}, {3.7991199675173535`*^9, 
   3.7991199730024023`*^9}, {3.7991201568905897`*^9, 
   3.7991201834982595`*^9}, {3.7991202156536255`*^9, 
   3.7991202519342046`*^9}, {3.799120313459937*^9, 3.799120337227936*^9}, {
   3.799120495825898*^9, 3.7991204969823923`*^9}, {3.7991211294355335`*^9, 
   3.7991211432190757`*^9}, {3.7991214271026497`*^9, 
   3.7991215023012996`*^9}, {3.7991215778593035`*^9, 3.799121626027424*^9}, {
   3.7991448624053364`*^9, 3.7991449148510504`*^9}, {3.799145083200984*^9, 
   3.799145098640134*^9}, {3.799145174322327*^9, 3.7991452033592834`*^9}, {
   3.7991454730901756`*^9, 3.799145479184555*^9}, {3.7991455263947115`*^9, 
   3.7991455571180277`*^9}, {3.7991456376507683`*^9, 3.799145650527478*^9}, {
   3.7991457847406616`*^9, 3.799145797142044*^9}, {3.7992242314229536`*^9, 
   3.79922431989464*^9}, {3.7992243723608894`*^9, 3.7992244458312597`*^9}, {
   3.7992246650486574`*^9, 3.7992246653455033`*^9}, {3.799224775781803*^9, 
   3.79922482639511*^9}, {3.7992248914030824`*^9, 3.799224900795082*^9}, {
   3.7992249826645126`*^9, 3.799225005440734*^9}, {3.7992251364309015`*^9, 
   3.7992251504635673`*^9}, {3.7992252100033016`*^9, 
   3.7992252235959034`*^9}, {3.7992252920575657`*^9, 
   3.7992253148824177`*^9}, {3.799247200461684*^9, 3.799247219574475*^9}, {
   3.799390419193269*^9, 3.799390428484346*^9}, {3.799405441462678*^9, 
   3.799405499704444*^9}, {3.7994055361212697`*^9, 3.7994056708286853`*^9}, {
   3.799405723305327*^9, 3.7994057782608595`*^9}, {3.7994058533903117`*^9, 
   3.7994058561094694`*^9}, {3.8045670024826074`*^9, 3.80456701376495*^9}, {
   3.8045670542396994`*^9, 3.804567054802306*^9}, {3.8045671822234917`*^9, 
   3.8045672119155273`*^9}, {3.8045672869246063`*^9, 3.80456735892441*^9}, {
   3.804567397497778*^9, 3.804567410972373*^9}, {3.804567465384981*^9, 
   3.8045674658849525`*^9}, {3.8045675832694855`*^9, 3.804567642136302*^9}, {
   3.8045676843905973`*^9, 3.8045676914248543`*^9}, {3.80456774596828*^9, 
   3.804567779170571*^9}, {3.804567811269348*^9, 3.804567829913135*^9}, {
   3.8045678839697495`*^9, 3.804567900174443*^9}, {3.8045679843109493`*^9, 
   3.8045680034304132`*^9}, {3.8045680389338264`*^9, 
   3.8045680405901656`*^9}, {3.8045710175777664`*^9, 3.804571206354971*^9}, {
   3.8045712495947876`*^9, 3.8045712507354574`*^9}, {3.8045712898481493`*^9, 
   3.804571324087729*^9}, {3.8092317916027813`*^9, 3.8092317970680885`*^9}, {
   3.809231854103389*^9, 3.8092318600855713`*^9}, {3.8092319105615053`*^9, 
   3.8092319150612183`*^9}, {3.8092325419576764`*^9, 3.809232715247785*^9}, {
   3.809233942427601*^9, 3.809233955589283*^9}, {3.8092339879808908`*^9, 
   3.8092340107755404`*^9}, {3.809234056309925*^9, 3.8092341206505847`*^9}, {
   3.8092341620636415`*^9, 3.809234187791301*^9}, 3.809234300727456*^9, {
   3.809234488772273*^9, 3.8092344915506363`*^9}, {3.8092345771482267`*^9, 
   3.809234605108821*^9}, 3.809234859957323*^9, 3.809234935467799*^9, {
   3.809235403284978*^9, 3.8092354357261286`*^9}, {3.809235832949008*^9, 
   3.809235857987056*^9}, {3.809235898240383*^9, 3.809235906129998*^9}, {
   3.809235950061078*^9, 3.809235965889228*^9}, {3.809236077854583*^9, 
   3.8092360780082254`*^9}, {3.809260138109808*^9, 3.809260172782078*^9}, {
   3.809260308190755*^9, 3.8092603539258356`*^9}, 3.8092604454271355`*^9, {
   3.8092624085811887`*^9, 3.8092624404105053`*^9}, {3.809262486379896*^9, 
   3.8092624946300635`*^9}, {3.810288279114811*^9, 3.8102883214233985`*^9}, 
   3.810288794695775*^9, {3.8102888711024785`*^9, 3.810288926755621*^9}, {
   3.810289001806428*^9, 3.810289041478368*^9}, {3.8102890717504272`*^9, 
   3.810289084978651*^9}, {3.810289459832657*^9, 3.810289474693591*^9}, {
   3.810289620259222*^9, 3.8102896716318674`*^9}, {3.81028976718307*^9, 
   3.8102897895317607`*^9}, {3.810289836478634*^9, 3.810289861527444*^9}, {
   3.810289945519662*^9, 3.8102899464411917`*^9}, {3.8102901554266286`*^9, 
   3.8102901711359243`*^9}, {3.8102902368704824`*^9, 
   3.8102902601228175`*^9}, {3.8102903561147137`*^9, 3.810290395540236*^9}, {
   3.810291347026215*^9, 3.8102913541739674`*^9}, {3.8102914054536285`*^9, 
   3.8102914098618717`*^9}, {3.810291441105032*^9, 3.8102917368280015`*^9}, {
   3.810292563253299*^9, 3.8102925975823917`*^9}, {3.8102926831624966`*^9, 
   3.810292683287512*^9}, {3.8102928586194963`*^9, 3.810292873807233*^9}, {
   3.810301294436025*^9, 3.810301309561745*^9}, {3.810301342765251*^9, 
   3.8103013516716433`*^9}, {3.8103014125948715`*^9, 
   3.8103014181422243`*^9}, {3.810301730850793*^9, 3.8103017403352585`*^9}, {
   3.8103073114877367`*^9, 3.8103073401607037`*^9}, {3.810368074945135*^9, 
   3.8103680811952057`*^9}, {3.8103683906055174`*^9, 3.810368397574511*^9}, {
   3.810368522107299*^9, 3.8103685702952113`*^9}, {3.8103686176551604`*^9, 
   3.8103686198585615`*^9}, {3.810368659780779*^9, 3.8103687501724997`*^9}, {
   3.8103687944701586`*^9, 3.8103688308766513`*^9}, {3.8103688626113453`*^9, 
   3.810368881643145*^9}, {3.8103689654720526`*^9, 3.810368966659535*^9}, {
   3.810369108286147*^9, 3.8103691389427223`*^9}, {3.8103705832234535`*^9, 
   3.8103705839892893`*^9}, {3.810370614020576*^9, 3.810370630052232*^9}, {
   3.810375060897814*^9, 3.8103750782889132`*^9}, {3.8105304930079455`*^9, 
   3.8105305176234465`*^9}, {3.810530556266593*^9, 3.8105305669411545`*^9}, {
   3.810530710665185*^9, 3.810530712540331*^9}, {3.8105307429894743`*^9, 
   3.810530774253314*^9}, {3.810530832942602*^9, 3.810530836670864*^9}, 
   3.81053355375762*^9, {3.810535276957549*^9, 3.810535322083971*^9}, {
   3.8105353819608088`*^9, 3.810535382070188*^9}, {3.810535420649542*^9, 
   3.8105354426346464`*^9}, {3.8105355823730326`*^9, 3.810535589362895*^9}, {
   3.8105356515334353`*^9, 3.810535654236637*^9}, {3.810535778633816*^9, 
   3.8105357853214808`*^9}, {3.8105359200435114`*^9, 
   3.8105359648500013`*^9}, {3.8105360177184153`*^9, 3.810536019218416*^9}, {
   3.810536076511289*^9, 3.810536092386629*^9}, {3.810536125684181*^9, 
   3.8105361851626797`*^9}, {3.8105362326377583`*^9, 3.810536240919186*^9}, 
   3.810555519330304*^9, {3.8105555853781433`*^9, 3.8105555895031233`*^9}, {
   3.8105556224414105`*^9, 3.8105556335038877`*^9}, {3.8105556901453295`*^9, 
   3.810555725911534*^9}, {3.8105560829638577`*^9, 3.8105560880732803`*^9}, {
   3.810556311983223*^9, 3.810556394812248*^9}, {3.810556468969961*^9, 
   3.8105565279080343`*^9}, {3.810556562424244*^9, 3.8105566006903114`*^9}, {
   3.8105566453316298`*^9, 3.8105566493945265`*^9}, {3.810556761333581*^9, 
   3.8105567831461*^9}, {3.810556901726198*^9, 3.8105569019447303`*^9}, {
   3.810556932289097*^9, 3.810556935054646*^9}, {3.8105633184464936`*^9, 
   3.8105633364623575`*^9}, {3.810628104798641*^9, 3.810628196239359*^9}, {
   3.810629876251961*^9, 3.8106299341234818`*^9}, {3.810629996822749*^9, 
   3.8106299976664815`*^9}, {3.810630069903042*^9, 3.8106301044278965`*^9}, {
   3.810630405340437*^9, 3.810630465071159*^9}, {3.8109805948892508`*^9, 
   3.810980621780734*^9}, {3.8109809921469193`*^9, 3.8109809933813343`*^9}, {
   3.8109810826798873`*^9, 3.8109810840240993`*^9}, 3.810981284136737*^9, {
   3.810983394221871*^9, 3.8109833947689877`*^9}, {3.810987107723233*^9, 
   3.810987131189526*^9}, {3.8110734607705965`*^9, 3.8110735092561407`*^9}, {
   3.8110778372784967`*^9, 3.8110778842483587`*^9}, 3.811147361063284*^9, {
   3.81115112677529*^9, 3.8111512310469723`*^9}, {3.8111516179408813`*^9, 
   3.8111517968342543`*^9}, {3.811151880970153*^9, 3.811151881579545*^9}, {
   3.8111519783500204`*^9, 3.8111519836028533`*^9}, {3.81459420203586*^9, 
   3.8145942107074757`*^9}, {3.81459894004951*^9, 3.8145989422707367`*^9}, 
   3.814599023966628*^9, {3.81459912320918*^9, 3.814599184800544*^9}, {
   3.814599223178383*^9, 3.814599299839842*^9}, {3.8145994090130925`*^9, 
   3.814599410206589*^9}, {3.814599629003039*^9, 3.8145996300494676`*^9}, {
   3.814599889441954*^9, 3.8145999008957524`*^9}, 3.8146001216286535`*^9, {
   3.814600334344943*^9, 3.814600335814014*^9}, {3.814600995807257*^9, 
   3.8146010078547697`*^9}, {3.8146013659689884`*^9, 
   3.8146013661939335`*^9}, {3.8146017550687904`*^9, 3.814601763366506*^9}, {
   3.8146021773961344`*^9, 3.8146021830451283`*^9}, {3.8146022380388255`*^9, 
   3.814602246314247*^9}, {3.814602671007721*^9, 3.814602711072196*^9}, {
   3.8146027467461023`*^9, 3.814602949521979*^9}, {3.814602991431796*^9, 
   3.8146031331543913`*^9}, {3.814603173501558*^9, 3.8146032433016815`*^9}, {
   3.814608517821357*^9, 3.814608549795789*^9}, {3.814608653764597*^9, 
   3.8146086538738403`*^9}, {3.8146086930781493`*^9, 
   3.8146086948595276`*^9}, {3.8146087466097703`*^9, 3.814608746720665*^9}, {
   3.814608861165512*^9, 3.814608869489973*^9}, {3.8146090295106115`*^9, 
   3.8146090631681724`*^9}, {3.814609160124211*^9, 3.814609160405352*^9}, {
   3.814609209093858*^9, 3.8146092254802375`*^9}, {3.8146092634398203`*^9, 
   3.8146092635807767`*^9}, {3.814609302628834*^9, 3.814609304925516*^9}, {
   3.8146093828172016`*^9, 3.8146094225542808`*^9}, {3.8146094786932755`*^9, 
   3.8146094885174437`*^9}, {3.814609531905155*^9, 3.8146095319950666`*^9}, {
   3.8146104617442865`*^9, 3.814610471179207*^9}, {3.8146105945576773`*^9, 
   3.8146106090288*^9}, {3.814610834413989*^9, 3.8146108417835913`*^9}, {
   3.8146108967479477`*^9, 3.814610902629107*^9}, {3.8146110526957684`*^9, 
   3.814611059617625*^9}, {3.814611334234791*^9, 3.81461134445383*^9}, {
   3.8146113819235554`*^9, 3.8146113820330796`*^9}, 3.8146114640510807`*^9, {
   3.8146115010515647`*^9, 3.814611501598613*^9}, {3.814611560990673*^9, 
   3.8146116097513933`*^9}, 3.814614289538726*^9, {3.814614326826544*^9, 
   3.8146144586738815`*^9}, {3.814614499439996*^9, 3.8146145062993975`*^9}, {
   3.8146146427714996`*^9, 3.8146146853884163`*^9}, {3.8146147238982573`*^9, 
   3.8146148178850517`*^9}, {3.8146148876929264`*^9, 3.814614889105199*^9}, {
   3.8146177066983385`*^9, 3.814617718073777*^9}, {3.814617749043063*^9, 
   3.8146177496837115`*^9}, {3.814617884764719*^9, 3.814617885342657*^9}, {
   3.8146179349842787`*^9, 3.8146179607348537`*^9}, {3.814618535106042*^9, 
   3.8146185415281906`*^9}, 3.8146187109221334`*^9, {3.8146192877940397`*^9, 
   3.8146193238096523`*^9}, {3.8146193719276857`*^9, 3.814619446171419*^9}, {
   3.8146195974557467`*^9, 3.814619684519815*^9}, {3.8146197190204477`*^9, 
   3.814619755911885*^9}, {3.814619787040416*^9, 3.814619864289318*^9}, {
   3.8146205929438744`*^9, 3.8146206600546823`*^9}, {3.8146823673677883`*^9, 
   3.814682423740196*^9}, {3.8146824653967543`*^9, 3.8146824910512676`*^9}, {
   3.814682681651716*^9, 3.814682689184199*^9}, {3.8146830988836937`*^9, 
   3.814683146792658*^9}, {3.814683239569524*^9, 3.8146832551781588`*^9}, {
   3.81468329587936*^9, 3.814683300347901*^9}, {3.8146833932653804`*^9, 
   3.8146834017337313`*^9}, {3.8146834388725986`*^9, 3.8146835070256166`*^9}, 
   3.814683577912875*^9, {3.8146836265199423`*^9, 3.8146836890526314`*^9}, {
   3.8146837260196266`*^9, 3.8146837972662315`*^9}, {3.8146863674954224`*^9, 
   3.8146863713233585`*^9}, {3.814686521886073*^9, 3.8146865419660835`*^9}, {
   3.8146867996721935`*^9, 3.814686833139287*^9}, {3.814769358030079*^9, 
   3.8147693959277163`*^9}, {3.8147694973045034`*^9, 
   3.8147696220624104`*^9}, {3.8147696591040134`*^9, 3.814769667979559*^9}, {
   3.8147697073272257`*^9, 3.8147697486328735`*^9}, 3.814769786684599*^9, {
   3.8147698177424517`*^9, 3.8147698594876413`*^9}, {3.8147701671769643`*^9, 
   3.814770285780281*^9}, {3.814770326569642*^9, 3.814770370930131*^9}, {
   3.8147704607297015`*^9, 3.8147705004782543`*^9}, {3.8147705605486765`*^9, 
   3.8147705733972893`*^9}, {3.814770618882779*^9, 3.8147708109112577`*^9}, {
   3.814770851314294*^9, 3.8147709346289434`*^9}, 3.8147710156301146`*^9, {
   3.814771061031638*^9, 3.8147711181291056`*^9}, {3.8147712107988253`*^9, 
   3.8147712158338947`*^9}, {3.814772149411039*^9, 3.8147721530515738`*^9}, {
   3.814773278127329*^9, 3.8147733052274303`*^9}, {3.8147784886172523`*^9, 
   3.8147785174299517`*^9}, {3.8147786024673867`*^9, 
   3.8147787323580065`*^9}, {3.8147787878944373`*^9, 3.814778803741969*^9}, {
   3.8147791000037365`*^9, 3.8147792732848263`*^9}, {3.814779805385618*^9, 
   3.81477985782164*^9}, {3.8147799543328514`*^9, 3.8147799570202284`*^9}, {
   3.814781418661335*^9, 3.814781467447771*^9}, {3.81478156570308*^9, 
   3.814781611682824*^9}, {3.8147816460236983`*^9, 3.81478169867354*^9}, {
   3.8147817306599865`*^9, 3.814781766051177*^9}, {3.814781807280602*^9, 
   3.8147819150098963`*^9}, {3.8151263863367023`*^9, 
   3.8151264410562906`*^9}, {3.8151265229949155`*^9, 
   3.8151265442762547`*^9}, {3.817205735366785*^9, 3.8172057368822813`*^9}, {
   3.8172747149742985`*^9, 3.8172747502098074`*^9}, {3.818145887652297*^9, 
   3.8181458882033577`*^9}, {3.818153744160195*^9, 3.8181537482226048`*^9}, 
   3.8181545435083*^9, {3.820306182137514*^9, 3.8203061827001586`*^9}, {
   3.820306260750496*^9, 3.820306312096523*^9}, {3.82030638941284*^9, 
   3.82030639683607*^9}, {3.8203064524123416`*^9, 3.820306455571697*^9}, {
   3.8203065291966844`*^9, 3.8203065296693425`*^9}, {3.8243427275486517`*^9, 
   3.8243428965020933`*^9}, {3.824357542880828*^9, 3.824357553831236*^9}, 
   3.824979899569599*^9, {3.824979956574704*^9, 3.8249799574505615`*^9}, {
   3.8249800265035715`*^9, 3.8249801281594434`*^9}, {3.824980172137928*^9, 
   3.8249801976238155`*^9}, {3.824980327679983*^9, 3.8249803285549765`*^9}, {
   3.8249808094939003`*^9, 3.8249808724824553`*^9}, {3.82498100941321*^9, 
   3.824981074683035*^9}, {3.824981518946063*^9, 3.8249816295310416`*^9}, {
   3.8249817006293135`*^9, 3.8249817309748*^9}, {3.8249817678365993`*^9, 
   3.824981800301588*^9}, {3.824981833703676*^9, 3.8249818457004633`*^9}, {
   3.8249819995534954`*^9, 3.824982075058135*^9}, {3.825504176358939*^9, 
   3.8255041764681644`*^9}, {3.825504210984556*^9, 3.825504251468605*^9}, {
   3.825504536382449*^9, 3.8255045409136705`*^9}, {3.825504577242592*^9, 
   3.8255045866179085`*^9}, {3.827232938112853*^9, 3.8272331032204504`*^9}, {
   3.827233637751807*^9, 3.8272338793115396`*^9}, {3.827233917360423*^9, 
   3.827233970847766*^9}, {3.8272340234019732`*^9, 3.827234107901932*^9}, {
   3.8272344750124073`*^9, 3.8272344755466585`*^9}, {3.827234587943*^9, 
   3.827234983307168*^9}, {3.8272350736349177`*^9, 3.8272350828588324`*^9}, {
   3.8272351623942966`*^9, 3.8272352206096544`*^9}, {3.8272352573272114`*^9, 
   3.8272353049972796`*^9}, {3.827235338281121*^9, 3.8272353575887537`*^9}, {
   3.8272355536668634`*^9, 3.8272355671391935`*^9}, {3.8272356907641096`*^9, 
   3.827235698116151*^9}, {3.827237326015725*^9, 3.8272373546541986`*^9}, {
   3.8273005526614285`*^9, 3.827300555671923*^9}, {3.8273006054547973`*^9, 
   3.8273006265734177`*^9}, {3.8273006604439354`*^9, 3.82730070770439*^9}, {
   3.827300772080652*^9, 3.8273008254760623`*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"b508c09e-bcb3-4682-98dd-e62d075b4a48"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`aa$$ = 0.0005, $CellContext`AA$$ = 
    0.3, $CellContext`bb$$ = 
    0.0001, $CellContext`BB$$ = -0.5, $CellContext`clp$$ = 
    0.286, $CellContext`h$$ = 1, $CellContext`hwhm$$ = 0.1, $CellContext`k$$ =
     0, $CellContext`kMag$$ = 1., $CellContext`l$$ = 
    0, $CellContext`lambda$$ = 0.154, $CellContext`model$$ = 
    "Popa-Adler-Houska", $CellContext`RRe$$ = 2.98, $CellContext`structure$$ =
     "bcc iron", $CellContext`xMag$$ = 1., $CellContext`\[Eta]$$ = 
    0.5, $CellContext`\[Theta]\[Theta]$$ = 45., $CellContext`\[Rho]$$ = 0.005,
     Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Text[
        Style["Pseudo-Voigt function", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Eta]$$], 0.5, "mixing param."}, 0., 1.}, {{
       Hold[$CellContext`hwhm$$], 0.1, "hwhm"}, 0.001, 2.}, {
      Hold[
       Grid[{{
          Manipulate`Place[1]}, {
          Manipulate`Place[2], "\[Degree]2\[Theta]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`model$$], "Popa-Adler-Houska", 
       "Microstrain model"}, {"Popa-Adler-Houska", "Krivoglaz-Wilkens"}}, {{
       Hold[$CellContext`structure$$], "bcc iron"}, {
      "bcc iron", "fluorite", "free input"}}, {{
       Hold[$CellContext`clp$$], 0.286, ""}, 0.1, 1.}, {{
       Hold[$CellContext`AA$$], 0.3, ""}, 0., 1.}, {{
       Hold[$CellContext`BB$$], -0.5, ""}, -1., 1.}, {{
       Hold[$CellContext`aa$$], 0.0005, ""}, 1.*^-7, 0.005}, {{
       Hold[$CellContext`bb$$], 0.0001, ""}, 2.*^-7, 0.002}, {{
       Hold[$CellContext`\[Rho]$$], 0.0101, ""}, 1.*^-7, 0.11}, {{
       Hold[$CellContext`RRe$$], 2.98, ""}, 0.1, 100}, {
      Hold[
       Grid[{{"cubic a", 
          Manipulate`Place[3], "nm"}, {"A      ", 
          Manipulate`Place[4], ""}, {"B      ", 
          Manipulate`Place[5], ""}, {"\[Alpha]      ", 
          Manipulate`Place[6], ""}, {"\[Beta]      ", 
          Manipulate`Place[7], ""}, {"\[Rho]       ", 
          Manipulate`Place[8], ""}, {"RRe     ", 
          Manipulate`Place[9], ""}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Theta]\[Theta]$$], 45., ""}, 1., 179.}, {{
       Hold[$CellContext`lambda$$], 0.154, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`h$$], 1, ""}, 1, 10, 1}, {{
       Hold[$CellContext`k$$], 0, ""}, 0, 10, 1}, {{
       Hold[$CellContext`l$$], 0, ""}, 0, 10, 1}, {
      Hold[
       Grid[{{"peak position ", 
          Manipulate`Place[10], "\[Degree]2\[Theta]"}, {"wavelength    ", 
          Manipulate`Place[11], "nm"}, {"Miller index h", 
          Manipulate`Place[12]}, {"Miller index k", 
          Manipulate`Place[13]}, {"Miller index l", 
          Manipulate`Place[14]}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Zoom factors", 16]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1.}, 0.1, 10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1.}, 0.1, 10., 0.1}, {
      Hold[
       Grid[{{
          Manipulate`Place[15]}, {
          Manipulate`Place[16]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1009., {330., 336.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`aa$$ = 0.0005, $CellContext`AA$$ = 
        0.3, $CellContext`bb$$ = 
        0.0001, $CellContext`BB$$ = -0.5, $CellContext`clp$$ = 
        0.286, $CellContext`h$$ = 1, $CellContext`hwhm$$ = 
        0.1, $CellContext`k$$ = 0, $CellContext`kMag$$ = 1., $CellContext`l$$ = 
        0, $CellContext`lambda$$ = 0.154, $CellContext`model$$ = 
        "Popa-Adler-Houska", $CellContext`RRe$$ = 
        2.98, $CellContext`structure$$ = "bcc iron", $CellContext`xMag$$ = 
        1., $CellContext`\[Eta]$$ = 0.5, $CellContext`\[Theta]\[Theta]$$ = 
        45., $CellContext`\[Rho]$$ = 0.0101}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`n$, $CellContext`x1$, $CellContext`x2$, \
$CellContext`deltax$, $CellContext`k1$, $CellContext`k2$, \
$CellContext`deltak$, $CellContext`grid$, $CellContext`samples1$, \
$CellContext`samples2$, $CellContext`samples3$, $CellContext`g1$, \
$CellContext`g2$, $CellContext`g3$, $CellContext`l1$, $CellContext`l2t$, \
$CellContext`l2$, $CellContext`l3$}, $CellContext`n$ = 
          2048; $CellContext`deltak$ = 
          400/$CellContext`n$; $CellContext`k1$ = (-($CellContext`n$/
             2)) $CellContext`deltak$; $CellContext`k2$ = $CellContext`k1$ + \
$CellContext`n$ $CellContext`deltak$; $CellContext`grid$ = 
          Range[$CellContext`k1$, $CellContext`k2$, $CellContext`deltak$]; \
$CellContext`samples1$ = 
          Map[$CellContext`FTPVoigt[#, $CellContext`\[Eta]$$, \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$] \
$CellContext`hwhm$$]& , $CellContext`grid$]; 
         Which[$CellContext`structure$$ == 
           "bcc iron", {$CellContext`clp$$ = 0.286, $CellContext`AA$$ = 
            0.3, $CellContext`BB$$ = -0.5, $CellContext`\[Rho]$$ = 
            0.005, $CellContext`RRe$$ = 2.98}, $CellContext`structure$$ == 
           "fluorite", {$CellContext`clp$$ = 0.54616, $CellContext`AA$$ = 
            0.111, $CellContext`BB$$ = 0.282, $CellContext`\[Rho]$$ = 
            0.101, $CellContext`RRe$$ = 2.98}]; 
         Which[$CellContext`model$$ == 
           "Popa-Adler-Houska", $CellContext`samples2$ = 
           
           Map[$CellContext`ALDPAH[#, $CellContext`clp$$, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`aa$$, $CellContext`bb$$]& , $CellContext`grid$], \
$CellContext`model$$ == "Krivoglaz-Wilkens", $CellContext`samples2$ = 
           Map[$CellContext`ALDWILK[#, $CellContext`clp$$, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`\[Rho]$$, $CellContext`RRe$$, $CellContext`clp$$ (Sqrt[2]/
               2)]& , $CellContext`grid$]]; $CellContext`samples3$ = \
$CellContext`samples1$ $CellContext`samples2$; $CellContext`g1$ = 
          Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples1$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`g2$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples2$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`g3$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples3$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`x1$ = 
          50/$CellContext`k1$; $CellContext`x2$ = 
          50/$CellContext`k2$; $CellContext`l1$ = 
          ListLinePlot[{$CellContext`samples1$, $CellContext`samples2$, \
$CellContext`samples3$}, DataRange -> {$CellContext`k1$, $CellContext`k2$}, 
            PlotRange -> {{$CellContext`k1$/$CellContext`kMag$$, \
$CellContext`k2$/$CellContext`kMag$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "Fourier length, s (nm)", "Fourier Transform"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              
              LineLegend[{
               "FT of peak shape", "FT of microstrain", 
                "FT of convolution"}], {0.2, Top}], TicksStyle -> 
            Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
            ImageSize -> 500]; $CellContext`l2$ = Plot[{
             $CellContext`g1$[$CellContext`x], 
             $CellContext`g2$[$CellContext`x], 
             $CellContext`g3$[$CellContext`x]}, {$CellContext`x, \
$CellContext`x1$/$CellContext`xMag$$, $CellContext`x2$/$CellContext`xMag$$}, 
            PlotRange -> {{$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`x2$/$CellContext`xMag$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "rel. \!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"peak shape", "microstrain", "convolution"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; $CellContext`l2t$ = 
          Plot[{$CellContext`g1$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$], \
$CellContext`g2$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$], \
$CellContext`g3$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]}, \
{$CellContext`x, $CellContext`\[Theta]2[$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`lambda$$] + $CellContext`\[Theta]\[Theta]$$, $CellContext`\
\[Theta]2[$CellContext`x2$/$CellContext`xMag$$, $CellContext`lambda$$] + \
$CellContext`\[Theta]\[Theta]$$}, 
            PlotRange -> \
{{$CellContext`\[Theta]2[$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`lambda$$] + $CellContext`\[Theta]\[Theta]$$, $CellContext`\
\[Theta]2[$CellContext`x2$/$CellContext`xMag$$, $CellContext`lambda$$] + \
$CellContext`\[Theta]\[Theta]$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "2\[Theta]  (\[Degree])", "Intensity (a.u.)"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"peak shape", "microstrain", "convolution"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; 
         Which[$CellContext`model$$ == "Popa-Adler-Houska", $CellContext`l3$ = 
           Plot[
             $CellContext`WPLTPAH[$CellContext`L, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`aa$$, $CellContext`bb$$], {$CellContext`L, 0, 50}, 
             PlotRange -> {{0, 50}, {0, All}}, 
             FrameLabel -> {
              "Fourier length, s  (nm)", 
               "<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\)  (nm)"}, GridLines -> 
             Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
             Frame -> True, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
               LineLegend[{"Warren plot - Popa-Adler-Houska strain model"}], {
               0.5, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
             Directive[Black, Thick], ImageSize -> 500], $CellContext`model$$ == 
           "Krivoglaz-Wilkens", $CellContext`l3$ = Plot[
             $CellContext`WPLTWILK[$CellContext`L, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`\[Rho]$$, $CellContext`RRe$$, $CellContext`clp$$ (Sqrt[2]/
               2)], {$CellContext`L, 0, 50}, PlotRange -> {{0, 50}, {0, All}},
              FrameLabel -> {
              "Fourier length, L (nm)", 
               "<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\) (nm)"}, GridLines -> Automatic,
              GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
             True, FrameTicks -> {{Automatic, Automatic}, {
               Automatic, Automatic}}, LabelStyle -> Directive[Bold, 16], 
             PlotLegends -> Placed[
               LineLegend[{"Warren plot - Krivoglaz-Wilkens strain model"}], {
               0.5, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
             Directive[Black, Thick], ImageSize -> 500]]; 
         Grid[{{$CellContext`l1$, $CellContext`l2$}, {$CellContext`l2t$, \
$CellContext`l3$}}]]], "Specifications" :> {
        Text[
         Style[
         "Pseudo-Voigt function", 16]], {{$CellContext`\[Eta]$$, 0.5, 
          "mixing param."}, 0., 1., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         1}, {{$CellContext`hwhm$$, 0.1, "hwhm"}, 0.001, 2., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 2}, 
        Grid[{{
           Manipulate`Place[1]}, {
           Manipulate`Place[2], "\[Degree]2\[Theta]"}}], 
        Delimiter, {{$CellContext`model$$, "Popa-Adler-Houska", 
          "Microstrain model"}, {"Popa-Adler-Houska", "Krivoglaz-Wilkens"}, 
         ControlType -> RadioButton, Appearance -> "Vertical"}, 
        Delimiter, {{$CellContext`structure$$, "bcc iron"}, {
         "bcc iron", "fluorite", "free input"}, ControlType -> RadioButton, 
         Appearance -> "Vertical"}, {{$CellContext`clp$$, 0.286, ""}, 0.1, 1.,
          ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`AA$$, 0.3, ""}, 0., 1., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         4}, {{$CellContext`BB$$, -0.5, ""}, -1., 1., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`aa$$, 0.0005, ""}, 1.*^-7, 0.005, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         6}, {{$CellContext`bb$$, 0.0001, ""}, 2.*^-7, 0.002, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         7}, {{$CellContext`\[Rho]$$, 0.0101, ""}, 1.*^-7, 0.11, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         8}, {{$CellContext`RRe$$, 2.98, ""}, 0.1, 100, ControlType -> Slider,
          Appearance -> "Labeled", ControlPlacement -> 9}, 
        Grid[{{"cubic a", 
           Manipulate`Place[3], "nm"}, {"A      ", 
           Manipulate`Place[4], ""}, {"B      ", 
           Manipulate`Place[5], ""}, {"\[Alpha]      ", 
           Manipulate`Place[6], ""}, {"\[Beta]      ", 
           Manipulate`Place[7], ""}, {"\[Rho]       ", 
           Manipulate`Place[8], ""}, {"RRe     ", 
           Manipulate`Place[9], ""}}], 
        Delimiter, {{$CellContext`\[Theta]\[Theta]$$, 45., ""}, 1., 179., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         10}, {{$CellContext`lambda$$, 0.154, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         11}, {{$CellContext`h$$, 1, ""}, 1, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         12}, {{$CellContext`k$$, 0, ""}, 0, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         13}, {{$CellContext`l$$, 0, ""}, 0, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 14}, 
        Grid[{{"peak position ", 
           Manipulate`Place[10], "\[Degree]2\[Theta]"}, {"wavelength    ", 
           Manipulate`Place[11], "nm"}, {"Miller index h", 
           Manipulate`Place[12]}, {"Miller index k", 
           Manipulate`Place[13]}, {"Miller index l", 
           Manipulate`Place[14]}}], Delimiter, 
        Text[
         Style["Zoom factors", 16]], {{$CellContext`xMag$$, 1.}, 0.1, 10., 
         0.1, ControlType -> Slider, Exclusions -> {0}, Appearance -> 
         "Labeled", ControlPlacement -> 15}, {{$CellContext`kMag$$, 1.}, 0.1, 
         10., 0.1, ControlType -> Slider, Exclusions -> {0}, Appearance -> 
         "Labeled", ControlPlacement -> 16}, 
        Grid[{{
           Manipulate`Place[15]}, {
           Manipulate`Place[16]}}], Delimiter}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Fourier (back)transform of Pseudo-Voigt function convoluted with \
microstrain\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1524., {446., 452.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`FTPVoigt[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Eta], 
          Blank[]], 
         Pattern[$CellContext`hwhm, 
          Blank[]]] := 
       Module[{$CellContext`k = (
            1 + (1 - $CellContext`\[Eta])/($CellContext`\[Eta] 
             Sqrt[Pi Log[2]]))^(-1)}, (1 - $CellContext`k)/
          E^((Pi^2 $CellContext`hwhm^2 $CellContext`L^2)/Log[
           2]) + $CellContext`k/
          E^(2 Pi $CellContext`hwhm Abs[$CellContext`L])], $CellContext`k$$[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       1/$CellContext`s[$CellContext`\[Theta]2, $CellContext`\[Lambda]], \
$CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`\[Lambda] = 
       0.14249059611887502`, $CellContext`cs[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := ($CellContext`\[Theta]2 Degree) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`cs[
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := (Pi/180) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`ALDPAH[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`a0, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`aa, 
          Blank[]], 
         Pattern[$CellContext`bb, 
          Blank[]]] := 
       E^((-2) Pi^2 (($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)/$CellContext`a0^2) ($CellContext`AA + $CellContext`BB \
(($CellContext`HH^2 $CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + \
$CellContext`LL^2 $CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2)) ($CellContext`aa 
           Abs[$CellContext`L] + $CellContext`bb $CellContext`L^2)), \
$CellContext`ALDWILK[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`a0, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`\[Rho], 
          Blank[]], 
         Pattern[$CellContext`RRe, 
          Blank[]], 
         Pattern[$CellContext`bu, 
          Blank[]]] := 
       E^((-2) Pi^2 (($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)/$CellContext`a0^2) ($CellContext`AA + $CellContext`BB \
(($CellContext`HH^2 $CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + \
$CellContext`LL^2 $CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2)) (($CellContext`bu^2/(4 
           Pi)) $CellContext`\[Rho] $CellContext`L^2 
          If[$CellContext`L == 0, 0, 
            $CellContext`FWILK[
             Abs[$CellContext`L], $CellContext`RRe]])), $CellContext`FWILK[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`RRe, 
          Blank[]]] := If[
         And[$CellContext`L > 0, $CellContext`L <= $CellContext`RRe], -
          Log[$CellContext`L/$CellContext`RRe] + 7/4 - Log[
         2] + ($CellContext`L/$CellContext`RRe)^2/6 - (
          32 ($CellContext`L/$CellContext`RRe)^3)/(225 Pi), 
         512/(90 Pi ($CellContext`L/$CellContext`RRe)) - (
          11/24 + (1/4) Log[2 ($CellContext`L/$CellContext`RRe)]) (
          1/($CellContext`L/$CellContext`RRe)^2)], $CellContext`fourierData[
         PatternTest[
          Pattern[$CellContext`data, 
           Blank[]], MatrixQ], 
         Pattern[$CellContext`scale, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`xGrid, $CellContext`pGrid, $CellContext`f, \
$CellContext`x0, $CellContext`x1, $CellContext`NN, $CellContext`DFT}, \
{$CellContext`xGrid, $CellContext`f} = 
          Transpose[$CellContext`data]; {$CellContext`x0, $CellContext`x1} = 
          MinMax[$CellContext`xGrid]; $CellContext`NN = 
          Length[$CellContext`xGrid] - 1; $CellContext`pGrid = 
          RotateRight[
           Range[-($CellContext`NN/2), $CellContext`NN/
              2]/($CellContext`x1 - $CellContext`x0), 
            Quotient[$CellContext`NN, 2] + 1]; $CellContext`DFT = 
          Fourier[$CellContext`f, FourierParameters -> 
             OptionValue[
              FourierParameters]] (($CellContext`x1 - $CellContext`x0)/Sqrt[
            2 Pi $CellContext`NN]); 
         Transpose[{$CellContext`pGrid, $CellContext`scale 
            Abs[$CellContext`DFT]}]], 
       Options[$CellContext`fourierData] = {
        FourierParameters -> {0, 1}}, $CellContext`data = CompressedData["
1:eJw0XHc81e8Xt6MoktmSIhqShubnEPJtp10qspqaSntop6GBKCXKiMpeqWMT
kb03lRRlb35+9zn6p9d9ua7P/Xye5zznvNcksyMbLAX4+Pj4Rfn4/v+/zJtV
0ds+12K10YmzJ+42cTMejVNVj6xFPc5y1e3B18suNTzoCq7F+5tMGkIGX28/
9Lnry/taPDLyvmn74Ouj2x+Yu/rW4nSVuW/W3Gvibi43TT/wuhbr7r/9GDX4
2m3ObO3FL2ux6arp66X3m7gQJYFXI1xrUedMiUn+4Os0iZzhpU9qcaN6eOO1
B01cdbenjf+DWuy6/8ZohUMT1/nTpvz8nVpUbTx8e/LDJm5UnsF/a67XYtTX
JifpR02capxs0PjLtfhzQPmcwuMmbsmHn2Mbz9ZikaeE9rwnTdzG5xHXP5+s
xYuqOWlWjk3cgdu3/94/WoveBn6L3js1cVdO7dhucrAWNWVqr4142sQ5m0+P
n2VVix/6q/wuujRx79f3zuDbU4sdqRMDhz1r4hKXpjtlGtdi7QsNJ6/nTVzp
tBd8r7bU4jyhsJ3GL5q4ZrkjB44Z1eLh3ydEVN2bODFhnVzd1YOfH7LEUcSj
iVNqluRGG9biQfWe4X2eTdz8iirvat1alHoUsF/Mq4lb8zVIKnhJLUr62wRP
92niLCKvnruqXYvbwk/Wm79t4s55bfq+UWvw+k93Sgb5N3EPH6usmzKzFkuW
bVOX/dDE+Vxuj2idOnh97SLzHQKbOLROVk5UrsUDo+8tVApp4vJ3PL3rOL4W
m9/fnp8U1sT9Mdzfbilfi7p3g2bZRTZxgvMWmc6XrkV32dypm6KbOEXlEaki
I2tR6UjWpCXYxM0eVTqnQLQWY4+8VloU18QZ9vq7eQvWYl7ErqlrE5u43b8u
DDvdX4Mzg6YsPJ3SxJ3MX3vsv64atHbW3h6R1sTZx08skW+twa9Xft8Z+a2J
8wj4p/+rsQYFD/lnnc1u4iLdYt9H/qrBeq5Psy+vicu880j+Tm0NPiqy9Xcs
auJ+2Jrb7aioQUOFdEP9siauz2Lun2nFNWj+PUFErKqJG7NBeEtPbg1y2lxD
TW0TNx3yMe1bDb5UmTWQW9fE6c7wVn+eWoM9Da91Sv80cdsUTj8+lFiDywbi
Q7v+NXFHRFb0LYmpwQXCKWYz25q4Gy0KeyU+1qBWi+Bq264m7nllfWZZaA0e
Gll9sqCviQtO/7jofUANlnTX1K4RaOZSo+6+vuhXg1aJHm7FIs1cpfeukeu8
atC/JeP1hRHNXMcTjdMTX9VgwW3NgfmSzdxIu4Gqv89qMHy8d6CITDOnciRz
VYxTDSaWqcf+UWjmFu98FerwcPDzPZO1fk1o5jasOD5xz90abOjxGtE7uZnb
P1/v9uybNdi9QMRIRb2Zuzx5TAu/XQ2+PrdY1FKjmXOS/L4z+3wNViaEzP84
p5l71xea5GFbgzoCnVVTFzZzCfU3NE8cr8H0cZ6j/Lhmrrhgq6uedQ2+Ej2U
qK/fzDUlqAmN2VeDP7KVxNpWNHOiQV3WtWY1OCvAu/LjumZu4svUgpBdNWg7
asDIZXMzN+/uM93r22pQ/c1S83vGzdzqM4f8Nm+sQefLjxSf7mnmzK2Wyqiu
rcE8GYOLkXububMbR15q/68Gn20OfdJk3cw56FTUJenVoHyEsYWOTTPnPTNg
gzNXg+Lrv7S8OdvMfVa8Er13YQ26lXuvUL7SzOUO26C6YG4N3q+KPBR6s5n7
3arsIDqrBiXfFJub3G/mBKpbugrVa3CPcf88JcdmTuFbgrnvlMH3q2rVdzxr
5mZFO6afmViDK+Y+v/nDo5lb7mulvVKxBnemnJP549vM7XLSfqUoU4Ojt6s/
Ew1s5myuio74PaoGFV1klZZENHN3jhbZfBxeg18eZ/jdwGbu1a635fbCNTjj
Y5tBXVIzF7Hy3H87+WrQi39lu2lGM5ehvTpoRk812vzySPiX18x9nzJ+XF9b
NXa7NUU4lzVzvVKN19P/VeN9Yd2Szd+bOemBz3/dflfjr5LQOdMbmjn1Pw+2
H/5Rjbax91Pl2po5nSLTeK6qGsW3TfEZ29fMbU2aPXNUaTX2bviVO1+4hTsc
LOBckV+NPY4Htu+XaOGuuefwBWRVI+qu44JlWrhn914fuPy1Gi3zt90dM6GF
Czp7Mnd9cjUW6ZqvvqfawqXsXc5NiqvG4j6Lm+NntXAVm+R8mqIH/57KkeWJ
2i1cu26dVFx4NR6//+7RNZ0WTmJW5LlHQdV4tNrqpPGKFm7yuDvfzd5Vo0NE
b8eKDS3cIjHjdXN8qlHJ//fk9cYtnFH79EhBz8HvczZN4LBFC7evplc5160a
Ryuue+Fp3cJdzEy/+/ppNX4o0OdrOtXCOX560W7zuBovWTtpbbncwvm/PWJq
cL8ah01eATm3W7g4Z51UmdvVGFh7QXPf4xau6JrU3B9Xq1FgzzFJGbcW7t+x
arewi9WYNuX8ryKvFm6YSfCwm2eqUSxidFJYQAs3fvW1Y1ttqvFLRGKAX1QL
N3fh5pKpR6oRenVDIhJauFWqqgad+6uxxnt9SVlGC2cm3fE+xaIa/Y0KNMcW
tXCn+VLkXUyqcc24Qjxa08I9aHhqt39HNeYUH3tc3tDCeRXv/7NwczVmqlSG
WXS2cNHJi7YMXz+4Hm6dmyco2MrlhIyIKV5ZjX8dIhWjJFq5+lel6n4G1ejX
M+P4bflWjv/Bu8fndKrx9rfrhscmt3Ly5y/2rVpcjc0XHnod02jlNPav2ztu
fjW+EFz87M7CVs5gi1LWH81qrBe3nx2t38rt1Gta9Gl6NY6R8Tkpsr6VO64Z
9/qe6uD9vpV/Yr9xK3d7/OORuydVo+rP0wu+W7Vy7sMtTmuMq8aF9aMyzxxv
5cI75lb3y1bjbM9FhlMvtnLptcKrv0lV41LPsLcNt1u52qz80Jfi1bh8nOmw
dMdWruez98Sjw6pRQlTrQOKrVm60/+nbOgLV+G7l8sr8d62cmsuKFsm+KnxW
lHeKP6qVgxuKu6o6qrC8csFig6RWbsuJ30mBzVU44tePRR7Zrdwh02hNu4Yq
nNbveFaqopW7uuae64a6Kvx2WXbA/ncr57pot9Dkmiqc2ayRL9XZygVOnXW4
pawK/074KOEp1MYlj+ErjC+swm36/sEg1caV82fpPsmpwuClYvk/x7dxbY2v
/CwyqnC2T6Pds2ltnHjpcZl5X6owS+JByg7tNk75i94l4YQqfDVyTqiKfhu3
MGzMr7zPVfjlzsKtvevbuPWe3zd4RVZhTprcp/JdbZyVQ1j0qZAq3PNhe9vX
A23chQs3VQ0/VOGH7Fcjk23buCcHtjnIva3C09G+cunX2ji/rerdP19XoZ/Y
sokVD9u4WP1u84iXVWj/dMPcvhdtXOHstPRbrlVYF1JsOdW/jfs74bn2dscq
lDNsitsV2caJiFu/UncYvH+9CTvck9q4cV1LR3TfqcKos8+X/M1p4+b8GHky
9XoVLrmVb7uyqo1bmVNR7np58PqW1o8NamzjTGMC/jt4rgofz9m7QLW3jbN9
dyVo8akqdAluK/USa+fuu24YJ36sCrFmi8JcuXbuzc3JN0oPVuH+Hou+9Cnt
3Eeb1r/+VlWocFjaxUarncvek7j9wp4qjFY+0jtVp537tdYpfs3OKqx6+UK7
bk07x7dk78wJW6vQjqveEWrczsmqL3BuNKrCxbuenHqwv52bKSvGj6ursPux
+rNTtu2cvmDxgQeGVXijRrPowPV2bse/t7kmy6rw1u+Nuocet3PHys5xmkur
0HnC1tqzr9q5W6mrffgWVKFgm0KO04d27mX4+NFZWlUYPtl5Qsyndi70deO5
VzMH11dWbUF7Wjv39SF+P6Y2eD+S50ouLm7nai46rFs2uQofBeUW3q1r57oP
7okcPaEKd6zV0PvT3s5JbteaXCNfhfVvkk23C3dwU5cL3guWrsK1+np6udId
HDcnt/3qyCqMPG7au1O5g9uk9MZ0k1gV/rLucWvR7OAOSpxKnSJUhV4vJRY9
hQ7Ornv53Lb+Smwufle9cm0H5/JT7kViVyWGOEq+HbGrg/uQWzfMqbUSfynd
8ig+2MElxUYes/pbiTPrrpWHn+3gyt7fKZlfX4n5bx2Pet7u4FqfGRsM+16J
fVF7D7o97eCG357xoaCiEldoJ1e98e7gJp3qk/cprkRu7csf0WEd3ALzDLvT
eZXocrL7bnViB7d2/cs//2VW4pgPAnWyeR2c5dKjWxTSKlEzgX/EjtoO7vw0
3ZhfiZW4//YeMf+WDu6x3OhpUTGDrxX928UFO7m3QjWP73ysxHqluz/Oj+7k
YpqC+3aEVeJnqfQ/PZM6uYLya3unB1ai7HHj8Xdmd3KNaZuzevwq0Uje4O5U
3U5OKFJ18VevSuyxiVyTu76TG+vV8fr5q0oUyxA75WDayWk9Thlp/bwSp973
Vdh5tJP777LL6aXOlVh1RWON9uVOzsT6QLXEo0o8PtlIRdmhkzu1Y/Hq8ruV
eLjiT9g4907unqF42Publbh5F5/c1IBO7vXcsomX7AY/P+ndDt2YTi5q0vvb
6y5UYumoxc4HMzu5rJGXWiaersRYg9HVbyo7ubqedbv+Ha/EhuzY9f/+dXL9
dUrJMdaVuCi9t3Mlfxcnk9+k+XBfJf7UffYvVKqLmxEf57rHvBK9Lruuma3c
xS0LeCyktbsSyw6NV/2k1cVtd7M4LLC9Em8mHHLYrtfFHb0zrzB7YyUmnerw
ENnUxd20FVnmubYSbzRusEmw6OJeWBT4nVhRiRoWi8c+PtnFhRj5yOjrV2LH
zCfvj9/o4tK4M5fGQCUqyOwzMHfu4qqnr/xVu7ASdT1+tVv4dHGd8mM3hs6t
xDzbE8W2kV3cKJE/0ddnVeLeV7eGPU/t4lRbolW3TKvEjb9zHbNKurgllfcc
VFUqsX3eTDf5hi5uY/ru7vaJg/cz68G8Y/1d3IGoWRbJipXYlTHFtmRUN3fF
my/DWaYSL+/mzm6d1M09fZKlvU9y8HlP2b71u1Y39/6Kx6sFIyrxiOO4qdf1
u7nEwydGiIlU4sGNxgLaW7q5UmP9k0V8g/fnmrRAz95u7vvDaZ83dlSg7rwj
kHWmmxt96OvD1j8VOC04ISfSvpvTWX7Y0rG6Ai//dioMcevmrJUkF84vrMDJ
6Y574z50c67dgeIF6RV41uuFa3VsN5eSu7HSNr4Cn9+OtpfJ7eba37cFy0dW
4H5/tc3GP7q5ybedb0a+r0CTjJVSIZ3d3HrzhcY7XlfgedfI4okjeriLS0s0
elwqcOKoxV9fjO/h/OUuCDx/UIGV1Ql8szV7uKKmCflLrlegWeP5x/nLejiR
rzG+ZWcr8KFD5MsHm3u4uV5mFy4ercAXEwR0d+7r4cwuCxlNtKpALcNRj5ec
6+Hu7/CaEmNcgcI30gI17/dw0XP/6zQ1qsAjtzdGLnjVw9WPrE/jN6zAhjft
iZtCeji5X/YvPZYMfr6uduu15B5OP37mCT2tClxtmGb6pbiHO+72bXnt1Ar0
dHyuptzYw7nbHlO8Pr4CG4992feAv5dLN5JuVJEefN3zmpOS6eW6p4fGJolW
4LXX4cnear2cmshWx7395WjrjpM2LunltlR27hNtLcdks8AD0ut7uatRrkt8
f5Wj9OiImDrzXi7gyRLJlRXl+Fx4/rIc216u/HB5TX1uOdosSZTIse/lRqy4
HG6fWo5h5drL6l72cgsmK9vPiCnHnyFP+0eH9HJWffG700PLscNvutnGlF7u
SYGl1mG/clTZePiub2kvFxs4TGTUq3J8u1PeTaapl2u09y364FSOB5XHhTgL
93HjrFa9W3+3HJ3VvJtmKfZxK3UaLjddKcdQT+VT5Rp9nK3ig02PbMuRj2+u
madeH/e6VVNtjnU5+u77lH9xWx+XnZHdk2NWjo0byluPWvdxAz4232y2leMO
kdayM3Z93Iyrsp4ya8vx0SzXYBfnPm7HrohTYXqDn7fXzznTv4+7pb1j5daF
5bg6Udd/QlwfFyrVO75ToxxzjodLXyvo46p/uzU9nVKOwYu9//E19HGSSZC4
ULEcI5QaLB0F+jnOvepp8ahyTGj2ctKV7+cOnr166JxwOc6vmeslrNHPPd2k
ojOupwzXTl4UUaXXzyVpJEt/+leGL8+6/cvb3s+1iu7/uetHGY77cftE9ZF+
Tqlm+Mf+kjKM0DpiOexGP7f2k//9l1mDP/cQ+K3/vJ8777zWTCe5DJ9eB/Vn
Qf2c77F/86qiy3DDz70Gw7/0c/mrHonZBZXhgenClo8q+jkh1bllyj5lGBBe
925Oez+nxZcfEO9Whsuez1jeKD7AmRTbXrN4XIYzubmb4iYPcHdDFLYJ3y7D
Y/zv+j8sGuCi7n+c7nWxDH933z8UbjTA1e3bNbDcpgyPPBufWLhvgJPRG8j+
ub8MhazqZo25PMAtG//K65ZJGf56mZa733mAO9qx7Kz65jK8L9ZUUvR+gHPL
ql2TunLw9x9nWlskDXCpfjcmHdQpw16F2cFi5QNc53W1thHzy1BCST3vS9sA
p2qamuI/vQxfJT24mC3CBxsXHXq+ZlIZJs23eps+mg8ujxl5tFG2DCuLxl3N
n8AH7xs/6D0QL8OV/VXjG6bxQWmKkZymQBl6+0k4SGnzgZhnS31mRymOFlH+
q6fHB/MvOH4+1lCKqcFp66+t4wOLrdqPRteUYrhedWq2MR88nF1kGVxYijOc
9p2YtY8PPo84t3BTRim+0btn6mrDB3++j5Noiy9FH1E/H+krfKAY87nSMbIU
D89aYfbsHh8YupqGzP9Qiqv7x76e7coHNjYCtwpel+LdycLX8734wGPta+PT
rqVYPWXMuDvBfJCptnyWgkMpWn67cXl1DB/0CdQJRF0vxWzfL1/Gp/PBtLLb
+TvOleIWy9Oj+ov4YFv49Lc9R0tx7Kbd+xt+8MGNh+kXnluVYljpqb+/W/gg
6OARo6U7S5G/qSGyi48fKg2kVMqNSrHwhlKV7Eh+GKkU3HnRsBT7JN0u6I3l
h8Xdm75OXFqKU7on+1xS44d9ue0vY7RKcbeSz5m0efzg9P7piT1qpVi5cd2I
qXr8kHBrkaHAhFK0yzt+6tF6fmgyK1X0lC7F+PyXuRK7+WHC0ouNemKlaNDn
DC4H+WG1nFJcbX8Jzqs1ypp7hh/ONsU6Xm8twQ+eXZ6VN/jBO818v2p9Cdpv
bsp6/oQfct8IL02uKEGrF1kn93vwg8Blb8l9eSW4WPvA2+UB/DBrx4pa0bQS
/O9M3J25n/lh59zf4b4xJXj2l4LWnK/8cGfkPfuVYSV44Uvdx2XF/BBRp2Hy
268EF3hV6pnX8cP3uEytu69KMLr+z/cn7fww2u24yEznErxxYs7nAiEB0LEd
U5x+d/D3p8j8mi4tAIeNwt4dtitB68saVx9OEoBn07ddGXV68Pp1t/mKagpA
inD3pgDrEpzR5n36IScA7RXP1IzMS/Cn89GRM9YIwOSopb1N20pQZK7erUJj
AVj/pOLbo7UluOXqX0HnAwJw8fAVzzn6JejpcO3l3jMC4P/fZNvchSV4ZKfR
mZW3BKBIOXHlyVklKH31+wdwFgCRPqsJsiol6PFDyszQSwDmFog2hymWYP2W
X+/3hAqAWeDbxK2SJVgGsaH3EwTggf1ql07hEnTZpuWUkSMA0ZaNh1x6itFk
g8LRSTUCUA8OOouainHOXWfzm80CIKeoNabkRzF2fZF+yCcgCPqtOT/PlRaj
Qd0ihXtSgnA84+THcdnFuM2Fb/zMSYLg7iP34FNyMSpNcP9UqSkI6XaRZrs/
FeMWEbdxPjqC0L3TeP5AUDHe+hdvfHW9IKhp94m5+xTjrDXT3Y6bCsIWqZdl
Oi+KMVx5ruCpo4Jw9bdOYNXjYjxVcCfg3mVBCEisvmZ3uxgruqamRDoIQvnL
a9smXypG+VFG1t3ugiB+VnVGgk0xepm6xK8LFIQFm1IGLA4Uo2BmdWNkrCBY
aRzIETYtRhnf3dILswXhiai4t9fmYvzv/P3N6dWCEFv97qzhqmI83KZffKpF
EBqj162t0xn8+UevpHlCQjDOuWnS7fnF+HD1dJ3hMkKw8tjjNvUZxfi41u1Q
q4oQ2K6a9yV1UjH+3DXheOt8IXitUvD8oFwxzh+vbDv8PyHIHjh9VFyiGFW6
bTzmbxcCvmJF/XcCxVipsWjsmQNCMDMkWm5tZxF2GjaIZp8Tgh33d/9ubCjC
MYrmj3XvCcGtfXz4oKYIX4SnVie/EILQZR6PNIuKUMj6/UTLACGoHqdvlZVR
hDnRrccV4oRAsuP7wuMJRbjJvEr4e44QcFk3JaSjivDnFlmBlO9CcNBPvSr4
QxEa5T55GNchBE+vp4VselOEhZafy3PFhCHJxPpWm2sRZrRtHjMwVhhaF47a
6eRQhFFll3fpagjDpDGBs7RvFKFjX/L3ZzrCsLZxg2DhuSJcmSdfNHKjMJxP
ac0/fawIh3kkmbtaCoOvh9Nbhb1FmHXBPog7LQwF5xdcjNpZhDtu3G7uuSMM
QluLjYw3FKGZ4GqjbDdh0Jp9XqXXsAh7HFN6YwOEwWTEhK7nS4tQeK/p5LR4
Ybj3Hb8unVOEjcZVLQ35whCFe9zL1Yrw/vqbbtPqheGni6DNpQmD17exb92V
PmGQsXljqDSmCDN/7F7cLCkCy9Yajo0VK8Jjyxc6XJgiAkfVfjXuGSjEgcC7
lyYvEAE3Afs4gbZCPB6Vvqh2lQiklc5w8qwvxNOOP1rQRAQ6wzL261cW4rCT
C8rCToiA6sOjS7/nFeKCmufqX26KwMaDo6VupBWixuS94h3PROCKQUitamwh
2jpbRuoEiMD7iVsiksMK8dD0GguvBBEo6eqw3+dfiBsSfPTUikRALNfFRMyj
EO1C+u8kNYjA/PeL57x1LsTZ898fvSIwDCxulYmsuleIQb8Epm+XGwYPzS4V
/7YrxCnGX/+tmTEMcMmk93dPF6LvbZMuE91h8Ec2/srMw4PXf+bp+QdbhoFi
k8XmDPNCNEgqCSo9OAwM00TUj2wvxF+cfJ7hlWFw8o1P76h1hah1PWVcltMw
8Li0MjNAvxAbg1rjT/sPg8ztfzyNFhXiStG5whA3DPrm3LdtnlWIM13fj51S
OAymjdRc9VilEMskJuqpNQ6DbXVZE+aOLcTUTbnhq4RE4XrcieZcyUI8cTw4
7L6iKAQ/l0k6KVKI55YvvNCkKQqVp8JdZHsLMMvk/AobQ1EYabTdOrypAKVy
NHbI7RaFxdN7dLb9LEDbse6NxTaisF/YbUxXaQHuHvi8HO1FwamCq3PJLkDP
C2M9EzxEISGy8uOilAIUjavT/x0pCk2P7R6UfCrA8UoD1nOyRGHC4Snm54ML
kF+23NStThRW/5c0f7xvAbpveW+qzicGZ5T3Df/8ogDVS/QCC+TEwLtXrHz3
kwL80TvR2WeWGOTm+wUO3C7AcMcTW58bioFA4Jrr7pcKcMH0SQuCTcRglv3f
bbonC9BqAl5qsBWDXZYPZ1QfKEDzHy4nVzmIwR2Yw3fVtABjjcL2pPuIQYRC
Xs7kLf//vjl3T8SKwfeWU94JqwrwfPZhHa5YDKQz5M9Z6hbglRHxSTNbxEDH
J2qtiHYB4r/0A8vEh4O13U5l7xkF2D7O6PR5leHwbGd/m6Hy4P1IyV1cyg2H
lPnuX+rkCrBq9VsBs23DoV1ymdttiQJseNeoOPL4cJj8u+boNMECNNW8l1Np
PxyMEq/rp3Xm48oO3fPFb4bDxZdT5Q815mPih+eWPTgc/M98+S1em48iuoJV
esXDoWjjQXxXlI9190J0QlqHwzANicdrv+Wj1+K0gtWjRsBc0Q9WfxPy8fIN
nW6JaSPArHr9IoeofHRT+tvboT8CHkQ3S8wOyMfl45zmjTAdAdFOT6qy3uRj
b1VJt+G5EVB/dH7o8Wf5uETL6PV7pxEgt6rwlvTDfFTRsrkDQSPAQOXszpAb
+ah5M1ikJ30EHB8Yq7n5fD7+O3vsRNWvEeBe9Emw/Vg+ouawGS3C4pAebFLg
tDcfH1Un39VUFoeee/x+2rvy8b2mUIsLJw5q+zwvFm7Ix3FnJD7NMhaHLcsM
Npz5Lx+/6C5c2WwrDlfH/VRR5PIxy7+2u+qJOAS03+qKmpOPZb22mgOB4lCe
OS3dWD0fraYeWLPymziM8Pvq3jshH0tP6IfG/xGHhdcP27iNyceLGl5fDw6X
ACsTyf+44fnoYPFf1zI1CXiyMGhsxUAeHg/m91ixXAJipTf9vdSWh4lTUzUu
W0jA34a2OKXfeXhaHUV/2knAuBRnp9jKPAy4MNX14isJWOmx8IBZfh6O3mi7
1jBGAmzPlywV/JqHj803PdKtkIA3Wy5IvY7Nw/GqrjnW/RKQrTnxu354Hi6Q
2n3l6/iRMDA8NuK7fx5qNLWM2L10JMz8bnb3hkceaq9rrlXeNRJ2oJDp1Kd5
+OrP/EtjL4yEWy5ec1Lu5WHaut9r/3MbCaEn/hu2/2oeRlvc/uL7aSTUrKkv
FjuThwNzKi11ykeCpNrd928P52GWj/xz8YGRwAlo2K2yyMMfR6O+j1QaBQdL
v23+sz0PXRoDPhnqjgKXsGPq99bl4Rrd9e7hZqMgyUG6b6ZBHkaa7Rhhcm0U
tBwIzcxYlIfbdgpd5LxGwSSDra+PaA6+/1HP6S0po2DtxC5bSdXBz59y8KJ3
/Sg43+W6KnBsHsqG8Ym5iEiCb86SiRuk8nBewtmdPXKSUPCuvLlZJA/1bor0
nVWXBKFbl5Me9+bi5++ZGvKLJUHLTNl1bnMuXs3MmZ+zWhJMliRY5/3MxV4o
2uG/WxLuyVrpnirLxezFF6s8j0pC1L9hMnI5uWjaMm90lJ0k1KX61oWn5OLJ
qtXz/j6RBMb/52LdwO/Het6SwPj+XOQXG3c6PFISGL+fi1nJKTNWfZUExufn
YoptQl9/uSQw/j4Xdeakaec0SQLj63PxyPEbailCUsD4+Vxc7eowoVxOChgf
n4uxrqf3y0yXAsa/52Lzy8TthzkpYHx7Lkpmd+v8MpICxq/noqbas2M3LKWA
8em5uGDNTFh+RgoYf56LXo7Qr3ZPChhfnoszxA4JzXolBYwfz8X1l3b6bAuV
AsaH5+LujAxdry9SwPjvXDwzykVdvlwKGN+di33t7yLfN0sB47cH75fOpDUH
ho0GxmfnYO2sGTqrxo0Gxl/n4KrpWv+MZo8Gxlfn4H6rxI8Xl48Gxk/nYIW3
n0C28WhgfHQOpk2pUVl9bDQw/jkHz5zwvtlwYzQwvjkHu5xO2Yc9Hw2MX85B
5cmyTt5Bo4HxyTnYfeapRGzKaGD8cQ56K5ttF6wYDYwvzsG9i2dVH24bDYwf
zkExEYXRQuLSwPjgHFR3eLYpXlkaGP+bg4ann8m+WygNjO/NwY8ZB5Ni10sD
43dz8K1Mbg7/PmlgfG4O+u6SDbC+JA2Mv83Bf3Zt6cLO0sD42hycdvvjq9T3
0sD42RxcLa/zKjpJGhgfm4MHFf/qlZZLA+Nfc9D53DeBaR3SwPjWwfeL39nm
NWoMMH41B71uHY01UhsDjE/NwZTYax9n6I4Bxp9m45a/l5K0d4wBxpdmY8iU
YvMTJ8YA40ezUeFvlmzl3THA+NBsVB9rY3HRawww/jMb13t65qyNGQOM78zG
FymTGoyKxwDjN7NRc4vT4lutY4DxmdkYLfV0VfNIGWD8ZTbGbw31c1CXAcZX
ZuP9n+f/mOvLAOMnszG97Ib7IRMZYHxkNr6puLDT76wMMP4xGx+dVgtXcpIB
xjdm4/K3x1ekB8oA4xezUTTQ9n1gugwwPjEbPfvtr2b8kgHGHw7+/KDhviki
ssD4wmwc9uJBf7CyLDB+MBtjgzzqL4AsMD4wGx1llXPsdsoC4/+y8ZPn+D3x
Z2SB8X3Z6NMzQUfHWRYYv5eN9krzJnSHyALj87KRfz2ff1O2LDD+LguDJ31+
PrVJFhhfl4Ux9Zu9no+SA8bPZaHhXssrRhpywPi4LEx+t+bX8jVywPi3LBx9
UOf5hUNywPi2LOw8tMa43V4OGL+WhXxnjtYH+skB49Oy8NzJl5KBaXLA+LMs
/FxT6Nz6Ww4YX5aFlwO01lwQlwfGj2Vhw/ZffKtnygPjw7Jwx5EjN/aslQfG
f2WhvfWFkM9H5IHxXVlo1zHJ0uKhPDB+KwsdjmWf3BgsD4zPGvz8/nPJd/Pk
gfFXWfit+gkn1SkPjK/Kwpr1GvFVigrA+KksXOkuojuwVAEYH5WFI1ufeR/Y
owCMf8rC4+uhfsp1BWB80+D3VVPjm+WrAIxfykLHXbdqb6crAOOTslA8zt1p
frMCMP4oC1sl8xXmyykC44syMd466eTtJYrA+KFM3G1pEjbbTBEYH5SJ0udb
f8+6pQiM/8nEiGVbpl9/rwiM78nE5fz197TyFIHxO5mY3BQ7e2GvIjA+JxPL
ZcMWuk4eC4y/ycQV/hfSt6waC4yvycQDi74oHD0xFhg/k4l5a3at//lsLDA+
JhMdCmf6fEoYC4x/ycQmvbO7WhvGAuNbMtF6Tn3gXblxwPiVTLzN5/fnpu44
YHxKJr5ou7fj58FxwPiTTCz8b+paf6dxwPiSweupaphYGDsOGD8y+POfxhqH
GsYB40MykW+mZPl+hfHA+I9MvGz5zyXbYDwwviMTMwxX53gfHw+M38hEnXv8
Ar9fjgfGZ2RiQLn7a7f08cD4i0xUDX6sE9szHhhfMXi9qnpmW6dNAMZPfMNt
GeC2Z/sEYHzENxR3OnC36tYEYPzDNzzrNSG7MGICML7hG4aa7ZRf8WsCMH7h
G7ZebJOcqzgRGJ/wDb8viTr5bNVEYPzBN4z+5i165cJEYHzBN6xsk3vy48NE
YPzAN9ya1lSfXj0RGB/wDQX/WduMG6EEDP//hn+/akeOUVEChvd/w7LWsKj1
oAQM38/ACR/O2mRtVwKG52egYkbpD2cbJWD4fQYuVp4g9+aBEjC8PgOF314d
1f1WCRg+n4HBV2wqnJOUgOHxGSjj8vTZpWolYPh7Bm6a07krqF8JGN6egafn
j1s+e+wkYPj64N9fO+tMn/YkYHh6BgbWTVSW3zwJGH6egRtGxx+zOz4JGF6e
gdvmdL5Y6jAJGD6ejjbh6T9Wvp8EDA9Pxw+eXnf9vk4Chn+no++EPcWmvycB
w7vTcWLzBaVDw5WB4dvpeHT4irAMdWVgeHY6enYJdN9eoQwMv05HvqsjjF7u
VwaGV6fjinkSapJ3lIHh0+k4TX5aS9lbZWB4dDqqn1DXGP5VGRj+nI4Xgrx2
OjUoE96cjspHdYdfGzWZ8OV0/O9NRmru7MmEJ39Fn+H2i+5smkz48Vec4re2
/43tZMKLv+LwgNh49WeTCR/+irP2P9KVw8mEB39Fhaf+2kdrJhP++xVl+Y8f
mS86hfDer3j9v9aPB2dOIXz3K06foNkttXEK4blfUenTCqnpZ6YQfvsV+eJT
myNeTiG89is+2VPl+ilpCuGzX/HcX3fJxY1TCI9Nw0nFelZzZFUIf03DOT2H
I304FcJb0/DD5lNz3PaqEL6ahhMWeYpJP1QhPDUNZ+efuyD+UYXw0zRsmyle
Zv9dhfDSNNSy07z6WFKV8NE0jJhUVaCyRJXw0DQ087q03mCfKuGfaej+XOVo
6xNVwjvT0PZxa/K8OFXCNwc//9HejhH/VAnPTMWX7W/8z0yYSvhlKmp6Fby+
smYq4ZWpuMDvrL/qhamET6biecWolwffTSU8MhVPrk06sLF8KuGPqWi1T2N4
1Sg1whtTUVB6sb3cMjXCF1Px1NmV4t02aoQnpuKvYzM/2fuoEX6YijJR1yu+
laoRXpiKzsYqyV+k1AkfTMU00SPF5w3VCQ9MHezfwx/9uaBO+N8X1PPwPj8u
VJ3wvi9oWfpygWSDOuF7XzDPf+y5NJVphOd9wUcbZSU2mEwj/O4Ldv848tXb
ZRrhdV9wRdMG/8zcaYTPfcHwE66hmZLTCY/7gm/nLhjmv2Y64W+Dv7/4Wb6V
/XTC276g8W7Zo8Kp0wlf+4IXwpdr3xWbQXjaF/z874z3wIoZhJ+l4OZZYzZZ
2M8gvCwFz15rq/ucPoPwsRSsCS2fNkZqJuFhKdg9L69j3+aZhH+l4PjxNwzj
XGcS3pWCne3e01WqZhK+lYJOs40zndQ0CM9KwbTeW+fHHdMg/CoF28x0Hn2M
0iC8KgV3WEg9OCM8i/CpFCwrsRTfaTSL8KgUzPpbgPtezCL8KRnrM6+fe/Nn
FuFNySijP1tOfIIm4UvJWJ2ke9x8uSbhScnodSK0xviIJuFHyXg6VvVB51NN
wouSUS5hmveSeE3Ch5JRUe2o9fRGTcKDknF4WYlWisJswn+S0Ujfc6vs8tmE
9yTjm2jzVQonZhO+k4xTTbTv5brPJjwnGX/HJ/mt+jab8JtkHHDfamDXP5vw
miT8IVc47LyGFuEzSVhv9yNgiYkW4TFJGPokTyLFQYvwlyQ87OLfMylei/CW
JAS/yXvXtmsRvpKEPd7PVhtNm0N4ShJ6h0tFaJjMIfwkCYW0RibWP5lDeEkS
bgi8/+J22hzCR5LQcuLvi6ME5xIekoQ77EM/XF48l/CPJDz15MntKpu5hHck
ovkCeZv5H+YSvpGI3Zm3vl+tn0t4RiIWSQaYZajOI/wiERXSnl1UtJhHeEUi
Bm7eUXzIYx7hE4kYsSlgSmrVPMIjEvHZ52QFbeX5hD8kov2vArsI8/mENySi
0YmkeRu95hO+kIjH8mPGiNfPJzxh8P2XMyTqNLQJP0jExqXGin9stAkvSEC1
nEhufLQ24QMJmOn64vZloQWEByRghuAj6bFrF9D8n4A/Unf0Nz1dQPN+Arp9
M7EZ/n0BzfcJ+NWc32e/1kKa5wc/v+dX9pgrC2l+T8CVE7fMk8paSPN6Al56
tFHGQnkRaPPm8wRsvNvxafTJRTSPJ2CY4N2Lyl8W0fydgMf+BPs+nbCY5u0E
7Dlx48nZk4tpvo7H1EmvHNPTF9M8HY8XfmgKOU9dQvNzPMrKNc8vtVtC83I8
7jKeetWjYgnNx/G41+Xm4r9Ll9I8HI/ajcofkt2W0vwbj3OTOLXZA0tp3o3H
2RrqvzXNOJpv4zHsrOC8r0kczbPxuHrvtUWiM4Hm13j8nBeoWv8EaF6Nx5/b
HynY9gPNp3FYv+egdPFcHZpH41Dl39JpGw/q0PwZh+Jbglb7eujQvBmHri/a
G8qLdWi+jMNrmxafbpfWpXkyDveNbV/VvEaX5sc41JSfhLm3dGlejMOnm23H
uSfowifefBiHrRvfe2zhXwZyvHkwDr+1+1/t5pbR/BeH1UIxNfcuLKN5Lw5r
jn8tHP1pGc13sTg5+NJ++75lNM/FYpThxbtdnB7Nb7E4kO8w1eSKHs1rsThe
OHPk5wQ9ms9i0X3rN0F5MX2ax2Kx+0ByyOG1+jR/xWJmPH6Mf6JP81YsbroV
4SZfqk/zVSw+PJr75fAUA5qnYlGcu/o02dqA5qdYNJR4t3JKhAHNS7G4Nb9c
9IbgcpqPYjH02OnqhnXLaR6KQauzpV93ui2n+ScGvSw9PHJ+L6d5JwZdp6cp
b1xsSPNNDI4s7fxbYm9I80wMnj3v++BwmSHNLzG4+e7J/SM0/6N5JQb17m9I
Crr6H+jx5pMY5G8t+mZR+B+48eaRGNz+9cmDSRoraP6IwV0PVzfWXVtB80YM
/ji5JziqdAXNFzHo8UD1mtO8lTRPIB5Zol9z7sFKmh8Q9SZM0jxQv5LmBcR7
wzd4mS5fRfMBouZyqV27PVfRPIDYt/fTcjP+1dT/I9Zpm2oeNF1N/f5nLKlc
GmsbsxrEef39Z1ycfOjsjUlrII7Xz3/GiM2nwhyvroFTvP79M1pL8Pt6/lhD
/fpnlFC5tvv9yrXUn3/Ge/1C0cEf1lI//gm/RJRfDJRZR/33JzQd/2TJm/Pr
qN/+hGfV/c3u1q6j/voTioSuHhukup766U8oOTu//onxeuqfP+Enx1uKDQ7r
qV/+hBHwRzIyaT084vXH0eg69YZSR+96+I/XD0cjn2jdzTdzjKCX1/9Go8Gh
pGNxB4yo341GrdAxbas8jKi/jUaV8VNldIqNqJ+Nxk/xxbHPR2+g/vUjaibG
F5is2kD96kcsM9mjdPPaBupPP2K46rYNkp83UD/6EXcsDZLq6thA/edHrHJS
+cdpbaR+8yOaaJhaVxzaCPK8/jIKj8/Y0VHgvREyeP1kFP6uf1evUrMR7Hj9
YxRqJrQ9SpqwifrFKHztMmt6+I5N1B9GYUKnSnmr0ybqB6MwOaE86XzOJur/
IvHC8lFNqyQ3U78Xicl2jttN1mym/i4S24LbG4PvbKZ+LhK9YqofLk/ZTP1b
JB6/GS0zRmQL1PH6tUj0zVXVVdDfAi94/VkE7s51zNhgtwU28fqxCFyZVXvo
U8wWEOX1XxGYIvEPNw9sgc+8fisCZa5q7ZHntoINr7+KwNx1eyv5L2ylfioC
nd00EkZGb6X+KRxj4kLvLO7ZSv1SOH6yMHt7bdE26o/CcdfOy49+nNlG/VA4
rhzf7Lcrchv1P+G4xqRm+4/ObXCY1++Eo3/yhe7zC7bDFF5/E44K617+HH96
OxTz+pkw1FF6ZJsYvh3u8/qXMHzrm9h3pGM76PP6lTDc5HYrTUF7B3Tz+pMw
fOEcr4mndlA/EoYjp4ac3xm2g/qPMPzU4N3f0LaD+o1Q9HAMFzk6z5j6i1B8
t/7Kj3IbY+onQlHqRXXT/BBj6h9C0Xpk4CWbFmNo5fULoZgWc6z+sdZOeMvr
D0IxZuOohw+P7QRTXj8Qgr+E7xfsD9gJY3jnfwjGxn2aqvB3J6TyzvsQvFX0
q+nZzF1wmXe+h6Dg+BvvGg/uIrw9BEVnFhVJvN1F53cIyvp59rf93EXndTBq
T0jw91TZTedzMEqsKrgobb6bzuNgtE/OVVjmvpvO32C8/th75oyy3XTeBuOR
K3EnMxRMQJN3vgZjwpKASJUtJlDLO0+DkPv8Il3jkQk8552fQRg+8P3Rj3QT
WM87L4Nwd7V+72shUxDlnY9BeHxqSd80ZVPCS4NQ8M/Y3KtgCja88y8IDbae
En+/05TOu0D8/Et+ic8ZU6jknW+BKNE/he+YkymdZ4HYZ13RJxJsCv/xzq9A
fLWuvHrfN1M6rwKxHedYOv42hRDe+RSIJwId9eyH7YFDvPMoECXD7QxWTN4D
SrzzJwAVE80XZ3B7oJB33gTgqJq3/fI79sBd3vkSgHWpjcfUTu4Bfd55EoA5
JwSv9DzYQ+dHAD6/OWrSw7d7IIB3XgSgR/yL9XUJe+h8+IALDQPl+Cr2gCbv
PPiAq3KSbxZ07qH6/wHvD/z5aD3aDER59f495h78WBg73QxO8+r7e9zXaiqe
o28Glbx6/h7PNL+4777LDNbz6vc7zHiY7K5+ygwiePX6HS4zjLhnfd8M1Hj1
+R3eO5Hle9DLDBx49dgf8+H3hsmfzYBP8P/11x8LYg3/Pc4zo3rrj52n7Jqj
/5hBIa+++uFo1Qs5boLmVE/9UGLhStn5iubgw6uffogvxxhe1zSnevkWP60V
7rmz3Bwu8+rjW5xhrZq5fKc5/OPVw7d4ykDfOuKYOWzj1T9fXCPx9UrFDXNI
4dU7Xxzm6pP48Zk5aPLqmy8Gyo7vWh1gDu68euaDfNlutY8SzKl++eDYRd7b
7hWaw2levfLB+eMfz1zyx5zqkze6GRzSezlgDv/x6pE3utyKuRI22oLqjzeq
mRwruKJiAUq8euONC5SuLuJfYAEOvPrihaEt9d5zV1pAJ6+eeGGvo/HkcTst
YB+vfnihkKBUeLi1BWTy6sUbLFB6dmLYJQvQ4dWHN7j6sveREQ4W4MOrB29w
76rU5Hh3C5Dn7f/XmG+7/IVmoAXt99f4clOe4oZYC/jH29+vMeGW9QG1LAva
z5641UUMgystIIa3fz1xlvjhda1/LWi/emLckr9b6vst4Clvf3pgfMd8GScJ
S9qPHljeJJbRMdYSjvL2nwdaz5T4MmqaJe23V+hoZm9Urm1J++sVbjq/KMzc
wBIiePvpFaos5V/hvsGS9o873hn3afcTE0tw4O0Xd6w7LLpO55Al7Q93FKzj
s3l92hIyefvhJU6+NXJa7DVLWv8vUUXQ75uTw+D18Nb7C5waoJ6o8tyS1rcb
Fo26fOiw9+Df461nN6xvH6l+LMiS1u9z3Lr/kInGp8HP563XZ5impXHSK9kS
Anjr8xk+MwzNLMqypPXoihu6ugpTSizBlLf+XFBabHvbie+WtN5c0P7Vnnsl
jZYgyVtfT9FL97UoX6clrSdnPOFul1HFZwUBvPXjjNMf8S2/ImZF68UJm9sc
88qlrMCUtz6csCGIv6ZbwYrWgyMuThufkzfJCiR5z/8JnrkTInZU3Yqe9xNc
n7fl1xdNK3q+jzHuxZycGm0rcOc9z0cYc/Of6mfOip7fI/zuf3XZdgMrWM97
Xg+x981Iu9BVVvR8HPBUVBTkGFkBn8L/n4cDPlvjlBO01Yru/wMsunbi8aZd
g9fHu9/38Pq0lOwIMyu6v3fxRcb96oq9g+/n3U97XDJVXSr1kBXdv9s4PEjv
re2xwffz7tctdHeOaq87OXj9vPtzE99nXVoy4ezQ/biBr5/YfZa7OHh9vO9/
DSf1OUfnXRn6vlfRnd/yxLbrVnCZ9/3scIvPinHut4a+z2V0uLKmwd9+8Oe8
67+E2lYSCpfuD13veXQ5+zZD9uHg9+Fd3xmssYlaaPN46HpsB/vRhXbOjoPv
5/19G1Rcd+7rZeehv3cc93goL9R0Gfr8I2itKv39jevga97n7UfphP2/qp4N
/b4FZky0Ma59Pvj69P/fb4LXg31Xv3Mb+vkmfKXulbrkxeBrr/+/1kffrikV
j/7/mv5lGfQ/+DD4muEB+jD0c/Z6E3jQ77PnZQJDn89+bgHf6O+zfnI/jKHr
Y+8/AkPXz+bN4zD0/djv28DQ92f10BaG7g/7vDMwdP8YXn0enOn+ss+/BIvo
/rN57jLco+fD/p4dbKTnx/qNqzD0fNnfvwZDz5/1YzdgaH2w67kJfrR+GF54
C17Q+mLXdxuG1h/r5+1hEa1Pdr13YWj9snnnHgytb1r/MLT+Wb1ygKe0P9j3
cYCh/cPm5YfQTfuLfb9HMLT/GJ7wCIb2J/u+j2Fo/7J+7Qmspf3Nvv8TGNr/
rJ90hEVUH9j9cIJGqh8Mr3OCofrC7o8zqFP9ofoER6k+sfv1FN5Q/WLzggvc
ovrG7p8LSFH9Y3i4KwzVR3Y/n8Fzqp9s3noGX6i+svv7HIbqL5sH3eAX1Wd2
v91gqH4zvukFDNV3qv8wVP9Zv/QSlOh8oPMD+On8YPO+O/yg84U9H3cYOn8Y
HvEKJtP5xJ7XKxg6vxhe8goe0fnGnp8HHKLzj+E5HlBM5yN7nh4QS+cnw5s8
IYbOV/Z8PWEmnb90PsMmOp/Z834NQ+c3w+tew3M639nzfw15dP4zPPENmFN/
wNbDG1hL/QObR95AHvUXbH14wVD/wfBYL+im/oStFy8Y6l8YXuwN86i/of4H
VKn/YfOaNzhRf0T9Ezyj/onh7T6gRf0VW18+oED9F+MDfKA/i/VnbL35wlD/
xuZZXxCk/o6tP19YTf3fX9Yfgg31h2w9voXp1D8yvuctfKT+kq1PPxjqP6k/
heHUn7L16geS1L/uZ/0ttFJ/y9avP+RT/8v4PH/Iof6Yred3cJf6Z4aHvAOg
/pqt73eQTv13DevP4RT152y9v4e91L8zvvY9ZFJ/T/0/3KX+n+FFHwb7LjYf
0PwAC2h+YHhUALjRfEHzB7jS/MHwrgD4RvMJ2y8B8JPmF4anBYA4zTds/wSA
PM0/DK8LBHGaj9h+CoRjND/RfAXNNF+x/RUI7jR/0XwGXTSfsf02+Hk0v9F8
Bx9pvmP7Lwj0aP5jeGkQDPxm8yHbj0FwlOZHhscGgTHNl2x/BkEozZ8M7w0C
bZpP2X4NHtyvbH6l+Rb20nxL8y9cofmX5mO4RvMxzc8gSvMzzdegSfM1zd8g
RfM3w9tDQIDmc7bfQ4Cf5neG54fAJZrv2f4PgaH5n/EFIVBF+ACrB6EQTfgB
4yNCIZHwBcIfYD/hD4RPwAjCJwi/AG/CLwjfAFfCNwj/gAjCPwgfATHCR1g9
CQNXwk8YHxQGqwlfYfUlDLwJf2F8UxgsInyG1ZtwGEP4DeOzwuE14TuE/8BK
wn8IHwIDwocIP4JthB8RvgTBhC8R/gTRhD8RPgX3CZ9i9SoCsgi/YnxiBEgQ
vsXqVwTEEv7F+MoIWEb4GKtnEbCD8DPGh0bCK8LXCH+Do4S/ET4HLwmfI/wO
mgi/I3wPPhG+R/gfnCT8j/BBiCF8kNXDKIgl/HAhwxfhOeGLrD5GwUzCHxnf
HQU1hE+yehkFhwm/3MPwTdhO+Cbhn1BC+Cfho7CB8FHCTyGQ8FPCVyGf8FXC
X0Gd8FfCZyGU8FlWb6NBifDbYIbvwgzCd1n9jYZlhP8yvUQ0dA5j+DCrx9Hw
hPDjEoYvQwDhy4Q/QwThz4RPw3DCpwm/BgHCrwnfhv2EbxP+DUaEfxM+DpGE
j7N6/hluEH4+k+HrMDCF4eusvn8GK8Lfmd7mM/gSPs/q/WeYS/j9Zobvw1fC
9wn/hwrC/4kfgEbiB4g/AFXiD4hfgMvELxD/AEuJfyB+YrCOMH6C+AtwJf6C
+A3IJ36D+A/YRvwH8SNgQPwI8SfQ2sL4E+JXQJv4FeJfYCXxL8TPwEHiZ4i/
AUHib4jfgXvE7xD/A0+J/yF+CDYRP0T8EfgSf0T8EugRv0T8E3DEPxE/Bd1L
GT9F/BXcIf6K+C0wIH6L+C9IIv6L+DH4TfwY8WfgTPwZ8WsgRfwa8W/QQfwb
8XPwlvg54u9gLPF3xO9BHvF7xP9BMfF/xA9CLPGDxB9CA/GHxC/CXeIXiX8E
deIfiZ+E3cRPEn8JZ4i/JH4T7hG/SfwnCBH/SfwoyBA/SvwpVBB/SvwqZBG/
SvwrhBD/SvwscMTPEn8L/sTfEr8LE4nfJf4XVIn/JX4YphI/TPwxbCP+mPhl
0CN+mfhnkCD+mfhpsCJ+mvhriCL+mvht+En8NvHfsJ/4b+LHwZv4ceLPoZz4
c+LXwZr4deLfYTHx78TPw1ji54m/hzji74nfh3vE7xP/D2XE/5M+AD6TPoD0
A5BG+gHSF4As6QtIfwDfSX9A+gQ4RfoE0i+AJekXSN8AQPoG0j/AedI/kD4C
HpI+gvQTEEz6CdJXwCvSV5D+AkRJf0H6DIgnfQbpN6CJ9Buk74D1pO8g/Qcc
Jf0H6UPgP9KHkH4EdpJ+hPQlYED6EtKfgADpT0ifAq6kTyH9CjSTfoX0LaBN
+hbSv4AF6V9IHwNvSB9D+hn4RfoZ0tdAMelrSH8DraS/IX0O5JI+h/Q7MJH0
O6Tvgeek7yH9Dywn/Q/pg6C9lOmDSD8E4qQfIn0RiJG+iPRHcIL0R6RPgmek
TyL9EhSQfon0TTCgx/RNpH+CGtI/kT4K3pI+ivRTkEn6KdJXAUf6KtJfQQ3p
r0ifBUGkzyL9FtiTfov0XfCD9F2k/4Ih/Rfpw6CW9GGkH4Ny0o+RvgxMSF9G
+jPYRfoz0qfBO9KnkX4NbEm/Rvo2MCB9G+nfoJP0b6SPA2/Sx5F+DvxIP0f6
OphH+jrS38Fv0t+RPg/Okz6P9HuQTvo90vfBf6TvI/0fcKT/Gyji6QMBSR9I
+kH4QvrBFUxfCOdIX8j6w1SQI/0h6RPhH+kTWb+YCpakXyR9I9SPZvpG0j+C
OekfSR8JG0kfSfpJOEX6SdJXghrpK0l/CRqkvyR9JtwhfSbrN9NgSL9J+k7Y
Q/pO0n/CC9J/GjF9KFiRPpT0o+BL+lHSl4IG6UtJfwoNpD8lfSqMJn0q6VdB
jfSrpG8FB9K3kv4V5pH+9QzTx8II0seSfhZsST8bz/S1cJ30tay//QqNcUx/
S/pcGEv6XNbvDr4m/S7pe+Ey6XtJ/wvDSP9L+mDod2b6YNIPw2zSD5O+GIaR
vpj0x7CI9MekTwYX0iezfjkdVpB+mfTNMIr0zaR/BlvSP6cxfTSMJ3006adB
k/TTpK+GIX016a9BkPTXpM8GR9Jnk34bzEm/TfpukCN9N+m/4T3pv1uYPhwC
SB9O+nEY0o8vZfpy0CV9OevPM8CE9OekTwdf0qezfj0DxpJ+nfTtcJL07aR/
h12kfyd9PPQ+Zfp40s/DK9LPk74e/voyfT3p70Gf9Pekzwd+0uezfj8DJpJ+
n/T9kEv6ftL/w0/S/xswfwD0/WX+APIPgAH5Bx4wfwFUkL+A/AcQTv4D8idA
HPkTyL8AgpeYf4H8DXCK/A3kf4Cb5H8gfwQMODJ/BPknwJD8E+SvgL3kryD/
BSwl/wX5M8CJ/Bnk34BJ5N8gfwcg+TvI/wEHyf9B/hBInsH8IWweyYQU8o+Q
vwRGkL+EzSeZUET+E/KnwBHyp5B/BS6Rf4X8LbCC/C3kf4Eh/wv5Y+A8+WPI
PwOu5J8hfw2Ykb+G/DewhPw3vsyfA0/In0P+HRjy76xj/h6YQP4e8v/AkP+H
/EHw+xzzB5F/CLaTf4j8RXCO/EXkPwIxKeY/In8SSJI/ifxLcIT8S+RvAiHy
N5H/CfaR/4n8URDdwvxR5J+CXeSfIn8VvCV/FfmvIIj8V+TPgj3kzyL/Fpwj
/xb5u8CY/F3k/wIL8n+RPwwWkD+M/GPwjfxj5C+Dc+QvI/8ZOJL/jPxpoEP+
NPKvQcVp5l8jfxsEkb+N/G/Qe4D538gfBx7kjyP/HKiRf478dXCd/HXkv4NX
5L8jfx78XMf8eeTfg4vk3yN/H3iTv4/8f/CA/H/kD4Tt5A9k82A2uJB/kPyF
UOfG/IVsPsyGkgPMf0j+RLhK/kTyLwI/+RfJ3whTyN9I/ke4RP5H8kfCFfJH
kn8SAsk/Sf5KuEz+SvJfwkvyX5I/E66TP5P8m9C9mfk3yd8JO8jfSf5PmEn+
T/KHwh9F5g8l/yh8b2T+UfKXwjXyl5L/FPTIf0r+VPAjfyr5V+Ey+VfJ3wqr
yN9K/lc4Rv5X8sfCbPLHkn8WlpB/lvy10H2L+WvJfwuJ5L8lfy6cI38u+Xfh
Ivl3yd8LN8jfS/5fmE3+X/IHQ8sD5g8m/zBkCTP/MPmLwZD8xeQ/hrPkPyZ/
MsSRP5n8y9CuzPzL15m/GV6Sv5n8z6BF/mfyR4Mz+aPJPw0+5J8mfzUsI381
+a9hLvmvyZ8NnuTPJv82DCf/Nvm74Sf5u8n/Dbrk/yZ/ODSkM384+cdBhPzj
5C+HXlHmL2fzeS5sJP85+dOhfzXzp5N/Hf5MZf518rdDQBbzt5P/HRLI/07+
eDhH/njyz0OnC/PPk78eNpC/nvz3MJL89+TPhy3kzyf/Ptwm/z75++G1KPP3
yzL/Pzwg//8vlg8AKpQP8JHlB8Acyg+4z/IF4C7lCzA9YS5EUP7AHJZPAPMp
n0CY5RfAPsovKGT5BjCW8g2YPjEPGuJZ/sEFlo8AsaEsH2Edy0+AM5SfoMzy
FeDoQ5avwPSOeRBuzPIXklk+A0ylfAZXlt8AgTosv+EQy3eAzgaW7wAs/wG2
U/6DFMuHACHKh6hl+RFgRPkRYSxfAvZQvsRtlj8BhWtZ/oQxy6eAgt8sn0KD
5VfA87Usv4JvBC/fAq7/Y/kWOSz/Ak5LsvwLL5aPATdUWD7GaZafAVMpP2MV
y9eAxxtYvsZ4lr8BUyl/4x/L54A4NZbPEcfyO6BFleV3OLJ8D6gKYvkee1n+
B6SZs/yPRSwfBDJmsnwQcZYfApspP6SC5YvAUVWWLxLE8kdgHeWPXGP5JKBL
+SRbWX4JTKP8EnWWbwJHT7N8k16WfwLNs1j+SQbLR4GcKpaP8orlp0DSLJaf
coLlq4A95assZ/krsPMGy1+RZ/ksMG82y2f5zfJb4Npslt/yieW7wEbKd2F6
qXw4OZblv1A+DLRPZPkw81h+DBRdZ/kxoixfBloXsXwZpgfOByPKn3nH8mnA
Wofl01xi+TXQ8J7l12xg+TZQ2s7ybZi+uAC8ZrH8mw6WjwPTKR/nC8vPgUOU
n/Oc5etAdzLL12F65QLQo/wdXZbPAxMon2cMy+8Bt+Esv+cHy/eBhiyW7xPJ
8n8gKJvl/9izfCCYRflAu1l+EER8Z/lBmixfCCQpX0iQ5Q/Bh2ksfyiP5RPB
SMon8mH5RaBG+UVnWb4ReBezfKM1LP8IhCn/SInlI4G+DMtHamb5SfBiIstP
SmT5SnApluUrObP8JRCl/KUDLJ8JfvezfKYlLL8JGhVZftMolu8Esdks36mK
5T/BGsp/CmH5UOBvwPKhbrD8KJCn/KjtLF8KhlO+1AyWPwW6lD/Vz/KpINiF
5VNRfhXYDWP5VZ4s3wp2UL7VKZZ/Beevsfyr/1g+FhyjfKyxLD8L/BNZflYD
y9cCccrXimH5W1B7i+VvPWL5XPBwB8vnsmT5XTCO8ru0Wb4XHJjH8r2Gs/wv
KAtm+V+lLB8MuuJZPtgHlh8GbdNYfpgdyxeDn04sX4zp+QvhkzLLH5vK8sng
dDXLJ+ti+WVgYMPyy76yfDNQp3wz5g8ohHuRLP/sGMtHg5eUj6bH8tNgLOWn
ybJ8NdCmfDXmNyiCgA0sf+0jy2cDGcpnu8/y28CB8ttMWb4bPP1fS3caXGV5
xmFcqqjFijBSqI40EJhIbI3WXQq5QGukRWWIsUVQDBZhgNSytBVwwQFcABXQ
EakidUFEnIILYgFhAGVJy6bgMqCsR1IUrKBTDUOhGa7/x+fbmfd8ed+5n/v6
DbDvlv4by9J/a2wfjr0/sA/3if04hj9gP26ufTkGpC93r/05/vi8/bke9ul4
fYt9umL7daw4Yr8ufTu++9S+3Rr7d5Smf/e0fbyG71H7eDX281i62X5e+nrM
SF+vuf092qa/V7DPxxPp8y2030dNjf2+Cfb9ODt9vz72/xrew+z/ldkHpCx9
wPQDaZt+4Gb7glTX2xecbX+QQefYHxxpn5D70ydMv5AW6Re2tm/IRekbeh97
KzWL7R+utI9I/bf2EZ+0n0ivu+0nDrSvyL459hU72l/k9o32F9NnpEv6jDvs
N7K0qf3G1+07ck36juPtP7LiI/uP6UNyU/qQpfYjmXSd/cgj9iVpnr6k+zhb
G96P7U+mT8ldre1TjrBfyYTp9isr7Fuytc6+pffVt9Ih/csv7WOyYpJ9zKX2
M5nQ037mFPuaXJW+ZvqbdEl/81L7nHRPn/NU+50c/dx+51b7nvxjrH3P9D85
1Mf+5xj7oPRIH7TSfiiFsfZD29sXZd3F9kW/sz/KdemP1tonZdm39kln2C/l
/PRL0zflX2Psm3a1f8qqdvZPW9hHZe9w+6h77adycvqp6auy5SX7qpPsr1KU
/mpf+6xcnj7rhfZbeXmk/dYT7bty9DL7rh/af2X3s/Zf59iH5XCVfdj0Y+mQ
fuz19mXZtce+bBv7syw8Yn/2kH1ahqRPm34t72+xX/uUfVuGpm872P4t+4rs
33ayj8uqevu4Z9jP5Z70c3fZ12Vc+roL7O9y19f2d9PnpSh93pvt9/LEjfZ7
f2bfl0J/+75H7f9Skv5v+sD8OH3gF+0HMzD94L/YF6Zb+sLu031Kl/SH0yfm
f2X2iQ/YL2bjKfaLl9s3piJ9Y/fzPmXQk/aP00fm2vSRr7CfTIf0k5vYV+bB
xvaV01/mF+kvz7fPzGnpM4+138yg9Jur7Dtzb/rO6T8zOv3nevvQrC6yD73O
fjTnpR890740ZelLpz/NmFPtT19tn5qO6VO3tF/NCXfYr07fmmbpWy+xf83h
evvXj9nH5vsT7GNX289mfGf72elr88oz9rUb29/mvPS3P7HPTaP0uefa72b6
Xvvd6XtTnb53D/vfrH3O/nexfXA6pg+efjiffW4/fI19cUalL/60/XEqi+2P
19gnZ8du++Tpl7PmoP3y5vbN6Zq+ecH+OW3TP19oH50H00dPPx3es5/ex746
bw+wr15mf53pZfbXT3jleJ+dk9Jn32y/nTk97bfPtu/Or9J3d79pO386dvHx
/nv68OxJH761/Xg2n2s//mv78pyevrz7sNvplf58+vT0r7RPP9B+Pb9Jv76j
fXsWpW/vfm3D703/Pn18Zv/SPv4b9vNpmn7+ePv6vNfcvn76+1yU/n6pfX4e
Sp//iP1+zk2/f4N9f/6Zvn/6//w2/f8R+gC0jg9QoR9AXYV+wE/0Bfg4vkD8
AXrEH1iqT0Ddw/oEU/QLuPoB/YL4Biyv0De4VP+A2tb6B6fqIzA3PsJW/QSe
PKCfEF+BA/EVxugvMKWp/kKlPgOr/qrP0F6/gTfX6zfEd6A0vkOt/gOvP6z/
MEMfgvbxIe7Uj2DgOv2IrvoSDI4v0UJ/go5v6E/s1adgQnyK+BV0iF+xWt+C
Zyr1LebrX9Aj/kV8DN5tp48RP4MVt+pnxNdgRnyNKv0NRm3S3+isz8GO+Bzx
O6j8Qr+jmb4Ho+N71Ot/MDb+R3wQJsYHWacfwpAW+iFv6YuwLL5I/BFe+b3+
SHwSquKTxC9hdvyS3vomLIlv4vxkJ58N0T+Jj8Ke+Cgt9VO4Mn7KMX0VGsVX
ib9Cv/grH+izUFOhz7JEv4W+zfRb4rtwS3yX+C+UxH+JD0O/+DDV+jEcKtaP
+bW+DMPjy8SfYfGj+jPn6NPwzXp9msb6NdwSvya+DSvj27jv2fD/DtO/WaGP
w3fxceLnsDN+Tnwd7o6vE3+H/zysvzNAn4fX4vM479nJhnn6PfF96BDfp1j/
h2HX6/+cpg/E4cv0geIH0Sh+UHwhxscXWqM/xJ11+kOv6RNR1VafKH4RbeMX
xTfiym36Ru7D7uKU+Ec36SPxSHyk+EmcGT+pg74SneIrNddf4ub4S/GZOCM+
U/wmxsVviu/E3PhOC/WfGLJJ/yk+FJ3b60PFj2Lft/pRw/WlGBtfqo/+FC3i
T8WnojQ+VZl+FbPiV7XSt2JTfKv4VxTFv4qPxYT4WPGzuKKdftY7+lqUxteK
v0Wj+FvxuRhR0Ocaqd9F1/hd/fS92BffK/4X6zvpf12iD8YXD+mDtdYP4774
YfHFeD++WPwxaiv0x+KT0f0tfbKV+mV8/JR+WXwzhsY3i3/G0Phn9+mj8XJ8
tIH6adTN00+Lr0bv+God9de4M/5aO3021sZni9/Gg/Hb4rtxe3y3+G8Mjv+2
Vh+Oovhw8eO4Jn5cfDmK4suN159jcvy5P+jTMSw+Xfw6lv9bv66Lvh2749uV
6t+xKf5dfDyeio8XP48PTtHPi6/HPfH1NujvsegF/b34fAyIzxe/jzbx+ybq
+9E3vt8I/T+ax/+LD8it8QEr9APpfbp+4AX6guyILxh/kLr4g/EJeS4+YfxC
lscv3KJvSJup+obOD3fzo/iH8RE5s0QfcYp+ImfFTxylr8iL8RXjLzIw/uJ1
+owMmaPPGL+REfEbf6rvSJNF+o7xH7nmbf3H+JCsiA+5VT+SYdX6ke/qS/JO
fMn4k+wq1p+cpk/Jq/Epx+hX0i1+ZXxLLoxvWal/yQ3xL+Nj8kZ8zPb6mVwb
PzO+Jk336GvG32Ro/M2d+pxcEJ+zVr+T6vid8T15Nr6n/YSG5x//8wF9UDbG
B40fStE0/dBe+qL8/UZ90fijjPud/uh5+qS0W6lPGr+U7fFL45ty+cn6pnv1
T1ka/3SjPir946PGT6VP/NQX9FX5Mr7qJP1V1sZfjc9KWXzWvvqtbOul3xrf
lYpafVf31fdwYvzX+LBwrj5s/FjOjx+7X1+WafFlP9SfpST+bHxadsennaNf
y4oe+rVT9W1pGd82/i1d49/218eluqU+bvxcJsbPvUxfl9HxdePvMjL+bnxe
6uLzHtLvpVv83m36vkyK7xv/lx3xf+fpA9MzPnD8YKbGD44vzP74woP1h9kb
fzg+MRVH9Ik76RczNX5xfGO6btc3jn/Mn+Mff6+PzPyJ+si79JPZED85vjJn
r9ZXXqC/zPT4y/GZeTQ+c/xmmsZvju/MwvjO8Z/5Yfznq/ShKf9KHzp+NM1K
9KPjS3NbfOmj+tP0iz9dp0/N2vjU8avZFr96sb41xehbx7+mPP71I/rYfB8f
O342M+Nnx9emVXztbvrbvBN/Oz433Yfqc8fvpmP87pP0vbmwlb73Af1v7on/
HR+cq+brgy/XD6cifnh8ceriiz+uP05J/PH45OyITx6/nM8W6pffoG9O4VV9
c+fnBVrFP4+Pzv3x0Zvop7PqTf30b/TVabJfXz3+Ol+dqL++Wp+d8r/ps8dv
53D89un67hQf03eP/84zLfTf48Nzd3z4Kv14zoof31lfnlnx5ePPMzP+fDN9
evbHp6/Xr+fgAf36+PZMnqxvv+74/L4ApW9/NX7ywfIFbX7w/GlPF3hu1Lbb
PnrsYPnM4/P8ArePq57VueH8UEX1+sGzCgyaPHfJ4kcPljvfL/BB+0teur7h
3LtmWX3tvAJ9mj5W/d9HDpZffXzeX6B91W0HFjScf/74OSWliwpMK7+j+4SG
s/f/CxzrOWL0iIbz/wG/9Y0I
        "], $CellContext`WPLTPAH[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`aa, 
          Blank[]], 
         Pattern[$CellContext`bb, 
          Blank[]]] := 
       Sqrt[($CellContext`AA + $CellContext`BB (($CellContext`HH^2 \
$CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + $CellContext`LL^2 \
$CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2)) ($CellContext`aa $CellContext`L + $CellContext`bb \
$CellContext`L^2)], $CellContext`WPLTWILK[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`\[Rho], 
          Blank[]], 
         Pattern[$CellContext`RRe, 
          Blank[]], 
         Pattern[$CellContext`bu, 
          Blank[]]] := 
       Sqrt[($CellContext`AA + $CellContext`BB (($CellContext`HH^2 \
$CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + $CellContext`LL^2 \
$CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2)) (($CellContext`bu^2/(4 
           Pi)) $CellContext`\[Rho] $CellContext`L^2 
          If[$CellContext`L == 0, 0, 
            $CellContext`FWILK[$CellContext`L, $CellContext`RRe]])]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.832149536922423*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"835ff0d2-e902-4ade-8c0c-8424f3a3bdce"]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`aa$$ = 0.0005, $CellContext`AA$$ = 
    0.3, $CellContext`bb$$ = 
    0.0001, $CellContext`BB$$ = -0.5, $CellContext`clp$$ = 
    0.286, $CellContext`h$$ = 1, $CellContext`hwhm$$ = 0.1, $CellContext`k$$ =
     0, $CellContext`kMag$$ = 1., $CellContext`l$$ = 
    0, $CellContext`lambda$$ = 0.154, $CellContext`model$$ = 
    "Popa-Adler-Houska", $CellContext`RRe$$ = 2.98, $CellContext`structure$$ =
     "bcc iron", $CellContext`xMag$$ = 1., $CellContext`\[Eta]$$ = 
    0.5, $CellContext`\[Theta]\[Theta]$$ = 45., $CellContext`\[Rho]$$ = 0.005,
     Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Text[
        Style["Pseudo-Voigt function", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Eta]$$], 0.5, "mixing param."}, 0., 1.}, {{
       Hold[$CellContext`hwhm$$], 0.1, "hwhm"}, 0.001, 2.}, {
      Hold[
       Grid[{{
          Manipulate`Place[1]}, {
          Manipulate`Place[2], "\[Degree]2\[Theta]"}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`model$$], "Popa-Adler-Houska", 
       "Microstrain model"}, {"Popa-Adler-Houska", "Krivoglaz-Wilkens"}}, {{
       Hold[$CellContext`structure$$], "bcc iron"}, {
      "bcc iron", "fluorite", "free input"}}, {{
       Hold[$CellContext`clp$$], 0.286, ""}, 0.1, 1.}, {{
       Hold[$CellContext`AA$$], 0.3, ""}, 0., 1.}, {{
       Hold[$CellContext`BB$$], -0.5, ""}, -1., 1.}, {{
       Hold[$CellContext`aa$$], 0.0005, ""}, 1.*^-7, 0.005}, {{
       Hold[$CellContext`bb$$], 0.0001, ""}, 2.*^-7, 0.002}, {{
       Hold[$CellContext`\[Rho]$$], 0.0101, ""}, 1.*^-7, 0.11}, {{
       Hold[$CellContext`RRe$$], 2.98, ""}, 0.1, 100}, {
      Hold[
       Grid[{{"cubic a", 
          Manipulate`Place[3], "nm"}, {"A      ", 
          Manipulate`Place[4], ""}, {"B      ", 
          Manipulate`Place[5], ""}, {"\[Alpha]      ", 
          Manipulate`Place[6], ""}, {"\[Beta]      ", 
          Manipulate`Place[7], ""}, {"\[Rho]       ", 
          Manipulate`Place[8], ""}, {"RRe     ", 
          Manipulate`Place[9], ""}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Theta]\[Theta]$$], 45., ""}, 1., 179.}, {{
       Hold[$CellContext`lambda$$], 0.154, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`h$$], 1, ""}, 1, 10, 1}, {{
       Hold[$CellContext`k$$], 0, ""}, 0, 10, 1}, {{
       Hold[$CellContext`l$$], 0, ""}, 0, 10, 1}, {
      Hold[
       Grid[{{"peak position ", 
          Manipulate`Place[10], "\[Degree]2\[Theta]"}, {"wavelength    ", 
          Manipulate`Place[11], "nm"}, {"Miller index h", 
          Manipulate`Place[12]}, {"Miller index k", 
          Manipulate`Place[13]}, {"Miller index l", 
          Manipulate`Place[14]}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Zoom factors", 16]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1.}, 0.1, 10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1.}, 0.1, 10., 0.1}, {
      Hold[
       Grid[{{
          Manipulate`Place[15]}, {
          Manipulate`Place[16]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1009., {330., 336.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`aa$$ = 0.0005, $CellContext`AA$$ = 
        0.3, $CellContext`bb$$ = 
        0.0001, $CellContext`BB$$ = -0.5, $CellContext`clp$$ = 
        0.286, $CellContext`h$$ = 1, $CellContext`hwhm$$ = 
        0.1, $CellContext`k$$ = 0, $CellContext`kMag$$ = 1., $CellContext`l$$ = 
        0, $CellContext`lambda$$ = 0.154, $CellContext`model$$ = 
        "Popa-Adler-Houska", $CellContext`RRe$$ = 
        2.98, $CellContext`structure$$ = "bcc iron", $CellContext`xMag$$ = 
        1., $CellContext`\[Eta]$$ = 0.5, $CellContext`\[Theta]\[Theta]$$ = 
        45., $CellContext`\[Rho]$$ = 0.0101}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`n$, $CellContext`x1$, $CellContext`x2$, \
$CellContext`deltax$, $CellContext`k1$, $CellContext`k2$, \
$CellContext`deltak$, $CellContext`grid$, $CellContext`samples1$, \
$CellContext`samples2$, $CellContext`samples3$, $CellContext`g1$, \
$CellContext`g2$, $CellContext`g3$, $CellContext`l1$, $CellContext`l2t$, \
$CellContext`l2$, $CellContext`l3$}, $CellContext`n$ = 
          2048; $CellContext`deltak$ = 
          400/$CellContext`n$; $CellContext`k1$ = (-($CellContext`n$/
             2)) $CellContext`deltak$; $CellContext`k2$ = $CellContext`k1$ + \
$CellContext`n$ $CellContext`deltak$; $CellContext`grid$ = 
          Range[$CellContext`k1$, $CellContext`k2$, $CellContext`deltak$]; \
$CellContext`samples1$ = 
          Map[$CellContext`FTPVoigt[#, $CellContext`\[Eta]$$, \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$] \
$CellContext`hwhm$$]& , $CellContext`grid$]; 
         Which[$CellContext`structure$$ == 
           "bcc iron", {$CellContext`clp$$ = 0.286, $CellContext`AA$$ = 
            0.3, $CellContext`BB$$ = -0.5, $CellContext`\[Rho]$$ = 
            0.005, $CellContext`RRe$$ = 2.98}, $CellContext`structure$$ == 
           "fluorite", {$CellContext`clp$$ = 0.54616, $CellContext`AA$$ = 
            0.111, $CellContext`BB$$ = 0.282, $CellContext`\[Rho]$$ = 
            0.101, $CellContext`RRe$$ = 2.98}]; 
         Which[$CellContext`model$$ == 
           "Popa-Adler-Houska", $CellContext`samples2$ = 
           
           Map[$CellContext`ALDPAH[#, $CellContext`clp$$, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`aa$$, $CellContext`bb$$]& , $CellContext`grid$], \
$CellContext`model$$ == "Krivoglaz-Wilkens", $CellContext`samples2$ = 
           Map[$CellContext`ALDWILK[#, $CellContext`clp$$, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`\[Rho]$$, $CellContext`RRe$$, $CellContext`clp$$ (Sqrt[2]/
               2)]& , $CellContext`grid$]]; $CellContext`samples3$ = \
$CellContext`samples1$ $CellContext`samples2$; $CellContext`g1$ = 
          Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples1$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`g2$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples2$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`g3$ = Interpolation[
            $CellContext`fourierData[
             Transpose[{$CellContext`grid$, $CellContext`samples3$}], 1.], 
            InterpolationOrder -> 1]; $CellContext`x1$ = 
          50/$CellContext`k1$; $CellContext`x2$ = 
          50/$CellContext`k2$; $CellContext`l1$ = 
          ListLinePlot[{$CellContext`samples1$, $CellContext`samples2$, \
$CellContext`samples3$}, DataRange -> {$CellContext`k1$, $CellContext`k2$}, 
            PlotRange -> {{$CellContext`k1$/$CellContext`kMag$$, \
$CellContext`k2$/$CellContext`kMag$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "Fourier length, s (nm)", "Fourier Transform"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              
              LineLegend[{
               "FT of peak shape", "FT of microstrain", 
                "FT of convolution"}], {0.2, Top}], TicksStyle -> 
            Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
            ImageSize -> 500]; $CellContext`l2$ = Plot[{
             $CellContext`g1$[$CellContext`x], 
             $CellContext`g2$[$CellContext`x], 
             $CellContext`g3$[$CellContext`x]}, {$CellContext`x, \
$CellContext`x1$/$CellContext`xMag$$, $CellContext`x2$/$CellContext`xMag$$}, 
            PlotRange -> {{$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`x2$/$CellContext`xMag$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "rel. \!\(\*SuperscriptBox[\(d\), \(*\)]\) \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"peak shape", "microstrain", "convolution"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; $CellContext`l2t$ = 
          Plot[{$CellContext`g1$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$], \
$CellContext`g2$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$], \
$CellContext`g3$[
               $CellContext`s[$CellContext`x - \
$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]] \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$$, $CellContext`lambda$$]}, \
{$CellContext`x, $CellContext`\[Theta]2[$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`lambda$$] + $CellContext`\[Theta]\[Theta]$$, $CellContext`\
\[Theta]2[$CellContext`x2$/$CellContext`xMag$$, $CellContext`lambda$$] + \
$CellContext`\[Theta]\[Theta]$$}, 
            PlotRange -> \
{{$CellContext`\[Theta]2[$CellContext`x1$/$CellContext`xMag$$, \
$CellContext`lambda$$] + $CellContext`\[Theta]\[Theta]$$, $CellContext`\
\[Theta]2[$CellContext`x2$/$CellContext`xMag$$, $CellContext`lambda$$] + \
$CellContext`\[Theta]\[Theta]$$}, Full}, GridLines -> Automatic, 
            GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
            True, FrameLabel -> {
             "2\[Theta]  (\[Degree])", "Intensity (a.u.)"}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"peak shape", "microstrain", "convolution"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; 
         Which[$CellContext`model$$ == "Popa-Adler-Houska", $CellContext`l3$ = 
           Plot[
             $CellContext`WPLTPAH[$CellContext`L, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`aa$$, $CellContext`bb$$], {$CellContext`L, 0, 50}, 
             PlotRange -> {{0, 50}, {0, All}}, 
             FrameLabel -> {
              "Fourier length, s  (nm)", 
               "<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\)  (nm)"}, GridLines -> 
             Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
             Frame -> True, 
             FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
             LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
               LineLegend[{"Warren plot - Popa-Adler-Houska strain model"}], {
               0.5, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
             Directive[Black, Thick], ImageSize -> 500], $CellContext`model$$ == 
           "Krivoglaz-Wilkens", $CellContext`l3$ = Plot[
             $CellContext`WPLTWILK[$CellContext`L, $CellContext`h$$, \
$CellContext`k$$, $CellContext`l$$, $CellContext`AA$$, $CellContext`BB$$, \
$CellContext`\[Rho]$$, $CellContext`RRe$$, $CellContext`clp$$ (Sqrt[2]/
               2)], {$CellContext`L, 0, 50}, PlotRange -> {{0, 50}, {0, All}},
              FrameLabel -> {
              "Fourier length, L (nm)", 
               "<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\) (nm)"}, GridLines -> Automatic,
              GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, Frame -> 
             True, FrameTicks -> {{Automatic, Automatic}, {
               Automatic, Automatic}}, LabelStyle -> Directive[Bold, 16], 
             PlotLegends -> Placed[
               LineLegend[{"Warren plot - Krivoglaz-Wilkens strain model"}], {
               0.5, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
             Directive[Black, Thick], ImageSize -> 500]]; 
         Grid[{{$CellContext`l1$, $CellContext`l2$}, {$CellContext`l2t$, \
$CellContext`l3$}}]]], "Specifications" :> {
        Text[
         Style[
         "Pseudo-Voigt function", 16]], {{$CellContext`\[Eta]$$, 0.5, 
          "mixing param."}, 0., 1., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         1}, {{$CellContext`hwhm$$, 0.1, "hwhm"}, 0.001, 2., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 2}, 
        Grid[{{
           Manipulate`Place[1]}, {
           Manipulate`Place[2], "\[Degree]2\[Theta]"}}], 
        Delimiter, {{$CellContext`model$$, "Popa-Adler-Houska", 
          "Microstrain model"}, {"Popa-Adler-Houska", "Krivoglaz-Wilkens"}, 
         ControlType -> RadioButton, Appearance -> "Vertical"}, 
        Delimiter, {{$CellContext`structure$$, "bcc iron"}, {
         "bcc iron", "fluorite", "free input"}, ControlType -> RadioButton, 
         Appearance -> "Vertical"}, {{$CellContext`clp$$, 0.286, ""}, 0.1, 1.,
          ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`AA$$, 0.3, ""}, 0., 1., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         4}, {{$CellContext`BB$$, -0.5, ""}, -1., 1., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`aa$$, 0.0005, ""}, 1.*^-7, 0.005, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         6}, {{$CellContext`bb$$, 0.0001, ""}, 2.*^-7, 0.002, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         7}, {{$CellContext`\[Rho]$$, 0.0101, ""}, 1.*^-7, 0.11, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         8}, {{$CellContext`RRe$$, 2.98, ""}, 0.1, 100, ControlType -> Slider,
          Appearance -> "Labeled", ControlPlacement -> 9}, 
        Grid[{{"cubic a", 
           Manipulate`Place[3], "nm"}, {"A      ", 
           Manipulate`Place[4], ""}, {"B      ", 
           Manipulate`Place[5], ""}, {"\[Alpha]      ", 
           Manipulate`Place[6], ""}, {"\[Beta]      ", 
           Manipulate`Place[7], ""}, {"\[Rho]       ", 
           Manipulate`Place[8], ""}, {"RRe     ", 
           Manipulate`Place[9], ""}}], 
        Delimiter, {{$CellContext`\[Theta]\[Theta]$$, 45., ""}, 1., 179., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         10}, {{$CellContext`lambda$$, 0.154, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         11}, {{$CellContext`h$$, 1, ""}, 1, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         12}, {{$CellContext`k$$, 0, ""}, 0, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         13}, {{$CellContext`l$$, 0, ""}, 0, 10, 1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 14}, 
        Grid[{{"peak position ", 
           Manipulate`Place[10], "\[Degree]2\[Theta]"}, {"wavelength    ", 
           Manipulate`Place[11], "nm"}, {"Miller index h", 
           Manipulate`Place[12]}, {"Miller index k", 
           Manipulate`Place[13]}, {"Miller index l", 
           Manipulate`Place[14]}}], Delimiter, 
        Text[
         Style["Zoom factors", 16]], {{$CellContext`xMag$$, 1.}, 0.1, 10., 
         0.1, ControlType -> Slider, Exclusions -> {0}, Appearance -> 
         "Labeled", ControlPlacement -> 15}, {{$CellContext`kMag$$, 1.}, 0.1, 
         10., 0.1, ControlType -> Slider, Exclusions -> {0}, Appearance -> 
         "Labeled", ControlPlacement -> 16}, 
        Grid[{{
           Manipulate`Place[15]}, {
           Manipulate`Place[16]}}], Delimiter}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Fourier (back)transform of Pseudo-Voigt function convoluted with \
microstrain\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1524., {446., 452.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`FTPVoigt[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Eta], 
          Blank[]], 
         Pattern[$CellContext`hwhm, 
          Blank[]]] := 
       Module[{$CellContext`k = (
            1 + (1 - $CellContext`\[Eta])/($CellContext`\[Eta] 
             Sqrt[Pi Log[2]]))^(-1)}, (1 - $CellContext`k)/
          E^(((Pi^2 $CellContext`hwhm^2) $CellContext`L^2)/Log[
           2]) + $CellContext`k/
          E^(((2 Pi) $CellContext`hwhm) 
           Abs[$CellContext`L])], $CellContext`k$$[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       1/$CellContext`s[$CellContext`\[Theta]2, $CellContext`\[Lambda]], \
$CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`\[Lambda] = 
       0.14249059611887502`, $CellContext`cs[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := ($CellContext`\[Theta]2 Degree) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`cs[
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := (Pi/180) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`ALDPAH[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`a0, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`aa, 
          Blank[]], 
         Pattern[$CellContext`bb, 
          Blank[]]] := 
       E^(((((-2) 
            Pi^2) (($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)/$CellContext`a0^2)) ($CellContext`AA + $CellContext`BB \
(($CellContext`HH^2 $CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + \
$CellContext`LL^2 $CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2))) ($CellContext`aa 
           Abs[$CellContext`L] + $CellContext`bb $CellContext`L^2)), \
$CellContext`ALDWILK[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`a0, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`\[Rho], 
          Blank[]], 
         Pattern[$CellContext`RRe, 
          Blank[]], 
         Pattern[$CellContext`bu, 
          Blank[]]] := 
       E^(((((-2) 
            Pi^2) (($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)/$CellContext`a0^2)) ($CellContext`AA + $CellContext`BB \
(($CellContext`HH^2 $CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + \
$CellContext`LL^2 $CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2))) (((($CellContext`bu^2/(4 
             Pi)) $CellContext`\[Rho]) $CellContext`L^2) 
          If[$CellContext`L == 0, 0, 
            $CellContext`FWILK[
             Abs[$CellContext`L], $CellContext`RRe]])), $CellContext`FWILK[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`RRe, 
          Blank[]]] := If[
         And[$CellContext`L > 0, $CellContext`L <= $CellContext`RRe], -
          Log[$CellContext`L/$CellContext`RRe] + 7/4 - Log[
         2] + ($CellContext`L/$CellContext`RRe)^2/6 - (
          32 ($CellContext`L/$CellContext`RRe)^3)/(225 Pi), 
         512/((90 Pi) ($CellContext`L/$CellContext`RRe)) - (
          11/24 + (1/4) Log[2 ($CellContext`L/$CellContext`RRe)]) (
          1/($CellContext`L/$CellContext`RRe)^2)], $CellContext`fourierData[
         PatternTest[
          Pattern[$CellContext`data, 
           Blank[]], MatrixQ], 
         Pattern[$CellContext`scale, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`xGrid, $CellContext`pGrid, $CellContext`f, \
$CellContext`x0, $CellContext`x1, $CellContext`NN, $CellContext`DFT}, \
{$CellContext`xGrid, $CellContext`f} = 
          Transpose[$CellContext`data]; {$CellContext`x0, $CellContext`x1} = 
          MinMax[$CellContext`xGrid]; $CellContext`NN = 
          Length[$CellContext`xGrid] - 1; $CellContext`pGrid = 
          RotateRight[
           Range[-($CellContext`NN/2), $CellContext`NN/
              2]/($CellContext`x1 - $CellContext`x0), 
            Quotient[$CellContext`NN, 2] + 1]; $CellContext`DFT = 
          Fourier[$CellContext`f, FourierParameters -> 
             OptionValue[
              FourierParameters]] (($CellContext`x1 - $CellContext`x0)/
            Sqrt[(2 Pi) $CellContext`NN]); 
         Transpose[{$CellContext`pGrid, $CellContext`scale 
            Abs[$CellContext`DFT]}]], 
       Options[$CellContext`fourierData] = {
        FourierParameters -> {0, 1}}, $CellContext`data = CompressedData["
1:eJw0XHc81e8Xt6MoktmSIhqShubnEPJtp10qspqaSntop6GBKCXKiMpeqWMT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        "], $CellContext`WPLTPAH[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`aa, 
          Blank[]], 
         Pattern[$CellContext`bb, 
          Blank[]]] := 
       Sqrt[($CellContext`AA + $CellContext`BB (($CellContext`HH^2 \
$CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + $CellContext`LL^2 \
$CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2)) ($CellContext`aa $CellContext`L + $CellContext`bb \
$CellContext`L^2)], $CellContext`WPLTWILK[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`HH, 
          Blank[]], 
         Pattern[$CellContext`KK, 
          Blank[]], 
         Pattern[$CellContext`LL, 
          Blank[]], 
         Pattern[$CellContext`AA, 
          Blank[]], 
         Pattern[$CellContext`BB, 
          Blank[]], 
         Pattern[$CellContext`\[Rho], 
          Blank[]], 
         Pattern[$CellContext`RRe, 
          Blank[]], 
         Pattern[$CellContext`bu, 
          Blank[]]] := 
       Sqrt[($CellContext`AA + $CellContext`BB (($CellContext`HH^2 \
$CellContext`KK^2 + $CellContext`KK^2 $CellContext`LL^2 + $CellContext`LL^2 \
$CellContext`HH^2)/($CellContext`HH^2 + $CellContext`KK^2 + \
$CellContext`LL^2)^2)) (((($CellContext`bu^2/(4 
             Pi)) $CellContext`\[Rho]) $CellContext`L^2) 
          If[$CellContext`L == 0, 0, 
            $CellContext`FWILK[$CellContext`L, $CellContext`RRe]])]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Input",
 CellChangeTimes->{3.8286955838901634`*^9},
 CellLabel->
  "Out[843]=",ExpressionUUID->"7ff969e4-e203-4018-9c90-7941060c407c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"IntervalSlider", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "100"}], ",", "100"}], "}"}], ",", 
     RowBox[{"Method", "\[Rule]", "\"\<Stop\>\""}], ",", 
     RowBox[{"MinIntervalSize", "\[Rule]", "1"}], ",", 
     RowBox[{"Appearance", " ", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "]"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{"range", ",", 
        RowBox[{
         RowBox[{"xinit", "=", "3"}], ";", 
         RowBox[{"xMax", "=", "5"}], ";"}], ",", 
        RowBox[{
         RowBox[{"xinit", "=", "1"}], ";", 
         RowBox[{"xMax", "=", "4"}], ";"}]}], "]"}], ";", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Dynamic", "[", "xinit", "]"}]}], "}"}], ",", "1", ",", 
       RowBox[{"Dynamic", "[", "xMax", "]"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"range", ",", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "1", ",", "10", ",", 
       RowBox[{"TrackingFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "=", "#"}], ";", " ", 
           RowBox[{"a", "=", "10"}], ";"}], "&"}], ")"}]}]}], "}"}]}], "]"}], 
   " ", "*)"}]}]], "Input",
 CellChangeTimes->{
  3.800596771824752*^9, 3.800597284202766*^9, 3.8146120134115524`*^9, {
   3.8146120668013515`*^9, 3.8146120742389493`*^9}, {3.8146121541941*^9, 
   3.81461216389769*^9}, {3.814612207899022*^9, 3.814612218680523*^9}, {
   3.814612708755319*^9, 3.8146127112555876`*^9}, {3.814780724837796*^9, 
   3.8147807301137247`*^9}, {3.8147808119408197`*^9, 3.81478081285876*^9}, {
   3.8147811246557026`*^9, 3.814781141799735*^9}, {3.8147819722189164`*^9, 
   3.8147819899487762`*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"5eff9a00-02d8-4ce5-a226-335fcf1c4d8b"],

Cell["", "Author",
 CellChangeTimes->{{3.8151160810328197`*^9, 
  3.8151160821054034`*^9}},ExpressionUUID->"fbfe43fb-0c19-4e3d-9f03-\
eed7045c8787"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Integral breaths ", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.809159709373041*^9, 3.8091597165513396`*^9}, {
  3.8146861797822194`*^9, 3.8146861829539366`*^9}, {3.814769293633284*^9, 
  3.8147692992256017`*^9}, {3.8182334730607305`*^9, 3.8182334795427165`*^9}},
 CellTags->"Title",ExpressionUUID->"a57dc121-f907-4fc7-9438-5611a390c876"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Quiet", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "hkl", ",", " ", "HKL", ",", "HHHH", ",", "SHKL", ",", " ", 
        "\[Theta]\[Theta]", ",", "delta", ",", " ", "sigma", ",", "FWHMG", 
        ",", " ", "FWHML", ",", " ", "IBG", ",", " ", "IBL", ",", 
        "\[IndentingNewLine]", 
        "                                               ", "IBIPs", ",", 
        "IBSizes", ",", "IBDs", ",", "IBs", ",", "\[IndentingNewLine]", 
        "                                                ", "MeanSize", ",", 
        " ", "StdSize", ",", "\[IndentingNewLine]", 
        "                                                ", "l1", ",", "l2", 
        " ", ",", "l3", ",", "FWHM\[Theta]\[Theta]"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Which", "[", 
        RowBox[{
         RowBox[{"structure", " ", "\[Equal]", " ", "\"\<bcc iron\>\""}], ",",
          "   ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"clp", "=", "0.28600"}], ",", 
           RowBox[{"AA", "=", "0.300"}], ",", 
           RowBox[{"BB", "=", "  ", 
            RowBox[{"-", "0.500"}]}], ",", 
           RowBox[{"\[Rho]", "=", "0.005"}], ",", 
           RowBox[{"RRe", "=", "2.98"}], ",", " ", 
           RowBox[{"\[Mu]", "=", "3.00"}], ",", 
           RowBox[{"\[Sigma]", "=", "0.300"}], ",", "\[IndentingNewLine]", 
           "                                                                  \
   ", 
           RowBox[{"hkl", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "2", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "}"}]}]}], " ", 
          "}"}], ",", "\[IndentingNewLine]", "           ", 
         RowBox[{"structure", " ", "==", "\"\<fluorite\>\""}], ",", "   ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"clp", "=", "0.54616"}], ",", 
           RowBox[{"AA", "=", "0.111"}], ",", 
           RowBox[{"BB", "=", "    ", "0.282"}], ",", 
           RowBox[{"\[Rho]", "=", "0.101"}], ",", 
           RowBox[{"RRe", "=", "2.98"}], ",", " ", 
           RowBox[{"\[Mu]", "=", "2.30"}], ",", 
           RowBox[{"\[Sigma]", "=", "0.478"}], ",", "\[IndentingNewLine]", 
           "                                                                  \
    ", 
           RowBox[{"hkl", "=", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "2", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "2", ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"5", ",", "1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"5", ",", "3", ",", "1"}], "}"}]}], "}"}]}]}], " ", 
          "}"}], ",", "\[IndentingNewLine]", "           ", 
         RowBox[{"structure", " ", "==", "\"\<free input\>\""}], ",", 
         RowBox[{"{", 
          RowBox[{"hkl", "=", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2", ",", "0"}], "}"}]}], "}"}]}], " ", 
          "}"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"MeanSize", "  ", "=", 
        RowBox[{"dmean", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"StdSize", "     ", "=", 
        RowBox[{"sd", "[", 
         RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"HKL", "  ", "=", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"hkl", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "1"}], "]"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"hkl", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "2"}], "]"}], "]"}], "2"], "+", 
         SuperscriptBox[
          RowBox[{"hkl", "[", 
           RowBox[{"[", 
            RowBox[{"All", ",", "3"}], "]"}], "]"}], "2"]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"HHHH", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"hkl", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], "2"], "  ", 
            SuperscriptBox[
             RowBox[{"hkl", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2"}], "]"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"hkl", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "2"}], "]"}], "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"hkl", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "3"}], "]"}], "]"}], "2"]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"hkl", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "3"}], "]"}], "]"}], "2"], 
            SuperscriptBox[
             RowBox[{"hkl", "[", 
              RowBox[{"[", 
               RowBox[{"All", ",", "1"}], "]"}], "]"}], "2"]}]}], ")"}], "/", 
         SuperscriptBox[
          RowBox[{"(", "HKL", ")"}], "2"]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"SHKL", "=", 
        FractionBox[
         SqrtBox["HKL"], "clp"]}], ";", " ", 
       RowBox[{"(*", "  ", 
        RowBox[{
         SuperscriptBox["d", "*"], " ", "in", " ", 
         SuperscriptBox["nm", 
          RowBox[{"-", "1"}]]}], "  ", "*)"}], "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"\[Lambda]", "=", 
        RowBox[{"Min", "[", 
         RowBox[{"\[Lambda]", ",", 
          RowBox[{"2", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"SHKL", "[", 
              RowBox[{"[", 
               RowBox[{"Length", "[", "hkl", "]"}], "]"}], "]"}], "+", 
             "0.05"}], ")"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"\[Theta]\[Theta]", "      ", "=", 
        RowBox[{"\[Theta]2", "[", 
         RowBox[{"SHKL", ",", "\[Lambda]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"delta", "=", 
        RowBox[{"2", "  ", 
         RowBox[{"Delta\[Theta]", "[", 
          RowBox[{"X", ",", "Y", ",", 
           RowBox[{"\[Theta]\[Theta]", "/", "2"}]}], "]"}], " ", 
         RowBox[{"cs", "[", 
          RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}]}], ";", 
       RowBox[{"(*", " ", 
        RowBox[{"in", " ", 
         SuperscriptBox["nm", 
          RowBox[{"-", "1"}]]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"sigma", "=", 
        RowBox[{"2", " ", 
         RowBox[{"Sigma\[Theta]", "[", 
          RowBox[{"u", ",", "v", ",", "w", ",", "z", ",", 
           RowBox[{"\[Theta]\[Theta]", "/", "2"}]}], "]"}], " ", 
         RowBox[{"cs", "[", 
          RowBox[{"\[Theta]\[Theta]", ",", "\[Lambda]"}], "]"}]}]}], ";", " ", 
       RowBox[{"(*", " ", 
        RowBox[{"in", " ", 
         SuperscriptBox["nm", 
          RowBox[{"-", "1"}]]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"FWHMG", "=", 
        RowBox[{"Gaussfwhm", "[", "sigma", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"FWHML", "=", " ", 
        RowBox[{"Lorentzfwhm", "[", "delta", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"IBG", "     ", "=", " ", 
        RowBox[{"GaussIB", "[", "FWHMG", "]"}]}], ";", "  ", 
       "\[IndentingNewLine]", 
       RowBox[{"IBL", "     ", "=", " ", 
        RowBox[{"LorentzIB", "[", "FWHML", "]"}]}], ";", 
       "\[IndentingNewLine]", "\n", "        ", 
       RowBox[{"IBIPs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"SHKL", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{"VoigtIB2", "[", 
             RowBox[{
              RowBox[{"IBG", "[", 
               RowBox[{"[", "i", "]"}], "]"}], ",", 
              RowBox[{"IBL", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}]}], ";", 
       "  ", "\[IndentingNewLine]", 
       RowBox[{"IBSizes", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"SHKL", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{
             FractionBox["4", "3"], 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", " ", "\[Mu]"}], "-", 
               FractionBox[
                RowBox[{"7", " ", 
                 SuperscriptBox["\[Sigma]", "2"]}], "2"]}]]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"IBDs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"SHKL", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"SHKL", "[", 
                RowBox[{"[", "i", "]"}], "]"}], 
               SqrtBox[
                RowBox[{"2", "\[Pi]"}]], 
               SqrtBox[
                RowBox[{"bb", " ", 
                 RowBox[{"(", 
                  RowBox[{"AA", "+", 
                   RowBox[{"BB", " ", 
                    RowBox[{"HHHH", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}]}]], 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"-", 
                 FractionBox[
                  RowBox[{
                   SuperscriptBox["aa", "2"], 
                   RowBox[{"(", 
                    RowBox[{"AA", "+", 
                    RowBox[{"BB", " ", 
                    RowBox[{"HHHH", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], 
                   SuperscriptBox["\[Pi]", "2"], 
                   SuperscriptBox[
                    RowBox[{"SHKL", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "2"]}], 
                  RowBox[{"2", " ", "bb"}]]}]]}], ")"}], "/", 
             RowBox[{"Erfc", "[", 
              RowBox[{
               RowBox[{"SHKL", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "\[Pi]", " ", "aa", 
               SqrtBox[
                FractionBox[
                 RowBox[{"AA", "+", 
                  RowBox[{"BB", " ", 
                   RowBox[{"HHHH", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], 
                 RowBox[{"2", " ", "bb"}]]]}], "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"IBs", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"SHKL", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"2", " ", 
               RowBox[{"NIntegrate", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{"-", "2"}], 
                    SuperscriptBox["\[Pi]", "2"], 
                    SuperscriptBox[
                    RowBox[{"SHKL", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "2"], 
                    RowBox[{"(", 
                    RowBox[{"AA", "+", 
                    RowBox[{"BB", " ", 
                    RowBox[{"HHHH", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"aa", " ", "L"}], "+", 
                    RowBox[{"bb", " ", 
                    SuperscriptBox["L", "2"]}]}], ")"}]}]], ")"}], 
                  RowBox[{"FTVoigt", "[", 
                   RowBox[{"L", ",", 
                    RowBox[{"delta", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", 
                    RowBox[{"sigma", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}], "]"}], 
                  RowBox[{"(", 
                   RowBox[{
                    FractionBox["1", "4"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"Erfc", "[", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"-", "\[Mu]"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"Log", "[", "L", "]"}]}], 
                    RowBox[{
                    SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], "+", 
                    RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", "\[Mu]"}], "-", 
                    FractionBox[
                    RowBox[{"9", " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "2"]}]], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["L", "3"], " ", 
                    RowBox[{"Erfc", "[", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"-", "\[Mu]"}], "+", 
                    RowBox[{"Log", "[", "L", "]"}]}], 
                    RowBox[{
                    SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"\[Mu]", "+", 
                    SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]], " ", "L", 
                    " ", 
                    RowBox[{"Erfc", "[", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"-", "\[Mu]"}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["\[Sigma]", "2"]}], "+", 
                    RowBox[{"Log", "[", "L", "]"}]}], 
                    RowBox[{
                    SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}]}], ")"}]}]}], 
                    ")"}]}], ")"}]}], ",", 
                 RowBox[{"{", 
                  RowBox[{"L", ",", "0", ",", "10000"}], "}"}], ",", 
                 RowBox[{"Method", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"Automatic", ",", 
                    RowBox[{"\"\<SymbolicProcessing\>\"", "\[Rule]", "0"}]}], 
                   "}"}]}]}], "]"}]}], ")"}], 
             RowBox[{"-", "1"}]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "hkl", "]"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"l1", "=", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"IBIPs", ",", "IBSizes", ",", " ", "IBDs", ",", "IBs"}], 
           "}"}], " ", ",", "\[IndentingNewLine]", 
          "                          ", 
          RowBox[{"Joined", "\[Rule]", "True"}], ",", 
          RowBox[{"Mesh", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
          "                          ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Black", ",", 
               RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Blue", ",", 
               RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Green", ",", 
               RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}]}], "}"}]}], 
          ",", "\[IndentingNewLine]", "                          ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                          ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                          ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                          ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                          ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", "  ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "\"\<\[Beta](\!\(\*SuperscriptBox[\(d\), \(*\)]\))  \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", "Null"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) (=2sin\[Theta]/\
\[Lambda])  (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
               "\"\<Integral breadth\>\""}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                          ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                          ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                          ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<instrumental profile\>\"", ",", "\"\<size\>\"", ",", 
                "\"\<microstrain\>\"", ",", "\"\<total\>\""}], "}"}], "]"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                         ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                         ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                         ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                       ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"l2", "=", "  ", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"L", ",", 
                SqrtBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"aa", " ", "L"}], " ", "+", " ", 
                    RowBox[{"bb", " ", 
                    SuperscriptBox["L", "2"]}]}], ")"}], 
                  RowBox[{"(", 
                   RowBox[{"AA", "+", 
                    RowBox[{"BB", " ", 
                    RowBox[{"HHHH", "[", 
                    RowBox[{"[", "i", "]"}], "]"}]}]}], ")"}]}]]}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"L", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "5"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"Mesh", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
          "                            ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", "  ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "\"\<<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \
\(2\)]\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\)  (nm)\>\"", ",", "Null"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<Fourier length, L  (nm)\>\"", ",", "\"\<Warren plot\>\""}],
               "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
          "                           ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                           ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                           ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Text", "@", 
                 RowBox[{"hkl", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                RowBox[{"Text", "@", 
                 RowBox[{"hkl", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{"Text", "@", 
                 RowBox[{"hkl", "[", 
                  RowBox[{"[", "3", "]"}], "]"}]}], ",", 
                RowBox[{"Text", "@", 
                 RowBox[{"hkl", "[", 
                  RowBox[{"[", "4", "]"}], "]"}]}], ",", 
                RowBox[{"Text", "@", 
                 RowBox[{"hkl", "[", 
                  RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                          ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                          ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                          ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                        ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"l3", "=", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"G", "[", 
           RowBox[{"x", ",", "\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "    ", 
          "\[IndentingNewLine]", "                       ", 
          RowBox[{"{", 
           RowBox[{"x", ",", " ", "0.", ",", 
            RowBox[{"MeanSize", " ", "+", " ", 
             RowBox[{"6", " ", "StdSize"}]}]}], "}"}], ",", 
          "\[IndentingNewLine]", "            \t  ", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", "  ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "\"\<\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)\>\"", ",", "Null"}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<domain size, D  (nm)\>\"", ",", 
               "\"\<Size distribution\>\""}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", "                        ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{
              "{", "\"\<Lognormal domain size distribution\>\"", "}"}], "]"}],
              ",", 
             RowBox[{"{", 
              RowBox[{"0.7", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                        ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                 ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"AbsolutePointSize", "[", "6", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Tooltip", "[", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                    "}"}], "]"}], "]"}], ",", 
                 RowBox[{"Tooltip", "[", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{",", "0"}], "}"}], "]"}], "]"}]}], "}"}]}], 
              "}"}]}], ","}], " ", "*)"}], "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Red", ",", " ", "Thick", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
               " ", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                    RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
              "}"}]}], " ", "}"}]}], ",", "\[IndentingNewLine]", 
          "                ", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Epilog", "\[Rule]", " ", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", 
               RowBox[{"Arrow", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "0"}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
                   RowBox[{"G", "[", 
                    RowBox[{
                    RowBox[{"dmean", "[", 
                    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "\[Mu]", 
                    ",", "\[Sigma]"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
            ","}], " ", "*)"}], "\[IndentingNewLine]", 
          "                        ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"FWHM\[Theta]\[Theta]", " ", "=", " ", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Gaussfwhm", "[", 
             RowBox[{"2", " ", 
              RowBox[{"Sigma\[Theta]", "[", 
               RowBox[{"u", ",", "v", ",", "w", ",", "z", ",", 
                RowBox[{"\[Theta]2", "/", "2"}]}], "]"}]}], "]"}], ",", 
            RowBox[{"Lorentzfwhm", "[", " ", 
             RowBox[{"2", "  ", 
              RowBox[{"Delta\[Theta]", "[", 
               RowBox[{"X", ",", "Y", ",", 
                RowBox[{"\[Theta]2", "/", "2"}]}], "]"}]}], "]"}], ",", " ", 
            RowBox[{"Voigtfwhm", "[", 
             RowBox[{
              RowBox[{"2", "  ", 
               RowBox[{"Delta\[Theta]", "[", 
                RowBox[{"X", ",", "Y", ",", 
                 RowBox[{"\[Theta]2", "/", "2"}]}], "]"}]}], ",", 
              RowBox[{"2", " ", 
               RowBox[{"Sigma\[Theta]", "[", 
                RowBox[{"u", ",", "v", ",", "w", ",", "z", ",", 
                 RowBox[{"\[Theta]2", "/", "2"}]}], "]"}]}]}], "]"}]}], "}"}],
           ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[Theta]2", ",", "0.01", ",", "160.0"}], "}"}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]",
           "\t\t\t ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", "  ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<2\[Theta] (\[Degree])\>\"", ",", "Null"}], "}"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{
              "\"\<FWHM (\[Degree]2\[Theta])\>\"", ",", 
               "\"\<Full width at half maximum\>\""}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "All"}], "}"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", "                             ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", 
               RowBox[{
               "\"\<FWHM(G)\>\"", ",", "\"\<FWHM(L)\>\"", ",", 
                "\"\<FWHM(V)\>\""}], " ", "}"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.2", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                            ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", "                            ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "\[IndentingNewLine]", 
         "                         ", "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l1", ",", "l2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"FWHM\[Theta]\[Theta]", ",", "l3"}], "}"}]}], "}"}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ",", "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{"\"\<cubic a\>\"", ",", "         ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"clp", ",", "0.286", ",", "       ", "\"\<\>\""}], "}"}], 
           ",", "0.1", ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<nm\>\""}], "}"}], ",", "              ", 
      "\[IndentingNewLine]", "              ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<wavelength\>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "     ", 
            RowBox[{"\[Lambda]", ",", "0.154059", ",", "\"\<\>\""}], "}"}], 
           ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        " ", ",", "\"\<nm\>\""}], "}"}]}], "\[IndentingNewLine]", "        ", 
     "}"}], "]"}], ",", "\[IndentingNewLine]", " ", "Delimiter", ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Voigt function\>\"", ",", "16"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", "\"\<Gaussian\>\"", "]"}], "}"}], ",", 
      "               ", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<u         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"u", ",", "0.00", ",", "\"\<\>\""}], "}"}], ",", "  ", 
           "0.0", ",", " ", "0.1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<v         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"v", ",", "0.00", ",", "\"\<\>\""}], "}"}], ",", "  ", 
           "0.0", ",", " ", "0.1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<w         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"w", ",", "0.001", ",", "\"\<\>\""}], "}"}], ",", "  ", 
           "0.0", ",", " ", "0.1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<z         \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", "0.000001", ",", "\"\<\>\""}], "}"}], ",", "  ",
            "0.000001", ",", " ", "0.1", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}]}], "     ", "\[IndentingNewLine]", "        ", "}"}], "]"}],
    ",", "\[IndentingNewLine]", "    ", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "              ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Text", "[", "\"\<Lorentzian\>\"", "]"}], "}"}], ",", 
      "               ", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<X          \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"X", ",", "0.000001", ",", "\"\<\>\""}], "}"}], ",", " ", 
           "0.0000001", ",", " ", "0.5", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}], ",", "\[IndentingNewLine]", "              ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<Y          \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Y", ",", "0.000001", ",", "\"\<\>\""}], "}"}], ",", " ", 
           "0.0000001", ",", " ", "0.5", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}]}], 
       " ", "}"}]}], "\[IndentingNewLine]", "        ", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "  ", "Delimiter", ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Control", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"structure", ",", "\"\<bcc iron\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<bcc iron\>\"", ",", "\"\<fluorite\>\"", ",", 
        "\"\<free input\>\""}], "}"}], ",", "RadioButton", ",", 
      RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Lognormal domain size distribution\>\"", ",", "16"}], "]"}],
     "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "         ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Control", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\[Mu]", ",", "3.", ",", "\"\<lognormal mean\>\""}], "}"}],
           ",", "0.1", ",", " ", "5.", ",", "Slider", ",", 
          RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", "         ", 
      RowBox[{"{", 
       RowBox[{"Control", "@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\[Sigma]", ",", ".1", ",", "\"\<lognormal std. dev.\>\""}], "}"}],
           ",", "0.01", ",", " ", "1.", ",", "Slider", ",", 
          RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
       "}"}], ",", "\[IndentingNewLine]", "         ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<Mean Size\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"dmean", "[", 
            RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
       "}"}], ",", "\[IndentingNewLine]", "         ", 
      RowBox[{"{", "  ", 
       RowBox[{"\"\<Std. dev.\>\"", ",", " ", 
        RowBox[{"Dynamic", "@", 
         RowBox[{"NumberForm", "[", 
          RowBox[{
           RowBox[{"sd", "[", 
            RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"5", ",", "2"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
       "}"}]}], "         ", "\[IndentingNewLine]", "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Microstrain parameters\>\"", ",", "16"}], "]"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"Grid", "[", 
    RowBox[{"{", "\[IndentingNewLine]", "               ", 
     RowBox[{
      RowBox[{"{", "   ", 
       RowBox[{"\"\<A      \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"AA", ",", "0.3", ",", "\"\<\>\""}], "}"}], ",", "0.0", 
           ",", " ", "1.0", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "               ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<B      \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"BB", ",", 
             RowBox[{"-", "0.5"}], ",", "\"\<\>\""}], "}"}], ",", 
           RowBox[{"-", "1."}], ",", " ", "1.", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "               ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<\[Alpha]      \>\"", ",", "  ", 
        RowBox[{"Control", "@", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"aa", ",", "0.0005", ",", "\"\<\>\""}], "}"}], ",", 
           "0.0000001", ",", "0.005", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "               ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<\[Beta]      \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"bb", ",", "0.0001", ",", "\"\<\>\""}], "}"}], ",", 
           "0.0000002", ",", "0.002", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "              ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<\[Rho]       \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Rho]", ",", "0.0101", ",", "\"\<\>\""}], "}"}], ",", 
           "0.0000001", ",", "0.11", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\>\""}], "}"}], ",", "\[IndentingNewLine]", 
      "               ", 
      RowBox[{"{", "   ", 
       RowBox[{"\"\<RRe     \>\"", ",", "  ", 
        RowBox[{"Control", "@", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"RRe", ",", "2.98", ",", "\"\<\>\""}], "}"}], ",", "0.1", 
           ",", "100", ",", "Slider", ",", 
           RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
        ",", "\"\<\>\""}], "}"}]}], "\[IndentingNewLine]", "    ", "}"}], 
    "]"}], ",", "\[IndentingNewLine]", "Delimiter", ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<by R. E. Dinnebier & Paolo Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
      "\"\<Integral breath of Pseudo-Voigt function(IP) convoluted with \
microstrain and size for cubic crystal system\\n\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", "  ", 
    RowBox[{
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], " ", ","}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "->", "True"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.8116469089893303`*^9, 3.811646959198616*^9}, {
   3.811646992991229*^9, 3.8116470255525875`*^9}, {3.811647069999996*^9, 
   3.811647161319325*^9}, {3.8116472285377836`*^9, 3.811647303012206*^9}, 
   3.8116473470284586`*^9, {3.811647403927615*^9, 3.811647626314125*^9}, 
   3.8117273354051256`*^9, {3.8117277383378496`*^9, 3.811727755204723*^9}, {
   3.8117278029627857`*^9, 3.8117278034889135`*^9}, 3.811730219921915*^9, {
   3.81173030943751*^9, 3.811730329900406*^9}, {3.81173037040485*^9, 
   3.811730371213261*^9}, {3.8119324063950877`*^9, 3.81193241179547*^9}, {
   3.8120808958906655`*^9, 3.812080921659605*^9}, 3.812080971569854*^9, 
   3.812081018118833*^9, 3.8120821823115854`*^9, {3.812082358002715*^9, 
   3.81208239438227*^9}, 3.812082778326488*^9, {3.8121002965022593`*^9, 
   3.8121002984778013`*^9}, {3.812100356274906*^9, 3.812100409974572*^9}, {
   3.8121004943919544`*^9, 3.8121004976229277`*^9}, {3.8121288133848047`*^9, 
   3.8121288436418457`*^9}, 3.812128904597102*^9, {3.8151296071958165`*^9, 
   3.8151298445253177`*^9}, {3.8151339601902027`*^9, 3.815133989190937*^9}, 
   3.8151340316141806`*^9, {3.8151340789283266`*^9, 3.8151341380553246`*^9}, {
   3.8151341911355314`*^9, 3.8151342098236685`*^9}, {3.815134298201085*^9, 
   3.8151343072167845`*^9}, 3.815134339983467*^9, {3.815134400828898*^9, 
   3.81513440159484*^9}, {3.815134452299344*^9, 3.815134710165594*^9}, {
   3.815134747322796*^9, 3.8151347768234363`*^9}, {3.8151348435439286`*^9, 
   3.8151349116859193`*^9}, {3.815135075260618*^9, 3.8151350760246005`*^9}, {
   3.815135214883604*^9, 3.815135222599374*^9}, 3.8151352797235985`*^9, {
   3.815135325394109*^9, 3.8151353291480317`*^9}, 3.8151353965401874`*^9, {
   3.8151354697448053`*^9, 3.815135543371948*^9}, {3.815135574792017*^9, 
   3.815135815328904*^9}, {3.815136659789564*^9, 3.8151366601684847`*^9}, {
   3.8151367427512584`*^9, 3.8151367751858683`*^9}, {3.8151368111053224`*^9, 
   3.8151368391554337`*^9}, {3.815136871389826*^9, 3.81513699446941*^9}, {
   3.81513721317859*^9, 3.8151372199860086`*^9}, {3.8151373332599654`*^9, 
   3.815137350011076*^9}, {3.815137451192785*^9, 3.8151374562804966`*^9}, {
   3.8151391980903187`*^9, 3.815139297551027*^9}, {3.8151926832631407`*^9, 
   3.8151926842630663`*^9}, {3.815192800748676*^9, 3.8151928752807083`*^9}, {
   3.815192946172357*^9, 3.815193088548589*^9}, {3.8151932557848387`*^9, 
   3.815193293597767*^9}, {3.815196303390625*^9, 3.815196363219092*^9}, {
   3.8151966232524495`*^9, 3.815196644518257*^9}, {3.8151967595792513`*^9, 
   3.815196788447325*^9}, {3.81520351520722*^9, 3.8152035360671225`*^9}, {
   3.815203575365065*^9, 3.8152037408850656`*^9}, {3.8152038032302127`*^9, 
   3.8152038067776947`*^9}, {3.8152038517784834`*^9, 3.815203863356789*^9}, {
   3.818221184963759*^9, 3.818221212432456*^9}, {3.8182222184540577`*^9, 
   3.8182222211731005`*^9}, {3.818222259318531*^9, 3.8182223519028797`*^9}, {
   3.8182224215236425`*^9, 3.8182224231113367`*^9}, {3.81822343921677*^9, 
   3.8182235576772738`*^9}, {3.8182322249761133`*^9, 
   3.8182323561638913`*^9}, {3.8182324317443357`*^9, 
   3.8182324512601604`*^9}, {3.8182325086982403`*^9, 
   3.8182325512847433`*^9}, {3.8182325846211987`*^9, 
   3.8182327457330103`*^9}, {3.818232898578037*^9, 3.8182329717350426`*^9}, {
   3.818233095158641*^9, 3.8182330971741247`*^9}, {3.818233260191413*^9, 
   3.818233292311819*^9}, {3.8182333860647426`*^9, 3.818233404456397*^9}, {
   3.8182334368969235`*^9, 3.8182334377762947`*^9}, {3.8182338249474487`*^9, 
   3.818233842651162*^9}, {3.8203065411266394`*^9, 3.8203065424512672`*^9}, {
   3.824343112266533*^9, 3.8243432290292883`*^9}, {3.8243437364640474`*^9, 
   3.8243437809193316`*^9}, {3.824343882042935*^9, 3.8243439683141465`*^9}, {
   3.82435758919878*^9, 3.824357598245679*^9}, {3.8249819416441345`*^9, 
   3.824981987782405*^9}, {3.824983211061121*^9, 3.8249832457038207`*^9}, 
   3.824983956535342*^9, {3.8249840469194803`*^9, 3.824984074623099*^9}, {
   3.824984169853397*^9, 3.824984223739229*^9}, {3.8249888910577927`*^9, 
   3.824988953078491*^9}, {3.8249891394582*^9, 3.824989152286272*^9}, {
   3.824989182424374*^9, 3.8249892271801786`*^9}, {3.8249896034046545`*^9, 
   3.82498960863229*^9}, {3.824989688057147*^9, 3.824989701120242*^9}, {
   3.825504662635028*^9, 3.8255046670726657`*^9}, {3.825504742283718*^9, 
   3.8255047462462697`*^9}, {3.8272344018862944`*^9, 
   3.8272344096919365`*^9}, {3.8272344597894516`*^9, 3.82723449780682*^9}, {
   3.8272351093416214`*^9, 3.8272351116574483`*^9}, 3.8272373970129166`*^9, {
   3.8272374476242547`*^9, 3.8272374615936003`*^9}, {3.82730148007421*^9, 
   3.827301489465759*^9}, {3.827301534639076*^9, 3.827301578429449*^9}, {
   3.8274013706390724`*^9, 3.827401466892805*^9}, {3.8274068561133766`*^9, 
   3.8274068695979457`*^9}, {3.827407002445818*^9, 3.827407003742899*^9}, {
   3.8274070921204386`*^9, 3.827407119449442*^9}, {3.827407253437952*^9, 
   3.8274073030489545`*^9}, {3.8274073499407434`*^9, 3.827407406473893*^9}, 
   3.827407443162385*^9, {3.827407540930644*^9, 3.8274075530563717`*^9}, {
   3.827407613620617*^9, 3.8274076495904274`*^9}, {3.8274077124675417`*^9, 
   3.827407744452875*^9}, {3.827407780531895*^9, 3.8274077858914037`*^9}, {
   3.8274081253235054`*^9, 3.827408169059376*^9}, {3.8274082390298767`*^9, 
   3.827408322063952*^9}, {3.8274084151133356`*^9, 3.827408437441926*^9}, {
   3.827408538241778*^9, 3.8274085691958733`*^9}, {3.8274089422222013`*^9, 
   3.827409087226679*^9}, {3.8274091223367558`*^9, 3.8274091227899833`*^9}, {
   3.827458216921028*^9, 3.8274582284528656`*^9}, {3.827458309001207*^9, 
   3.8274583233140607`*^9}, {3.827458356861678*^9, 3.8274583590651226`*^9}, {
   3.827458400425295*^9, 3.827458403128301*^9}, {3.827458449488823*^9, 
   3.827458451223418*^9}, {3.827458668556587*^9, 3.8274586844628434`*^9}, {
   3.827458781699638*^9, 3.827458927343173*^9}, {3.827458961531639*^9, 
   3.8274591223475266`*^9}, {3.8274592253029437`*^9, 
   3.8274592501785765`*^9}, {3.8274592901952553`*^9, 3.827459316930001*^9}, {
   3.8274595732642155`*^9, 3.8274596248275228`*^9}, {3.827459679375677*^9, 
   3.827459715282839*^9}, {3.8274597456430426`*^9, 3.827459764596224*^9}, {
   3.827459819972418*^9, 3.827459865161041*^9}, {3.827460572458252*^9, 
   3.8274605747240844`*^9}, {3.827460665116452*^9, 3.8274606662882442`*^9}, {
   3.8274608407463074`*^9, 3.8274608434339333`*^9}, {3.827460904547485*^9, 
   3.8274609138601665`*^9}, {3.827461004021941*^9, 3.8274610247576017`*^9}, {
   3.827461601995109*^9, 3.8274616023235598`*^9}, {3.827463918947392*^9, 
   3.827463965699697*^9}, {3.827465136004797*^9, 3.8274651564275827`*^9}, {
   3.8274652763237*^9, 3.827465290417943*^9}, {3.827465372000038*^9, 
   3.8274653875004034`*^9}, {3.827465466660117*^9, 3.827465486692292*^9}, {
   3.827465766157857*^9, 3.8274658300200877`*^9}, {3.8274666018181224`*^9, 
   3.8274666501639132`*^9}, {3.8274668304059105`*^9, 3.827466870688527*^9}, {
   3.8274669129872894`*^9, 3.8274669723957815`*^9}, {3.827467002709552*^9, 
   3.8274670502583256`*^9}, 3.8274670857596874`*^9, {3.8274671951547136`*^9, 
   3.827467202327159*^9}, {3.827467246484919*^9, 3.8274672598919096`*^9}, {
   3.827467503854921*^9, 3.827467609671543*^9}, {3.8274678074600625`*^9, 
   3.8274678080381336`*^9}, {3.827467982857506*^9, 3.827468004655319*^9}, {
   3.827468178224286*^9, 3.8274681902875257`*^9}, {3.82746829894754*^9, 
   3.8274683117451*^9}, {3.8274685227685385`*^9, 3.8274685290343547`*^9}, {
   3.82746857541115*^9, 3.82746864578867*^9}, {3.8274686790869694`*^9, 
   3.8274687063064747`*^9}, {3.827469301218548*^9, 3.8274693042189198`*^9}, {
   3.8274697974862385`*^9, 3.827469800408152*^9}, {3.827469998024599*^9, 
   3.827470002696399*^9}, 3.827475377454653*^9, {3.8274754233703785`*^9, 
   3.8274754403827963`*^9}, {3.8274755027262774`*^9, 
   3.8274755560180426`*^9}, {3.827475692912642*^9, 3.8274757136392913`*^9}, {
   3.827475870361652*^9, 3.82747589529195*^9}, {3.8274760128499374`*^9, 
   3.827476020342168*^9}, {3.827476052741849*^9, 3.827476231585573*^9}, {
   3.8274763380837526`*^9, 3.8274763385463953`*^9}, {3.827476416267404*^9, 
   3.827476494738104*^9}, {3.827476547020676*^9, 3.827476549939853*^9}, {
   3.827476754050645*^9, 3.8274767709958076`*^9}, {3.8274768120434656`*^9, 
   3.8274768312702785`*^9}, {3.827476879304028*^9, 3.8274768812017226`*^9}, {
   3.827476913062063*^9, 3.827476930953968*^9}, {3.8274813247540417`*^9, 
   3.8274813503795986`*^9}, {3.827481532040325*^9, 3.8274817756242757`*^9}, {
   3.8274818119846897`*^9, 3.8274818185941935`*^9}, {3.8274858947231503`*^9, 
   3.827485905282091*^9}, {3.8274859987877483`*^9, 3.827486040210988*^9}, {
   3.8274860902430954`*^9, 3.8274860913392315`*^9}, {3.8274861298125844`*^9, 
   3.8274861526508007`*^9}, {3.8274924000117645`*^9, 3.827492423590472*^9}, {
   3.827492455450709*^9, 3.827492637298585*^9}, {3.827492716581798*^9, 
   3.827492730222226*^9}, {3.827562435520049*^9, 3.827562460456953*^9}, {
   3.827562507461132*^9, 3.827562555850584*^9}, {3.8275626263645735`*^9, 
   3.8275626320675616`*^9}, {3.8275626751446085`*^9, 3.8275627374444447`*^9}, 
   3.8275627718927603`*^9, {3.828515433550979*^9, 3.828515495304804*^9}, {
   3.8321499324848537`*^9, 3.832149968889065*^9}, {3.8321509969828773`*^9, 
   3.8321510980186186`*^9}, {3.8321511373139734`*^9, 
   3.8321511834588213`*^9}, {3.832151265124094*^9, 3.832151287949004*^9}, {
   3.832151369935584*^9, 3.832151374629302*^9}},
 CellLabel->
  "In[207]:=",ExpressionUUID->"45ec3c80-d17e-41e6-9625-a7968f247647"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`aa$$ = 0.0005, $CellContext`AA$$ = 
    0.3, $CellContext`bb$$ = 
    0.0001, $CellContext`BB$$ = -0.5, $CellContext`clp$$ = 
    0.286, $CellContext`RRe$$ = 2.98, $CellContext`structure$$ = 
    "bcc iron", $CellContext`u$$ = 0, $CellContext`v$$ = 0, $CellContext`w$$ =
     0.01, $CellContext`X$$ = 0.5, $CellContext`Y$$ = 0, $CellContext`z$$ = 
    1.*^-6, $CellContext`\[Lambda]$$ = 
    0.12158013984280899`, $CellContext`\[Mu]$$ = 3., $CellContext`\[Rho]$$ = 
    0.005, $CellContext`\[Sigma]$$ = 0.3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`clp$$], 0.286, ""}, 0.1, 1.}, {{
       Hold[$CellContext`\[Lambda]$$], 0.154059, ""}, 0.01, 0.3}, {
      Hold[
       Grid[{{"cubic a", 
          Manipulate`Place[1], "nm"}, {"wavelength", 
          Manipulate`Place[2], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Voigt function", 16]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`u$$], 0., ""}, 0., 0.1}, {{
       Hold[$CellContext`v$$], 0., ""}, 0., 0.1}, {{
       Hold[$CellContext`w$$], 0.001, ""}, 0., 0.1}, {{
       Hold[$CellContext`z$$], 1.*^-6, ""}, 1.*^-6, 0.1}, {
      Hold[
       Grid[{{
          Text["Gaussian"]}, {"u         ", 
          Manipulate`Place[3]}, {"v         ", 
          Manipulate`Place[4]}, {"w         ", 
          Manipulate`Place[5]}, {"z         ", 
          Manipulate`Place[6]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`X$$], 1.*^-6, ""}, 1.*^-7, 0.5}, {{
       Hold[$CellContext`Y$$], 1.*^-6, ""}, 1.*^-7, 0.5}, {
      Hold[
       Grid[{{
          Text["Lorentzian"]}, {"X          ", 
          Manipulate`Place[7]}, {"Y          ", 
          Manipulate`Place[8]}}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`structure$$], "bcc iron"}, {
      "bcc iron", "fluorite", "free input"}}, {
      Hold[
       Text[
        Style["Lognormal domain size distribution", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Mu]$$], 3., "lognormal mean"}, 0.1, 5.}, {{
       Hold[$CellContext`\[Sigma]$$], 0.1, "lognormal std. dev."}, 0.01, 1.}, {
      Hold[
       Grid[{{
          Manipulate`Place[9]}, {
          Manipulate`Place[10]}, {"Mean Size", 
          Dynamic[
           NumberForm[
            $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
          Dynamic[
           NumberForm[
            $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
            5, 2}]], "nm"}}]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Microstrain parameters", 16]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`AA$$], 0.3, ""}, 0., 1.}, {{
       Hold[$CellContext`BB$$], -0.5, ""}, -1., 1.}, {{
       Hold[$CellContext`aa$$], 0.0005, ""}, 1.*^-7, 0.005}, {{
       Hold[$CellContext`bb$$], 0.0001, ""}, 2.*^-7, 0.002}, {{
       Hold[$CellContext`\[Rho]$$], 0.0101, ""}, 1.*^-7, 0.11}, {{
       Hold[$CellContext`RRe$$], 2.98, ""}, 0.1, 100}, {
      Hold[
       Grid[{{"A      ", 
          Manipulate`Place[11], ""}, {"B      ", 
          Manipulate`Place[12], ""}, {"\[Alpha]      ", 
          Manipulate`Place[13], ""}, {"\[Beta]      ", 
          Manipulate`Place[14], ""}, {"\[Rho]       ", 
          Manipulate`Place[15], ""}, {"RRe     ", 
          Manipulate`Place[16], ""}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1009., {347.5, 353.5}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`aa$$ = 0.0005, $CellContext`AA$$ = 
        0.3, $CellContext`bb$$ = 
        0.0001, $CellContext`BB$$ = -0.5, $CellContext`clp$$ = 
        0.286, $CellContext`RRe$$ = 2.98, $CellContext`structure$$ = 
        "bcc iron", $CellContext`u$$ = 0., $CellContext`v$$ = 
        0., $CellContext`w$$ = 0.001, $CellContext`X$$ = 
        1.*^-6, $CellContext`Y$$ = 1.*^-6, $CellContext`z$$ = 
        1.*^-6, $CellContext`\[Lambda]$$ = 0.154059, $CellContext`\[Mu]$$ = 
        3., $CellContext`\[Rho]$$ = 0.0101, $CellContext`\[Sigma]$$ = 0.1}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Quiet[
        Module[{$CellContext`hkl$, $CellContext`HKL$, $CellContext`HHHH$, \
$CellContext`SHKL$, $CellContext`\[Theta]\[Theta]$, $CellContext`delta$, \
$CellContext`sigma$, $CellContext`FWHMG$, $CellContext`FWHML$, \
$CellContext`IBG$, $CellContext`IBL$, $CellContext`IBIPs$, \
$CellContext`IBSizes$, $CellContext`IBDs$, $CellContext`IBs$, \
$CellContext`MeanSize$, $CellContext`StdSize$, $CellContext`l1$, \
$CellContext`l2$, $CellContext`l3$, $CellContext`FWHM\[Theta]\[Theta]$}, 
         Which[$CellContext`structure$$ == 
           "bcc iron", {$CellContext`clp$$ = 0.286, $CellContext`AA$$ = 
            0.3, $CellContext`BB$$ = -0.5, $CellContext`\[Rho]$$ = 
            0.005, $CellContext`RRe$$ = 2.98, $CellContext`\[Mu]$$ = 
            3., $CellContext`\[Sigma]$$ = 
            0.3, $CellContext`hkl$ = {{1, 1, 0}, {2, 0, 0}, {2, 1, 1}, {3, 1, 
             0}, {3, 2, 1}, {4, 1, 1}, {4, 2, 0}, {3, 3, 
             2}}}, $CellContext`structure$$ == 
           "fluorite", {$CellContext`clp$$ = 0.54616, $CellContext`AA$$ = 
            0.111, $CellContext`BB$$ = 0.282, $CellContext`\[Rho]$$ = 
            0.101, $CellContext`RRe$$ = 2.98, $CellContext`\[Mu]$$ = 
            2.3, $CellContext`\[Sigma]$$ = 
            0.478, $CellContext`hkl$ = {{1, 1, 1}, {2, 0, 0}, {2, 2, 0}, {3, 
             1, 1}, {4, 2, 0}, {4, 2, 2}, {5, 1, 1}, {5, 3, 
             1}}}, $CellContext`structure$$ == 
           "free input", {$CellContext`hkl$ = {{1, 0, 0}, {1, 1, 0}, {1, 1, 
             1}, {2, 1, 0}, {2, 1, 1}, {3, 1, 0}, {3, 1, 1}, {3, 2, 
             0}}}]; $CellContext`MeanSize$ = $CellContext`dmean[$CellContext`\
\[Mu]$$, $CellContext`\[Sigma]$$]; $CellContext`StdSize$ = \
$CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]; \
$CellContext`HKL$ = 
          Part[$CellContext`hkl$, All, 1]^2 + 
           Part[$CellContext`hkl$, All, 2]^2 + 
           Part[$CellContext`hkl$, All, 3]^2; $CellContext`HHHH$ = (
            Part[$CellContext`hkl$, All, 1]^2 
             Part[$CellContext`hkl$, All, 2]^2 + 
            Part[$CellContext`hkl$, All, 2]^2 
             Part[$CellContext`hkl$, All, 3]^2 + 
            Part[$CellContext`hkl$, All, 3]^2 
             Part[$CellContext`hkl$, All, 
                1]^2)/$CellContext`HKL$^2; $CellContext`SHKL$ = 
          Sqrt[$CellContext`HKL$]/$CellContext`clp$$; \
$CellContext`\[Lambda]$$ = 
          Min[$CellContext`\[Lambda]$$, 2/(Part[$CellContext`SHKL$, 
              Length[$CellContext`hkl$]] + 
            0.05)]; $CellContext`\[Theta]\[Theta]$ = \
$CellContext`\[Theta]2[$CellContext`SHKL$, $CellContext`\[Lambda]$$]; \
$CellContext`delta$ = 
          2 $CellContext`Delta\[Theta][$CellContext`X$$, $CellContext`Y$$, \
$CellContext`\[Theta]\[Theta]$/
             2] $CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\
\[Lambda]$$]; $CellContext`sigma$ = 
          2 $CellContext`Sigma\[Theta][$CellContext`u$$, $CellContext`v$$, \
$CellContext`w$$, $CellContext`z$$, $CellContext`\[Theta]\[Theta]$/
             2] $CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`\
\[Lambda]$$]; $CellContext`FWHMG$ = \
$CellContext`Gaussfwhm[$CellContext`sigma$]; $CellContext`FWHML$ = \
$CellContext`Lorentzfwhm[$CellContext`delta$]; $CellContext`IBG$ = \
$CellContext`GaussIB[$CellContext`FWHMG$]; $CellContext`IBL$ = \
$CellContext`LorentzIB[$CellContext`FWHML$]; $CellContext`IBIPs$ = Table[{
             Part[$CellContext`SHKL$, $CellContext`i], 
             $CellContext`VoigtIB2[
              Part[$CellContext`IBG$, $CellContext`i], 
              Part[$CellContext`IBL$, $CellContext`i]]}, {$CellContext`i, 
             Length[$CellContext`hkl$]}]; $CellContext`IBSizes$ = Table[{
             Part[$CellContext`SHKL$, $CellContext`i], (4/3) 
             E^(-$CellContext`\[Mu]$$ - 7 $CellContext`\[Sigma]$$^2/
               2)}, {$CellContext`i, 
             Length[$CellContext`hkl$]}]; $CellContext`IBDs$ = Table[{
             
             Part[$CellContext`SHKL$, $CellContext`i], (
              Part[$CellContext`SHKL$, $CellContext`i] Sqrt[2 Pi] 
              Sqrt[$CellContext`bb$$ ($CellContext`AA$$ + $CellContext`BB$$ 
                  Part[$CellContext`HHHH$, $CellContext`i])] 
              E^(-($CellContext`aa$$^2 ($CellContext`AA$$ + $CellContext`BB$$ 
                   Part[$CellContext`HHHH$, $CellContext`i]) Pi^2 
                 Part[$CellContext`SHKL$, $CellContext`i]^2/(
                 2 $CellContext`bb$$))))/Erfc[
             Part[$CellContext`SHKL$, $CellContext`i] Pi $CellContext`aa$$ 
              Sqrt[($CellContext`AA$$ + $CellContext`BB$$ 
                  Part[$CellContext`HHHH$, $CellContext`i])/(
                2 $CellContext`bb$$)]]}, {$CellContext`i, 
             Length[$CellContext`hkl$]}]; $CellContext`IBs$ = Table[{
             
             Part[$CellContext`SHKL$, $CellContext`i], (2 
              NIntegrate[
               E^((-2) Pi^2 
                  Part[$CellContext`SHKL$, $CellContext`i]^2 \
($CellContext`AA$$ + $CellContext`BB$$ 
                    Part[$CellContext`HHHH$, $CellContext`i]) \
($CellContext`aa$$ $CellContext`L + $CellContext`bb$$ $CellContext`L^2)) \
$CellContext`FTVoigt[$CellContext`L, 
                  Part[$CellContext`delta$, $CellContext`i], 
                  Part[$CellContext`sigma$, $CellContext`i]] ((1/4) (
                  2 Erfc[(-$CellContext`\[Mu]$$ - 3 $CellContext`\[Sigma]$$^2 + 
                    Log[$CellContext`L])/(Sqrt[2] $CellContext`\[Sigma]$$)] + 
                  E^((-3) $CellContext`\[Mu]$$ - 9 $CellContext`\[Sigma]$$^2/
                    2) ($CellContext`L^3 
                    Erfc[(-$CellContext`\[Mu]$$ + Log[$CellContext`L])/(
                    Sqrt[2] $CellContext`\[Sigma]$$)] - 3 
                    E^(2 ($CellContext`\[Mu]$$ + $CellContext`\[Sigma]$$^2)) \
$CellContext`L Erfc[(-$CellContext`\[Mu]$$ - 2 $CellContext`\[Sigma]$$^2 + 
                    Log[$CellContext`L])/(
                    Sqrt[2] $CellContext`\[Sigma]$$)]))), {$CellContext`L, 0, 
                 10000}, 
                Method -> {
                 Automatic, "SymbolicProcessing" -> 
                  0}])^(-1)}, {$CellContext`i, 
             Length[$CellContext`hkl$]}]; $CellContext`l1$ = 
          ListPlot[{$CellContext`IBIPs$, $CellContext`IBSizes$, \
$CellContext`IBDs$, $CellContext`IBs$}, Joined -> True, Mesh -> All, 
            PlotStyle -> {{Black, 
               PointSize[Large]}, {Red, 
               PointSize[Large]}, {Blue, 
               PointSize[Large]}, {Green, 
               PointSize[Large]}}, 
            PlotRange -> {{Automatic, Automatic}, {0, Automatic}}, GridLines -> 
            Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
            Frame -> True, 
            FrameLabel -> {{
              "\[Beta](\!\(\*SuperscriptBox[\(d\), \(*\)]\))  \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", Null}, {
              "\!\(\*SuperscriptBox[\(d\), \(*\)]\) (=2sin\[Theta]/\[Lambda]) \
 (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", "Integral breadth"}}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              
              LineLegend[{
               "instrumental profile", "size", "microstrain", "total"}], {
              0.2, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; $CellContext`l2$ = 
          ListPlot[
            Table[
             Table[{$CellContext`L, 
               
               Sqrt[($CellContext`aa$$ $CellContext`L + $CellContext`bb$$ \
$CellContext`L^2) ($CellContext`AA$$ + $CellContext`BB$$ 
                  Part[$CellContext`HHHH$, $CellContext`i])]}, \
{$CellContext`L, 0, 50}], {$CellContext`i, 5}], Mesh -> All, 
            PlotRange -> {{0, Automatic}, {0, Automatic}}, GridLines -> 
            Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
            Frame -> True, 
            FrameLabel -> {{
              "<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]s\), \(hkl\), \(2\)]\
\)\!\(\*SuperscriptBox[\(>\), \(1/2\)]\)  (nm)", Null}, {
              "Fourier length, L  (nm)", "Warren plot"}}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{
                Text[
                 Part[$CellContext`hkl$, 1]], 
                Text[
                 Part[$CellContext`hkl$, 2]], 
                Text[
                 Part[$CellContext`hkl$, 3]], 
                Text[
                 Part[$CellContext`hkl$, 4]], 
                Text[
                 Part[$CellContext`hkl$, 5]]}], {0.2, Top}], TicksStyle -> 
            Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
            ImageSize -> 500]; $CellContext`l3$ = Plot[
            $CellContext`G[$CellContext`x, $CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {$CellContext`x, 0., $CellContext`MeanSize$ + 
             6 $CellContext`StdSize$}, PlotRange -> Full, GridLines -> 
            Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
            Frame -> True, 
            FrameLabel -> {{"\!\(\*SubscriptBox[\(g\), \(l\)]\)(D)", Null}, {
              "domain size, D  (nm)", "Size distribution"}}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"Lognormal domain size distribution"}], {0.7, Top}],
             TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], Epilog -> {Red, Thick, {
               Arrow[{{
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                  $CellContext`G[
                   $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}], 
               Arrow[{{
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 0}, {
                  $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], 
                  $CellContext`G[
                   $CellContext`dmean[$CellContext`\[Mu]$$, $CellContext`\
\[Sigma]$$], $CellContext`\[Mu]$$, $CellContext`\[Sigma]$$]}}]}}, ImageSize -> 
            500]; $CellContext`FWHM\[Theta]\[Theta]$ = Plot[{
             $CellContext`Gaussfwhm[
             2 $CellContext`Sigma\[Theta][$CellContext`u$$, $CellContext`v$$, \
$CellContext`w$$, $CellContext`z$$, $CellContext`\[Theta]2/2]], 
             $CellContext`Lorentzfwhm[
             2 $CellContext`Delta\[Theta][$CellContext`X$$, $CellContext`Y$$, \
$CellContext`\[Theta]2/2]], 
             $CellContext`Voigtfwhm[
             2 $CellContext`Delta\[Theta][$CellContext`X$$, $CellContext`Y$$, \
$CellContext`\[Theta]2/2], 
              2 $CellContext`Sigma\[Theta][$CellContext`u$$, \
$CellContext`v$$, $CellContext`w$$, $CellContext`z$$, $CellContext`\[Theta]2/
                2]]}, {$CellContext`\[Theta]2, 0.01, 160.}, PlotRange -> All, 
            GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
            PlotStyle -> {Thick}, Frame -> True, 
            FrameLabel -> {{"2\[Theta] (\[Degree])", Null}, {
              "FWHM (\[Degree]2\[Theta])", "Full width at half maximum"}}, 
            FrameTicks -> {{Automatic, Automatic}, {Automatic, All}}, 
            LabelStyle -> Directive[Bold, 16], PlotLegends -> Placed[
              LineLegend[{"FWHM(G)", "FWHM(L)", "FWHM(V)"}], {0.2, Top}], 
            TicksStyle -> Directive[Black, 15], AxesStyle -> 
            Directive[Black, Thick], ImageSize -> 500]; 
         Grid[{{$CellContext`l1$, $CellContext`l2$}, {$CellContext`FWHM\
\[Theta]\[Theta]$, $CellContext`l3$}}]]], 
      "Specifications" :> {{{$CellContext`clp$$, 0.286, ""}, 0.1, 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         1}, {{$CellContext`\[Lambda]$$, 0.154059, ""}, 0.01, 0.3, 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         2}, 
        Grid[{{"cubic a", 
           Manipulate`Place[1], "nm"}, {"wavelength", 
           Manipulate`Place[2], "nm"}}], Delimiter, 
        Text[
         Style["Voigt function", 16]], {{$CellContext`u$$, 0., ""}, 0., 0.1, 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         3}, {{$CellContext`v$$, 0., ""}, 0., 0.1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         4}, {{$CellContext`w$$, 0.001, ""}, 0., 0.1, ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`z$$, 1.*^-6, ""}, 1.*^-6, 0.1, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 6}, 
        Grid[{{
           Text["Gaussian"]}, {"u         ", 
           Manipulate`Place[3]}, {"v         ", 
           Manipulate`Place[4]}, {"w         ", 
           Manipulate`Place[5]}, {"z         ", 
           Manipulate`Place[6]}}], 
        Delimiter, {{$CellContext`X$$, 1.*^-6, ""}, 1.*^-7, 0.5, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         7}, {{$CellContext`Y$$, 1.*^-6, ""}, 1.*^-7, 0.5, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 8}, 
        Grid[{{
           Text["Lorentzian"]}, {"X          ", 
           Manipulate`Place[7]}, {"Y          ", 
           Manipulate`Place[8]}}], 
        Delimiter, {{$CellContext`structure$$, "bcc iron"}, {
         "bcc iron", "fluorite", "free input"}, ControlType -> RadioButton, 
         Appearance -> "Vertical"}, Delimiter, 
        Text[
         Style[
         "Lognormal domain size distribution", 16]], {{$CellContext`\[Mu]$$, 
          3., "lognormal mean"}, 0.1, 5., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 
         9}, {{$CellContext`\[Sigma]$$, 0.1, "lognormal std. dev."}, 0.01, 1.,
          ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         10}, 
        Grid[{{
           Manipulate`Place[9]}, {
           Manipulate`Place[10]}, {"Mean Size", 
           Dynamic[
            NumberForm[
             $CellContext`dmean[$CellContext`\[Mu]$$, \
$CellContext`\[Sigma]$$], {5, 2}]], "nm"}, {"Std. dev.", 
           Dynamic[
            NumberForm[
             $CellContext`sd[$CellContext`\[Mu]$$, $CellContext`\[Sigma]$$], {
             5, 2}]], "nm"}}], Delimiter, 
        Text[
         Style["Microstrain parameters", 16]], {{$CellContext`AA$$, 0.3, ""}, 
         0., 1., ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 11}, {{$CellContext`BB$$, -0.5, ""}, -1., 1., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         12}, {{$CellContext`aa$$, 0.0005, ""}, 1.*^-7, 0.005, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         13}, {{$CellContext`bb$$, 0.0001, ""}, 2.*^-7, 0.002, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         14}, {{$CellContext`\[Rho]$$, 0.0101, ""}, 1.*^-7, 0.11, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         15}, {{$CellContext`RRe$$, 2.98, ""}, 0.1, 100, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 16}, 
        Grid[{{"A      ", 
           Manipulate`Place[11], ""}, {"B      ", 
           Manipulate`Place[12], ""}, {"\[Alpha]      ", 
           Manipulate`Place[13], ""}, {"\[Beta]      ", 
           Manipulate`Place[14], ""}, {"\[Rho]       ", 
           Manipulate`Place[15], ""}, {"RRe     ", 
           Manipulate`Place[16], ""}}], Delimiter}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & Paolo Scardi", "", 
          "Integral breath of Pseudo-Voigt function(IP) convoluted with \
microstrain and size for cubic crystal system\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> False, TrackedSymbols -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{1602., {496., 502.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`\[Sigma]$$ = 0.3, $CellContext`dmean[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       E^($CellContext`\[Mu] + $CellContext`\[Sigma]^2/2), $CellContext`sd[
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Sqrt[E^(2 $CellContext`\[Mu] + $CellContext`\[Sigma]^2) (
          E^($CellContext`\[Sigma]^2) - 1)], $CellContext`\[Lambda]$$ = 
       0.14249059611887502`, $CellContext`\[Theta]2[
         Pattern[$CellContext`s, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (ArcSin[($CellContext`\[Lambda]/2) $CellContext`s]/
         Degree), $CellContext`s[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := 
       2 (Sin[($CellContext`\[Theta]2/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`Delta\[Theta][
         Pattern[$CellContext`X, 
          Blank[]], 
         Pattern[$CellContext`Y, 
          Blank[]], 
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := $CellContext`X 
         Tan[$CellContext`\[Theta] Degree] + $CellContext`Y/
         Cos[$CellContext`\[Theta] Degree], $CellContext`X$$ = 
       0.5, $CellContext`Y$$ = 0, $CellContext`cs[
         Pattern[$CellContext`\[Theta]2, 
          Blank[]], 
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := ($CellContext`\[Theta]2 Degree) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`cs[
         Pattern[$CellContext`\[Theta]20, 
          Blank[]], 
         Pattern[$CellContext`\[Lambda], 
          Blank[]]] := (Pi/180) (
         Cos[($CellContext`\[Theta]20/2) 
           Degree]/$CellContext`\[Lambda]), $CellContext`Sigma\[Theta][
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]], 
         Pattern[$CellContext`w, 
          Blank[]], 
         Pattern[$CellContext`z, 
          Blank[]], 
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       Block[{$CellContext`a = $CellContext`u 
            Tan[$CellContext`\[Theta] Degree]^2 + $CellContext`v 
            Tan[$CellContext`\[Theta] 
              Degree] + $CellContext`w + $CellContext`z/
            Cos[$CellContext`\[Theta] Degree]^2}, 
         If[$CellContext`a < 0., 0., $CellContext`a]; 
         Sqrt[$CellContext`a]], $CellContext`u$$ = 0, $CellContext`v$$ = 
       0, $CellContext`w$$ = 0.01, $CellContext`z$$ = 
       1.*^-6, $CellContext`Gaussfwhm[
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       2 Sqrt[2 Log[2]] $CellContext`\[Sigma], $CellContext`Lorentzfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]]] := 2 $CellContext`\[Delta], $CellContext`GaussIB[
         Pattern[$CellContext`fwhm, 
          Blank[]]] := $CellContext`fwhm 
        Sqrt[Pi/(4 Log[2])], $CellContext`fwhm = 0., $CellContext`LorentzIB[
         Pattern[$CellContext`fwhm, 
          Blank[]]] := $CellContext`fwhm (Pi/2), $CellContext`VoigtIB2[
         Pattern[$CellContext`IBGauss, 
          Blank[]], 
         Pattern[$CellContext`IBLorentz, 
          Blank[]]] := (1/2) ($CellContext`IBLorentz + 
         Sqrt[4 $CellContext`IBGauss^2 + $CellContext`IBLorentz^2]), \
$CellContext`FTVoigt[
         Pattern[$CellContext`L, 
          Blank[]], 
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       E^((-$CellContext`\[Delta]) Abs[$CellContext`L 2 Pi] - 
         2 $CellContext`\[Sigma]^2 ($CellContext`L Pi)^2), $CellContext`G[
         Pattern[$CellContext`d, 
          Blank[]], 
         Pattern[$CellContext`\[Mu], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Piecewise[{{0., $CellContext`d <= 0}}, 1/(
         E^((Log[$CellContext`d] - $CellContext`\[Mu])^2/(
           2 $CellContext`\[Sigma]^2)) ($CellContext`d $CellContext`\[Sigma] 
          Sqrt[2 Pi]))], $CellContext`Voigtfwhm[
         Pattern[$CellContext`\[Delta], 
          Blank[]], 
         Pattern[$CellContext`\[Sigma], 
          Blank[]]] := 
       Module[{$CellContext`fg = 
          Sqrt[8 Log[2]] $CellContext`\[Sigma], $CellContext`fl = 
          2 $CellContext`\[Delta]}, 0.5346 $CellContext`fl + 
         Sqrt[0.2166 $CellContext`fl $CellContext`fl + $CellContext`fg \
$CellContext`fg]]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.82748609372808*^9, 3.827486153885002*^9, 
  3.827492639251853*^9, 3.8274927353787394`*^9, 3.8275622696335964`*^9, 
  3.8275626372392635`*^9, 3.8275627387412367`*^9, 3.827562807970392*^9, 
  3.8278403202249985`*^9, 3.8281878500759153`*^9, 3.828352563418662*^9, 
  3.8285058336830277`*^9, 3.828510862157423*^9, 3.828515573970783*^9, 
  3.8286882798929768`*^9, 3.832149537766138*^9, 3.8321511113480787`*^9, 
  3.8321511892472277`*^9, 3.832151295055883*^9, 3.8321513754696836`*^9},
 CellLabel->
  "Out[207]=",ExpressionUUID->"fe6e3f76-283b-45b4-aea7-940775110d80"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1861, 1079},
WindowMargins->{{Automatic, 760}, {118, Automatic}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6108c5e4-8854-4d3e-82d9-dc9bd551896b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Title"->{
  Cell[580, 22, 377, 5, 97, "Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a",
   CellTags->"Title"],
  Cell[4385, 105, 364, 4, 85, "Title",ExpressionUUID->"9004c831-7d6f-49ee-bde6-b915ab17c4da",
   CellTags->"Title"],
  Cell[63304, 1320, 452, 6, 85, "Title",ExpressionUUID->"614fb7d8-b5b8-4315-b0cc-39cf1a5d0d88",
   CellTags->"Title"],
  Cell[118695, 2469, 488, 6, 82, "Title",ExpressionUUID->"87089602-e95a-48e2-9bc8-643af66f361b",
   CellTags->"Title"],
  Cell[229198, 4521, 524, 7, 82, "Title",ExpressionUUID->"9ab5a89b-d659-4faa-a591-779b5f7e289d",
   CellTags->"Title"],
  Cell[395365, 7621, 512, 6, 82, "Title",ExpressionUUID->"a57dc121-f907-4fc7-9438-5611a390c876",
   CellTags->"Title"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Title", 481447, 9420}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 377, 5, 97, "Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a",
 CellTags->"Title"],
Cell[960, 29, 306, 8, 50, "Input",ExpressionUUID->"638de314-7056-49bd-af21-319f457c40a4"],
Cell[1269, 39, 644, 15, 29, "Input",ExpressionUUID->"7ee0b89d-b3e5-44a5-836e-8ce0856b95e9"],
Cell[CellGroupData[{
Cell[1938, 58, 392, 8, 50, "Input",ExpressionUUID->"c0c5201b-c383-4468-8299-2a63fa0088f2"],
Cell[2333, 68, 2003, 31, 33, "Output",ExpressionUUID->"dd75fa14-bd6a-4986-bfe7-3a7a0030c6ff"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4385, 105, 364, 4, 85, "Title",ExpressionUUID->"9004c831-7d6f-49ee-bde6-b915ab17c4da",
 CellTags->"Title"],
Cell[CellGroupData[{
Cell[4774, 113, 36399, 747, 2150, "Input",ExpressionUUID->"ef4a8e38-7c6b-424d-a4dc-0634896bc416"],
Cell[41176, 862, 22079, 452, 869, "Output",ExpressionUUID->"c24345ef-725b-458c-9066-086d9c2bc399"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63304, 1320, 452, 6, 85, "Title",ExpressionUUID->"614fb7d8-b5b8-4315-b0cc-39cf1a5d0d88",
 CellTags->"Title"],
Cell[CellGroupData[{
Cell[63781, 1330, 40614, 848, 1986, "Input",ExpressionUUID->"f88a6359-607b-4714-82c5-2f44741394a2"],
Cell[104398, 2180, 14248, 283, 884, "Output",ExpressionUUID->"9ce39970-a60e-4acc-9b78-67fdb5244527"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118695, 2469, 488, 6, 82, "Title",ExpressionUUID->"87089602-e95a-48e2-9bc8-643af66f361b",
 CellTags->"Title"],
Cell[CellGroupData[{
Cell[119208, 2479, 52674, 1027, 2798, "Input",ExpressionUUID->"8ed16028-e390-4f33-a637-2d59df92a45e"],
Cell[171885, 3508, 57264, 1007, 819, "Output",ExpressionUUID->"d83010df-b4e2-4dee-8474-0c8428f3e1f3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[229198, 4521, 524, 7, 82, "Title",ExpressionUUID->"9ab5a89b-d659-4faa-a591-779b5f7e289d",
 CellTags->"Title"],
Cell[CellGroupData[{
Cell[229747, 4532, 54862, 1075, 3089, "Input",ExpressionUUID->"b508c09e-bcb3-4682-98dd-e62d075b4a48"],
Cell[284612, 5609, 54091, 967, 917, "Output",ExpressionUUID->"835ff0d2-e902-4ade-8c0c-8424f3a3bdce"]
}, Open  ]],
Cell[338718, 6579, 54164, 970, 913, "Input",ExpressionUUID->"7ff969e4-e203-4018-9c90-7941060c407c"],
Cell[392885, 7551, 2292, 60, 67, "Input",ExpressionUUID->"5eff9a00-02d8-4ce5-a226-335fcf1c4d8b"],
Cell[395180, 7613, 148, 3, 31, "Author",ExpressionUUID->"fbfe43fb-0c19-4e3d-9f03-eed7045c8787"]
}, Open  ]],
Cell[CellGroupData[{
Cell[395365, 7621, 512, 6, 82, "Title",ExpressionUUID->"a57dc121-f907-4fc7-9438-5611a390c876",
 CellTags->"Title"],
Cell[CellGroupData[{
Cell[395902, 7631, 58206, 1248, 3265, "Input",ExpressionUUID->"45ec3c80-d17e-41e6-9625-a7968f247647"],
Cell[454111, 8881, 26808, 519, 1017, "Output",ExpressionUUID->"fe6e3f76-283b-45b4-aea7-940775110d80"]
}, Open  ]]
}, Open  ]]
}
]
*)

