(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     79504,       1864]
NotebookOptionsPosition[     71805,       1732]
NotebookOutlinePosition[     73735,       1780]
CellTagsIndexPosition[     73666,       1775]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Voigt & Pseudo-Voigt profiles", "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
   3.794473182921484*^9, 3.794473193906823*^9}, 3.797331640127709*^9, {
   3.797653041984359*^9, 3.797653047469375*^9}},
 CellTags->"Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a"],

Cell[TextData[StyleBox["Conversion 2\[Theta] \[DoubleLongLeftRightArrow]s \
(d*)", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.81304391837568*^9, 3.813043974892224*^9}, {3.8130440133459535`*^9, 
  3.813044013705327*^9}, {3.824284660175318*^9, 3.824284663360445*^9}},
 CellTags->"Title",ExpressionUUID->"b1b247d9-e08c-4ac2-b206-3c3f097ef3a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"\[Theta]2_", ",", "\[Lambda]_"}], "]"}], ":=", 
    RowBox[{"2", " ", 
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Theta]2", "/", "2"}], ")"}], "\[Degree]"}], "]"}], 
      "\[Lambda]"]}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"s", " ", 
    RowBox[{"(", 
     SuperscriptBox["d", "*"], ")"}], " ", "in", " ", 
    SuperscriptBox["nm", 
     RowBox[{"-", "1"}]]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.8130439862205877`*^9, 3.813044121613388*^9}, {
  3.8130441522547483`*^9, 3.813044162129672*^9}, {3.813044218599369*^9, 
  3.8130442340685253`*^9}, {3.813390666045783*^9, 3.813390668068509*^9}, {
  3.813390834668897*^9, 3.813390835070195*^9}, {3.8134701505914497`*^9, 
  3.813470153622281*^9}, {3.813490868453823*^9, 3.8134908689764247`*^9}, {
  3.813491572835273*^9, 3.8134915732291503`*^9}, {3.824284585111151*^9, 
  3.8242845968304596`*^9}, {3.8242976714302826`*^9, 3.8242977339014273`*^9}, {
  3.824297824583324*^9, 3.8242978668121767`*^9}, {3.8243011989441795`*^9, 
  3.8243011993034134`*^9}, {3.8249672148872423`*^9, 3.8249672198091755`*^9}, {
  3.8249791262114534`*^9, 3.824979168423847*^9}},
 CellLabel->
  "In[435]:=",ExpressionUUID->"e4c31daf-f6e7-44eb-96d5-a439bfa598db"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"kk", "[", 
     RowBox[{"\[Theta]2_", ",", "\[Lambda]_"}], "]"}], ":=", 
    RowBox[{"1", "/", 
     RowBox[{"s", "[", 
      RowBox[{"\[Theta]2", ",", "\[Lambda]"}], "]"}]}]}], ";"}], "   ", 
  RowBox[{"(*", " ", 
   RowBox[{"k", " ", 
    RowBox[{"(", "L", ")"}], " ", "in", " ", "nm"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.8242978695466166`*^9, 3.824297882828185*^9}, {
   3.824639482616784*^9, 3.824639482976264*^9}, {3.8249672256061583`*^9, 
   3.8249672259342976`*^9}, 3.824973435719431*^9, {3.824979138440511*^9, 
   3.8249791447346897`*^9}, 3.8249791763322988`*^9},
 CellLabel->
  "In[436]:=",ExpressionUUID->"a488047f-3e6a-4e9f-b3ca-c98cbba42186"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]2", "[", 
     RowBox[{"s_", ",", "\[Lambda]_"}], "]"}], ":=", 
    RowBox[{"2", " ", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["\[Lambda]", "2"], " ", "s"}], ")"}], "]"}], "/", 
      "\[Degree]"}]}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"in", " ", "\[Degree]\[Theta]2"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.813044156660957*^9, 3.813044164020385*^9}, {
   3.813044378305174*^9, 3.813044464900423*^9}, {3.813044529479773*^9, 
   3.8130445568395934`*^9}, {3.813044616606386*^9, 3.8130446256063833`*^9}, 
   3.813390680711667*^9, {3.824350286906697*^9, 3.824350287423006*^9}, {
   3.824639484972766*^9, 3.82463949149195*^9}, {3.8249561834868865`*^9, 
   3.824956183986964*^9}, {3.824959888032378*^9, 3.8249598883606577`*^9}},
 CellLabel->
  "In[437]:=",ExpressionUUID->"acb57c99-40fb-487e-9091-f6fcceeee589"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"cs", "[", 
     RowBox[{"\[Theta]20_", ",", "\[Lambda]_"}], "]"}], ":=", " ", 
    RowBox[{
     FractionBox["Pi", "180"], " ", 
     FractionBox[
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[Theta]20", "/", "2"}], ")"}], "\[Degree]"}], "]"}], 
      "\[Lambda]"]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Factor", " ", "for", " ", "transformation", " ", "from", " ", "2", 
     "\[Theta]", 
     RowBox[{"(", "\[Degree]", ")"}]}], "-", " ", 
    RowBox[{"to", " ", 
     SuperscriptBox["d", "*"], 
     RowBox[{"(", 
      RowBox[{"1", "/", "nm"}], ")"}]}], "-", " ", "space"}], " ", "*)"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.813390859355547*^9, 3.8133909052283325`*^9}, {
   3.81339346128885*^9, 3.813393477259736*^9}, {3.813485020635194*^9, 
   3.813485041278067*^9}, {3.8134907806250534`*^9, 3.813490881682496*^9}, {
   3.8243011689439545`*^9, 3.8243012376794815`*^9}, {3.824302808823081*^9, 
   3.824302809424151*^9}, {3.824350142144822*^9, 3.824350145685917*^9}, {
   3.824350290361763*^9, 3.8243503162046103`*^9}, 3.82435965814948*^9, {
   3.8249560164990983`*^9, 3.8249560170616255`*^9}, {3.824956209659363*^9, 
   3.8249562100343423`*^9}, {3.824959721794577*^9, 3.8249597253727*^9}, {
   3.8249597592953167`*^9, 3.8249597947023134`*^9}, {3.8249598392189817`*^9, 
   3.8249598395938935`*^9}, {3.824959891610611*^9, 3.824959932424241*^9}},
 CellLabel->
  "In[438]:=",ExpressionUUID->"13f904a3-c3cf-40c0-8fd4-e1d1d54fa193"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"c\[Theta]2", "[", 
     RowBox[{"s_", ",", "\[Theta]20_", ",", "\[Lambda]_"}], "]"}], ":=", 
    RowBox[{"1", "/", 
     RowBox[{"cs", "[", 
      RowBox[{"\[Theta]20", ",", "\[Lambda]"}], "]"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Factor", " ", "for", " ", "transformation", " ", "from", " ", 
     SuperscriptBox["d", "*"], 
     RowBox[{"(", 
      RowBox[{"1", "/", "nm"}], ")"}]}], "-", " ", 
    RowBox[{"to", " ", "2", "\[Theta]", 
     RowBox[{"(", "\[Degree]", ")"}], " ", "space"}]}], " ", "*)"}], 
  " "}]], "Input",
 CellChangeTimes->{{3.8249560232492256`*^9, 3.824956077187882*^9}, 
   3.8249561897214684`*^9, {3.8249562402852683`*^9, 3.8249562406756406`*^9}, {
   3.824956271098121*^9, 3.8249562715355997`*^9}, {3.8249597312322354`*^9, 
   3.8249597354668493`*^9}, {3.82495982907832*^9, 3.8249598468441677`*^9}, 
   3.8249598995638595`*^9, {3.824959936658433*^9, 3.824959952939992*^9}},
 CellLabel->
  "In[439]:=",ExpressionUUID->"f02565a8-b4cf-481e-a64b-656c857224e1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Gaussian distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.81304391837568*^9, 3.813043974892224*^9}, {3.8130440133459535`*^9, 
  3.813044013705327*^9}, {3.8134967097277517`*^9, 3.8134967462755475`*^9}, {
  3.8243596363670645`*^9, 3.824359638877367*^9}},
 CellTags->"Title",ExpressionUUID->"d0e4b628-b487-47bb-8760-390da9407c49"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Gauss", "[", 
     RowBox[{"hwhm_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"\[Pi]", " ", "hwhm"}]], 
     SqrtBox[
      RowBox[{"\[Pi]", " ", 
       RowBox[{"Log", "[", "2", "]"}]}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Log", "[", "2", "]"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"x", "-", "x0"}], "hwhm"], ")"}], "2"]}]]}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[Sigma]", " ", "--"}], ">", " ", "hwhm"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.8133960630995045`*^9, 3.8133961454607472`*^9}, {
  3.813400995439947*^9, 3.8134010527041035`*^9}, {3.813411228896119*^9, 
  3.8134112293334274`*^9}, {3.8134117051685095`*^9, 3.8134117058544016`*^9}, {
  3.813460487837509*^9, 3.8134604912439084`*^9}, {3.8134605284790993`*^9, 
  3.8134605788242297`*^9}, {3.8279151425551496`*^9, 3.82791514287166*^9}, {
  3.8285920056481085`*^9, 3.828592042055032*^9}, {3.8321402793702865`*^9, 
  3.832140279671118*^9}},ExpressionUUID->"0874c1fa-303d-45be-9466-\
d934a08862a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gauss2", "[", 
    RowBox[{"\[Sigma]_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "x0"}], ")"}], "2"], 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Sigma]", "2"]}]]}]]}]}], ";", "   ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Sigma]", " ", "--"}], ">", " ", 
     RowBox[{
     "standard", " ", "deviation", " ", "of", " ", "normal", " ", 
      "distribution", " ", "hwhm"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", " ", "ln", 
       RowBox[{"(", "2", ")"}]}], "]"}], " ", "\[Sigma]"}]}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.81341168418501*^9, 3.8134118187968254`*^9}, {
  3.813411885989378*^9, 3.813411886110237*^9}, {3.813460559667529*^9, 
  3.8134605672769346`*^9}, {3.813928870226845*^9, 3.813928887742859*^9}, {
  3.813928930694321*^9, 3.813928952375323*^9}, {3.828588297984939*^9, 
  3.828588298518672*^9}},
 CellLabel->
  "In[441]:=",ExpressionUUID->"badf184d-6803-4970-b4f1-5f30a7877daf"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GaussTable", "[", 
    RowBox[{"\[Sigma]_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Gauss2", "[", 
     RowBox[{"\[Sigma]", ",", "x0", ",", "abscissae"}], "]"}], "//", 
    "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.794323615906721*^9, 3.7943236555079737`*^9}, {
   3.7943236873347144`*^9, 3.7943237482573233`*^9}, {3.794323826453142*^9, 
   3.794323862331386*^9}, {3.794326654297535*^9, 3.794326659532873*^9}, {
   3.794385490377509*^9, 3.794385512353673*^9}, {3.7943856017670383`*^9, 
   3.7943856022201405`*^9}, {3.7944733460214233`*^9, 3.794473346427919*^9}, {
   3.7973316857298393`*^9, 3.7973316921452127`*^9}, {3.797332334459362*^9, 
   3.7973323574470453`*^9}, {3.797332776844247*^9, 3.797332815074564*^9}, {
   3.7973350302690363`*^9, 3.7973350600072494`*^9}, {3.813396744155448*^9, 
   3.813396757532748*^9}, {3.8134010303446407`*^9, 3.813401030692625*^9}, {
   3.8134012253617425`*^9, 3.8134012510496373`*^9}, {3.8134013444851627`*^9, 
   3.813401344870859*^9}, {3.813401479681415*^9, 3.813401480383892*^9}, 
   3.813412307444744*^9, {3.813475856787052*^9, 3.813475865041119*^9}},
 CellLabel->
  "In[442]:=",ExpressionUUID->"29d4c8bf-2a7f-4d7d-ab1f-aa289bf581df"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Gauss2", "[", 
     RowBox[{"0.2", ",", "0", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], "]"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8134128447022877`*^9, 3.813412902046976*^9}, {
  3.813412940981433*^9, 3.813412944328394*^9}},
 CellLabel->
  "In[443]:=",ExpressionUUID->"99ec9406-5abf-442e-b64a-ca9686bcf9b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FTGauss", "[", 
    RowBox[{"L_", ",", "\[Sigma]_"}], "]"}], ":=", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["\[Sigma]", "2"], " ", 
     SuperscriptBox["L", "2"]}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.8279151271714993`*^9, 3.8279152686596727`*^9}, {
   3.8279154787728662`*^9, 3.8279155053325973`*^9}, {3.8279155392924385`*^9, 
   3.8279155396781597`*^9}, {3.8279166247961965`*^9, 
   3.8279166280696597`*^9}, {3.827916832645958*^9, 3.827916838450556*^9}, {
   3.827916872651224*^9, 3.827916879358539*^9}, 3.828588931013048*^9, {
   3.828588961637849*^9, 3.8285890004453573`*^9}, {3.8285911503574553`*^9, 
   3.828591150830214*^9}, {3.832140274117654*^9, 3.8321402975976105`*^9}, {
   3.832142857906148*^9, 
   3.832142858269532*^9}},ExpressionUUID->"9b9f243b-a52e-42ca-82a8-\
f7b6f24e3165"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Gaussfwhm", "[", "\[Sigma]_", "]"}], ":=", 
   RowBox[{"2", 
    SqrtBox[
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "\[Sigma]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GaussIB", "[", "fwhm_", "]"}], ":=", 
   RowBox[{"fwhm", 
    SqrtBox[
     RowBox[{
      FractionBox["\[Pi]", 
       RowBox[{"4", 
        RowBox[{"Log", "[", "2", "]"}]}]], " "}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sigma", "[", "fwhm_", "]"}], ":=", 
   FractionBox["fwhm", 
    RowBox[{"2", 
     SqrtBox[
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "2", "]"}]}]]}]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8134007604016595`*^9, 3.813400839503253*^9}, {
  3.8135699579476485`*^9, 3.81357005682425*^9}, {3.8135701007622147`*^9, 
  3.813570166903781*^9}, {3.813570200013607*^9, 3.813570200498023*^9}, {
  3.8251320618507576`*^9, 3.8251320926953163`*^9}, {3.825132139260668*^9, 
  3.825132164884144*^9}, {3.825132201650693*^9, 3.825132275996374*^9}, {
  3.8251323097092624`*^9, 3.8251323101848907`*^9}, {3.8251324874856386`*^9, 
  3.8251324879245214`*^9}, {3.828154327222947*^9, 3.8281543276767063`*^9}, {
  3.828589170040121*^9, 3.8285891705108843`*^9}, {3.8285913794784636`*^9, 
  3.828591396991146*^9}, {3.8321403640278254`*^9, 
  3.8321403643287525`*^9}},ExpressionUUID->"9aeab83c-4e00-422d-9600-\
5e5665e44a86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FTGaussfwhm", "[", "\[Sigma]_", "]"}], ":=", 
   FractionBox[
    SqrtBox[
     RowBox[{"2", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], 
    RowBox[{"\[Pi]", " ", "\[Sigma]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.8281543000779734`*^9, 3.8281543388371096`*^9}, {
   3.8281551833288946`*^9, 3.828155199202324*^9}, {3.828589126958067*^9, 
   3.8285891354944983`*^9}, 3.828589177255271*^9, {3.828589667945065*^9, 
   3.828589677273718*^9}, {3.8285913331912127`*^9, 3.8285913631502824`*^9}, {
   3.8321403599762597`*^9, 3.832140367470826*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"18ccfb01-4d08-460f-9979-537a410fbe40"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"2", " ", "\[Pi]"}]], " ", "a"}]], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["x", "2"], 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"]}]]}]]}], ",", "x", ",", "\[Omega]"}], 
    "]"}], "//", "FullSimplify"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8285880968818665`*^9, 3.8285881139719405`*^9}, {
  3.828588201428926*^9, 3.8285882271932817`*^9}, {3.828588302719434*^9, 
  3.828588343039493*^9}, {3.8285884943616714`*^9, 3.828588495040312*^9}, {
  3.828589299760808*^9, 3.8285893055907125`*^9}, {3.828591015510395*^9, 
  3.828591026286087*^9}, {3.828591104647092*^9, 3.8285911078623714`*^9}, {
  3.8285922393444138`*^9, 3.8285922440368624`*^9}, {3.828592279887244*^9, 
  3.8285922822859564`*^9}},
 CellLabel->
  "In[449]:=",ExpressionUUID->"09646820-832a-468c-aac9-de82bdc3fc01"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8285887724948807`*^9, 3.828588779714487*^9}},
 CellLabel->
  "In[450]:=",ExpressionUUID->"eca7e658-6996-40d7-9f38-14dbc89e2e62"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Solve", "[", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["L", "2"]}]], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}], ",", "L"}], "]"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8285911389054265`*^9, 3.828591194789875*^9}, {
  3.828592868510126*^9, 3.828592868892931*^9}},
 CellLabel->
  "In[451]:=",ExpressionUUID->"97d529f0-2459-40c0-be08-6b91c18d3357"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Lorentzian distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.81304391837568*^9, 3.813043974892224*^9}, {3.8130440133459535`*^9, 
  3.813044013705327*^9}, {3.8134967097277517`*^9, 3.8134967462755475`*^9}},
 CellTags->"Title",ExpressionUUID->"b7e5a630-108c-486a-b32f-70e9e67b13c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Lorentz", "[", 
     RowBox[{"\[Delta]_", ",", "x0_", ",", "x_"}], "]"}], ":=", "  ", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"\[Pi]", " ", "\[Delta]"}]], 
     FractionBox["1", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"x", "-", "x0"}], "\[Delta]"], ")"}], "2"]}]]}]}], ";"}], 
  "   ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"\[Delta]", " ", "--"}], ">", " ", "hwhm"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.813396815163421*^9, 3.8133968177254496`*^9}, {
  3.8133968504175625`*^9, 3.813396877456921*^9}, {3.8134010736914926`*^9, 
  3.81340109292021*^9}, {3.813401356680214*^9, 3.8134013569656534`*^9}, {
  3.8134127010046663`*^9, 3.8134127014048533`*^9}, {3.8134605839648438`*^9, 
  3.8134605932307262`*^9}},
 CellLabel->
  "In[452]:=",ExpressionUUID->"af94b793-67f8-49be-b392-3910f9946037"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LorentzTable", "[", 
    RowBox[{"\[Delta]_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Lorentz", "[", 
     RowBox[{"\[Delta]", ",", "x0", ",", "abscissae"}], "]"}], "//", 
    "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.794323615906721*^9, 3.7943236555079737`*^9}, {
  3.7943236873347144`*^9, 3.7943237482573233`*^9}, {3.794323826453142*^9, 
  3.794323862331386*^9}, {3.794326654297535*^9, 3.794326659532873*^9}, {
  3.794385490377509*^9, 3.794385512353673*^9}, {3.7943856017670383`*^9, 
  3.7943856022201405`*^9}, {3.7944733460214233`*^9, 3.794473346427919*^9}, {
  3.7973316857298393`*^9, 3.7973316921452127`*^9}, {3.7973328514876394`*^9, 
  3.797332881757473*^9}, {3.7973329638918514`*^9, 3.797332970854458*^9}, {
  3.7973350358166866`*^9, 3.7973350544911203`*^9}, {3.8134010703422565`*^9, 
  3.8134010706967072`*^9}, {3.8134013495715237`*^9, 3.813401377537244*^9}, {
  3.8134758732716265`*^9, 3.8134758811155186`*^9}},
 CellLabel->
  "In[453]:=",ExpressionUUID->"10efed5c-1053-4cf7-9b07-ae6126543a81"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Lorentz", "[", 
     RowBox[{"0.2", ",", "0", ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], "]"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.813412675465613*^9, 3.8134127266381545`*^9}, {
  3.8134127576227703`*^9, 3.8134127614547644`*^9}, {3.813412835329542*^9, 
  3.8134128357491226`*^9}, {3.8134129079845095`*^9, 3.813412950312846*^9}, {
  3.813415229861174*^9, 3.813415230229245*^9}},
 CellLabel->
  "In[454]:=",ExpressionUUID->"c92e544f-a100-420b-bbbc-ff2c5de90c14"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FTLorentz", "[", 
    RowBox[{"L_", ",", "\[Delta]_"}], "]"}], ":=", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", " ", "2"}], " ", "\[Pi]", " ", "\[Delta]", " ", 
     RowBox[{"Abs", "[", "L", "]"}], " "}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.8279157118798466`*^9, 3.827915730565444*^9}, {
  3.8279158430999527`*^9, 3.8279158434008245`*^9}, {3.827916615410877*^9, 
  3.827916619408747*^9}, {3.8279168437843122`*^9, 3.827916859290081*^9}, {
  3.8321428499104443`*^9, 
  3.832142876815827*^9}},ExpressionUUID->"afbe93a1-7258-4b50-9df4-\
fb9aa7ba4fbc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Lorentzfwhm", "[", "\[Delta]_", "]"}], ":=", 
    RowBox[{"2", "\[Delta]"}]}], ";"}], 
  "           "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LorentzIB", "[", "fwhm_", "]"}], ":=", 
   RowBox[{"fwhm", 
    FractionBox["\[Pi]", "2"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Delta", "[", "fwhm_", "]"}], ":=", 
    FractionBox["fwhm", "2"]}], ";"}], 
  "                                     "}]}], "Input",
 CellChangeTimes->{{3.8134007965563993`*^9, 3.813400833398017*^9}, {
   3.8135701629037447`*^9, 3.813570215888835*^9}, {3.8251323147840967`*^9, 
   3.82513235851709*^9}, {3.8281546105796757`*^9, 3.8281546108985195`*^9}, 
   3.8321428978712683`*^9},ExpressionUUID->"dcf5a5e7-06dd-428a-a337-\
a636db6d4f4e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FTLorentzfwhm", "[", "\[Delta]_", "]"}], ":=", 
   FractionBox[
    RowBox[{"Log", "[", "2", "]"}], 
    RowBox[{"\[Delta]", " ", "\[Pi]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.8281545971763496`*^9, 3.8281546381445303`*^9}, {
  3.8281551735856085`*^9, 3.8281552042337575`*^9}},
 CellLabel->
  "In[459]:=",ExpressionUUID->"7695e8d1-823a-4254-8d1b-ee4b47fdfbe3"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Solve", "[", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", " ", 
        RowBox[{"Abs", "[", 
         RowBox[{"L", " ", "2", " ", "Pi"}], "]"}]}], " ", "a"}]], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}], ",", "L"}], "]"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8285928832052765`*^9, 3.8285929160531425`*^9}},
 CellLabel->
  "In[460]:=",ExpressionUUID->"7a1c223a-aba3-4b22-ac4c-26dce77ae9b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Voigt distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.81304391837568*^9, 3.813043974892224*^9}, {3.8130440133459535`*^9, 
  3.813044013705327*^9}, {3.8134967097277517`*^9, 3.813496719603038*^9}, {
  3.813496753678862*^9, 3.813496756244568*^9}},
 CellTags->"Title",ExpressionUUID->"bde64921-d385-444d-b2ee-4dd4e642f830"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Voigt", "[", 
    RowBox[{"\[Delta]_", ",", "\[Sigma]_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"Re", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "-", "x0"}], ")"}], "-", 
            RowBox[{"\[ImaginaryI]", " ", "\[Delta]"}]}], ")"}], "2"], 
         RowBox[{"2", " ", 
          SuperscriptBox["\[Sigma]", "2"]}]]}]], " ", 
      RowBox[{"Erfc", "[", 
       FractionBox[
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "x0"}], ")"}]}], "+", "\[Delta]"}], 
        RowBox[{
         SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], "]"}], 
    RowBox[{
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.813401531505726*^9, 3.8134015932664776`*^9}, {
  3.813401997222108*^9, 3.8134020041774993`*^9}, {3.813569875430806*^9, 
  3.8135698758995857`*^9}, {3.817119087621827*^9, 3.817119088007472*^9}},
 CellLabel->
  "In[461]:=",ExpressionUUID->"b1d26e04-4930-460b-80a6-0562addd054e"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{"FTVoigt", "[", 
     RowBox[{"L_", ",", "\[Delta]_", ",", "\[Sigma]_"}], "]"}], ":=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Delta]"}], " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"L", " ", "2", " ", "\[Pi]"}], "]"}]}], "-", 
      RowBox[{"2", 
       SuperscriptBox["\[Sigma]", "2"], 
       SuperscriptBox[
        RowBox[{"(", " ", 
         RowBox[{"L", "  ", "\[Pi]"}], ")"}], "2"]}]}]]}], ";"}], 
  "  "}]], "Input",
 CellChangeTimes->{{3.81711909190508*^9, 3.817119095178578*^9}, {
  3.8171338638218546`*^9, 3.817133864868785*^9}, {3.8171339586387625`*^9, 
  3.8171339866244745`*^9}, {3.8171340679717703`*^9, 3.8171340878941317`*^9}, {
  3.817134151214138*^9, 3.8171341593039727`*^9}, {3.817134210244773*^9, 
  3.817134213259294*^9}, {3.8171343023610888`*^9, 3.81713431066197*^9}, {
  3.817178639142126*^9, 3.817178650454821*^9}, {3.8243066231867447`*^9, 
  3.8243066566740246`*^9}, {3.8243076025158987`*^9, 3.8243076066018567`*^9}, {
  3.82746914454114*^9, 3.8274691450098815`*^9}, {3.8279168554458933`*^9, 
  3.827916856126052*^9}, {3.828593337508337*^9, 3.828593341307145*^9}, {
  3.828593371627833*^9, 3.828593392467008*^9}},
 CellLabel->
  "In[462]:=",ExpressionUUID->"4eb79771-258c-438c-96f3-8df27753d5c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VoigtTable", "[", 
     RowBox[{"\[Delta]_", ",", "\[Sigma]_", ",", "x0_", ",", "abscissae_"}], 
     "]"}], ":=", 
    RowBox[{
     RowBox[{"Voigt", "[", 
      RowBox[{"\[Delta]", ",", "\[Sigma]", ",", "x0", ",", "abscissae"}], 
      "]"}], "//", "Chop"}]}], ";"}], "                        ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"PDF", "@", 
        RowBox[{"VoigtDistribution", "[", 
         RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}]}], ")"}], "[", 
      "abscissae", "]"}], "//", "Chop"}], ";"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.794323615906721*^9, 3.7943236555079737`*^9}, {
   3.7943236873347144`*^9, 3.7943237482573233`*^9}, {3.794323826453142*^9, 
   3.794323862331386*^9}, {3.794326654297535*^9, 3.794326659532873*^9}, {
   3.794385490377509*^9, 3.794385512353673*^9}, {3.7943856017670383`*^9, 
   3.7943856022201405`*^9}, {3.7944733460214233`*^9, 3.794473346427919*^9}, {
   3.7973316857298393`*^9, 3.7973316921452127`*^9}, {3.8133969725485287`*^9, 
   3.813396972865211*^9}, {3.813401527344535*^9, 3.8134015295300875`*^9}, {
   3.8134018259280195`*^9, 3.8134018522872677`*^9}, {3.8134149749923267`*^9, 
   3.8134149754927397`*^9}, {3.8134758910065966`*^9, 3.813475895568434*^9}, 
   3.813476832642655*^9},
 CellLabel->
  "In[463]:=",ExpressionUUID->"8c507082-c739-408f-b56b-4a0c6b66cd0d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Voigtfwhm", "[", 
    RowBox[{"\[Delta]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"fg", "=", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"8", "*", 
           RowBox[{"Log", " ", "[", "2", "]"}]}], "]"}], "*", "\[Sigma]"}]}], 
       ",", " ", 
       RowBox[{"fl", "=", 
        RowBox[{"2", "*", "\[Delta]"}]}]}], "}"}], ",", "\[IndentingNewLine]",
      "                                                                 ", 
     RowBox[{
      RowBox[{"0.5346", "*", "fl"}], "+", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"0.2166", "*", "fl", "*", "fl"}], "+", 
        RowBox[{"fg", "*", "fg"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VoigtIB", "[", 
   RowBox[{"IBGauss_", ",", "IBLorentz_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", "=", 
       FractionBox["IBLorentz", 
        RowBox[{
         SqrtBox[
          RowBox[{"\[Pi]", " "}]], "IBGauss"}]]}], "}"}], ",", 
     RowBox[{"IBGauss", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          SuperscriptBox["k", "2"]}]], " "}], 
       RowBox[{"Erfc", "[", "k", "]"}]]}]}], "]"}], "/;", 
   RowBox[{"IBGauss", ">", "0.000001"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VoigtIB2", "[", 
    RowBox[{"IBGauss_", ",", "IBLorentz_"}], "]"}], ":=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"IBLorentz", "+", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["IBGauss", "2"]}], "+", 
        SuperscriptBox["IBLorentz", "2"]}]]}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8133969761609793`*^9, 3.8133970026148825`*^9}, {
  3.813397040746448*^9, 3.8133970411321936`*^9}, {3.8134008206228247`*^9, 
  3.8134008209239354`*^9}, {3.8251323727329655`*^9, 3.8251326468182917`*^9}, {
  3.8274752582347655`*^9, 3.82747526571938*^9}, {3.8280904410391364`*^9, 
  3.828090441372972*^9}, {3.82809140194976*^9, 3.828091402345562*^9}, {
  3.8298070093182755`*^9, 3.829807045171755*^9}, {3.8298070837070656`*^9, 
  3.8298072184320917`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"7f5b3f6a-0499-4afb-a7e0-7bc0a9f5c74c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FTVoigtfwhm", "[", 
    RowBox[{"\[Delta]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "\[Delta]"}], "+", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["\[Delta]", "2"], "+", 
       RowBox[{
        SuperscriptBox["\[Sigma]", "2"], " ", 
        RowBox[{"Log", "[", "4", "]"}]}]}]]}], 
    RowBox[{" ", 
     RowBox[{
      SuperscriptBox["\[Sigma]", "2"], " ", "\[Pi]"}]}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.8280904202228093`*^9, 3.828090506342268*^9}, 
   3.8280906015663624`*^9, {3.828091642207755*^9, 3.828091642869398*^9}, {
   3.8280917376348467`*^9, 3.8280917506771355`*^9}, {3.8280927324791856`*^9, 
   3.828092782469366*^9}, 3.8280929009067445`*^9, {3.8281551554618297`*^9, 
   3.828155159013918*^9}, {3.828593331064393*^9, 3.8285933314741707`*^9}},
 CellLabel->
  "In[467]:=",ExpressionUUID->"1035bd92-c64d-4412-9004-6fda1d749fc4"],

Cell["\<\
(C. Chiarella and A. Reichel, Journal : Math. Comp. 22 (1968), 137 - 143.,
  S. M. Abrarov, B. M. Quine, R. K. Jagpal, Efficient application of the \
Chiarella and Reichel series approximation of the complex error function, \
arXiv : 1208.2062.
     from https : // mathematica.stackexchange.com/questions/19884/compiling \
- the Voigtdistribution - pdf)\
\>", "Text",
 CellChangeTimes->{{3.8281548605679784`*^9, 3.8281548751929054`*^9}, {
  3.828155299475971*^9, 3.828155315050089*^9}},
 FormatType->
  "TextForm",ExpressionUUID->"29ea16b9-4633-45df-8201-3e16ae9fe076"],

Cell[BoxData[
 RowBox[{
  RowBox[{"VoigtApprox", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "=", "24"}], ",", 
       RowBox[{"\[Tau]", "=", "12"}]}], "}"}], ",", "\[IndentingNewLine]", 
     " ", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"d", "=", 
          RowBox[{"N", "[", 
           RowBox[{
            RowBox[{"Range", "[", "n", "]"}], " ", 
            RowBox[{"\[Pi]", "/", "\[Tau]"}]}], "]"}]}], ",", 
         RowBox[{"b", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Exp", "[", 
            RowBox[{"-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Range", "[", "n", "]"}], " ", 
                RowBox[{"\[Pi]", "/", "\[Tau]"}]}], ")"}], "^", "2"}]}], 
            "]"}], "]"}]}], ",", "\[IndentingNewLine]", "           ", 
         RowBox[{"s", "=", 
          RowBox[{"N", "[", 
           RowBox[{"PadRight", "[", 
            RowBox[{
             RowBox[{"{", "}"}], ",", "n", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "]"}]}], ",", 
         "\[IndentingNewLine]", "         ", 
         RowBox[{"sq", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Sqrt", "[", "2", "]"}], "]"}]}], ",", "  ", 
         RowBox[{"sp", "=", 
          RowBox[{"N", "[", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"2", " ", "\[Pi]"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "    ", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Delta]", ",", "_Real"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Sigma]", ",", "_Real"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x0", ",", "_Real"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "_Real"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", "         ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"z", "=", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "x0"}], ")"}], "+", 
                 RowBox[{"I", " ", "\[Delta]"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"\[Sigma]", " ", "sq"}], ")"}]}]}], ",", "e"}], "}"}],
            ",", 
           RowBox[{
            RowBox[{"e", "=", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", " ", "\[Tau]", " ", "z"}], "]"}]}], ";", 
            "\[IndentingNewLine]", "                         ", 
            RowBox[{
             RowBox[{"Re", "[", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"I", " ", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "e"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Tau]", " ", "z"}], ")"}]}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", " ", "I", " ", 
                   RowBox[{"z", "/", "\[Tau]"}]}], ")"}], " ", 
                 RowBox[{"b", ".", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"e", " ", "s"}], "-", "1"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"d", "+", "z"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"d", "-", "z"}], ")"}]}], ")"}]}], ")"}]}]}]}], 
               ")"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"\[Sigma]", " ", "sp"}], ")"}]}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"RuntimeAttributes", "\[Rule]", 
          RowBox[{"{", "Listable", "}"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.797831283309857*^9, 3.797831283309857*^9}, {
   3.7978313552964964`*^9, 3.7978315034967556`*^9}, {3.797831783235509*^9, 
   3.797831784204218*^9}, 3.7984507705414557`*^9, {3.8134759623454423`*^9, 
   3.813475980491027*^9}, {3.825132177009671*^9, 3.8251321773379345`*^9}},
 CellLabel->
  "In[468]:=",ExpressionUUID->"1d6716fe-61f5-4919-87a0-56c7474d7b85"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"VoigtApproxTable", "[", 
    RowBox[{"\[Delta]_", ",", "\[Sigma]_", ",", "x0_", ",", "abscissae_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"VoigtApprox", "[", 
     RowBox[{"\[Delta]", ",", "\[Sigma]", ",", "x0", ",", "abscissae"}], 
     "]"}], "//", "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7978317744730015`*^9, 3.7978317796868954`*^9}, {
   3.7978318155202193`*^9, 3.7978318198331137`*^9}, {3.79783186134614*^9, 
   3.7978318662269897`*^9}, {3.797833855135457*^9, 3.797833860338848*^9}, 
   3.7984507778706217`*^9, {3.803300330660842*^9, 3.803300331145215*^9}, {
   3.8134759926164494`*^9, 3.8134760017414255`*^9}},
 CellLabel->
  "In[469]:=",ExpressionUUID->"e8e6e415-19b7-441a-a5b2-a6becf9945b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["TCH-Pseudo Voigt distribution\n", "Chapter"],
 StyleBox["(Thompson, P., Cox, D.E. & Hastings, J.B. (1987). Rietveld \
refinement of Debye-Scherrer synchrotron X-ray data from Al2O3. J. Appl. \
Cryst. 20, 79-83", "Chapter",
  FontSize->14]
}], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.81304391837568*^9, 3.813043974892224*^9}, {3.8130440133459535`*^9, 
  3.813044013705327*^9}, {3.8134967097277517`*^9, 3.813496719603038*^9}, {
  3.8134967748544407`*^9, 3.8134968386066103`*^9}},
 CellTags->"Title",ExpressionUUID->"639caf54-b21f-4622-883b-cee5decd1311"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Mix", "[", 
     RowBox[{"\[Delta]_", ",", "\[Sigma]_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FWHMg", "=", 
         RowBox[{"\[Sigma]", 
          SqrtBox[
           RowBox[{"8", " ", 
            RowBox[{"Log", "[", "2", "]"}]}]]}]}], ",", 
        RowBox[{"FWHMl", "=", 
         RowBox[{"2", "\[Delta]"}]}], ",", 
        RowBox[{"FWHMv", "=", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["FWHMl", "5"], "+", 
            SuperscriptBox["FWHMg", "5"], "+", 
            RowBox[{"2.69296", " ", 
             SuperscriptBox["FWHMg", "4"], " ", "FWHMl"}], "+", 
            RowBox[{"2.42843", " ", 
             SuperscriptBox["FWHMg", "3"], " ", 
             SuperscriptBox["FWHMl", "2"]}], "+", 
            RowBox[{"4.47163", " ", 
             SuperscriptBox["FWHMg", "2"], " ", 
             SuperscriptBox["FWHMl", "3"]}], "+", 
            RowBox[{"0.07842", " ", "FWHMg", " ", 
             SuperscriptBox["FWHMl", "4"]}]}], ")"}], 
          RowBox[{"1", "/", "5"}]]}], ",", "\[Eta]"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Eta]", "=", 
        RowBox[{"FWHMl", "/", "FWHMv"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"\[Eta]", "=", 
        RowBox[{"\[Eta]", "*", 
         RowBox[{"(", 
          RowBox[{"1.36603", " ", "-", " ", 
           RowBox[{"0.47719", " ", "\[Eta]"}], "+", 
           RowBox[{"0.11116", " ", 
            RowBox[{"\[Eta]", "^", "2"}]}]}], ")"}]}]}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8139276438131*^9, 3.813927679473899*^9}, {
   3.813927724164508*^9, 3.813927745033828*^9}, {3.851047922690811*^9, 
   3.851047964254839*^9}, 
   3.8510484981643248`*^9},ExpressionUUID->"89be03e1-29c8-454b-8752-\
af15cea84848"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TCHPseudoVoigt", "[", 
    RowBox[{"\[Delta]_", ",", "\[Sigma]_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FWHMg", "=", 
        RowBox[{"\[Sigma]", 
         SqrtBox[
          RowBox[{"8", " ", 
           RowBox[{"Log", "[", "2", "]"}]}]]}]}], ",", 
       RowBox[{"FWHMl", "=", 
        RowBox[{"2", "\[Delta]"}]}], ",", 
       RowBox[{"FWHMv", "=", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["FWHMl", "5"], "+", 
           SuperscriptBox["FWHMg", "5"], "+", 
           RowBox[{"2.69296", " ", 
            SuperscriptBox["FWHMg", "4"], " ", "FWHMl"}], "+", 
           RowBox[{"2.42843", " ", 
            SuperscriptBox["FWHMg", "3"], " ", 
            SuperscriptBox["FWHMl", "2"]}], "+", 
           RowBox[{"4.47163", " ", 
            SuperscriptBox["FWHMg", "2"], " ", 
            SuperscriptBox["FWHMl", "3"]}], "+", 
           RowBox[{"0.07842", " ", "FWHMg", " ", 
            SuperscriptBox["FWHMl", "4"]}]}], ")"}], 
         RowBox[{"1", "/", "5"}]]}], ",", "\[Eta]"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"\[Eta]", "=", 
       RowBox[{"FWHMl", "/", "FWHMv"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"\[Eta]", "=", 
       RowBox[{"\[Eta]", "*", 
        RowBox[{"(", 
         RowBox[{"1.36603", " ", "-", " ", 
          RowBox[{"0.47719", " ", "\[Eta]"}], "+", 
          RowBox[{"0.11116", " ", 
           RowBox[{"\[Eta]", "^", "2"}]}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Eta]"}], ")"}], 
        RowBox[{"Gauss2", "[", 
         RowBox[{
          RowBox[{"FWHMv", "/", 
           SqrtBox[
            RowBox[{"8", " ", 
             RowBox[{"Log", "[", "2", "]"}]}]]}], ",", "x0", ",", "x"}], 
         "]"}]}], "+", 
       RowBox[{"\[Eta]", " ", 
        RowBox[{"Lorentz", "[", 
         RowBox[{
          RowBox[{"FWHMv", "/", "2"}], ",", " ", "x0", ",", "x"}], 
         "]"}]}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8510474710960445`*^9, 3.851047483096555*^9}, {
   3.851047541942444*^9, 3.8510475678653345`*^9}, {3.8510477628725014`*^9, 
   3.851047832359627*^9}, 3.851047865845009*^9, {3.8510479526763496`*^9, 
   3.851047953207531*^9}},ExpressionUUID->"ef1f31ca-3ce6-4def-b892-\
2735302fb168"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.813413319850766*^9, 3.81341333499678*^9}, {
   3.8134133843831115`*^9, 3.8134134387881174`*^9}, 3.813413550226976*^9, {
   3.8134136685409327`*^9, 3.8134136755721836`*^9}, {3.813415102962372*^9, 
   3.8134151070652947`*^9}, {3.8139303740718656`*^9, 
   3.8139303744720716`*^9}, {3.81711961898341*^9, 3.8171196388907547`*^9}, {
   3.851047465564554*^9, 3.851047466080242*^9}, {3.8510478167964582`*^9, 
   3.851047844953622*^9}, 
   3.8510485421181746`*^9},ExpressionUUID->"58434e1f-4a2b-4755-ad10-\
b9605d8da381"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"PseudoVoigt", "[", 
      RowBox[{"0.1", ",", "0.3", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "Infinity"}], " ", ",", "Infinity"}], "}"}]}], "]"}], 
   "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"PseudoVoigt", "[", 
      RowBox[{"0.1", ",", "0.3", ",", "0", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], " ", ",", "3"}], "}"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.8134135769564276`*^9, 3.813413606602404*^9}, {
  3.813414724879362*^9, 3.813414770584508*^9}},
 CellLabel->
  "In[472]:=",ExpressionUUID->"e7104af1-ce41-4f1e-bfb6-7c7683ef88d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TCHPseudoVoigtTable", "[", 
     RowBox[{"\[Delta]_", ",", "\[Sigma]_", ",", "x0_", ",", "abscissae_"}], 
     "]"}], ":=", 
    RowBox[{
     RowBox[{"TCHPseudoVoigt", "[", 
      RowBox[{"\[Delta]", ",", "\[Sigma]", ",", "x0", ",", "abscissae"}], 
      "]"}], "//", "Chop"}]}], ";"}], "                        "}]], "Input",
 CellChangeTimes->{{3.8134149829612055`*^9, 3.8134150010241756`*^9}, {
  3.813475903943924*^9, 3.8134759127004814`*^9}, {3.8171196444881506`*^9, 
  3.8171196461472783`*^9}, {3.8171286774106407`*^9, 3.8171286785357676`*^9}, {
  3.819723864383236*^9, 3.8197238648907394`*^9}, {3.8243560113016987`*^9, 
  3.8243560117397056`*^9}},
 CellLabel->
  "In[473]:=",ExpressionUUID->"65870b43-076d-42e8-8459-39f4c3aab939"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Simplified Pseudo-Voigt  distribution", "Chapter"]], \
"Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.813499782848096*^9}, {3.813500130542923*^9, 
  3.8135001629185205`*^9}, {3.8135789848781996`*^9, 3.8135790332573433`*^9}, {
  3.813579143986269*^9, 3.8135791654381247`*^9}, {3.814175761432988*^9, 
  3.814175769300118*^9}, {3.8171173359128194`*^9, 3.81711733715454*^9}, {
  3.817119008252906*^9, 3.81711900987419*^9}},
 CellTags->"Title",ExpressionUUID->"163d7f9b-4568-46fe-99e0-ad9f578eebc3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PVoigt", "[", 
    RowBox[{"\[Eta]_", ",", "hwhm_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Eta]"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", " ", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"\[Pi]", " ", 
           RowBox[{"Log", "[", "2", "]"}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Pi]", " ", "hwhm"}], ")"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"Log", "[", "2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"x", "-", "x0"}], "hwhm"], ")"}], "2"]}]]}], ")"}]}], 
      ")"}]}], "+", 
    RowBox[{"\[Eta]", 
     RowBox[{"(", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Pi]", " ", "hwhm"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "x0"}], ")"}], "/", "hwhm"}], ")"}], "2"]}], 
          ")"}]}], ")"}]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PVoigt2", "[", 
    RowBox[{"\[Eta]_", ",", "\[Sigma]_", ",", "x0_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Eta]"}], ")"}], 
     RowBox[{"(", " ", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{"\[Sqrt]", 
            RowBox[{"(", 
             RowBox[{"2", "\[Pi]"}], " ", ")"}]}], "\[Sigma]"}], ")"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{" ", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"x", "-", "x0"}], 
              RowBox[{
               SqrtBox[
                RowBox[{"2", " "}]], "\[Sigma]"}]], ")"}], "2"]}]]}], ")"}]}],
       ")"}]}], "+", 
    RowBox[{"\[Eta]", 
     RowBox[{"(", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Pi]", " ", "\[Sigma]"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "x0"}], ")"}], "/", "\[Sigma]"}], ")"}], 
            "2"]}], ")"}]}], ")"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"PVoigtTable", "[", 
     RowBox[{"\[Eta]_", ",", "hwhm_", ",", "x0_", ",", "abscissae_"}], "]"}], 
    ":=", 
    RowBox[{
     RowBox[{"PVoigt", "[", 
      RowBox[{"\[Eta]", ",", "hwhm", ",", "x0", ",", "abscissae"}], "]"}], "//",
      "Chop"}]}], ";"}], "                        "}]}], "Input",
 CellChangeTimes->{{3.810111249484289*^9, 3.8101116436641836`*^9}, {
   3.810111707196417*^9, 3.810111713665283*^9}, {3.810111833620827*^9, 
   3.8101118394022064`*^9}, {3.8101118828249426`*^9, 3.810111888371964*^9}, {
   3.8101119209194436`*^9, 3.8101119260914364`*^9}, {3.810111959342102*^9, 
   3.8101119596546183`*^9}, {3.8101133509944973`*^9, 
   3.8101133554168196`*^9}, {3.8101135434986315`*^9, 3.810113572421221*^9}, {
   3.810113611952878*^9, 3.810113612437207*^9}, {3.8101136695632925`*^9, 
   3.8101136875168*^9}, {3.8101137230643625`*^9, 3.810113831816527*^9}, {
   3.8102718568166733`*^9, 3.8102719391524243`*^9}, {3.8102719836477017`*^9, 
   3.8102719916417055`*^9}, 3.8102723908525677`*^9, {3.81027265566003*^9, 
   3.8102726587741914`*^9}, {3.810272754845205*^9, 3.810272765512096*^9}, {
   3.8102729031745777`*^9, 3.8102729037809267`*^9}, {3.8102732040747814`*^9, 
   3.81027320789711*^9}, {3.8102742622110343`*^9, 3.810274272034525*^9}, {
   3.8102745672479644`*^9, 3.810274586654537*^9}, {3.8102909882392817`*^9, 
   3.8102911029502687`*^9}, {3.810291154740323*^9, 3.8102911552365026`*^9}, {
   3.8102912243555374`*^9, 3.810291234537383*^9}, {3.810291296774308*^9, 
   3.810291313321695*^9}, {3.810291626537592*^9, 3.8102916269747667`*^9}, {
   3.8135650471263924`*^9, 3.8135650535641527`*^9}, {3.8135651510033846`*^9, 
   3.813565158675895*^9}, {3.813565410212015*^9, 3.8135654196652317`*^9}, {
   3.8135654566190414`*^9, 3.81356555876201*^9}, {3.8135656177162433`*^9, 
   3.813565639513547*^9}, {3.8135657079524*^9, 3.8135657397812653`*^9}, {
   3.8135680034011407`*^9, 3.81356804574576*^9}, {3.813568079889924*^9, 
   3.8135680830744605`*^9}, {3.813568157122513*^9, 3.8135681598413677`*^9}, {
   3.8135684248302174`*^9, 3.81356843115834*^9}, {3.8135686531775503`*^9, 
   3.8135687060846725`*^9}, 3.8135689135723515`*^9, 3.813569021824066*^9, {
   3.8135692615619993`*^9, 3.8135692795468044`*^9}, {3.813569495253442*^9, 
   3.8135694965503387`*^9}, {3.8140054741605654`*^9, 3.8140054745237255`*^9}, 
   3.814086138648883*^9, {3.819723918548787*^9, 3.8197239189554353`*^9}, {
   3.824356018037281*^9, 3.8243560743308153`*^9}, {3.8243561435195475`*^9, 
   3.824356229995598*^9}, {3.824639518079842*^9, 3.8246395189500704`*^9}},
 CellLabel->
  "In[474]:=",ExpressionUUID->"fc400c0a-44ba-4ab1-821b-6e87a6e14297"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FTPVoigt", "[", 
     RowBox[{"L_", ",", "\[Eta]_", ",", "hwhm_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"k", "=", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            RowBox[{"1", "-", "\[Eta]"}], 
            RowBox[{"\[Eta]", 
             SqrtBox[
              RowBox[{"\[Pi]", " ", 
               RowBox[{"Log", "[", "2", "]"}]}]], " "}]]}], ")"}], 
         RowBox[{"-", "1"}]]}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "k"}], ")"}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox["hwhm", "2"], " ", 
            SuperscriptBox["L", "2"]}], 
           RowBox[{"Log", "[", "2", "]"}]]}]]}], "+", 
       RowBox[{"k", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Pi]", " ", "hwhm", " ", 
          RowBox[{"Abs", "[", "L", "]"}]}]]}]}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"hwhm", " ", "in", " ", "s"}], "-", "space"}], " ", 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.810111931451268*^9, 3.8101119722487426`*^9}, {
   3.8101120042962313`*^9, 3.81011202812475*^9}, {3.810113543701565*^9, 
   3.8101135726397476`*^9}, {3.8101139387094016`*^9, 3.810113980678788*^9}, {
   3.8102712953120584`*^9, 3.810271296687112*^9}, {3.810272252903858*^9, 
   3.8102722533189282`*^9}, {3.8102732307621884`*^9, 
   3.8102732510045614`*^9}, {3.8102911170918207`*^9, 3.810291135126522*^9}, {
   3.8103008884896407`*^9, 3.810300898161661*^9}, {3.8109802846956944`*^9, 
   3.8109803897915764`*^9}, {3.813568341422512*^9, 3.813568354860236*^9}, {
   3.8135689907454195`*^9, 3.8135689912454805`*^9}, {3.813569028746193*^9, 
   3.8135690329960895`*^9}, {3.8135789006331844`*^9, 
   3.8135789079921722`*^9}, {3.813579319531566*^9, 3.8135794830545316`*^9}, {
   3.8136714085683737`*^9, 3.8136714092525206`*^9}, {3.8136716532591567`*^9, 
   3.8136717881199684`*^9}, {3.8136718268235617`*^9, 3.8136721555154405`*^9}, 
   3.8136722203910975`*^9, {3.8136723385645466`*^9, 3.813672338643176*^9}, {
   3.8136725926832576`*^9, 3.813672638052702*^9}, {3.8136742874184575`*^9, 
   3.8136742879003205`*^9}, {3.8136743304327717`*^9, 
   3.8136743401705256`*^9}, {3.813674426995535*^9, 3.813674445005729*^9}, {
   3.813674487525755*^9, 3.813674490765211*^9}, {3.8136745932879205`*^9, 
   3.813674684389779*^9}, {3.813675801666582*^9, 3.8136758563420477`*^9}, {
   3.8136759289492793`*^9, 3.8136759338244233`*^9}, 3.8136759649706807`*^9, {
   3.813676071681794*^9, 3.813676147576729*^9}, {3.813676459157983*^9, 
   3.8136764687209735`*^9}, {3.813676550112413*^9, 3.813676602222079*^9}, {
   3.813676650831871*^9, 3.8136766742694936`*^9}, {3.8136767096450067`*^9, 
   3.813676709785894*^9}, {3.8136767430201674`*^9, 3.8136767626604958`*^9}, {
   3.8136768043494916`*^9, 3.8136769244913173`*^9}, {3.8136769790699854`*^9, 
   3.8136770231794786`*^9}, {3.813677133419404*^9, 3.8136771382598286`*^9}, 
   3.813677203619131*^9, {3.8136773732770844`*^9, 3.8136774153554497`*^9}, {
   3.8136775088093486`*^9, 3.813677514247182*^9}, {3.81392634856769*^9, 
   3.813926374786761*^9}, {3.813926438051065*^9, 3.8139264560700073`*^9}, {
   3.813926581916376*^9, 3.813926598010289*^9}, {3.813926727434951*^9, 
   3.813926732795935*^9}, {3.8139268042921543`*^9, 3.813926808139719*^9}, {
   3.813928007663558*^9, 3.813928250902892*^9}, {3.8139283160913506`*^9, 
   3.8139283190209723`*^9}, {3.8139283503423023`*^9, 
   3.8139283505452085`*^9}, {3.8139284120933743`*^9, 
   3.8139284202967644`*^9}, {3.8139284853758435`*^9, 
   3.8139285001378007`*^9}, {3.813928623440831*^9, 3.813928637222577*^9}, {
   3.8139943925293036`*^9, 3.8139943973573556`*^9}, {3.8139944298945303`*^9, 
   3.8139944337333355`*^9}, {3.8139945585389123`*^9, 
   3.8139945802515926`*^9}, {3.8139946426432714`*^9, 
   3.8139946428306847`*^9}, {3.8139952234349966`*^9, 
   3.8139952364668016`*^9}, {3.8139969708849506`*^9, 
   3.8139970349815364`*^9}, {3.8139972160941296`*^9, 3.813997230766091*^9}, {
   3.8139978530573587`*^9, 3.8139978769170885`*^9}, {3.8139979078746862`*^9, 
   3.8139979109020605`*^9}, {3.8139983391742764`*^9, 3.813998343533613*^9}, {
   3.8140040205831604`*^9, 3.8140040206798086`*^9}, {3.814004147965721*^9, 
   3.814004148022564*^9}, {3.8140059800515137`*^9, 3.8140059910302925`*^9}, {
   3.814007107571813*^9, 3.814007122419526*^9}, {3.814007154904418*^9, 
   3.814007154997924*^9}, {3.8140072164366074`*^9, 3.8140072274069743`*^9}, {
   3.8140072722224083`*^9, 3.8140072841089725`*^9}, {3.8140074027669744`*^9, 
   3.8140074279858775`*^9}, {3.814008069290696*^9, 3.8140081200100775`*^9}, {
   3.814008226823965*^9, 3.8140082589802074`*^9}, {3.8140083455644464`*^9, 
   3.814008355356522*^9}, {3.814079031114129*^9, 3.8140790321554165`*^9}, 
   3.8140861037615757`*^9, 3.8140861414205728`*^9, {3.824354927951866*^9, 
   3.8243549525785275`*^9}},
 CellLabel->
  "In[477]:=",ExpressionUUID->"37f95d17-1e85-422b-877f-236f74753693"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"PVoigt", "[", 
       RowBox[{"x", ",", "0", ",", "0.5", ",", "0.05"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}], 
    "\[IndentingNewLine]", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{"PVoigt2", "[", 
       RowBox[{"x", ",", "0", ",", "0.5", ",", "0.05"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "*)"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQBGIQnelULGqW/Max7HiDJIiuvVyjDKL/X/kGpjel3zMC
0UK5p01A9I/o7e9B9MqYw2D6WclnBnMQ/TuBA0S/ZBbmA9GHWk6A6Vs/s1lb
gHTGz5Vg2kKNr7QVSNcs2wymT82f2wWinc6e6QbRf/LmLwLRzZ9Og+k/fJlB
ZzLfOEYKngDTf6adDwfRG8Q8IkD0mSe8E0D0vZTjYPpKUs/ps0CaOVXnDIiW
On5f4xyQvnH8viaInnPWSh9En/DPBNOPgtYZg+hTgU/B9KWlMlKXgfQMVXcw
LTfl9sXPIHsd3G+BaKW67fdB9LX5k5+BaLbdc19+AdJMrz1fgehjr2au+A2k
p3ifXAmijxb1Hz2V9cZx1ZrVx0B0xgvXpZML3jjW6astA9HTngVELGh946gq
ewJMAwCsfNp/
  "],
 CellLabel->
  "In[478]:=",ExpressionUUID->"514ebfbe-77bf-4662-90f3-ff4aebf36d30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FWHM", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
   3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
   3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, 
   3.8133970198744593`*^9},
 CellTags->"Title",ExpressionUUID->"684c1a57-90ca-426a-a14a-c1142be9e495"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"fwhmcalc", "[", 
     RowBox[{"data_", ",", "n_Integer"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"max", "=", 
        RowBox[{
         RowBox[{"MaximalBy", "[", 
          RowBox[{"data", ",", "Last"}], "]"}], "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"(", 
       RowBox[{"Mean", "/@", 
        RowBox[{"FindClusters", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"data", "[", 
             RowBox[{"[", 
              RowBox[{"#", ",", "1"}], "]"}], "]"}], "&"}], "/@", 
           RowBox[{"Nearest", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"data", "[", 
               RowBox[{"[", 
                RowBox[{"All", ",", "2"}], "]"}], "]"}], "\[Rule]", 
              "Automatic"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "2"}], ")"}], " ", "max"}], ",", 
             RowBox[{"2", " ", "n"}]}], "]"}]}], ",", "2"}], "]"}]}], ")"}]}],
      "]"}]}], ";"}], " "}]], "Input",
 CellLabel->
  "In[479]:=",ExpressionUUID->"830d5b40-81ec-4e0e-8adb-fda80c540ddb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Angular dependence of FWHM", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
   3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
   3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, 
   3.8133970198744593`*^9, {3.815298885963627*^9, 3.8152989032459555`*^9}},
 CellTags->"Title",ExpressionUUID->"a979a3a1-153e-443a-a45b-1477e444ea0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sigma\[Theta]", "[", 
   RowBox[{"u_", ",", "v_", ",", "w_", ",", "z_", ",", "\[Theta]_"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "=", 
      RowBox[{
       RowBox[{"u", " ", 
        RowBox[{
         RowBox[{"Tan", "[", 
          RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}], "^", "2"}]}], "+", 
       RowBox[{"v", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}]}], "+", "w", "+", 
       RowBox[{"z", "/", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}], "^", "2"}]}]}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"a", "<", "0."}], ",", "0.", ",", "a"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     SqrtBox["a"]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.782014694707831*^9, 3.782014705561699*^9}, {
   3.7820147358418846`*^9, 3.7820147373619456`*^9}, {3.7820167372602386`*^9, 
   3.782016842133361*^9}, {3.782016967700897*^9, 3.7820169714119716`*^9}, {
   3.7820170902353506`*^9, 3.7820171103807535`*^9}, {3.78264604090475*^9, 
   3.782646168862544*^9}, {3.782646248850542*^9, 3.7826462610267596`*^9}, {
   3.7826463307737336`*^9, 3.782646360630719*^9}, {3.7826464606427193`*^9, 
   3.7826465129409485`*^9}, 3.782646603713025*^9, {3.782646715927245*^9, 
   3.7826467184384966`*^9}, {3.7826467590645585`*^9, 
   3.7826467618718395`*^9}, {3.782646982452895*^9, 3.782646997394389*^9}, {
   3.7826470365243015`*^9, 3.782647064774126*^9}, {3.7826472152921767`*^9, 
   3.7826472272043676`*^9}, {3.815298843635421*^9, 3.8152988489636507`*^9}, {
   3.8153071525680294`*^9, 3.81530715298999*^9}, {3.8157451782659388`*^9, 
   3.8157451800569916`*^9}, {3.8157471530948963`*^9, 
   3.8157471726144133`*^9}, {3.815747223406131*^9, 3.815747228126608*^9}, {
   3.815747267064863*^9, 3.815747273639331*^9}, {3.8157524762549367`*^9, 
   3.8157524842779903`*^9}},
 CellLabel->
  "In[480]:=",ExpressionUUID->"279ae50a-95ad-4e7f-bab0-0499d2f58ab5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Delta\[Theta]", "[", 
    RowBox[{"X_", ",", "Y_", ",", "\[Theta]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"X", " ", 
     RowBox[{"Tan", "[", 
      RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}]}], "+", 
    RowBox[{"Y", "/", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7820171163118725`*^9, 3.7820171317561817`*^9}, {
   3.782017931295326*^9, 3.7820179316253324`*^9}, {3.7820190105081635`*^9, 
   3.7820190119481926`*^9}, 3.815298860339131*^9, {3.815298969965573*^9, 
   3.8152989702936954`*^9}, {3.8153071870372334`*^9, 3.8153072011311226`*^9}},
 CellLabel->
  "In[481]:=",ExpressionUUID->"13dae483-e99d-47eb-bdb2-0793e8dd17ab"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Numerical Fourier transformation", "Chapter",
 FontSize->36]], "Chapter",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.813499782848096*^9}, {3.813500130542923*^9, 
  3.8135001629185205`*^9}, {3.8135789848781996`*^9, 3.8135790332573433`*^9}, {
  3.813579143986269*^9, 3.8135791654381247`*^9}, {3.8140861592886915`*^9, 
  3.8140861813430047`*^9}},
 CellTags->"Title",ExpressionUUID->"9e37cdf2-0d05-485e-8717-39e66853afb5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Options", "[", "fourierData", "]"}], "=", 
    RowBox[{"{", 
     RowBox[{"FourierParameters", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fourierData", "[", 
   RowBox[{
    RowBox[{"data_", "?", "MatrixQ"}], ",", "scale_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "xGrid", ",", "pGrid", ",", "f", ",", "x0", ",", "x1", ",", "NN", ",", 
      "DFT"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xGrid", ",", "f"}], "}"}], "=", 
      RowBox[{"Transpose", "[", "data", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x0", ",", "x1"}], "}"}], "=", 
      RowBox[{"MinMax", "[", "xGrid", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"NN", "=", 
      RowBox[{
       RowBox[{"Length", "[", "xGrid", "]"}], "-", "1"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pGrid", "=", 
      RowBox[{"RotateRight", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Range", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "NN"}], "/", "2"}], ",", 
           RowBox[{"NN", "/", "2"}]}], "]"}], " ", 
         RowBox[{"(*", 
          RowBox[{"2.0", " ", "\[Pi]"}], "*)"}], "/", 
         RowBox[{"(", 
          RowBox[{"x1", "-", "x0"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"Quotient", "[", 
          RowBox[{"NN", ",", "2"}], "]"}], "+", "1"}]}], "]"}]}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{"empirisch", " ", "+", "1"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"DFT", "=", 
      RowBox[{
       RowBox[{"Fourier", "[", 
        RowBox[{"f", ",", 
         RowBox[{"FourierParameters", "\[Rule]", 
          RowBox[{"OptionValue", "[", "FourierParameters", "]"}]}]}], "]"}], 
       " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x1", "-", "x0"}], ")"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"(", "NN", ")"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Transpose", "@", 
      RowBox[{"{", 
       RowBox[{"pGrid", ",", 
        RowBox[{"scale", " ", 
         RowBox[{"Abs", "@", "DFT"}]}]}], "}"}]}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8140771304547033`*^9, 3.8140771927183743`*^9}, {
   3.814077259031645*^9, 3.8140773186565495`*^9}, {3.8140773551676607`*^9, 
   3.8140773553683634`*^9}, {3.8140774027978954`*^9, 3.814077419354084*^9}, {
   3.8140774645948315`*^9, 3.8140774705305767`*^9}, {3.814077526878851*^9, 
   3.8140775278667126`*^9}, {3.814077591187489*^9, 3.814077652164401*^9}, {
   3.814077684446787*^9, 3.814077753412609*^9}, {3.8140777941245723`*^9, 
   3.8140778212366753`*^9}, 3.814078189018439*^9, {3.814078225812955*^9, 
   3.8140782461278677`*^9}, {3.814078341911869*^9, 3.8140784096431656`*^9}, {
   3.814078439977064*^9, 3.8140784511678305`*^9}, {3.814078535987029*^9, 
   3.814078543080739*^9}, {3.8140785922166185`*^9, 3.8140785986925907`*^9}, {
   3.8140786296678033`*^9, 3.8140786315521865`*^9}, {3.814078695610015*^9, 
   3.814078698667507*^9}, {3.8140787361495104`*^9, 3.814078878241047*^9}, {
   3.814078972480596*^9, 3.8140790836644907`*^9}, {3.814079145976894*^9, 
   3.8140791539040723`*^9}, {3.814079277383916*^9, 3.8140793088312993`*^9}, {
   3.814079384043247*^9, 3.8140794286893573`*^9}, {3.814079486883639*^9, 
   3.814079493537532*^9}, {3.8140796065033817`*^9, 3.814079651079243*^9}, 
   3.814079724518266*^9, {3.814080861850895*^9, 3.814080873877462*^9}, {
   3.814080905936254*^9, 3.8140809914850245`*^9}, {3.814081032494896*^9, 
   3.8140810425126076`*^9}, {3.814081086224352*^9, 3.814081092575427*^9}, {
   3.814081146258117*^9, 3.814081158598447*^9}, {3.8140862953888397`*^9, 
   3.81408634116351*^9}, {3.8140864010418158`*^9, 3.814086435005127*^9}, {
   3.814086550502998*^9, 3.8140865510268393`*^9}, {3.814086597257512*^9, 
   3.814086605539158*^9}, 3.8140866671503325`*^9, {3.8141758131609154`*^9, 
   3.814175829002303*^9}, {3.8172744802502565`*^9, 3.817274484250496*^9}, {
   3.8172745390642576`*^9, 3.8172745431736135`*^9}, {3.817274612034627*^9, 
   3.817274612362602*^9}, {3.8172746753174534`*^9, 3.8172746754266148`*^9}, {
   3.8172747682567215`*^9, 3.817274784897727*^9}, {3.818844919365426*^9, 
   3.8188449676635256`*^9}, {3.8188450369460497`*^9, 3.8188450524777555`*^9}},
 CellLabel->
  "In[482]:=",ExpressionUUID->"2eae0e8c-1e0c-4c86-9a91-dc314fcdcc03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Saving Mathematica .m file", "Chapter",
 FontSize->36]], "Chapter",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.813499782848096*^9}, {3.813500130542923*^9, 
  3.8135001629185205`*^9}, {3.8135789848781996`*^9, 3.8135790332573433`*^9}, {
  3.813579143986269*^9, 3.8135791654381247`*^9}, {3.8140861592886915`*^9, 
  3.8140861813430047`*^9}, {3.8171192507401466`*^9, 3.81711926018217*^9}},
 CellTags->"Title",ExpressionUUID->"f5a04d98-c0c6-4f81-a278-8c8211feed42"],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<Voigt_functions_general.m\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "s", ",", "kk", ",", "\[Theta]2", ",", "cs", ",", "c\[Theta]2", ",", 
     "\[IndentingNewLine]", "                               ", "Gauss", ",", 
     "Gauss2", ",", "FTGauss", ",", "GaussTable", ",", "Gaussfwhm", ",", 
     "FTGaussfwhm", ",", "GaussIB", ",", "Sigma", ",", "\[IndentingNewLine]", 
     "                               ", "Lorentz", ",", "LorentzTable", ",", 
     "FTLorentz", ",", "Lorentzfwhm", ",", "FTLorentzfwhm", ",", "LorentzIB", 
     ",", "Delta", ",", "\[IndentingNewLine]", 
     "                               ", "Voigt", ",", "FTVoigt", ",", 
     "VoigtTable", ",", "Voigtfwhm", ",", "FTVoigtfwhm", ",", "VoigtIB", ",", 
     "VoigtIB2", ",", "\[IndentingNewLine]", 
     "                               ", "fwhmcalc", ",", 
     "\[IndentingNewLine]", "                               ", "VoigtApprox", 
     ",", "VoigtApproxTable", ",", "\[IndentingNewLine]", 
     "                               ", "Mix", ",", "TCHPseudoVoigt", ",", 
     "TCHPseudoVoigtTable", ",", "Sigma\[Theta]", ",", "Delta\[Theta]", ",", 
     "\[IndentingNewLine]", "                               ", "PVoigt", ",", 
     "PVoigt2", ",", "PVoigtTable", ",", "FTPVoigt", ",", 
     "\[IndentingNewLine]", "                               ", 
     "fourierData"}], "\[IndentingNewLine]", "     ", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8171192933841333`*^9, 3.8171193609993525`*^9}, {
   3.8171194508439407`*^9, 3.8171195811042337`*^9}, {3.817119653202878*^9, 
   3.8171197939875903`*^9}, 3.8171200543653073`*^9, {3.8171204126886873`*^9, 
   3.817120424018894*^9}, {3.819959091677175*^9, 3.8199590978508425`*^9}, {
   3.824284625190239*^9, 3.82428462633111*^9}, {3.824297663445962*^9, 
   3.824297664617652*^9}, {3.8243562566532745`*^9, 3.8243562581069603`*^9}, {
   3.824639530305683*^9, 3.824639530852498*^9}, {3.824956276051464*^9, 
   3.8249562774110394`*^9}, 3.824973450656932*^9, {3.8251326942570763`*^9, 
   3.8251327109133434`*^9}, {3.8274752882380743`*^9, 
   3.8274752918767176`*^9}, {3.827915276136385*^9, 3.827915277487867*^9}, {
   3.8279157409471736`*^9, 3.827915742220453*^9}, {3.8280906738516097`*^9, 
   3.8280906955161905`*^9}, {3.8281544285894327`*^9, 3.828154436426735*^9}, {
   3.8281546647320023`*^9, 3.8281546662142067`*^9}},
 CellLabel->
  "In[484]:=",ExpressionUUID->"bb1d3a95-3f7d-471e-994f-f4a04626ede4"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{"L", " ", "2", " ", "Pi"}], "]"}]}], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], 
          SuperscriptBox[
           RowBox[{"(", " ", 
            RowBox[{"L", " ", "2", " ", "Pi"}], ")"}], "2"], " "}], "2"]}]], "==", 
      RowBox[{"1", "/", "2"}]}], ",", "L"}], "]"}], "//", "FullSimplify"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8280920034071846`*^9, 3.8280920242653313`*^9}, {
   3.8280920554259396`*^9, 3.8280921757899446`*^9}, 3.828092235876051*^9, {
   3.828092307514329*^9, 3.8280923629512043`*^9}, {3.8280924188006124`*^9, 
   3.8280924379048147`*^9}, {3.8280924715711036`*^9, 
   3.8280925148857913`*^9}, {3.828092546258075*^9, 3.8280925560413437`*^9}, {
   3.828092587394515*^9, 3.8280926625197687`*^9}, {3.828092834567655*^9, 
   3.8280928370952873`*^9}, {3.8281550899348*^9, 3.8281550906893806`*^9}},
 CellLabel->
  "In[485]:=",ExpressionUUID->"44cc83a5-fd38-4da1-a7ca-d11f8a9dd07f"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{"L", " ", "2", " ", "Pi"}], "]"}]}], " ", "a"}]], 
      "\[Equal]", 
      FractionBox["1", "2"]}], ",", "L"}], "]"}], "//", "FullSimplify"}], " ",
   "*)"}]], "Input",
 CellChangeTimes->{{3.828154476754978*^9, 3.8281545554331646`*^9}},
 CellLabel->
  "In[486]:=",ExpressionUUID->"e8f0c5cb-a25f-4192-9011-cf69029c76ed"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1452, 951},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
Magnification:>1.25 Inherited,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c26b8973-d7ef-4e27-8f67-621b9c00bb54"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Title"->{
  Cell[580, 22, 313, 4, 121, "Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a",
   CellTags->"Title"],
  Cell[896, 28, 542, 7, 105, "Title",ExpressionUUID->"b1b247d9-e08c-4ac2-b206-3c3f097ef3a1",
   CellTags->"Title"],
  Cell[7160, 179, 562, 7, 105, "Title",ExpressionUUID->"d0e4b628-b487-47bb-8760-390da9407c49",
   CellTags->"Title"],
  Cell[16922, 427, 513, 6, 105, "Title",ExpressionUUID->"b7e5a630-108c-486a-b32f-70e9e67b13c4",
   CellTags->"Title"],
  Cell[22569, 572, 555, 7, 105, "Title",ExpressionUUID->"bde64921-d385-444d-b2ee-4dd4e642f830",
   CellTags->"Title"],
  Cell[36367, 925, 771, 13, 133, "Title",ExpressionUUID->"639caf54-b21f-4622-883b-cee5decd1311",
   CellTags->"Title"],
  Cell[43902, 1117, 720, 10, 105, "Title",ExpressionUUID->"163d7f9b-4568-46fe-99e0-ad9f578eebc3",
   CellTags->"Title"],
  Cell[56513, 1392, 375, 5, 105, "Title",ExpressionUUID->"684c1a57-90ca-426a-a14a-c1142be9e495",
   CellTags->"Title"],
  Cell[58183, 1441, 445, 5, 105, "Title",ExpressionUUID->"a979a3a1-153e-443a-a45b-1477e444ea0b",
   CellTags->"Title"],
  Cell[61536, 1515, 639, 9, 88, "Chapter",ExpressionUUID->"9e37cdf2-0d05-485e-8717-39e66853afb5",
   CellTags->"Title"],
  Cell[66859, 1631, 680, 9, 88, "Chapter",ExpressionUUID->"f5a04d98-c0c6-4f81-a278-8c8211feed42",
   CellTags->"Title"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Title", 72331, 1749}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 313, 4, 121, "Title",ExpressionUUID->"7995810e-50f3-4fa3-b6f9-1e105911130a",
 CellTags->"Title"],
Cell[896, 28, 542, 7, 105, "Title",ExpressionUUID->"b1b247d9-e08c-4ac2-b206-3c3f097ef3a1",
 CellTags->"Title"],
Cell[1441, 37, 1347, 30, 53, "Input",ExpressionUUID->"e4c31daf-f6e7-44eb-96d5-a439bfa598db"],
Cell[2791, 69, 727, 17, 35, "Input",ExpressionUUID->"a488047f-3e6a-4e9f-b3ca-c98cbba42186"],
Cell[3521, 88, 960, 22, 53, "Input",ExpressionUUID->"acb57c99-40fb-487e-9091-f6fcceeee589"],
Cell[4484, 112, 1565, 36, 53, "Input",ExpressionUUID->"13f904a3-c3cf-40c0-8fd4-e1d1d54fa193"],
Cell[6052, 150, 1071, 24, 35, "Input",ExpressionUUID->"f02565a8-b4cf-481e-a64b-656c857224e1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7160, 179, 562, 7, 105, "Title",ExpressionUUID->"d0e4b628-b487-47bb-8760-390da9407c49",
 CellTags->"Title"],
Cell[7725, 188, 1213, 31, 56, "Input",ExpressionUUID->"0874c1fa-303d-45be-9466-d934a08862a0"],
Cell[8941, 221, 1300, 36, 69, "Input",ExpressionUUID->"badf184d-6803-4970-b4f1-5f30a7877daf"],
Cell[10244, 259, 1261, 22, 35, "Input",ExpressionUUID->"29d4c8bf-2a7f-4d7d-ab1f-aa289bf581df"],
Cell[11508, 283, 499, 13, 35, "Input",ExpressionUUID->"99ec9406-5abf-442e-b64a-ca9686bcf9b5"],
Cell[12010, 298, 952, 20, 40, "Input",ExpressionUUID->"9b9f243b-a52e-42ca-82a8-f7b6f24e3165"],
Cell[12965, 320, 1436, 37, 139, "Input",ExpressionUUID->"9aeab83c-4e00-422d-9600-5e5665e44a86"],
Cell[14404, 359, 673, 14, 59, "Input",ExpressionUUID->"18ccfb01-4d08-460f-9979-537a410fbe40"],
Cell[15080, 375, 1056, 25, 62, "Input",ExpressionUUID->"09646820-832a-468c-aac9-de82bdc3fc01"],
Cell[16139, 402, 177, 3, 35, "Input",ExpressionUUID->"eca7e658-6996-40d7-9f38-14dbc89e2e62"],
Cell[16319, 407, 566, 15, 50, "Input",ExpressionUUID->"97d529f0-2459-40c0-be08-6b91c18d3357"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16922, 427, 513, 6, 105, "Title",ExpressionUUID->"b7e5a630-108c-486a-b32f-70e9e67b13c4",
 CellTags->"Title"],
Cell[17438, 435, 954, 26, 66, "Input",ExpressionUUID->"af94b793-67f8-49be-b392-3910f9946037"],
Cell[18395, 463, 1091, 20, 35, "Input",ExpressionUUID->"10efed5c-1053-4cf7-9b07-ae6126543a81"],
Cell[19489, 485, 652, 15, 35, "Input",ExpressionUUID->"c92e544f-a100-420b-bbbc-ff2c5de90c14"],
Cell[20144, 502, 627, 14, 37, "Input",ExpressionUUID->"afbe93a1-7258-4b50-9df4-fb9aa7ba4fbc"],
Cell[20774, 518, 833, 22, 116, "Input",ExpressionUUID->"dcf5a5e7-06dd-428a-a337-a636db6d4f4e"],
Cell[21610, 542, 413, 10, 53, "Input",ExpressionUUID->"7695e8d1-823a-4254-8d1b-ee4b47fdfbe3"],
Cell[22026, 554, 506, 13, 39, "Input",ExpressionUUID->"7a1c223a-aba3-4b22-ac4c-26dce77ae9b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22569, 572, 555, 7, 105, "Title",ExpressionUUID->"bde64921-d385-444d-b2ee-4dd4e642f830",
 CellTags->"Title"],
Cell[23127, 581, 1254, 34, 88, "Input",ExpressionUUID->"b1d26e04-4930-460b-80a6-0562addd054e"],
Cell[24384, 617, 1344, 29, 40, "Input",ExpressionUUID->"4eb79771-258c-438c-96f3-8df27753d5c7"],
Cell[25731, 648, 1443, 31, 60, "Input",ExpressionUUID->"8c507082-c739-408f-b56b-4a0c6b66cd0d"],
Cell[27177, 681, 2392, 65, 161, "Input",ExpressionUUID->"7f5b3f6a-0499-4afb-a7e0-7bc0a9f5c74c"],
Cell[29572, 748, 942, 23, 64, "Input",ExpressionUUID->"1035bd92-c64d-4412-9004-6fda1d749fc4"],
Cell[30517, 773, 580, 11, 99, "Text",ExpressionUUID->"29ea16b9-4633-45df-8201-3e16ae9fe076"],
Cell[31100, 786, 4463, 116, 204, "Input",ExpressionUUID->"1d6716fe-61f5-4919-87a0-56c7474d7b85"],
Cell[35566, 904, 764, 16, 35, "Input",ExpressionUUID->"e8e6e415-19b7-441a-a5b2-a6becf9945b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36367, 925, 771, 13, 133, "Title",ExpressionUUID->"639caf54-b21f-4622-883b-cee5decd1311",
 CellTags->"Title"],
Cell[37141, 940, 1959, 50, 210, "Input",ExpressionUUID->"89be03e1-29c8-454b-8752-af15cea84848"],
Cell[39103, 992, 2496, 65, 214, "Input",ExpressionUUID->"ef1f31ca-3ce6-4def-b892-2735302fb168"],
Cell[41602, 1059, 561, 9, 35, "Input",ExpressionUUID->"58434e1f-4a2b-4755-ad10-b9605d8da381"],
Cell[42166, 1070, 898, 23, 60, "Input",ExpressionUUID->"e7104af1-ce41-4f1e-bfb6-7c7683ef88d3"],
Cell[43067, 1095, 798, 17, 35, "Input",ExpressionUUID->"65870b43-076d-42e8-8459-39f4c3aab939"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43902, 1117, 720, 10, 105, "Title",ExpressionUUID->"163d7f9b-4568-46fe-99e0-ad9f578eebc3",
 CellTags->"Title"],
Cell[44625, 1129, 5330, 127, 151, "Input",ExpressionUUID->"fc400c0a-44ba-4ab1-821b-6e87a6e14297"],
Cell[49958, 1258, 5238, 96, 68, "Input",ExpressionUUID->"37f95d17-1e85-422b-877f-236f74753693"],
Cell[55199, 1356, 1277, 31, 108, "Input",ExpressionUUID->"514ebfbe-77bf-4662-90f3-ff4aebf36d30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56513, 1392, 375, 5, 105, "Title",ExpressionUUID->"684c1a57-90ca-426a-a14a-c1142be9e495",
 CellTags->"Title"],
Cell[56891, 1399, 1255, 37, 60, "Input",ExpressionUUID->"830d5b40-81ec-4e0e-8adb-fda80c540ddb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58183, 1441, 445, 5, 105, "Title",ExpressionUUID->"a979a3a1-153e-443a-a45b-1477e444ea0b",
 CellTags->"Title"],
Cell[58631, 1448, 2116, 44, 116, "Input",ExpressionUUID->"279ae50a-95ad-4e7f-bab0-0499d2f58ab5"],
Cell[60750, 1494, 761, 17, 35, "Input",ExpressionUUID->"13dae483-e99d-47eb-bdb2-0793e8dd17ab"],
Cell[CellGroupData[{
Cell[61536, 1515, 639, 9, 88, "Chapter",ExpressionUUID->"9e37cdf2-0d05-485e-8717-39e66853afb5",
 CellTags->"Title"],
Cell[62178, 1526, 4644, 100, 228, "Input",ExpressionUUID->"2eae0e8c-1e0c-4c86-9a91-dc314fcdcc03"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66859, 1631, 680, 9, 88, "Chapter",ExpressionUUID->"f5a04d98-c0c6-4f81-a278-8c8211feed42",
 CellTags->"Title"],
Cell[67542, 1642, 2475, 38, 252, "Input",ExpressionUUID->"bb1d3a95-3f7d-471e-994f-f4a04626ede4"],
Cell[70020, 1682, 1203, 28, 55, "Input",ExpressionUUID->"44cc83a5-fd38-4da1-a7ca-d11f8a9dd07f"],
Cell[71226, 1712, 551, 16, 42, "Input",ExpressionUUID->"e8f0c5cb-a25f-4192-9011-cf69029c76ed"]
}, Open  ]]
}, Open  ]]
}
]
*)

