(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     58876,       1372]
NotebookOptionsPosition[     56389,       1314]
NotebookOutlinePosition[     57639,       1350]
CellTagsIndexPosition[     57570,       1345]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Size/shape functions",
 FontSize->72]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
   3.794473182921484*^9, 3.794473193906823*^9}, 3.797331640127709*^9, {
   3.797653041984359*^9, 3.797653047469375*^9}, {3.809154956980171*^9, 
   3.8091549665393624`*^9}, {3.8110547048196044`*^9, 3.811054732781788*^9}, {
   3.8171957101580353`*^9, 3.8171957149709253`*^9}},
 CellTags->"Title",ExpressionUUID->"164cce3e-b849-403d-aceb-97cf924b3ff6"],

Cell[TextData[StyleBox["Lognormal distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.809154985974642*^9, 3.809154991076743*^9}, {3.8102750828990383`*^9, 
  3.8102750904146776`*^9}},
 CellTags->"Title",ExpressionUUID->"e2287e95-7869-4be2-a9ef-ad7246c7240d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"G", "[", 
    RowBox[{"d_", ",", "\[Mu]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   RowBox[{"Piecewise", " ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0.", ",", 
        RowBox[{"d", "<=", "0"}]}], "}"}], "}"}], ",", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Log", "[", "d", "]"}], "-", "\[Mu]"}], ")"}], "2"], 
         RowBox[{"2", "*", 
          SuperscriptBox["\[Sigma]", "2"]}]]}]], "/", 
      RowBox[{"(", 
       RowBox[{"d", " ", "\[Sigma]", " ", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{"2", " ", "\[Pi]"}], ")"}]}]}], ")"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dmean", "[", 
    RowBox[{"\[Mu]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[Mu]", "+", 
     FractionBox[
      SuperscriptBox["\[Sigma]", "2"], "2"]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sd", "[", 
    RowBox[{"\[Mu]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"2", "\[Mu]"}], "+", 
        SuperscriptBox["\[Sigma]", "2"]}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         SuperscriptBox["\[Sigma]", "2"]], "-", "1"}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LV", "[", 
    RowBox[{"\[Mu]_", ",", "\[Sigma]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "/", "4"}], ")"}], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[Mu]", "+", 
      FractionBox[
       RowBox[{"7", 
        SuperscriptBox["\[Sigma]", "2"]}], "2"]}]]}]}], ";"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQ3foo5VtS4hvHiiVHGZOBtN2e6EwQvevwlBwQHcP0
sQBEG23fVAeiH/bWTATRIRGuU0C0iorLDBAtka68AET/6Vi0DUS73T4KpmcH
HP2VAqQXHDz7B0Sb/xPnSgXSU16t4AXRTj/WS4BoFuH7ciD6pI+1Mog+0Vqp
AaKfq6vpgegonzJTEO0VoCTbBaRnOe5QBNFGQu5LQPS6lGww/XLF+pqpQLp8
rWojiL5sKtABog9t1+oC0Tu+/3ecBqS5vjM6gWgFprdeIFqo4QeYTpwpsIcp
9Y1j61qTfSD6jalAKTeQXpA5eQKIBgAdsZTM
  "],
 CellLabel->
  "In[368]:=",ExpressionUUID->"1a1327d8-cedc-4b0f-a1b7-db26bc48538e"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"G", "[", 
     RowBox[{"x", ",", "1", ",", "0.5"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.809257687945459*^9, 3.809257785759603*^9}, {
  3.8101111222005816`*^9, 3.8101111516231318`*^9}, {3.817195751739021*^9, 
  3.817195754614205*^9}},
 CellLabel->
  "In[372]:=",ExpressionUUID->"6bec88db-87a4-42e4-aa2f-134ffd35413f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["FT of size distribution", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.809159709373041*^9, 3.8091597165513396`*^9}},
 CellTags->"Title",ExpressionUUID->"6c206687-332d-421d-86c4-42764b2c19e5"],

Cell[BoxData[
 RowBox[{" ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FTAgen", "[", 
     RowBox[{
     "type_", ",", " ", "L_", ",", "d_", ",", "h_", ",", "k_", ",", "l_"}], 
     "]"}], ":=", 
    RowBox[{"Piecewise", " ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"1.", ",", 
         RowBox[{"L", "==", "0"}]}], "}"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "=", 
           RowBox[{"\[Sqrt]", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["h", "2"], "+", 
              SuperscriptBox["k", "2"], "+", 
              SuperscriptBox["l", "2"]}], ")"}]}]}], ",", 
          RowBox[{"A", "=", 
           RowBox[{"h", "/", "t"}]}], ",", 
          RowBox[{"B", "=", 
           RowBox[{"k", "/", "t"}]}], ",", 
          RowBox[{"C", "=", 
           RowBox[{"l", "/", "t"}]}], " ", ",", 
          RowBox[{"H", "=", 
           RowBox[{"Range", "[", "4", "]"}]}], ",", " ", 
          RowBox[{"K", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "  ", 
        RowBox[{
         RowBox[{"Which", "[", 
          RowBox[{
           RowBox[{"type", "==", "\"\<sphere\>\""}], ",", 
           "                                           ", 
           RowBox[{"{", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
             "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "=", 
              RowBox[{"-", "1.5"}]}], ",", "                      ", 
             "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "=", "0"}], ",", 
             "                            ", "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "=", 
              RowBox[{"1", "/", "2"}]}], ",", "                       ", 
             "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{"K", "            ", "=", " ", "1"}]}], "}"}], ",", 
           "\[IndentingNewLine]", "             ", 
           RowBox[{"type", "==", "\"\<cube\>\""}], ",", 
           "                                                ", 
           RowBox[{"{", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
             "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "=", 
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{"A", "+", "B", "+", "C"}], ")"}]}]}], ",", "       ", 
             "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "=", 
              RowBox[{
               RowBox[{"A", " ", "B"}], " ", "+", " ", 
               RowBox[{"B", " ", "C"}], " ", "+", " ", 
               RowBox[{"C", " ", "A"}]}]}], ",", "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{
              RowBox[{"H", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "=", 
              RowBox[{
               RowBox[{"-", "A"}], " ", "B", " ", "C"}]}], ",", 
             "                                  ", "\[IndentingNewLine]", 
             "                                                                \
                                ", 
             RowBox[{"K", "             ", "=", " ", "A"}]}], "}"}], ",", 
           "\[IndentingNewLine]", "             ", 
           RowBox[{"type", "==", "\"\<tetrahedron\>\""}], ",", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"A", "\[GreaterEqual]", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", "C"}], ")"}]}], ",", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "=", 
                RowBox[{
                 RowBox[{"-", "3"}], " ", 
                 RowBox[{"\[Sqrt]", "2"}], "A"}]}], ",", "      ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "=", 
                RowBox[{"6", " ", 
                 SuperscriptBox["A", "2"]}]}], ",", "              ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "=", 
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"\[Sqrt]", "2"}], 
                 SuperscriptBox["A", "3"]}]}], ",", "                 ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{"K", "=", 
                RowBox[{
                 RowBox[{"\[Sqrt]", "2"}], "A"}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                             ", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "=", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"3", 
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", "2"}], ")"}]}], ")"}]}]}], ",", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "=", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}], "2"]}], ")"}], 
                  "/", "2"}], ")"}]}], ",", "  ", "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "=", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}], "3"], "/", 
                   RowBox[{"(", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sqrt]", "2"}]}], ")"}]}], ")"}]}]}], ",", 
               "      ", "\[IndentingNewLine]", 
               "                                                              \
                                ", 
               RowBox[{"K", "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"\[Sqrt]", "2"}], ")"}]}]}]}], "}"}]}], "    ", 
            "]"}], ",", "\[IndentingNewLine]", "               ", 
           RowBox[{"type", "==", "\"\<octahedron\>\""}], ",", "   ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"A", "\[GreaterEqual]", " ", 
              RowBox[{"(", 
               RowBox[{"B", "+", "C"}], ")"}]}], ",", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "=", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"3", " ", "A"}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"\[Sqrt]", "2"}], ")"}]}], ")"}]}]}], ",", 
               "      ", "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "=", 
                RowBox[{"(", 
                 RowBox[{"3", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["A", "2"], "-", 
                    SuperscriptBox["B", "2"], "-", 
                    SuperscriptBox["C", "2"]}], ")"}], "/", "2"}]}], ")"}]}], 
               ",", "              ", "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    SuperscriptBox["A", "3"]}], "+", 
                   RowBox[{"3", " ", "A", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["B", "2"], "+", 
                    SuperscriptBox["C", "2"]}], ")"}]}], "+", 
                   RowBox[{"2", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["B", "3"], "+", 
                    SuperscriptBox["C", "3"]}], ")"}]}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"2", " ", 
                   RowBox[{"\[Sqrt]", "2"}]}], ")"}]}]}], ",", 
               "                 ", "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{"K", "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"\[Sqrt]", "2"}], ")"}]}]}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             "                                                                \
                             ", 
             RowBox[{"{", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "=", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"3", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", 
                    RowBox[{"\[Sqrt]", "2"}]}], ")"}]}]}], ")"}]}]}], ",", 
               "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "=", 
                RowBox[{"-", 
                 RowBox[{"(", 
                  RowBox[{"3", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["A", "2"], "+", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"B", "-", "C"}], ")"}], "2"], "-", 
                    RowBox[{"2", "A", 
                    RowBox[{"(", 
                    RowBox[{"B", "+", "C"}], ")"}]}]}], ")"}], "/", "4"}]}], 
                  ")"}]}]}], ",", "  ", "\[IndentingNewLine]", 
               "                                                              \
                               ", 
               RowBox[{
                RowBox[{"H", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "=", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["A", "3"], "+", " ", 
                    SuperscriptBox["B", "3"], "+", 
                    SuperscriptBox["C", "3"], "-", " ", 
                    RowBox[{"3", " ", "A", " ", "B", " ", "C"}]}], ")"}], "/",
                   " ", 
                  RowBox[{"\[Sqrt]", "2"}]}], ")"}]}], ",", "      ", 
               "\[IndentingNewLine]", 
               "                                                              \
                                ", 
               RowBox[{"K", "=", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"\[Sqrt]", "2"}], ")"}]}]}]}], "}"}]}], "    ", 
            "]"}]}], "\[IndentingNewLine]", "           ", "]"}], ";", 
         "\[IndentingNewLine]", "         ", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", 
             RowBox[{"[", "n", "]"}], "]"}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Abs", "[", "L", "]"}], "/", "d"}], ")"}], "n"]}], ",", 
           RowBox[{"{", 
            RowBox[{"n", ",", "0", ",", "3"}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "        ", "]"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "  "}]], "Input",
 CellChangeTimes->{{3.809321430697323*^9, 3.809321440910252*^9}, {
   3.8093217964490113`*^9, 3.8093217999175777`*^9}, 3.8093257290942497`*^9, {
   3.8093284586569023`*^9, 3.809328475176261*^9}, {3.809328575794211*^9, 
   3.8093286693227835`*^9}, {3.809332148014536*^9, 3.809332152097257*^9}, {
   3.8093366280736523`*^9, 3.8093367385245914`*^9}, {3.809336981248112*^9, 
   3.809337032395867*^9}, {3.809337356673783*^9, 3.809337463728775*^9}, {
   3.809337748915701*^9, 3.8093378155451126`*^9}, {3.809337880803422*^9, 
   3.8093378818850417`*^9}, {3.8093379455677586`*^9, 3.809337945984865*^9}, {
   3.809338032986615*^9, 3.8093381956879416`*^9}, {3.8093383047626376`*^9, 
   3.809338306044959*^9}, {3.8093385210296597`*^9, 3.8093385451911535`*^9}, {
   3.8093387237836437`*^9, 3.8093387561969547`*^9}, 3.8093388024733124`*^9, {
   3.8093388354200425`*^9, 3.809338839161007*^9}, 3.809338892551105*^9, {
   3.8093389807628727`*^9, 3.809339007878353*^9}, {3.8100183437662573`*^9, 
   3.8100184116286993`*^9}, {3.8100185046963844`*^9, 
   3.8100185300623035`*^9}, {3.810018563277335*^9, 3.810018602307501*^9}, {
   3.8100192066818905`*^9, 3.8100194454947767`*^9}, {3.8100194777598066`*^9, 
   3.810019775509309*^9}, {3.8100198710221663`*^9, 3.810020209677538*^9}, {
   3.8100239333066344`*^9, 3.810024129741727*^9}, {3.8100245985060053`*^9, 
   3.810024747977311*^9}, {3.810027214387453*^9, 3.810027222794116*^9}, 
   3.8100275851675987`*^9, 3.810027715172715*^9, {3.810030270039501*^9, 
   3.8100302997795143`*^9}, {3.810290070123413*^9, 3.8102900704359093`*^9}, {
   3.810293229564621*^9, 3.8102932354865103`*^9}, {3.8103071422627897`*^9, 
   3.8103071723106127`*^9}, {3.810307385365345*^9, 3.810307385505965*^9}, {
   3.8103074487583055`*^9, 3.810307458352625*^9}, {3.810307535276909*^9, 
   3.810307541089788*^9}, {3.810368173899581*^9, 3.810368186806031*^9}, {
   3.810368285729227*^9, 3.8103683076359673`*^9}, {3.810369176630658*^9, 
   3.8103692267409115`*^9}, {3.8243441736592045`*^9, 3.824344186801345*^9}, {
   3.824344248490509*^9, 3.8243442950752697`*^9}, {3.82434449607859*^9, 
   3.8243445269589252`*^9}, {3.824344635168456*^9, 3.824344636822961*^9}, {
   3.824344685240075*^9, 3.8243446874711637`*^9}, {3.824345674862524*^9, 
   3.8243457701104665`*^9}, {3.824345953059968*^9, 3.8243459697759314`*^9}, {
   3.824980530709463*^9, 
   3.824980548054283*^9}},ExpressionUUID->"04437e29-0d0d-4a57-b413-\
979bd47889e2"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FTASgen", "[", 
      RowBox[{
      "type_", ",", " ", "L_", ",", "\[Mu]_", ",", "\[Sigma]_", ",", "h_", 
       ",", "k_", ",", "l_"}], "]"}], ":=", 
     RowBox[{"Piecewise", " ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.", ",", 
          RowBox[{"L", "==", "0"}]}], "}"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t", "=", 
            RowBox[{"\[Sqrt]", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["h", "2"], "+", 
               SuperscriptBox["k", "2"], "+", 
               SuperscriptBox["l", "2"]}], ")"}]}]}], ",", 
           RowBox[{"A", "=", 
            RowBox[{"h", "/", "t"}]}], ",", 
           RowBox[{"B", "=", 
            RowBox[{"k", "/", "t"}]}], ",", 
           RowBox[{"C", "=", 
            RowBox[{"l", "/", "t"}]}], " ", ",", 
           RowBox[{"H", "=", 
            RowBox[{"Range", "[", "4", "]"}]}], ",", " ", 
           RowBox[{"K", "=", "1"}]}], "}"}], ",", "\[IndentingNewLine]", "  ", 
         RowBox[{
          RowBox[{"Which", "[", 
           RowBox[{
            RowBox[{"type", "==", "\"\<sphere\>\""}], ",", 
            "                                           ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "0", "]"}], "]"}], "=", "  ", "1"}], ",", " ", 
              "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "=", 
               RowBox[{"-", "1.5"}]}], ",", "                      ", 
              "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "=", "   ", "0"}], ",", 
              "                            ", "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "3", "]"}], "]"}], "=", "   ", "0.5"}], ",", 
              "                       ", "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{"K", "            ", "=", "   ", "1"}]}], "}"}], ",", 
            "\[IndentingNewLine]", "             ", 
            RowBox[{"type", "==", "\"\<cube\>\""}], ",", 
            "                                                ", 
            RowBox[{"{", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
              "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "=", 
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{"A", "+", "B", "+", "C"}], ")"}]}]}], ",", "       ",
               "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "=", 
               RowBox[{
                RowBox[{"A", " ", "B"}], " ", "+", " ", 
                RowBox[{"B", " ", "C"}], " ", "+", " ", 
                RowBox[{"C", " ", "A"}]}]}], ",", "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{
               RowBox[{"H", "[", 
                RowBox[{"[", "3", "]"}], "]"}], "=", 
               RowBox[{
                RowBox[{"-", "A"}], " ", "B", " ", "C"}]}], ",", 
              "                                  ", "\[IndentingNewLine]", 
              "                                                               \
                                 ", 
              RowBox[{"K", "             ", "=", " ", "A"}]}], "}"}], ",", 
            "\[IndentingNewLine]", "             ", 
            RowBox[{"type", "==", "\"\<tetrahedron\>\""}], ",", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"A", "\[GreaterEqual]", " ", 
               RowBox[{"(", 
                RowBox[{"B", "+", "C"}], ")"}]}], ",", 
              RowBox[{"{", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "=", 
                 RowBox[{
                  RowBox[{"-", "3"}], " ", 
                  RowBox[{"\[Sqrt]", "2"}], "A"}]}], ",", "      ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "=", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["A", "2"]}]}], ",", "              ", 
                "\[IndentingNewLine]", 
                
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "=", 
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  RowBox[{"\[Sqrt]", "2"}], 
                  SuperscriptBox["A", "3"]}]}], ",", "                 ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{"K", "=", 
                 RowBox[{
                  RowBox[{"\[Sqrt]", "2"}], "A"}]}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              "                                                               \
                              ", 
              RowBox[{"{", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "=", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", 
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"\[Sqrt]", "2"}], ")"}]}], ")"}]}]}], ",", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "=", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"3", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}], "2"]}], ")"}], 
                   "/", "2"}], ")"}]}], ",", "  ", "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "=", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}], "3"], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", " ", 
                    RowBox[{"\[Sqrt]", "2"}]}], ")"}]}], ")"}]}]}], ",", 
                "      ", "\[IndentingNewLine]", 
                "                                                             \
                                 ", 
                RowBox[{"K", "=", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", "2"}], ")"}]}]}]}], "}"}]}], "    ", 
             "]"}], ",", "\[IndentingNewLine]", "               ", 
            RowBox[{"type", "==", "\"\<octahedron\>\""}], ",", "   ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"A", "\[GreaterEqual]", " ", 
               RowBox[{"(", 
                RowBox[{"B", "+", "C"}], ")"}]}], ",", 
              RowBox[{"{", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "=", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"3", " ", "A"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"\[Sqrt]", "2"}], ")"}]}], ")"}]}]}], ",", 
                "      ", "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "=", 
                 RowBox[{"(", 
                  RowBox[{"3", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["A", "2"], "-", 
                    SuperscriptBox["B", "2"], "-", 
                    SuperscriptBox["C", "2"]}], ")"}], "/", "2"}]}], ")"}]}], 
                ",", "              ", "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "=", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["A", "3"]}], "+", 
                    RowBox[{"3", " ", "A", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["B", "2"], "+", 
                    SuperscriptBox["C", "2"]}], ")"}]}], "+", 
                    RowBox[{"2", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["B", "3"], "+", 
                    SuperscriptBox["C", "3"]}], ")"}]}]}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"2", " ", 
                    RowBox[{"\[Sqrt]", "2"}]}], ")"}]}]}], ",", 
                "                 ", "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{"K", "=", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", "2"}], ")"}]}]}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              "                                                               \
                              ", 
              RowBox[{"{", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "0", "]"}], "]"}], "=", "1"}], ",", " ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "=", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"3", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", 
                    RowBox[{"\[Sqrt]", "2"}]}], ")"}]}]}], ")"}]}]}], ",", 
                "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "=", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"3", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["A", "2"], "+", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"B", "-", "C"}], ")"}], "2"], "-", 
                    RowBox[{"2", "A", 
                    RowBox[{"(", 
                    RowBox[{"B", "+", "C"}], ")"}]}]}], ")"}], "/", "4"}]}], 
                   ")"}]}]}], ",", "  ", "\[IndentingNewLine]", 
                "                                                             \
                                ", 
                RowBox[{
                 RowBox[{"H", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "=", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["A", "3"], "+", " ", 
                    SuperscriptBox["B", "3"], "+", 
                    SuperscriptBox["C", "3"], "-", " ", 
                    RowBox[{"3", " ", "A", " ", "B", " ", "C"}]}], ")"}], "/",
                    " ", 
                   RowBox[{"\[Sqrt]", "2"}]}], ")"}]}], ",", "      ", 
                "\[IndentingNewLine]", 
                "                                                             \
                                 ", 
                RowBox[{"K", "=", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"A", "+", "B", "+", "C"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"\[Sqrt]", "2"}], ")"}]}]}]}], "}"}]}], "    ", 
             "]"}]}], "\[IndentingNewLine]", "           ", "]"}], ";", 
          "\[IndentingNewLine]", "         ", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"H", "[", 
              RowBox[{"[", "n", "]"}], "]"}], 
             RowBox[{"Erfc", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"Abs", "[", "L", "]"}], "  ", "K"}], "]"}], "-", 
                 "\[Mu]", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "-", "n"}], ")"}], 
                  SuperscriptBox["\[Sigma]", "2"]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"\[Sigma]", " ", 
                 RowBox[{"\[Sqrt]", "2"}]}], " ", ")"}]}], "]"}], 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"3", "-", "n"}], ")"}], "\[Mu]"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"3", "-", "n"}], ")"}], "2"], "/", "2"}], ")"}], 
                  " ", 
                  SuperscriptBox["\[Sigma]", "2"]}]}]], "/", 
               RowBox[{"(", 
                RowBox[{"2", " ", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{
                   RowBox[{"3", "\[Mu]"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"9", "/", "2"}], ")"}], " ", 
                    SuperscriptBox["\[Sigma]", "2"]}]}]]}], ")"}]}], ")"}], 
             SuperscriptBox[
              RowBox[{"Abs", "[", "L", "]"}], "n"]}], ",", 
            RowBox[{"{", 
             RowBox[{"n", ",", "0", ",", "3"}], "}"}]}], "]"}]}]}], 
        "\[IndentingNewLine]", "        ", "]"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "  ", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.809321430697323*^9, 3.809321440910252*^9}, {
   3.8093217964490113`*^9, 3.8093217999175777`*^9}, 3.8093257290942497`*^9, {
   3.8093284586569023`*^9, 3.809328475176261*^9}, {3.809328575794211*^9, 
   3.8093286693227835`*^9}, {3.809332148014536*^9, 3.809332152097257*^9}, {
   3.8093366280736523`*^9, 3.8093367385245914`*^9}, {3.809336981248112*^9, 
   3.809337032395867*^9}, {3.809337356673783*^9, 3.809337463728775*^9}, {
   3.809337748915701*^9, 3.8093378155451126`*^9}, {3.809337880803422*^9, 
   3.8093378818850417`*^9}, {3.8093379455677586`*^9, 3.809337945984865*^9}, {
   3.809338032986615*^9, 3.8093381956879416`*^9}, {3.8093383047626376`*^9, 
   3.809338306044959*^9}, {3.8093385210296597`*^9, 3.8093385451911535`*^9}, {
   3.8093387237836437`*^9, 3.8093387561969547`*^9}, 3.8093388024733124`*^9, {
   3.8093388354200425`*^9, 3.809338839161007*^9}, 3.809338892551105*^9, {
   3.8093389807628727`*^9, 3.809339007878353*^9}, {3.8100183437662573`*^9, 
   3.8100184116286993`*^9}, {3.8100185046963844`*^9, 
   3.8100185300623035`*^9}, {3.810018563277335*^9, 3.810018602307501*^9}, {
   3.8100192066818905`*^9, 3.8100194454947767`*^9}, {3.8100194777598066`*^9, 
   3.810019775509309*^9}, {3.8100198710221663`*^9, 3.810020209677538*^9}, {
   3.8100239333066344`*^9, 3.810024129741727*^9}, {3.8100245985060053`*^9, 
   3.810024747977311*^9}, {3.810027214387453*^9, 3.810027222794116*^9}, 
   3.8100275851675987`*^9, 3.810027715172715*^9, 3.810027817692258*^9, {
   3.8100278664754767`*^9, 3.8100279018046784`*^9}, {3.810027970760664*^9, 
   3.8100280587795544`*^9}, {3.8100281823776383`*^9, 3.8100282213634953`*^9}, 
   3.8100283332894845`*^9, {3.8100285812518215`*^9, 3.810028591439576*^9}, {
   3.8100295928674603`*^9, 3.810029600959309*^9}, {3.810030393264067*^9, 
   3.810030409783304*^9}, {3.8100304503992357`*^9, 3.8100304606883535`*^9}, {
   3.810290075873317*^9, 3.8102900761550555`*^9}, {3.810306800077434*^9, 
   3.8103068589701514`*^9}, {3.8103725887536373`*^9, 3.810372686271648*^9}, {
   3.810372718931958*^9, 3.810372775794881*^9}, 3.810372840308919*^9, {
   3.8103746827964487`*^9, 3.810374841831808*^9}, {3.8103748888252482`*^9, 
   3.81037490727104*^9}, {3.8103749391763105`*^9, 3.8103749474003897`*^9}, {
   3.8105278684752293`*^9, 3.8105278720031133`*^9}, {3.8105279130384245`*^9, 
   3.8105279370070295`*^9}, {3.8105351576358376`*^9, 
   3.8105351652923074`*^9}, {3.81055992654757*^9, 3.810559929803608*^9}, {
   3.810560015486322*^9, 3.8105600196893435`*^9}, {3.8105602364659543`*^9, 
   3.810560270317432*^9}, 3.810560576946109*^9, {3.81062800163302*^9, 
   3.8106280082107487`*^9}, {3.8106280453022265`*^9, 3.810628056145358*^9}, {
   3.824340857102558*^9, 3.824340863892719*^9}, 3.82434474942165*^9, {
   3.8243452696948137`*^9, 3.8243452723182373`*^9}, {3.8243457916901493`*^9, 
   3.824345793158428*^9}, {3.8243484265123835`*^9, 3.8243484278789105`*^9}, 
   3.82434875385944*^9, {3.8249805564464355`*^9, 
   3.8249805602543755`*^9}},ExpressionUUID->"5450824a-1287-40f1-94f5-\
3ff29ab4e6af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Microstrain models", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794732010842287*^9, 3.794732013217427*^9}, {3.7973316652578783`*^9, 
  3.797331667852068*^9}, {3.804507324713513*^9, 3.8045073284483347`*^9}, {
  3.809154985974642*^9, 3.809154991076743*^9}, {3.8102750828990383`*^9, 
  3.8102750904146776`*^9}, {3.814688710399637*^9, 3.8146887144567647`*^9}},
 CellTags->"Title",ExpressionUUID->"03b42d6b-7b24-48ba-9f18-8a821935c188"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ALDPAH", "[", 
     RowBox[{
     "L_", ",", "a0_", ",", "HH_", ",", "KK_", ",", "LL_", ",", "AA_", ",", 
      "BB_", ",", "aa_", ",", "bb_"}], "]"}], ":=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], 
      SuperscriptBox["\[Pi]", "2"], 
      FractionBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["HH", "2"], "+", 
         SuperscriptBox["KK", "2"], "+", 
         SuperscriptBox["LL", "2"]}], ")"}], 
       SuperscriptBox["a0", "2"]], 
      RowBox[{"(", 
       RowBox[{"AA", "+", 
        RowBox[{"BB", " ", 
         FractionBox[
          RowBox[{
           RowBox[{
            SuperscriptBox["HH", "2"], 
            SuperscriptBox["KK", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["KK", "2"], 
            SuperscriptBox["LL", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["LL", "2"], 
            SuperscriptBox["HH", "2"]}]}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["HH", "2"], "+", 
             SuperscriptBox["KK", "2"], "+", 
             SuperscriptBox["LL", "2"]}], ")"}], "2"]]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"aa", " ", 
         RowBox[{"Abs", "[", "L", "]"}]}], "+", 
        RowBox[{"bb", " ", 
         SuperscriptBox["L", "2"]}]}], ")"}]}]]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "for", " ", "a", " ", "PAH", " ", "model", " ", "of", " ", "microstrain"}],
    " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"WPLTPAH", "[", 
     RowBox[{
     "L_", ",", "HH_", ",", "KK_", ",", "LL_", ",", "AA_", ",", "BB_", ",", 
      "aa_", ",", "bb_"}], "]"}], ":=", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"AA", "+", 
         RowBox[{"BB", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["HH", "2"], 
               SuperscriptBox["KK", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["KK", "2"], 
               SuperscriptBox["LL", "2"]}], "+", 
              RowBox[{
               SuperscriptBox["LL", "2"], 
               SuperscriptBox["HH", "2"]}]}], ")"}], "/", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["HH", "2"], "+", 
               SuperscriptBox["KK", "2"], "+", 
               SuperscriptBox["LL", "2"]}], ")"}], "2"]}], ")"}]}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"aa", " ", "L"}], "+", 
         RowBox[{"bb", " ", 
          SuperscriptBox["L", "2"]}]}], ")"}]}], ")"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "for", " ", "a", " ", "PAH", " ", "model", " ", "of", " ", "microstrain"}],
    " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FWILK", "[", 
    RowBox[{"L_", ",", "RRe_"}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"L", ">", "0"}], "&&", 
      RowBox[{"L", "\[LessEqual]", "RRe"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", 
        RowBox[{"L", "/", "RRe"}], "]"}]}], "+", 
      RowBox[{"7", "/", "4"}], "-", 
      RowBox[{"Log", "[", "2", "]"}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"L", "/", "RRe"}], ")"}], "2"], "/", "6"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"32", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"L", "/", "RRe"}], ")"}], "3"]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"225", " ", "\[Pi]"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"512", "/", 
       RowBox[{"(", 
        RowBox[{"90", " ", "\[Pi]", 
         RowBox[{"(", 
          RowBox[{"L", "/", "RRe"}], ")"}]}], " ", ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", "/", "24"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], 
          RowBox[{"Log", "[", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{"L", "/", "RRe"}], ")"}]}], "]"}]}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "/", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"L", "/", "RRe"}], ")"}], "2"]}], ")"}]}]}]}], "]"}]}], 
  ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Wilkens", " ", "function", " ", "for", " ", "dislocation", " ", 
    "microstrain", " ", "broadening", " ", "model"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ALDWILK", "[", 
    RowBox[{
    "L_", ",", "a0_", ",", "HH_", ",", "KK_", ",", "LL_", ",", "AA_", ",", 
     "BB_", ",", "\[Rho]_", ",", "RRe_", ",", "bu_"}], "]"}], ":=", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], 
     SuperscriptBox["\[Pi]", "2"], 
     FractionBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["HH", "2"], "+", 
        SuperscriptBox["KK", "2"], "+", 
        SuperscriptBox["LL", "2"]}], ")"}], 
      SuperscriptBox["a0", "2"]], 
     RowBox[{"(", 
      RowBox[{"AA", "+", 
       RowBox[{"BB", " ", 
        FractionBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["HH", "2"], 
           SuperscriptBox["KK", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["KK", "2"], 
           SuperscriptBox["LL", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["LL", "2"], 
           SuperscriptBox["HH", "2"]}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["HH", "2"], "+", 
            SuperscriptBox["KK", "2"], "+", 
            SuperscriptBox["LL", "2"]}], ")"}], "2"]]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        SuperscriptBox["bu", "2"], 
        RowBox[{"4", "\[Pi]"}]], "\[Rho]", " ", 
       SuperscriptBox["L", "2"], 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"L", "\[Equal]", "0"}], ",", "0", ",", 
         RowBox[{"FWILK", "[", 
          RowBox[{
           RowBox[{"Abs", "[", "L", "]"}], ",", "RRe"}], "]"}]}], "]"}]}], 
      ")"}]}]]}], ";", 
  RowBox[{"(*", " ", 
   RowBox[{
   "for", " ", "Wilkens", " ", "model", " ", "of", " ", "microstrain"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"WPLTWILK", "[", 
    RowBox[{
    "L_", ",", "HH_", ",", "KK_", ",", "LL_", ",", "AA_", ",", "BB_", ",", 
     "\[Rho]_", ",", "RRe_", ",", "bu_"}], "]"}], ":=", 
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"AA", "+", 
        RowBox[{"BB", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["HH", "2"], 
              SuperscriptBox["KK", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["KK", "2"], 
              SuperscriptBox["LL", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["LL", "2"], 
              SuperscriptBox["HH", "2"]}]}], ")"}], "/", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["HH", "2"], "+", 
              SuperscriptBox["KK", "2"], "+", 
              SuperscriptBox["LL", "2"]}], ")"}], "2"]}], ")"}]}]}], ")"}], 
      " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["bu", "2"], "/", 
          RowBox[{"(", 
           RowBox[{"4", "\[Pi]"}], ")"}]}], ")"}], "\[Rho]", " ", 
        SuperscriptBox["L", "2"], 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"L", "\[Equal]", "0"}], ",", "0", ",", 
          RowBox[{"FWILK", "[", 
           RowBox[{"L", ",", "RRe"}], "]"}]}], "]"}]}], ")"}]}], ")"}]}]}], 
  ";", "    ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "for", " ", "Wilkens", " ", "model", " ", "of", " ", "microstrain"}], " ", 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.810628084482506*^9, 3.8106281694173636`*^9}, {
   3.810628199509118*^9, 3.8106282085598507`*^9}, 3.8106284326946115`*^9, {
   3.810628834569597*^9, 3.810628869202668*^9}, {3.810629237802969*^9, 
   3.8106293050339026`*^9}, 3.8113926706316566`*^9, {3.8119302543433332`*^9, 
   3.8119303805912356`*^9}, {3.8119306906599903`*^9, 3.811930732653577*^9}, {
   3.811930839715717*^9, 3.811931036960427*^9}, {3.811931296084023*^9, 
   3.811931296723381*^9}, {3.8119314755443745`*^9, 3.811931518319768*^9}, {
   3.8119315483319206`*^9, 3.811931565204464*^9}, {3.81212811397147*^9, 
   3.8121281178257036`*^9}, {3.812128568635559*^9, 3.8121285687785883`*^9}, {
   3.8121505578450856`*^9, 3.8121505602030993`*^9}, {3.812152381076289*^9, 
   3.8121524346409903`*^9}, {3.812152508416998*^9, 3.8121525293282223`*^9}, 
   3.8121525715757647`*^9, {3.8121527045710845`*^9, 3.8121527217610345`*^9}, {
   3.8121527953967924`*^9, 3.812152802286654*^9}, {3.812152882558959*^9, 
   3.812152899925852*^9}, {3.8121544281492376`*^9, 3.8121546207028213`*^9}, {
   3.8121548980609026`*^9, 3.81215495986679*^9}, {3.8121549914520316`*^9, 
   3.812155017238892*^9}, {3.812155113864715*^9, 3.8121551266385264`*^9}, {
   3.812155179785485*^9, 3.8121552495431185`*^9}, {3.8121552803310947`*^9, 
   3.812155393105529*^9}, {3.812155496278573*^9, 3.8121554963614025`*^9}, {
   3.8121559048682704`*^9, 3.8121559850563016`*^9}, 3.8121560906897626`*^9, {
   3.812156222606162*^9, 3.8121562552672462`*^9}, {3.8146886930397463`*^9, 
   3.8146886987321067`*^9}, 3.814690392473443*^9, {3.814770423696851*^9, 
   3.8147704241668835`*^9}, {3.8147720827709103`*^9, 
   3.8147720915934362`*^9}, {3.8147731736441813`*^9, 3.814773177115556*^9}, {
   3.8171959976601396`*^9, 3.817196001379109*^9}, {3.817205886542565*^9, 
   3.8172058929958525`*^9}, 
   3.8249805790565033`*^9},ExpressionUUID->"6f441147-4c36-4925-9aa7-\
30b448cd5148"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Saving Mathematica .m file", "Chapter",
 FontSize->36]], "Chapter",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.813499782848096*^9}, {3.813500130542923*^9, 
  3.8135001629185205`*^9}, {3.8135789848781996`*^9, 3.8135790332573433`*^9}, {
  3.813579143986269*^9, 3.8135791654381247`*^9}, {3.8140861592886915`*^9, 
  3.8140861813430047`*^9}, {3.8171192507401466`*^9, 3.81711926018217*^9}},
 CellTags->"Title",ExpressionUUID->"8e398aba-c010-4ea9-b51b-72ccbb389019"],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{
  "\"\<SizeStrain_functions_general.m\>\"", ",", "\[IndentingNewLine]", 
   "           ", 
   RowBox[{"{", 
    RowBox[{
    "G", ",", "dmean", ",", "sd", ",", "LV", ",", "\[IndentingNewLine]", 
     "           ", "FTAgen", ",", " ", "FTASgen", ",", "\[IndentingNewLine]",
      "           ", "ALDPAH", ",", " ", "WPLTPAH", ",", " ", "FWILK", ",", 
     " ", "ALDWILK", ",", " ", "WPLTWILK"}], "\[IndentingNewLine]", 
    "        ", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8171192933841333`*^9, 3.8171193609993525`*^9}, {
   3.8171194508439407`*^9, 3.8171195811042337`*^9}, {3.817119653202878*^9, 
   3.8171197939875903`*^9}, 3.8171200543653073`*^9, {3.8171204126886873`*^9, 
   3.817120424018894*^9}, {3.817204848482622*^9, 3.817204926391176*^9}, {
   3.817204989080514*^9, 3.8172050277065573`*^9}, 3.8172734425540485`*^9},
 CellLabel->
  "In[380]:=",ExpressionUUID->"68b1fadc-da1c-44e4-a24b-36fb7bea599a"],

Cell["", "Author",
 CellChangeTimes->{{3.817196104354244*^9, 3.8171961047136683`*^9}, {
  3.817204817247519*^9, 3.8172048181849346`*^9}, {3.8172049414540615`*^9, 
  3.81720498679904*^9}},ExpressionUUID->"5a9dbe46-4901-479f-ad8f-\
5732ae5d0a31"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{853.8, 790.8},
WindowMargins->{{195.6, Automatic}, {Automatic, 72}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "Preprint.nb", 
  CharacterEncoding -> "UTF-8"],
ExpressionUUID->"4c865441-90be-411b-b995-39865cdc2e68"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Title"->{
  Cell[580, 22, 493, 7, 124, "Title",ExpressionUUID->"164cce3e-b849-403d-aceb-97cf924b3ff6",
   CellTags->"Title"],
  Cell[1076, 31, 465, 6, 82, "Title",ExpressionUUID->"e2287e95-7869-4be2-a9ef-ad7246c7240d",
   CellTags->"Title"],
  Cell[4529, 133, 364, 4, 82, "Title",ExpressionUUID->"6c206687-332d-421d-86c4-42764b2c19e5",
   CellTags->"Title"],
  Cell[43882, 989, 509, 6, 82, "Title",ExpressionUUID->"03b42d6b-7b24-48ba-9f18-8a821935c188",
   CellTags->"Title"],
  Cell[54464, 1275, 680, 9, 70, "Chapter",ExpressionUUID->"8e398aba-c010-4ea9-b51b-72ccbb389019",
   CellTags->"Title"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Title", 56958, 1331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 493, 7, 124, "Title",ExpressionUUID->"164cce3e-b849-403d-aceb-97cf924b3ff6",
 CellTags->"Title"],
Cell[1076, 31, 465, 6, 82, "Title",ExpressionUUID->"e2287e95-7869-4be2-a9ef-ad7246c7240d",
 CellTags->"Title"],
Cell[1544, 39, 2405, 73, 154, "Input",ExpressionUUID->"1a1327d8-cedc-4b0f-a1b7-db26bc48538e"],
Cell[3952, 114, 540, 14, 29, "Input",ExpressionUUID->"6bec88db-87a4-42e4-aa2f-134ffd35413f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4529, 133, 364, 4, 82, "Title",ExpressionUUID->"6c206687-332d-421d-86c4-42764b2c19e5",
 CellTags->"Title"],
Cell[4896, 139, 18250, 398, 796, "Input",ExpressionUUID->"04437e29-0d0d-4a57-b413-979bd47889e2"],
Cell[23149, 539, 20696, 445, 870, "Input",ExpressionUUID->"5450824a-1287-40f1-94f5-3ff29ab4e6af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43882, 989, 509, 6, 82, "Title",ExpressionUUID->"03b42d6b-7b24-48ba-9f18-8a821935c188",
 CellTags->"Title"],
Cell[44394, 997, 10045, 274, 415, "Input",ExpressionUUID->"6f441147-4c36-4925-9aa7-30b448cd5148"],
Cell[CellGroupData[{
Cell[54464, 1275, 680, 9, 70, "Chapter",ExpressionUUID->"8e398aba-c010-4ea9-b51b-72ccbb389019",
 CellTags->"Title"],
Cell[55147, 1286, 967, 18, 102, "Input",ExpressionUUID->"68b1fadc-da1c-44e4-a24b-36fb7bea599a"],
Cell[56117, 1306, 244, 4, 45, "Author",ExpressionUUID->"5a9dbe46-4901-479f-ad8f-5732ae5d0a31"]
}, Open  ]]
}, Open  ]]
}
]
*)

