(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     52247,       1241]
NotebookOptionsPosition[     47412,       1155]
NotebookOutlinePosition[     48712,       1190]
CellTagsIndexPosition[     48643,       1185]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Aberration functions", "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794473182921484*^9, 3.794473193906823*^9}, {3.8196330686453323`*^9, 
  3.819633075286093*^9}},
 CellTags->"Title",ExpressionUUID->"e9731c62-a129-4fb0-b49d-b2fd3e83f612"],

Cell[TextData[StyleBox["Hat/box function", "Chapter"]], "Title",
 CellChangeTimes->{{3.794473018806044*^9, 3.7944730238220263`*^9}, {
  3.7947317495247765`*^9, 3.7947317511030135`*^9}, {3.794731977010672*^9, 
  3.7947319781203117`*^9}},
 CellTags->"Title",ExpressionUUID->"d81e2349-6df5-4293-879f-57d030883827"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"box", "[", 
    RowBox[{"x_", ",", "x0_", ",", "\[Sigma]_"}], "]"}], ":=", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          FractionBox["1.`", "\[Sigma]"], 
          RowBox[{
           RowBox[{
            RowBox[{"-", "0.5`"}], " ", "\[Sigma]"}], "\[LessEqual]", 
           RowBox[{"(", 
            RowBox[{"x", "-", "x0"}], ")"}], "\[LessEqual]", 
           RowBox[{"0.5`", " ", "\[Sigma]"}]}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        Selectable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False]}], ";"}]], "Input",
 CellChangeTimes->{{3.794731461890937*^9, 3.7947315430347953`*^9}, {
  3.8196334342637095`*^9, 3.8196334428418016`*^9}, {3.8196335468601327`*^9, 
  3.819633553365013*^9}, {3.8201616454250374`*^9, 3.8201616505812874`*^9}, {
  3.8201617025201483`*^9, 3.820161706520198*^9}, {3.8201617495213137`*^9, 
  3.820161749880723*^9}, {3.8213482586319265`*^9, 3.8213482591786976`*^9}, {
  3.8213521400721045`*^9, 3.821352140397455*^9}, {3.8213532742936983`*^9, 
  3.821353274622958*^9}, {3.8213536309183445`*^9, 3.8213536313576717`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ba23861e-dde2-4214-8853-8253c1eff8bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"halfbox", "[", 
    RowBox[{"x_", ",", "x0_", ",", "\[Sigma]_"}], "]"}], ":=", 
   FormBox[
    TagBox[GridBox[{
       {"\[Piecewise]", GridBox[{
          {
           FractionBox["1.`", 
            RowBox[{"Abs", "[", "\[Sigma]", "]"}]], 
           RowBox[{
            RowBox[{"\[Sigma]", "<", "0"}], " ", "&&", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "\[LessEqual]", "0"}], "&&", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "\[GreaterEqual]", 
             "\[Sigma]"}]}]},
          {
           FractionBox["1.`", "\[Sigma]"], 
           RowBox[{
            RowBox[{"\[Sigma]", ">", "0"}], " ", "&&", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "\[GreaterEqual]", "0"}], "&&", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "\[LessEqual]", "\[Sigma]"}]}]},
          {"0", 
           TagBox["True",
            "PiecewiseDefault",
            AutoDelete->True]}
         },
         AllowedDimensions->{2, Automatic},
         Editable->True,
         GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
         GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.84]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}},
         Selectable->True]}
      },
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.35]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     "Piecewise",
     DeleteWithContents->True,
     Editable->False,
     SelectWithContents->True,
     Selectable->False,
     StripWrapperBoxes->True],
    TraditionalForm]}], ";"}]], "Input",
 CellChangeTimes->{{3.821348239396926*^9, 3.8213482617569036`*^9}, {
   3.821348408495638*^9, 3.8213484097140417`*^9}, {3.8213484576995816`*^9, 
   3.8213485632652884`*^9}, {3.8213485961411858`*^9, 3.8213486288297853`*^9}, 
   3.8213486953629875`*^9, {3.8213487351604652`*^9, 3.821348804693652*^9}, {
   3.821348998824168*^9, 3.8213490259967704`*^9}, {3.8213490676383944`*^9, 
   3.821349124405613*^9}, {3.8213491735635905`*^9, 3.821349178407061*^9}, {
   3.821349336083224*^9, 3.821349420335634*^9}, {3.8213494591022954`*^9, 
   3.8213494685401583`*^9}, {3.8213535805274925`*^9, 
   3.8213535808553224`*^9}, {3.8213536612018642`*^9, 3.821353661562127*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"368867c6-cb3c-4964-9544-a9980e511d82"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tubetail", "[", 
    RowBox[{
    "x_", ",", "x0_", ",", "\[Sigma]1_", ",", "\[Sigma]2_", ",", "\[Sigma]3_",
      ",", "fraction_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"box", "[", 
       RowBox[{"x", ",", "x0", ",", "\[Sigma]1"}], "]"}], "+", " ", 
      RowBox[{"fraction", " ", 
       RowBox[{"halfbox", "[", 
        RowBox[{"x", ",", "x0", ",", "\[Sigma]2"}], "]"}]}], "+", " ", 
      RowBox[{"fraction", " ", 
       RowBox[{"(", 
        RowBox[{"Abs", "[", 
         RowBox[{"\[Sigma]3", "/", "\[Sigma]2"}], "]"}], ")"}], " ", 
       RowBox[{"halfbox", "[", 
        RowBox[{"x", ",", "x0", ",", "\[Sigma]3"}], "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "fraction", "+", 
      RowBox[{"fraction", " ", 
       RowBox[{"(", 
        RowBox[{"Abs", "[", 
         RowBox[{"\[Sigma]3", "/", "\[Sigma]2"}], "]"}], ")"}]}]}], ")"}]}]}],
   ";"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzk0og3EABvCXycFqxCz22oxaU9R8lI/ZNDNfK8kaJoXUG9LalJh2eMeB
w4qYr4PXgQPSUkqmls9y2Oaygxzm4vBaItI4bAf2/A9Pv8tTz1Myajcz6RRF
yVOBbz29nQfO92ZztnAIBqIZo7DXNz8G+75ebFBw9Unc2YynHabcYHQCaHbR
QqgLjudAz8apGL4qM2nYEXmQQ4l2ohhuh/bKoCkSK4fCBNcAby/9Wqj2GozQ
+eHogs8tgxb4XSMbgRpJZApGVdcuqKi+Z+Fd7ZYbap/qF+GMcYWYZdN5YJhf
8kLpbjsHWfcAkU8U7sNpWnVOfoy838Bgy2wYisXJR7huWI5B1/BCHIp42y98
dCf/IKX0i47w33eRCxXBVRncpUvV8CNxVgUlazUaaMnRE60c3wRPKgStsOMw
zwTzNXXEomQ3A/VM/yTpF/jskJWEHLDy2DpHdho5Fv60ZgVgW7eU+A8oN/du

  "],
 CellLabel->"In[3]:=",ExpressionUUID->"cb672fb4-59b0-4543-b479-3d608970c494"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"tubetail", "[", 
     RowBox[{"x", ",", "0", ",", "0.2", ",", 
      RowBox[{"-", "0.5"}], ",", "0.8", ",", "0.3"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8213580919296703`*^9, 3.821358198918126*^9}, {
  3.821358458797455*^9, 3.8213584765061984`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"a9dcf0f6-1aa3-4477-b1df-9c4f434ab03a"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{"halfbox", "[", 
      RowBox[{"x", ",", "0", ",", "\[Sigma]"}], "]"}], ",", "x", ",", "w"}], 
    "]"}], "//", "Simplify"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8213495836686077`*^9, 3.821349602200254*^9}, {
  3.821349709296694*^9, 3.821349710000208*^9}, {3.82134974773514*^9, 
  3.82134976187631*^9}, {3.8213521450387077`*^9, 3.821352149976066*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"5274f7ee-df5a-44bf-bcb9-b0f98f68481a"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"halfbox", "[", 
     RowBox[{"x", ",", "0", ",", "1.33"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8213521519279633`*^9, 3.8213522233859215`*^9}, {
  3.821352482648489*^9, 3.821352485320301*^9}, {3.821358100014132*^9, 
  3.8213581003830395`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"c053b2d7-38c6-4fab-ac76-daf7d2b0540e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fthalfbox", "[", 
    RowBox[{"\[Omega]_", ",", "\[Sigma]_"}], "]"}], " ", ":=", 
   FractionBox[
    RowBox[{" ", 
     RowBox[{"\[ImaginaryI]", "-", " ", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{" ", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "\[Sigma]"}]}]]}]}]}], 
    RowBox[{"\[Omega]", " ", "\[Sigma]"}]]}], ";"}]], "Input",
 CellChangeTimes->{{3.821349792033573*^9, 3.8213497929083395`*^9}, {
  3.82134984123787*^9, 3.821349882160841*^9}, {3.8213499402718215`*^9, 
  3.8213499782415943`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"ccd599db-87fb-496b-97ed-80160f4acb40"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"halfbox", "[", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"-", "2.667"}]}], "]"}], ",", 
      RowBox[{"Re", "@", 
       RowBox[{"fthalfbox", "[", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2.667"}]}], "]"}]}], ",", 
      RowBox[{"Im", "@", 
       RowBox[{"fthalfbox", "[", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2.667"}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8213488287099385`*^9, 3.8213488495857735`*^9}, 
   3.8213491450939817`*^9, 3.821349473368797*^9, 3.821349690859103*^9, {
   3.821349889817518*^9, 3.8213499261935697`*^9}, {3.8213499959138966`*^9, 
   3.8213500019453955`*^9}, {3.8213500753695917`*^9, 
   3.8213500805886493`*^9}, {3.821350151889152*^9, 3.8213501593895674`*^9}, {
   3.821353902389732*^9, 3.821353902791808*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"f2b5a855-6748-4560-b3f1-8458ebf0261c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ftbox", "[", 
     RowBox[{"\[Omega]_", ",", "\[Sigma]_"}], "]"}], " ", ":=", 
    TagBox[GridBox[{
       {"\[Piecewise]", GridBox[{
          {"0.`", 
           RowBox[{"\[Sigma]", "\[LessEqual]", "0"}]},
          {"1.`", 
           RowBox[{"\[Omega]", "\[LongEqual]", "0"}]},
          {
           FractionBox[
            RowBox[{"2.`", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{".5`", " ", "\[Sigma]", " ", "\[Omega]"}], "]"}]}], 
            RowBox[{"\[Sigma]", " ", "\[Omega]"}]], 
           TagBox["True",
            "PiecewiseDefault",
            AutoDelete->True]}
         },
         AllowedDimensions->{2, Automatic},
         Editable->True,
         GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
         GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.84]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}},
         Selectable->True]}
      },
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.35]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     "Piecewise",
     DeleteWithContents->True,
     Editable->False,
     SelectWithContents->True,
     Selectable->False,
     StripWrapperBoxes->True]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"box", "[", 
        RowBox[{"x", ",", "2.667"}], "]"}], ",", 
       RowBox[{"ftbox", "[", 
        RowBox[{"x", ",", "2.667"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
     RowBox[{"PlotRange", "->", "All"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}], " ", 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.819633629377843*^9, 3.8196336526117744`*^9}, 
   3.8196337479744773`*^9, {3.819633815538205*^9, 3.8196338562615366`*^9}, {
   3.819633895419174*^9, 3.819633897962183*^9}, 3.819634012074355*^9, {
   3.819634069497624*^9, 3.8196341145297475`*^9}, 3.8196341625506625`*^9, {
   3.8196341992623777`*^9, 3.8196343153314133`*^9}, {3.8196343612408056`*^9, 
   3.8196344298032017`*^9}, {3.819634850067085*^9, 3.819634850438064*^9}, {
   3.819635054316474*^9, 3.819635072957035*^9}, {3.819723315747877*^9, 
   3.8197233933791986`*^9}, {3.8197236190018787`*^9, 
   3.8197236279755287`*^9}, {3.821348659424086*^9, 3.8213486734713955`*^9}, {
   3.821348712363106*^9, 3.8213487281763587`*^9}, {3.82134881999092*^9, 
   3.821348820397273*^9}, {3.821367136261073*^9, 3.8213671768714*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"00f9dbba-70a7-4bfb-b8cf-a62b1b8ccf89"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"boxTable", "[", 
    RowBox[{"\[Sigma]_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"box", "[", 
       RowBox[{"#", ",", "x0", ",", "\[Sigma]"}], "]"}], "&"}], "/@", 
     "abscissae"}], "//", "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7943238128938727`*^9, 3.79432391031476*^9}, 
   3.794324102388053*^9, {3.7943263252661953`*^9, 3.7943263257662344`*^9}, {
   3.794326616523223*^9, 3.7943266207426405`*^9}, {3.794327222238057*^9, 
   3.794327222613104*^9}, {3.7943856104082785`*^9, 3.794385618143759*^9}, {
   3.7947316565864477`*^9, 3.7947316829986744`*^9}, {3.794731771089608*^9, 
   3.7947317717302074`*^9}, {3.8196330966926546`*^9, 3.819633096755521*^9}, 
   3.8201616645034647`*^9, {3.820161724099084*^9, 3.8201617255521307`*^9}, {
   3.821350117465494*^9, 3.821350117887354*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"1591aa71-386e-4d42-bc1f-8ad7f4a6d2eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"halfboxTable", "[", 
    RowBox[{"\[Sigma]_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"halfbox", "[", 
       RowBox[{"#", ",", "x0", ",", "\[Sigma]"}], "]"}], "&"}], "/@", 
     "abscissae"}], "//", "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8213501208722525`*^9, 3.821350128872583*^9}, {
  3.821358610004118*^9, 3.821358610370804*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"fb945ffd-1a31-4fb3-ba25-14a2656a95ca"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"tubetailTable", "[", 
    RowBox[{
    "\[Sigma]1_", ",", "\[Sigma]2_", ",", "\[Sigma]3_", ",", "fraction_", ",",
      "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"tubetail", "[", 
       RowBox[{
       "#", ",", "x0", ",", "\[Sigma]1", ",", "\[Sigma]2", ",", "\[Sigma]3", 
        ",", "fraction"}], "]"}], "&"}], "/@", "abscissae"}], "//", 
    "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7943239305452337`*^9, 3.7943239682052183`*^9}, {
   3.794324088698605*^9, 3.7943240962623878`*^9}, 3.79432425304447*^9, {
   3.7943266777854023`*^9, 3.794326694154456*^9}, {3.794385625988207*^9, 
   3.7943856406024427`*^9}, {3.794391743310779*^9, 3.7943917437953796`*^9}, {
   3.794731789325862*^9, 3.7947318048944798`*^9}, 3.7947318565929003`*^9, {
   3.7947319106423564`*^9, 3.794731922343302*^9}, {3.819633102623331*^9, 
   3.8196331081619015`*^9}, {3.819633340917616*^9, 3.819633358420376*^9}, {
   3.8196334009865723`*^9, 3.8196334043254604`*^9}, {3.8196347944253654`*^9, 
   3.8196347980306225`*^9}, {3.8201616762225175`*^9, 
   3.8201616942858696`*^9}, {3.821358530959388*^9, 3.8213586166993294`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"bff2dbda-deb7-4445-91aa-474c8c579f1e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Exponential function", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730275430593`*^9, 3.7944730311097736`*^9}},
 CellTags->"Title",ExpressionUUID->"631bf9f0-9d84-4703-8b2d-956a817b25dd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"expo", "[", 
    RowBox[{"x_", ",", "x0_", ",", "xmin_"}], "]"}], ":=", 
   RowBox[{"Piecewise", " ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.", ",", 
         RowBox[{
          RowBox[{"xmin", "<", "0."}], " ", "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], ">=", "0."}], "||", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "<", "xmin"}]}], ")"}]}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       "                                                           ", 
       RowBox[{"{", 
        RowBox[{"0.", ",", 
         RowBox[{"xmin", "==", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
       "                                                           ", 
       RowBox[{"{", 
        RowBox[{"0.", ",", " ", 
         RowBox[{
          RowBox[{"xmin", ">", "0."}], " ", "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "<=", "0."}], "||", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], ">", "xmin"}]}], ")"}]}]}], 
        "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
     "                                                           ", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "x0"}], ")"}], "xmin"], 
        RowBox[{"Log", "[", "0.001", "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"0.14462", " ", 
        RowBox[{"Abs", "[", "xmin", "]"}]}], ")"}]}]}], "\[IndentingNewLine]",
     "                                                         ", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.788245766510047*^9, 3.7882457957155867`*^9}, {
   3.7882458357161684`*^9, 3.788245974059005*^9}, {3.7882460385516977`*^9, 
   3.7882460532093663`*^9}, {3.788246295500413*^9, 3.788246300532284*^9}, {
   3.788246356100892*^9, 3.788246365646796*^9}, {3.7882465115617313`*^9, 
   3.7882465240787697`*^9}, {3.7882466078102083`*^9, 
   3.7882466198824143`*^9}, {3.7882466879602103`*^9, 
   3.7882467002738757`*^9}, {3.788246821475462*^9, 3.7882468232256966`*^9}, {
   3.7882469521115913`*^9, 3.7882469525180235`*^9}, 3.7882471164426317`*^9, {
   3.788247551302855*^9, 3.788247689714847*^9}, {3.788247741231883*^9, 
   3.788247814588455*^9}, {3.7882478613976593`*^9, 3.7882478797332983`*^9}, {
   3.7882496018043385`*^9, 3.788249666446211*^9}, {3.788249708397928*^9, 
   3.7882497254156485`*^9}, 3.7885108703656883`*^9, {3.7885128724496093`*^9, 
   3.7885128875135937`*^9}, 3.7885135225803814`*^9, {3.7885150938360186`*^9, 
   3.788515102024079*^9}, {3.788579770518365*^9, 3.788579771267788*^9}, {
   3.788580000033429*^9, 3.788580112029985*^9}, 3.7885802170248594`*^9, {
   3.7885802541589065`*^9, 3.788580284532505*^9}, {3.7885804841089373`*^9, 
   3.788580516155771*^9}, {3.7886664570852585`*^9, 3.7886664575541744`*^9}, {
   3.793607684212555*^9, 3.7936076999185004`*^9}, {3.7937862893540783`*^9, 
   3.7937863070379744`*^9}, {3.7943862173738937`*^9, 3.794386226874628*^9}, {
   3.794386263760778*^9, 3.7943862705425615`*^9}, {3.7943869011418295`*^9, 
   3.79438693370748*^9}, {3.7943875681440334`*^9, 3.79438758298962*^9}, {
   3.7943881962528076`*^9, 3.794388226837846*^9}, {3.7943900845452704`*^9, 
   3.7943901279066925`*^9}, {3.7943902280476985`*^9, 
   3.7943903025884285`*^9}, {3.794390395996187*^9, 3.7943904086380043`*^9}, {
   3.794390445594239*^9, 3.794390476182076*^9}, {3.7943905753296027`*^9, 
   3.7943905864418354`*^9}, 3.7943906182594566`*^9, {3.794390716149062*^9, 
   3.7943907285415206`*^9}, {3.794390769692948*^9, 3.7943908446307015`*^9}, {
   3.7943909687765827`*^9, 3.7943909728240275`*^9}, {3.7943917578443017`*^9, 
   3.7943917582506013`*^9}, {3.794666917998082*^9, 3.79466691838869*^9}, {
   3.794731501936428*^9, 3.7947315024676204`*^9}, {3.819634873995844*^9, 
   3.819634900970225*^9}, {3.819635645844443*^9, 3.819635646237425*^9}, {
   3.8196357154110374`*^9, 3.8196357185831003`*^9}, {3.820161739177346*^9, 
   3.8201617724908133`*^9}, {3.828678454966118*^9, 3.828678455632825*^9}, {
   3.828679972900224*^9, 
   3.8286799734141197`*^9}},ExpressionUUID->"d3285d70-937a-4a72-a7f1-\
f443abe4f7fa"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"expo2", "[", 
     RowBox[{"x_", ",", "x0_", ",", "xmin_", ",", "minimum_"}], "]"}], ":=", 
    RowBox[{"Piecewise", " ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.", ",", 
          RowBox[{
           RowBox[{"xmin", "<", "0."}], " ", "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "x0"}], ")"}], ">=", "0."}], "||", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "x0"}], ")"}], "<", "xmin"}]}], ")"}]}]}], 
         "}"}], ",", "\[IndentingNewLine]", 
        "                                                           ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", 
          RowBox[{"xmin", "==", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
        "                                                           ", 
        RowBox[{"{", 
         RowBox[{"0.", ",", " ", 
          RowBox[{
           RowBox[{"xmin", ">", "0."}], " ", "&&", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "x0"}], ")"}], "<=", "0."}], "||", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "x0"}], ")"}], ">", "xmin"}]}], ")"}]}]}], 
         "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      "                                                            ", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"(", 
           RowBox[{"x", "-", "x0"}], ")"}], "xmin"], 
         RowBox[{"Log", "[", "minimum", "]"}]}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Log", "[", "minimum", "]"}]}], "/", 
         RowBox[{"Abs", "[", "xmin", "]"}]}], ")"}]}]}], 
     "\[IndentingNewLine]", 
     "                                                         ", "]"}]}], 
   ";"}], " ", "*)"}]], "Input",
 CellChangeTimes->{
  3.8286784713047605`*^9, {3.8286785188053045`*^9, 3.8286785407655954`*^9}, {
   3.8286787252915893`*^9, 3.8286787876512117`*^9}, {3.8286788503937187`*^9, 
   3.828678852182968*^9}, 3.8286791285172405`*^9, {3.828679225475817*^9, 
   3.8286792539783754`*^9}, {3.8286794696376123`*^9, 3.828679507953845*^9}, {
   3.828679621041453*^9, 3.828679644286115*^9}, {3.8286798367063684`*^9, 
   3.8286798435213103`*^9}, {3.8286798817505026`*^9, 
   3.8286799081277747`*^9}, {3.828679977069769*^9, 3.828680013214369*^9}, {
   3.828680071542672*^9, 3.8286800824074583`*^9}, {3.8286804497174788`*^9, 
   3.8286804642318535`*^9}, 3.828680637122414*^9, {3.828681128312894*^9, 
   3.828681175458229*^9}, {3.828681247604409*^9, 3.8286813454236174`*^9}, {
   3.8286815242170486`*^9, 3.828681526185334*^9}, {3.828685132450487*^9, 
   3.8286851329036465`*^9}, {3.828686126574148*^9, 
   3.8286861368322124`*^9}},ExpressionUUID->"2117628d-9f14-417a-a811-\
43bcec08e5fc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"expoTable", "[", 
    RowBox[{"xmin_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"expo", "[", 
       RowBox[{"#", ",", "x0", ",", "xmin"}], "]"}], "&"}], "/@", 
     "abscissae"}], "//", "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.794405010884797*^9, 3.794405120990938*^9}, {
  3.794405394664589*^9, 3.794405395071004*^9}, {3.7944083023500624`*^9, 
  3.7944083028656616`*^9}, {3.7944719801838655`*^9, 3.7944719806997633`*^9}, {
  3.8196366242437506`*^9, 3.819636628588242*^9}, {3.8201618038977575`*^9, 
  3.820161811882385*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"067572ba-85e4-4d96-a801-838672d6ac0c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Circles function", "Chapter"]], "Title",
 CellChangeTimes->{{3.794473036356423*^9, 3.7944730423895483`*^9}},
 CellTags->"Title",ExpressionUUID->"76ef3c72-3143-46b4-93b0-c4653f4e4655"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"circles", "[", 
    RowBox[{"x_", ",", "x0_", ",", "xmin_"}], "]"}], ":=", 
   RowBox[{"Piecewise", " ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"xmin", "\[LessEqual]", "0"}], " ", "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "\[GreaterEqual]", "0"}], "||",
             " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "<", "xmin"}]}], ")"}]}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"xmin", ">", "0"}], " ", "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "\[LessSlantEqual]", "0"}], "||",
             " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], ">", "xmin"}]}], ")"}]}]}], 
        "}"}]}], "}"}], ",", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"Abs", "[", 
         FractionBox["xmin", 
          RowBox[{"(", 
           RowBox[{"x", "-", "x0"}], ")"}]], "]"}]], "-", "1."}], 
      RowBox[{"Abs", "[", "xmin", "]"}]]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8196368284830713`*^9, 3.8196368866720705`*^9}, {
  3.8201618930409665`*^9, 3.8201619067911882`*^9}, {3.8201678905653825`*^9, 
  3.820167901659381*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"777fe453-be17-4fdf-8297-f0d3b8496994"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{"circles", "[", 
      RowBox[{"x", ",", "xmin"}], "]"}], ",", "x", ",", "w"}], "]"}], "//", 
   "Simplify"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7882469564245667`*^9, 3.7882469791340957`*^9}, 
   3.7882471176147285`*^9, {3.7882473764288816`*^9, 3.788247393743456*^9}, {
   3.7882475112119064`*^9, 3.788247516118515*^9}, {3.788247870460994*^9, 
   3.788247871370325*^9}, {3.7882599154555745`*^9, 3.7882599745894346`*^9}, {
   3.7882601082829485`*^9, 3.7882601097362614`*^9}, {3.7882604391502295`*^9, 
   3.7882604631834373`*^9}, {3.788499547849804*^9, 3.7884995789714136`*^9}, 
   3.7884996365909677`*^9, {3.788510792530032*^9, 3.7885107946864357`*^9}, 
   3.7885108689592175`*^9, 3.7885110848193545`*^9, {3.7938842370613685`*^9, 
   3.7938842417178574`*^9}, {3.7939547913334317`*^9, 
   3.7939547962119503`*^9}, {3.7939553025031767`*^9, 
   3.7939553053471956`*^9}, {3.793957949863079*^9, 3.7939579528320985`*^9}, 
   3.793958005418508*^9, 3.7939580524190454`*^9, {3.7939583100267844`*^9, 
   3.7939583122612944`*^9}, {3.79395855144895*^9, 3.7939585804833517`*^9}, {
   3.7939586153045783`*^9, 3.793958617742385*^9}, {3.7939587444451437`*^9, 
   3.7939587469296875`*^9}, {3.8196367968730874`*^9, 3.819636799389144*^9}, {
   3.819636912984992*^9, 3.8196369166728196`*^9}, {3.8196370997238884`*^9, 
   3.8196371141130004`*^9}, 3.8196371508211823`*^9, {3.819637334463295*^9, 
   3.8196373363859444`*^9}, {3.819637454964721*^9, 3.819637455372282*^9}, 
   3.819637539331601*^9, {3.819637648923535*^9, 3.819637649767064*^9}, {
   3.819637994587582*^9, 3.8196379950873756`*^9}, {3.8196380905425725`*^9, 
   3.819638113668213*^9}, {3.81963829501567*^9, 3.819638297531391*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"3e2dc6a6-ee60-4f62-88da-07e879570764"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ftcircles", "[", 
    RowBox[{"w_", ",", "xmin_"}], "]"}], ":=", 
   RowBox[{
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "w", " ", "xmin"}]]}], ")"}]}], 
     RowBox[{"w", " ", "xmin"}]], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"HypergeometricPFQ", "[", 
        RowBox[{
         RowBox[{"{", "0.25`", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "1.25`"}], "}"}], ",", 
         RowBox[{
          RowBox[{"-", "0.25`"}], " ", 
          SuperscriptBox["w", "2"], " ", 
          SuperscriptBox["xmin", "2"]}]}], "]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"0.`", "\[VeryThinSpace]", "+", 
          RowBox[{"0.3325`", " ", "\[ImaginaryI]"}]}], ")"}], " ", "w", " ", 
        "xmin", " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", "0.75`", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.5`", ",", "1.75`"}], "}"}], ",", 
          RowBox[{
           RowBox[{"-", "0.25`"}], " ", 
           SuperscriptBox["w", "2"], " ", 
           SuperscriptBox["xmin", "2"]}]}], "]"}]}]}], ")"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.793955037830784*^9, 3.793955132778705*^9}, {
   3.7939555269262934`*^9, 3.7939555421150894`*^9}, {3.793955594279269*^9, 
   3.7939556076555405`*^9}, {3.7939557377634315`*^9, 3.793955795319526*^9}, {
   3.7939582748168316`*^9, 3.793958285192526*^9}, {3.793958736475676*^9, 
   3.793958737663106*^9}, {3.8196370888574886`*^9, 3.8196370912681885`*^9}, {
   3.819637160258094*^9, 3.819637162916236*^9}, {3.819637608578884*^9, 
   3.8196376350173464`*^9}, {3.819637675439645*^9, 3.8196378495233746`*^9}, {
   3.8196379271951294`*^9, 3.819637928164049*^9}, {3.819638035933203*^9, 
   3.819638064042201*^9}, {3.8196381429968286`*^9, 3.8196382652657022`*^9}, {
   3.819638349579351*^9, 3.819638365825496*^9}, {3.819638405471456*^9, 
   3.819638405940239*^9}, 3.8211665557402196`*^9, {3.8212792032135863`*^9, 
   3.821279232589484*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"45d0a3f6-13d0-4377-bbb5-8e808967efdf"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"circles", "[", 
       RowBox[{"x", ",", "2.667"}], "]"}], ",", 
      RowBox[{"ftcircles", "[", 
       RowBox[{"x", ",", "2.667"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.819637896737121*^9, 3.819637913023336*^9}, {
  3.8196384304253187`*^9, 3.81963843394066*^9}, {3.819639933441861*^9, 
  3.8196399338323307`*^9}, {3.8197234050166035`*^9, 3.819723406469163*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"73b271d2-e44a-4fe2-bb20-4e404feed50c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"circlesTable", "[", 
    RowBox[{"xmin_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"circles", "[", 
       RowBox[{"#", ",", "x0", ",", "xmin"}], "]"}], "&"}], "/@", 
     "abscissae"}], "//", "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7944083079448013`*^9, 3.7944083230628033`*^9}, {
  3.8196383099834166`*^9, 3.8196383136257133`*^9}, {3.8201619136819*^9, 
  3.8201619214789753`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"fe022a68-fbc7-4453-83dd-54448f8c9405"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1/X function", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}},
 CellTags->"Title",ExpressionUUID->"ac9c888c-0269-4db2-afae-16cc96c44cb1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"oneonx", "[", 
    RowBox[{"x_", ",", "x0_", ",", "xmin_"}], "]"}], ":=", 
   RowBox[{"Piecewise", " ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"xmin", "<=", "0"}], " ", "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], ">=", "0"}], "||", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "<", "xmin"}]}], ")"}]}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"xmin", ">=", "0"}], " ", "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], "<=", "0"}], "||", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "x0"}], ")"}], ">", "xmin"}]}], ")"}]}]}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{"(", " ", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{"4", " ", 
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "-", "x0"}], ")"}], " ", "xmin"}], "]"}]}], ")"}]}],
        ")"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.794473063891701*^9, 3.7944730665480833`*^9}, {
  3.7949087435195427`*^9, 3.7949087450977693`*^9}, {3.8196387214000697`*^9, 
  3.8196387545392356`*^9}, {3.820161931370209*^9, 3.820161951261344*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"58a685fa-0b15-4ed2-b4c3-1b6076f15e0b"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     RowBox[{"oneonx", "[", 
      RowBox[{"t", ",", "xmin"}], "]"}], ",", "t", ",", "w"}], "]"}], "//", 
   "FullSimplify"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.788585277699663*^9, 3.7885852874991255`*^9}, {
   3.78860185555843*^9, 3.788601862455515*^9}, 3.788667283712986*^9, {
   3.7937934880092926`*^9, 3.7937934916031756`*^9}, {3.7938673804692483`*^9, 
   3.793867382797711*^9}, {3.793867427866685*^9, 3.7938674302574844`*^9}, {
   3.7949082523720245`*^9, 3.7949082543408146`*^9}, {3.7949082962669926`*^9, 
   3.794908299313977*^9}, {3.7949083513264384`*^9, 3.7949083528891487`*^9}, {
   3.819638760434228*^9, 3.819638761630207*^9}, 3.819719214906095*^9, {
   3.8197193272406588`*^9, 3.8197193285845957`*^9}, {3.819719384274229*^9, 
   3.8197193866024933`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"b9b3ce95-5eb2-4e5e-892e-fd9dcb9f3d51"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ftoneonx", "[", 
   RowBox[{"w_", ",", "xmin_"}], "]"}], ":=", 
  RowBox[{
   SqrtBox[
    RowBox[{"2", "\[Pi]"}]], " ", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          FractionBox[
           RowBox[{
            RowBox[{"FresnelC", "[", 
             RowBox[{
              SqrtBox[
               FractionBox["2", "\[Pi]"]], " ", 
              SqrtBox["w"], " ", 
              SqrtBox["xmin"]}], "]"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"FresnelS", "[", 
              RowBox[{
               SqrtBox[
                FractionBox["2", "\[Pi]"]], " ", 
               SqrtBox["w"], " ", 
               SqrtBox["xmin"]}], "]"}]}]}], 
           RowBox[{"2", " ", 
            SqrtBox["w"], " ", 
            SqrtBox["xmin"]}]], 
          RowBox[{"xmin", "\[NotEqual]", "0"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True]}]}]], "Input",
 CellChangeTimes->{{3.78866729155745*^9, 3.788667304933761*^9}, {
   3.7886675183635893`*^9, 3.788667519660734*^9}, 3.7886675840931387`*^9, 
   3.788667622254738*^9, 3.7938674231000924`*^9, 3.794908399462925*^9, 
   3.7949086225211306`*^9, {3.8196387870735245`*^9, 3.819638811761462*^9}, {
   3.8196399978651495`*^9, 3.819639998052769*^9}, {3.8197190972310767`*^9, 
   3.8197190984184256`*^9}, {3.819719146467444*^9, 3.819719182404313*^9}, {
   3.8197193008425922`*^9, 3.8197193045520043`*^9}, {3.8197193422417808`*^9, 
   3.8197193492413855`*^9}, {3.8211665651726866`*^9, 3.821166567195407*^9}, 
   3.8286739178058186`*^9},ExpressionUUID->"ddcd5852-0b49-4353-a916-\
b1aa5dd2c307"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"oneonx", "[", 
       RowBox[{"x", ",", "2.667"}], "]"}], ",", 
      RowBox[{"ftoneonx", "[", 
       RowBox[{"x", ",", "2.667"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "25"}], ",", "25"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8196399408016562`*^9, 3.8196399535364532`*^9}, {
  3.8197193902119513`*^9, 3.8197193923684177`*^9}, {3.819723411063818*^9, 
  3.8197234116801357`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"d2d4265e-7ac2-4865-8040-58992ebee1b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"oneonxTable", "[", 
    RowBox[{"xmin_", ",", "x0_", ",", "abscissae_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"oneonx", "[", 
       RowBox[{"#", ",", "x0", ",", "xmin"}], "]"}], "&"}], "/@", 
     "abscissae"}], "//", "Chop"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.794408338861037*^9, 3.7944083507843695`*^9}, {
  3.796128045558771*^9, 3.796128046011888*^9}, {3.819719118404459*^9, 
  3.819719124363032*^9}, {3.8201619591363816`*^9, 3.820161964683234*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"5bef5198-b1d9-4424-b9dc-c05f76bd2fde"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Instrumental aberrations", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.8208372001668997`*^9, 3.820837209260604*^9}},
 CellTags->"Title",ExpressionUUID->"b36d4c13-7bc8-4091-bf05-16f722a544a8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Size", "[", 
    RowBox[{"x_", ",", "c_", ",", "rs_"}], "]"}], ":=", 
   "                                    ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"180", "/", "Pi"}], ")"}], " ", 
    RowBox[{"c", "/", "rs"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SpecimenTilt", "[", 
    RowBox[{"x_", ",", "c_", ",", "rs_"}], "]"}], ":=", "                  ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"180", "/", "Pi"}], ")"}], " ", "c", " ", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"x", "/", "2"}], " ", "Degree"}], "]"}], "/", "rs"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AxialDivergence", "[", 
    RowBox[{"x_", ",", "c_", ",", "rs_"}], "]"}], ":=", " ", 
   RowBox[{
    RowBox[{"-", "0.5"}], 
    RowBox[{"(", 
     RowBox[{"180", "/", "Pi"}], ")"}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", " ", 
       RowBox[{"c", " ", "/", "rs"}], ")"}], "2"], "/", 
     RowBox[{"Tan", "[", 
      RowBox[{"x", " ", "Degree"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FixedDivergence", "[", 
    RowBox[{"x_", ",", "c_"}], "]"}], ":=", "                    ", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{"Pi", "/", "360"}], ")"}]}], 
    SuperscriptBox["c", "2"], 
    RowBox[{"Cot", "[", 
     RowBox[{
      RowBox[{"x", "/", "2"}], " ", "Degree"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VariableDivergence", "[", 
    RowBox[{"x_", ",", "c_", ",", "rs_"}], "]"}], ":=", " ", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"180", "/", "Pi"}], ")"}], 
       SuperscriptBox["c", "2"], 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "Degree"}], "]"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"4", " ", 
      SuperscriptBox["rs", "2"]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearAbsorption", "[", 
    RowBox[{"x_", ",", "c_", ",", "rs_"}], "]"}], ":=", "         ", 
   RowBox[{"900", " ", 
    RowBox[{"Log", "[", "0.001", "]"}], " ", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "Degree"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c", " ", "rs"}], " ", ")"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.820837216510784*^9, 3.8208373463903284`*^9}, {
   3.8208373828914957`*^9, 3.8208374390183716`*^9}, {3.8208374847857533`*^9, 
   3.8208375106301284`*^9}, {3.820837546787766*^9, 3.82083762096201*^9}, 
   3.820837720871604*^9, {3.8212768196319623`*^9, 3.82127682683512*^9}, {
   3.8213523543611393`*^9, 3.821352441943405*^9}, {3.821353251376231*^9, 
   3.8213532919350853`*^9}, {3.8213533356825128`*^9, 3.821353336237054*^9}, {
   3.8213533909248247`*^9, 3.8213534285830584`*^9}, {3.8213706930071363`*^9, 
   3.821370708585929*^9}, {3.821425450490888*^9, 
   3.8214254697031345`*^9}},ExpressionUUID->"1adfbe80-b657-4b89-a4f7-\
716d558e8610"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Saving Mathematica .m file", "Chapter",
 FontSize->36]], "Chapter",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
  3.794473090557276*^9, 3.794473100964528*^9}, {3.797333014298021*^9, 
  3.79733303430528*^9}, {3.804508014113057*^9, 3.804508018223386*^9}, {
  3.813499744675688*^9, 3.813499782848096*^9}, {3.813500130542923*^9, 
  3.8135001629185205`*^9}, {3.8135789848781996`*^9, 3.8135790332573433`*^9}, {
  3.813579143986269*^9, 3.8135791654381247`*^9}, {3.8140861592886915`*^9, 
  3.8140861813430047`*^9}, {3.8171192507401466`*^9, 3.81711926018217*^9}},
 CellTags->"Title",ExpressionUUID->"7650f7ac-183e-412a-8605-87768a0be5d7"],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<Aberration_functions_general.m\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
    "box", ",", "ftbox", ",", "boxTable", ",", "halfbox", ",", "fthalfbox", 
     ",", " ", "halfboxTable", ",", "\[IndentingNewLine]", 
     "                                                                        \
              ", "tubetail", ",", " ", "tubetailTable", ",", 
     "\[IndentingNewLine]", 
     "                                                                        \
              ", "expo", ",", "ftexpo", ",", "expoTable", ",", 
     "\[IndentingNewLine]", 
     "                                                                        \
             ", "circles", ",", "ftcircles", ",", "circlesTable", ",", 
     "\[IndentingNewLine]", 
     "                                                                        \
             ", "oneonx", ",", "ftoneonx", ",", "oneonxTable", ",", 
     "\[IndentingNewLine]", 
     "                                                                        \
             ", "Size", ",", "SpecimenTilt", ",", "\[IndentingNewLine]", 
     "                                                                        \
             ", "AxialDivergence", ",", "\[IndentingNewLine]", 
     "                                                                        \
             ", "FixedDivergence", ",", "VariableDivergence", ",", 
     "\[IndentingNewLine]", 
     "                                                                        \
             ", "LinearAbsorption"}], "}"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellChangeTimes->{{3.8171192933841333`*^9, 3.8171193609993525`*^9}, {
   3.8171194508439407`*^9, 3.8171195811042337`*^9}, {3.817119653202878*^9, 
   3.8171197939875903`*^9}, 3.8171200543653073`*^9, {3.8171204126886873`*^9, 
   3.817120424018894*^9}, {3.8196331158182793`*^9, 3.8196332162753096`*^9}, {
   3.8196348125464306`*^9, 3.8196348153904533`*^9}, {3.819636700215146*^9, 
   3.8196367020429153`*^9}, {3.819719415697565*^9, 3.8197194268142757`*^9}, {
   3.819723575459771*^9, 3.8197235977727737`*^9}, {3.820837624899598*^9, 
   3.820837691495693*^9}, {3.8211847214296494`*^9, 3.8211847238514166`*^9}, {
   3.821366746733465*^9, 3.821366778781173*^9}, {3.8213668102555237`*^9, 
   3.8213668161419487`*^9}, {3.821369847748001*^9, 3.821369866170382*^9}, {
   3.8213699070934176`*^9, 3.8213699120154676`*^9}, 3.821370715570205*^9},
 CellLabel->"In[33]:=",ExpressionUUID->"4dbc4c1d-fbcc-40e9-9acb-0eb75abfcd52"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.821352351220042*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"24be91db-ea49-4695-9ed1-8976e055dd8b"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1349, 951},
WindowMargins->{{74, Automatic}, {Automatic, 56}},
Magnification:>1.25 Inherited,
FrontEndVersion->"12.1 for Microsoft Windows (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"787f2e66-3ab1-4c43-8114-1f53e017d779"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Title"->{
  Cell[580, 22, 282, 4, 121, "Title",ExpressionUUID->"e9731c62-a129-4fb0-b49d-b2fd3e83f612",
   CellTags->"Title"],
  Cell[865, 28, 311, 4, 105, "Title",ExpressionUUID->"d81e2349-6df5-4293-879f-57d030883827",
   CellTags->"Title"],
  Cell[17829, 450, 213, 2, 105, "Title",ExpressionUUID->"631bf9f0-9d84-4703-8b2d-956a817b25dd",
   CellTags->"Title"],
  Cell[26269, 638, 207, 2, 105, "Title",ExpressionUUID->"76ef3c72-3143-46b4-93b0-c4653f4e4655",
   CellTags->"Title"],
  Cell[33705, 817, 205, 2, 105, "Title",ExpressionUUID->"ac9c888c-0269-4db2-afae-16cc96c44cb1",
   CellTags->"Title"],
  Cell[40683, 1002, 268, 3, 105, "Title",ExpressionUUID->"b36d4c13-7bc8-4091-bf05-16f722a544a8",
   CellTags->"Title"],
  Cell[44010, 1096, 680, 9, 88, "Chapter",ExpressionUUID->"7650f7ac-183e-412a-8605-87768a0be5d7",
   CellTags->"Title"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Title", 47789, 1167}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 282, 4, 121, "Title",ExpressionUUID->"e9731c62-a129-4fb0-b49d-b2fd3e83f612",
 CellTags->"Title"],
Cell[865, 28, 311, 4, 105, "Title",ExpressionUUID->"d81e2349-6df5-4293-879f-57d030883827",
 CellTags->"Title"],
Cell[1179, 34, 2549, 62, 64, "Input",ExpressionUUID->"ba23861e-dde2-4214-8853-8253c1eff8bb"],
Cell[3731, 98, 2981, 73, 100, "Input",ExpressionUUID->"368867c6-cb3c-4964-9544-a9980e511d82"],
Cell[6715, 173, 1581, 39, 60, "Input",ExpressionUUID->"cb672fb4-59b0-4543-b479-3d608970c494"],
Cell[8299, 214, 552, 13, 35, "Input",ExpressionUUID->"a9dcf0f6-1aa3-4477-b1df-9c4f434ab03a"],
Cell[8854, 229, 542, 11, 35, "Input",ExpressionUUID->"5274f7ee-df5a-44bf-bcb9-b0f98f68481a"],
Cell[9399, 242, 545, 13, 35, "Input",ExpressionUUID->"c053b2d7-38c6-4fab-ac76-daf7d2b0540e"],
Cell[9947, 257, 694, 16, 58, "Input",ExpressionUUID->"ccd599db-87fb-496b-97ed-80160f4acb40"],
Cell[10644, 275, 1197, 28, 60, "Input",ExpressionUUID->"f2b5a855-6748-4560-b3f1-8458ebf0261c"],
Cell[11844, 305, 3144, 77, 143, "Input",ExpressionUUID->"00f9dbba-70a7-4bfb-b8cf-a62b1b8ccf89"],
Cell[14991, 384, 979, 19, 35, "Input",ExpressionUUID->"1591aa71-386e-4d42-bc1f-8ad7f4a6d2eb"],
Cell[15973, 405, 531, 13, 35, "Input",ExpressionUUID->"fb945ffd-1a31-4fb3-ba25-14a2656a95ca"],
Cell[16507, 420, 1285, 25, 35, "Input",ExpressionUUID->"bff2dbda-deb7-4445-91aa-474c8c579f1e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17829, 450, 213, 2, 105, "Title",ExpressionUUID->"631bf9f0-9d84-4703-8b2d-956a817b25dd",
 CellTags->"Title"],
Cell[18045, 454, 4433, 88, 170, "Input",ExpressionUUID->"d3285d70-937a-4a72-a7f1-f443abe4f7fa"],
Cell[22481, 544, 3028, 71, 161, "Input",ExpressionUUID->"2117628d-9f14-417a-a811-43bcec08e5fc"],
Cell[25512, 617, 720, 16, 35, "Input",ExpressionUUID->"067572ba-85e4-4d96-a801-838672d6ac0c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26269, 638, 207, 2, 105, "Title",ExpressionUUID->"76ef3c72-3143-46b4-93b0-c4653f4e4655",
 CellTags->"Title"],
Cell[26479, 642, 1655, 48, 117, "Input",ExpressionUUID->"777fe453-be17-4fdf-8297-f0d3b8496994"],
Cell[28137, 692, 1867, 29, 35, "Input",ExpressionUUID->"3e2dc6a6-ee60-4f62-88da-07e879570764"],
Cell[30007, 723, 2290, 53, 146, "Input",ExpressionUUID->"45d0a3f6-13d0-4377-bbb5-8e808967efdf"],
Cell[32300, 778, 787, 18, 35, "Input",ExpressionUUID->"73b271d2-e44a-4fe2-bb20-4e404feed50c"],
Cell[33090, 798, 578, 14, 35, "Input",ExpressionUUID->"fe022a68-fbc7-4453-83dd-54448f8c9405"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33705, 817, 205, 2, 105, "Title",ExpressionUUID->"ac9c888c-0269-4db2-afae-16cc96c44cb1",
 CellTags->"Title"],
Cell[33913, 821, 1695, 48, 92, "Input",ExpressionUUID->"58a685fa-0b15-4ed2-b4c3-1b6076f15e0b"],
Cell[35611, 871, 951, 17, 35, "Input",ExpressionUUID->"b9b3ce95-5eb2-4e5e-892e-fd9dcb9f3d51"],
Cell[36565, 890, 2713, 71, 80, "Input",ExpressionUUID->"ddcd5852-0b49-4353-a916-b1aa5dd2c307"],
Cell[39281, 963, 744, 18, 35, "Input",ExpressionUUID->"d2d4265e-7ac2-4865-8040-58992ebee1b3"],
Cell[40028, 983, 618, 14, 35, "Input",ExpressionUUID->"5bef5198-b1d9-4424-b9dc-c05f76bd2fde"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40683, 1002, 268, 3, 105, "Title",ExpressionUUID->"b36d4c13-7bc8-4091-bf05-16f722a544a8",
 CellTags->"Title"],
Cell[40954, 1007, 3031, 85, 163, "Input",ExpressionUUID->"1adfbe80-b657-4b89-a4f7-716d558e8610"],
Cell[CellGroupData[{
Cell[44010, 1096, 680, 9, 88, "Chapter",ExpressionUUID->"7650f7ac-183e-412a-8605-87768a0be5d7",
 CellTags->"Title"],
Cell[44693, 1107, 2522, 40, 252, "Input",ExpressionUUID->"4dbc4c1d-fbcc-40e9-9acb-0eb75abfcd52"],
Cell[47218, 1149, 166, 2, 60, "Input",ExpressionUUID->"24be91db-ea49-4695-9ed1-8976e055dd8b"]
}, Open  ]]
}, Open  ]]
}
]
*)

