(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1497931,      27377]
NotebookOptionsPosition[   1492652,      27279]
NotebookOutlinePosition[   1493688,      27309]
CellTagsIndexPosition[   1493616,      27304]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Pseudo-Voigt profile with aberration functions", "Title",
 CellChangeTimes->{{3.7944729497088766`*^9, 3.7944730042260256`*^9}, {
  3.794473182921484*^9, 3.794473193906823*^9}},
 CellTags->"Title",ExpressionUUID->"e9731c62-a129-4fb0-b49d-b2fd3e83f612"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellLabel->
  "In[160]:=",ExpressionUUID->"0c5a4feb-8b17-4eea-b737-3c76e3a5b71a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"filePath", "=", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"HomeDirectory", "[", "]"}], ",", "\"\<DeskTop\>\"", ",", 
       "\"\<Double_Voigt.jpg\>\""}], "}"}], "]"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.794487949165287*^9, 3.7944879555406275`*^9}, {
  3.795686926938303*^9, 3.79568693015725*^9}, {3.7956871831566043`*^9, 
  3.795687184703747*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"e3ab1a89-5656-4f6d-86b2-41c4d0c56879"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Get", "[", "\"\<Voigt_functions_general.m\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<SizeStrain_functions_general.m\>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", "\"\<Aberration_functions_general.m\>\"", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.817128916523795*^9, 3.817128924413577*^9}, {
  3.8172051006619625`*^9, 3.8172051384284296`*^9}, {3.8197278018359427`*^9, 
  3.819727812632044*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"b968a6bb-86f4-4eb5-87a4-f5c9e504bcdc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"FourierParameters", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.817129495125703*^9, 3.817130020129476*^9, 3.8171321855370483`*^9, 
   3.8171328825102763`*^9, 3.8171339216368856`*^9, 3.8171341130358796`*^9, 
   3.817134179945239*^9, 3.8171342445261045`*^9, 3.8171343488433547`*^9, 
   3.817135459169955*^9, 3.8171371321213355`*^9, 3.817186306758191*^9, 
   3.8171864805107546`*^9, 3.817191602455773*^9, 3.8172057630392785`*^9, 
   3.8172059794982147`*^9, 3.817217111081523*^9, 3.8172732175485954`*^9, 
   3.8172735339153957`*^9, 3.8172745162510815`*^9, {3.817274639081896*^9, 
   3.8172746528478837`*^9}, 3.817274695536309*^9, {3.81727473320909*^9, 
   3.8172747556157894`*^9}, 3.817992109644123*^9, 3.818071285232978*^9, 
   3.8181344098266635`*^9, 3.818134594155491*^9, 3.818151748161479*^9, 
   3.818153758488387*^9, 3.81822102696124*^9, 3.819729747153189*^9, 
   3.8197300900996075`*^9, 3.8197303002820253`*^9, 3.819790141252656*^9, 
   3.819790714755858*^9, 3.8197927647797346`*^9, 3.8197937474558883`*^9, 
   3.8197939404615326`*^9, 3.819949391981893*^9, 3.8199503057525597`*^9, 
   3.819955448265458*^9, 3.819959125791645*^9, 3.8200516677962785`*^9, 
   3.820060478199582*^9, 3.8200615609766965`*^9, 3.8201310235820026`*^9, 
   3.820135032279924*^9, 3.820135261581922*^9, 3.820135766249421*^9, 
   3.820151163896247*^9, 3.8201622116897364`*^9, 3.8201671401098213`*^9, 
   3.8201677349366264`*^9, 3.8201679421291027`*^9, 3.820211940292653*^9, 
   3.820212087876584*^9, 3.820213058426032*^9, 3.820230741140458*^9, 
   3.8202308920659385`*^9, 3.820299842147227*^9, 3.8203067159434814`*^9, 
   3.8208378950023813`*^9, 3.8209090812169366`*^9, 3.821161197225999*^9, 
   3.8211843352162485`*^9, 3.821184671318799*^9, 3.8211847478364935`*^9, 
   3.8211851197370796`*^9, 3.821366936195121*^9, 3.821369133258027*^9, {
   3.8213693193728757`*^9, 3.821369342451914*^9}, 3.821369540926613*^9, 
   3.8213704106550093`*^9, 3.8213751845262027`*^9, 3.821375218855356*^9, 
   3.82142075046989*^9, 3.821420916660961*^9, 3.821508368864142*^9, 
   3.8246473330327473`*^9, 3.824651821656435*^9, 3.82465206496529*^9, 
   3.824800630645054*^9, 3.824813197847882*^9, 3.824874855076746*^9, 
   3.824875662887946*^9, 3.824956554057087*^9, 3.8249613973608303`*^9, 
   3.825152350581518*^9, 3.8254889870918207`*^9, 3.825489195719133*^9, 
   3.825489696084631*^9, 3.8269465204664392`*^9, 3.826946765990406*^9, 
   3.8269469708876333`*^9, 3.8269475992209496`*^9, 3.8269487864920845`*^9, 
   3.82694996619818*^9, 3.8269662429631877`*^9, 3.8278401181709785`*^9, 
   3.828176454328435*^9, 3.8281875224569197`*^9, 3.8286141701660023`*^9, 
   3.8286143656516285`*^9, 3.828687419893956*^9, 3.8305972510255547`*^9, 
   3.8316059290809593`*^9, 3.831623027906578*^9, 3.832145879244528*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"8b38ac73-f336-430c-b9e1-d5e7aa5cab05"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Effect on the peak profile of aberrations in the \
equatorial plane (hat shape function)", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
   3.794473090557276*^9, 3.794473100964528*^9}, {3.8201203831885056`*^9, 
   3.820120405845306*^9}, {3.820134318920413*^9, 3.820134354280964*^9}, 
   3.8201344101726217`*^9},
 CellTags->"Title",ExpressionUUID->"c9d89525-b45e-4235-b55e-f22973fadf30"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fwhmabs", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "fwhmpos", ",", " ", "\[IndentingNewLine]", "               ", 
         "points", ",", "\[IndentingNewLine]", "               ", 
         "\[Theta]\[Theta]", ",", "\[IndentingNewLine]", "              ", 
         "leftbound1", ",", "rightbound1", ",", "  ", "stepw1", ",", "grid1", 
         ",", "middle1", ",", " ", "kernel1", ",", " ", "lc1", ",", 
         "\[IndentingNewLine]", "              ", "leftbound2", ",", 
         "rightbound2", ",", "  ", "stepw2", ",", "grid2", ",", "middle2", 
         ",", " ", "kernel2", ",", " ", "lc2", ",", "\[IndentingNewLine]", 
         "              ", "ftlc", ",", " ", "lp1", ",", "lp2", ",", " ", 
         "lp3", ",", "lp4", ",", "\[Theta]\[Theta]pos"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "     ", 
       RowBox[{
        RowBox[{"points", "         ", "=", " ", "4096"}], ";", 
        "\[IndentingNewLine]", "    ", 
        RowBox[{"\[Theta]\[Theta]", "                  ", "=", " ", 
         RowBox[{"\[Theta]2", "[", 
          RowBox[{"ss", ",", "lambda"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"2", "\[Theta]"}], "-", "space"}], " ", "*)"}], 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"leftbound1", "   ", "=", " ", 
         RowBox[{"\[Theta]\[Theta]", " ", "-", " ", 
          RowBox[{"6.", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]", 
        "   ", 
        RowBox[{"rightbound1", "=", " ", 
         RowBox[{"\[Theta]\[Theta]", " ", "+", " ", 
          RowBox[{"6.", " ", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]",
         "   ", 
        RowBox[{"stepw1", "           ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound1", "-", "leftbound1"}], ")"}], "/", 
          "points"}]}], ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"grid1", "             ", "=", " ", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound1", ",", "rightbound1", ",", "stepw1"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"middle1", "        ", "=", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "grid1", "]"}], "/", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "  ", 
        RowBox[{"kernel1", "         ", "=", 
         RowBox[{"VoigtApproxTable", "[", 
          RowBox[{
          "\[Delta]", ",", "\[Sigma]", ",", "\[Theta]\[Theta]", ",", 
           "grid1"}], "]"}]}], ";", "\[IndentingNewLine]", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"=", 
             RowBox[{"1", "/", "d"}]}], ")"}]}], " ", "-", "space"}], " ", 
         "*)"}], "\[IndentingNewLine]", "    ", 
        RowBox[{"leftbound2", "   ", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"leftbound1", ",", "lambda"}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"rightbound2", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"rightbound1", ",", "lambda"}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"stepw2", "            ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound2", "-", "leftbound2"}], ")"}], "/", 
          "points"}]}], ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"grid2", "              ", "=", " ", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound2", ",", "rightbound2", ",", "stepw2"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"middle2", "        ", "=", "  ", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "grid2", "]"}], "/", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"kernel2", "        ", "=", "  ", 
         RowBox[{"VoigtApproxTable", "[", 
          RowBox[{
           RowBox[{"\[Delta]", " ", 
            RowBox[{"cs", "[", 
             RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
           RowBox[{"\[Sigma]", " ", 
            RowBox[{"cs", "[", 
             RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", "ss", 
           ",", "grid2"}], "]"}]}], ";", "\[IndentingNewLine]", "  ", 
        "\[IndentingNewLine]", "    ", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"source", "\[Equal]", "\"\<Width of source\>\""}], ",", 
          "                ", 
          RowBox[{"{", 
           RowBox[{"lc1", "=", 
            RowBox[{"boxTable", "[", 
             RowBox[{
              RowBox[{"Size", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "c1", ",", "rs"}], "]"}], ",",
               "\[Theta]\[Theta]", ",", "grid1"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"source", "\[Equal]", "\"\<Receiving slit width\>\""}], ",",
           "     ", 
          RowBox[{"{", 
           RowBox[{"lc1", "=", 
            RowBox[{"boxTable", "[", 
             RowBox[{
              RowBox[{"Size", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "c2", ",", "rs"}], "]"}], ",",
               "\[Theta]\[Theta]", ",", "grid1"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"source", "\[Equal]", "\"\<Specimen tilt\>\""}], ",", 
          "                     ", 
          RowBox[{"{", 
           RowBox[{"lc1", "=", 
            RowBox[{"boxTable", "[", 
             RowBox[{
              RowBox[{"SpecimenTilt", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "c3", ",", "rs"}], "]"}], ",",
               "\[Theta]\[Theta]", ",", "grid1"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", "               ", 
          RowBox[{"source", "\[Equal]", "\"\<Tube tails\>\""}], ",", 
          "                           ", 
          RowBox[{"{", 
           RowBox[{"lc1", "=", 
            RowBox[{"tubetailTable", "[", 
             RowBox[{
              RowBox[{"Size", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "c1", ",", "rs"}], "]"}], ",",
               " ", 
              RowBox[{"Size", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", 
                RowBox[{"-", "z1"}], ",", "rs"}], "]"}], ",", " ", 
              RowBox[{"Size", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "   ", "z2", ",", "rs"}], 
               "]"}], ",", " ", "frac", ",", "\[Theta]\[Theta]", ",", " ", 
              "grid1"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", 
         "             ", "]"}], ";", "\[IndentingNewLine]", "    ", 
        RowBox[{"lc2", "=", 
         RowBox[{"lc1", " ", 
          RowBox[{"cs", "[", 
           RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}]}], ";", " ", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "     ", 
        RowBox[{"lc1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"ListConvolve", "[", 
            RowBox[{"lc1", ",", "kernel1", ",", "middle1"}], "]"}], " ", 
           "stepw1"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", "     ", 
        RowBox[{"lc2", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"ListConvolve", "[", 
            RowBox[{"lc2", ",", "kernel2", ",", "middle2"}], "]"}], " ", 
           "stepw2"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"fwhmpos", "=", 
         RowBox[{"fwhmcalc", "[", 
          RowBox[{
           RowBox[{"Transpose", " ", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"grid1", "-", "\[Theta]\[Theta]"}], ",", "lc1"}], "}"}],
             "]"}], ",", "8"}], "]"}]}], ";", "\[IndentingNewLine]", "     ", 
        RowBox[{"fwhmabs", "=", " ", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"fwhmpos", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
          RowBox[{"Abs", "[", 
           RowBox[{"fwhmpos", "[", 
            RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}]}], ";", 
        "\[IndentingNewLine]", "     ", "\[IndentingNewLine]", "     ", 
        RowBox[{"ftlc", "  ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"grid2", "-", "ss"}], ",", "lc2"}], "}"}], "]"}], ",",
              "1.0"}], "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp1", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{"lc1", ",", "      ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound1", ",", " ", "rightbound1"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"leftbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                  "/", "xMag"}], "+", "\[Theta]\[Theta]"}], ",", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"rightbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                  "/", "xMag"}], "+", "\[Theta]\[Theta]"}]}], "}"}], ",", 
              "Full"}], "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Epilog", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Inset", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"fwhmabs", ",", "3"}], "]"}], "]"}], 
                    "\"\<fwhm/\[Degree]2\[Theta] \>\""}], ",", "20"}], "]"}], 
                 " ", "]"}], ",", 
                RowBox[{"ImageScaled", "[", 
                 RowBox[{"{", 
                  RowBox[{"0.25", ",", "0.85"}], "}"}], "]"}]}], "]"}], ",", 
              RowBox[{"InfiniteLine", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ",", " ",
            "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp2", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{"lc2", ",", "      ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound2", ",", " ", "rightbound2"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"leftbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                 "+", "ss"}], ",", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"rightbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                 "+", "ss"}]}], "}"}], ",", "Full"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "      ", 
        RowBox[{"lp3", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ftlc", "[", "x", "]"}], "}"}], ",", 
           "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "32."}], "/", 
                RowBox[{"(", 
                 RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
              "/", "kMag"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"32.", "/", 
                RowBox[{"(", 
                 RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
              "/", "kMag"}]}], "}"}], ",", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Fourier transform of diffraction peak\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp4", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"source", "\[Equal]", "\"\<Width of source\>\""}], ",", 
             "            ", 
             RowBox[{"{", 
              RowBox[{"Size", "[", 
               RowBox[{"x", ",", "c1", ",", "rs"}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", "                                      ", 
             RowBox[{"source", "\[Equal]", "\"\<Receiving slit width\>\""}], 
             ",", " ", 
             RowBox[{"{", 
              RowBox[{"Size", "[", 
               RowBox[{"x", ",", "c2", ",", "rs"}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", "                                      ", 
             RowBox[{"source", "\[Equal]", "\"\<Specimen tilt\>\""}], ",", 
             "                 ", 
             RowBox[{"{", 
              RowBox[{"SpecimenTilt", "[", 
               RowBox[{"x", ",", "c3", ",", "rs"}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", "                                      ", 
             RowBox[{"source", "\[Equal]", "\"\<Tube tails\>\""}], ",", 
             "                     ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Size", "[", 
                RowBox[{"x", ",", "c1", ",", "rs"}], "]"}], ",", " ", 
               RowBox[{"Size", "[", 
                RowBox[{"x", ",", 
                 RowBox[{"-", "z1"}], ",", "rs"}], "]"}], ",", " ", 
               RowBox[{"Size", "[", 
                RowBox[{"x", ",", " ", "z2", ",", "rs"}], "]"}]}], "}"}]}], 
            "   ", "]"}], ",", "                      ", 
           "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", "0.0", ",", "180.0"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              RowBox[{"source", "<>", "\"\< (\[Degree]2\[Theta])\>\""}]}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]",
            "                                                          ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", "source", "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.6", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"\[Theta]\[Theta]pos", "=", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"\[Theta]\[Theta]", ",", 
               RowBox[{"Which", "[", 
                RowBox[{
                 RowBox[{"source", "\[Equal]", "\"\<Width of source\>\""}], 
                 ",", "            ", 
                 RowBox[{"Size", "[", 
                  RowBox[{"\[Theta]\[Theta]", ",", "c1", ",", "rs"}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "                                                            \
                                                              ", 
                 RowBox[{
                 "source", "\[Equal]", "\"\<Receiving slit width\>\""}], ",", 
                 " ", 
                 RowBox[{"Size", "[", 
                  RowBox[{"\[Theta]\[Theta]", ",", "c2", ",", "rs"}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "                                                            \
                                                              ", 
                 RowBox[{"source", "\[Equal]", "\"\<Specimen tilt\>\""}], ",",
                  "                 ", 
                 RowBox[{"SpecimenTilt", "[", 
                  RowBox[{"\[Theta]\[Theta]", ",", "c3", ",", "rs"}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "                                                            \
                                                              ", 
                 RowBox[{"source", "\[Equal]", "\"\<Tube tails\>\""}], ",", 
                 "                        ", 
                 RowBox[{"Size", "[", 
                  RowBox[{"\[Theta]\[Theta]", ",", "c1", ",", "rs"}], "]"}]}],
                 "   ", "]"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", 
           "                                  ", "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"If", "[", 
         RowBox[{"export", ",", 
          RowBox[{"{", "\[IndentingNewLine]", "                       ", 
           RowBox[{
            RowBox[{"Export", "[", 
             RowBox[{"filePath", ",", 
              RowBox[{"{", 
               RowBox[{
               "lp1", ",", "lp2", ",", "lp3", ",", "lp4", ",", 
                "\[Theta]\[Theta]pos"}], "}"}]}], "]"}], ",", " ", 
            "\[IndentingNewLine]", "                       ", 
            RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
           "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
         "]"}], ";", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{"help", ",", 
          RowBox[{"{", "\[IndentingNewLine]", "                       ", 
           RowBox[{
            RowBox[{"MessageDialog", "[", "\"\<Text\>\"", "]"}], ",", 
            "\[IndentingNewLine]", "                       ", 
            RowBox[{"help", "=", "False"}]}], "\[IndentingNewLine]", 
           "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
         "]"}], ";", " ", "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
        RowBox[{"Grid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lp1", ",", "lp2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"lp3", ",", 
             RowBox[{"Show", "[", 
              RowBox[{"lp4", ",", "\[Theta]\[Theta]pos"}], "]"}]}], "}"}]}], 
          "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "              ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Voigt function\>\"", ",", "16", ",", "Bold"}], "]"}],
            "]"}], "}"}], ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<\[Delta] \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Delta]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",",
               "0.001", ",", "1.", ",", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Slider", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Delta]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                    RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                  "\"\< \>\"", ",", 
                  RowBox[{"InputField", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                 "}"}], "]"}], "&"}]}], "}"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
         "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<\[Sigma] \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Sigma]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",",
               "0.001", ",", "1.", ",", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Slider", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                    RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                  "\"\< \>\"", ",", 
                  RowBox[{"InputField", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                 "}"}], "]"}], "&"}]}], "}"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
         "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Voigt   fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Voigtfwhm", "[", 
               RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<mixing  \[Delta]/\[Sigma] \>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Mix", "[", 
               RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}], "}"}]}], 
        "\[IndentingNewLine]", "        ", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Left", "}"}], ",", 
          RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
     " ", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Type of aberration in the equatorial plane\>\"", ",", "16", ",", 
        "Bold"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "source", ",", "\"\<Receiving slit width\>\"", ",", "\"\<\>\""}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Width of source\>\"", ",", "\"\<Specimen tilt\>\"", ",", 
          "\"\<Receiving slit width\>\"", ",", "\"\<Tube tails\>\""}], "}"}], 
        ",", "RadioButton", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",",
      "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Parameters of diffractometer\>\"", ",", "16", ",", "Bold"}], 
       "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "                ", 
        RowBox[{
         RowBox[{"{", "   ", 
          RowBox[{"\"\<secondary diffract. radius\>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"rs", ",", "217.5", ",", "\"\<\>\""}], "}"}], ",", 
              "10.", ",", " ", "300.", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<mm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "                ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<source width              \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"c1", ",", "1.0", ",", "\"\<\>\""}], "}"}], ",", 
              "0.03", ",", "2.0", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<mm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "                ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<receiving slit width      \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"c2", ",", "0.2", ",", "\"\<\>\""}], "}"}], ",", 
              "0.03", ",", " ", "2.", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<mm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "                ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<specimen tilt             \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"c3", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
              "0.000001", ",", " ", "5.", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<mm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "                ", 
         RowBox[{"{", "   ", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"InsertLinebreaks", "[", 
              RowBox[{
              "\"\<Eff. width of tube tails in the equator. plane perpend. to \
the X-ray beam:\>\"", ",", "30"}], "]"}], ",", "Bold"}], "]"}], "]"}], "}"}], 
         ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<neg. z-dir.                \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"z1", ",", "0.4", ",", "\"\<\>\""}], "}"}], ",", 
              "0.01", ",", "3.", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<mm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<pos. z-dir.                \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"z2", ",", "0.4", ",", "\"\<\>\""}], "}"}], ",", 
              "0.01", ",", " ", "3.", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<mm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<fract. height of the tube tails \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"frac", ",", "0.05", ",", "\"\<\>\""}], "}"}], ",", 
              "0.01", ",", " ", "1.", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], 
             "}"}]}]}], " ", "}"}], ",", "\[IndentingNewLine]", 
         "               ", 
         RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<wavelength \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "      ", 
               RowBox[{
               "lambda", ",", "       ", "0.154059", ",", "\"\<\>\""}], "}"}],
               ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "   ", 
          RowBox[{
          "\"\<peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))\>\"", ",", 
           "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", " ", 
               RowBox[{"ss", ",", "5.", ",", "\"\<\>\""}], "}"}], ",", 
              "0.001", ",", 
              RowBox[{"2.", "/", "lambda"}], ",", "Slider", ",", " ", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", "               ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<peak center (d)\>\"", ",", "     ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"1", "/", "ss"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}],
           "}"}], ",", "\[IndentingNewLine]", "               ", 
         RowBox[{"{", " ", 
          RowBox[{"\"\<peak center (2\[Theta])\>\"", ",", "  ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", " ", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{"ss", ",", "lambda"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]\>\""}], "}"}]}], 
        "                                          ", "\[IndentingNewLine]", 
        "        ", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Left", "}"}], ",", 
          RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "       ", 
         RowBox[{
         "xMag", ",", "1.", ",", "\"\<zoom factor in 2\[Theta]-space\>\""}], 
         "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
        ",", 
        RowBox[{"Exclusions", "\[Rule]", 
         RowBox[{"{", "0", "}"}]}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "       ", 
         RowBox[{
         "kMag", ",", "1.", ",", "\"\<zoom factor in Fourier-space\>\""}], 
         "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
        ",", 
        RowBox[{"Exclusions", "\[Rule]", 
         RowBox[{"{", "0", "}"}]}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]",
      "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Export to desktop\>\"", ",", 
       RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"help", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Help\>\"", ",", 
       RowBox[{"help", "=", "True"}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<by R. E. Dinnebier & P. Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
        "\"\<Effect on the peak profile of hat shape aberrations in the \
equatorial plane\\n\>\""}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", " ", 
     RowBox[{"ControlPlacement", "\[Rule]", 
      RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"must", " ", "be", " ", 
       RowBox[{"true", " ", "!"}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ","}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"TrackedSymbols", "\[Rule]", "True"}], " ", ",", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], 
    "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.819728492794449*^9, 3.8197284932455807`*^9}, {
   3.819728625421876*^9, 3.819728626717719*^9}, {3.819728677281361*^9, 
   3.8197286916098843`*^9}, {3.8197291134280157`*^9, 3.8197291195744543`*^9}, 
   3.819729272016214*^9, {3.819729449430892*^9, 3.819729562695278*^9}, {
   3.819729640739251*^9, 3.819729689417652*^9}, 3.8197298058324804`*^9, {
   3.819729920087845*^9, 3.819729924798761*^9}, {3.819729963893061*^9, 
   3.819729964205609*^9}, {3.8197300109100018`*^9, 3.819730027691801*^9}, {
   3.81973012230657*^9, 3.8197301263816333`*^9}, {3.819790126139161*^9, 
   3.8197901337368383`*^9}, {3.8197902062705264`*^9, 3.819790210020707*^9}, {
   3.819790785984022*^9, 3.8197907961179748`*^9}, {3.819792686972494*^9, 
   3.8197926880348387`*^9}, {3.819792718332367*^9, 3.8197927977098866`*^9}, {
   3.819793546231357*^9, 3.819793592623288*^9}, {3.8197936472966633`*^9, 
   3.8197936611722803`*^9}, {3.8197938108950267`*^9, 
   3.8197939558054085`*^9}, {3.8197940300107384`*^9, 3.819794031916913*^9}, {
   3.8197940741370335`*^9, 3.819794096059348*^9}, {3.819794317097081*^9, 
   3.819794318206133*^9}, {3.81994928417307*^9, 3.819949285532399*^9}, {
   3.8199493529207053`*^9, 3.8199493772480264`*^9}, {3.819949437415901*^9, 
   3.8199494473162775`*^9}, {3.8199495087659454`*^9, 
   3.8199495156966248`*^9}, {3.8199495838078737`*^9, 3.819949590495144*^9}, 
   3.8199497674365063`*^9, {3.819949806546152*^9, 3.81994996558689*^9}, {
   3.819950043162286*^9, 3.8199501845784645`*^9}, {3.819950233619505*^9, 
   3.8199502343538523`*^9}, {3.8199502662277164`*^9, 3.819950271305624*^9}, 
   3.8199548289951043`*^9, {3.8199549032181487`*^9, 3.8199549127656813`*^9}, {
   3.819954990001178*^9, 3.8199550333475776`*^9}, {3.819955433885533*^9, 
   3.8199554407553506`*^9}, {3.8199556170973134`*^9, 3.819955617197615*^9}, {
   3.8199556579995203`*^9, 3.819955665555208*^9}, {3.819955699520218*^9, 
   3.819955724936166*^9}, {3.819955784277455*^9, 3.819955798323655*^9}, {
   3.81995594977618*^9, 3.819955953387624*^9}, {3.819956296798997*^9, 
   3.8199563635770674`*^9}, {3.819956405617238*^9, 3.8199564634584723`*^9}, {
   3.81995659006818*^9, 3.819956594103692*^9}, {3.819956739198935*^9, 
   3.8199567686274295`*^9}, {3.819958569932622*^9, 3.819958622345554*^9}, {
   3.819958805034949*^9, 3.819958930989318*^9}, {3.819959173591346*^9, 
   3.819959184907379*^9}, {3.819960616244831*^9, 3.8199606540876265`*^9}, {
   3.820051335864154*^9, 3.8200515115100107`*^9}, {3.8200516541552877`*^9, 
   3.8200516571709538`*^9}, {3.8200522887846923`*^9, 
   3.8200522983162446`*^9}, {3.8200527026101685`*^9, 
   3.8200527938003335`*^9}, {3.820052844708329*^9, 3.8200528624900227`*^9}, {
   3.8200529182573366`*^9, 3.820052932851428*^9}, {3.8200530250106564`*^9, 
   3.820053079387211*^9}, {3.82005317015576*^9, 3.8200531724058433`*^9}, {
   3.820053212079077*^9, 3.8200532466734533`*^9}, {3.8200533432546196`*^9, 
   3.820053381833788*^9}, {3.820053429757244*^9, 3.820053432210325*^9}, {
   3.820053888708329*^9, 3.820053890911499*^9}, {3.8200540164776616`*^9, 
   3.820054048822542*^9}, {3.8200541992799683`*^9, 3.820054249000436*^9}, {
   3.8200543321902947`*^9, 3.8200543563941026`*^9}, {3.820054404285946*^9, 
   3.820054410864315*^9}, {3.8200545650875716`*^9, 3.82005461435716*^9}, {
   3.820056328731359*^9, 3.8200563567630453`*^9}, {3.820056428098807*^9, 
   3.8200564399062595`*^9}, {3.820056516533333*^9, 3.8200565223459277`*^9}, {
   3.8200566229265957`*^9, 3.8200566582333126`*^9}, {3.8200568318701673`*^9, 
   3.8200569112994194`*^9}, {3.8200569471388807`*^9, 
   3.8200569632796125`*^9}, {3.820057642830802*^9, 3.820057704534196*^9}, {
   3.82005778043912*^9, 3.820057794817848*^9}, {3.820057915852412*^9, 
   3.820057916899253*^9}, {3.820058180327685*^9, 3.8200582340011744`*^9}, {
   3.8200583071903787`*^9, 3.8200583088938417`*^9}, {3.82005849155733*^9, 
   3.8200585549781504`*^9}, {3.8200614889746857`*^9, 
   3.8200615530388985`*^9}, {3.8200619414234257`*^9, 3.820061944095337*^9}, {
   3.8200621030210266`*^9, 3.820062106130537*^9}, {3.820062145897167*^9, 
   3.8200621851793933`*^9}, {3.820063988254425*^9, 3.8200640542560353`*^9}, {
   3.8200641050696573`*^9, 3.8200641267109566`*^9}, {3.820064163649234*^9, 
   3.8200642019629173`*^9}, {3.8200642391043425`*^9, 
   3.8200642536670895`*^9}, {3.820064345716237*^9, 3.8200643521694603`*^9}, {
   3.820064606285*^9, 3.820064697490368*^9}, {3.820118967250663*^9, 
   3.820118995126238*^9}, {3.8201190328146763`*^9, 3.8201191469894657`*^9}, {
   3.820119951835021*^9, 3.8201200016174045`*^9}, {3.820120440252187*^9, 
   3.8201205691143284`*^9}, {3.82012060633399*^9, 3.8201206109121294`*^9}, {
   3.820120676210512*^9, 3.8201206773823457`*^9}, {3.8201207103520684`*^9, 
   3.820120800728956*^9}, {3.8201208403860273`*^9, 3.820120856495741*^9}, {
   3.820121019936925*^9, 3.8201210758914194`*^9}, {3.820121130611267*^9, 
   3.820121151518222*^9}, {3.82012146414999*^9, 3.820121475603373*^9}, {
   3.820121510353907*^9, 3.820121525823312*^9}, {3.8201215935118713`*^9, 
   3.8201216415600133`*^9}, {3.82012167290483*^9, 3.8201218240485106`*^9}, {
   3.820122562127669*^9, 3.82012259267509*^9}, {3.820122629566326*^9, 
   3.82012265302291*^9}, {3.8201232879561768`*^9, 3.8201232888939667`*^9}, {
   3.8201248184124575`*^9, 3.8201248824453154`*^9}, {3.8201250140579753`*^9, 
   3.820125057409334*^9}, {3.82012944071832*^9, 3.8201295015791845`*^9}, {
   3.820129540642418*^9, 3.8201296057376213`*^9}, {3.8201296568168077`*^9, 
   3.8201297039274645`*^9}, {3.8201297392097297`*^9, 3.820129824101841*^9}, {
   3.8201298637901974`*^9, 3.820130056075783*^9}, {3.820130200563362*^9, 
   3.820130216844943*^9}, {3.820130264564714*^9, 3.8201302782525053`*^9}, 
   3.8201303787234526`*^9, {3.820130451928259*^9, 3.820130458803444*^9}, {
   3.8201307027307434`*^9, 3.8201307142309837`*^9}, {3.820130850999633*^9, 
   3.820131013456335*^9}, {3.8201319880716147`*^9, 3.8201320014785047`*^9}, {
   3.820132121934329*^9, 3.8201321961550145`*^9}, {3.8201339025517006`*^9, 
   3.8201339030051737`*^9}, {3.820151435109483*^9, 3.8201514371720505`*^9}, {
   3.82015158594343*^9, 3.8201516847285223`*^9}, {3.8201621328750553`*^9, 
   3.8201621561416516`*^9}, {3.8201625166821585`*^9, 3.820162542995212*^9}, {
   3.820162780470229*^9, 3.8201627840482144`*^9}, {3.8201631501359234`*^9, 
   3.8201631511517725`*^9}, {3.820163401595292*^9, 3.8201634195333185`*^9}, {
   3.820163461378135*^9, 3.820163472784955*^9}, {3.8201642688516912`*^9, 
   3.8201643051809635`*^9}, {3.8201643463223457`*^9, 
   3.8201643504477677`*^9}, {3.8201644209809036`*^9, 
   3.8201644220586305`*^9}, {3.820165223172457*^9, 3.820165226313103*^9}, {
   3.820165343237808*^9, 3.8201653480036077`*^9}, {3.820165400098864*^9, 
   3.820165417895825*^9}, {3.8201655278986096`*^9, 3.8201655806342335`*^9}, {
   3.820165738013099*^9, 3.8201657478883333`*^9}, {3.820165827093341*^9, 
   3.8201658741259427`*^9}, {3.820165931970945*^9, 3.8201659352525663`*^9}, {
   3.820166104428131*^9, 3.8201661333354826`*^9}, {3.820210824848721*^9, 
   3.8202108255954475`*^9}, {3.821367960145193*^9, 3.821367993927549*^9}, {
   3.8213680244583015`*^9, 3.8213681934802485`*^9}, {3.8213685901754665`*^9, 
   3.821368591415351*^9}, {3.8213686817918644`*^9, 3.821368755340894*^9}, {
   3.82136894595582*^9, 3.8213690894287686`*^9}, {3.8213692956692843`*^9, 
   3.8213693062164917`*^9}, {3.8213693553270087`*^9, 3.821369358217866*^9}, {
   3.821369972111298*^9, 3.8213699723608437`*^9}, {3.821370778259485*^9, 
   3.8213707797281322`*^9}, {3.8213708138231955`*^9, 3.821370872168575*^9}, {
   3.8213747692331457`*^9, 3.8213747697176275`*^9}, 3.8214240153010063`*^9, {
   3.821424079669924*^9, 3.8214242417709017`*^9}, {3.821424280383169*^9, 
   3.821424368918544*^9}, {3.8214246327402954`*^9, 3.8214246840560284`*^9}, 
   3.821424721063921*^9, {3.82142475205293*^9, 3.821424887881631*^9}, {
   3.821424976284298*^9, 3.821425037708008*^9}, {3.8214250788301153`*^9, 
   3.821425086370941*^9}, 3.8214251312684913`*^9, {3.8214252605280647`*^9, 
   3.821425382905331*^9}, {3.8246473746763363`*^9, 3.824647433863231*^9}, {
   3.824647961655281*^9, 3.824647962374189*^9}, {3.8246507647581253`*^9, 
   3.824650770842658*^9}, {3.8246508427309027`*^9, 3.824650856747243*^9}, {
   3.824650900624569*^9, 3.824650926110449*^9}, {3.8246509749879723`*^9, 
   3.8246510213921957`*^9}, {3.8246510655396905`*^9, 
   3.8246511223395386`*^9}, {3.8246511644512367`*^9, 
   3.8246511866711187`*^9}, {3.824651222426963*^9, 3.824651572848004*^9}, {
   3.8246516913220663`*^9, 3.8246517073227487`*^9}, {3.8246517376368766`*^9, 
   3.824651767247667*^9}, {3.8246517984833937`*^9, 3.8246518009063115`*^9}, {
   3.8246518860503807`*^9, 3.824651888785113*^9}, {3.824651921271126*^9, 
   3.824651986220934*^9}, 3.824652089935423*^9, {3.8246527618265533`*^9, 
   3.8246528183292127`*^9}, {3.8246528855823936`*^9, 3.8246529819306*^9}, {
   3.8246530275731564`*^9, 3.8246530891854296`*^9}, {3.824653162688764*^9, 
   3.824653162813803*^9}, {3.8248008182430353`*^9, 3.824800971387087*^9}, {
   3.8248010037785788`*^9, 3.824801058248683*^9}, {3.8248011211097684`*^9, 
   3.8248011400004787`*^9}, {3.8248012036742516`*^9, 
   3.8248012361591043`*^9}, {3.824801281269489*^9, 3.8248012830663323`*^9}, {
   3.824801460273568*^9, 3.8248015019306755`*^9}, {3.8248016981072283`*^9, 
   3.8248017914218206`*^9}, {3.824801914018293*^9, 3.8248019141279163`*^9}, {
   3.824802047130722*^9, 3.824802103007017*^9}, {3.824802153680204*^9, 
   3.8248022510106344`*^9}, {3.824802435155308*^9, 3.8248024706718473`*^9}, {
   3.8248025028289413`*^9, 3.824802650707061*^9}, {3.8248028221328893`*^9, 
   3.8248028515554056`*^9}, {3.8248029313230934`*^9, 
   3.8248029560893974`*^9}, {3.8248030237940392`*^9, 3.82480311535822*^9}, {
   3.824803194438548*^9, 3.8248032120010524`*^9}, {3.8248032858741436`*^9, 
   3.8248032862527676`*^9}, {3.824804462482257*^9, 3.8248044880611115`*^9}, 
   3.8248045486872783`*^9, {3.8248050868243055`*^9, 3.8248050895902357`*^9}, {
   3.824805151544318*^9, 3.8248051537477455`*^9}, {3.82480522718648*^9, 
   3.824805235718094*^9}, {3.8248053545176144`*^9, 3.8248053702368565`*^9}, {
   3.824805428972213*^9, 3.824805434660025*^9}, {3.824961172746439*^9, 
   3.824961204731442*^9}, {3.8249612383728247`*^9, 3.82496123890404*^9}, 
   3.824961344875084*^9, {3.8254899844946856`*^9, 3.82549000343202*^9}, {
   3.8269009346538515`*^9, 3.826900941185317*^9}, {3.826901411428811*^9, 
   3.826901418116875*^9}, {3.8269439503884416`*^9, 3.8269439939057436`*^9}, {
   3.826944032141658*^9, 3.8269440725803146`*^9}, {3.8269442679008446`*^9, 
   3.8269443876551685`*^9}, {3.8269444199641237`*^9, 3.826944467236539*^9}, {
   3.826944505065964*^9, 3.826944505409582*^9}, {3.8269455421794057`*^9, 
   3.8269455429326878`*^9}, {3.826946840774399*^9, 3.8269468642005014`*^9}, {
   3.826946926076068*^9, 3.8269469262144747`*^9}, {3.826947056453332*^9, 
   3.8269471678739605`*^9}, {3.8269472302086887`*^9, 
   3.8269472632879906`*^9}, {3.826947313130618*^9, 3.826947317383783*^9}, {
   3.826947470275996*^9, 3.826947472998083*^9}, {3.826948090862052*^9, 
   3.82694809139261*^9}, {3.8269481445288773`*^9, 3.8269481589882035`*^9}, {
   3.8269482365110416`*^9, 3.8269482369596186`*^9}, {3.8269482688230205`*^9, 
   3.8269482705074234`*^9}, {3.826948367025915*^9, 3.826948373666792*^9}, {
   3.826948433153285*^9, 3.826948478232419*^9}, {3.8269485221900196`*^9, 
   3.826948522812106*^9}, {3.8269486874525986`*^9, 3.826948687910686*^9}, {
   3.8269488697756834`*^9, 3.8269488698536067`*^9}, {3.826949126049222*^9, 
   3.826949130611593*^9}, {3.8269491821631365`*^9, 3.8269492195987744`*^9}, {
   3.8269493279456644`*^9, 3.826949329086159*^9}, {3.8269493621494923`*^9, 
   3.826949371837676*^9}, {3.8269494098229537`*^9, 3.8269494125417604`*^9}, {
   3.8269494511661863`*^9, 3.8269494517459946`*^9}, 3.826949575359042*^9, {
   3.826949623688716*^9, 3.8269496342983665`*^9}, {3.8269498198350763`*^9, 
   3.826949908274984*^9}, {3.826949951094795*^9, 3.8269499516042824`*^9}, {
   3.826960434936776*^9, 3.826960435468218*^9}, {3.8269605106100125`*^9, 
   3.8269605156386876`*^9}, {3.826960562972638*^9, 3.826960806866319*^9}, {
   3.826961270502596*^9, 3.8269613779464917`*^9}, 3.8269619391718206`*^9, {
   3.8269620238922896`*^9, 3.8269620239861917`*^9}, {3.8281764885544043`*^9, 
   3.828176491493815*^9}, {3.828181533076604*^9, 3.828181770539136*^9}, {
   3.8281819031238527`*^9, 3.828181978159999*^9}, {3.8281820974371557`*^9, 
   3.8281821262968273`*^9}, {3.828182164757292*^9, 3.828182168074648*^9}, {
   3.8281822027183876`*^9, 3.828182235794951*^9}, {3.828182282476309*^9, 
   3.8281823165131874`*^9}, {3.828182356533861*^9, 3.8281823982157416`*^9}, {
   3.8281832436090746`*^9, 3.8281832444956226`*^9}, {3.828183290983968*^9, 
   3.8281833746644106`*^9}, {3.828183545236946*^9, 3.828183586285347*^9}, {
   3.828183667960821*^9, 3.8281836962829328`*^9}, {3.828184593971246*^9, 
   3.8281846016007195`*^9}, {3.8281846475926504`*^9, 3.828184670320657*^9}, {
   3.8281847020126743`*^9, 3.8281847219231544`*^9}, {3.8281847626707563`*^9, 
   3.8281848313535786`*^9}, {3.8281848725715923`*^9, 
   3.8281848775550556`*^9}, {3.828187550385209*^9, 3.8281875776658545`*^9}, {
   3.828187634442156*^9, 3.8281877388803124`*^9}, {3.830597074227168*^9, 
   3.8305971555797153`*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"3501e88b-74bc-41f1-84ac-51d11368c340"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c1$$ = 1., $CellContext`c2$$ = 
    0.2, $CellContext`c3$$ = 0.03, $CellContext`export$$ = 
    False, $CellContext`frac$$ = 0.05, $CellContext`help$$ = 
    False, $CellContext`kMag$$ = 1., $CellContext`lambda$$ = 
    0.154059, $CellContext`rs$$ = 217.5, $CellContext`source$$ = 
    "Receiving slit width", $CellContext`ss$$ = 5., $CellContext`xMag$$ = 
    1.2000000000000002`, $CellContext`z1$$ = 0.4, $CellContext`z2$$ = 
    0.4, $CellContext`\[Delta]$$ = 
    0.004897788193684461, $CellContext`\[Sigma]$$ = 0.0047315125896148025`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.03, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`\[Sigma]$$], 0.03, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{
          Text[
           Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
          Dynamic[
           NumberForm[
            $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Type of aberration in the equatorial plane", 16, Bold]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`source$$], "Receiving slit width", ""}, {
      "Width of source", "Specimen tilt", "Receiving slit width", 
       "Tube tails"}}, {
      Hold[
       Text[
        Style["Parameters of diffractometer", 16, Bold]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`rs$$], 217.5, ""}, 10., 300.}, {{
       Hold[$CellContext`c1$$], 1., ""}, 0.03, 2.}, {{
       Hold[$CellContext`c2$$], 0.2, ""}, 0.03, 2.}, {{
       Hold[$CellContext`c3$$], 0.03, ""}, 1.*^-6, 5.}, {{
       Hold[$CellContext`z1$$], 0.4, ""}, 0.01, 3.}, {{
       Hold[$CellContext`z2$$], 0.4, ""}, 0.01, 3.}, {{
       Hold[$CellContext`frac$$], 0.05, ""}, 0.01, 1.}, {{
       Hold[$CellContext`lambda$$], 0.154059, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`ss$$], 5., ""}, 0.001, 
      Dynamic[2./$CellContext`lambda$$]}, {
      Hold[
       Grid[{{"secondary diffract. radius", 
          Manipulate`Place[3], "mm"}, {"source width              ", 
          Manipulate`Place[4], "mm"}, {"receiving slit width      ", 
          Manipulate`Place[5], "mm"}, {"specimen tilt             ", 
          Manipulate`Place[6], "mm"}, {
          Text[
           Style[
           "Eff. width of tube tails in\nthe equator. plane perpend. to\nthe \
X-ray beam:", Bold]]}, {"neg. z-dir.                ", 
          Manipulate`Place[7], "mm"}, {"pos. z-dir.                ", 
          Manipulate`Place[8], "mm"}, {"fract. height of the tube tails ", 
          Manipulate`Place[9]}, {}, {"wavelength ", 
          Manipulate`Place[10], "nm"}, {
         "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
          Manipulate`Place[11], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
         "peak center (d)", 
          Dynamic[
           NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
         "peak center (2\[Theta])", 
          Dynamic[
           NumberForm[
            $CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$], \
{3, 5}]], "\[Degree]"}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1., "zoom factor in 2\[Theta]-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1., "zoom factor in Fourier-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`help$$], False}, 0}, {
      Hold[
       Button["Help", $CellContext`help$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1009., {342., 348.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`c1$$ = 1., $CellContext`c2$$ = 
        0.2, $CellContext`c3$$ = 0.03, $CellContext`export$$ = 
        False, $CellContext`frac$$ = 0.05, $CellContext`help$$ = 
        False, $CellContext`kMag$$ = 1., $CellContext`lambda$$ = 
        0.154059, $CellContext`rs$$ = 217.5, $CellContext`source$$ = 
        "Receiving slit width", $CellContext`ss$$ = 5., $CellContext`xMag$$ = 
        1., $CellContext`z1$$ = 0.4, $CellContext`z2$$ = 
        0.4, $CellContext`\[Delta]$$ = 0.03, $CellContext`\[Sigma]$$ = 0.03}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`fwhmpos$, $CellContext`points$, $CellContext`\
\[Theta]\[Theta]$, $CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$, $CellContext`grid1$, $CellContext`middle1$, \
$CellContext`kernel1$, $CellContext`lc1$, $CellContext`leftbound2$, \
$CellContext`rightbound2$, $CellContext`stepw2$, $CellContext`grid2$, \
$CellContext`middle2$, $CellContext`kernel2$, $CellContext`lc2$, \
$CellContext`ftlc$, $CellContext`lp1$, $CellContext`lp2$, $CellContext`lp3$, \
$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$}, $CellContext`points$ = 
         4096; $CellContext`\[Theta]\[Theta]$ = \
$CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$]; \
$CellContext`leftbound1$ = $CellContext`\[Theta]\[Theta]$ - 
          6. $CellContext`fwhmabs; $CellContext`rightbound1$ = $CellContext`\
\[Theta]\[Theta]$ + 
          6. $CellContext`fwhmabs; $CellContext`stepw1$ = \
($CellContext`rightbound1$ - $CellContext`leftbound1$)/$CellContext`points$; \
$CellContext`grid1$ = 
         Range[$CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$]; $CellContext`middle1$ = 
         Ceiling[Length[$CellContext`grid1$]/
           2]; $CellContext`kernel1$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$, $CellContext`\[Theta]\[Theta]$, $CellContext`grid1$]; \
$CellContext`leftbound2$ = $CellContext`s[$CellContext`leftbound1$, \
$CellContext`lambda$$]; $CellContext`rightbound2$ = \
$CellContext`s[$CellContext`rightbound1$, $CellContext`lambda$$]; \
$CellContext`stepw2$ = ($CellContext`rightbound2$ - \
$CellContext`leftbound2$)/$CellContext`points$; $CellContext`grid2$ = 
         Range[$CellContext`leftbound2$, $CellContext`rightbound2$, \
$CellContext`stepw2$]; $CellContext`middle2$ = 
         Ceiling[Length[$CellContext`grid2$]/
           2]; $CellContext`kernel2$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$], \
$CellContext`\[Sigma]$$ $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`lambda$$], $CellContext`ss$$, $CellContext`grid2$]; 
        Which[$CellContext`source$$ == 
          "Width of source", {$CellContext`lc1$ = $CellContext`boxTable[
             $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c1$$, $CellContext`rs$$], $CellContext`\[Theta]\[Theta]$, \
$CellContext`grid1$]}, $CellContext`source$$ == 
          "Receiving slit width", {$CellContext`lc1$ = $CellContext`boxTable[
             $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c2$$, $CellContext`rs$$], $CellContext`\[Theta]\[Theta]$, \
$CellContext`grid1$]}, $CellContext`source$$ == 
          "Specimen tilt", {$CellContext`lc1$ = $CellContext`boxTable[
             $CellContext`SpecimenTilt[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c3$$, $CellContext`rs$$], $CellContext`\[Theta]\[Theta]$, \
$CellContext`grid1$]}, $CellContext`source$$ == 
          "Tube tails", {$CellContext`lc1$ = $CellContext`tubetailTable[
             $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c1$$, $CellContext`rs$$], 
             $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
-$CellContext`z1$$, $CellContext`rs$$], 
             $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`z2$$, $CellContext`rs$$], $CellContext`frac$$, $CellContext`\
\[Theta]\[Theta]$, $CellContext`grid1$]}]; $CellContext`lc2$ = \
$CellContext`lc1$ $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`lambda$$]; $CellContext`lc1$ = 
         Chop[
          ListConvolve[$CellContext`lc1$, $CellContext`kernel1$, \
$CellContext`middle1$] $CellContext`stepw1$]; $CellContext`lc2$ = 
         Chop[ListConvolve[$CellContext`lc2$, $CellContext`kernel2$, \
$CellContext`middle2$] $CellContext`stepw2$]; $CellContext`fwhmpos$ = \
$CellContext`fwhmcalc[
           
           Transpose[{$CellContext`grid1$ - $CellContext`\[Theta]\[Theta]$, \
$CellContext`lc1$}], 8]; $CellContext`fwhmabs = Abs[
            Part[$CellContext`fwhmpos$, 1]] + Abs[
            Part[$CellContext`fwhmpos$, 2]]; $CellContext`ftlc$ = 
         Interpolation[
           $CellContext`fourierData[
            
            Transpose[{$CellContext`grid2$ - $CellContext`ss$$, \
$CellContext`lc2$}], 1.], InterpolationOrder -> 1]; $CellContext`lp1$ = 
         ListLinePlot[$CellContext`lc1$, 
           DataRange -> {$CellContext`leftbound1$, $CellContext`rightbound1$},
            PlotRange -> {{($CellContext`leftbound1$ - $CellContext`\[Theta]\
\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\[Theta]$, \
($CellContext`rightbound1$ - \
$CellContext`\[Theta]\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\
\[Theta]$}, Full}, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
           PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {"2\[Theta] axis (\[Degree])", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], Epilog -> {
             Inset[
              Framed[
               Style[Text[
                  NumberForm[$CellContext`fwhmabs, 3]] 
                "fwhm/\[Degree]2\[Theta] ", 20]], 
              ImageScaled[{0.25, 0.85}]], 
             InfiniteLine[{0, 0}, {0, 1}]}, ImageSize -> 
           500]; $CellContext`lp2$ = 
         ListLinePlot[$CellContext`lc2$, 
           DataRange -> {$CellContext`leftbound2$, $CellContext`rightbound2$},
            
           PlotRange -> {{($CellContext`leftbound2$ - \
$CellContext`ss$$)/$CellContext`xMag$$ + $CellContext`ss$$, \
($CellContext`rightbound2$ - $CellContext`ss$$)/$CellContext`xMag$$ + \
$CellContext`ss$$}, Full}, GridLines -> Automatic, GridLinesStyle -> 
           Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {
            "\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis (\!\(\*SuperscriptBox[\
\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp3$ = 
         Plot[{
            $CellContext`ftlc$[$CellContext`x]}, {$CellContext`x, \
((-32.)/($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$, (
             32./($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$}, PlotRange -> Full, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, FrameLabel -> {"s (nm)", "Fourier transform"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Fourier transform of diffraction peak"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp4$ = 
         Plot[
           Which[$CellContext`source$$ == "Width of source", {
             $CellContext`Size[$CellContext`x, $CellContext`c1$$, \
$CellContext`rs$$]}, $CellContext`source$$ == "Receiving slit width", {
             $CellContext`Size[$CellContext`x, $CellContext`c2$$, \
$CellContext`rs$$]}, $CellContext`source$$ == "Specimen tilt", {
             $CellContext`SpecimenTilt[$CellContext`x, $CellContext`c3$$, \
$CellContext`rs$$]}, $CellContext`source$$ == "Tube tails", {
             $CellContext`Size[$CellContext`x, $CellContext`c1$$, \
$CellContext`rs$$], 
             $CellContext`Size[$CellContext`x, -$CellContext`z1$$, \
$CellContext`rs$$], 
             $CellContext`Size[$CellContext`x, $CellContext`z2$$, \
$CellContext`rs$$]}], {$CellContext`x, 0., 180.}, PlotRange -> All, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, FrameLabel -> {"2\[Theta] axis (\[Degree])", 
             StringJoin[$CellContext`source$$, " (\[Degree]2\[Theta])"]}, 
           FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], Filling -> None, PlotLegends -> 
           Placed[
             LineLegend[{$CellContext`source$$}], {0.6, Top}], TicksStyle -> 
           Directive[Black, 15], AxesStyle -> Directive[Black, Thick], 
           ImageSize -> 500]; $CellContext`\[Theta]\[Theta]pos$ = Graphics[{
            PointSize[Large], Red, 
            Point[{$CellContext`\[Theta]\[Theta]$, 
              Which[$CellContext`source$$ == "Width of source", 
               $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c1$$, $CellContext`rs$$], $CellContext`source$$ == 
               "Receiving slit width", 
               $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c2$$, $CellContext`rs$$], $CellContext`source$$ == 
               "Specimen tilt", 
               $CellContext`SpecimenTilt[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c3$$, $CellContext`rs$$], $CellContext`source$$ == "Tube tails", 
               $CellContext`Size[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c1$$, $CellContext`rs$$]]}]}]; If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`lp1$, \
$CellContext`lp2$, $CellContext`lp3$, $CellContext`lp4$, \
$CellContext`\[Theta]\[Theta]pos$}], $CellContext`export$$ = False}]; 
        If[$CellContext`help$$, {
           MessageDialog["Text"], $CellContext`help$$ = False}]; 
        Grid[{{$CellContext`lp1$, $CellContext`lp2$}, {$CellContext`lp3$, 
            Show[$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$]}}]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.03, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.03, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 2}, 
        Grid[{{
           Text[
            Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
           Dynamic[
            NumberForm[
             $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}], 
        Delimiter, 
        Text[
         Style[
         "Type of aberration in the equatorial plane", 16, 
          Bold]], {{$CellContext`source$$, "Receiving slit width", ""}, {
         "Width of source", "Specimen tilt", "Receiving slit width", 
          "Tube tails"}, ControlType -> RadioButton, Appearance -> 
         "Vertical"}, Delimiter, 
        Text[
         Style[
         "Parameters of diffractometer", 16, Bold]], {{$CellContext`rs$$, 
          217.5, ""}, 10., 300., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`c1$$, 1., ""}, 
         0.03, 2., ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 4}, {{$CellContext`c2$$, 0.2, ""}, 0.03, 2., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`c3$$, 0.03, ""}, 1.*^-6, 5., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         6}, {{$CellContext`z1$$, 0.4, ""}, 0.01, 3., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         7}, {{$CellContext`z2$$, 0.4, ""}, 0.01, 3., ControlType -> Slider, 
         Appearance -> "Labeled", ControlPlacement -> 
         8}, {{$CellContext`frac$$, 0.05, ""}, 0.01, 1., ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         9}, {{$CellContext`lambda$$, 0.154059, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         10}, {{$CellContext`ss$$, 5., ""}, 0.001, 
         Dynamic[2./$CellContext`lambda$$], ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 11}, 
        Grid[{{"secondary diffract. radius", 
           Manipulate`Place[3], "mm"}, {"source width              ", 
           Manipulate`Place[4], "mm"}, {"receiving slit width      ", 
           Manipulate`Place[5], "mm"}, {"specimen tilt             ", 
           Manipulate`Place[6], "mm"}, {
           Text[
            Style[
            "Eff. width of tube tails in\nthe equator. plane perpend. to\nthe \
X-ray beam:", Bold]]}, {"neg. z-dir.                ", 
           Manipulate`Place[7], "mm"}, {"pos. z-dir.                ", 
           Manipulate`Place[8], "mm"}, {"fract. height of the tube tails ", 
           Manipulate`Place[9]}, {}, {"wavelength ", 
           Manipulate`Place[10], "nm"}, {
          "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
           Manipulate`Place[11], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
          "peak center (d)", 
           Dynamic[
            NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
          "peak center (2\[Theta])", 
           Dynamic[
            NumberForm[
             $CellContext`\[Theta]2[$CellContext`ss$$, \
$CellContext`lambda$$], {3, 5}]], "\[Degree]"}}, 
         Alignment -> {{Left}, {Center}}], 
        Delimiter, {{$CellContext`xMag$$, 1., 
          "zoom factor in 2\[Theta]-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> 
         "Labeled"}, {{$CellContext`kMag$$, 1., 
          "zoom factor in Fourier-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button[
        "Export to desktop", $CellContext`export$$ = 
         True], {{$CellContext`help$$, False}, 0, ControlType -> None}, 
        Button["Help", $CellContext`help$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & P. Scardi", "", 
          "Effect on the peak profile of hat shape aberrations in the \
equatorial plane\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> True, TrackedSymbols -> True, SynchronousUpdating -> 
        False}, "DefaultOptions" :> {}],
     ImageSizeCache->{1724., {541., 547.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8197300902556353`*^9, 3.819730127881957*^9, 3.8197303004017687`*^9, {
   3.819790141471384*^9, 3.819790146065446*^9}, {3.819790211895508*^9, 
   3.8197902187398233`*^9}, 3.8197907149586697`*^9, {3.819790798305459*^9, 
   3.8197908024774494`*^9}, {3.819792690534674*^9, 3.819792696722711*^9}, {
   3.819792742020584*^9, 3.8197927693496485`*^9}, 3.81979279953512*^9, 
   3.819793594185934*^9, {3.819793747627595*^9, 3.8197937537840157`*^9}, {
   3.8197939405863047`*^9, 3.8197939597117167`*^9}, 3.819794033495157*^9, {
   3.8197940972781105`*^9, 3.819794115294241*^9}, {3.819794320346734*^9, 
   3.8197943246907067`*^9}, {3.8199493921381497`*^9, 
   3.8199494045439663`*^9}, {3.819950305908806*^9, 3.8199503159709888`*^9}, {
   3.819950346283352*^9, 3.819950352189387*^9}, {3.8199554484659863`*^9, 
   3.8199554726434574`*^9}, {3.8199556195054398`*^9, 3.819955627545648*^9}, 
   3.8199556673768806`*^9, {3.819955714765596*^9, 3.819955755196559*^9}, {
   3.819955785265073*^9, 3.8199557987626348`*^9}, {3.819956374630643*^9, 
   3.8199563775928593`*^9}, {3.8199564754843426`*^9, 3.8199564796813655`*^9}, 
   3.8199565353938255`*^9, {3.8199566241183863`*^9, 3.81995664371459*^9}, {
   3.819956805808609*^9, 3.819956814701168*^9}, {3.819958571020562*^9, 
   3.8199585789304123`*^9}, 3.8199586910429273`*^9, 3.819958808483882*^9, {
   3.8199588398884487`*^9, 3.81995896294154*^9}, 3.8199591259921618`*^9, {
   3.8199591986382413`*^9, 3.8199592068491077`*^9}, 3.819960655460984*^9, 
   3.8200516693278365`*^9, 3.8200523004569626`*^9, 3.8200528028944607`*^9, 
   3.82005286906826*^9, {3.82005308548112*^9, 3.8200530909972053`*^9}, {
   3.820053386037065*^9, 3.820053391802806*^9}, {3.8200539087088957`*^9, 
   3.820053924584486*^9}, 3.8200540283686314`*^9, 3.820054069151265*^9, {
   3.8200542585473003`*^9, 3.820054263156819*^9}, {3.8200543596439395`*^9, 
   3.8200543627378006`*^9}, {3.8200545678691893`*^9, 
   3.8200545987015777`*^9}, {3.820056358177434*^9, 3.820056362107226*^9}, {
   3.8200564418750143`*^9, 3.820056445236456*^9}, {3.8200566651936016`*^9, 
   3.82005666995944*^9}, {3.82005683541671*^9, 3.8200568426047497`*^9}, {
   3.8200569148411465`*^9, 3.8200569187159576`*^9}, {3.8200576480949025`*^9, 
   3.8200576525954447`*^9}, {3.8200577181748033`*^9, 3.82005772237831*^9}, 
   3.82005811817017*^9, {3.820058236688803*^9, 3.820058250735798*^9}, {
   3.820058291080635*^9, 3.8200583913957767`*^9}, 3.820058445522588*^9, {
   3.820058495226585*^9, 3.820058563400487*^9}, 3.8200585991980486`*^9, 
   3.8200604785017767`*^9, {3.820061561148429*^9, 3.820061588446191*^9}, {
   3.8200619451266384`*^9, 3.820061998987447*^9}, {3.82006206333267*^9, 
   3.8200620680517855`*^9}, {3.8200621078493695`*^9, 3.8200621251466446`*^9}, 
   3.820062156631979*^9, 3.820064134070442*^9, 3.820064204134853*^9, 
   3.8200642546515055`*^9, 3.820064353091584*^9, 3.8200646659895945`*^9, 
   3.8200646984745145`*^9, {3.8201189732667847`*^9, 3.820118996610676*^9}, {
   3.820119037236658*^9, 3.8201190694873476`*^9}, 3.820119100160022*^9, 
   3.820119147957828*^9, 3.8201200030549316`*^9, 3.8201206124903493`*^9, 
   3.8201215523238897`*^9, {3.8201216219816947`*^9, 3.8201216428727913`*^9}, {
   3.8201217701722775`*^9, 3.820121792282099*^9}, 3.820121827548588*^9, {
   3.8201225657055206`*^9, 3.820122593768653*^9}, 3.820122658067294*^9, 
   3.8201296077376413`*^9, 3.8201298657277527`*^9, 3.8201303131438885`*^9, 
   3.820130381832966*^9, 3.8201304602877893`*^9, 3.820131023987869*^9, {
   3.8201321770293074`*^9, 3.8201322036077414`*^9}, 3.8201350328269606`*^9, 
   3.8201352620975294`*^9, 3.820135766671281*^9, 3.8201511643179293`*^9, 
   3.820151438797389*^9, {3.8201516499769144`*^9, 3.820151686056347*^9}, 
   3.820162212080265*^9, 3.820162519151012*^9, 3.8201625514172087`*^9, 
   3.820162798454822*^9, 3.820163170292824*^9, 3.8201634239083357`*^9, 
   3.8201634737846327`*^9, 3.8201639359838667`*^9, 3.8201643161497164`*^9, {
   3.8201643517443495`*^9, 3.820164378573124*^9}, 3.8201644279180746`*^9, 
   3.820165228906767*^9, 3.8201653509254875`*^9, 3.8201654199119463`*^9, 
   3.820165878438421*^9, 3.820165936158908*^9, 3.820166039879902*^9, 
   3.820166134335352*^9, 3.82016714048479*^9, 3.8201677353428507`*^9, 
   3.820167942535631*^9, 3.820211940699131*^9, 3.8202120882669735`*^9, 
   3.8202130588394394`*^9, 3.8202307415481205`*^9, 3.8202308924719996`*^9, 
   3.820299842662816*^9, 3.820306716526132*^9, 3.8208378954245386`*^9, 
   3.8209090816230707`*^9, 3.821161197927843*^9, 3.8211843356223135`*^9, 
   3.821184671740713*^9, 3.821184748242815*^9, 3.8211851201591253`*^9, 
   3.8213669365830145`*^9, 3.8213691334395256`*^9, {3.821369309028961*^9, 
   3.821369342639464*^9}, 3.821369541113821*^9, 3.8213704108114443`*^9, 
   3.8213708759497776`*^9, 3.8213751847137637`*^9, 3.8213752191678443`*^9, 
   3.821420750654787*^9, 3.821420916814597*^9, 3.8214249028791895`*^9, 
   3.82142503864227*^9, 3.8214250890490465`*^9, 3.8214251322562504`*^9, {
   3.8214252698279824`*^9, 3.8214252823851075`*^9}, 3.821425390916561*^9, 
   3.8215083690516024`*^9, 3.8246473332046137`*^9, 3.8246474412112217`*^9, 
   3.8246518218660517`*^9, {3.8246520652777576`*^9, 3.8246520924353247`*^9}, 
   3.824652766748654*^9, 3.8246528243296604`*^9, 3.824652982930571*^9, 
   3.8246531098582315`*^9, 3.824653163985879*^9, 3.8248006308639145`*^9, 
   3.824801044326411*^9, 3.8248010755615773`*^9, 3.8248011467037253`*^9, 
   3.824801237143346*^9, 3.8248018566111107`*^9, {3.8248020838035994`*^9, 
   3.8248021038351903`*^9}, 3.824802254448057*^9, 3.8248024732658205`*^9, 
   3.824802658082266*^9, 3.824802896087741*^9, {3.8248030317938585`*^9, 
   3.8248030833418455`*^9}, 3.824803116952002*^9, {3.8248031996729097`*^9, 
   3.824803213079262*^9}, 3.8248044907330513`*^9, 3.8248050909024267`*^9, 
   3.824805155200879*^9, 3.8248052373902454`*^9, 3.8248053728618326`*^9, 
   3.8248115026969147`*^9, 3.8248131980353007`*^9, 3.8248748553306494`*^9, 
   3.824875663123322*^9, 3.8249565543852215`*^9, 3.824961397563593*^9, 
   3.8251523507846527`*^9, 3.8254889872946014`*^9, 3.8254891959066114`*^9, 
   3.82548969627215*^9, 3.8254900049789257`*^9, 3.82694399923377*^9, 
   3.826944149953944*^9, {3.8269442788696575`*^9, 3.8269443886238403`*^9}, {
   3.8269444225712104`*^9, 3.826944448704482*^9}, {3.826944496268737*^9, 
   3.826944507800375*^9}, 3.8269465207944*^9, 3.82694664548617*^9, 
   3.8269467662074876`*^9, 3.826946843649459*^9, 3.826946874150044*^9, 
   3.826946927714528*^9, 3.826946971090784*^9, 3.8269472855700645`*^9, 
   3.826947388416871*^9, 3.826947599454908*^9, 3.8269481598465815`*^9, 
   3.82694827194477*^9, 3.826948378526599*^9, 3.826948447044134*^9, 
   3.8269484802952538`*^9, 3.8269487866950893`*^9, {3.8269491984776754`*^9, 
   3.826949220989255*^9}, 3.826949331992366*^9, 3.826949373368919*^9, 
   3.826949417323253*^9, 3.826949576968405*^9, 3.8269496267979684`*^9, 
   3.8269498384660463`*^9, {3.826949880352092*^9, 3.8269499092748165`*^9}, 
   3.826949966401383*^9, 3.8269604732500267`*^9, 3.826960809228796*^9, 
   3.826961379659791*^9, 3.8269619481561317`*^9, 3.8269620251638184`*^9, 
   3.8269662431817575`*^9, 3.8278401183933735`*^9, 3.8281764545793133`*^9, 
   3.828176492368985*^9, 3.828181780784607*^9, 3.8281820526285353`*^9, 
   3.8281821274109435`*^9, 3.828182169941712*^9, {3.8281822943458176`*^9, 
   3.8281823180953484`*^9}, 3.828182399730934*^9, 3.8281833091737013`*^9, 
   3.828183512989884*^9, 3.8281835582380853`*^9, 3.828183593381596*^9, 
   3.8281836764973283`*^9, 3.8281846031908784`*^9, 3.828184672138694*^9, {
   3.828184707490068*^9, 3.8281847237721868`*^9}, 3.828184794995284*^9, 
   3.828184832438991*^9, 3.8281848790642424`*^9, 3.8281875227507625`*^9, 
   3.828187602600763*^9, 3.8281877102771196`*^9, 3.8281877422588787`*^9, 
   3.828614170306695*^9, 3.828614365792268*^9, 3.8286874200748916`*^9, 
   3.830597251245935*^9, 3.831605929252824*^9, 3.831623028062695*^9, 
   3.8321458797601385`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"48685a51-899c-4423-8a06-90a71392bc8e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Effect on the peak profile of simple aberrations in \
the axial plane (circles function)", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
   3.794473090557276*^9, 3.794473100964528*^9}, {3.8201203831885056`*^9, 
   3.820120405845306*^9}, {3.820134318920413*^9, 3.820134402585107*^9}, 
   3.8201350165140266`*^9},
 CellTags->"Title",ExpressionUUID->"d3f6e012-fc4b-40aa-8ac5-7c3246fbdcb8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fwhmabs", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "fwhmpos", ",", " ", "\[IndentingNewLine]", "               ", 
         "points", ",", "\[IndentingNewLine]", "               ", 
         "\[Theta]\[Theta]", ",", "\[IndentingNewLine]", "              ", 
         "leftbound1", ",", "rightbound1", ",", "  ", "stepw1", ",", "grid1", 
         ",", "middle1", ",", " ", "kernel1", ",", " ", "lc1", ",", 
         "\[IndentingNewLine]", "              ", "leftbound2", ",", 
         "rightbound2", ",", "  ", "stepw2", ",", "grid2", ",", "middle2", 
         ",", " ", "kernel2", ",", " ", "lc2", ",", "\[IndentingNewLine]", 
         "              ", "ftlc", ",", " ", "lp1", ",", "lp2", ",", " ", 
         "lp3", ",", "lp4", ",", "\[Theta]\[Theta]pos"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "     ", 
       RowBox[{
        RowBox[{"points", "         ", "=", " ", "4096"}], ";", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"\[Theta]\[Theta]", "                 ", "=", " ", 
         RowBox[{"\[Theta]2", "[", 
          RowBox[{"ss", ",", "lambda"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"2", "\[Theta]"}], "-", "space"}], " ", "*)"}], 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"leftbound1", "   ", "=", " ", 
         RowBox[{"\[Theta]\[Theta]", " ", "-", " ", 
          RowBox[{"6.", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]", 
        "   ", 
        RowBox[{"rightbound1", "=", " ", 
         RowBox[{"\[Theta]\[Theta]", " ", "+", " ", 
          RowBox[{"6.", " ", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]",
         "   ", 
        RowBox[{"stepw1", "           ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound1", "-", "leftbound1"}], ")"}], "/", 
          "points"}]}], ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"grid1", "             ", "=", " ", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound1", ",", "rightbound1", ",", "stepw1"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"middle1", "        ", "=", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "grid1", "]"}], "/", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "  ", 
        RowBox[{"kernel1", "         ", "=", 
         RowBox[{"VoigtApproxTable", "[", 
          RowBox[{
          "\[Delta]", ",", "\[Sigma]", ",", "\[Theta]\[Theta]", ",", 
           "grid1"}], "]"}]}], ";", "\[IndentingNewLine]", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"=", 
             RowBox[{"1", "/", "d"}]}], ")"}]}], " ", "-", "space"}], " ", 
         "*)"}], "\[IndentingNewLine]", "   ", 
        RowBox[{"leftbound2", "   ", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"leftbound1", ",", "lambda"}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"rightbound2", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"rightbound1", ",", "lambda"}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"stepw2", "            ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound2", "-", "leftbound2"}], ")"}], "/", 
          "points"}]}], ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"grid2", "              ", "=", " ", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound2", ",", "rightbound2", ",", "stepw2"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"middle2", "        ", "=", "  ", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "grid2", "]"}], "/", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"kernel2", "        ", "=", "  ", 
         RowBox[{"VoigtApproxTable", "[", 
          RowBox[{
           RowBox[{"\[Delta]", " ", 
            RowBox[{"cs", "[", 
             RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
           RowBox[{"\[Sigma]", " ", 
            RowBox[{"cs", "[", 
             RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", "ss", 
           ",", "grid2"}], "]"}]}], ";", "\[IndentingNewLine]", "     ", 
        "\[IndentingNewLine]", "    ", 
        RowBox[{"lc1", "=", 
         RowBox[{"circlesTable", "[", 
          RowBox[{
           RowBox[{"AxialDivergence", "[", 
            RowBox[{"\[Theta]\[Theta]", ",", "c", ",", "rs"}], "]"}], ",", 
           "\[Theta]\[Theta]", ",", "grid1"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "    ", 
        RowBox[{"lc2", "=", 
         RowBox[{"lc1", " ", 
          RowBox[{"cs", "[", 
           RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}]}], ";", " ", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lc1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"ListConvolve", "[", 
            RowBox[{"lc1", ",", "kernel1", ",", "middle1"}], "]"}], " ", 
           "stepw1"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", "    ", 
        RowBox[{"lc2", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"ListConvolve", "[", 
            RowBox[{"lc2", ",", "kernel2", ",", "middle2"}], "]"}], " ", 
           "stepw2"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"fwhmpos", "=", 
         RowBox[{"fwhmcalc", "[", 
          RowBox[{
           RowBox[{"Transpose", " ", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"grid1", "-", "\[Theta]\[Theta]"}], ",", "lc1"}], "}"}],
             "]"}], ",", "8"}], "]"}]}], ";", "\[IndentingNewLine]", "     ", 
        RowBox[{"fwhmabs", "=", " ", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"fwhmpos", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
          RowBox[{"Abs", "[", 
           RowBox[{"fwhmpos", "[", 
            RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}]}], ";", 
        "\[IndentingNewLine]", "     ", "\[IndentingNewLine]", "     ", 
        RowBox[{"ftlc", "  ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"grid2", "-", "ss"}], ",", "lc2"}], "}"}], "]"}], ",",
              "1.0"}], "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp1", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{"lc1", ",", "      ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound1", ",", " ", "rightbound1"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"leftbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                  "/", "xMag"}], "+", "\[Theta]\[Theta]"}], ",", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"rightbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                  "/", "xMag"}], "+", "\[Theta]\[Theta]"}]}], "}"}], ",", 
              "Full"}], "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Epilog", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Inset", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"fwhmabs", ",", "3"}], "]"}], "]"}], 
                    "\"\<fwhm/\[Degree]2\[Theta] \>\""}], ",", "20"}], "]"}], 
                 " ", "]"}], ",", 
                RowBox[{"ImageScaled", "[", 
                 RowBox[{"{", 
                  RowBox[{"0.25", ",", "0.85"}], "}"}], "]"}]}], "]"}], ",", 
              RowBox[{"InfiniteLine", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ",", " ",
            "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp2", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{"lc2", ",", "      ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound2", ",", " ", "rightbound2"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"leftbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                 "+", "ss"}], ",", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"rightbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                 "+", "ss"}]}], "}"}], ",", "Full"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "      ", 
        RowBox[{"lp3", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ftlc", "[", "x", "]"}], "}"}], ",", 
           "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "32."}], "/", 
                RowBox[{"(", 
                 RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
              "/", "kMag"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"32.", "/", 
                RowBox[{"(", 
                 RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
              "/", "kMag"}]}], "}"}], ",", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Fourier transform of diffraction peak\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp4", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"AxialDivergence", "[", 
             RowBox[{"x", ",", "c", ",", "rs"}], "]"}], "}"}], ",", 
           "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", "1.", ",", "179.0"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<fhwm of aberration (2\[Degree]\[Theta])\>\""}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", "\"\<fwhm caused by aberration\>\"", "}"}], "]"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "   ", 
        RowBox[{"\[Theta]\[Theta]pos", "=", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"\[Theta]\[Theta]", ",", 
               RowBox[{"AxialDivergence", "[", 
                RowBox[{"\[Theta]\[Theta]", ",", "c", ",", "rs"}], "]"}]}], 
              "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "    ", "\[IndentingNewLine]", "    ", 
        RowBox[{"If", "[", 
         RowBox[{"export", ",", 
          RowBox[{"{", "\[IndentingNewLine]", "                       ", 
           RowBox[{
            RowBox[{"Export", "[", 
             RowBox[{"filePath", ",", 
              RowBox[{"{", 
               RowBox[{
               "lp1", ",", "lp2", ",", "lp3", ",", "lp4", ",", 
                "\[Theta]\[Theta]pos"}], "}"}]}], "]"}], ",", " ", 
            "\[IndentingNewLine]", "                       ", 
            RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
           "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
         "]"}], ";", " ", "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
        RowBox[{"Grid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lp1", ",", "lp2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"lp3", ",", 
             RowBox[{"Show", "[", 
              RowBox[{"lp4", ",", "\[Theta]\[Theta]pos"}], "]"}]}], "}"}]}], 
          "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "              ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Voigt function\>\"", ",", "16", ",", "Bold"}], "]"}],
            "]"}], "}"}], ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<\[Delta] \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Delta]", ",", "0.01", ",", "\"\<\>\""}], "}"}], ",",
               "0.001", ",", "1.", ",", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Slider", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Delta]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                    RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                  "\"\< \>\"", ",", 
                  RowBox[{"InputField", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                 "}"}], "]"}], "&"}]}], "}"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
         "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<\[Sigma] \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Sigma]", ",", "0.01", ",", "\"\<\>\""}], "}"}], ",",
               "0.001", ",", "1.", ",", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Slider", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                    RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                  "\"\< \>\"", ",", 
                  RowBox[{"InputField", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                 "}"}], "]"}], "&"}]}], "}"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
         "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Voigt   fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Voigtfwhm", "[", 
               RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<mixing  \[Delta]/\[Sigma] \>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Mix", "[", 
               RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}], "}"}]}], 
        "\[IndentingNewLine]", "        ", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Left", "}"}], ",", 
          RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Parameters of diffractometer\>\"", ",", "16", ",", "Bold"}], 
       "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "                ", 
        RowBox[{
         RowBox[{"{", "   ", 
          RowBox[{"\"\<secondary diffract. radius  \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"rs", ",", "217.5", ",", "\"\<\>\""}], "}"}], ",", 
              "10.0", ",", " ", "300.0", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            ",", "\"\<mm\>\""}], " ", "}"}], ",", "\[IndentingNewLine]", 
         "                ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<RS length in the axial plane\>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"c", ",", "    ", "12.0", ",", "\"\<\>\""}], "}"}], 
              ",", "  ", "0.1", ",", "   ", "20.0", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            ",", "\"\<mm\>\""}], " ", "}"}], ",", "\[IndentingNewLine]", 
         "               ", 
         RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<wavelength \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "      ", 
               RowBox[{
               "lambda", ",", "       ", "0.154059", ",", "\"\<\>\""}], "}"}],
               ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "   ", 
          RowBox[{
          "\"\<peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))\>\"", ",", 
           "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", " ", 
               RowBox[{"ss", ",", "5.", ",", "\"\<\>\""}], "}"}], ",", "0.4", 
              ",", 
              RowBox[{"2.", "/", "lambda"}], ",", "Slider", ",", " ", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", "               ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<peak center (d)\>\"", ",", "     ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"1", "/", "ss"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}],
           "}"}], ",", "\[IndentingNewLine]", "               ", 
         RowBox[{"{", " ", 
          RowBox[{"\"\<peak center (2\[Theta])\>\"", ",", "  ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", " ", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{"ss", ",", "lambda"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]\>\""}], "}"}]}], 
        "                                 ", "\[IndentingNewLine]", 
        "        ", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Left", "}"}], ",", 
          RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "       ", 
         RowBox[{
         "xMag", ",", "1.", ",", "\"\<zoom factor in 2\[Theta]-space\>\""}], 
         "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
        ",", 
        RowBox[{"Exclusions", "\[Rule]", 
         RowBox[{"{", "0", "}"}]}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "       ", 
         RowBox[{
         "kMag", ",", "1.", ",", "\"\<zoom factor in Fourier-space\>\""}], 
         "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
        ",", 
        RowBox[{"Exclusions", "\[Rule]", 
         RowBox[{"{", "0", "}"}]}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]",
      "\[IndentingNewLine]", "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Export to desktop\>\"", ",", 
       RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<by R. E. Dinnebier & P. Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
        "\"\<Effect on the peak profile of circles aberrations in the axial \
plane\\n\>\""}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", " ", 
     RowBox[{"ControlPlacement", "\[Rule]", 
      RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"must", " ", "be", " ", 
       RowBox[{"true", " ", "!"}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ","}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"TrackedSymbols", "\[Rule]", "True"}], " ", ",", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], 
    "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8248124481002054`*^9, 3.8248124758047705`*^9}, {
   3.8248125103072166`*^9, 3.8248125392462053`*^9}, 3.824812569544921*^9, {
   3.8248126491751738`*^9, 3.8248127080845594`*^9}, {3.824812759228319*^9, 
   3.824812836795431*^9}, {3.8248128678126497`*^9, 3.8248128787353964`*^9}, {
   3.824813034681962*^9, 3.824813035588359*^9}, {3.8248131052174673`*^9, 
   3.8248131159055266`*^9}, {3.824813346934935*^9, 3.8248133772018843`*^9}, {
   3.82496125257611*^9, 3.8249612653420806`*^9}, {3.825490399030468*^9, 
   3.8254904074208984`*^9}, {3.825497297015222*^9, 3.8254972971250134`*^9}, {
   3.8269455536789603`*^9, 3.826945576292947*^9}, {3.8269469423714294`*^9, 
   3.8269469424806147`*^9}, {3.826948197507374*^9, 3.826948258913412*^9}, {
   3.826948291523862*^9, 3.826948294883185*^9}, {3.8269485379844666`*^9, 
   3.826948557300461*^9}, {3.826949461652526*^9, 3.826949470715309*^9}, 
   3.826949566358841*^9, {3.826965956675715*^9, 3.826965958550997*^9}, {
   3.8281850070193324`*^9, 3.828185033556831*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"4b48566f-80da-4495-ab8d-d5f256420450"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c$$ = 12., $CellContext`export$$ = 
    False, $CellContext`kMag$$ = 1., $CellContext`lambda$$ = 
    0.154059, $CellContext`rs$$ = 217.5, $CellContext`ss$$ = 
    1.6833680135532492`, $CellContext`xMag$$ = 1., $CellContext`\[Delta]$$ = 
    0.01, $CellContext`\[Sigma]$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.01, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`\[Sigma]$$], 0.01, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{
          Text[
           Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
          Dynamic[
           NumberForm[
            $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Parameters of diffractometer", 16, Bold]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`rs$$], 217.5, ""}, 10., 300.}, {{
       Hold[$CellContext`c$$], 12., ""}, 0.1, 20.}, {{
       Hold[$CellContext`lambda$$], 0.154059, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`ss$$], 5., ""}, 0.4, 
      Dynamic[2./$CellContext`lambda$$]}, {
      Hold[
       Grid[{{"secondary diffract. radius  ", 
          Manipulate`Place[3], "mm"}, {"RS length in the axial plane", 
          Manipulate`Place[4], "mm"}, {}, {"wavelength ", 
          Manipulate`Place[5], "nm"}, {
         "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
          Manipulate`Place[6], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
         "peak center (d)", 
          Dynamic[
           NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
         "peak center (2\[Theta])", 
          Dynamic[
           NumberForm[
            $CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$], \
{3, 5}]], "\[Degree]"}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1., "zoom factor in 2\[Theta]-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1., "zoom factor in Fourier-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1009., {342., 348.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`c$$ = 12., $CellContext`export$$ = 
        False, $CellContext`kMag$$ = 1., $CellContext`lambda$$ = 
        0.154059, $CellContext`rs$$ = 217.5, $CellContext`ss$$ = 
        5., $CellContext`xMag$$ = 1., $CellContext`\[Delta]$$ = 
        0.01, $CellContext`\[Sigma]$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`fwhmpos$, $CellContext`points$, $CellContext`\
\[Theta]\[Theta]$, $CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$, $CellContext`grid1$, $CellContext`middle1$, \
$CellContext`kernel1$, $CellContext`lc1$, $CellContext`leftbound2$, \
$CellContext`rightbound2$, $CellContext`stepw2$, $CellContext`grid2$, \
$CellContext`middle2$, $CellContext`kernel2$, $CellContext`lc2$, \
$CellContext`ftlc$, $CellContext`lp1$, $CellContext`lp2$, $CellContext`lp3$, \
$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$}, $CellContext`points$ = 
         4096; $CellContext`\[Theta]\[Theta]$ = \
$CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$]; \
$CellContext`leftbound1$ = $CellContext`\[Theta]\[Theta]$ - 
          6. $CellContext`fwhmabs; $CellContext`rightbound1$ = $CellContext`\
\[Theta]\[Theta]$ + 
          6. $CellContext`fwhmabs; $CellContext`stepw1$ = \
($CellContext`rightbound1$ - $CellContext`leftbound1$)/$CellContext`points$; \
$CellContext`grid1$ = 
         Range[$CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$]; $CellContext`middle1$ = 
         Ceiling[Length[$CellContext`grid1$]/
           2]; $CellContext`kernel1$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$, $CellContext`\[Theta]\[Theta]$, $CellContext`grid1$]; \
$CellContext`leftbound2$ = $CellContext`s[$CellContext`leftbound1$, \
$CellContext`lambda$$]; $CellContext`rightbound2$ = \
$CellContext`s[$CellContext`rightbound1$, $CellContext`lambda$$]; \
$CellContext`stepw2$ = ($CellContext`rightbound2$ - \
$CellContext`leftbound2$)/$CellContext`points$; $CellContext`grid2$ = 
         Range[$CellContext`leftbound2$, $CellContext`rightbound2$, \
$CellContext`stepw2$]; $CellContext`middle2$ = 
         Ceiling[Length[$CellContext`grid2$]/
           2]; $CellContext`kernel2$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$], \
$CellContext`\[Sigma]$$ $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`lambda$$], $CellContext`ss$$, $CellContext`grid2$]; \
$CellContext`lc1$ = $CellContext`circlesTable[
           $CellContext`AxialDivergence[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c$$, $CellContext`rs$$], $CellContext`\[Theta]\[Theta]$, \
$CellContext`grid1$]; $CellContext`lc2$ = $CellContext`lc1$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$]; \
$CellContext`lc1$ = 
         Chop[ListConvolve[$CellContext`lc1$, $CellContext`kernel1$, \
$CellContext`middle1$] $CellContext`stepw1$]; $CellContext`lc2$ = 
         Chop[ListConvolve[$CellContext`lc2$, $CellContext`kernel2$, \
$CellContext`middle2$] $CellContext`stepw2$]; $CellContext`fwhmpos$ = \
$CellContext`fwhmcalc[
           
           Transpose[{$CellContext`grid1$ - $CellContext`\[Theta]\[Theta]$, \
$CellContext`lc1$}], 8]; $CellContext`fwhmabs = Abs[
            Part[$CellContext`fwhmpos$, 1]] + Abs[
            Part[$CellContext`fwhmpos$, 2]]; $CellContext`ftlc$ = 
         Interpolation[
           $CellContext`fourierData[
            
            Transpose[{$CellContext`grid2$ - $CellContext`ss$$, \
$CellContext`lc2$}], 1.], InterpolationOrder -> 1]; $CellContext`lp1$ = 
         ListLinePlot[$CellContext`lc1$, 
           DataRange -> {$CellContext`leftbound1$, $CellContext`rightbound1$},
            PlotRange -> {{($CellContext`leftbound1$ - $CellContext`\[Theta]\
\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\[Theta]$, \
($CellContext`rightbound1$ - \
$CellContext`\[Theta]\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\
\[Theta]$}, Full}, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
           PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {"2\[Theta] axis (\[Degree])", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], Epilog -> {
             Inset[
              Framed[
               Style[Text[
                  NumberForm[$CellContext`fwhmabs, 3]] 
                "fwhm/\[Degree]2\[Theta] ", 20]], 
              ImageScaled[{0.25, 0.85}]], 
             InfiniteLine[{0, 0}, {0, 1}]}, ImageSize -> 
           500]; $CellContext`lp2$ = 
         ListLinePlot[$CellContext`lc2$, 
           DataRange -> {$CellContext`leftbound2$, $CellContext`rightbound2$},
            PlotRange -> {{($CellContext`leftbound2$ - \
$CellContext`ss$$)/$CellContext`xMag$$ + $CellContext`ss$$, \
($CellContext`rightbound2$ - $CellContext`ss$$)/$CellContext`xMag$$ + \
$CellContext`ss$$}, Full}, GridLines -> Automatic, GridLinesStyle -> 
           Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {
            "\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis (\!\(\*SuperscriptBox[\
\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp3$ = 
         Plot[{
            $CellContext`ftlc$[$CellContext`x]}, {$CellContext`x, \
((-32.)/($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$, (
             32./($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$}, PlotRange -> Full, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, FrameLabel -> {"s (nm)", "Fourier transform"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Fourier transform of diffraction peak"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp4$ = 
         Plot[{
            $CellContext`AxialDivergence[$CellContext`x, $CellContext`c$$, \
$CellContext`rs$$]}, {$CellContext`x, 1., 179.}, PlotRange -> All, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, 
           FrameLabel -> {
            "2\[Theta] axis (\[Degree])", 
             "fhwm of aberration (2\[Degree]\[Theta])"}, 
           FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], Filling -> None, PlotLegends -> 
           Placed[
             LineLegend[{"fwhm caused by aberration"}], {0.4, Top}], 
           TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 
           500]; $CellContext`\[Theta]\[Theta]pos$ = Graphics[{
            PointSize[Large], Red, 
            Point[{$CellContext`\[Theta]\[Theta]$, 
              $CellContext`AxialDivergence[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c$$, $CellContext`rs$$]}]}]; If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`lp1$, \
$CellContext`lp2$, $CellContext`lp3$, $CellContext`lp4$, \
$CellContext`\[Theta]\[Theta]pos$}], $CellContext`export$$ = False}]; 
        Grid[{{$CellContext`lp1$, $CellContext`lp2$}, {$CellContext`lp3$, 
            Show[$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$]}}]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.01, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.01, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 2}, 
        Grid[{{
           Text[
            Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
           Dynamic[
            NumberForm[
             $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}], 
        Delimiter, 
        Text[
         Style[
         "Parameters of diffractometer", 16, Bold]], {{$CellContext`rs$$, 
          217.5, ""}, 10., 300., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`c$$, 12., ""}, 0.1,
          20., ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 4}, {{$CellContext`lambda$$, 0.154059, ""}, 0.01,
          0.3, ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 5}, {{$CellContext`ss$$, 5., ""}, 0.4, 
         Dynamic[2./$CellContext`lambda$$], ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 6}, 
        Grid[{{"secondary diffract. radius  ", 
           Manipulate`Place[3], "mm"}, {"RS length in the axial plane", 
           Manipulate`Place[4], "mm"}, {}, {"wavelength ", 
           Manipulate`Place[5], "nm"}, {
          "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
           Manipulate`Place[6], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
          "peak center (d)", 
           Dynamic[
            NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
          "peak center (2\[Theta])", 
           Dynamic[
            NumberForm[
             $CellContext`\[Theta]2[$CellContext`ss$$, \
$CellContext`lambda$$], {3, 5}]], "\[Degree]"}}, 
         Alignment -> {{Left}, {Center}}], 
        Delimiter, {{$CellContext`xMag$$, 1., 
          "zoom factor in 2\[Theta]-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> 
         "Labeled"}, {{$CellContext`kMag$$, 1., 
          "zoom factor in Fourier-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & P. Scardi", "", 
          "Effect on the peak profile of circles aberrations in the axial \
plane\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> True, TrackedSymbols -> True, SynchronousUpdating -> 
        False}, "DefaultOptions" :> {}],
     ImageSizeCache->{1724., {411., 417.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.824812912299912*^9, 3.8248130370884748`*^9, 3.8248131982700386`*^9, 
   3.8248133803739257`*^9, 3.824874855794171*^9, 3.824875663409175*^9, 
   3.824956554666679*^9, 3.8249613977983046`*^9, 3.8251523510344143`*^9, 
   3.825488987591482*^9, 3.825489196141406*^9, 3.825489696522134*^9, 
   3.825490408546011*^9, 3.825497298734034*^9, 3.826946521700734*^9, 
   3.8269467664590197`*^9, 3.826946971340854*^9, 3.8269475999083643`*^9, {
   3.82694827740518*^9, 3.826948296586389*^9}, 3.8269485676413865`*^9, 
   3.826948786960461*^9, 3.8269499666827126`*^9, 3.8269659597695456`*^9, 
   3.826966243493957*^9, 3.827840118711198*^9, 3.828176455114663*^9, {
   3.828185015808688*^9, 3.8281850345603104`*^9}, 3.8281875230516825`*^9, 
   3.828614170572321*^9, 3.8286143659958267`*^9, 3.8286874203563576`*^9, 
   3.830597251605229*^9, 3.8316059297684765`*^9, 3.8316230283749275`*^9, 
   3.8321458801507273`*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"752bd527-d580-4b86-bd5d-07ded759a543"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Effect on the peak profile of simple aberrations in \
the equatorial plane (1/X function)", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
   3.794473090557276*^9, 3.794473100964528*^9}, {3.8201203831885056`*^9, 
   3.820120405845306*^9}, {3.820134318920413*^9, 3.820134402585107*^9}, 
   3.8201350165140266`*^9, 3.8202120717507834`*^9},
 CellTags->"Title",ExpressionUUID->"fe6db5da-cd62-4577-8a5c-0b3d771198f3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fwhmabs", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Quiet", "@", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "fwhmpos", ",", " ", "\[IndentingNewLine]", "               ", 
         "points", ",", "\[IndentingNewLine]", "               ", 
         "\[Theta]\[Theta]", ",", "\[IndentingNewLine]", "              ", 
         "leftbound1", ",", "rightbound1", ",", "  ", "stepw1", ",", "grid1", 
         ",", "middle1", ",", " ", "kernel1", ",", " ", "lc1", ",", 
         "\[IndentingNewLine]", "              ", "leftbound2", ",", 
         "rightbound2", ",", "  ", "stepw2", ",", "grid2", ",", "middle2", 
         ",", " ", "kernel2", ",", " ", "lc2", ",", "\[IndentingNewLine]", 
         "              ", "ftlc", ",", " ", "lp1", ",", "lp2", ",", " ", 
         "lp3", ",", "lp4", ",", "\[Theta]\[Theta]pos"}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "     ", 
       RowBox[{
        RowBox[{"points", "         ", "=", " ", "4096"}], ";", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"\[Theta]\[Theta]", "                  ", "=", " ", 
         RowBox[{"\[Theta]2", "[", 
          RowBox[{"ss", ",", "lambda"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"2", "\[Theta]"}], "-", "space"}], " ", "*)"}], 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"leftbound1", "   ", "=", " ", 
         RowBox[{"\[Theta]\[Theta]", " ", "-", " ", 
          RowBox[{"6.", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]", 
        "   ", 
        RowBox[{"rightbound1", "=", " ", 
         RowBox[{"\[Theta]\[Theta]", " ", "+", " ", 
          RowBox[{"6.", " ", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]",
         "   ", 
        RowBox[{"stepw1", "           ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound1", "-", "leftbound1"}], ")"}], "/", 
          "points"}]}], ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"grid1", "             ", "=", " ", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound1", ",", "rightbound1", ",", "stepw1"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"middle1", "        ", "=", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "grid1", "]"}], "/", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "  ", 
        RowBox[{"kernel1", "         ", "=", 
         RowBox[{"VoigtApproxTable", "[", 
          RowBox[{
          "\[Delta]", ",", "\[Sigma]", ",", "\[Theta]\[Theta]", ",", 
           "grid1"}], "]"}]}], ";", "\[IndentingNewLine]", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{"s", " ", 
           RowBox[{"(", 
            RowBox[{"=", 
             RowBox[{"1", "/", "d"}]}], ")"}]}], " ", "-", "space"}], " ", 
         "*)"}], "\[IndentingNewLine]", "    ", 
        RowBox[{"leftbound2", "   ", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"leftbound1", ",", "lambda"}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"rightbound2", "=", " ", 
         RowBox[{"s", "[", 
          RowBox[{"rightbound1", ",", "lambda"}], "]"}]}], ";", " ", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"stepw2", "            ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"rightbound2", "-", "leftbound2"}], ")"}], "/", 
          "points"}]}], ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"grid2", "              ", "=", " ", 
         RowBox[{"Range", "[", 
          RowBox[{"leftbound2", ",", "rightbound2", ",", "stepw2"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "   ", 
        RowBox[{"middle2", "        ", "=", "  ", 
         RowBox[{"Ceiling", "[", 
          RowBox[{
           RowBox[{"Length", "[", "grid2", "]"}], "/", "2"}], "]"}]}], ";", 
        "\[IndentingNewLine]", "   ", 
        RowBox[{"kernel2", "        ", "=", "  ", 
         RowBox[{"VoigtApproxTable", "[", 
          RowBox[{
           RowBox[{"\[Delta]", " ", 
            RowBox[{"cs", "[", 
             RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
           RowBox[{"\[Sigma]", " ", 
            RowBox[{"cs", "[", 
             RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", "ss", 
           ",", "grid2"}], "]"}]}], ";", "\[IndentingNewLine]", "  ", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"Which", "[", 
         RowBox[{
          RowBox[{"typediffslit", "\[Equal]", "\"\<fixed\>\""}], ",", 
          "           ", 
          RowBox[{"{", 
           RowBox[{"lc1", "=", 
            RowBox[{"oneonxTable", "[", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{"FixedDivergence", "[", 
                 RowBox[{"\[Theta]\[Theta]", ",", "cfix"}], "]"}], ",", 
                RowBox[{"-", "0.001"}]}], "]"}], ",", "\[Theta]\[Theta]", ",",
               "grid1"}], "]"}]}], " ", "}"}], ",", " ", 
          "\[IndentingNewLine]", "                ", 
          RowBox[{"typediffslit", "\[Equal]", "\"\<variable\>\""}], ",", 
          "     ", 
          RowBox[{"{", 
           RowBox[{"lc1", "=", 
            RowBox[{"oneonxTable", "[", 
             RowBox[{
              RowBox[{"Min", "[", 
               RowBox[{
                RowBox[{"VariableDivergence", "[", 
                 RowBox[{"\[Theta]\[Theta]", ",", "cvar", ",", "rs"}], "]"}], 
                ",", 
                RowBox[{"-", "0.001"}]}], "]"}], ",", "\[Theta]\[Theta]", ",",
               "grid1"}], "]"}]}], " ", "}"}]}], "\[IndentingNewLine]", 
         "     ", "]"}], ";", "\[IndentingNewLine]", "   ", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"lc2", "=", 
         RowBox[{"lc1", " ", 
          RowBox[{"cs", "[", 
           RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}]}], ";", " ", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lc1", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"ListConvolve", "[", 
            RowBox[{"lc1", ",", "kernel1", ",", "middle1"}], "]"}], " ", 
           "stepw1"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", "    ", 
        RowBox[{"lc2", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"ListConvolve", "[", 
            RowBox[{"lc2", ",", "kernel2", ",", "middle2"}], "]"}], " ", 
           "stepw2"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", "     ", 
        RowBox[{"fwhmpos", "=", 
         RowBox[{"fwhmcalc", "[", 
          RowBox[{
           RowBox[{"Transpose", " ", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"grid1", "-", "\[Theta]\[Theta]"}], ",", "lc1"}], "}"}],
             "]"}], ",", "8"}], "]"}]}], ";", "\[IndentingNewLine]", "     ", 
        RowBox[{"fwhmabs", "=", " ", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"fwhmpos", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
          RowBox[{"Abs", "[", 
           RowBox[{"fwhmpos", "[", 
            RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}]}], ";", 
        "\[IndentingNewLine]", "     ", "\[IndentingNewLine]", "     ", 
        RowBox[{"ftlc", "  ", "=", "  ", 
         RowBox[{"Interpolation", "[", 
          RowBox[{
           RowBox[{"fourierData", "[", 
            RowBox[{
             RowBox[{"Transpose", " ", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"grid2", "-", "ss"}], ",", "lc2"}], "}"}], "]"}], ",",
              "1.0"}], "]"}], ",", 
           RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
        "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp1", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{"lc1", ",", "      ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound1", ",", " ", "rightbound1"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"leftbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                  "/", "xMag"}], "+", "\[Theta]\[Theta]"}], ",", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"rightbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                  "/", "xMag"}], "+", "\[Theta]\[Theta]"}]}], "}"}], ",", 
              "Full"}], "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Epilog", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Inset", "[", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{"Style", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"fwhmabs", ",", "3"}], "]"}], "]"}], 
                    "\"\<fwhm (\[Degree]2\[Theta]) \>\""}], ",", "20"}], 
                  "]"}], " ", "]"}], ",", 
                RowBox[{"ImageScaled", "[", 
                 RowBox[{"{", 
                  RowBox[{"0.25", ",", "0.85"}], "}"}], "]"}]}], "]"}], ",", 
              RowBox[{"InfiniteLine", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ",", " ",
            "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"lp2", "=", 
         RowBox[{"ListLinePlot", "[", 
          RowBox[{"lc2", ",", "      ", 
           RowBox[{"DataRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"leftbound2", ",", " ", "rightbound2"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"leftbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                 "+", "ss"}], ",", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", " ", 
                   RowBox[{"rightbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                 "+", "ss"}]}], "}"}], ",", "Full"}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
              "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "      ", 
        RowBox[{"lp3", "=", " ", 
         RowBox[{"Plot", "[", "  ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ftlc", "[", "x", "]"}], "}"}], ",", 
           "                      ", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "32."}], "/", 
                RowBox[{"(", 
                 RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
              "/", "kMag"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"32.", "/", 
                RowBox[{"(", 
                 RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
              "/", "kMag"}]}], "}"}], ",", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"None", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{
               "{", "\"\<Fourier transform of diffraction peak\>\"", "}"}], 
               "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"lp4", "=", " ", 
         RowBox[{"Plot", "[", "          ", 
          RowBox[{
           RowBox[{"Which", "[", 
            RowBox[{
             RowBox[{"typediffslit", "\[Equal]", "\"\<fixed\>\""}], ",", 
             "        ", 
             RowBox[{"FixedDivergence", "[", 
              RowBox[{"x", ",", "cfix"}], "]"}], ",", "\[IndentingNewLine]", 
             "                                          ", 
             RowBox[{"typediffslit", "\[Equal]", "\"\<variable\>\""}], ",", 
             " ", 
             RowBox[{"VariableDivergence", "[", 
              RowBox[{"x", ",", "cvar", ",", "rs"}], "]"}]}], "   ", "]"}], 
           ",", "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"{", 
            RowBox[{"x", ",", " ", "1.", ",", "179.0"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           "                                                        ", 
           RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"GridLinesStyle", "\[Rule]", 
            RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
              "\"\<fhwm of aberration (2\[Degree]\[Theta])\>\""}], "}"}]}], 
           ",", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"FrameTicks", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",",
            " ", "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]",
            "                                                         ", 
           RowBox[{"PlotLegends", "\[Rule]", 
            RowBox[{"Placed", "[", 
             RowBox[{
              RowBox[{"LineLegend", "[", 
               RowBox[{"{", "\"\<fwhm caused by aberration\>\"", "}"}], "]"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"0.4", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"TicksStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "15"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                          ", 
           RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
             RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
           "\[IndentingNewLine]", 
           "                                                         ", 
           RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
        RowBox[{"\[Theta]\[Theta]pos", "=", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"\[Theta]\[Theta]", ",", 
               RowBox[{"Which", "[", 
                RowBox[{
                 RowBox[{"typediffslit", "\[Equal]", "\"\<fixed\>\""}], ",", 
                 "       ", 
                 RowBox[{"FixedDivergence", "[", 
                  RowBox[{"\[Theta]\[Theta]", ",", "cfix"}], "]"}], ",", " ", 
                 "\[IndentingNewLine]", 
                 "                                                            \
                                                             ", 
                 RowBox[{"typediffslit", "\[Equal]", "\"\<variable\>\""}], 
                 ",", " ", 
                 RowBox[{"VariableDivergence", "[", 
                  RowBox[{"\[Theta]\[Theta]", ",", "cvar", ",", "rs"}], 
                  "]"}]}], "   ", "]"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
        ";", "\[IndentingNewLine]", "    ", "\[IndentingNewLine]", "    ", 
        RowBox[{"If", "[", 
         RowBox[{"export", ",", 
          RowBox[{"{", "\[IndentingNewLine]", "                       ", 
           RowBox[{
            RowBox[{"Export", "[", 
             RowBox[{"filePath", ",", 
              RowBox[{"{", 
               RowBox[{
               "lp1", ",", "lp2", ",", "lp3", ",", "lp4", ",", 
                "\[Theta]\[Theta]pos"}], "}"}]}], "]"}], ",", " ", 
            "\[IndentingNewLine]", "                       ", 
            RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
           "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
         "]"}], ";", " ", "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
        RowBox[{"Grid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lp1", ",", "lp2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"lp3", ",", 
             RowBox[{"Show", "[", 
              RowBox[{"lp4", ",", "\[Theta]\[Theta]pos"}], "]"}]}], "}"}]}], 
          "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "              ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Text", "[", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Voigt function\>\"", ",", "16", ",", "Bold"}], "]"}],
            "]"}], "}"}], ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<\[Delta] \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Delta]", ",", "0.01", ",", "\"\<\>\""}], "}"}], ",",
               "0.001", ",", "1.", ",", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Slider", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Delta]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                    RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                  "\"\< \>\"", ",", 
                  RowBox[{"InputField", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                 "}"}], "]"}], "&"}]}], "}"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
         "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<\[Sigma] \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\[Sigma]", ",", "0.01", ",", "\"\<\>\""}], "}"}], ",",
               "0.001", ",", "1.", ",", 
              RowBox[{
               RowBox[{"Row", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Slider", "[", 
                   RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                    RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                  "\"\< \>\"", ",", 
                  RowBox[{"InputField", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                 "}"}], "]"}], "&"}]}], "}"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
         "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<Voigt   fwhm\>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Voigtfwhm", "[", 
               RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<mixing  \[Delta]/\[Sigma] \>\"", ",", " ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"Mix", "[", 
               RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}], "}"}]}], 
        "\[IndentingNewLine]", "        ", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Left", "}"}], ",", 
          RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<Type of divergence slit\>\"", ",", "16", ",", "Bold"}], 
       "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"typediffslit", ",", "\"\<fixed\>\"", ",", "\"\<\>\""}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<fixed\>\"", ",", "\"\<variable\>\""}], "}"}], ",", 
        "RadioButton", ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "}"}]}], ",",
      "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<Parameters of diffractometer\>\"", ",", "16", ",", "Bold"}], 
       "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", "                ", 
        RowBox[{
         RowBox[{"{", "   ", 
          RowBox[{"\"\<secondary diffract. radius\>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"rs", ",", "217.5", ",", "\"\<\>\""}], "}"}], ",", 
              "10.0", ",", " ", "300.0", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            ",", "\"\<mm\>\""}], " ", "}"}], ",", "\[IndentingNewLine]", 
         "                 ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<fixed div slit opening    \>\"", ",", " ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"cfix", ",", "    ", "1.0", ",", "\"\<\>\""}], "}"}], 
              ",", "  ", "0.5", ",", "   ", "5.0", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            ",", "\"\<mm\>\""}], " ", "}"}], ",", "\[IndentingNewLine]", 
         "                ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<variable slit opening     \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"cvar", ",", "   ", "30.0", ",", "\"\<\>\""}], "}"}], 
              ",", "  ", "1.", ",", " ", "40.0", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<\[Degree]\>\""}], "}"}], ",", 
         "\[IndentingNewLine]", "               ", 
         RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "              ", 
         RowBox[{"{", "   ", 
          RowBox[{"\"\<wavelength \>\"", ",", "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", "      ", 
               RowBox[{
               "lambda", ",", "       ", "0.154059", ",", "\"\<\>\""}], "}"}],
               ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
         "              ", 
         RowBox[{"{", "   ", 
          RowBox[{
          "\"\<peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))\>\"", ",", 
           "  ", 
           RowBox[{"Control", "@", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", " ", 
               RowBox[{"ss", ",", "5.", ",", "\"\<\>\""}], "}"}], ",", 
              "0.001", ",", 
              RowBox[{"2.", "/", "lambda"}], ",", "Slider", ",", " ", 
              RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}],
            " ", ",", "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], 
          "}"}], ",", "\[IndentingNewLine]", "               ", 
         RowBox[{"{", "  ", 
          RowBox[{"\"\<peak center (d)\>\"", ",", "     ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", 
             RowBox[{
              RowBox[{"1", "/", "ss"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}],
           "}"}], ",", "\[IndentingNewLine]", "               ", 
         RowBox[{"{", " ", 
          RowBox[{"\"\<peak center (2\[Theta])\>\"", ",", "  ", 
           RowBox[{"Dynamic", "@", 
            RowBox[{"NumberForm", "[", " ", 
             RowBox[{
              RowBox[{"\[Theta]2", "[", 
               RowBox[{"ss", ",", "lambda"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
           "\"\<\[Degree]\>\""}], "}"}]}], "               ", 
        "\[IndentingNewLine]", "        ", "}"}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Left", "}"}], ",", 
          RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "       ", 
         RowBox[{
         "xMag", ",", "1.", ",", "\"\<zoom factor in 2\[Theta]-space\>\""}], 
         "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
        ",", 
        RowBox[{"Exclusions", "\[Rule]", 
         RowBox[{"{", "0", "}"}]}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Control", "@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "       ", 
         RowBox[{
         "kMag", ",", "1.", ",", "\"\<zoom factor in Fourier-space\>\""}], 
         "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
        ",", 
        RowBox[{"Exclusions", "\[Rule]", 
         RowBox[{"{", "0", "}"}]}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
     ",", " ", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]",
      "  ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Export to desktop\>\"", ",", 
       RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<by R. E. Dinnebier & P. Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
        "\"\<Effect on the peak profile of 1/X aberrations in the equatorial \
plane\\n\>\""}], "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", " ", 
     RowBox[{"ControlPlacement", "\[Rule]", 
      RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"(*", 
      RowBox[{"must", " ", "be", " ", 
       RowBox[{"true", " ", "!"}]}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ","}], " ", "*)"}], 
     "\[IndentingNewLine]", " ", 
     RowBox[{"TrackedSymbols", "\[Rule]", "True"}], " ", ",", " ", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], 
    "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8248124481002054`*^9, 3.8248124758047705`*^9}, {
   3.8248125103072166`*^9, 3.8248125392462053`*^9}, 3.824812569544921*^9, {
   3.8248126491751738`*^9, 3.8248127080845594`*^9}, {3.824812759228319*^9, 
   3.824812836795431*^9}, {3.8248128678126497`*^9, 3.8248128787353964`*^9}, {
   3.824813034681962*^9, 3.824813035588359*^9}, {3.8248131052174673`*^9, 
   3.8248131159055266`*^9}, {3.824813346934935*^9, 3.8248133772018843`*^9}, {
   3.8248751140324297`*^9, 3.824875155375804*^9}, {3.824875222234923*^9, 
   3.8248752956138105`*^9}, {3.8248753357211943`*^9, 3.824875338446196*^9}, {
   3.824875401363318*^9, 3.8248754262883635`*^9}, {3.8248755359474916`*^9, 
   3.8248755407169557`*^9}, {3.8248756422416196`*^9, 3.824875650363557*^9}, {
   3.824875730559176*^9, 3.8248757355913973`*^9}, {3.8249612771235647`*^9, 
   3.8249612866237855`*^9}, {3.825496896340798*^9, 3.82549690176291*^9}, 
   3.825497234137817*^9, {3.8269455939026866`*^9, 3.8269456180031443`*^9}, {
   3.8269469521682262`*^9, 3.8269469522308984`*^9}, {3.826948605970804*^9, 
   3.8269486144400625`*^9}, 3.826948652691221*^9, {3.826948700848819*^9, 
   3.8269487387405014`*^9}, 3.8269494799653873`*^9, 3.826949558138313*^9, {
   3.826966165851814*^9, 3.826966230353136*^9}, {3.828185269243015*^9, 
   3.828185310869134*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"3e19f028-ff79-4fb2-98b7-ca9d432451ec"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`cfix$$ = 1., $CellContext`cvar$$ = 
    30., $CellContext`export$$ = False, $CellContext`kMag$$ = 
    1., $CellContext`lambda$$ = 0.154059, $CellContext`rs$$ = 
    217.5, $CellContext`ss$$ = 
    1.3250660135532493`, $CellContext`typediffslit$$ = 
    "fixed", $CellContext`xMag$$ = 1., $CellContext`\[Delta]$$ = 
    0.01, $CellContext`\[Sigma]$$ = 0.01, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.01, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`\[Sigma]$$], 0.01, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{
          Text[
           Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
          Dynamic[
           NumberForm[
            $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Type of divergence slit", 16, Bold]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`typediffslit$$], "fixed", ""}, {
      "fixed", "variable"}}, {
      Hold[
       Text[
        Style["Parameters of diffractometer", 16, Bold]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`rs$$], 217.5, ""}, 10., 300.}, {{
       Hold[$CellContext`cfix$$], 1., ""}, 0.5, 5.}, {{
       Hold[$CellContext`cvar$$], 30., ""}, 1., 40.}, {{
       Hold[$CellContext`lambda$$], 0.154059, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`ss$$], 5., ""}, 0.001, 
      Dynamic[2./$CellContext`lambda$$]}, {
      Hold[
       Grid[{{"secondary diffract. radius", 
          Manipulate`Place[3], "mm"}, {"fixed div slit opening    ", 
          Manipulate`Place[4], "mm"}, {"variable slit opening     ", 
          Manipulate`Place[5], "\[Degree]"}, {}, {"wavelength ", 
          Manipulate`Place[6], "nm"}, {
         "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
          Manipulate`Place[7], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
         "peak center (d)", 
          Dynamic[
           NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
         "peak center (2\[Theta])", 
          Dynamic[
           NumberForm[
            $CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$], \
{3, 5}]], "\[Degree]"}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1., "zoom factor in 2\[Theta]-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1., "zoom factor in Fourier-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1009., {341.5, 347.5}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`cfix$$ = 1., $CellContext`cvar$$ = 
        30., $CellContext`export$$ = False, $CellContext`kMag$$ = 
        1., $CellContext`lambda$$ = 0.154059, $CellContext`rs$$ = 
        217.5, $CellContext`ss$$ = 5., $CellContext`typediffslit$$ = 
        "fixed", $CellContext`xMag$$ = 1., $CellContext`\[Delta]$$ = 
        0.01, $CellContext`\[Sigma]$$ = 0.01}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`fwhmpos$, $CellContext`points$, $CellContext`\
\[Theta]\[Theta]$, $CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$, $CellContext`grid1$, $CellContext`middle1$, \
$CellContext`kernel1$, $CellContext`lc1$, $CellContext`leftbound2$, \
$CellContext`rightbound2$, $CellContext`stepw2$, $CellContext`grid2$, \
$CellContext`middle2$, $CellContext`kernel2$, $CellContext`lc2$, \
$CellContext`ftlc$, $CellContext`lp1$, $CellContext`lp2$, $CellContext`lp3$, \
$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$}, $CellContext`points$ = 
         4096; $CellContext`\[Theta]\[Theta]$ = \
$CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$]; \
$CellContext`leftbound1$ = $CellContext`\[Theta]\[Theta]$ - 
          6. $CellContext`fwhmabs; $CellContext`rightbound1$ = $CellContext`\
\[Theta]\[Theta]$ + 
          6. $CellContext`fwhmabs; $CellContext`stepw1$ = \
($CellContext`rightbound1$ - $CellContext`leftbound1$)/$CellContext`points$; \
$CellContext`grid1$ = 
         Range[$CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$]; $CellContext`middle1$ = 
         Ceiling[Length[$CellContext`grid1$]/
           2]; $CellContext`kernel1$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$, $CellContext`\[Theta]\[Theta]$, $CellContext`grid1$]; \
$CellContext`leftbound2$ = $CellContext`s[$CellContext`leftbound1$, \
$CellContext`lambda$$]; $CellContext`rightbound2$ = \
$CellContext`s[$CellContext`rightbound1$, $CellContext`lambda$$]; \
$CellContext`stepw2$ = ($CellContext`rightbound2$ - \
$CellContext`leftbound2$)/$CellContext`points$; $CellContext`grid2$ = 
         Range[$CellContext`leftbound2$, $CellContext`rightbound2$, \
$CellContext`stepw2$]; $CellContext`middle2$ = 
         Ceiling[Length[$CellContext`grid2$]/
           2]; $CellContext`kernel2$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$], \
$CellContext`\[Sigma]$$ $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`lambda$$], $CellContext`ss$$, $CellContext`grid2$]; 
        Which[$CellContext`typediffslit$$ == 
          "fixed", {$CellContext`lc1$ = $CellContext`oneonxTable[
             Min[
              $CellContext`FixedDivergence[$CellContext`\[Theta]\[Theta]$, \
$CellContext`cfix$$], -0.001], $CellContext`\[Theta]\[Theta]$, \
$CellContext`grid1$]}, $CellContext`typediffslit$$ == 
          "variable", {$CellContext`lc1$ = $CellContext`oneonxTable[
             Min[
              $CellContext`VariableDivergence[$CellContext`\[Theta]\[Theta]$, \
$CellContext`cvar$$, $CellContext`rs$$], -0.001], $CellContext`\[Theta]\
\[Theta]$, $CellContext`grid1$]}]; $CellContext`lc2$ = $CellContext`lc1$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$]; \
$CellContext`lc1$ = 
         Chop[ListConvolve[$CellContext`lc1$, $CellContext`kernel1$, \
$CellContext`middle1$] $CellContext`stepw1$]; $CellContext`lc2$ = 
         Chop[
          ListConvolve[$CellContext`lc2$, $CellContext`kernel2$, \
$CellContext`middle2$] $CellContext`stepw2$]; $CellContext`fwhmpos$ = \
$CellContext`fwhmcalc[
           
           Transpose[{$CellContext`grid1$ - $CellContext`\[Theta]\[Theta]$, \
$CellContext`lc1$}], 8]; $CellContext`fwhmabs = Abs[
            Part[$CellContext`fwhmpos$, 1]] + Abs[
            Part[$CellContext`fwhmpos$, 2]]; $CellContext`ftlc$ = 
         Interpolation[
           $CellContext`fourierData[
            
            Transpose[{$CellContext`grid2$ - $CellContext`ss$$, \
$CellContext`lc2$}], 1.], InterpolationOrder -> 1]; $CellContext`lp1$ = 
         ListLinePlot[$CellContext`lc1$, 
           DataRange -> {$CellContext`leftbound1$, $CellContext`rightbound1$},
            PlotRange -> {{($CellContext`leftbound1$ - $CellContext`\[Theta]\
\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\[Theta]$, \
($CellContext`rightbound1$ - \
$CellContext`\[Theta]\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\
\[Theta]$}, Full}, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
           PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {"2\[Theta] axis (\[Degree])", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], Epilog -> {
             Inset[
              Framed[
               Style[Text[
                  NumberForm[$CellContext`fwhmabs, 3]] 
                "fwhm (\[Degree]2\[Theta]) ", 20]], 
              ImageScaled[{0.25, 0.85}]], 
             InfiniteLine[{0, 0}, {0, 1}]}, ImageSize -> 
           500]; $CellContext`lp2$ = 
         ListLinePlot[$CellContext`lc2$, 
           DataRange -> {$CellContext`leftbound2$, $CellContext`rightbound2$},
            PlotRange -> {{($CellContext`leftbound2$ - \
$CellContext`ss$$)/$CellContext`xMag$$ + $CellContext`ss$$, \
($CellContext`rightbound2$ - $CellContext`ss$$)/$CellContext`xMag$$ + \
$CellContext`ss$$}, Full}, GridLines -> Automatic, GridLinesStyle -> 
           Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {
            "\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis (\!\(\*SuperscriptBox[\
\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp3$ = 
         Plot[{
            $CellContext`ftlc$[$CellContext`x]}, {$CellContext`x, \
((-32.)/($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$, (
             32./($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$}, PlotRange -> Full, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, FrameLabel -> {"s (nm)", "Fourier transform"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Fourier transform of diffraction peak"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp4$ = 
         Plot[
           Which[$CellContext`typediffslit$$ == "fixed", 
            $CellContext`FixedDivergence[$CellContext`x, \
$CellContext`cfix$$], $CellContext`typediffslit$$ == "variable", 
            $CellContext`VariableDivergence[$CellContext`x, \
$CellContext`cvar$$, $CellContext`rs$$]], {$CellContext`x, 1., 179.}, 
           PlotRange -> All, GridLines -> Automatic, GridLinesStyle -> 
           Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {
            "2\[Theta] axis (\[Degree])", 
             "fhwm of aberration (2\[Degree]\[Theta])"}, 
           FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], Filling -> None, PlotLegends -> 
           Placed[
             LineLegend[{"fwhm caused by aberration"}], {0.4, Bottom}], 
           TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 
           500]; $CellContext`\[Theta]\[Theta]pos$ = Graphics[{
            PointSize[Large], Red, 
            Point[{$CellContext`\[Theta]\[Theta]$, 
              Which[$CellContext`typediffslit$$ == "fixed", 
               $CellContext`FixedDivergence[$CellContext`\[Theta]\[Theta]$, \
$CellContext`cfix$$], $CellContext`typediffslit$$ == "variable", 
               $CellContext`VariableDivergence[$CellContext`\[Theta]\[Theta]$,\
 $CellContext`cvar$$, $CellContext`rs$$]]}]}]; If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`lp1$, \
$CellContext`lp2$, $CellContext`lp3$, $CellContext`lp4$, \
$CellContext`\[Theta]\[Theta]pos$}], $CellContext`export$$ = False}]; 
        Grid[{{$CellContext`lp1$, $CellContext`lp2$}, {$CellContext`lp3$, 
            Show[$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$]}}]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.01, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.01, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 2}, 
        Grid[{{
           Text[
            Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
           Dynamic[
            NumberForm[
             $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}], 
        Delimiter, 
        Text[
         Style[
         "Type of divergence slit", 16, Bold]], {{$CellContext`typediffslit$$,
           "fixed", ""}, {"fixed", "variable"}, ControlType -> RadioButton, 
         Appearance -> "Vertical"}, Delimiter, 
        Text[
         Style[
         "Parameters of diffractometer", 16, Bold]], {{$CellContext`rs$$, 
          217.5, ""}, 10., 300., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`cfix$$, 1., ""}, 
         0.5, 5., ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 4}, {{$CellContext`cvar$$, 30., ""}, 1., 40., 
         ControlType -> Slider, Appearance -> "Labeled", ControlPlacement -> 
         5}, {{$CellContext`lambda$$, 0.154059, ""}, 0.01, 0.3, ControlType -> 
         Slider, Appearance -> "Labeled", ControlPlacement -> 
         6}, {{$CellContext`ss$$, 5., ""}, 0.001, 
         Dynamic[2./$CellContext`lambda$$], ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 7}, 
        Grid[{{"secondary diffract. radius", 
           Manipulate`Place[3], "mm"}, {"fixed div slit opening    ", 
           Manipulate`Place[4], "mm"}, {"variable slit opening     ", 
           Manipulate`Place[5], "\[Degree]"}, {}, {"wavelength ", 
           Manipulate`Place[6], "nm"}, {
          "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
           Manipulate`Place[7], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
          "peak center (d)", 
           Dynamic[
            NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
          "peak center (2\[Theta])", 
           Dynamic[
            NumberForm[
             $CellContext`\[Theta]2[$CellContext`ss$$, \
$CellContext`lambda$$], {3, 5}]], "\[Degree]"}}, 
         Alignment -> {{Left}, {Center}}], 
        Delimiter, {{$CellContext`xMag$$, 1., 
          "zoom factor in 2\[Theta]-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> 
         "Labeled"}, {{$CellContext`kMag$$, 1., 
          "zoom factor in Fourier-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & P. Scardi", "", 
          "Effect on the peak profile of 1/X aberrations in the equatorial \
plane\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> True, TrackedSymbols -> True, SynchronousUpdating -> 
        False}, "DefaultOptions" :> {}],
     ImageSizeCache->{1724., {411., 417.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.82487566366308*^9, 3.8248757366169224`*^9, 3.824956554994928*^9, 
   3.824961398016749*^9, 3.8251523512690754`*^9, 3.825488987841462*^9, 
   3.8254891963598185`*^9, 3.825489696756911*^9, 3.8254969027943225`*^9, 
   3.8254972395282354`*^9, 3.826946522122607*^9, 3.826946766693363*^9, 
   3.8269469715597954`*^9, 3.8269476002209177`*^9, 3.8269487225679536`*^9, 
   3.826948787194873*^9, 3.8269499669328995`*^9, 3.826966243744276*^9, 
   3.8278401189830503`*^9, 3.828176455440488*^9, {3.828185273181919*^9, 
   3.828185313121952*^9}, 3.8281875232375813`*^9, 3.8286141708222895`*^9, 
   3.8286143661828804`*^9, 3.8286874206686907`*^9, 3.830597251902062*^9, 
   3.831605929956412*^9, 3.831623028624961*^9, 3.8321458803538437`*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"f00e6c2d-025c-41bd-99f7-cf31e661e5f5"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8201630615554333`*^9, 3.82016307533703*^9}, {
   3.820210236838038*^9, 3.820210260401258*^9}, {3.820210324753332*^9, 
   3.820210331264793*^9}, {3.820210366698591*^9, 3.8202104092043023`*^9}, {
   3.8202104448619995`*^9, 3.8202106034929676`*^9}, {3.8202106779331284`*^9, 
   3.820210687908089*^9}, {3.8202107353887663`*^9, 3.820210745342908*^9}, {
   3.820210859940411*^9, 3.8202109315631075`*^9}, {3.820210968441333*^9, 
   3.820210984929367*^9}, {3.8202110902461004`*^9, 3.820211250455308*^9}, {
   3.820211297843593*^9, 3.820211301003912*^9}, {3.820211350115013*^9, 
   3.8202113978679724`*^9}, {3.820211459860341*^9, 3.820211570607502*^9}, {
   3.820211835742196*^9, 3.8202118419584813`*^9}, {3.820211883538022*^9, 
   3.8202119276985903`*^9}, 3.8202119806398773`*^9, 3.8202120228174286`*^9, {
   3.8202121535973063`*^9, 3.820212155800887*^9}, {3.820212237201031*^9, 
   3.82021224733747*^9}, {3.820213007362079*^9, 3.8202130395661116`*^9}, {
   3.820213370327173*^9, 3.820213373265058*^9}, {3.820213441517354*^9, 
   3.8202134704713593`*^9}, {3.8202249822864933`*^9, 
   3.8202250420986166`*^9}, {3.820225151521139*^9, 3.8202251603397007`*^9}, {
   3.820225202334646*^9, 3.8202252082312336`*^9}, {3.8202252462578*^9, 
   3.82022524664837*^9}, {3.8213692857733846`*^9, 3.8213692862781067`*^9}, {
   3.824813538429804*^9, 3.824813601417632*^9}, {3.8248137249400015`*^9, 
   3.8248137824745703`*^9}, {3.824815903082875*^9, 3.8248159839304314`*^9}, {
   3.8248160206822195`*^9, 3.82481610449847*^9}, {3.8248162083001733`*^9, 
   3.824816334009283*^9}, {3.824874967892801*^9, 3.8248750144157953`*^9}, {
   3.8248750639618587`*^9, 3.8248751020695267`*^9}, 3.8248751907820263`*^9, {
   3.824875325570565*^9, 3.8248753951955357`*^9}, 3.8248754410543747`*^9, 
   3.8248755280045123`*^9, 3.8248755703358645`*^9, {3.824875639532567*^9, 
   3.824875648093264*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"94d040a7-a1bb-4847-b6d0-08185456ea66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Effect on the peak profile of linear absorption  \
(exponential function)", "Chapter"]], "Title",
 CellChangeTimes->{{3.7944730484525137`*^9, 3.7944730531562967`*^9}, {
   3.794473090557276*^9, 3.794473100964528*^9}, {3.8201203831885056`*^9, 
   3.820120405845306*^9}, {3.820134318920413*^9, 3.820134402585107*^9}, 
   3.8201350165140266`*^9, {3.8202303493499947`*^9, 3.8202303682088804`*^9}},
 CellTags->"Title",ExpressionUUID->"d2a35c83-d712-44eb-8a2b-1ee3466e5a17"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fwhmabs", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Quiet", "@", 
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "fwhmpos", ",", " ", "\[IndentingNewLine]", "               ", 
        "points", ",", "\[IndentingNewLine]", "               ", 
        "\[Theta]\[Theta]", ",", "\[IndentingNewLine]", "              ", 
        "leftbound1", ",", "rightbound1", ",", "  ", "stepw1", ",", "grid1", 
        ",", "middle1", ",", " ", "kernel1", ",", " ", "lc1", ",", 
        "\[IndentingNewLine]", "              ", "leftbound2", ",", 
        "rightbound2", ",", "  ", "stepw2", ",", "grid2", ",", "middle2", ",",
         " ", "kernel2", ",", " ", "lc2", ",", "\[IndentingNewLine]", 
        "              ", "ftlc", ",", " ", "lp1", ",", "lp2", ",", " ", 
        "lp3", ",", "lp4", ",", "\[Theta]\[Theta]pos"}], "}"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "     ", 
      RowBox[{
       RowBox[{"points", "         ", "=", " ", "4096"}], ";", 
       "\[IndentingNewLine]", "     ", 
       RowBox[{"\[Theta]\[Theta]", "                  ", "=", " ", 
        RowBox[{"\[Theta]2", "[", 
         RowBox[{"ss", ",", "lambda"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "   ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"2", "\[Theta]"}], "-", "space"}], " ", "*)"}], 
       "\[IndentingNewLine]", "   ", 
       RowBox[{"leftbound1", "   ", "=", " ", 
        RowBox[{"\[Theta]\[Theta]", " ", "-", " ", 
         RowBox[{"6.", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]", 
       "   ", 
       RowBox[{"rightbound1", "=", " ", 
        RowBox[{"\[Theta]\[Theta]", " ", "+", " ", 
         RowBox[{"6.", " ", "fwhmabs"}]}]}], ";", " ", "\[IndentingNewLine]", 
       "   ", 
       RowBox[{"stepw1", "           ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound1", "-", "leftbound1"}], ")"}], "/", 
         "points"}]}], ";", "\[IndentingNewLine]", "   ", 
       RowBox[{"grid1", "             ", "=", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound1", ",", "rightbound1", ",", "stepw1"}], "]"}]}], 
       ";", "\[IndentingNewLine]", "   ", 
       RowBox[{"middle1", "        ", "=", 
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Length", "[", "grid1", "]"}], "/", "2"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "  ", 
       RowBox[{"kernel1", "         ", "=", 
        RowBox[{"VoigtApproxTable", "[", 
         RowBox[{
         "\[Delta]", ",", "\[Sigma]", ",", "\[Theta]\[Theta]", ",", "grid1"}],
          "]"}]}], ";", "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
       "   ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"s", " ", 
          RowBox[{"(", 
           RowBox[{"=", 
            RowBox[{"1", "/", "d"}]}], ")"}]}], " ", "-", "space"}], " ", 
        "*)"}], "\[IndentingNewLine]", "    ", 
       RowBox[{"leftbound2", "   ", "=", " ", 
        RowBox[{"s", "[", 
         RowBox[{"leftbound1", ",", "lambda"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", "   ", 
       RowBox[{"rightbound2", "=", " ", 
        RowBox[{"s", "[", 
         RowBox[{"rightbound1", ",", "lambda"}], "]"}]}], ";", " ", 
       "\[IndentingNewLine]", "   ", 
       RowBox[{"stepw2", "            ", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"rightbound2", "-", "leftbound2"}], ")"}], "/", 
         "points"}]}], ";", "\[IndentingNewLine]", "   ", 
       RowBox[{"grid2", "              ", "=", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"leftbound2", ",", "rightbound2", ",", "stepw2"}], "]"}]}], 
       ";", "\[IndentingNewLine]", "   ", 
       RowBox[{"middle2", "        ", "=", "  ", 
        RowBox[{"Ceiling", "[", 
         RowBox[{
          RowBox[{"Length", "[", "grid2", "]"}], "/", "2"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "   ", 
       RowBox[{"kernel2", "        ", "=", "  ", 
        RowBox[{"VoigtApproxTable", "[", 
         RowBox[{
          RowBox[{"\[Delta]", " ", 
           RowBox[{"cs", "[", 
            RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", 
          RowBox[{"\[Sigma]", " ", 
           RowBox[{"cs", "[", 
            RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}], ",", "ss", 
          ",", "grid2"}], "]"}]}], ";", "\[IndentingNewLine]", "     ", 
       "\[IndentingNewLine]", "   ", 
       RowBox[{"lc1", " ", "=", 
        RowBox[{"expoTable", "[", 
         RowBox[{
          RowBox[{"LinearAbsorption", "[", 
           RowBox[{"\[Theta]\[Theta]", ",", "c", ",", "rs"}], "]"}], ",", 
          "\[Theta]\[Theta]", ",", "grid1"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "    ", 
       RowBox[{"lc2", "=", 
        RowBox[{"lc1", " ", 
         RowBox[{"cs", "[", 
          RowBox[{"\[Theta]\[Theta]", ",", "lambda"}], "]"}]}]}], ";", " ", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
       RowBox[{"lc1", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"ListConvolve", "[", 
           RowBox[{"lc1", ",", "kernel1", ",", "middle1"}], "]"}], " ", 
          "stepw1"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", "    ", 
       RowBox[{"lc2", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"ListConvolve", "[", 
           RowBox[{"lc2", ",", "kernel2", ",", "middle2"}], "]"}], " ", 
          "stepw2"}], "//", "Chop"}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", "     ", 
       RowBox[{"fwhmpos", "=", 
        RowBox[{"fwhmcalc", "[", 
         RowBox[{
          RowBox[{"Transpose", " ", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"grid1", "-", "\[Theta]\[Theta]"}], ",", "lc1"}], "}"}], 
           "]"}], ",", "8"}], "]"}]}], ";", "\[IndentingNewLine]", "     ", 
       RowBox[{"fwhmabs", "=", " ", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"fwhmpos", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
         RowBox[{"Abs", "[", 
          RowBox[{"fwhmpos", "[", 
           RowBox[{"[", "2", "]"}], "]"}], " ", "]"}]}]}], ";", 
       "\[IndentingNewLine]", "     ", "\[IndentingNewLine]", "     ", 
       RowBox[{"ftlc", "  ", "=", "  ", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"fourierData", "[", 
           RowBox[{
            RowBox[{"Transpose", " ", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"grid2", "-", "ss"}], ",", "lc2"}], "}"}], "]"}], ",", 
            "1.0"}], "]"}], ",", 
          RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
       "  ", "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
       RowBox[{"lp1", "=", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{"lc1", ",", "      ", 
          RowBox[{"DataRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"leftbound1", ",", " ", "rightbound1"}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", " ", 
                  RowBox[{"leftbound1", "-", "\[Theta]\[Theta]"}], ")"}], "/",
                  "xMag"}], "+", "\[Theta]\[Theta]"}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", " ", 
                  RowBox[{"rightbound1", "-", "\[Theta]\[Theta]"}], ")"}], 
                 "/", "xMag"}], "+", "\[Theta]\[Theta]"}]}], "}"}], ",", 
             "Full"}], "}"}]}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
             "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"None", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{
              "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
              "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                                                          ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Epilog", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Inset", "[", 
              RowBox[{
               RowBox[{"Framed", "[", 
                RowBox[{"Style", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Text", "[", 
                    RowBox[{"NumberForm", "[", 
                    RowBox[{"fwhmabs", ",", "3"}], "]"}], "]"}], 
                   "\"\<fwhm/\[Degree]2\[Theta] \>\""}], ",", "20"}], "]"}], 
                " ", "]"}], ",", 
               RowBox[{"ImageScaled", "[", 
                RowBox[{"{", 
                 RowBox[{"0.25", ",", "0.85"}], "}"}], "]"}]}], "]"}], ",", 
             RowBox[{"InfiniteLine", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
       RowBox[{"lp2", "=", 
        RowBox[{"ListLinePlot", "[", 
         RowBox[{"lc2", ",", "      ", 
          RowBox[{"DataRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"leftbound2", ",", " ", "rightbound2"}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotRange", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"(", " ", 
                  RowBox[{"leftbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                "+", "ss"}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", " ", 
                  RowBox[{"rightbound2", "-", "ss"}], ")"}], "/", "xMag"}], 
                "+", "ss"}]}], "}"}], ",", "Full"}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))\>\"", ",", 
             "\"\<Intensity (a.u.)\>\""}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"None", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{
              "{", "\"\<Voigt peak with aberration functions\>\"", "}"}], 
              "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                                                          ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "      ", 
       RowBox[{"lp3", "=", " ", 
        RowBox[{"Plot", "[", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ftlc", "[", "x", "]"}], "}"}], ",", 
          "                      ", "\[IndentingNewLine]", 
          "                                                        ", 
          RowBox[{"{", 
           RowBox[{"x", ",", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "32."}], "/", 
               RowBox[{"(", 
                RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
             "/", "kMag"}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"32.", "/", 
               RowBox[{"(", 
                RowBox[{"rightbound2", "-", "leftbound2"}], ")"}]}], ")"}], 
             "/", "kMag"}]}], "}"}], ",", "\[IndentingNewLine]", 
          "                                                        ", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<s (nm)\>\"", ",", "\"\<Fourier transform\>\""}], 
            "}"}]}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"None", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Filling", "\[Rule]", "Axis"}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{
              "{", "\"\<Fourier transform of diffraction peak\>\"", "}"}], 
              "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                                                          ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "   ", 
       RowBox[{"lp4", "=", " ", 
        RowBox[{"Plot", "[", "  ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"LinearAbsorption", "[", 
            RowBox[{"x", ",", "c", ",", "rs"}], "]"}], "}"}], ",", 
          "                      ", "\[IndentingNewLine]", 
          "                                                        ", 
          RowBox[{"{", 
           RowBox[{"x", ",", " ", "1.", ",", "179.0"}], "}"}], ",", 
          "\[IndentingNewLine]", 
          "                                                        ", 
          RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]",
           "                                                         ", 
          RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
          RowBox[{"GridLinesStyle", "\[Rule]", 
           RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameLabel", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
            "\"\<2\[Theta] axis (\[Degree])\>\"", ",", 
             "\"\<fhwm of aberration (2\[Degree]\[Theta])\>\""}], "}"}]}], 
          ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"FrameTicks", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
          " ", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"PlotLegends", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{
             RowBox[{"LineLegend", "[", 
              RowBox[{"{", "\"\<fwhm caused by aberration\>\"", "}"}], "]"}], 
             ",", 
             RowBox[{"{", 
              RowBox[{"0.4", ",", "Top"}], "}"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"TicksStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]",
           "                                                          ", 
          RowBox[{"AxesStyle", "\[Rule]", 
           RowBox[{"Directive", "[", 
            RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          "                                                         ", 
          RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "    ", 
       RowBox[{"\[Theta]\[Theta]pos", "=", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"\[Theta]\[Theta]", ",", 
              RowBox[{"LinearAbsorption", "[", 
               RowBox[{"\[Theta]\[Theta]", ",", "c", ",", "rs"}], "]"}]}], 
             "}"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       "    ", "\[IndentingNewLine]", "    ", 
       RowBox[{"If", "[", 
        RowBox[{"export", ",", 
         RowBox[{"{", "\[IndentingNewLine]", "                       ", 
          RowBox[{
           RowBox[{"Export", "[", 
            RowBox[{"filePath", ",", 
             RowBox[{"{", 
              RowBox[{
              "lp1", ",", "lp2", ",", "lp3", ",", "lp4", ",", 
               "\[Theta]\[Theta]pos"}], "}"}]}], "]"}], ",", " ", 
           "\[IndentingNewLine]", "                       ", 
           RowBox[{"export", "=", "False"}]}], "\[IndentingNewLine]", 
          "                     ", "}"}]}], "\[IndentingNewLine]", "   ", 
        "]"}], ";", " ", "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lp1", ",", "lp2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"lp3", ",", 
            RowBox[{"Show", "[", 
             RowBox[{"lp4", ",", "\[Theta]\[Theta]pos"}], "]"}]}], "}"}]}], 
         "}"}], "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "              ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Text", "[", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Voigt function\>\"", ",", "16", ",", "Bold"}], "]"}], 
          "]"}], "}"}], ",", "\[IndentingNewLine]", "              ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<\[Delta] \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Delta]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
             "0.001", ",", "1.", ",", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Slider", "[", 
                  RowBox[{
                   RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Delta]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                   RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                 "\"\< \>\"", ",", 
                 RowBox[{"InputField", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                "}"}], "]"}], "&"}]}], "}"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
        "\[IndentingNewLine]", "              ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<\[Sigma] \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\[Sigma]", ",", "0.03", ",", "\"\<\>\""}], "}"}], ",", 
             "0.001", ",", "1.", ",", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Slider", "[", 
                  RowBox[{
                   RowBox[{"Dynamic", "[", 
                    RowBox[{
                    RowBox[{"Log10", "[", "#", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Sigma]", "=", 
                    RowBox[{"10", "^", "#"}]}], ")"}], "&"}]}], "]"}], ",", 
                   RowBox[{"Log10", "[", "#2", "]"}]}], "]"}], ",", 
                 "\"\< \>\"", ",", 
                 RowBox[{"InputField", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Label\>\"", ",", "15"}], "}"}]}]}], "]"}]}], 
                "}"}], "]"}], "&"}]}], "}"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], " ", "}"}], ",", 
        "\[IndentingNewLine]", "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<Gauss   fwhm\>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Gaussfwhm", "[", "\[Sigma]", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<Lorentz fwhm\>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Lorentzfwhm", "[", "\[Delta]", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<Voigt   fwhm\>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Voigtfwhm", "[", 
              RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]2\[Theta]\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<mixing  \[Delta]/\[Sigma] \>\"", ",", " ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"Mix", "[", 
              RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]}], "}"}]}], 
       "\[IndentingNewLine]", "        ", "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "Left", "}"}], ",", 
         RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
      "\"\<Parameters of diffractometer\>\"", ",", "16", ",", "Bold"}], "]"}],
      "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "                ", 
       RowBox[{
        RowBox[{"{", "   ", 
         RowBox[{"\"\<secondary diffract. radius\>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"rs", ",", "217.5", ",", "\"\<\>\""}], "}"}], ",", 
             "10.0", ",", " ", "300.0", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          ",", "\"\<mm\>\""}], " ", "}"}], ",", "\[IndentingNewLine]", 
        "                ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<linear absorption coeff   \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"c", ",", "   ", "100.0", ",", "\"\<\>\""}], "}"}], ",",
              "  ", "3.0", ",", "500.0", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          ",", "\"\<\!\(\*SuperscriptBox[\(mm\), \(\(-1\)\(\\\ \)\)]\)\>\""}],
          " ", "}"}], ",", "\[IndentingNewLine]", 
        "                               ", 
        RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "              ", 
        RowBox[{"{", "   ", 
         RowBox[{"\"\<wavelength \>\"", ",", "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "      ", 
              RowBox[{"lambda", ",", "       ", "0.154059", ",", "\"\<\>\""}],
               "}"}], ",", "0.01", ",", "  ", "0.3", ",", "Slider", ",", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          " ", ",", "\"\<nm\>\""}], "}"}], ",", "\[IndentingNewLine]", 
        "              ", 
        RowBox[{"{", "   ", 
         RowBox[{
         "\"\<peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))\>\"", ",", 
          "  ", 
          RowBox[{"Control", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", " ", 
              RowBox[{"ss", ",", "5.", ",", "\"\<\>\""}], "}"}], ",", "0.001",
              ",", 
             RowBox[{"2.", "/", "lambda"}], ",", "Slider", ",", " ", 
             RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
          " ", ",", "\"\<\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)\>\""}], "}"}],
         ",", "\[IndentingNewLine]", "               ", 
        RowBox[{"{", "  ", 
         RowBox[{"\"\<peak center (d)\>\"", ",", "     ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", 
            RowBox[{
             RowBox[{"1", "/", "ss"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", "\"\<nm\>\""}], 
         "}"}], ",", "\[IndentingNewLine]", "               ", 
        RowBox[{"{", " ", 
         RowBox[{"\"\<peak center (2\[Theta])\>\"", ",", "  ", 
          RowBox[{"Dynamic", "@", 
           RowBox[{"NumberForm", "[", " ", 
            RowBox[{
             RowBox[{"\[Theta]2", "[", 
              RowBox[{"ss", ",", "lambda"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "5"}], "}"}]}], "]"}]}], ",", 
          "\"\<\[Degree]\>\""}], "}"}]}], "                  ", 
       "\[IndentingNewLine]", "        ", "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "Left", "}"}], ",", 
         RowBox[{"{", " ", "Center", " ", "}"}]}], "}"}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "       ", 
        RowBox[{
        "xMag", ",", "1.", ",", "\"\<zoom factor in 2\[Theta]-space\>\""}], 
        "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
       ",", 
       RowBox[{"Exclusions", "\[Rule]", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
    ",", " ", "\[IndentingNewLine]", 
    RowBox[{"Control", "@", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "       ", 
        RowBox[{
        "kMag", ",", "1.", ",", "\"\<zoom factor in Fourier-space\>\""}], 
        "}"}], ",", " ", "0.1", ",", " ", "10.", ",", "0.1", ",", "Slider", 
       ",", 
       RowBox[{"Exclusions", "\[Rule]", 
        RowBox[{"{", "0", "}"}]}], ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], " ", 
    ",", " ", "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"export", ",", "False"}], "}"}], ",", "None"}], "}"}], ",", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Export to desktop\>\"", ",", 
      RowBox[{"export", "=", "True"}]}], "]"}], ",", " ", 
    "\[IndentingNewLine]", " ", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<by R. E. Dinnebier & P. Scardi\>\"", ",", "\"\<\>\"", ",", " ", 
       "\"\<Effect on the peak profile of exponential aberrations due to \
linear absorption\\n\>\""}], "}"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Bold", ",", " ", "16"}], "]"}]}], ",", " ", 
    RowBox[{"ControlPlacement", "\[Rule]", 
     RowBox[{"{", "Left", "}"}]}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"ContinuousAction", "\[Rule]", "True"}], ",", " ", 
    RowBox[{"(*", 
     RowBox[{"must", " ", "be", " ", 
      RowBox[{"true", " ", "!"}]}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"SaveDefinitions", "\[Rule]", "True"}], ","}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"TrackedSymbols", "\[Rule]", "True"}], " ", ",", 
    "\[IndentingNewLine]", " ", 
    RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8248124481002054`*^9, 3.8248124758047705`*^9}, {
   3.8248125103072166`*^9, 3.8248125392462053`*^9}, 3.824812569544921*^9, {
   3.8248126491751738`*^9, 3.8248127080845594`*^9}, {3.824812759228319*^9, 
   3.824812836795431*^9}, {3.8248128678126497`*^9, 3.8248128787353964`*^9}, {
   3.824813034681962*^9, 3.824813035588359*^9}, {3.8248131052174673`*^9, 
   3.8248131159055266`*^9}, {3.824813346934935*^9, 3.8248133772018843`*^9}, {
   3.824878982318041*^9, 3.8248789979714375`*^9}, {3.824879040688345*^9, 
   3.8248791066248116`*^9}, {3.824879140340571*^9, 3.8248792311254644`*^9}, {
   3.82496129588958*^9, 3.82496130199936*^9}, {3.8249614536897955`*^9, 
   3.8249614543147974`*^9}, {3.8254978560705028`*^9, 
   3.8254978683210216`*^9}, {3.826945630651009*^9, 3.826945655561385*^9}, {
   3.8269469613563623`*^9, 3.82694696143439*^9}, 3.8269486664965353`*^9, {
   3.8269487290058355`*^9, 3.8269487540548844`*^9}, 3.826949492278558*^9, 
   3.8269495243731375`*^9, {3.8281853523363886`*^9, 3.8281853546896644`*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"fa256ac1-243a-4004-8009-037c769cf1ab"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c$$ = 100., $CellContext`export$$ = 
    False, $CellContext`kMag$$ = 1., $CellContext`lambda$$ = 
    0.154059, $CellContext`rs$$ = 217.5, $CellContext`ss$$ = 
    8.542523891353312, $CellContext`xMag$$ = 1., $CellContext`\[Delta]$$ = 
    0.003630780547701014, $CellContext`\[Sigma]$$ = 0.003935500754557773, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Delta]$$], 0.03, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {{
       Hold[$CellContext`\[Sigma]$$], 0.03, ""}, 0.001, 1., 
      Dynamic[Row[{
         Slider[
          Dynamic[
           Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
          Log10[#2]], " ", 
         InputField[#, Appearance -> "Labeled", 
          BaseStyle -> {"Label", 15}]}]& ]}, {
      Hold[
       Grid[{{
          Text[
           Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
          Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
          Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
          "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
          Dynamic[
           NumberForm[
            $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
          Dynamic[
           NumberForm[
            $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Text[
        Style["Parameters of diffractometer", 16, Bold]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`rs$$], 217.5, ""}, 10., 300.}, {{
       Hold[$CellContext`c$$], 100., ""}, 3., 500.}, {{
       Hold[$CellContext`lambda$$], 0.154059, ""}, 0.01, 0.3}, {{
       Hold[$CellContext`ss$$], 5., ""}, 0.001, 
      Dynamic[2./$CellContext`lambda$$]}, {
      Hold[
       Grid[{{"secondary diffract. radius", 
          Manipulate`Place[3], "mm"}, {"linear absorption coeff   ", 
          Manipulate`Place[4], 
          "\!\(\*SuperscriptBox[\(mm\), \(\(-1\)\(\\ \)\)]\)"}, {}, {
         "wavelength ", 
          Manipulate`Place[5], "nm"}, {
         "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
          Manipulate`Place[6], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
         "peak center (d)", 
          Dynamic[
           NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
         "peak center (2\[Theta])", 
          Dynamic[
           NumberForm[
            $CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$], \
{3, 5}]], "\[Degree]"}}, Alignment -> {{Left}, {Center}}]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`xMag$$], 1., "zoom factor in 2\[Theta]-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`kMag$$], 1., "zoom factor in Fourier-space"}, 0.1, 
      10., 0.1}, {{
       Hold[$CellContext`export$$], False}, 0}, {
      Hold[
       Button["Export to desktop", $CellContext`export$$ = True]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    1009., {342., 348.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`c$$ = 100., $CellContext`export$$ = 
        False, $CellContext`kMag$$ = 1., $CellContext`lambda$$ = 
        0.154059, $CellContext`rs$$ = 217.5, $CellContext`ss$$ = 
        5., $CellContext`xMag$$ = 1., $CellContext`\[Delta]$$ = 
        0.03, $CellContext`\[Sigma]$$ = 0.03}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`fwhmpos$, $CellContext`points$, $CellContext`\
\[Theta]\[Theta]$, $CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$, $CellContext`grid1$, $CellContext`middle1$, \
$CellContext`kernel1$, $CellContext`lc1$, $CellContext`leftbound2$, \
$CellContext`rightbound2$, $CellContext`stepw2$, $CellContext`grid2$, \
$CellContext`middle2$, $CellContext`kernel2$, $CellContext`lc2$, \
$CellContext`ftlc$, $CellContext`lp1$, $CellContext`lp2$, $CellContext`lp3$, \
$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$}, $CellContext`points$ = 
         4096; $CellContext`\[Theta]\[Theta]$ = \
$CellContext`\[Theta]2[$CellContext`ss$$, $CellContext`lambda$$]; \
$CellContext`leftbound1$ = $CellContext`\[Theta]\[Theta]$ - 
          6. $CellContext`fwhmabs; $CellContext`rightbound1$ = $CellContext`\
\[Theta]\[Theta]$ + 
          6. $CellContext`fwhmabs; $CellContext`stepw1$ = \
($CellContext`rightbound1$ - $CellContext`leftbound1$)/$CellContext`points$; \
$CellContext`grid1$ = 
         Range[$CellContext`leftbound1$, $CellContext`rightbound1$, \
$CellContext`stepw1$]; $CellContext`middle1$ = 
         Ceiling[Length[$CellContext`grid1$]/
           2]; $CellContext`kernel1$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$, $CellContext`\[Theta]\[Theta]$, $CellContext`grid1$]; \
$CellContext`leftbound2$ = $CellContext`s[$CellContext`leftbound1$, \
$CellContext`lambda$$]; $CellContext`rightbound2$ = \
$CellContext`s[$CellContext`rightbound1$, $CellContext`lambda$$]; \
$CellContext`stepw2$ = ($CellContext`rightbound2$ - \
$CellContext`leftbound2$)/$CellContext`points$; $CellContext`grid2$ = 
         Range[$CellContext`leftbound2$, $CellContext`rightbound2$, \
$CellContext`stepw2$]; $CellContext`middle2$ = 
         Ceiling[Length[$CellContext`grid2$]/
           2]; $CellContext`kernel2$ = \
$CellContext`VoigtApproxTable[$CellContext`\[Delta]$$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$], \
$CellContext`\[Sigma]$$ $CellContext`cs[$CellContext`\[Theta]\[Theta]$, \
$CellContext`lambda$$], $CellContext`ss$$, $CellContext`grid2$]; \
$CellContext`lc1$ = $CellContext`expoTable[
           $CellContext`LinearAbsorption[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c$$, $CellContext`rs$$], $CellContext`\[Theta]\[Theta]$, \
$CellContext`grid1$]; $CellContext`lc2$ = $CellContext`lc1$ \
$CellContext`cs[$CellContext`\[Theta]\[Theta]$, $CellContext`lambda$$]; \
$CellContext`lc1$ = 
         Chop[ListConvolve[$CellContext`lc1$, $CellContext`kernel1$, \
$CellContext`middle1$] $CellContext`stepw1$]; $CellContext`lc2$ = 
         Chop[ListConvolve[$CellContext`lc2$, $CellContext`kernel2$, \
$CellContext`middle2$] $CellContext`stepw2$]; $CellContext`fwhmpos$ = \
$CellContext`fwhmcalc[
           
           Transpose[{$CellContext`grid1$ - $CellContext`\[Theta]\[Theta]$, \
$CellContext`lc1$}], 8]; $CellContext`fwhmabs = Abs[
            Part[$CellContext`fwhmpos$, 1]] + Abs[
            Part[$CellContext`fwhmpos$, 2]]; $CellContext`ftlc$ = 
         Interpolation[
           $CellContext`fourierData[
            
            Transpose[{$CellContext`grid2$ - $CellContext`ss$$, \
$CellContext`lc2$}], 1.], InterpolationOrder -> 1]; $CellContext`lp1$ = 
         ListLinePlot[$CellContext`lc1$, 
           DataRange -> {$CellContext`leftbound1$, $CellContext`rightbound1$},
            PlotRange -> {{($CellContext`leftbound1$ - $CellContext`\[Theta]\
\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\[Theta]$, \
($CellContext`rightbound1$ - \
$CellContext`\[Theta]\[Theta]$)/$CellContext`xMag$$ + $CellContext`\[Theta]\
\[Theta]$}, Full}, GridLines -> Automatic, GridLinesStyle -> Opacity[0.1], 
           PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {"2\[Theta] axis (\[Degree])", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], Epilog -> {
             Inset[
              Framed[
               Style[Text[
                  NumberForm[$CellContext`fwhmabs, 3]] 
                "fwhm/\[Degree]2\[Theta] ", 20]], 
              ImageScaled[{0.25, 0.85}]], 
             InfiniteLine[{0, 0}, {0, 1}]}, ImageSize -> 
           500]; $CellContext`lp2$ = 
         ListLinePlot[$CellContext`lc2$, 
           DataRange -> {$CellContext`leftbound2$, $CellContext`rightbound2$},
            PlotRange -> {{($CellContext`leftbound2$ - \
$CellContext`ss$$)/$CellContext`xMag$$ + $CellContext`ss$$, \
($CellContext`rightbound2$ - $CellContext`ss$$)/$CellContext`xMag$$ + \
$CellContext`ss$$}, Full}, GridLines -> Automatic, GridLinesStyle -> 
           Opacity[0.1], PlotStyle -> {Thick}, Frame -> True, 
           FrameLabel -> {
            "\!\(\*SuperscriptBox[\(d\), \(*\)]\) axis (\!\(\*SuperscriptBox[\
\(nm\), \(-1\)]\))", "Intensity (a.u.)"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Voigt peak with aberration functions"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp3$ = 
         Plot[{
            $CellContext`ftlc$[$CellContext`x]}, {$CellContext`x, \
((-32.)/($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$, (
             32./($CellContext`rightbound2$ - \
$CellContext`leftbound2$))/$CellContext`kMag$$}, PlotRange -> Full, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, FrameLabel -> {"s (nm)", "Fourier transform"}, 
           FrameTicks -> {{None, None}, {Automatic, Automatic}}, LabelStyle -> 
           Directive[Bold, 16], Filling -> Axis, PlotLegends -> Placed[
             LineLegend[{"Fourier transform of diffraction peak"}], {
             0.4, Top}], TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 500]; $CellContext`lp4$ = 
         Plot[{
            $CellContext`LinearAbsorption[$CellContext`x, $CellContext`c$$, \
$CellContext`rs$$]}, {$CellContext`x, 1., 179.}, PlotRange -> All, GridLines -> 
           Automatic, GridLinesStyle -> Opacity[0.1], PlotStyle -> {Thick}, 
           Frame -> True, 
           FrameLabel -> {
            "2\[Theta] axis (\[Degree])", 
             "fhwm of aberration (2\[Degree]\[Theta])"}, 
           FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
           LabelStyle -> Directive[Bold, 16], Filling -> None, PlotLegends -> 
           Placed[
             LineLegend[{"fwhm caused by aberration"}], {0.4, Top}], 
           TicksStyle -> Directive[Black, 15], AxesStyle -> 
           Directive[Black, Thick], ImageSize -> 
           500]; $CellContext`\[Theta]\[Theta]pos$ = Graphics[{
            PointSize[Large], Red, 
            Point[{$CellContext`\[Theta]\[Theta]$, 
              $CellContext`LinearAbsorption[$CellContext`\[Theta]\[Theta]$, \
$CellContext`c$$, $CellContext`rs$$]}]}]; If[$CellContext`export$$, {
           
           Export[$CellContext`filePath, {$CellContext`lp1$, \
$CellContext`lp2$, $CellContext`lp3$, $CellContext`lp4$, \
$CellContext`\[Theta]\[Theta]pos$}], $CellContext`export$$ = False}]; 
        Grid[{{$CellContext`lp1$, $CellContext`lp2$}, {$CellContext`lp3$, 
            Show[$CellContext`lp4$, $CellContext`\[Theta]\[Theta]pos$]}}]], 
      "Specifications" :> {{{$CellContext`\[Delta]$$, 0.03, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Delta]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 
         1}, {{$CellContext`\[Sigma]$$, 0.03, ""}, 0.001, 1., 
         Dynamic[Row[{
            Slider[
             Dynamic[
              Log10[#], ($CellContext`\[Sigma]$$ = 10^#)& ], 
             Log10[#2]], " ", 
            
            InputField[#, Appearance -> "Labeled", 
             BaseStyle -> {"Label", 15}]}]& ], ControlPlacement -> 2}, 
        Grid[{{
           Text[
            Style["Voigt function", 16, Bold]]}, {"\[Delta] ", 
           Manipulate`Place[1], "\[Degree]2\[Theta]"}, {"\[Sigma] ", 
           Manipulate`Place[2], "\[Degree]2\[Theta]"}, {"Gauss   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Gaussfwhm[$CellContext`\[Sigma]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Lorentz fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Lorentzfwhm[$CellContext`\[Delta]$$], {3, 5}]], 
           "\[Degree]2\[Theta]"}, {"Voigt   fwhm", 
           Dynamic[
            NumberForm[
             $CellContext`Voigtfwhm[$CellContext`\[Delta]$$, $CellContext`\
\[Sigma]$$], {3, 5}]], "\[Degree]2\[Theta]"}, {"mixing  \[Delta]/\[Sigma] ", 
           Dynamic[
            NumberForm[
             $CellContext`Mix[$CellContext`\[Delta]$$, \
$CellContext`\[Sigma]$$], {3, 2}]]}}, Alignment -> {{Left}, {Center}}], 
        Delimiter, 
        Text[
         Style[
         "Parameters of diffractometer", 16, Bold]], {{$CellContext`rs$$, 
          217.5, ""}, 10., 300., ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 3}, {{$CellContext`c$$, 100., ""}, 3.,
          500., ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 4}, {{$CellContext`lambda$$, 0.154059, ""}, 0.01,
          0.3, ControlType -> Slider, Appearance -> "Labeled", 
         ControlPlacement -> 5}, {{$CellContext`ss$$, 5., ""}, 0.001, 
         Dynamic[2./$CellContext`lambda$$], ControlType -> Slider, Appearance -> 
         "Labeled", ControlPlacement -> 6}, 
        Grid[{{"secondary diffract. radius", 
           Manipulate`Place[3], "mm"}, {"linear absorption coeff   ", 
           Manipulate`Place[4], 
           "\!\(\*SuperscriptBox[\(mm\), \(\(-1\)\(\\ \)\)]\)"}, {}, {
          "wavelength ", 
           Manipulate`Place[5], "nm"}, {
          "peak center (\!\(\*SuperscriptBox[\(d\), \(*\)]\))", 
           Manipulate`Place[6], "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)"}, {
          "peak center (d)", 
           Dynamic[
            NumberForm[1/$CellContext`ss$$, {3, 5}]], "nm"}, {
          "peak center (2\[Theta])", 
           Dynamic[
            NumberForm[
             $CellContext`\[Theta]2[$CellContext`ss$$, \
$CellContext`lambda$$], {3, 5}]], "\[Degree]"}}, 
         Alignment -> {{Left}, {Center}}], 
        Delimiter, {{$CellContext`xMag$$, 1., 
          "zoom factor in 2\[Theta]-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> 
         "Labeled"}, {{$CellContext`kMag$$, 1., 
          "zoom factor in Fourier-space"}, 0.1, 10., 0.1, ControlType -> 
         Slider, Exclusions -> {0}, Appearance -> "Labeled"}, 
        Delimiter, {{$CellContext`export$$, False}, 0, ControlType -> None}, 
        Button["Export to desktop", $CellContext`export$$ = True]}, 
      "Options" :> {
       FrameLabel -> {
         "by R. E. Dinnebier & P. Scardi", "", 
          "Effect on the peak profile of exponential aberrations due to \
linear absorption\n"}, LabelStyle -> Directive[
          GrayLevel[0], Bold, 16], ControlPlacement -> {Left}, 
        ContinuousAction -> True, TrackedSymbols -> True, SynchronousUpdating -> 
        False}, "DefaultOptions" :> {}],
     ImageSizeCache->{1724., {411., 417.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8197300902556353`*^9, 3.819730127881957*^9, 3.8197303004017687`*^9, {
   3.819790141471384*^9, 3.819790146065446*^9}, {3.819790211895508*^9, 
   3.8197902187398233`*^9}, 3.8197907149586697`*^9, {3.819790798305459*^9, 
   3.8197908024774494`*^9}, {3.819792690534674*^9, 3.819792696722711*^9}, {
   3.819792742020584*^9, 3.8197927693496485`*^9}, 3.81979279953512*^9, 
   3.819793594185934*^9, {3.819793747627595*^9, 3.8197937537840157`*^9}, {
   3.8197939405863047`*^9, 3.8197939597117167`*^9}, 3.819794033495157*^9, {
   3.8197940972781105`*^9, 3.819794115294241*^9}, {3.819794320346734*^9, 
   3.8197943246907067`*^9}, {3.8199493921381497`*^9, 
   3.8199494045439663`*^9}, {3.819950305908806*^9, 3.8199503159709888`*^9}, {
   3.819950346283352*^9, 3.819950352189387*^9}, {3.8199554484659863`*^9, 
   3.8199554726434574`*^9}, {3.8199556195054398`*^9, 3.819955627545648*^9}, 
   3.8199556673768806`*^9, {3.819955714765596*^9, 3.819955755196559*^9}, {
   3.819955785265073*^9, 3.8199557987626348`*^9}, {3.819956374630643*^9, 
   3.8199563775928593`*^9}, {3.8199564754843426`*^9, 3.8199564796813655`*^9}, 
   3.8199565353938255`*^9, {3.8199566241183863`*^9, 3.81995664371459*^9}, {
   3.819956805808609*^9, 3.819956814701168*^9}, {3.819958571020562*^9, 
   3.8199585789304123`*^9}, 3.8199586910429273`*^9, 3.819958808483882*^9, {
   3.8199588398884487`*^9, 3.81995896294154*^9}, 3.8199591259921618`*^9, {
   3.8199591986382413`*^9, 3.8199592068491077`*^9}, 3.819960655460984*^9, 
   3.8200516693278365`*^9, 3.8200523004569626`*^9, 3.8200528028944607`*^9, 
   3.82005286906826*^9, {3.82005308548112*^9, 3.8200530909972053`*^9}, {
   3.820053386037065*^9, 3.820053391802806*^9}, {3.8200539087088957`*^9, 
   3.820053924584486*^9}, 3.8200540283686314`*^9, 3.820054069151265*^9, {
   3.8200542585473003`*^9, 3.820054263156819*^9}, {3.8200543596439395`*^9, 
   3.8200543627378006`*^9}, {3.8200545678691893`*^9, 
   3.8200545987015777`*^9}, {3.820056358177434*^9, 3.820056362107226*^9}, {
   3.8200564418750143`*^9, 3.820056445236456*^9}, {3.8200566651936016`*^9, 
   3.82005666995944*^9}, {3.82005683541671*^9, 3.8200568426047497`*^9}, {
   3.8200569148411465`*^9, 3.8200569187159576`*^9}, {3.8200576480949025`*^9, 
   3.8200576525954447`*^9}, {3.8200577181748033`*^9, 3.82005772237831*^9}, 
   3.82005811817017*^9, {3.820058236688803*^9, 3.820058250735798*^9}, {
   3.820058291080635*^9, 3.8200583913957767`*^9}, 3.820058445522588*^9, {
   3.820058495226585*^9, 3.820058563400487*^9}, 3.8200585991980486`*^9, 
   3.8200604785017767`*^9, {3.820061561148429*^9, 3.820061588446191*^9}, {
   3.8200619451266384`*^9, 3.820061998987447*^9}, {3.82006206333267*^9, 
   3.8200620680517855`*^9}, {3.8200621078493695`*^9, 3.8200621251466446`*^9}, 
   3.820062156631979*^9, 3.820064134070442*^9, 3.820064204134853*^9, 
   3.8200642546515055`*^9, 3.820064353091584*^9, 3.8200646659895945`*^9, 
   3.8200646984745145`*^9, {3.8201189732667847`*^9, 3.820118996610676*^9}, {
   3.820119037236658*^9, 3.8201190694873476`*^9}, 3.820119100160022*^9, 
   3.820119147957828*^9, 3.8201200030549316`*^9, 3.8201206124903493`*^9, 
   3.8201215523238897`*^9, {3.8201216219816947`*^9, 3.8201216428727913`*^9}, {
   3.8201217701722775`*^9, 3.820121792282099*^9}, 3.820121827548588*^9, {
   3.8201225657055206`*^9, 3.820122593768653*^9}, 3.820122658067294*^9, 
   3.8201296077376413`*^9, 3.8201298657277527`*^9, 3.8201303131438885`*^9, 
   3.820130381832966*^9, 3.8201304602877893`*^9, 3.820131023987869*^9, {
   3.8201321770293074`*^9, 3.8201322036077414`*^9}, 3.820134832041106*^9, 
   3.820135033045619*^9, 3.820135262316334*^9, 3.8201353732876253`*^9, {
   3.820135423335641*^9, 3.82013544607056*^9}, 3.8201357668900275`*^9, 
   3.8201510329380713`*^9, 3.820151114925419*^9, 3.8201511645053463`*^9, 
   3.8201622122677565`*^9, 3.8201670668113933`*^9, 3.820167140688099*^9, 
   3.820167171469884*^9, 3.82016727364421*^9, 3.82016773553034*^9, 
   3.820167942738846*^9, 3.8202119409176702`*^9, 3.82021208847005*^9, 
   3.8202130590396013`*^9, 3.8202307422029514`*^9, 3.8202308257519827`*^9, 
   3.820230893097254*^9, 3.82023104722608*^9, 3.820299843334727*^9, 
   3.8203067176971016`*^9, 3.8208378961589165`*^9, 3.8209090822793455`*^9, 
   3.8211611986987176`*^9, 3.8211843363570194`*^9, 3.821184672475021*^9, 
   3.8211847489927006`*^9, 3.821185120752877*^9, 3.821366937348381*^9, 
   3.8213691343989253`*^9, {3.821369320107292*^9, 3.8213693437330327`*^9}, 
   3.8213695422388234`*^9, 3.821370411420536*^9, 3.821375188854477*^9, 
   3.821375220496245*^9, 3.8214207518956933`*^9, 3.821420917679205*^9, 
   3.8215083696925087`*^9, 3.824647333954855*^9, 3.824651822687707*^9, 
   3.824652066605934*^9, 3.824800631816676*^9, 3.8248131986917515`*^9, 
   3.824874856364473*^9, 3.824875663963858*^9, 3.8248792346596556`*^9, 
   3.824956555291683*^9, 3.8249613982667265`*^9, 3.8251523515814443`*^9, 
   3.825488988153932*^9, 3.8254891966410885`*^9, 3.8254896969909773`*^9, 
   3.825497869571092*^9, 3.826946522606511*^9, 3.8269467669746*^9, 
   3.826946971872362*^9, 3.826947600507951*^9, 3.826948787507573*^9, 
   3.826949493727154*^9, 3.8269495255761538`*^9, 3.826949967260831*^9, 
   3.826966244056444*^9, 3.8278401193528457`*^9, 3.828176455826277*^9, 
   3.8281853555182667`*^9, 3.828187523489827*^9, 3.8286141710879383`*^9, 
   3.8286143664487286`*^9, 3.82868742091866*^9, 3.830597252292592*^9, 
   3.8316059301747427`*^9, 3.8316230288592486`*^9, 3.8321458806038294`*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"c3bd5c04-839c-4fdd-8ac8-19b214883c86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "  ", 
  RowBox[{
   RowBox[{"Plot", "[", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"box", "[", 
       RowBox[{"x", ",", "0.0", ",", "0.5"}], "]"}], "}"}], ",", 
     "                      ", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<2\[Theta] (\[Degree])\>\"", ",", "\"\<normalized intensity\>\"", 
        ",", "\"\<box (hat) function\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"LineLegend", "[", 
         RowBox[{"{", "\"\<fwhm = 0.5 \[Degree]2\[Theta]\>\"", "}"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0.45", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                          ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "  ", 
   RowBox[{"Plot", "[", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"halfbox", "[", 
       RowBox[{"x", ",", "0.0", ",", "0.25"}], "]"}], "}"}], ",", 
     "                      ", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<2\[Theta] (\[Degree])\>\"", ",", "\"\<normalized intensity\>\"", 
        ",", "\"\<half box (hat) function\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"LineLegend", "[", 
         RowBox[{"{", "\"\<fwhm = 0.25 \[Degree]2\[Theta]\>\"", "}"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0.45", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                          ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tubetail", "[", 
       RowBox[{"x", ",", "0", ",", "0.3", ",", 
        RowBox[{"-", "1"}], ",", "1.5", ",", "0.3"}], "]"}], "}"}], ",", 
     "                      ", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<2\[Theta] (\[Degree])\>\"", ",", "\"\<normalized intensity\>\"", 
        ",", "\"\<tube tail function\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"LineLegend", "[", 
         RowBox[{"{", "\"\<tubetails\>\"", "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.45", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                          ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
   " ", 
   RowBox[{"Plot", "[", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "@", 
        RowBox[{"ftbox", "[", 
         RowBox[{"x", ",", "0.5"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
       "            ", 
       RowBox[{"Im", "@", 
        RowBox[{"ftbox", "[", 
         RowBox[{"x", ",", "0.5"}], "]"}]}]}], "\[IndentingNewLine]", 
      "                        ", "}"}], ",", "                      ", 
     "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "100."}], ",", "100."}], "}"}], ",", 
     "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)\>\"", ",", 
        "\"\<Fourier transform\>\"", ",", 
        "\"\<Fourier transform of box (hat) function\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"LineLegend", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<real part\>\"", ",", "\"\<imaginary part\>\""}], "}"}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.25", ",", "Top"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                          ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{"Plot", "[", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "@", 
        RowBox[{"fthalfbox", "[", 
         RowBox[{"x", ",", "0.25"}], "]"}]}], ",", " ", "\[IndentingNewLine]",
        "            ", 
       RowBox[{"Im", "@", 
        RowBox[{"fthalfbox", "[", 
         RowBox[{"x", ",", "0.25"}], "]"}]}]}], "\[IndentingNewLine]", 
      "                        ", "}"}], ",", "                      ", 
     "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"-", "100."}], ",", "100."}], "}"}], ",", 
     "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)\>\"", ",", 
        "\"\<Fourier transform\>\"", ",", 
        "\"\<Fourier transform of half box (hat) function\>\""}], "}"}]}], 
     ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"LineLegend", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<real part\>\"", ",", "\"\<imaginary part\>\""}], "}"}],
          "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.25", ",", "Top"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                          ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "   ", 
   RowBox[{"Plot", "[", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ReceivingSlitWidth", "[", 
        RowBox[{"x", ",", "0.1", ",", "217.5"}], "]"}], ",", 
       "\[IndentingNewLine]", "                         ", 
       RowBox[{"SpecimenTilt", "[", 
        RowBox[{"x", ",", "0.1", ",", "217.5"}], "]"}]}], 
      "\[IndentingNewLine]", "                        ", "}"}], ",", 
     "                      ", "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0.", ",", "180."}], "}"}], ",", 
     "\[IndentingNewLine]", 
     "                                                        ", 
     RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<2\[Theta] (\[Degree])\>\"", ",", 
        "\"\<fhwm of box function (\[Degree]2\[Theta])\>\"", ",", 
        "\"\<aberrations in the equatorial plane\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"Placed", "[", 
       RowBox[{
        RowBox[{"LineLegend", "[", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Size of source/ receiving slit width = 0.1 mm\>\"", ",", 
           "\"\<speciment tilt = 0.1 mm\>\""}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.45", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"TicksStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                          ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
     "                                                         ", 
     RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.8209090724200773`*^9, {3.820909123077384*^9, 3.8209093161455173`*^9}, {
   3.8209093761784782`*^9, 3.820909430351841*^9}, {3.8209094676029963`*^9, 
   3.820909472431177*^9}, {3.820909508604167*^9, 3.8209095641085224`*^9}, {
   3.8209099135845814`*^9, 3.820909937460065*^9}, {3.820912386091544*^9, 
   3.820912393904076*^9}, {3.8209124413741016`*^9, 3.8209127363822985`*^9}, {
   3.8209127861807146`*^9, 3.820912816322043*^9}, 3.8209128886833997`*^9, {
   3.820912985858285*^9, 3.820913012999303*^9}, 3.8209130455003195`*^9, {
   3.820913608453177*^9, 3.8209136090937896`*^9}, {3.8211666433680124`*^9, 
   3.821166648184724*^9}, {3.8211673702762623`*^9, 3.8211674249655333`*^9}, {
   3.8211674950055895`*^9, 3.8211675007252045`*^9}, {3.821167665755329*^9, 
   3.8211677940548573`*^9}, {3.821169392088668*^9, 3.8211695987468624`*^9}, {
   3.821169644979255*^9, 3.8211696491978245`*^9}, {3.821169695556106*^9, 
   3.8211697085440245`*^9}, {3.82116975986994*^9, 3.821169760432415*^9}, {
   3.8211698438609204`*^9, 3.8211699262288713`*^9}, {3.82118432140312*^9, 
   3.821184326309362*^9}, {3.821184495892169*^9, 3.8211845009394965`*^9}, {
   3.8213703609347715`*^9, 3.821370464891079*^9}, {3.821370516830041*^9, 
   3.8213705170175905`*^9}, {3.821427027374592*^9, 3.821427139327878*^9}, {
   3.823658458606786*^9, 3.823658490070077*^9}, {3.8248033346960506`*^9, 
   3.8248033639111233`*^9}, {3.8254890771553125`*^9, 3.825489134015299*^9}, {
   3.8254896281151114`*^9, 3.8254896498340464`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"174ca19a-0c44-4378-a0ae-a8e20cfe8053"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxN1WkwHAYUAOB11aIWSciIq84goiFKI02ZiASJa4fYTGIdDc0QdbRiVcaV
jWiiExFS3QqtJY7oKm0iWNbGsVri2Fh2LdYtR7Fx1JG02s7Ee3kzb95882be
m3l/nmFoNDlMlkAgpP2X/1drJ60XW1sSDuFtRG8YZ25son/51cZseRVta+4Z
OvsS7aBBH+4eQjtPvfrj+2o0+dqT+weD0Am99KjPm8fAAwMqL7gho2C9luhd
Droj4AeRbQpqo8Pg4CwbqShdBF7PScrkOAnBTNKYdv7EILjAwybu6TcCcPrF
EJqF+wA4Sa4yIW6eDw5J7TUZLO8HnxYVfTrKRHvYxlCmC9F20+pZS7looht5
mZSGZqkJuCfOoF8XDlPrldDStUpaizx62icph7fVB+6R1e0QrKKLwwP3L02g
3azHX1s2oPOaZvILItBUGiPZIQxtftD7PD8I3VD+6EOiP3rs9o2OL53QZV7O
VSRHdIzS6q0KO7RsCjVQYoHuOrTT5WsTdO4Kz1zTAL03wmbFYxdaajIrmiGh
6yUMTqoSOp3hXaojj/6ukqgV9Xfvtp3ZeeIq4Rx6PJXlcoyPtgjwi9UpQ8ft
3yxcSkLfybjl793bA26QmL9fZYReSLDbmzreDTZWdz7qV9gFrrXMjJic6gRL
2ms+sLfvAM9Y5dlyHraCNZIr7K1luGAr+0Wr0mU2+Mqx+b56Wh1Y04+VfWZ3
Le77q12t06QSXCqe+fY5vRAc6Kv7m/gzOrheOUnwOP6K07Y/mpTRT6MUgY2l
jRuOjyvA7kzREy9KLdjVc4fc6oM68M2godQDdWwwz0tP1WcHFzxvqJnMZ7SC
47/aF3JTqwM8NKJODu/sBAcnfjKneKoLnMOvfzRT3g1u3edwvVWhBxwepqhb
Wo4mFg39nHGyFyxq5FxaK0BXCsucLiygXUfaKHfW0dJF6cehMn3bJjTFprgm
voe+vqxKzlZBB8QXUMvU0SZrlpHNmujmzRP0Pw3QNy4PZsuZoin/nL+7xxK9
JJP+0M0ObabEflbi9k6fZx1R7PnO/IyfXhaR0aflry0wzqGvbvmuZMegp1fn
ti7no4snd+72f4bWY0e6KmT2gwmbshVxk3zwmm8Ttd10ACy2C9IxpQvAMQHq
GkYjg2Dt3GmKvJ4QzDr7Y9kyTYT3O5Li1tk0DK6hRhk5vhGD15Vd5Or9R8Hk
/sP2evljYOXDKlz2XTS3ZPjkOSb6AC0x5AcWmmRQl6Xdjv79ou2U5hLamWiR
TTolwf2x63tYvuhqMa/UMwCtXx3emBWKfuNfMquciK5jGhxRvIf+QnWRd+8+
2iyhmXy8Bp3rEXjhKhsd94pxW+4p2vJshD5TiJ5oO1RxdAztky9sTnuOJsqW
uxsuojmRCQMtK+hLguNBwZvot/8f/C8eEDbD
         "]]},
       Annotation[#, "Charting`Private`Tag$47365#1"]& ]}, {}}, InsetBox[
     TemplateBox[{"\"fwhm = 0.5 \[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0.368417, 0.506779, 0.709798], Editable -> False, 
                  Selectable -> False], ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.01}], ImageScaled[{0.5, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"box (hat) function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-0.5, 0.5}, {0., 2.}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxN1WkwHAYUAOB11aIWSciIq84goiFKI02ZiASJa4fYTGIdDc0QdbRiVcaV
jWiiExFS3QqtJY7oKm0iWNbGsVri2Fh2LdYtR7Fx1JG02s7Ee3kzb95882be
m3l/nmFoNDlMlkAgpP2X/1drJ60XW1sSDuFtRG8YZ25son/51cZseRVta+4Z
OvsS7aBBH+4eQjtPvfrj+2o0+dqT+weD0Am99KjPm8fAAwMqL7gho2C9luhd
Droj4AeRbQpqo8Pg4CwbqShdBF7PScrkOAnBTNKYdv7EILjAwybu6TcCcPrF
EJqF+wA4Sa4yIW6eDw5J7TUZLO8HnxYVfTrKRHvYxlCmC9F20+pZS7looht5
mZSGZqkJuCfOoF8XDlPrldDStUpaizx62icph7fVB+6R1e0QrKKLwwP3L02g
3azHX1s2oPOaZvILItBUGiPZIQxtftD7PD8I3VD+6EOiP3rs9o2OL53QZV7O
VSRHdIzS6q0KO7RsCjVQYoHuOrTT5WsTdO4Kz1zTAL03wmbFYxdaajIrmiGh
6yUMTqoSOp3hXaojj/6ukqgV9Xfvtp3ZeeIq4Rx6PJXlcoyPtgjwi9UpQ8ft
3yxcSkLfybjl793bA26QmL9fZYReSLDbmzreDTZWdz7qV9gFrrXMjJic6gRL
2ms+sLfvAM9Y5dlyHraCNZIr7K1luGAr+0Wr0mU2+Mqx+b56Wh1Y04+VfWZ3
Le77q12t06QSXCqe+fY5vRAc6Kv7m/gzOrheOUnwOP6K07Y/mpTRT6MUgY2l
jRuOjyvA7kzREy9KLdjVc4fc6oM68M2godQDdWwwz0tP1WcHFzxvqJnMZ7SC
47/aF3JTqwM8NKJODu/sBAcnfjKneKoLnMOvfzRT3g1u3edwvVWhBxwepqhb
Wo4mFg39nHGyFyxq5FxaK0BXCsucLiygXUfaKHfW0dJF6cehMn3bJjTFprgm
voe+vqxKzlZBB8QXUMvU0SZrlpHNmujmzRP0Pw3QNy4PZsuZoin/nL+7xxK9
JJP+0M0ObabEflbi9k6fZx1R7PnO/IyfXhaR0aflry0wzqGvbvmuZMegp1fn
ti7no4snd+72f4bWY0e6KmT2gwmbshVxk3zwmm8Ttd10ACy2C9IxpQvAMQHq
GkYjg2Dt3GmKvJ4QzDr7Y9kyTYT3O5Li1tk0DK6hRhk5vhGD15Vd5Or9R8Hk
/sP2evljYOXDKlz2XTS3ZPjkOSb6AC0x5AcWmmRQl6Xdjv79ou2U5hLamWiR
TTolwf2x63tYvuhqMa/UMwCtXx3emBWKfuNfMquciK5jGhxRvIf+QnWRd+8+
2iyhmXy8Bp3rEXjhKhsd94pxW+4p2vJshD5TiJ5oO1RxdAztky9sTnuOJsqW
uxsuojmRCQMtK+hLguNBwZvot/8f/C8eEDbD
           "]]}, "Charting`Private`Tag$47365#1"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity", None}, {
        "2\[Theta] (\[Degree])", "box (hat) function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {{-0.5, 0.5}, {0., 2.}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {"fwhm = 0.5 \[Degree]2\[Theta]"}, LegendMarkers -> 
       None, LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.45, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.820909075607528*^9, 3.8209090824513116`*^9}, {
   3.8209091919230733`*^9, 3.8209092147987614`*^9}, 3.820909284707246*^9, 
   3.820909317317361*^9, 3.820909400523015*^9, 3.8209094313361864`*^9, 
   3.8209094744936914`*^9, 3.8209095657779527`*^9, 3.8209099385226974`*^9, 
   3.820912472297239*^9, {3.8209125581430645`*^9, 3.8209125735968084`*^9}, {
   3.8209126055661416`*^9, 3.8209126282701006`*^9}, 3.820912664396261*^9, 
   3.8209127038501472`*^9, 3.820912737288566*^9, 3.820912849072829*^9, {
   3.8209130171400003`*^9, 3.8209130458755035`*^9}, 3.821161199162278*^9, 
   3.821167426392152*^9, {3.8211676669593077`*^9, 3.821167691054671*^9}, {
   3.821167742497898*^9, 3.8211677746052523`*^9}, {3.821169469778968*^9, 
   3.821169490153081*^9}, {3.821169577933821*^9, 3.8211695995905294`*^9}, 
   3.82116971862167*^9, 3.8211697661741605`*^9, {3.821169885290314*^9, 
   3.8211699274944086`*^9}, 3.8211843365440636`*^9, 3.8211846726626654`*^9, 
   3.821184749164697*^9, 3.8211851209873743`*^9, 3.8213669375515127`*^9, 
   3.821369134601821*^9, {3.821369320435778*^9, 3.8213693439205985`*^9}, 
   3.8213695425825663`*^9, {3.8213704041859355`*^9, 3.8213704116549015`*^9}, 
   3.8213704662033987`*^9, 3.821375189260708*^9, 3.8213752208709993`*^9, 
   3.821420752374871*^9, 3.8214209178640947`*^9, 3.821427074724353*^9, 
   3.821427109605117*^9, 3.8214271405787616`*^9, 3.82150836992704*^9, 
   3.824647334173438*^9, 3.824651822844209*^9, 3.824652067434126*^9, 
   3.8248006323011227`*^9, 3.824813198941621*^9, 3.8248748568813906`*^9, 
   3.8248756641422606`*^9, 3.824956555557131*^9, 3.824961398469942*^9, 
   3.8251523518000298`*^9, 3.8254889884044204`*^9, 3.825489196828559*^9, 
   3.8254896971942825`*^9, 3.826946523411081*^9, 3.82694676716206*^9, 
   3.8269469720594745`*^9, 3.8269476008924627`*^9, 3.8269487877262793`*^9, 
   3.8269499674482727`*^9, 3.82696624427526*^9, 3.8278401195963397`*^9, 
   3.8281764562050853`*^9, 3.828187523682723*^9, 3.828614171322327*^9, 
   3.8286143666516438`*^9, 3.8286874211686726`*^9, 3.8305972525893993`*^9, 
   3.831605930643487*^9, 3.8316230290780125`*^9, 3.8321458808382053`*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"8c8dd7bd-7336-4756-98d4-f5083e3ced58"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxN1nkwHGYUAHBHlDqXBhX3WZYoogRVkiJEXNsoqThTxywp2TqHccdVSRRR
cUQaxJGUICFq2QgbK+Je5zomhMjhptjJ0Haavpdv5s03v3kz35v3vu+PT9En
mOTLxcHBkfpP/Ltrm0m8OTiYpXF8WMF7yml7bPT9Bl21zW20nrqdz+JbtKFo
8uTzMbT5/PqzG7VoUmrv3WOe6Ij+5Iv+bTNgJlPgTbv3NFj2cfBhQ5kp8MPA
Th6R6UmwV6bu2kTiBHg3OzqNZjYOLhWekcp/MQouOq1LGU4fAScGeUdq2DDB
0dzVEZTlIbB3fL/KaOUg+HrrQn4ReQD856y64D2lPrAywfzk2Zs94HpiGnlu
ngGepdcpGBg8BS9oXdejNXaARWOrDLQ528FaBqta5ZtUcJLF8kBzZBNY/GxN
1jnJeqz3F12EoVINLmctXHmdfBM8GSNRUnwMLSx36r7TXDE43KtyqNkMbbVA
lsxgF4KXVlZvEUNugIlc7IZAt1ywRymRLs+PzrZwGx1+lANmp1B3TSTQPQJx
poKDv4LHiXxXz125CnZ3knnAupAMfre5bRTWmQSOyeunCauii1iJPScWE8AP
eoboDoOx4NqtIOWlyVBwn5HCl9JFP4NXYoeN7d0pYFex0LIAWjD4OxNhLs5u
X+yPHirlb3sBPODA0unt9QIXMhxpeuUu4M+nZVf2q0hgzfkRozx3W7CaYMhv
2v4nwPFMdaZ0x1F8DyLTZJ6jh83+E8F8dD2xhLB7HLzm8MVGMMUKHJ1j9SxQ
3xEcT74XNEz8AdyhkJ5aTPABM3ZWNHh4g8D+/kS/xn0KOOibLD657RhwM3/0
yJOwJHB3g6dFXXou+Ks5TrkE1xKw8lrLnvGTKrBN6USvvWs92NJOjHv7YRP4
mudYvE4TFdxlLyvkKNYOXlYUjx0q6ACHhWp6X5N4Ch6bIpD8GAywV9TXr3jP
9ICzh5ofLVQ+x3loGmZ08PSB/Xx5Zcor0XwlY3+k2PaDJ1po4TtF6OrxCrOA
FbTlVKdr3i56bXXtuA/ngNn/99l6Kc4y6hN0xqYQKUsA7RJW5FFBQKvsEAPb
xNFt7FPJ7+TRv8SMZnGrol33fyw+QkRvcCY2Wuuj1T6lLpVZf5Tv0ibftvvo
/JTf35aQ0N8fSl0pOI++fOC0lRWCfrn96iAmH3177jNJ5yW0LDXQkidtEMzB
5qqizA2Bd5xaPeiqTDBL31NaNXkEHOJCEFWaGgVL5b50PSQ7Dq5xu1WxGTmB
8zONs2a0ToLrPC4qGb9ngXf5v+Vudp4GkwZNDGTzZ8D8JgLt1GJ0e9mk7flS
tE5klHdhDVpYvilTio7uDtKbF99Am/NpZAmfmcX6l3aP1Diha1ld5XYuaLla
v5ZMH/R757JF/ih0U6m8Ke8d9E9Cq1137qLVItpIVnXo3NPuAZepaMp6QQ73
MJroRpYrHUe/6DSqOjmDdswfb0t4jebjqrRRXEXTAiOYj7fQ4SNWnl5s9If/
BfhvFx4+0w==
         "]]},
       Annotation[#, "Charting`Private`Tag$47434#1"]& ]}, {}}, InsetBox[
     TemplateBox[{"\"fwhm = 0.25 \[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0.368417, 0.506779, 0.709798], Editable -> False, 
                  Selectable -> False], ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.01}], ImageScaled[{0.5, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"half box (hat) function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-0.5, 0.5}, {0., 4.}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxN1nkwHGYUAHBHlDqXBhX3WZYoogRVkiJEXNsoqThTxywp2TqHccdVSRRR
cUQaxJGUICFq2QgbK+Je5zomhMjhptjJ0Haavpdv5s03v3kz35v3vu+PT9En
mOTLxcHBkfpP/Ltrm0m8OTiYpXF8WMF7yml7bPT9Bl21zW20nrqdz+JbtKFo
8uTzMbT5/PqzG7VoUmrv3WOe6Ij+5Iv+bTNgJlPgTbv3NFj2cfBhQ5kp8MPA
Th6R6UmwV6bu2kTiBHg3OzqNZjYOLhWekcp/MQouOq1LGU4fAScGeUdq2DDB
0dzVEZTlIbB3fL/KaOUg+HrrQn4ReQD856y64D2lPrAywfzk2Zs94HpiGnlu
ngGepdcpGBg8BS9oXdejNXaARWOrDLQ528FaBqta5ZtUcJLF8kBzZBNY/GxN
1jnJeqz3F12EoVINLmctXHmdfBM8GSNRUnwMLSx36r7TXDE43KtyqNkMbbVA
lsxgF4KXVlZvEUNugIlc7IZAt1ywRymRLs+PzrZwGx1+lANmp1B3TSTQPQJx
poKDv4LHiXxXz125CnZ3knnAupAMfre5bRTWmQSOyeunCauii1iJPScWE8AP
eoboDoOx4NqtIOWlyVBwn5HCl9JFP4NXYoeN7d0pYFex0LIAWjD4OxNhLs5u
X+yPHirlb3sBPODA0unt9QIXMhxpeuUu4M+nZVf2q0hgzfkRozx3W7CaYMhv
2v4nwPFMdaZ0x1F8DyLTZJ6jh83+E8F8dD2xhLB7HLzm8MVGMMUKHJ1j9SxQ
3xEcT74XNEz8AdyhkJ5aTPABM3ZWNHh4g8D+/kS/xn0KOOibLD657RhwM3/0
yJOwJHB3g6dFXXou+Ks5TrkE1xKw8lrLnvGTKrBN6USvvWs92NJOjHv7YRP4
mudYvE4TFdxlLyvkKNYOXlYUjx0q6ACHhWp6X5N4Ch6bIpD8GAywV9TXr3jP
9ICzh5ofLVQ+x3loGmZ08PSB/Xx5Zcor0XwlY3+k2PaDJ1po4TtF6OrxCrOA
FbTlVKdr3i56bXXtuA/ngNn/99l6Kc4y6hN0xqYQKUsA7RJW5FFBQKvsEAPb
xNFt7FPJ7+TRv8SMZnGrol33fyw+QkRvcCY2Wuuj1T6lLpVZf5Tv0ibftvvo
/JTf35aQ0N8fSl0pOI++fOC0lRWCfrn96iAmH3177jNJ5yW0LDXQkidtEMzB
5qqizA2Bd5xaPeiqTDBL31NaNXkEHOJCEFWaGgVL5b50PSQ7Dq5xu1WxGTmB
8zONs2a0ToLrPC4qGb9ngXf5v+Vudp4GkwZNDGTzZ8D8JgLt1GJ0e9mk7flS
tE5klHdhDVpYvilTio7uDtKbF99Am/NpZAmfmcX6l3aP1Diha1ld5XYuaLla
v5ZMH/R757JF/ih0U6m8Ke8d9E9Cq1137qLVItpIVnXo3NPuAZepaMp6QQ73
MJroRpYrHUe/6DSqOjmDdswfb0t4jebjqrRRXEXTAiOYj7fQ4SNWnl5s9If/
BfhvFx4+0w==
           "]]}, "Charting`Private`Tag$47434#1"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity", None}, {
        "2\[Theta] (\[Degree])", "half box (hat) function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {{-0.5, 0.5}, {0., 4.}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {"fwhm = 0.25 \[Degree]2\[Theta]"}, 
       LegendMarkers -> None, LabelStyle -> Directive[Bold, 16], LegendLayout -> 
       "Column"]], {0.45, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.820909075607528*^9, 3.8209090824513116`*^9}, {
   3.8209091919230733`*^9, 3.8209092147987614`*^9}, 3.820909284707246*^9, 
   3.820909317317361*^9, 3.820909400523015*^9, 3.8209094313361864`*^9, 
   3.8209094744936914`*^9, 3.8209095657779527`*^9, 3.8209099385226974`*^9, 
   3.820912472297239*^9, {3.8209125581430645`*^9, 3.8209125735968084`*^9}, {
   3.8209126055661416`*^9, 3.8209126282701006`*^9}, 3.820912664396261*^9, 
   3.8209127038501472`*^9, 3.820912737288566*^9, 3.820912849072829*^9, {
   3.8209130171400003`*^9, 3.8209130458755035`*^9}, 3.821161199162278*^9, 
   3.821167426392152*^9, {3.8211676669593077`*^9, 3.821167691054671*^9}, {
   3.821167742497898*^9, 3.8211677746052523`*^9}, {3.821169469778968*^9, 
   3.821169490153081*^9}, {3.821169577933821*^9, 3.8211695995905294`*^9}, 
   3.82116971862167*^9, 3.8211697661741605`*^9, {3.821169885290314*^9, 
   3.8211699274944086`*^9}, 3.8211843365440636`*^9, 3.8211846726626654`*^9, 
   3.821184749164697*^9, 3.8211851209873743`*^9, 3.8213669375515127`*^9, 
   3.821369134601821*^9, {3.821369320435778*^9, 3.8213693439205985`*^9}, 
   3.8213695425825663`*^9, {3.8213704041859355`*^9, 3.8213704116549015`*^9}, 
   3.8213704662033987`*^9, 3.821375189260708*^9, 3.8213752208709993`*^9, 
   3.821420752374871*^9, 3.8214209178640947`*^9, 3.821427074724353*^9, 
   3.821427109605117*^9, 3.8214271405787616`*^9, 3.82150836992704*^9, 
   3.824647334173438*^9, 3.824651822844209*^9, 3.824652067434126*^9, 
   3.8248006323011227`*^9, 3.824813198941621*^9, 3.8248748568813906`*^9, 
   3.8248756641422606`*^9, 3.824956555557131*^9, 3.824961398469942*^9, 
   3.8251523518000298`*^9, 3.8254889884044204`*^9, 3.825489196828559*^9, 
   3.8254896971942825`*^9, 3.826946523411081*^9, 3.82694676716206*^9, 
   3.8269469720594745`*^9, 3.8269476008924627`*^9, 3.8269487877262793`*^9, 
   3.8269499674482727`*^9, 3.82696624427526*^9, 3.8278401195963397`*^9, 
   3.8281764562050853`*^9, 3.828187523682723*^9, 3.828614171322327*^9, 
   3.8286143666516438`*^9, 3.8286874211686726`*^9, 3.8305972525893993`*^9, 
   3.831605930643487*^9, 3.8316230290780125`*^9, 3.8321458809475613`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"b4f30b77-c24c-43f0-be44-85bedf64304f"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxN1ns0FHgUB/AxYdEobZRZieSoCCFTNDIltLuRR2g5W16zTZMiWpVXlEes
7eEZsWWUR7TatoitITPeeWzWoIn08ErJMIPRZLbOqXv7nfs793zO75/v/eN3
zl3lG+hCJxIIhOsf76ceOewwKZUuqCF8PkPhy0R8CdpR5dlMhRitbRH0IXAK
XZuUojAwhFYw6l5Z04pOO+b9Y/RldIlMyDXCJrQc3d6U/DMRvLSnLoB1UQbs
wsn2W9dMAIe/swq48FJa/cX3jmczy3bPgx1T3LTnsyRg+9wHjjvfzIELGk7y
QrzE4H2xaWrtRTPgKO8Ffy5cOg0mGGpV28QJwU9+y0oo6ZoEd9Zpl3q3ox9J
CzvUmtDskHJy9H00y6uzZE8+mmmg3PEhCP2+OVrdiYQWyipYycmjx7ee96mS
CsADt3Nv6E6hudlVVHEvOpkp9GYVolcoMYqF29H72I+SdajovGCTICdztB5/
jlK6Bm1c+jvXj4Te7vj3s8ddE+BYojqH0I5uKI8oMGpE79KyO5xUhXaf6Jnb
dgV9MGVe7S8GutTOT9zvgx6fa3hK8kIH+13MZzig7yyfjs+wQ8+0eDK51uiI
jbom2qZo9shZVUcDtEzu25lwXfQOZxd+sSY6Xq6C3b0M3VipwZJTQSsdiY4z
U/xqXp1Bhg8RvfJm6qWVM++q1fYLPlad9Q5Bf5skEX3IXF+OvwJ9gCLrsTvo
LdhvU38RhzMG1j9hKT1ybQSc1+fKPbltEDwco0a1V38Brkpfazvi3gfeMNor
NM7l4fu/nqeWhXViviq+4gf3DnBtjIhEs28FS86ZyccPNIGz0h8T1xk2gik5
R6UtJ+vBsVoPIzWv1oE7WSqSI/VccJj/5n8yf0Lr6HmH1bzhgKflhb17ytFN
wwkWo6fQOY0aWZHfo4OKy2aXLOVU1yjmfCwCTf7M7FW74Eqw+y+r8x5HFIMn
LmX5C7JcwA2PepPMXIusv5hhE3yT//o2OODq8XTN0krwuGNYIpv0AHwvis0u
o9SA9+pXv+9e9BAs7qreTBhGNxvQPFRda8HZMTW/rq1Gny4lxJmK0MxuWhrV
gAN2Icbk2/lwrFU/z29p+PC2Uyb6CinUXHmwCUwMVXvqT+4Af0NyivEd54HP
DPBsgvP7wLcuxztFTT4HB7L8VV65D4L3MbM1E2JGwInOoRZmOWNgWdX0oVNz
4+DulriJ2MUCsFu4LyWbMwkOWDim0+YpBGuV1GfIvxaBW03kREm10+Dwezau
iy/PgD3tQ5uc76AteUXWaa3oG5q1YeZP0GQ6/y5vCN2hwHBd8xZ9tlQ4cXwK
TXOKOdcoRs9OKa8nE2atv/z3W5nZTQfl0Ywtaw5UkdA9p2ksLzK6YkmI+h+m
6FDjHtnVdLRRpz8r5BB6KFRgzT2KdmMrhdOj0BsdrASFmegpJqtvfTM6qCCg
nGIsBve3a6QvoqAdxM0hQ1S0/q51Jhk/oF8JBktEdLSH1f68Oznorf85J5sq
zYFJxE2+RoNo28N70vVTJWD1Ss1AW915cErw2YsbuqVgl/jdhrnlBBrk8Yp1
uxYpA+YNKbJS3YjgNt/Bbd9qLQA/ly2cTddBCwsYZWQ9NHlsbMUqQ7R/yOSM
8Rb03BnpTQcPtN518neJ59EW9vwOUip612hOwoUM9FFDbVFmLvr+Xb2OghK0
S71ZPLcBTWeIqDtb0CeUKqZa2tC5jpY+nV3oER6N+uLlV3lPEKfow2hlDW7x
6Gu06X775QIB2lZGse2YCL03vzl2dhbNtE3eEiFBf94fwf8DwcqXSA==
         "]]},
       Annotation[#, "Charting`Private`Tag$47503#1"]& ]}, {}}, InsetBox[
     TemplateBox[{"\"tubetails\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0.368417, 0.506779, 0.709798], Editable -> False, 
                  Selectable -> False], ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], "}"}], 
           ",", 
           RowBox[{"{", #, "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.01}], ImageScaled[{0.5, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"tube tail function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-2.5, 2.5}, {0., 2.076190476190476}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxN1ns0FHgUB/AxYdEobZRZieSoCCFTNDIltLuRR2g5W16zTZMiWpVXlEes
7eEZsWWUR7TatoitITPeeWzWoIn08ErJMIPRZLbOqXv7nfs793zO75/v/eN3
zl3lG+hCJxIIhOsf76ceOewwKZUuqCF8PkPhy0R8CdpR5dlMhRitbRH0IXAK
XZuUojAwhFYw6l5Z04pOO+b9Y/RldIlMyDXCJrQc3d6U/DMRvLSnLoB1UQbs
wsn2W9dMAIe/swq48FJa/cX3jmczy3bPgx1T3LTnsyRg+9wHjjvfzIELGk7y
QrzE4H2xaWrtRTPgKO8Ffy5cOg0mGGpV28QJwU9+y0oo6ZoEd9Zpl3q3ox9J
CzvUmtDskHJy9H00y6uzZE8+mmmg3PEhCP2+OVrdiYQWyipYycmjx7ee96mS
CsADt3Nv6E6hudlVVHEvOpkp9GYVolcoMYqF29H72I+SdajovGCTICdztB5/
jlK6Bm1c+jvXj4Te7vj3s8ddE+BYojqH0I5uKI8oMGpE79KyO5xUhXaf6Jnb
dgV9MGVe7S8GutTOT9zvgx6fa3hK8kIH+13MZzig7yyfjs+wQ8+0eDK51uiI
jbom2qZo9shZVUcDtEzu25lwXfQOZxd+sSY6Xq6C3b0M3VipwZJTQSsdiY4z
U/xqXp1Bhg8RvfJm6qWVM++q1fYLPlad9Q5Bf5skEX3IXF+OvwJ9gCLrsTvo
LdhvU38RhzMG1j9hKT1ybQSc1+fKPbltEDwco0a1V38Brkpfazvi3gfeMNor
NM7l4fu/nqeWhXViviq+4gf3DnBtjIhEs28FS86ZyccPNIGz0h8T1xk2gik5
R6UtJ+vBsVoPIzWv1oE7WSqSI/VccJj/5n8yf0Lr6HmH1bzhgKflhb17ytFN
wwkWo6fQOY0aWZHfo4OKy2aXLOVU1yjmfCwCTf7M7FW74Eqw+y+r8x5HFIMn
LmX5C7JcwA2PepPMXIusv5hhE3yT//o2OODq8XTN0krwuGNYIpv0AHwvis0u
o9SA9+pXv+9e9BAs7qreTBhGNxvQPFRda8HZMTW/rq1Gny4lxJmK0MxuWhrV
gAN2Icbk2/lwrFU/z29p+PC2Uyb6CinUXHmwCUwMVXvqT+4Af0NyivEd54HP
DPBsgvP7wLcuxztFTT4HB7L8VV65D4L3MbM1E2JGwInOoRZmOWNgWdX0oVNz
4+DulriJ2MUCsFu4LyWbMwkOWDim0+YpBGuV1GfIvxaBW03kREm10+Dwezau
iy/PgD3tQ5uc76AteUXWaa3oG5q1YeZP0GQ6/y5vCN2hwHBd8xZ9tlQ4cXwK
TXOKOdcoRs9OKa8nE2atv/z3W5nZTQfl0Ywtaw5UkdA9p2ksLzK6YkmI+h+m
6FDjHtnVdLRRpz8r5BB6KFRgzT2KdmMrhdOj0BsdrASFmegpJqtvfTM6qCCg
nGIsBve3a6QvoqAdxM0hQ1S0/q51Jhk/oF8JBktEdLSH1f68Oznorf85J5sq
zYFJxE2+RoNo28N70vVTJWD1Ss1AW915cErw2YsbuqVgl/jdhrnlBBrk8Yp1
uxYpA+YNKbJS3YjgNt/Bbd9qLQA/ly2cTddBCwsYZWQ9NHlsbMUqQ7R/yOSM
8Rb03BnpTQcPtN518neJ59EW9vwOUip612hOwoUM9FFDbVFmLvr+Xb2OghK0
S71ZPLcBTWeIqDtb0CeUKqZa2tC5jpY+nV3oER6N+uLlV3lPEKfow2hlDW7x
6Gu06X775QIB2lZGse2YCL03vzl2dhbNtE3eEiFBf94fwf8DwcqXSA==
           "]]}, "Charting`Private`Tag$47503#1"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity", None}, {
        "2\[Theta] (\[Degree])", "tube tail function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-2.5, 2.5}, {0., 2.076190476190476}}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {"tubetails"}, LegendMarkers -> None, LabelStyle -> 
       Directive[Bold, 16], LegendLayout -> "Column"]], {0.45, Bottom}, 
     Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.820909075607528*^9, 3.8209090824513116`*^9}, {
   3.8209091919230733`*^9, 3.8209092147987614`*^9}, 3.820909284707246*^9, 
   3.820909317317361*^9, 3.820909400523015*^9, 3.8209094313361864`*^9, 
   3.8209094744936914`*^9, 3.8209095657779527`*^9, 3.8209099385226974`*^9, 
   3.820912472297239*^9, {3.8209125581430645`*^9, 3.8209125735968084`*^9}, {
   3.8209126055661416`*^9, 3.8209126282701006`*^9}, 3.820912664396261*^9, 
   3.8209127038501472`*^9, 3.820912737288566*^9, 3.820912849072829*^9, {
   3.8209130171400003`*^9, 3.8209130458755035`*^9}, 3.821161199162278*^9, 
   3.821167426392152*^9, {3.8211676669593077`*^9, 3.821167691054671*^9}, {
   3.821167742497898*^9, 3.8211677746052523`*^9}, {3.821169469778968*^9, 
   3.821169490153081*^9}, {3.821169577933821*^9, 3.8211695995905294`*^9}, 
   3.82116971862167*^9, 3.8211697661741605`*^9, {3.821169885290314*^9, 
   3.8211699274944086`*^9}, 3.8211843365440636`*^9, 3.8211846726626654`*^9, 
   3.821184749164697*^9, 3.8211851209873743`*^9, 3.8213669375515127`*^9, 
   3.821369134601821*^9, {3.821369320435778*^9, 3.8213693439205985`*^9}, 
   3.8213695425825663`*^9, {3.8213704041859355`*^9, 3.8213704116549015`*^9}, 
   3.8213704662033987`*^9, 3.821375189260708*^9, 3.8213752208709993`*^9, 
   3.821420752374871*^9, 3.8214209178640947`*^9, 3.821427074724353*^9, 
   3.821427109605117*^9, 3.8214271405787616`*^9, 3.82150836992704*^9, 
   3.824647334173438*^9, 3.824651822844209*^9, 3.824652067434126*^9, 
   3.8248006323011227`*^9, 3.824813198941621*^9, 3.8248748568813906`*^9, 
   3.8248756641422606`*^9, 3.824956555557131*^9, 3.824961398469942*^9, 
   3.8251523518000298`*^9, 3.8254889884044204`*^9, 3.825489196828559*^9, 
   3.8254896971942825`*^9, 3.826946523411081*^9, 3.82694676716206*^9, 
   3.8269469720594745`*^9, 3.8269476008924627`*^9, 3.8269487877262793`*^9, 
   3.8269499674482727`*^9, 3.82696624427526*^9, 3.8278401195963397`*^9, 
   3.8281764562050853`*^9, 3.828187523682723*^9, 3.828614171322327*^9, 
   3.8286143666516438`*^9, 3.8286874211686726`*^9, 3.8305972525893993`*^9, 
   3.831605930643487*^9, 3.8316230290780125`*^9, 3.8321458810413074`*^9},
 CellLabel->
  "Out[176]=",ExpressionUUID->"744ae281-6a96-4d89-961f-7530a329b7df"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3c81d8bJxTpi5AKISl773k+xrW3a0WSZKVUVlSUhJCRmZXsvUfmOcm+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         "]]},
       Annotation[#, "Charting`Private`Tag$47573#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxF1GtIEwAQAOBplppWYkPdQmJkJjXBLIeabM0Hczkfm7pM1OazadrwgRm+
mgyRKahMrLDFKp9Y9kJEErUp/dFNcbpKLR+5kQW6luZsPirQu4Pj+H4cd/fn
KCkiXrolgUAI/5f/a0LywsrubtwgYS/myAlGxy10yqR2/bQJLWSNboUZ0Pme
PYfvz6OlmzXuXu/QvfW+SYIKtJOyVjVohWbRP5VdX+ODSREb1na/Y8EeBeK+
N1sx4K7u1iD/lWjwlFTxRPWTh/sU+0zS57ngiAra+eeaKHCDn8to1OtI8J2W
zWlLWThY4St5oL4XBg406bsaWtngiZXyTKdqFrjZXql5JQsBpyb7f7XJCwLL
F6Xs+Hgm+IKT7YBURQfbTAl9Ptb7gwWLZLtrj2i4b6LfOS7fG1yS6mAsDqaC
te08Tl+2G1gtmynUfnAG/2Jks61ndwf2bWDU5RCEO4x9VxblzrmVulzed4WG
fLz/pBvY5lgzxdxBBXM5GVlnKr3BTYHtS64iGth2pJQof+YPXrOy0H17TAev
G5cPKJhMnEd1NdQmBIHV9DZqRnQImEo2D90tYIFD1S2d4lw2eDm2KKAqLQz8
sJXooRGHg4+OW6dZFUdif3LKdsBYFJgzHCP/M8MFv5DlpXdqeXgfaz2+TB8N
1t94WhS8FIP35eqyjnyOBVcLaqSm73yw+G3ShFZ/Fezyfrzw0g/0y/HAE4pV
9Bede1qmCR3gsLputo0Dm9LKSRRP9K2jCsHNfPQhkuPB8dto+SlJx8US9Kiv
0LgtQZ9N9ZLUNaJ1PYNt3b3oEqU3h9yPJqqaDWVKdOBilV/oCFphzx2ZnkX7
Og+JGAvoMYoPsVmH3qGREnNW0I3MaosJI9qTs91C20AP80VXmszovf8F/gse
ti3F
         "]]},
       Annotation[#, "Charting`Private`Tag$47573#2"]& ]}, {}}, InsetBox[
     TemplateBox[{"\"real part\"", "\"imaginary part\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.25, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"Fourier transform\"", TraditionalForm], None}, {
      FormBox[
      "\"(2\[Theta]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\) \
(\[Degree]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"Fourier transform of box (hat) function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-100., 100.}, {-0.2172289031168081, 0.9999975318424837}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwUV3c81d8bJxTpi5AKISl773k+xrW3a0WSZKVUVlSUhJCRmZXsvUfmOcm+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           "]]}, "Charting`Private`Tag$47573#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxF1GtIEwAQAOBplppWYkPdQmJkJjXBLIeabM0Hczkfm7pM1OazadrwgRm+
mgyRKahMrLDFKp9Y9kJEErUp/dFNcbpKLR+5kQW6luZsPirQu4Pj+H4cd/fn
KCkiXrolgUAI/5f/a0LywsrubtwgYS/myAlGxy10yqR2/bQJLWSNboUZ0Pme
PYfvz6OlmzXuXu/QvfW+SYIKtJOyVjVohWbRP5VdX+ODSREb1na/Y8EeBeK+
N1sx4K7u1iD/lWjwlFTxRPWTh/sU+0zS57ngiAra+eeaKHCDn8to1OtI8J2W
zWlLWThY4St5oL4XBg406bsaWtngiZXyTKdqFrjZXql5JQsBpyb7f7XJCwLL
F6Xs+Hgm+IKT7YBURQfbTAl9Ptb7gwWLZLtrj2i4b6LfOS7fG1yS6mAsDqaC
te08Tl+2G1gtmynUfnAG/2Jks61ndwf2bWDU5RCEO4x9VxblzrmVulzed4WG
fLz/pBvY5lgzxdxBBXM5GVlnKr3BTYHtS64iGth2pJQof+YPXrOy0H17TAev
G5cPKJhMnEd1NdQmBIHV9DZqRnQImEo2D90tYIFD1S2d4lw2eDm2KKAqLQz8
sJXooRGHg4+OW6dZFUdif3LKdsBYFJgzHCP/M8MFv5DlpXdqeXgfaz2+TB8N
1t94WhS8FIP35eqyjnyOBVcLaqSm73yw+G3ShFZ/Fezyfrzw0g/0y/HAE4pV
9Bede1qmCR3gsLputo0Dm9LKSRRP9K2jCsHNfPQhkuPB8dto+SlJx8US9Kiv
0LgtQZ9N9ZLUNaJ1PYNt3b3oEqU3h9yPJqqaDWVKdOBilV/oCFphzx2ZnkX7
Og+JGAvoMYoPsVmH3qGREnNW0I3MaosJI9qTs91C20AP80VXmszovf8F/gse
ti3F
           "]]}, "Charting`Private`Tag$47573#2"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"Fourier transform", None}, {
        "(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)", 
         "Fourier transform of box (hat) function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-100., 100.}, {-0.2172289031168081, 0.9999975318424837}},
       PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {"real part", "imaginary part"}, LegendMarkers -> 
       None, LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.25, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.820909075607528*^9, 3.8209090824513116`*^9}, {
   3.8209091919230733`*^9, 3.8209092147987614`*^9}, 3.820909284707246*^9, 
   3.820909317317361*^9, 3.820909400523015*^9, 3.8209094313361864`*^9, 
   3.8209094744936914`*^9, 3.8209095657779527`*^9, 3.8209099385226974`*^9, 
   3.820912472297239*^9, {3.8209125581430645`*^9, 3.8209125735968084`*^9}, {
   3.8209126055661416`*^9, 3.8209126282701006`*^9}, 3.820912664396261*^9, 
   3.8209127038501472`*^9, 3.820912737288566*^9, 3.820912849072829*^9, {
   3.8209130171400003`*^9, 3.8209130458755035`*^9}, 3.821161199162278*^9, 
   3.821167426392152*^9, {3.8211676669593077`*^9, 3.821167691054671*^9}, {
   3.821167742497898*^9, 3.8211677746052523`*^9}, {3.821169469778968*^9, 
   3.821169490153081*^9}, {3.821169577933821*^9, 3.8211695995905294`*^9}, 
   3.82116971862167*^9, 3.8211697661741605`*^9, {3.821169885290314*^9, 
   3.8211699274944086`*^9}, 3.8211843365440636`*^9, 3.8211846726626654`*^9, 
   3.821184749164697*^9, 3.8211851209873743`*^9, 3.8213669375515127`*^9, 
   3.821369134601821*^9, {3.821369320435778*^9, 3.8213693439205985`*^9}, 
   3.8213695425825663`*^9, {3.8213704041859355`*^9, 3.8213704116549015`*^9}, 
   3.8213704662033987`*^9, 3.821375189260708*^9, 3.8213752208709993`*^9, 
   3.821420752374871*^9, 3.8214209178640947`*^9, 3.821427074724353*^9, 
   3.821427109605117*^9, 3.8214271405787616`*^9, 3.82150836992704*^9, 
   3.824647334173438*^9, 3.824651822844209*^9, 3.824652067434126*^9, 
   3.8248006323011227`*^9, 3.824813198941621*^9, 3.8248748568813906`*^9, 
   3.8248756641422606`*^9, 3.824956555557131*^9, 3.824961398469942*^9, 
   3.8251523518000298`*^9, 3.8254889884044204`*^9, 3.825489196828559*^9, 
   3.8254896971942825`*^9, 3.826946523411081*^9, 3.82694676716206*^9, 
   3.8269469720594745`*^9, 3.8269476008924627`*^9, 3.8269487877262793`*^9, 
   3.8269499674482727`*^9, 3.82696624427526*^9, 3.8278401195963397`*^9, 
   3.8281764562050853`*^9, 3.828187523682723*^9, 3.828614171322327*^9, 
   3.8286143666516438`*^9, 3.8286874211686726`*^9, 3.8305972525893993`*^9, 
   3.831605930643487*^9, 3.8316230290780125`*^9, 3.8321458811662993`*^9},
 CellLabel->
  "Out[177]=",ExpressionUUID->"847a7a14-8869-4804-b090-00982e4a7ece"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3c81d8bJxTpi5AKISl773k+xrW3a0WSZKVUVlSUhJCRmZXsvUfmOcm+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         "]]},
       Annotation[#, "Charting`Private`Tag$47649#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3c8198XNsuoiAjZe5TszfvtQ/bem0SISsmsJAkZmQnZZGePCPck+5NK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         "]]},
       Annotation[#, "Charting`Private`Tag$47649#2"]& ]}, {}}, InsetBox[
     TemplateBox[{"\"real part\"", "\"imaginary part\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.25, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"Fourier transform\"", TraditionalForm], None}, {
      FormBox[
      "\"(2\[Theta]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\) \
(\[Degree]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\)\"", TraditionalForm], 
      FormBox[
      "\"Fourier transform of half box (hat) function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-100., 100.}, {-0.7246059103694156, 0.9999975318424837}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwUV3c81d8bJxTpi5AKISl773k+xrW3a0WSZKVUVlSUhJCRmZXsvUfmOcm+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           "]]}, "Charting`Private`Tag$47649#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwUV3c8198XNsuoiAjZe5TszfvtQ/bem0SISsmsJAkZmQnZZGePCPck+5NK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           "]]}, "Charting`Private`Tag$47649#2"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"Fourier transform", None}, {
        "(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)", 
         "Fourier transform of half box (hat) function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-100., 100.}, {-0.7246059103694156, 0.9999975318424837}},
       PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {"real part", "imaginary part"}, LegendMarkers -> 
       None, LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.25, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.820909075607528*^9, 3.8209090824513116`*^9}, {
   3.8209091919230733`*^9, 3.8209092147987614`*^9}, 3.820909284707246*^9, 
   3.820909317317361*^9, 3.820909400523015*^9, 3.8209094313361864`*^9, 
   3.8209094744936914`*^9, 3.8209095657779527`*^9, 3.8209099385226974`*^9, 
   3.820912472297239*^9, {3.8209125581430645`*^9, 3.8209125735968084`*^9}, {
   3.8209126055661416`*^9, 3.8209126282701006`*^9}, 3.820912664396261*^9, 
   3.8209127038501472`*^9, 3.820912737288566*^9, 3.820912849072829*^9, {
   3.8209130171400003`*^9, 3.8209130458755035`*^9}, 3.821161199162278*^9, 
   3.821167426392152*^9, {3.8211676669593077`*^9, 3.821167691054671*^9}, {
   3.821167742497898*^9, 3.8211677746052523`*^9}, {3.821169469778968*^9, 
   3.821169490153081*^9}, {3.821169577933821*^9, 3.8211695995905294`*^9}, 
   3.82116971862167*^9, 3.8211697661741605`*^9, {3.821169885290314*^9, 
   3.8211699274944086`*^9}, 3.8211843365440636`*^9, 3.8211846726626654`*^9, 
   3.821184749164697*^9, 3.8211851209873743`*^9, 3.8213669375515127`*^9, 
   3.821369134601821*^9, {3.821369320435778*^9, 3.8213693439205985`*^9}, 
   3.8213695425825663`*^9, {3.8213704041859355`*^9, 3.8213704116549015`*^9}, 
   3.8213704662033987`*^9, 3.821375189260708*^9, 3.8213752208709993`*^9, 
   3.821420752374871*^9, 3.8214209178640947`*^9, 3.821427074724353*^9, 
   3.821427109605117*^9, 3.8214271405787616`*^9, 3.82150836992704*^9, 
   3.824647334173438*^9, 3.824651822844209*^9, 3.824652067434126*^9, 
   3.8248006323011227`*^9, 3.824813198941621*^9, 3.8248748568813906`*^9, 
   3.8248756641422606`*^9, 3.824956555557131*^9, 3.824961398469942*^9, 
   3.8251523518000298`*^9, 3.8254889884044204`*^9, 3.825489196828559*^9, 
   3.8254896971942825`*^9, 3.826946523411081*^9, 3.82694676716206*^9, 
   3.8269469720594745`*^9, 3.8269476008924627`*^9, 3.8269487877262793`*^9, 
   3.8269499674482727`*^9, 3.82696624427526*^9, 3.8278401195963397`*^9, 
   3.8281764562050853`*^9, 3.828187523682723*^9, 3.828614171322327*^9, 
   3.8286143666516438`*^9, 3.8286874211686726`*^9, 3.8305972525893993`*^9, 
   3.831605930643487*^9, 3.8316230290780125`*^9, 3.832145881306916*^9},
 CellLabel->
  "Out[178]=",ExpressionUUID->"2df3522e-bdab-4dff-8101-617730ceabde"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQXXhOT337hXN2gp53rRb+nGWfYXb/zCvnP/Yw/tfD
l++/cOZxgPGXPP1VZlUiC+eHpHPrej1UhfOllfrru5/owPk6S0t4ftsbwfkL
i1QCtp4xhfMvlNmbtyy1hPMV4676xebYwvmp/7etk610gPPFX+9gF09ygvNL
jG3uTNJygfOT3v45IfzKFc5f61TMPv+8O8L9X7IOrpniCef/cJQ4e6TeG86/
y8D88WGiL5yfJ5M/oVHZH85fl3niwNTWADi/6rPkd+3MQDj/q5db2PH4IDjf
Mnqi49PAYDj/kuTcrCPGIXC+1LLmPSs0QuH8HQ+0fPx4w+B8uSsf0sveIvjG
UyeuWfwgHM6fy/JZb9LhCDh/m6P+rdadkXD+DPMuwT+rouD887eXthn3RMP5
W33nqBQ0xMD5H3ODGfJSYhH+cdPMeOccB+eveHvzR7FZPJwfsXBpcixPApy/
eZN3PHM7gm8pfeln508EX/lB+q2LmYlw/hPubP85jxH8C31+ye6hSXD+lIr5
3KUXEPw9+/7/TPZMhvP5YxzajXch+JYJ71a0mqTA+X27azJ3LEPw3YulCtaI
pcL51yeqcitPQPAnsQu6VjGmIdyXs05urwOCb3bJ+8f/egQfAFXYiDk=
         "]]},
       Annotation[#, "Charting`Private`Tag$47725#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwV1GlczUsYB/B2aV9o1XZaaDmokxLxPNrQrkiRtJz+LRJaqKR0k1Boo/rr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         "]]},
       Annotation[#, "Charting`Private`Tag$47725#2"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"Size of source/ receiving slit width = 0.1 mm\"", 
       "\"speciment tilt = 0.1 mm\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.01}], ImageScaled[{0.5, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"fhwm of box function (\[Degree]2\[Theta])\"", TraditionalForm], 
      None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"aberrations in the equatorial plane\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{0., 180.}, {8.444757228132801*^-10, 0.026342887132451646`}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQXXhOT337hXN2gp53rRb+nGWfYXb/zCvnP/Yw/tfD
l++/cOZxgPGXPP1VZlUiC+eHpHPrej1UhfOllfrru5/owPk6S0t4ftsbwfkL
i1QCtp4xhfMvlNmbtyy1hPMV4676xebYwvmp/7etk610gPPFX+9gF09ygvNL
jG3uTNJygfOT3v45IfzKFc5f61TMPv+8O8L9X7IOrpniCef/cJQ4e6TeG86/
y8D88WGiL5yfJ5M/oVHZH85fl3niwNTWADi/6rPkd+3MQDj/q5db2PH4IDjf
Mnqi49PAYDj/kuTcrCPGIXC+1LLmPSs0QuH8HQ+0fPx4w+B8uSsf0sveIvjG
UyeuWfwgHM6fy/JZb9LhCDh/m6P+rdadkXD+DPMuwT+rouD887eXthn3RMP5
W33nqBQ0xMD5H3ODGfJSYhH+cdPMeOccB+eveHvzR7FZPJwfsXBpcixPApy/
eZN3PHM7gm8pfeln508EX/lB+q2LmYlw/hPubP85jxH8C31+ye6hSXD+lIr5
3KUXEPw9+/7/TPZMhvP5YxzajXch+JYJ71a0mqTA+X27azJ3LEPw3YulCtaI
pcL51yeqcitPQPAnsQu6VjGmIdyXs05urwOCb3bJ+8f/egQfAFXYiDk=
           "]]}, "Charting`Private`Tag$47725#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwV1GlczUsYB/B2aV9o1XZaaDmokxLxPNrQrkiRtJz+LRJaqKR0k1Boo/rr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           "]]}, "Charting`Private`Tag$47725#2"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"fhwm of box function (\[Degree]2\[Theta])", None}, {
        "2\[Theta] (\[Degree])", "aberrations in the equatorial plane"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0., 180.}, {8.444757228132801*^-10, 
       0.026342887132451646`}}, PlotRangeClipping -> True, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "Size of source/ receiving slit width = 0.1 mm", 
        "speciment tilt = 0.1 mm"}, LegendMarkers -> None, LabelStyle -> 
       Directive[Bold, 16], LegendLayout -> "Column"]], {0.45, Bottom}, 
     Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{{3.820909075607528*^9, 3.8209090824513116`*^9}, {
   3.8209091919230733`*^9, 3.8209092147987614`*^9}, 3.820909284707246*^9, 
   3.820909317317361*^9, 3.820909400523015*^9, 3.8209094313361864`*^9, 
   3.8209094744936914`*^9, 3.8209095657779527`*^9, 3.8209099385226974`*^9, 
   3.820912472297239*^9, {3.8209125581430645`*^9, 3.8209125735968084`*^9}, {
   3.8209126055661416`*^9, 3.8209126282701006`*^9}, 3.820912664396261*^9, 
   3.8209127038501472`*^9, 3.820912737288566*^9, 3.820912849072829*^9, {
   3.8209130171400003`*^9, 3.8209130458755035`*^9}, 3.821161199162278*^9, 
   3.821167426392152*^9, {3.8211676669593077`*^9, 3.821167691054671*^9}, {
   3.821167742497898*^9, 3.8211677746052523`*^9}, {3.821169469778968*^9, 
   3.821169490153081*^9}, {3.821169577933821*^9, 3.8211695995905294`*^9}, 
   3.82116971862167*^9, 3.8211697661741605`*^9, {3.821169885290314*^9, 
   3.8211699274944086`*^9}, 3.8211843365440636`*^9, 3.8211846726626654`*^9, 
   3.821184749164697*^9, 3.8211851209873743`*^9, 3.8213669375515127`*^9, 
   3.821369134601821*^9, {3.821369320435778*^9, 3.8213693439205985`*^9}, 
   3.8213695425825663`*^9, {3.8213704041859355`*^9, 3.8213704116549015`*^9}, 
   3.8213704662033987`*^9, 3.821375189260708*^9, 3.8213752208709993`*^9, 
   3.821420752374871*^9, 3.8214209178640947`*^9, 3.821427074724353*^9, 
   3.821427109605117*^9, 3.8214271405787616`*^9, 3.82150836992704*^9, 
   3.824647334173438*^9, 3.824651822844209*^9, 3.824652067434126*^9, 
   3.8248006323011227`*^9, 3.824813198941621*^9, 3.8248748568813906`*^9, 
   3.8248756641422606`*^9, 3.824956555557131*^9, 3.824961398469942*^9, 
   3.8251523518000298`*^9, 3.8254889884044204`*^9, 3.825489196828559*^9, 
   3.8254896971942825`*^9, 3.826946523411081*^9, 3.82694676716206*^9, 
   3.8269469720594745`*^9, 3.8269476008924627`*^9, 3.8269487877262793`*^9, 
   3.8269499674482727`*^9, 3.82696624427526*^9, 3.8278401195963397`*^9, 
   3.8281764562050853`*^9, 3.828187523682723*^9, 3.828614171322327*^9, 
   3.8286143666516438`*^9, 3.8286874211686726`*^9, 3.8305972525893993`*^9, 
   3.831605930643487*^9, 3.8316230290780125`*^9, 3.8321458814162855`*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"f86b6b51-51f6-47c2-a790-355a9066be67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"circles", "[", 
      RowBox[{"x", ",", "0.0", ",", 
       RowBox[{"-", "2."}]}], "]"}], ",", "\[IndentingNewLine]", 
     "           ", 
     RowBox[{"circles", "[", 
      RowBox[{"x", ",", "0.0", ",", 
       RowBox[{"-", "4."}]}], "]"}], ",", "\[IndentingNewLine]", 
     "            ", 
     RowBox[{"circles", "[", 
      RowBox[{"x", ",", "0.0", ",", 
       RowBox[{"-", "8."}]}], "]"}]}], "}"}], ",", "                      ", 
   "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "0.5"}], ",", "0.05"}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Full", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "20"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", "\"\<normalized intensity\>\"", 
      ",", "\"\<circles function\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<cut off at 2.0 \[Degree]2\[Theta]\>\"", ",", 
         "\"\<cut off at 4.0 \[Degree]2\[Theta]\>\"", ",", 
         "\"\<cut off at 8.0 \[Degree]2\[Theta]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.45", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{"Plot", "[", "  ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "@", 
       RowBox[{"ftcircles", "[", 
        RowBox[{"x", ",", "4."}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
      "            ", 
      RowBox[{"Im", "@", 
       RowBox[{"ftcircles", "[", 
        RowBox[{"x", ",", "4."}], "]"}]}]}], "\[IndentingNewLine]", 
     "                        ", "}"}], ",", "                      ", 
    "\[IndentingNewLine]", 
    "                                                        ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", 
      RowBox[{"-", "100."}], ",", "100."}], "}"}], ",", "\[IndentingNewLine]",
     "                                                        ", 
    RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"GridLinesStyle", "\[Rule]", 
     RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)\>\"", ",", 
       "\"\<Fourier transform\>\"", ",", 
       "\"\<Fourier transform of circles function\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{"{", 
         RowBox[{
         "\"\<  real part\>\"", ",", 
          "\"\<imaginary part \\n(cut off at 4.0 \[Degree]2\[Theta])\>\""}], 
         "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.25", ",", "Top"}], "}"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
    "                                                          ", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AxialDivergence", "[", 
      RowBox[{"x", ",", "2", ",", "217.5"}], "]"}], ",", 
     RowBox[{"AxialDivergence", "[", 
      RowBox[{"x", ",", "4", ",", "217.5"}], "]"}], ",", 
     RowBox[{"AxialDivergence", "[", 
      RowBox[{"x", ",", "8", ",", "217.5"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "1", ",", "179."}], "}"}], ",", 
   "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", 
      "\"\<extens. of circles function (\[Degree]2\[Theta])\>\"", ",", 
      "\"\<aberrations in the axial plane (axial divergence)\>\""}], "}"}]}], 
   ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<RS length= 2 mm\>\"", ",", "\"\<RS length= 4 mm\>\"", " ", ",", 
         "\"\<RS length= 8 mm\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.45", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8209138505691295`*^9, 3.820913867085225*^9}, {
   3.820913900070752*^9, 3.8209139365558834`*^9}, {3.8209139696195307`*^9, 
   3.8209142140321927`*^9}, {3.8209142568613873`*^9, 
   3.8209142649241695`*^9}, {3.8209178827402067`*^9, 
   3.8209178833494573`*^9}, {3.820919226197742*^9, 3.82091926197972*^9}, {
   3.8211697887982206`*^9, 3.8211697896106367`*^9}, {3.8211845241432605`*^9, 
   3.8211845430497293`*^9}, {3.8211845825508337`*^9, 3.8211846626778455`*^9}, 
   3.8211847720718207`*^9, {3.8211848037755957`*^9, 3.8211848062444215`*^9}, {
   3.8211848960438414`*^9, 3.8211849130601225`*^9}, {3.821185067860705*^9, 
   3.8211851086744785`*^9}, {3.821189812582754*^9, 3.8211899166809125`*^9}, {
   3.821189956463896*^9, 3.8211900659218664`*^9}, {3.8211900966735377`*^9, 
   3.8211901318469763`*^9}, {3.8211901881459136`*^9, 3.821190198880842*^9}, {
   3.8211902308821473`*^9, 3.82119025761769*^9}, {3.8211907105193577`*^9, 
   3.8211907127622175`*^9}, {3.821190746216662*^9, 3.8211907828280044`*^9}, {
   3.8211908487265196`*^9, 3.8211908509245763`*^9}, {3.8211908857542067`*^9, 
   3.8211908986213255`*^9}, {3.821190935522674*^9, 3.821190935722974*^9}, 
   3.8248033770864353`*^9, 3.8251523234870563`*^9, 3.825489149296773*^9, 
   3.8254896624280376`*^9},
 CellLabel->
  "In[180]:=",ExpressionUUID->"7606f1a9-ad04-4dd1-828b-a3e0963904a1"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwdxwc81Yv/x/Fj744VJyQkupcolNH4fioUJRUJySoUxUmSZKVCsq/EQVc2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         "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBWIQPafB0OWF4ud9DGBg4nChKs9O9RizPQMUiL5v/9Hr
pg3n75bfFXDyrAWcz2dx+U/aRHc4X92HT32Fmi+cr7BhyYovsYFwvsWR+5dM
P4fB+SbfVgnf4UuE8612W8bplCTB+Q4NJ1bU3EyG8324ntnKLkmD81PlFDPi
LHPgfO/F3nEfNhbD+QVMX5NEE0vg/CmJ89KtBErh/HvyHwta8soQ6udMa5bQ
rkSon/pwhcOSOjj/3eHdlR6nW+B8822BR2bs7YfzO3QbX2rsnw3nt/y/rCiV
tRjOd8kylLvRhOCzXO2TmjYbwW9d5SksdBbBbwvdz8JlsATO71y96vnPrwh+
X3jj2puNy+B8v0P3Vk6fheDz6dosC92M4PczfZ938QmCP2FtzoST7svh/MnM
EcU7eVfA+SF5W/PL1RB8kZtCOab2CP6UdWdTNhYg+NMincNWXkbww44sCEp/
g+CL6f/zU2VdCedPZ9npvtAMwY/IF3OJ90fwJW4VO8hmIPg3XC7a3G5A8Ges
17OcORPBBwAXcaYq
         "]]},
       Annotation[#, "Charting`Private`Tag$47803#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwdxwc4Ffz/xvFj5WRkj5A6IvV0IiNJ8v2msldpSLKKyuo4IVmdPJKyJZvs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         "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBWIQfY/11t5V81j3M4CBicOFqjw71WPM9gxQIPq+/Uev
mzacv1t+V8DJsxZwPp/F5T9pE93hfHUfPvUVar5wvsKGJSu+xAbC+RZH7l8y
/RwG55t8WyV8hy8RzrfabRmnU5IE5zs0nFhRczMZzvfhemYruyQNzk+VU8yI
s8yB870Xe8d92FgM5xcwfU0STSyB86ckzku3EiiF8+/JfyxoyStDqJ8zrVlC
uxKhfurDFQ5L6uD8d4d3V3qcboHzzbcFHpmxtx/O79BtfKmxfzac3/L/sqJU
1mI43yXLUO5GE4LPcrVPatpsBL91laew0FkEvy10PwuXwRI4v3P1quc/vyL4
feGNa282LoPz/Q7dWzl9FoLPp2uzLHQzgt/P9H3exScI/oS1ORNOui+H8ycz
RxTv5F0B54fkbc0vV0PwRW4K5ZjaI/hT1p1N2ViA4E+LdA5beRnBDzuyICj9
DYIvpv/PT5V1JZw/nWWn+0IzBD8iX8wl3h/Bl7hV7CCbgeDfcLloc7sBwZ+x
Xs9y5kwEHwC/M6Zl
         "]]},
       Annotation[#, "Charting`Private`Tag$47803#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwdxwc4FXwfxnGbki1UKiR6H0qhjMb/ryKUyCYZCUVxkiRZeTKzkoxjPNkj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         "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBWIQve69YE1AqPB+BjAwcbhQlWeneozZngEKRN+3/+h1
04bzd8vvCjh51gLO57O4/Cdtojucr+7Dp75CzRfOV9iwZMWX2EA43+LI/Uum
n8PgfJNvq4Tv8CXC+Va7LeN0SpLgfIeGEytqbibD+T5cz2xll6TB+alyihlx
ljlwvvdi77gPG4vh/AKmr0miiSVw/pTEeelWAqVw/j35jwUteWUI9XOmNUto
VyLUT324wmFJHZz/7vDuSo/TLXC++bbAIzP29sP5HbqNLzX2z4bzW/5fVpTK
Wgznu2QZyt1oQvBZrvZJTZuN4Leu8hQWOovgt4XuZ+EyWALnd65e9fznVwS/
L7xx7c3GZXC+36F7K6fPQvD5dG2WhW5G8PuZvs+7+ATBn7A2Z8JJ9+Vw/mTm
iOKdvCvg/JC8rfnlagi+yE2hHFN7BH/KurMpGwsQ/GmRzmErLyP4YUcWBKW/
QfDF9P/5qbKuhPOns+x0X2iG4Efki7nE+yP4EreKHWQzEPwbLhdtbjcg+DPW
61nOnIngAwA+8aWA
         "]]},
       Annotation[#, "Charting`Private`Tag$47803#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"cut off at 2.0 \[Degree]2\[Theta]\"", 
       "\"cut off at 4.0 \[Degree]2\[Theta]\"", 
       "\"cut off at 8.0 \[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"circles function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-0.5, 0.05}, {-2, 20}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {0, 0}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwdxwc81Yv/x/Fj744VJyQkupcolNH4fioUJRUJySoUxUmSZKVCsq/EQVc2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           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGDQBWIQPafB0OWF4ud9DGBg4nChKs9O9RizPQMUiL5v/9Hr
pg3n75bfFXDyrAWcz2dx+U/aRHc4X92HT32Fmi+cr7BhyYovsYFwvsWR+5dM
P4fB+SbfVgnf4UuE8612W8bplCTB+Q4NJ1bU3EyG8324ntnKLkmD81PlFDPi
LHPgfO/F3nEfNhbD+QVMX5NEE0vg/CmJ89KtBErh/HvyHwta8soQ6udMa5bQ
rkSon/pwhcOSOjj/3eHdlR6nW+B8822BR2bs7YfzO3QbX2rsnw3nt/y/rCiV
tRjOd8kylLvRhOCzXO2TmjYbwW9d5SksdBbBbwvdz8JlsATO71y96vnPrwh+
X3jj2puNy+B8v0P3Vk6fheDz6dosC92M4PczfZ938QmCP2FtzoST7svh/MnM
EcU7eVfA+SF5W/PL1RB8kZtCOab2CP6UdWdTNhYg+NMincNWXkbww44sCEp/
g+CL6f/zU2VdCedPZ9npvtAMwY/IF3OJ90fwJW4VO8hmIPg3XC7a3G5A8Ges
17OcORPBBwAXcaYq
           "]]}, "Charting`Private`Tag$47803#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwdxwc4Ffz/xvFj5WRkj5A6IvV0IiNJ8v2msldpSLKKyuo4IVmdPJKyJZvs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           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGDQBWIQfY/11t5V81j3M4CBicOFqjw71WPM9gxQIPq+/Uev
mzacv1t+V8DJsxZwPp/F5T9pE93hfHUfPvUVar5wvsKGJSu+xAbC+RZH7l8y
/RwG55t8WyV8hy8RzrfabRmnU5IE5zs0nFhRczMZzvfhemYruyQNzk+VU8yI
s8yB870Xe8d92FgM5xcwfU0STSyB86ckzku3EiiF8+/JfyxoyStDqJ8zrVlC
uxKhfurDFQ5L6uD8d4d3V3qcboHzzbcFHpmxtx/O79BtfKmxfzac3/L/sqJU
1mI43yXLUO5GE4LPcrVPatpsBL91laew0FkEvy10PwuXwRI4v3P1quc/vyL4
feGNa282LoPz/Q7dWzl9FoLPp2uzLHQzgt/P9H3exScI/oS1ORNOui+H8ycz
RxTv5F0B54fkbc0vV0PwRW4K5ZjaI/hT1p1N2ViA4E+LdA5beRnBDzuyICj9
DYIvpv/PT5V1JZw/nWWn+0IzBD8iX8wl3h/Bl7hV7CCbgeDfcLloc7sBwZ+x
Xs9y5kwEHwC/M6Zl
           "]]}, "Charting`Private`Tag$47803#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwdxwc4FXwfxnGbki1UKiR6H0qhjMb/ryKUyCYZCUVxkiRZeTKzkoxjPNkj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           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGDQBWIQve69YE1AqPB+BjAwcbhQlWeneozZngEKRN+3/+h1
04bzd8vvCjh51gLO57O4/Cdtojucr+7Dp75CzRfOV9iwZMWX2EA43+LI/Uum
n8PgfJNvq4Tv8CXC+Va7LeN0SpLgfIeGEytqbibD+T5cz2xll6TB+alyihlx
ljlwvvdi77gPG4vh/AKmr0miiSVw/pTEeelWAqVw/j35jwUteWUI9XOmNUto
VyLUT324wmFJHZz/7vDuSo/TLXC++bbAIzP29sP5HbqNLzX2z4bzW/5fVpTK
Wgznu2QZyt1oQvBZrvZJTZuN4Leu8hQWOovgt4XuZ+EyWALnd65e9fznVwS/
L7xx7c3GZXC+36F7K6fPQvD5dG2WhW5G8PuZvs+7+ATBn7A2Z8JJ9+Vw/mTm
iOKdvCvg/JC8rfnlagi+yE2hHFN7BH/KurMpGwsQ/GmRzmErLyP4YUcWBKW/
QfDF9P/5qbKuhPOns+x0X2iG4Efki7nE+yP4EreKHWQzEPwbLhdtbjcg+DPW
61nOnIngAwA+8aWA
           "]]}, "Charting`Private`Tag$47803#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
      All, DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity", None}, {
        "2\[Theta] (\[Degree])", "circles function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {{-0.5, 0.05}, {-2, 20}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {Automatic, Automatic}}, 
      Ticks -> {Automatic, Automatic}, TicksStyle -> Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "cut off at 2.0 \[Degree]2\[Theta]", 
        "cut off at 4.0 \[Degree]2\[Theta]", 
        "cut off at 8.0 \[Degree]2\[Theta]"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.45, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8209139378683414`*^9, {3.8209139806351423`*^9, 3.820913991448325*^9}, {
   3.8209140342148027`*^9, 3.820914056293874*^9}, {3.82091409326348*^9, 
   3.8209141613280125`*^9}, 3.8209142147821794`*^9, 3.820914266564885*^9, 
   3.820919262933076*^9, 3.8211611993159466`*^9, 3.8211843369972286`*^9, 
   3.8211846730844364`*^9, {3.8211847496334333`*^9, 3.8211847747282534`*^9}, 
   3.8211848146196814`*^9, 3.821184906856371*^9, 3.8211850869706073`*^9, 
   3.821185121424631*^9, 3.821189832333556*^9, {3.8211898884764814`*^9, 
   3.8211899173842363`*^9}, {3.8211900064195433`*^9, 3.821190066593844*^9}, 
   3.8211901128771973`*^9, 3.821190199630719*^9, {3.821190234835477*^9, 
   3.8211902593208213`*^9}, 3.8211907137779036`*^9, 3.8211907528106966`*^9, 
   3.8211907854217124`*^9, 3.8211908520338545`*^9, 3.821190899692251*^9, 
   3.821190936540428*^9, 3.821366937989266*^9, 3.821369135008207*^9, {
   3.8213693208999834`*^9, 3.8213693443110776`*^9}, 3.8213695431138535`*^9, 
   3.82137041213929*^9, 3.8213751902920294`*^9, 3.821375221574173*^9, 
   3.8214207531769867`*^9, 3.821420918450056*^9, 3.8215083705520964`*^9, 
   3.8246473347828293`*^9, 3.8246518234534397`*^9, 3.8246520685747566`*^9, 
   3.824800633004345*^9, 3.824813199535491*^9, 3.8248748576365795`*^9, 
   3.8248756647972507`*^9, 3.824956556307198*^9, 3.8249613990637455`*^9, 
   3.825152352393819*^9, 3.82548898901337*^9, 3.8254891974224687`*^9, 
   3.825489697772189*^9, 3.82694652413519*^9, 3.8269467677247543`*^9, 
   3.8269469727001843`*^9, 3.82694760164262*^9, 3.8269487883515882`*^9, 
   3.826949968073625*^9, 3.8269662449002542`*^9, 3.8278401202875214`*^9, 
   3.828176456980192*^9, 3.8281875243558865`*^9, 3.8286141719943533`*^9, 
   3.8286143672611523`*^9, 3.8286874218718877`*^9, 3.830597253592373*^9, 
   3.831605931393845*^9, 3.831623029687365*^9, 3.8321458815881596`*^9},
 CellLabel->
  "Out[180]=",ExpressionUUID->"4c3c7117-429e-4371-98d6-a9d7d994b606"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJw12Xc0Fm70AHAlW3Zm9p4h9Jr3ISNSdt6vJCQkSQlRyQqRURokkjRUeIkk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         "]]},
       Annotation[#, "Charting`Private`Tag$47978#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwt2XkwF87/B3B3rtz3fZOb0Dtkl1DKfb7LkYSQ6EJJQhIShYpEEonk1se9
+3bf3u4jSVJKRblz/vxmvn/tPOY5uzs7r9k/XvMSd/O39qCioKD4TElB8f+r
09nP87u7REyflEXpW1WIPgk4LXJsEXHQw9bVOzWFyG1weEV6nYjjJ+woX9YV
Iq9jXVsn/xCx8ripwSqpEF1V+o8xZYqIt17xV4POQhT7L05GlUTE1l8Y0q9/
KkRVjwgurhFELCPEeukFdRHiaUjoxjREXCwp7vjNqggd0xsLPbNsjyma+T2P
URQjfvO1fUyrdvivgHPYJ2IxkrsWXlu2ZYuzzYKa3cuKUWHF66Pa8zY4U0mk
bE6kBA3FZmZ1/7XG+2lZNq/ElKCrNzUH9aas8Al69v1LdKXIPEJL7d2AJU7o
jarPji9FyYf5uixLLTAbbzzdX+4ydCPn3zhVkhlm//ROqryqDGUSIlN7np7E
PVoJnTlny5HB+rfC5Ncm2PwEX/FpvgrUP3/bm+f+McwdIpzDtFaBspkbBkqS
jPB3FTM6s0/v0bmz2l/orxzFao9qz4nQVqL06ViT06f1ceYkewGyqkJ67dMr
9631sa/ITeYYhyo0VaSdVXdCHzPJ7rc3d65CUrfmNsR09HGVfNBssVcVKuA9
UTArqI8HWFJ+2YZWoVpTBtaAjxCnuE/ddH9dhT68vzeY4Arx9bXz5TQ01egg
DwOK7dbDvH7B3JmkaqT8eHo5rVYPV4hdSUKt1Uieq1b+3Vs9jE7c0f/RXY3E
OPyf9Mbo4QbvY2nR49WIhWXoIpexHraiDwkeXKlG32lfCmXUH8FkyYDiWvUa
lLFCCC4p0sWZXjcfzmfVIPohL83RR9p4LFsvpiCnFumlIwJjhDZ28DXbN/Cu
Fl314NHVvaKNcQVtQW9FLZpcaTTItNbGreLVY0eba1EZj6ilF6c21jiSnR0z
XYtciEM+68mHMdu134OponWo/IN+Jl8KAauy6tZoFtShuVcpr05EE/DJKBsN
9vI6JOq78DrkOgEvy2f2TdfUodit5++miARsrs8f8bKzDp0RXq9+w0/At2el
Ond/1aHkr+b14wwELLrw+ubiSh3qeJdDYt44hB0tWljld+uQhp5N26XxQxg8
KuA/xVGPGM8UDhHSDuGjBTWHX2nXI9dpAaZTGVpYL//FdHB3PTJzSvtJeKCF
qdzFX+aO1CPtYcEuvhAtjA9ITCtO1yPODqEHo6e0sFVwtJrJej1qKRFhJXJr
YbNtNaUhWYSUwiU4HeI0MUuyT9GLSIQ2ROUF7YI1cJ7vraBOEYxmU/M3Nbw1
cIwaZXqiNEaDnAoTXEQN7GWTYGquiNG7fYrpg5oauLS0+On1wxi5LiiJ2v49
iBu6DqRsW2Fk5l24e3DqID7pw9DQ6ICR9hflKc7eg7j7pIrdNWeMuEZUXg4U
HMSv5aseNnthRGlVHF6WdhBvv3qqGu6H0XyHqltS7EF8Wcf6mOM1jFrr1SRt
vA5ik0TlsqdhGCU7H1awslfHRob2HqWLGM2kXJoMM1LHC/HU9FvrGGkO5j4q
1lDHiq8YX6jvYjR8gmedlVMddxhmsL5gIiHZKLO3gGpvf6w39RI7CV0nRbr4
/1XDaz/P8vnxkRA/Yampp1cNs7eMPqGXISGfq/LXd+rVsM6vrY1DSiRUXXhW
QblQDTO+aT3xToOEnKTJjx7EqWExVqZhF0MSyuB452JqooaFabvb2z1IaMFs
hj2EoIZ1p5/x6vqREIwRbH4rq4aN3P0dUwJJ6PNujAITnRpWFGERn4giIanf
nuvtDaq4skDffTWbhK7JZbz9V6KKoziJH5gLSKj53JDLgZeq2Jq6L5W5jIQ8
x482R99WxffG6FMZSSSU1yqWeExXFTsemXv6eZKENqiIRkEKqrjmz6AiwywJ
ndBLWH8toIrPpIu/ilwgoRHvzTrmRRXsq/La4AJlA3IyrHCIvbDnw6XUZbIN
6Pw/uft3XZTxuSaCCdOlBhRyjm3xpqEi3v94vtCNrhEl+t5YEpJWxDVUbrM/
2BpRbsD0ch2tIjZKVewlCjai/nvla7stCpiN+aluoUojki0gbt8xUcDn6UKq
zO0akW4FaUdKXgEnih6aEHBpRNb18hQtjArY6tO/0TrPRhRC3qKi75LHG4j1
VV/Q3nnLmfRx5vJYd+KmeURaI/q+zcCopCKPJ34ZflLPaUTbdFeZeljlcfaz
njCzokYkx2/EwtZ3ABvIlfX2NTWi0CM/OJNtDuCKk6u9p5Yb0YEoNdHnRDks
eCPxc65tE9JLeCZ25LAcDr7jYRl8pgnZplBLTPLL4Tdko4ht7yYUmj8kJfZB
FhN6C85ZhTah5DI9GVKNLD69SaduGt2E8mpzZd2ey+59FPZKk8QmNNhzQz7b
WRazsAVv1L5uQnMj0wpGerJ4Q/KKgHdJE9qdOqn0TUQWv0CBweG1TUh+SVhV
bkoGSwVUr2kPNqEw3gbNAjcZbLr1Yx9kbEZPxBQOmR2VwRJ26MZXvmb09kAy
YV5SBj/uMaAZkG1GwzqeOqpfpTEw8rTdb9yMFFwZ9cvPS+NpUVaOyrC9/I21
aa2vFP4tQ7ck8bUZneZmpa86IYVZ834ePLHYjCbDOxsr5KTwzzf9v8Z3m9Hs
aUOdohlJvHGDW/qTUAvybaVYe9sgiS9VZ/ImKragPwfrSt9kSuKa6fZnckda
0DqzlnyWkyR2Eq65uOXagkJuLH7N0JbErk8f5vBca0EU3wpfpvFJ4s9/p9nJ
91oQA5LlfzwogTnSLH97FLcggcv89NGmElhiXbL6HEUryvg41BgpL4E3pC91
inC2IokTibfD6SWw5X7Hb9LSrUhBkmktuEkcl0GffNljrag4obU0KEsci1s4
qFo5tCKNrTt+18LE8fq6HkHifCvSHdr6elFXHH9t3dzIjGpFWL/qpY+AOC4Z
f2lIftKKDAsDnM+vi2H9IO+Yl7mtqE1And99WAwvPmcysqxqRWb35gddy8Uw
31e5H/u7WlH/Uv5D50QxPHmULLXzqRXZu543PX1JDFcdfUejsdKKXA5PNdoo
iuGT1O1SrpJtaDrn+W1LRjHcdDb/tKhuG+qWKg18RhbFy782flTataHJ4Vce
D46LYsVSBeYLsW3oW5HQxygaUUyowxNz2W1oIfqxbRgWwcn6zuvCqA1R6Nw7
epUggvk5DOoe/21D9FwUNb7Lwvh1ypeZGwztiP33dXXPYmFcenHKgijWjiRe
+IifkhPGIVwlnnIn25ERtfmuHp8Q3tFRXel+1o7MJ1oCCYOC+Aq1ENO5onZk
XwHm1R4K4jeVTAK7Te3oTHylh4KpIJZ6wRaw8aEdeZ1X+yhFL4jVIvNn05fb
0SWYbyvSJICZ0B1hYdYOdINfsos3TADPfo40TVToQLGdXDWM6/zYw7/15WGf
DpSY/UCdppwf32AV62WP60Bpt+jyt/358TkdkrFqUQcqUFlP+TPLh/XNxuqS
1zpQT9KHwOERXqyrEqSlGNmJ0CMTKZsUXlz5ca5XOqtzr/7/9fUSebEoLVtm
WX0nenQ/SbF9jAfLOMyGVS11oogYynGjZzz4x8Oj1gnMXejKPf97Dad5sK9n
9HSJVBeyvXNyuuYDN/b6qqecYduFjMKrEgjPubHUNKOAz8UupHVb9kiFEzeO
2zn78fq9LiRz6/GcmjA3pnvoymT6qgvx3qROKfzIhYf/ISYHUheiv3HZSCGD
Cx8WrXq49rkLrQd+Wsx14cLlVcrU/rTdaPxKjdnLT5x4kcs544hdN+q8dGBT
OJMTb5hTNrqHd6Nav6dvnrlyYvf40HNUxd0o3ecqdfJnDsw+RtFVzdGD4r0+
F7NlcWAPS0vPLKMeFOpp4fLAjQMT/XNr86/3IFc3haqoL+xYbVrr65mJHmTl
mupJnc2OjxkwepOZepGByz6uMHd27PyF9fEOoRepOwWQtqTYcegBz7j0c71I
8vQXvxtf2fC3BuXZhPu9iItoJbSaw4ZXatSf/yruRTT2qP2KJxu2rpDgpBzs
RZ2vtExGe1jxlmxkQwsjGRW84Mjus2DFS+PqFzoFyCg+bX6ng8yCr21T2mso
kJH/045TTVYseC7u899oXTKyTHpdXte/H+enu5+1tiAj9YQI1v9s9uPK+1Uh
nO5kxHnfxad4kBnnvtEshDfJaDlKuznPjhmHat8VIzwmo+EIHrFXw0z42NGz
ldqlZFQZuhj83IFprwWYsPDsJ6PU4J6hx6OMOIaxPqNkhYycrkTdjx5nwCNT
M6Hlhn1Iz8/tW7gjA87slJyI9+9Doj56+jcn6LGEQ4X9cFofmj67unpxch++
OvjgYP5KH2py7rc6f2Yf9pJmuZsi3o9yThUWuE7RYX63mfLek/0oyi523+mz
dFhsZ1su7Wo/8rLydLOZpsVs36tcvFL60QkzgzrTc7R4984MYaCqHymYiPAZ
z9Bg+p3PpOKRfsRstHEFeNDgSCrDPN7FfjQPh7sJ36hxTf/OgAfDACLrlsqp
n6fGzy/+9jcQGUAlhPg7Ct+pMJ1OivBztQGUqOEzKeVNhesd6X9nGQ6ga6rG
h0XmKPFqKkGgnjiA7BUlknkvUGJvuwt5t/wH0CG5nXm2XxQ4PoThcHTsAOKT
GjdhvEiBbR8cTrr7dgAtAV+TfRO7qPBUXDXd4ABaNnsovza9g3wnx1SdaAbR
smM50+yPbZQy/HDEUG/P3qO/hv9sobyPz0suROw5aKu7ZW0TMUkNcjL27fmu
WNH7nQ0UqzEbM3hgCK0kGT58TbuBunVWjv+8P4RWi+KsozjXEcWOlp+jxzBa
rSs+GCiwhujp5q+2jAyjtc5BLk/xVWRpRq2SazKC1sfWV+zkVtDyULA01X97
nhUaMVJZRjJyNNZOgqNofQVWamotodPHnggPXh5F/6g9UqWPLKL/Pvh2gIpR
tMEeE8xt+BepBK6GWU7tWfSdI+3JP6gmKn+98vcoWnHMujH3ah4dFXoYbT86
ilaD5nQ6Sn6hmYsvjjmmjaK1JPWdPDSHtKyHu4PU9+4rCsYx3d9RwyqfMPWz
EfSvsyHC+8M3tDUYfUS0dxhtzDIamfyYQTzRNIpjvUNok9pm34G1afR6I2nc
IG0QbYmmtdPTfkYz4U9Vo/bquRHUwtsnPYl4ijnU/yT1oa0i++cP9ceRav2T
S7MxvWhn9puYpfMw0m3x+2T8sBPtigblsN7oRzNFvNrGhq2IqpjFNuNAN+q/
6LYsVtKAaMVUnIXPNqO4MzaSj1prkCoFrrsIc5GheWAL05sMRLO7HkiMSgA7
tlqj77sjwRjI2OoKLwNk1//CNfPzwFfA4vvdqh30nJO784yIwd/ZwBKNB2Qg
InVeTp2xGSwUfVMMuDwIannyaoeD28HvIPs3FXajoJxR+cuFjG7wE7RIrh6e
AMaxt3XtK8hghTrNQpB1Cgwbh7oUX+gHy7PWD3Qop8HMCyKfwcIAWOpk7HRc
+gKULRrFlfSGwGJRA33I169AysCmptJhGPxNCjZ+PjILKmeKsk7ojoA/QeqR
te0/gPwt7g8Ov0fAguMcaaLmJ5Cn6aMyvzgK5kHW7ta732CNo0MxEI2C35Kn
jwhnLoBv3hLe/bOjYJU6pk6k/Q+Qc0+1WJvb84r7hHLDX+Cg578+3b3nWbip
V7MIOPqPTPQ/3vOYkIBF+RKQxLfZBI6PgpXOdcKZd8vghzk2+vdjBCzXDTr4
v14BWRolPTfC9lxUHHj7xSrwTlDqMWXb88u4xwkpa+BCWWBQUfowWEryKn/x
aB20rlJz2CkOg8W7hgNFsf9AZ/Wzgw5o7/1BYovozgY4IVHppnhqz95bbOSQ
TXCQw4wzZ3MQ/HUcVZkK2AIno9ZK53MHwR+zcvM/fttAx/S5wXOXPYOHFym8
dsAa85POMtFBcJ2nr0o9cBdsJ30ILf42AMJW6e+oG1BAoZdLNEaVA6Dp7IG8
k+0U8B9TC+Ns4gBg6DbpdbekhDIJUgKN1waAOcFn5dYIJWS2u44/OQ6AxFex
gk9dqKB1NbFJz3gADLO81S/+SgV9N3n+bagNAIHgzvPtvtTQyuHBnbPCA+DI
YE9KYs4+uKRxrO0WQz+IAAv1bxXpYeWR/ru8432gJZ/1a1MZPRSQqydq5fcB
Rh5VpkltBnhF68f0QHAfMA+3VFsjMcDK6YriMdM+kPjrkgObCSP08bvnxyne
B0YcHt06QGaElKIXGaXWyUCoseSVgQMTLBUpUgntJwNX5f52x0kmuNzkZOla
TAbZqYsL1zyYYdwvIcLgIzL4TsPJE/+LGZ67GzFfEkgGipcO6uZe3Q8/3h4M
y3Ehg8sfbNzwxn7IUDwkfciEDN4bX4seC2eB67qmnEOaZLBRkly4SM8KP1Y1
mU1KkoF+k8+tRCY2aFg/+jabkgxm/gWziVqwwWlFewbvqV4QpXL/1dvEvfyj
OVN3TS+Q80jTIgyzQTMhENeY3As6nr1tb+Jnh9e36d9/9OkFvuQaJytndmie
fcZy8UgvYKHrWviYyQ6p6Y/3CLL0AuvLv7jXZDmgyL7vyvq5PWD59dabOxc4
oEJ2NU3I5R7wZIJZl62IAwLDiu/KOj3gwzEltwNanJCQZbdhSe4GobeOrFTc
4IRPPIdMLNO7gViZWbRBHSfUumZ1pse3G7iL+BU6GnLBX09ytje5ugGdbaj+
93tc8BKhboxtvgu8iYkfvNa5l3OEIN+OLvBruXDjgTU3HD8kTtVxvwvEy6MH
Ak+44SrVb68J/y6g6torljvGDX24V4N87LpAQOeCMXblgc+TLH76S3SBqOuX
P0nd4oOEQmOSr2ongDFxusq1fPA9+VrZDksn2EjNTT20yQfp4g5KwN8dwK/m
o82JG/xwneJNqk1+B5DrWi+2qeSHh06+FZ6O6QDTE5wszmv8UEmqWyLepwPY
75i0+QcIQHKJ1XFN1Q7AxuohfaNcAAaMPO26yd0BOkTDIiKWBKBUtnbA1a12
oKf/XvfxZUH4idHNS6a3Haxb9aVmFAvCoxfH4+5Xt4NSt1+ruQuC8MQoY/7m
63YgHSlRUn1RCM489tPtDW8Hk8lHWJoKhKB3lNFwsn87SMkhXuj+KQRNE/tn
1J3bAXNrvPSUtzBk218pua3VDpYZNlNpPUVgOskOM35uA4UCPGssOSLQ+xD/
v5j2NuCloGbLNyMCg7KrHweWtIEJ0/MsCm6ikK/4L8E3rA1Mt3rry6mIwaK1
9y+cxNsAsFxbKDAXgw9CxXoDmNrA89HIDDU/MRjwzLf16WorsP/xYlP7nRiM
/UHQliK3grLLSvmoSwwa9V2julPfCtg2qomGv8Tg3wCT5MF3raCDcbjCTEEc
Ms+sfnsf3wpkk865958QhwFL7PXfb7eCSMG/HA4+4tDg+gtvu8utQE+R+ZJr
njiMm2a+w27bCkrNDOSvykrARo24ohauVsA63Du6ZiwBx8rbJm5TtwJfF+d7
IZ4SsH/+0Ms3f1uAjP/1mbs5EhDE/WbI7WoBd9ZokxibJeBiRNQiqmoBU7eT
9BNmJKDKgsDDjtct4NnDwowUSUkoMTT372x4C1jj0zUTPioJJwIOrEL/FmD7
sn3zpZsktHct1CtxbgEspTPEty8loZFoqliubgu4oH1lnypJEhanVycaK7WA
tobdivIpSdgdEvMlT6QFRAwIcNaLSkH+9/Z5d6lbwKV1232z+lKwS/xQV8NK
M3ARTthkdZeCbG6u4oHfm4H2eeqZs2+k4BnBeI2InmawtPGznFZNGo7GVi35
pjSDaVGZPGUbaXj7z/vDLTHNgGzomu4QIA2fqDvcSQ1uBgXxg3fzqqRhkibX
pZnTzeBZGUtw/wdpyFu7fivhRDOIHj3ut7ktDVHChC2vdjMI3I5wkxKTgbZa
StuvDjQDd4k6ezMDGSiftWHkwt8MjC6feTbhLgdVa92T7C2bgMaT1Hjae3Kw
Ym2uhdawCUjUDEQo58nB1md6FhaHmsAOzfELYb/l4H//Cd2bEWoC71NUdaUC
D0B5lShCz7dGIIMpJy/ck4e7XFNfxmIbAT1rtvhmniIMZXYmxM80AOWSS5ci
OxWhVO/pM3isAdjZHEH7fytC3h5mC4PeBpD1dNhJTFUJ8n35K+Je0wB0xBhS
jN4rwZsWlx8cSGkAfmp+LA8blGEa/SmeIfsGkDyg7cw/owxpLR9d/GLWAGoC
9hVk0arAjRBgU2bYAOirM00qjqtAMaeS9lq1BvDSYCByvEcFXjkq16jJ1ADm
Djy/lXhRFc5fiBrJbyOB7WAqaYdQVZiV/5rzPokE2Lq8ugQTVOFaoz4pppoE
DvlpCuYUq0LzYSaYVkACkaU9lf8tqcLcbgsl9wQSeEqt6RpCowbT/CdOptwj
gXzbtH363Goweexj1tPbJNC3et6+Q0sN6hscpeD2J4GZYz3b8cfU4NEOM6F8
TxJYT9HIsSGqwUHP/ctaLiTANPfMlM9bDZ484/W6044ERHQolyduqMGffR91
r5uRgJWpp49slDrMpf85xTiFgbythWHnY3Woc18nPmsMAxongoh/jjrMX3F8
zDGAwfsLjP3vm9ThcR5L3QfNGAjcLzxsTH0QTkQdDRnLw2CmfZXeI+wgjA40
0vsRhEHgsXu5WcEacPFDZ32BCAYWFpfCjWM1YAHwfhPCh4GcwynHuVQNePWA
s4gDBwbjngqs6lUaUJexptWCDgMQ1RtIWtOAQxEavymnEOCLr7T02KcJZbiS
fUqGEFh8/FKegVcT0qnMcxZ1IpCdc3XSUksTHh5beeFRiQB9M6/x1DVNmP70
EXE1EYE0gzczwv5acPu/5Lvn5upBbcr5z5xhWlCsJfJt6ad6MDkvM8nwSAsy
Bx5udByqBxJpOSMrpVrQuYJJL5tUD94sZXV0r2pBa226klvP68H77PTiW6GH
oGD0AyZms3rQT5cU8vEBAXp5x741K6kDDJ23uNILtKEbtJhKeFoL/oygo1dq
tSHBK1GJN6EWjM5QXj3WpQ2h11HJ5Kha8Gbnbt/fn9qQv8z66YuAWmCsHh9v
rKADv9+IfqtuVwsiUzPo/+TpwNOJuuv0wrVg5zzaMsjVhc6igmfGX9eAZRrK
r99f6sHo96nXwvqqwXXLOH2/Ej3oNaev29tZDbbSeDOWsB5cuPmAT6mlGtAc
VHbY+aQHV53ki/9WVwPOs47tnCIAVr1Qia9+VQ3U6yre6T0DUPfU9VynS9Wg
UltT54QJhLpMGoGlXNVgZfEHdaa+PgxeqidvnasCEYrCfxKcjkL/S9e6nrJV
gh69XEVPGyP4XTnAXIviP6AosNkYdu0Y7PM+BLUp34PjPTlvwy+bQEuwEJWn
UAF+2F3XjXY/CU0Ev7xPu1YOnr/mkhsIN4Md6QaOufVlgIW8z53mpgU892N8
a1amDBw/67at22sJVa/oeU49LAWmTbbpGx+sIO9pnbQv9KWgKOmKx9tha+hy
usDp7JMSkHZs5XToNxt4nED80CteAr6df3XdcMYW1mKFJYm6YrB8+avP/o92
8IyZ1jnjs8Xgvmtc7PqcPazie2dzmboYhNe49A9/c4CD8dyLNzyKAF8LOVDn
pwN0e8sc1OJWBIrJBoKZCw5QuUTmOKVrEZj8KuPuve4A7763goani4Au28LK
JgMRmvvaHLIxLwLr7rf5xZWIUOEPVbokoQj4sWS6XrhKhLggs1RqfxGg4+eg
JQcRoVt9i78xYxFIl4zM0wghwtCDtHqB+4pAF8FrcTuSCNfyn39goCoC8udU
Ix8+IUKxpd0rO2uF4Ot/OLeiiggVdYMZJWcKQUiDuuleYw/nP9gX+nwuBFzd
2X9CG4iwUS498tVkITCYjj58vJMIae+PRKyMFoJMZqvO8QkiDKHLSHrSXQgI
vI3+4DMRrtbzqY52FIJecU2u7K9EmBxeFSzfVgh2tPidL84TIfWVOnfaxkLw
RP8+Zf8iEf6ol/kWhwuBkul2jtYaET46pPxHor4QNNn7n0jbJELVbeH9TTWF
4H/zX/i/+S/4PzWXFCg=
         "]]},
       Annotation[#, "Charting`Private`Tag$47978#2"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"  real part\"", 
       "\"imaginary part \\n(cut off at 4.0 \[Degree]2\[Theta])\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.25, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"Fourier transform\"", TraditionalForm], None}, {
      FormBox[
      "\"(2\[Theta]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\) \
(\[Degree]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\)\"", TraditionalForm], 
      FormBox["\"Fourier transform of circles function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-100., 100.}, {-0.3895094326381742, 0.99987364354853}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJw12Xc0Fm70AHAlW3Zm9p4h9Jr3ISNSdt6vJCQkSQlRyQqRURokkjRUeIkk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           "]]}, "Charting`Private`Tag$47978#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwt2XkwF87/B3B3rtz3fZOb0Dtkl1DKfb7LkYSQ6EJJQhIShYpEEonk1se9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           "]]}, "Charting`Private`Tag$47978#2"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"Fourier transform", None}, {
        "(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)", 
         "Fourier transform of circles function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{-100., 100.}, {-0.3895094326381742, 0.99987364354853}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.02], 
         Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "  real part", "imaginary part \n(cut off at 4.0 \[Degree]2\[Theta])"},
        LegendMarkers -> None, LabelStyle -> Directive[Bold, 16], 
       LegendLayout -> "Column"]], {0.25, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8209139378683414`*^9, {3.8209139806351423`*^9, 3.820913991448325*^9}, {
   3.8209140342148027`*^9, 3.820914056293874*^9}, {3.82091409326348*^9, 
   3.8209141613280125`*^9}, 3.8209142147821794`*^9, 3.820914266564885*^9, 
   3.820919262933076*^9, 3.8211611993159466`*^9, 3.8211843369972286`*^9, 
   3.8211846730844364`*^9, {3.8211847496334333`*^9, 3.8211847747282534`*^9}, 
   3.8211848146196814`*^9, 3.821184906856371*^9, 3.8211850869706073`*^9, 
   3.821185121424631*^9, 3.821189832333556*^9, {3.8211898884764814`*^9, 
   3.8211899173842363`*^9}, {3.8211900064195433`*^9, 3.821190066593844*^9}, 
   3.8211901128771973`*^9, 3.821190199630719*^9, {3.821190234835477*^9, 
   3.8211902593208213`*^9}, 3.8211907137779036`*^9, 3.8211907528106966`*^9, 
   3.8211907854217124`*^9, 3.8211908520338545`*^9, 3.821190899692251*^9, 
   3.821190936540428*^9, 3.821366937989266*^9, 3.821369135008207*^9, {
   3.8213693208999834`*^9, 3.8213693443110776`*^9}, 3.8213695431138535`*^9, 
   3.82137041213929*^9, 3.8213751902920294`*^9, 3.821375221574173*^9, 
   3.8214207531769867`*^9, 3.821420918450056*^9, 3.8215083705520964`*^9, 
   3.8246473347828293`*^9, 3.8246518234534397`*^9, 3.8246520685747566`*^9, 
   3.824800633004345*^9, 3.824813199535491*^9, 3.8248748576365795`*^9, 
   3.8248756647972507`*^9, 3.824956556307198*^9, 3.8249613990637455`*^9, 
   3.825152352393819*^9, 3.82548898901337*^9, 3.8254891974224687`*^9, 
   3.825489697772189*^9, 3.82694652413519*^9, 3.8269467677247543`*^9, 
   3.8269469727001843`*^9, 3.82694760164262*^9, 3.8269487883515882`*^9, 
   3.826949968073625*^9, 3.8269662449002542`*^9, 3.8278401202875214`*^9, 
   3.828176456980192*^9, 3.8281875243558865`*^9, 3.8286141719943533`*^9, 
   3.8286143672611523`*^9, 3.8286874218718877`*^9, 3.830597253592373*^9, 
   3.831605931393845*^9, 3.831623029687365*^9, 3.8321458848379884`*^9},
 CellLabel->
  "Out[181]=",ExpressionUUID->"220b72a3-4778-40a5-9056-5583241741ea"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwlmHk01f/zxyXJnpQlSkhFpOy715BIJbInWe6975ss2Xch4SL7njVbCUmF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         "]]},
       Annotation[#, "Charting`Private`Tag$59470#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwlmHc41v/3xyXJrpQR5YMWkbK31yGRSmSTjNv9vlOUVXaoRGTvLSKrZCfr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         "]]},
       Annotation[#, "Charting`Private`Tag$59470#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwlmHc41v/3xyXJrpQRJbSIlL29DolUIjuZ932/7xRllaxKJeKDZJcQpezs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         "]]},
       Annotation[#, "Charting`Private`Tag$59470#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"RS length= 2 mm\"", "\"RS length= 4 mm\"", "\"RS length= 8 mm\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.01}], ImageScaled[{0.5, 0}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"extens. of circles function (\[Degree]2\[Theta])\"", 
       TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox[
      "\"aberrations in the axial plane (axial divergence)\"", 
       TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{All, All},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwlmHk01f/zxyXJnpQlSkhFpOy715BIJbInWe6975ss2Xch4SL7njVbCUmF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           "]]}, "Charting`Private`Tag$59470#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwlmHc41v/3xyXJrpQR5YMWkbK31yGRSmSTjNv9vlOUVXaoRGTvLSKrZCfr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           "]]}, "Charting`Private`Tag$59470#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwlmHc41v/3xyXJrpQRJbSIlL29DolUIjuZ932/7xRllaxKJeKDZJcQpezs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           "]]}, "Charting`Private`Tag$59470#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{
        "extens. of circles function (\[Degree]2\[Theta])", None}, {
        "2\[Theta] (\[Degree])", 
         "aberrations in the axial plane (axial divergence)"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
      True, PlotRangePadding -> {{Automatic, Automatic}, {
        Automatic, Automatic}}, Ticks -> {Automatic, Automatic}, TicksStyle -> 
      Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "RS length= 2 mm", "RS length= 4 mm", "RS length= 8 mm"}, 
       LegendMarkers -> None, LabelStyle -> Directive[Bold, 16], LegendLayout -> 
       "Column"]], {0.45, Bottom}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8209139378683414`*^9, {3.8209139806351423`*^9, 3.820913991448325*^9}, {
   3.8209140342148027`*^9, 3.820914056293874*^9}, {3.82091409326348*^9, 
   3.8209141613280125`*^9}, 3.8209142147821794`*^9, 3.820914266564885*^9, 
   3.820919262933076*^9, 3.8211611993159466`*^9, 3.8211843369972286`*^9, 
   3.8211846730844364`*^9, {3.8211847496334333`*^9, 3.8211847747282534`*^9}, 
   3.8211848146196814`*^9, 3.821184906856371*^9, 3.8211850869706073`*^9, 
   3.821185121424631*^9, 3.821189832333556*^9, {3.8211898884764814`*^9, 
   3.8211899173842363`*^9}, {3.8211900064195433`*^9, 3.821190066593844*^9}, 
   3.8211901128771973`*^9, 3.821190199630719*^9, {3.821190234835477*^9, 
   3.8211902593208213`*^9}, 3.8211907137779036`*^9, 3.8211907528106966`*^9, 
   3.8211907854217124`*^9, 3.8211908520338545`*^9, 3.821190899692251*^9, 
   3.821190936540428*^9, 3.821366937989266*^9, 3.821369135008207*^9, {
   3.8213693208999834`*^9, 3.8213693443110776`*^9}, 3.8213695431138535`*^9, 
   3.82137041213929*^9, 3.8213751902920294`*^9, 3.821375221574173*^9, 
   3.8214207531769867`*^9, 3.821420918450056*^9, 3.8215083705520964`*^9, 
   3.8246473347828293`*^9, 3.8246518234534397`*^9, 3.8246520685747566`*^9, 
   3.824800633004345*^9, 3.824813199535491*^9, 3.8248748576365795`*^9, 
   3.8248756647972507`*^9, 3.824956556307198*^9, 3.8249613990637455`*^9, 
   3.825152352393819*^9, 3.82548898901337*^9, 3.8254891974224687`*^9, 
   3.825489697772189*^9, 3.82694652413519*^9, 3.8269467677247543`*^9, 
   3.8269469727001843`*^9, 3.82694760164262*^9, 3.8269487883515882`*^9, 
   3.826949968073625*^9, 3.8269662449002542`*^9, 3.8278401202875214`*^9, 
   3.828176456980192*^9, 3.8281875243558865`*^9, 3.8286141719943533`*^9, 
   3.8286143672611523`*^9, 3.8286874218718877`*^9, 3.830597253592373*^9, 
   3.831605931393845*^9, 3.831623029687365*^9, 3.8321458849629683`*^9},
 CellLabel->
  "Out[182]=",ExpressionUUID->"d1e0af01-6401-4da7-a329-2dc5dc0015c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"oneonx", "[", 
      RowBox[{"x", ",", "0.0", ",", 
       RowBox[{"-", "2."}]}], "]"}], ",", "\[IndentingNewLine]", 
     "           ", 
     RowBox[{"oneonx", "[", 
      RowBox[{"x", ",", "0.0", ",", 
       RowBox[{"-", "4."}]}], "]"}], ",", "\[IndentingNewLine]", 
     "           ", 
     RowBox[{"oneonx", "[", 
      RowBox[{"x", ",", "0.0", ",", 
       RowBox[{"-", "8."}]}], "]"}]}], "}"}], ",", "                      ", 
   "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "0.5"}], ",", "0.05"}], "}"}], ",", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Full", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "20"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", "\"\<normalized intensity\>\"", 
      ",", "\"\<1/x function\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<cut off at 2.0 \[Degree]2\[Theta]\>\"", ",", 
         "\"\<cut off at 4.0 \[Degree]2\[Theta]\>\"", ",", 
         "\"\<cut off at 8.0 \[Degree]2\[Theta]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.45", ",", "Top"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{"Plot", "[", "  ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "@", 
       RowBox[{"ftoneonx", "[", 
        RowBox[{"x", ",", "4."}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
      "            ", 
      RowBox[{"Im", "@", 
       RowBox[{"ftoneonx", "[", 
        RowBox[{"x", ",", "4."}], "]"}]}]}], "\[IndentingNewLine]", 
     "                        ", "}"}], ",", "                      ", 
    "\[IndentingNewLine]", 
    "                                                        ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", 
      RowBox[{"-", "100."}], ",", "100."}], "}"}], ",", "\[IndentingNewLine]",
     "                                                        ", 
    RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"Exclusions", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"GridLinesStyle", "\[Rule]", 
     RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<(2\[Theta]\!\(\*SuperscriptBox[\()\), \(-1\)]\) \
(\[Degree]\!\(\*SuperscriptBox[\()\), \(-1\)]\)\>\"", ",", 
       "\"\<Fourier transform\>\"", ",", 
       "\"\<Fourier transform of 1/x function\>\""}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
    "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"Filling", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"LineLegend", "[", 
        RowBox[{"{", 
         RowBox[{
         "\"\<  real part\>\"", ",", 
          "\"\<imaginary part \\n(cut off at 4.0 \[Degree]2\[Theta])\>\""}], 
         "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.25", ",", "Top"}], "}"}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"TicksStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
    "                                                          ", 
    RowBox[{"AxesStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
    "                                                         ", 
    RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FixedDivergence", "[", 
      RowBox[{"x", ",", "0.5"}], "]"}], ",", 
     RowBox[{"FixedDivergence", "[", 
      RowBox[{"x", ",", "1"}], "]"}], ",", 
     RowBox[{"FixedDivergence", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], " ", "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "1", ",", "179."}], "}"}], ",", 
   "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", 
      "\"\<extens. of 1/X function (\[Degree]2\[Theta])\>\"", ",", 
      "\"\<aberration due to equatorial divergence\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "    ", "\[IndentingNewLine]",
    "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<fixed    (horizontal diverg.of the beam ): 0.5\[Degree]\>\"", 
         ",", "\[IndentingNewLine]", 
         "                                                                    \
                                                      ", 
         "\"\<1.0\[Degree]\>\"", ",", "\[IndentingNewLine]", 
         "                                                                    \
                                                      ", 
         "\"\<2.0\[Degree]\>\""}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.50", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", "  ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"VariableDivergence", "[", 
      RowBox[{"x", ",", "10", ",", "217.5"}], "]"}], ",", 
     RowBox[{"VariableDivergence", "[", 
      RowBox[{"x", ",", "20", ",", "217.5"}], "]"}], ",", 
     RowBox[{"VariableDivergence", "[", 
      RowBox[{"x", ",", "30", ",", "217.5"}], "]"}]}], "}"}], ",", 
   "                      ", "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "1", ",", "179."}], "}"}], ",", 
   "\[IndentingNewLine]", 
   "                                                        ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".1", "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", "Thick", "}"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Frame", "\[Rule]", " ", "True"}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<2\[Theta] (\[Degree])\>\"", ",", 
      "\"\<extens. of 1/X function (\[Degree]2\[Theta])\>\"", ",", 
      "\"\<aberration due to equatorial divergence\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", " ", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", "16"}], "]"}]}], ",", " ", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"Filling", "\[Rule]", "None"}], ",", "    ", "\[IndentingNewLine]",
    "                                                         ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"LineLegend", "[", 
       RowBox[{"{", 
        RowBox[{
        "\"\<variable (constant illumin. sample length): 10 mm\>\"", " ", ",",
          "\[IndentingNewLine]", 
         "                                                                    \
                                                      ", "\"\<20 mm\>\"", ",",
          "\[IndentingNewLine]", 
         "                                                                    \
                                                      ", "\"\<30 mm\>\""}], 
        " ", "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.50", ",", "Bottom"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "15"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                          ", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "                                                         ", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.820917895693761*^9, 3.820917927006914*^9}, {
   3.82091796027392*^9, 3.8209180022124863`*^9}, {3.820918057088501*^9, 
   3.8209181415750875`*^9}, {3.8209181910140924`*^9, 3.8209182606252995`*^9}, 
   3.820918291079112*^9, {3.8209183796596456`*^9, 3.820918393800564*^9}, {
   3.82091842417671*^9, 3.820918631291236*^9}, {3.8209192785424747`*^9, 
   3.8209192886681595`*^9}, {3.8211697946573424`*^9, 
   3.8211697954385605`*^9}, {3.821192697781867*^9, 3.821192788404503*^9}, {
   3.821247128784849*^9, 3.8212471294546638`*^9}, {3.8212487497703695`*^9, 
   3.8212487689741917`*^9}, {3.821866052057792*^9, 3.821866081458047*^9}, {
   3.8218663160830317`*^9, 3.821866461737229*^9}, {3.8218665521340866`*^9, 
   3.8218665522186785`*^9}, {3.8218666031234975`*^9, 3.821866767294077*^9}, 
   3.8248033863957553`*^9, {3.8251523337526464`*^9, 3.8251523380344887`*^9}, 
   3.8254891599843903`*^9, 3.825489670772319*^9, {3.8316234847408433`*^9, 
   3.8316234924285593`*^9}, {3.8316235224517794`*^9, 
   3.8316235410667777`*^9}, {3.831623574023081*^9, 3.831623635352213*^9}, {
   3.831634988227693*^9, 3.8316351064360523`*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"0f7807e0-e927-4a84-bfaf-f519b9b2998f"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwdxwc8Ffr/x/FjHSIRQpGQ6F6kUEbp+62QGSGjhBR1KU5SISQ3MyvJOOhm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         "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBWIQfca91f6WmfB+BjAwcbhQlWeneozZngEKRN+3/+h1
04bzd8vvCjh51gLO57O4/Cdtojucr+7Dp75CzRfOV9iwZMWX2EA43+LI/Uum
n8PgfJNvq4Tv8CXC+Va7LeN0SpLgfIeGEytqbibD+T5cz2xll6TB+alyihlx
ljlwvvdi77gPG4vh/AKmr0miiSVw/pTEeelWAqVw/j35jwUteWUI9XOmNUto
VyLUT324wmFJHZz/7vDuSo/TLXC++bbAIzP29sP5HbqNLzX2z4bzW/5fVpTK
Wgznu2QZyt1oQvBZrvZJTZuN4Leu8hQWOovgt4XuZ+EyWALnd65e9fznVwS/
L7xx7c3GZXC+36F7K6fPQvD5dG2WhW5G8PuZvs+7+ATBn7A2Z8JJ9+Vw/mTm
iOKdvCvg/JC8rfnlagi+yE2hHFN7BH/KurMpGwsQ/GmRzmErLyP4YUcWBKW/
QfDF9P/5qbKuhPOns+x0X2iG4Efki7nE+yP4EreKHWQzEPwbLhdtbjcg+DPW
61nOnIngAwCBW6WY
         "]]},
       Annotation[#, "Charting`Private`Tag$59554#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwdxwc41Y3/xvFjRUlmUlo0NE4qJFqfb0r2aAkJKSqi4xiVeXhSypZssld0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         "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGDQBWIQLSSvn7fNRX4/AxiYOFyoyrNTPcZszwAFou/bf/S6
acP5u+V3BZw8awHn81lc/pM20R3OV/fhU1+h5gvnK2xYsuJLbCCcb3Hk/iXT
z2Fwvsm3VcJ3+BLhfKvdlnE6JUlwvkPDiRU1N5PhfB+uZ7ayS9Lg/FQ5xYw4
yxw433uxd9yHjcVwfgHT1yTRxBI4f0rivHQrgVI4/578x4KWvDKE+jnTmiW0
KxHqpz5c4bCkDs5/d3h3pcfpFjjffFvgkRl7++H8Dt3Glxr7Z8P5Lf8vK0pl
LYbzXbIM5W40IfgsV/ukps1G8FtXeQoLnUXw20L3s3AZLIHzO1evev7zK4Lf
F9649mbjMjjf79C9ldNnIfh8ujbLQjcj+P1M3+ddfILgT1ibM+Gk+3I4fzJz
RPFO3hVwfkje1vxyNQRf5KZQjqk9gj9l3dmUjQUI/rRI57CVlxH8sCMLgtLf
IPhi+v/8VFlXwvnTWXa6LzRD8CPyxVzi/RF8iVvFDrIZCP4Nl4s2txsQ/Bnr
9SxnzkTwAXwHpIU=
         "]]},
       Annotation[#, "Charting`Private`Tag$59554#2"]& ], 
      TagBox[
       {RGBColor[0.560181, 0.691569, 0.194885], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJxF0Xkw1ovbBnDZS6E4qCRKdA5SUZbS/a1U1qxZStbQQTxHKoSQPVuSnZN9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         "]]},
       Annotation[#, "Charting`Private`Tag$59554#3"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"cut off at 2.0 \[Degree]2\[Theta]\"", 
       "\"cut off at 4.0 \[Degree]2\[Theta]\"", 
       "\"cut off at 8.0 \[Degree]2\[Theta]\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.45, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"normalized intensity\"", TraditionalForm], None}, {
      FormBox["\"2\[Theta] (\[Degree])\"", TraditionalForm], 
      FormBox["\"1/x function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-0.5, 0.05}, {-2, 20}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {0, 0}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwdxwc8Ffr/x/FjHSIRQpGQ6F6kUEbp+62QGSGjhBR1KU5SISQ3MyvJOOhm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           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGDQBWIQfca91f6WmfB+BjAwcbhQlWeneozZngEKRN+3/+h1
04bzd8vvCjh51gLO57O4/Cdtojucr+7Dp75CzRfOV9iwZMWX2EA43+LI/Uum
n8PgfJNvq4Tv8CXC+Va7LeN0SpLgfIeGEytqbibD+T5cz2xll6TB+alyihlx
ljlwvvdi77gPG4vh/AKmr0miiSVw/pTEeelWAqVw/j35jwUteWUI9XOmNUto
VyLUT324wmFJHZz/7vDuSo/TLXC++bbAIzP29sP5HbqNLzX2z4bzW/5fVpTK
Wgznu2QZyt1oQvBZrvZJTZuN4Leu8hQWOovgt4XuZ+EyWALnd65e9fznVwS/
L7xx7c3GZXC+36F7K6fPQvD5dG2WhW5G8PuZvs+7+ATBn7A2Z8JJ9+Vw/mTm
iOKdvCvg/JC8rfnlagi+yE2hHFN7BH/KurMpGwsQ/GmRzmErLyP4YUcWBKW/
QfDF9P/5qbKuhPOns+x0X2iG4Efki7nE+yP4EreKHWQzEPwbLhdtbjcg+DPW
61nOnIngAwCBW6WY
           "]]}, "Charting`Private`Tag$59554#1"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwdxwc41Y3/xvFjRUlmUlo0NE4qJFqfb0r2aAkJKSqi4xiVeXhSypZssld0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           "]], 
          Line[CompressedData["
1:eJxTTMoPSmViYGDQBWIQLSSvn7fNRX4/AxiYOFyoyrNTPcZszwAFou/bf/S6
acP5u+V3BZw8awHn81lc/pM20R3OV/fhU1+h5gvnK2xYsuJLbCCcb3Hk/iXT
z2Fwvsm3VcJ3+BLhfKvdlnE6JUlwvkPDiRU1N5PhfB+uZ7ayS9Lg/FQ5xYw4
yxw433uxd9yHjcVwfgHT1yTRxBI4f0rivHQrgVI4/578x4KWvDKE+jnTmiW0
KxHqpz5c4bCkDs5/d3h3pcfpFjjffFvgkRl7++H8Dt3Glxr7Z8P5Lf8vK0pl
LYbzXbIM5W40IfgsV/ukps1G8FtXeQoLnUXw20L3s3AZLIHzO1evev7zK4Lf
F9649mbjMjjf79C9ldNnIfh8ujbLQjcj+P1M3+ddfILgT1ibM+Gk+3I4fzJz
RPFO3hVwfkje1vxyNQRf5KZQjqk9gj9l3dmUjQUI/rRI57CVlxH8sCMLgtLf
IPhi+v/8VFlXwvnTWXa6LzRD8CPyxVzi/RF8iVvFDrIZCP4Nl4s2txsQ/Bnr
9SxnzkTwAXwHpIU=
           "]]}, "Charting`Private`Tag$59554#2"], 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJxF0Xkw1ovbBnDZS6E4qCRKdA5SUZbS/a1U1qxZStbQQTxHKoSQPVuSnZN9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           "]]}, "Charting`Private`Tag$59554#3"]}}, {}}, {
     DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
      AxesOrigin -> {0, 0}, 
      FrameTicks -> {{Automatic, {}}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, DisplayFunction -> Identity, 
      PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {0, 0}}, PlotRangeClipping -> True, ImagePadding -> 
      All, DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      AxesStyle -> Directive[
        GrayLevel[0], 
        Thickness[Large]], DisplayFunction :> Identity, 
      Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{"normalized intensity", None}, {
        "2\[Theta] (\[Degree])", "1/x function"}}, 
      FrameTicks -> {{Automatic, None}, {Automatic, Automatic}}, 
      GridLines -> {Automatic, Automatic}, GridLinesStyle -> Opacity[0.1], 
      ImageSize -> 500, LabelStyle -> Directive[Bold, 16], 
      Method -> {
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}}, PlotRange -> {{-0.5, 0.05}, {-2, 20}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {Automatic, Automatic}}, 
      Ticks -> {Automatic, Automatic}, TicksStyle -> Directive[
        GrayLevel[0], 15]}], 
    Placed[
     Unevaluated[
      LineLegend[{
        Directive[
         Opacity[1.], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6], 
         Thickness[Large]], 
        Directive[
         Opacity[1.], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6], 
         Thickness[Large]]}, {
       "cut off at 2.0 \[Degree]2\[Theta]", 
        "cut off at 4.0 \[Degree]2\[Theta]", 
        "cut off at 8.0 \[Degree]2\[Theta]"}, LegendMarkers -> None, 
       LabelStyle -> Directive[Bold, 16], LegendLayout -> "Column"]], {
     0.45, Top}, Identity]]& ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8209179297256784`*^9, {3.8209179618673105`*^9, 3.820918003102714*^9}, {
   3.8209180964332576`*^9, 3.820918142622279*^9}, {3.8209182100612435`*^9, 
   3.8209182613283553`*^9}, 3.820918395066372*^9, {3.820918431708069*^9, 
   3.8209184750371*^9}, 3.8209185341167283`*^9, {3.8209185705555897`*^9, 
   3.820918632228797*^9}, 3.820919289605663*^9, 3.821161199500856*^9, 
   3.821184337090974*^9, 3.8211846734595547`*^9, 3.8211847578367434`*^9, 
   3.82118512923769*^9, 3.821192793049531*^9, 3.821366941473835*^9, 
   3.8213691384613304`*^9, {3.8213693242822914`*^9, 3.8213693476523914`*^9}, 
   3.8213695463639174`*^9, 3.8213704154990683`*^9, 3.8213751944796233`*^9, 
   3.821375224964898*^9, 3.8214207566486464`*^9, 3.8214209217436266`*^9, 
   3.8215083738799815`*^9, {3.8218660568223934`*^9, 3.821866084231397*^9}, {
   3.8218663844100385`*^9, 3.821866454146433*^9}, {3.821866531258072*^9, 
   3.821866553274665*^9}, 3.8218667370802402`*^9, 3.8218667739214725`*^9, 
   3.8246473382437277`*^9, 3.8246518269070077`*^9, 3.8246520720593233`*^9, 
   3.8248006363480864`*^9, 3.82481320287938*^9, 3.82487486183187*^9, 
   3.8248756684539623`*^9, 3.824956559838502*^9, 3.824961402392067*^9, 
   3.825152355753644*^9, 3.8254889924979916`*^9, 3.825489200938399*^9, 
   3.8254897011628523`*^9, 3.8269465275448327`*^9, 3.826946771084407*^9, 
   3.8269469762002954`*^9, 3.826947605174241*^9, 3.8269487916325626`*^9, 
   3.826949971370451*^9, 3.826966248212796*^9, 3.8278401237451725`*^9, 
   3.8281764606121964`*^9, 3.828187527919977*^9, 3.828614175338348*^9, 
   3.8286143705582504`*^9, 3.828687425309459*^9, 3.830597257097122*^9, 
   3.8316059351437635`*^9, 3.8316230330781846`*^9, {3.831623597507812*^9, 
   3.831623636274006*^9}, 3.8316351082342978`*^9, 3.832145885197334*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"67e7932f-9572-45f0-8535-2599b0921063"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3c8ld8fpySElKaGRCU0rJL1sfe493Kvq40URUJSykj2lpJU3H1t0VTS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         "]]},
       Annotation[#, "Charting`Private`Tag$59641#1"]& ], 
      TagBox[
       {RGBColor[0.880722, 0.611041, 0.142051], Thickness[Large], Opacity[1.],
         LineBox[CompressedData["
1:eJwUV3k81F8bRUj4iaQFUdEmSSWJyr5vM8aMqWghpEiyRiRZsheSoszK2Esb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         "]]},
       Annotation[#, "Charting`Private`Tag$59641#2"]& ]}, {}}, InsetBox[
     TemplateBox[{
      "\"  real part\"", 
       "\"imaginary part \\n(cut off at 4.0 \[Degree]2\[Theta])\""},
      "LineLegend",
      DisplayFunction->(FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6], 
                    Thickness[Large]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive[Bold, 16], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ),
      Editable->True,
      InterpretationFunction:>(RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "Large", "]"}]}], "]"}]}], "}"}],
            ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "16"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
     Scaled[{0.25, 0.99}], ImageScaled[{0.5, 1}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   AxesStyle->Directive[
     GrayLevel[0], 
     Thickness[Large]],
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox["\"Fourier transform\"", TraditionalForm], None}, {
      FormBox[
      "\"(2\[Theta]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\) \
(\[Degree]\\!\\(\\*SuperscriptBox[\\()\\), \\(-1\\)]\\)\"", TraditionalForm], 
      FormBox["\"Fourier transform of 1/x function\"", TraditionalForm]}},
   FrameTicks->{{Automatic, {}}, {Automatic, Automatic}},
   GridLines->{Automatic, Automatic},
   GridLinesStyle->Opacity[0.1],
   ImagePadding->All,
   ImageSize->500,
   LabelStyle->Directive[Bold, 16],
   Method->{
    "DefaultBoundaryStyle" -> Automatic, 
     "DefaultGraphicsInteraction" -> {
      "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
       "Effects" -> {
        "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
         "Droplines" -> {
          "freeformCursorMode" -> True, 
           "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
     "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         (Identity[#]& )[
          Part[#, 1]], 
         (Identity[#]& )[
          Part[#, 2]]}& )}},
   PlotRange->{{-100., 100.}, {-0.5282756769940139, 0.9996209572577901}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic},
   TicksStyle->Directive[
     GrayLevel[0], 15]],
  InterpretTemplate[Legended[
    Graphics[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[1.6], 
           Thickness[Large]], 
          Line[CompressedData["
1:eJwUV3c8ld8fpySElKaGRCU0rJL1sfe493Kvq40URUJSykj2lpJU3H1t0VTS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